/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.StringUtils;

public class FontWriter
extends FontFile2 {
    private static final long serialVersionUID = -5399219427547126730L;
    String name;
    int glyphCount;
    int headCheckSumPos = -1;
    Map IDtoTable = new HashMap();
    private static boolean compressWoff = true;
    ArrayList<TTFDirectory> ttfList = new ArrayList();
    static final String[] TTFTableOrder;
    private HashMap<Integer, byte[]> tableStore = new HashMap();
    boolean debug = false;

    public FontWriter(byte[] data) {
        super(data);
    }

    public FontWriter() {
    }

    static int getUintFromByteArray(byte[] d, int startPoint, int offsetSize) {
        int result = 0;
        int offset = 0;
        for (int shift = (offsetSize - 1) * 8; shift >= 0; shift -= 8) {
            int part = d[startPoint + offset];
            if (part < 0) {
                part += 256;
            }
            result |= part << shift;
            ++offset;
        }
        return result;
    }

    static int getUintFromIntArray(int[] d, int startPoint, int offsetSize) {
        int result = 0;
        int offset = 0;
        for (int shift = (offsetSize - 1) * 8; shift >= 0; shift -= 8) {
            result |= (d[startPoint + offset] & 0xFF) << shift;
            ++offset;
        }
        return result;
    }

    static byte[] set1cNumber(int num) {
        byte[] result = num >= -107 && num <= 107 ? new byte[]{(byte)(num + 139)} : (num >= 108 && num <= 1131 ? new byte[]{(byte)(247 + (num -= 108) / 256), (byte)(num & 0xFF)} : (num >= -1131 && num <= -108 ? new byte[]{(byte)(251 + (num += 108) / -256), (byte)(-num & 0xFF)} : (num >= Short.MIN_VALUE && num <= Short.MAX_VALUE ? new byte[]{28, (byte)(num / 256 & 0xFF), (byte)(num & 0xFF)} : new byte[]{29, (byte)(num / 256 / 256 / 256 & 0xFF), (byte)(num / 256 / 256 & 0xFF), (byte)(num / 256 & 0xFF), (byte)(num & 0xFF)})));
        return result;
    }

    static byte[] set1cRealNumber(double num) {
        int len;
        String n = Double.toString(num);
        int maxLength = 10;
        if (n.length() > 10) {
            if (n.contains("E")) {
                String[] parts = n.split("E");
                n = n.substring(0, 10 - (parts[1].length() + 1)) + "E" + parts[1];
            } else {
                n = n.substring(0, 10);
            }
        }
        if ((len = (n = n + "f").length()) % 2 == 1) {
            ++len;
        }
        byte[] result = new byte[1 + (len /= 2)];
        result[0] = 30;
        for (int i = 0; i < len; ++i) {
            int charLoc = i * 2;
            char a = n.charAt(charLoc);
            char b = charLoc + 1 < n.length() ? n.charAt(charLoc + 1) : a;
            byte aByte = FontWriter.getNibble(a);
            byte bByte = FontWriter.getNibble(b);
            result[i + 1] = (byte)((aByte & 0xF) << 4 | bByte & 0xF);
        }
        return result;
    }

    private static byte getNibble(char c) {
        switch (c) {
            case '.': {
                return 10;
            }
            case 'E': {
                return 11;
            }
            case '-': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return (byte)Integer.parseInt("" + c);
    }

    static byte[] setCharstringType2Number(int num) {
        byte[] result;
        if (num >= -107 && num <= 107) {
            result = new byte[]{(byte)(num + 139)};
        } else if (num >= 108 && num <= 1131) {
            result = new byte[]{(byte)(247 + (num -= 108) / 256), (byte)(num & 0xFF)};
        } else if (num >= -1131 && num <= -108) {
            result = new byte[]{(byte)(251 + (num += 108) / -256), (byte)(-num & 0xFF)};
        } else if (num >= 0) {
            result = new byte[]{-1, (byte)(num / 256 & 0xFF), (byte)(num & 0xFF), 0, 0};
        } else {
            int add = num + 32768;
            result = new byte[]{-1, (byte)(0x80 | add / 256 & 0x7F), (byte)(add & 0xFF), 0, 0};
        }
        return result;
    }

    public static byte[] setUintAsBytes(int num, int byteCount) {
        byte[] result = new byte[byteCount];
        for (int i = byteCount; i > 0; --i) {
            int part = num;
            for (int j = 1; j < i; ++j) {
                part >>= 8;
            }
            result[byteCount - i] = (byte)part;
        }
        return result;
    }

    static int createChecksum(byte[] table) {
        int checksumValue = 0;
        FontFile2 checksum = new FontFile2(table, true);
        int longCount = table.length + 3 >> 2;
        for (int j = 0; j < longCount; ++j) {
            checksumValue += checksum.getNextUint32();
        }
        return checksumValue;
    }

    public static final byte[] setUFWord(int rawValue) {
        short value = (short)rawValue;
        byte[] returnValue = new byte[2];
        for (int i = 0; i < 2; ++i) {
            returnValue[i] = (byte)(value >> 8 * (1 - i) & 0xFF);
        }
        return returnValue;
    }

    public static final byte[] setFWord(int rawValue) {
        short value = (short)rawValue;
        byte[] returnValue = new byte[2];
        for (int i = 0; i < 2; ++i) {
            returnValue[i] = (byte)(value >> 8 * (1 - i) & 0xFF);
        }
        return returnValue;
    }

    public static final byte[] setNextUint16(int value) {
        byte[] returnValue = new byte[2];
        for (int i = 0; i < 2; ++i) {
            returnValue[i] = (byte)(value >> 8 * (1 - i) & 0xFF);
        }
        return returnValue;
    }

    public static final byte[] setNextInt16(int value) {
        byte[] returnValue = new byte[2];
        for (int i = 0; i < 2; ++i) {
            returnValue[i] = (byte)(value >> 8 * (1 - i) & 0xFF);
        }
        return returnValue;
    }

    public static final byte[] setNextSignedInt16(short value) {
        byte[] returnValue = new byte[2];
        for (int i = 0; i < 2; ++i) {
            returnValue[i] = (byte)(value >> 8 * (1 - i) & 0xFF);
        }
        return returnValue;
    }

    public static final byte setNextUint8(int value) {
        return (byte)(value & 0xFF);
    }

    public static final byte[] setNextUint32(int value) {
        byte[] returnValue = new byte[4];
        for (int i = 0; i < 4; ++i) {
            returnValue[i] = (byte)(value >> 8 * (3 - i) & 0xFF);
        }
        return returnValue;
    }

    public static final byte[] setNextUint64(int value) {
        byte[] returnValue = new byte[8];
        for (int i = 0; i < 8; ++i) {
            returnValue[i] = (byte)(value >> 8 * (7 - i) & 0xFF);
        }
        return returnValue;
    }

    public static final byte[] setNextUint64(long value) {
        byte[] returnValue = new byte[8];
        for (int i = 0; i < 8; ++i) {
            returnValue[i] = (byte)(value >> 8 * (7 - i) & 0xFFL);
        }
        return returnValue;
    }

    public final byte[] writeFontToStream() throws IOException {
        this.readTables();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.type == 1) {
            if (this.subType == 10) {
                bos.write(FontWriter.setNextUint32(0x4F54544F));
            } else {
                bos.write(FontWriter.setNextUint32(65536));
            }
        } else if (this.type == 3) {
            bos.write(FontWriter.setNextUint32(1953784678));
        } else {
            bos.write(FontWriter.setNextUint32(65536));
        }
        if (this.type == 3) {
            System.out.println("TTC write not implemented");
        } else {
            this.writeTablesForFont(bos);
        }
        bos.flush();
        bos.close();
        byte[] fileInBytes = bos.toByteArray();
        byte[] headCheckSum = FontWriter.setNextUint32((int)(Long.parseLong("B1B0AFBA", 16) - (long)FontWriter.createChecksum(fileInBytes)));
        System.arraycopy(headCheckSum, 0, fileInBytes, 0 + this.headCheckSumPos, 4);
        return fileInBytes;
    }

    void readTables() {
    }

    private void writeTablesForFont(ByteArrayOutputStream bos) throws IOException {
        int l;
        int j;
        int id;
        String tag;
        int[] keys = new int[this.numTables];
        int[] offset = new int[this.numTables];
        int[] checksum = new int[this.numTables];
        int[] tableSize = new int[this.numTables];
        bos.write(FontWriter.setNextUint16(this.numTables));
        bos.write(FontWriter.setNextUint16(this.searchRange));
        bos.write(FontWriter.setNextUint16(this.entrySelector));
        bos.write(FontWriter.setNextUint16(this.rangeShift));
        for (int l2 = 0; l2 < this.numTables; ++l2) {
            tag = (String)this.tableList.get(l2);
            id = FontWriter.getTableID(tag);
            if (this.debug) {
                System.out.println("writing out " + tag + " id=" + id);
            }
            if (id == -1) continue;
            byte[] tableBytes = this.getTableBytes(id);
            this.tableStore.put(id, tableBytes);
            if (id != 0) {
                checksum[l2] = FontWriter.createChecksum(tableBytes);
            }
            tableSize[l2] = tableBytes.length;
            keys[l2] = l2;
            offset[l2] = this.tables[id][this.currentFontID];
        }
        if (this.subType == 10) {
            keys = Sorts.quicksort(offset, keys);
        }
        int currentOffset = FontWriter.alignOnWordBoundary(bos.size() + 16 * this.numTables);
        int[] fileOffset = new int[this.numTables];
        for (int l3 = 0; l3 < this.numTables; ++l3) {
            int i = keys[l3];
            fileOffset[i] = currentOffset;
            offset[i] = currentOffset;
            currentOffset = FontWriter.alignOnWordBoundary(currentOffset + tableSize[i]);
        }
        if (this.subType == 11) {
            for (j = 0; j < this.numTables; ++j) {
                tag = TTFTableOrder[j];
                bos.write(StringUtils.toBytes(tag));
                id = FontWriter.getTableID(tag);
                l = (Integer)this.IDtoTable.get(tag);
                if (id == -1) continue;
                if (id == 0) {
                    this.headCheckSumPos = bos.size();
                }
                bos.write(FontWriter.setNextUint32(checksum[l]));
                bos.write(FontWriter.setNextUint32(fileOffset[l]));
                bos.write(FontWriter.setNextUint32(tableSize[l]));
                this.ttfList.add(new TTFDirectory(tag, fileOffset[l], checksum[l], tableSize[l]));
            }
        } else {
            for (j = 0; j < this.numTables; ++j) {
                l = j;
                tag = (String)this.tableList.get(l);
                bos.write(StringUtils.toBytes(tag));
                id = FontWriter.getTableID(tag);
                if (id == -1) continue;
                if (id == 0) {
                    this.headCheckSumPos = bos.size();
                }
                bos.write(FontWriter.setNextUint32(checksum[l]));
                bos.write(FontWriter.setNextUint32(fileOffset[l]));
                bos.write(FontWriter.setNextUint32(tableSize[l]));
                this.ttfList.add(new TTFDirectory(tag, fileOffset[l], checksum[l], tableSize[l]));
            }
        }
        for (int l4 = 0; l4 < this.numTables; ++l4) {
            int sortedKey = keys[l4];
            tag = (String)this.tableList.get(sortedKey);
            id = FontWriter.getTableID(tag);
            byte[] bytes = this.tableStore.get(id);
            while ((bos.size() & 3) != 0) {
                bos.write(0);
            }
            bos.write(bytes);
        }
    }

    private static int alignOnWordBoundary(int currentOffset) {
        int packing = currentOffset & 3;
        if (packing != 0) {
            currentOffset += 4 - packing;
        }
        return currentOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] writeFontToWoffStream() throws IOException {
        byte[] originalSfntData = this.writeFontToStream();
        for (TTFDirectory t : this.ttfList) {
            if (!t.getTag().equals("head")) continue;
            int headChecksum = this.AdjustWoffChecksum(originalSfntData, t.getOffset(), t.getLength());
            t.setChecksum(headChecksum);
        }
        int ttfSuffix = 12 + 16 * this.numTables;
        int woffSuffix = 44 + 20 * this.numTables;
        int onlySfntLen = originalSfntData.length - ttfSuffix;
        byte[] onlySfntData = new byte[onlySfntLen];
        System.arraycopy(originalSfntData, ttfSuffix, onlySfntData, 0, originalSfntData.length - ttfSuffix);
        ByteArrayOutputStream dbos = new ByteArrayOutputStream(4);
        int endPos = 0;
        for (TTFDirectory d : this.ttfList) {
            int padding;
            byte[] b = new byte[d.getLength()];
            System.arraycopy(originalSfntData, d.getOffset(), b, 0, d.getLength());
            d.setOffset(endPos + woffSuffix);
            int compLength = d.getLength();
            if (compressWoff) {
                byte[] output = new byte[d.getLength()];
                Deflater compresser = null;
                try {
                    compresser = new Deflater(9);
                    compresser.setInput(b);
                    compresser.finish();
                    compLength = compresser.deflate(output);
                    if (compLength < d.getLength() && compresser.finished()) {
                        dbos.write(output, 0, compLength);
                    }
                    dbos.write(b);
                    compLength = d.getLength();
                }
                finally {
                    if (compresser != null) {
                        compresser.end();
                        compresser = null;
                    }
                }
            } else {
                dbos.write(b);
            }
            d.setCompressLength(compLength);
            int n = padding = compLength % 4 > 0 ? 4 - compLength % 4 : 0;
            if (padding > 0) {
                byte[] n2 = new byte[padding];
                dbos.write(n2);
            }
            endPos = endPos + d.getCompressLength() + padding;
        }
        ByteArrayOutputStream wbos = new ByteArrayOutputStream();
        wbos.write(FontWriter.setNextUint32(2001684038));
        if (this.type == 1) {
            if (this.subType == 10) {
                wbos.write(FontWriter.setNextUint32(0x4F54544F));
            } else {
                wbos.write(FontWriter.setNextUint32(65536));
            }
        } else if (this.type == 3) {
            wbos.write(FontWriter.setNextUint32(1953784678));
        } else {
            wbos.write(FontWriter.setNextUint32(65536));
        }
        wbos.write(FontWriter.setNextUint32(woffSuffix + endPos));
        wbos.write(FontWriter.setNextUint16(this.numTables));
        wbos.write(FontWriter.setNextUint16(0));
        int endPadding = originalSfntData.length % 4 > 0 ? 4 - originalSfntData.length % 4 : 0;
        wbos.write(FontWriter.setNextUint32(endPadding > 0 ? originalSfntData.length + endPadding : originalSfntData.length));
        wbos.write(FontWriter.setNextUint16(1));
        wbos.write(FontWriter.setNextUint16(1));
        wbos.write(FontWriter.setNextUint32(0));
        wbos.write(FontWriter.setNextUint32(0));
        wbos.write(FontWriter.setNextUint32(0));
        wbos.write(FontWriter.setNextUint32(0));
        wbos.write(FontWriter.setNextUint32(0));
        for (TTFDirectory t : this.ttfList) {
            wbos.write(t.getTagBytes());
            wbos.write(FontWriter.setNextUint32(t.getOffset()));
            wbos.write(FontWriter.setNextUint32(t.getCompressLength()));
            wbos.write(FontWriter.setNextUint32(t.getLength()));
            wbos.write(FontWriter.setNextUint32(t.getChecksum()));
        }
        wbos.write(dbos.toByteArray());
        wbos.flush();
        wbos.close();
        return wbos.toByteArray();
    }

    private int AdjustWoffChecksum(byte[] tableBytes, int headOffset, int headLength) {
        if (tableBytes.length > headOffset && headLength >= 4) {
            ByteBuffer data = ByteBuffer.wrap(tableBytes);
            byte[] a = new byte[4];
            for (int z = 0; z < 4; ++z) {
                a[z] = 0;
            }
            System.arraycopy(a, 0, tableBytes, headOffset + 8, 4);
            int totalChecksum = -1313820742 - FontWriter.createChecksum(a);
            byte[] b = new byte[headLength];
            System.arraycopy(data.array(), headOffset, b, 0, headLength);
            int headChecksum = FontWriter.createChecksum(b);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(totalChecksum);
            byte[] c = bb.array();
            System.arraycopy(c, 0, tableBytes, headOffset + 8, 4);
            return headChecksum;
        }
        return 0;
    }

    static {
        if (System.getProperty("org.jpedal.pdf2html.compressWoff") != null && System.getProperty("org.jpedal.pdf2html.compressWoff").toLowerCase().equals("false")) {
            compressWoff = false;
        }
        TTFTableOrder = new String[]{"OS/2", "cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name", "post", "prep"};
    }

    private class TTFDirectory {
        private int offset2;
        private int checksum2;
        private int length2;
        private int compressLength;
        private String tag2;

        public TTFDirectory(String tag, int offset, int checksum, int length) {
            this.tag2 = tag;
            this.offset2 = offset;
            this.checksum2 = checksum;
            this.length2 = length;
        }

        public String getTag() {
            return this.tag2;
        }

        public byte[] getTagBytes() {
            byte[] b = new byte[4];
            for (int z = 0; z < 4; ++z) {
                b[z] = (byte)this.getTag().charAt(z);
            }
            return b;
        }

        public int getOffset() {
            return this.offset2;
        }

        public int getChecksum() {
            return this.checksum2;
        }

        public int getLength() {
            return this.length2;
        }

        public int getCompressLength() {
            return this.compressLength;
        }

        public void setOffset(int offset) {
            this.offset2 = offset;
        }

        public void setChecksum(int checksum) {
            this.checksum2 = checksum;
        }

        public void setLength(int length) {
            this.length2 = length;
        }

        public void setTag(String tag) {
            this.tag2 = tag;
        }

        public void setCompressLength(int compressLength) {
            this.compressLength = compressLength;
        }
    }
}

