/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;

public class HheaWriter
extends Hhea
implements FontTableWriter {
    private static final long serialVersionUID = -7014279475817569381L;
    private int glyphCount;
    private double xMaxExtent;
    private double minRightSideBearing;
    private double minLeftSideBearing;
    private double advanceWidthMax;
    private double lowestDescender;
    private double highestAscender;

    public HheaWriter(PdfJavaGlyphs glyphs, double xMaxExtent, double minRightSideBearing, double minLeftSideBearing, double advanceWidthMax, double lowestDescender, double highestAscender) {
        this.glyphCount = glyphs.getGlyphCount();
        this.xMaxExtent = xMaxExtent;
        this.minRightSideBearing = minRightSideBearing;
        this.minLeftSideBearing = minLeftSideBearing;
        this.advanceWidthMax = advanceWidthMax;
        this.lowestDescender = lowestDescender;
        this.highestAscender = highestAscender;
    }

    @Override
    public byte[] writeTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(FontWriter.setNextUint32(65536));
        bos.write(FontWriter.setFWord((int)this.highestAscender));
        bos.write(FontWriter.setFWord((int)this.lowestDescender));
        bos.write(FontWriter.setFWord(0));
        bos.write(FontWriter.setUFWord((int)this.advanceWidthMax));
        bos.write(FontWriter.setFWord((int)this.minLeftSideBearing));
        bos.write(FontWriter.setFWord((int)this.minRightSideBearing));
        bos.write(FontWriter.setFWord((int)this.xMaxExtent));
        bos.write(FontWriter.setNextInt16(1));
        bos.write(FontWriter.setNextInt16(0));
        bos.write(FontWriter.setFWord(0));
        for (int i = 0; i < 4; ++i) {
            bos.write(FontWriter.setNextUint16(0));
        }
        bos.write(FontWriter.setNextInt16(0));
        bos.write(FontWriter.setNextUint16(this.glyphCount));
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public int getIntValue(int key) {
        return 0;
    }
}

