/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.outlines;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.io.ArrayDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutlineData {
    private Document OutlineDataXML;
    private Map DestObjs = new HashMap();

    public OutlineData(int pageCount) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.OutlineDataXML = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Exception " + e + " generating XML document");
        }
    }

    public Document getList() {
        return this.OutlineDataXML;
    }

    public int readOutlineFileMetadata(PdfObject OutlinesObj, PdfObjectReader currentPdfFile) {
        int count = OutlinesObj.getInt(1061502502);
        PdfObject FirstObj = OutlinesObj.getDictionary(960643930);
        currentPdfFile.checkResolved(FirstObj);
        if (FirstObj != null) {
            Element root = this.OutlineDataXML.createElement("root");
            this.OutlineDataXML.appendChild(root);
            int level = 0;
            this.readOutlineLevel(root, currentPdfFile, FirstObj, level, false);
        }
        return count;
    }

    private void readOutlineLevel(Element root, PdfObjectReader currentPdfFile, PdfObject outlineObj, int level, boolean isClosed) {
        Element child = this.OutlineDataXML.createElement("title");
        PdfObject FirstObj = null;
        while (true) {
            byte[] titleData;
            int count;
            if (FirstObj != null) {
                outlineObj = FirstObj;
            }
            String ID = outlineObj.getObjectRefAsString();
            int page = -1;
            FirstObj = outlineObj.getDictionary(960643930);
            currentPdfFile.checkResolved(FirstObj);
            PdfObject NextObj = outlineObj.getDictionary(506808388);
            currentPdfFile.checkResolved(NextObj);
            int numberOfItems = outlineObj.getInt(1061502502);
            if (numberOfItems != 0) {
                isClosed = numberOfItems < 0;
            }
            PdfArrayIterator DestObj = outlineObj.getMixedArray(339034948);
            PdfObject Aobj = outlineObj;
            if ((DestObj == null || DestObj.getTokenCount() == 0) && (Aobj = outlineObj.getDictionary(17)) != null) {
                DestObj = Aobj.getMixedArray(339034948);
            }
            String ref = null;
            if (DestObj != null && DestObj.getTokenCount() > 0 && (count = DestObj.getTokenCount()) > 0) {
                if (DestObj.isNextValueRef()) {
                    ref = DestObj.getNextValueAsString(true);
                } else {
                    String nameString = DestObj.getNextValueAsString(true);
                    if (nameString != null) {
                        ref = currentPdfFile.convertNameToRef(nameString);
                        if (ref != null && ref.startsWith("[")) {
                            byte[] raw = StringUtils.toBytes(ref);
                            ArrayDecoder objDecoder = new ArrayDecoder(currentPdfFile.getObjectReader(), 0, raw.length, 18, null, 826094945);
                            objDecoder.readArray(false, raw, Aobj, 339034948);
                            DestObj = Aobj.getMixedArray(339034948);
                        } else if (ref != null) {
                            Aobj = new OutlineObject(ref);
                            currentPdfFile.readObject(Aobj);
                            DestObj = Aobj.getMixedArray(339034948);
                        }
                        if (DestObj != null && (count = DestObj.getTokenCount()) > 0 && DestObj.hasMoreTokens() && DestObj.isNextValueRef()) {
                            ref = DestObj.getNextValueAsString(true);
                        }
                    }
                }
            }
            if (ref != null) {
                page = currentPdfFile.convertObjectToPageNumber(ref);
            }
            if ((titleData = outlineObj.getTextStreamValueAsByte(960773209)) != null) {
                String title = StringUtils.getTextString(titleData, false);
                child = this.OutlineDataXML.createElement("title");
                root.appendChild(child);
                child.setAttribute("title", title);
            }
            child.setAttribute("isClosed", String.valueOf(isClosed));
            if (Aobj != null) {
                this.DestObjs.put(ID, Aobj);
            }
            if (page != -1) {
                child.setAttribute("page", String.valueOf(page));
            }
            child.setAttribute("level", String.valueOf(level));
            child.setAttribute("objectRef", ID);
            if (FirstObj != null) {
                this.readOutlineLevel(child, currentPdfFile, FirstObj, level + 1, isClosed);
            }
            if (NextObj == null) break;
            FirstObj = NextObj;
        }
    }

    public PdfObject getAobj(String ref) {
        return (PdfObject)this.DestObjs.get(ref);
    }
}

