/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.parser.Cmd;

public class CommandParser {
    private byte[] characterStream;
    private int commandID = -1;
    private static final int[] prefixes = new int[]{60, 40};
    private static final int[] suffixes = new int[]{62, 41};
    private static final int[][] intValues = new int[][]{{0, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000}, {0, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000}, {0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000}, {0, 100, 200, 300, 400, 500, 600, 700, 800, 900}, {0, 10, 20, 30, 40, 50, 60, 70, 80, 90}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};
    private static final int MAXOPS = 50;
    private int[] opStart = new int[50];
    private int[] opEnd = new int[50];
    private int operandCount;
    private int currentOp = 0;

    public CommandParser(byte[] characterStr) {
        this.characterStream = characterStr;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    int getCommandValues(int dataPointer, int streamSize, int tokenNumber) {
        int nextChar;
        block34: {
            byte next;
            int start;
            int end;
            block35: {
                byte firstChar;
                boolean matchFound;
                int current;
                int sLen;
                int count;
                block38: {
                    boolean isBreak;
                    int type;
                    block39: {
                        int start2;
                        block37: {
                            block36: {
                                boolean debug = false;
                                count = prefixes.length;
                                nextChar = this.characterStream[dataPointer];
                                end = 0;
                                this.commandID = -1;
                                sLen = this.characterStream.length;
                                current = nextChar;
                                if (nextChar == 13 || nextChar == 10 || nextChar == 32 || nextChar == 9) {
                                    ++dataPointer;
                                    while (dataPointer != streamSize && ((current = this.characterStream[dataPointer]) == 13 || current == 10 || current == 32 || current == 9)) {
                                        ++dataPointer;
                                    }
                                }
                                while (current == 37) {
                                    ++dataPointer;
                                    while (dataPointer != streamSize) {
                                        current = this.characterStream[dataPointer];
                                        if (current == 13 || current == 10) {
                                            while (dataPointer + 1 < streamSize && this.characterStream[dataPointer + 1] == 10) {
                                                current = this.characterStream[++dataPointer];
                                            }
                                            break;
                                        }
                                        ++dataPointer;
                                    }
                                    if (++dataPointer >= streamSize) break;
                                    current = this.characterStream[dataPointer];
                                }
                                if (dataPointer == streamSize) {
                                    return dataPointer;
                                }
                                matchFound = false;
                                type = this.getType(current, dataPointer);
                                if (type != 3) break block36;
                                start2 = dataPointer;
                                break block37;
                            }
                            if (type == 4) break block34;
                            start = dataPointer;
                            if (type != 1 && type != 2) break block38;
                            break block39;
                        }
                        while (++dataPointer < sLen && (current = this.characterStream[dataPointer]) != 13 && current != 10 && current != 32 && current != 40 && current != 47 && current != 91 && current != 9 && current != 60) {
                        }
                        end = dataPointer - 1;
                        if (end >= sLen) {
                            return end;
                        }
                        byte endC = this.characterStream[end];
                        if (endC == 47 || endC == 91 || endC == 60) {
                            --end;
                        }
                        this.commandID = -1;
                        if (end - start2 < 3) {
                            int key = 0;
                            int x = 0;
                            for (int i2 = end; i2 > start2 - 1; key += this.characterStream[i2] << x, x += 8, --i2) {
                            }
                            this.commandID = Cmd.getCommandID(key);
                        }
                        if (this.commandID == -1) {
                            this.opStart[this.currentOp] = start2;
                            this.opEnd[this.currentOp] = end;
                            ++this.currentOp;
                            if (this.currentOp == 50) {
                                this.currentOp = 0;
                            }
                            ++this.operandCount;
                            break block34;
                        } else {
                            if (this.operandCount > 0) {
                                int jj;
                                int[] orderedOpStart = new int[50];
                                int[] orderedOpEnd = new int[50];
                                int opid = 0;
                                for (jj = this.currentOp - 1; jj > -1; ++opid, --jj) {
                                    orderedOpStart[opid] = this.opStart[jj];
                                    orderedOpEnd[opid] = this.opEnd[jj];
                                    if (opid != this.operandCount) continue;
                                    jj = -1;
                                }
                                if (opid == this.operandCount) {
                                    --this.currentOp;
                                    for (jj = 49; jj > this.currentOp; ++opid, --jj) {
                                        orderedOpStart[opid] = this.opStart[jj];
                                        orderedOpEnd[opid] = this.opEnd[jj];
                                        if (opid != this.operandCount) continue;
                                        jj = this.currentOp;
                                    }
                                    ++this.currentOp;
                                }
                                this.opStart = orderedOpStart;
                                this.opEnd = orderedOpEnd;
                            }
                            return -dataPointer;
                        }
                    }
                    boolean inStream = false;
                    matchFound = true;
                    int last = 32;
                    do {
                        last = last == 92 && current == 92 ? 120 : current;
                        if (++dataPointer == sLen) break;
                        current = this.characterStream[dataPointer];
                        if (current == 13 || current == 10 || current == 9) {
                            current = 32;
                        }
                        isBreak = false;
                        if (current == 62 && last == 62 && type == 1) {
                            isBreak = true;
                        }
                        if (type != 2) continue;
                        if (current == 40 && last != 92) {
                            inStream = true;
                        } else if (current == 41 && last != 92) {
                            inStream = false;
                        }
                        if (inStream || current != 93 || last == 92) continue;
                        isBreak = true;
                    } while (!isBreak);
                    end = dataPointer;
                }
                boolean bl = true;
                while (true) {
                    int startChars;
                    block43: {
                        int last;
                        block44: {
                            block41: {
                                block42: {
                                    block40: {
                                        if (!bl || (bl = false)) break block40;
                                        if (matchFound) break block41;
                                        last = 32;
                                        startChars = 0;
                                    }
                                    if (startChars >= count) break block42;
                                    if (current != prefixes[startChars]) break block43;
                                    break block44;
                                }
                                end = dataPointer;
                            }
                            if (!matchFound) {
                                start = dataPointer;
                                firstChar = this.characterStream[start];
                                break;
                            }
                            break block35;
                        }
                        matchFound = true;
                        start = dataPointer;
                        int numOfPrefixs = 0;
                        while (true) {
                            last = last == 92 && current == 92 ? 120 : current;
                            if (++dataPointer == sLen) break;
                            current = this.characterStream[dataPointer];
                            if (current == 13 || current == 10 || current == 9) {
                                current = 32;
                            }
                            if (current == prefixes[startChars] && last != 92) {
                                ++numOfPrefixs;
                            }
                            if (current != suffixes[startChars] || last == 92) continue;
                            if (numOfPrefixs == 0) break;
                            --numOfPrefixs;
                        }
                        startChars = count;
                    }
                    ++startChars;
                }
                while (++dataPointer != sLen && (current = this.characterStream[dataPointer]) != 13 && current != 10 && current != 32 && current != 40 && current != 47 && current != 91 && current != 9 && (firstChar != 47 || current != 60)) {
                }
                end = dataPointer;
            }
            if (end >= this.characterStream.length || (next = this.characterStream[end]) == 47 || next == 91) {
                // empty if block
            }
            this.opStart[this.currentOp] = start;
            this.opEnd[this.currentOp] = --end;
            ++this.currentOp;
            if (this.currentOp == 50) {
                this.currentOp = 0;
            }
            ++this.operandCount;
        }
        if (dataPointer < streamSize && (nextChar = this.characterStream[dataPointer]) != 47 && nextChar != 40 && nextChar != 91 && nextChar != 60) {
            ++dataPointer;
        }
        return dataPointer;
    }

    public int getCommandID() {
        return this.commandID;
    }

    private int getType(int current, int dataPointer) {
        int type = 0;
        if (current == 60 && this.characterStream[dataPointer + 1] == 60) {
            type = 1;
        } else if (current == 32) {
            type = 4;
        } else if (current == 91) {
            type = 2;
        } else if (current >= 97 && current <= 122) {
            type = 3;
        } else if (current >= 65 && current <= 90) {
            type = 3;
        } else if (current == 39 || current == 34) {
            type = 3;
        }
        return type;
    }

    String generateOpAsString(int p, boolean loseSlashPrefix) {
        byte[] dataStream = this.characterStream;
        int start = this.opStart[p];
        if (loseSlashPrefix && dataStream[start] == 47) {
            ++start;
        }
        int end = this.opEnd[p];
        while (dataStream[end] == 32 || dataStream[end] == 13 || dataStream[end] == 10) {
            --end;
        }
        int count = end - start + 1;
        int spaces = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii <= 0 || dataStream[start + ii] != 32 && dataStream[start + ii] != 13 && dataStream[start + ii] != 10 || dataStream[start + ii - 1] != 32 && dataStream[start + ii - 1] != 13 && dataStream[start + ii - 1] != 10) continue;
            ++spaces;
        }
        char[] charString = new char[count - spaces];
        int pos = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii > 0 && (dataStream[start + ii] == 32 || dataStream[start + ii] == 13 || dataStream[start + ii] == 10) && (dataStream[start + ii - 1] == 32 || dataStream[start + ii - 1] == 13 || dataStream[start + ii - 1] == 10)) continue;
            charString[pos] = dataStream[start + ii] == 10 || dataStream[start + ii] == 13 ? 32 : (char)dataStream[start + ii];
            ++pos;
        }
        String s = String.copyValueOf(charString);
        return s;
    }

    final float parseFloat(int id) {
        float f;
        int charCount;
        byte[] stream = this.characterStream;
        int start = this.opStart[id];
        int floatptr = charCount = this.opEnd[id] - start;
        int intStart = 0;
        boolean isMinus = false;
        for (int j = charCount - 1; j > -1; --j) {
            if (stream[start + j] != 46) continue;
            floatptr = j;
            break;
        }
        int intChars = floatptr;
        if (stream[start] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[start] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        int decNumbers = charCount - floatptr;
        if (intNumbers > 3 || decNumbers > 11) {
            isMinus = false;
            f = Float.parseFloat(this.generateOpAsString(id, false));
        } else {
            int c;
            float units = 0.0f;
            float tens = 0.0f;
            float hundreds = 0.0f;
            float tenths = 0.0f;
            float hundredths = 0.0f;
            float thousands = 0.0f;
            float tenthousands = 0.0f;
            float hunthousands = 0.0f;
            if (intNumbers > 2) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        hundreds = 100.0f;
                        break;
                    }
                    case 2: {
                        hundreds = 200.0f;
                        break;
                    }
                    case 3: {
                        hundreds = 300.0f;
                        break;
                    }
                    case 4: {
                        hundreds = 400.0f;
                        break;
                    }
                    case 5: {
                        hundreds = 500.0f;
                        break;
                    }
                    case 6: {
                        hundreds = 600.0f;
                        break;
                    }
                    case 7: {
                        hundreds = 700.0f;
                        break;
                    }
                    case 8: {
                        hundreds = 800.0f;
                        break;
                    }
                    case 9: {
                        hundreds = 900.0f;
                    }
                }
                ++intStart;
            }
            if (intNumbers > 1) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        tens = 10.0f;
                        break;
                    }
                    case 2: {
                        tens = 20.0f;
                        break;
                    }
                    case 3: {
                        tens = 30.0f;
                        break;
                    }
                    case 4: {
                        tens = 40.0f;
                        break;
                    }
                    case 5: {
                        tens = 50.0f;
                        break;
                    }
                    case 6: {
                        tens = 60.0f;
                        break;
                    }
                    case 7: {
                        tens = 70.0f;
                        break;
                    }
                    case 8: {
                        tens = 80.0f;
                        break;
                    }
                    case 9: {
                        tens = 90.0f;
                    }
                }
                ++intStart;
            }
            if (intNumbers > 0) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        units = 1.0f;
                        break;
                    }
                    case 2: {
                        units = 2.0f;
                        break;
                    }
                    case 3: {
                        units = 3.0f;
                        break;
                    }
                    case 4: {
                        units = 4.0f;
                        break;
                    }
                    case 5: {
                        units = 5.0f;
                        break;
                    }
                    case 6: {
                        units = 6.0f;
                        break;
                    }
                    case 7: {
                        units = 7.0f;
                        break;
                    }
                    case 8: {
                        units = 8.0f;
                        break;
                    }
                    case 9: {
                        units = 9.0f;
                    }
                }
            }
            if (decNumbers > 1) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        tenths = 0.1f;
                        break;
                    }
                    case 2: {
                        tenths = 0.2f;
                        break;
                    }
                    case 3: {
                        tenths = 0.3f;
                        break;
                    }
                    case 4: {
                        tenths = 0.4f;
                        break;
                    }
                    case 5: {
                        tenths = 0.5f;
                        break;
                    }
                    case 6: {
                        tenths = 0.6f;
                        break;
                    }
                    case 7: {
                        tenths = 0.7f;
                        break;
                    }
                    case 8: {
                        tenths = 0.8f;
                        break;
                    }
                    case 9: {
                        tenths = 0.9f;
                    }
                }
            }
            if (decNumbers > 2) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        hundredths = 0.01f;
                        break;
                    }
                    case 2: {
                        hundredths = 0.02f;
                        break;
                    }
                    case 3: {
                        hundredths = 0.03f;
                        break;
                    }
                    case 4: {
                        hundredths = 0.04f;
                        break;
                    }
                    case 5: {
                        hundredths = 0.05f;
                        break;
                    }
                    case 6: {
                        hundredths = 0.06f;
                        break;
                    }
                    case 7: {
                        hundredths = 0.07f;
                        break;
                    }
                    case 8: {
                        hundredths = 0.08f;
                        break;
                    }
                    case 9: {
                        hundredths = 0.09f;
                    }
                }
            }
            if (decNumbers > 3) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        thousands = 0.001f;
                        break;
                    }
                    case 2: {
                        thousands = 0.002f;
                        break;
                    }
                    case 3: {
                        thousands = 0.003f;
                        break;
                    }
                    case 4: {
                        thousands = 0.004f;
                        break;
                    }
                    case 5: {
                        thousands = 0.005f;
                        break;
                    }
                    case 6: {
                        thousands = 0.006f;
                        break;
                    }
                    case 7: {
                        thousands = 0.007f;
                        break;
                    }
                    case 8: {
                        thousands = 0.008f;
                        break;
                    }
                    case 9: {
                        thousands = 0.009f;
                    }
                }
            }
            if (decNumbers > 4) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        tenthousands = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        tenthousands = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        tenthousands = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        tenthousands = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        tenthousands = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        tenthousands = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        tenthousands = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        tenthousands = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        tenthousands = 9.0E-4f;
                    }
                }
            }
            if (decNumbers > 5) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        hunthousands = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        hunthousands = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        hunthousands = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        hunthousands = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        hunthousands = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        hunthousands = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        hunthousands = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        hunthousands = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        hunthousands = 9.0E-5f;
                    }
                }
            }
            float dec = tenths + hundredths + thousands + tenthousands + hunthousands;
            float num = hundreds + tens + units;
            f = num + dec;
        }
        if (isMinus) {
            return -f;
        }
        return f;
    }

    float[] getValuesAsFloat() {
        float[] op = new float[this.operandCount];
        for (int i = 0; i < this.operandCount; ++i) {
            op[i] = this.parseFloat(i);
        }
        return op;
    }

    String[] getValuesAsString() {
        String[] op = new String[this.operandCount];
        for (int i = 0; i < this.operandCount; ++i) {
            op[i] = this.generateOpAsString(i, true);
        }
        return op;
    }

    final int parseInt(int i) {
        int start = this.opStart[i];
        int end = this.opEnd[i];
        byte[] stream = this.characterStream;
        int number = 0;
        int id = 0;
        int charCount = end - start;
        int intStart = 0;
        boolean isMinus = false;
        int intChars = charCount;
        if (stream[start] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[start] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        if (intNumbers > 6) {
            isMinus = false;
            number = Integer.parseInt(this.generateOpAsString(id, false));
        } else {
            for (int jj = 5; jj > -1; --jj) {
                if (intNumbers <= jj) continue;
                int c = stream[start + intStart] - 48;
                number += intValues[5 - jj][c];
                ++intStart;
            }
        }
        if (isMinus) {
            return -number;
        }
        return number;
    }

    public void reset() {
        this.currentOp = 0;
        this.operandCount = 0;
    }

    public int getOperandCount() {
        return this.operandCount;
    }

    public byte[] getStream() {
        return this.characterStream;
    }

    public int getcurrentOp() {
        return this.currentOp;
    }
}

