/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ImageHandler;
import org.jpedal.images.ImageOps;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.IDObjectDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.ImageCommands;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;

public class ImageDecoder
extends BaseDecoder {
    PdfImageData pdfImages = null;
    private boolean getSamplingOnly = false;
    boolean isMask = true;
    String imagesInFile = null;
    boolean isPrinting;
    ImageHandler customImageHandler;
    boolean useHiResImageForDisplay;
    boolean isType3Font;
    boolean renderDirectly;
    int formLevel;
    PdfPageData pageData;
    ObjectStore objectStoreStreamRef;
    boolean clippedImagesExtracted = true;
    private boolean extractRawCMYK = false;
    boolean finalImagesExtracted = true;
    private boolean doNotRotate = false;
    boolean createScaledVersion = true;
    boolean renderImages = false;
    boolean rawImagesExtracted = true;
    private int optionsApplied = 0;
    private String currentImage = "";
    private String formName;

    public ImageDecoder(ImageHandler customImageHandler, ObjectStore objectStoreStreamRef, boolean renderDirectly, PdfImageData pdfImages, int formLevel, PdfPageData pageData, String imagesInFile, String formName) {
        this.formName = formName;
        this.customImageHandler = customImageHandler;
        this.objectStoreStreamRef = objectStoreStreamRef;
        this.renderDirectly = renderDirectly;
        this.pdfImages = pdfImages;
        this.formLevel = formLevel;
        this.pageData = pageData;
        this.imagesInFile = imagesInFile;
    }

    private GenericColorSpace setupXObjectColorspace(PdfObject XObject2, int depth, int width, int height, byte[] objectData) {
        PdfObject parms;
        int[] maskArray;
        PdfObject newMask;
        PdfObject ColorSpace2 = XObject2.getDictionary(2087749783);
        GenericColorSpace decodeColorData = new DeviceRGBColorSpace();
        if (ColorSpace2 != null) {
            decodeColorData = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, ColorSpace2, this.cache.XObjectColorspaces);
            decodeColorData.setPrinting(this.isPrinting);
            this.cache.put(1, decodeColorData.getID(), "x");
            if (depth == 1 && decodeColorData.getID() == 1785221209 && XObject2.getDictionary(489767739) == null) {
                byte[] data = decodeColorData.getIndexedMap();
                if (decodeColorData.getIndexedMap() == null || data.length == 6 && data[0] == 0 && data[1] == 0 && data[2] == 0) {
                    decodeColorData = new DeviceGrayColorSpace();
                }
            }
        }
        byte[] indexData = decodeColorData.getIndexedMap();
        if (depth == 8 && indexData != null && decodeColorData.getID() == 1785221209 && width * height == objectData.length && (newMask = XObject2.getDictionary(489767739)) != null && (maskArray = newMask.getIntArray(489767739)) != null && maskArray.length == 2 && maskArray[0] == 255 && maskArray[0] == maskArray[1] && decodeColorData.getIndexedMap() != null && decodeColorData.getIndexedMap().length == 768) {
            boolean isCorrupt = true;
            for (int jj = 0; jj < 768; ++jj) {
                if (indexData[jj] == 0) continue;
                isCorrupt = false;
                jj = 768;
            }
            if (isCorrupt) {
                decodeColorData = new DeviceGrayColorSpace();
            }
        }
        if ((parms = XObject2.getDictionary(1888135062)) != null) {
            decodeColorData.setDecodeParms(parms);
        }
        decodeColorData.setIntent(XObject2.getName(1144346498));
        return decodeColorData;
    }

    public BufferedImage processImageXObject(PdfObject XObject2, String image_name, byte[] objectData, boolean saveRawData, String details) throws PdfException {
        BufferedImage image = null;
        image_name = this.fileName + '-' + image_name;
        int depth = 1;
        int width = XObject2.getInt(959726687);
        int height = XObject2.getInt(959926393);
        int newDepth = XObject2.getInt(-1344207655);
        if (newDepth != -1) {
            depth = newDepth;
        }
        boolean imageMask = this.isMask = XObject2.getBoolean(1516403337);
        GenericColorSpace decodeColorData = this.setupXObjectColorspace(XObject2, depth, width, height, objectData);
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Processing XObject: " + image_name + ' ' + XObject2.getObjectRefAsString() + " width=" + width + " Height=" + height + " Depth=" + depth + " colorspace=" + decodeColorData);
        }
        if (this.customImageHandler != null) {
            image = this.customImageHandler.processImageData(this.gs, XObject2);
        }
        PdfObject newSMask = XObject2.getDictionary(489767774);
        byte[] index = decodeColorData.getIndexedMap();
        if (newSMask != null && index != null && index.length == 3 && decodeColorData.getID() != 1247168582) {
            XObject2 = newSMask;
            XObject2.setFloatArray(859785322, new float[]{1.0f, 0.0f});
            objectData = this.currentPdfFile.readStream(XObject2, true, true, false, false, false, null);
            depth = 1;
            width = XObject2.getInt(959726687);
            height = XObject2.getInt(959926393);
            newDepth = XObject2.getInt(-1344207655);
            if (newDepth != -1) {
                depth = newDepth;
            }
            decodeColorData = this.setupXObjectColorspace(XObject2, depth, width, height, objectData);
        }
        if (newSMask != null && XObject2.getInt(959726687) == 1 && XObject2.getInt(959926393) == 1 && XObject2.getInt(-1344207655) == 8) {
            int opacity = -1;
            XObject2 = newSMask;
            float[] maskDecode = XObject2.getFloatArray(859785322);
            if (maskDecode != null) {
                opacity = (byte)(maskDecode[0] * 255.0f);
            }
            byte[] maskIndex = new byte[]{0, 0, 0, -1, -1, -1};
            byte[] data = this.currentPdfFile.readStream(XObject2, true, true, false, false, false, null);
            width = XObject2.getInt(959726687);
            height = XObject2.getInt(959926393);
            int length = width * height * 4;
            objectData = new byte[length];
            ColorSpaceConvertor.flatten1bpc(width, data, maskIndex, true, length, opacity, objectData);
            image = new BufferedImage(width, height, 2);
            DataBufferByte db = new DataBufferByte(objectData, objectData.length);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 4, 4, new int[]{0, 1, 2, 3}, null);
            image.setData(raster);
        } else if (this.customImageHandler == null || image == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
            image = this.processImage(decodeColorData, objectData, image_name, width, height, depth, imageMask, XObject2, saveRawData, 2);
        }
        if (ImageCommands.trackImages && image != null && details != null) {
            float dpi = this.gs.CTM[0][0];
            if (dpi == 0.0f) {
                dpi = this.gs.CTM[0][1];
            }
            if (dpi < 0.0f) {
                dpi = -dpi;
            }
            dpi = (int)((float)width / dpi * 100.0f);
            StringBuilder imageInfo = new StringBuilder(details);
            imageInfo.append(" w=");
            imageInfo.append(String.valueOf(width));
            imageInfo.append(" h=");
            imageInfo.append(String.valueOf(height));
            imageInfo.append(' ');
            imageInfo.append(String.valueOf((int)dpi));
            imageInfo.append(' ');
            imageInfo.append(ColorSpaces.IDtoString(decodeColorData.getID()));
            imageInfo.append(" (");
            imageInfo.append(String.valueOf(image.getWidth()));
            imageInfo.append(' ');
            imageInfo.append(String.valueOf(image.getHeight()));
            imageInfo.append(" type=");
            imageInfo.append(String.valueOf(image.getType()));
            imageInfo.append(')');
            if (this.imagesInFile.length() == 0) {
                this.imagesInFile = imageInfo.toString();
            } else {
                imageInfo.append('\n');
                imageInfo.append(this.imagesInFile);
                this.imagesInFile = imageInfo.toString();
            }
        }
        return image;
    }

    public int processDOImage(String name, int dataPointer, PdfObject XObject2) throws PdfException {
        block7: {
            if (this.formLevel > 0) {
                name = this.formName + '_' + this.formLevel + '_' + name;
            }
            String key = null;
            if (ImageCommands.rejectSuperimposedImages) {
                key = (int)this.gs.CTM[2][0] + "-" + (int)this.gs.CTM[2][1] + '-' + (int)this.gs.CTM[0][0] + '-' + (int)this.gs.CTM[1][1] + '-' + (int)this.gs.CTM[0][1] + '-' + (int)this.gs.CTM[1][0];
            }
            try {
                this.processXImage(name, name, key, XObject2);
            }
            catch (Error e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error: " + e.getMessage());
                }
                this.imagesProcessedFully = false;
                this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + e);
                }
                this.imagesProcessedFully = false;
                this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
                if (!e.getMessage().contains("JPeg 2000")) break block7;
                throw new RuntimeException("XX JPeg 2000 Images needs the VM parameter -Dorg.jpedal.jai=true switch turned on");
            }
        }
        return dataPointer;
    }

    private void processXImage(String name, String details, String key, PdfObject XObject2) throws PdfException {
        boolean isForHTML;
        int previousUse = -1;
        if (ImageCommands.trackImages) {
            details = details + " Image";
            if (this.imagesInFile == null) {
                this.imagesInFile = "";
            }
        }
        boolean bl = isForHTML = this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6;
        if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
            byte[] objectData = this.currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(this.currentPdfFile.getObjectReader()));
            if (objectData == null) {
                this.imagesProcessedFully = false;
            }
            if (objectData != null) {
                boolean alreadyCached = false;
                BufferedImage image = null;
                this.currentImage = this.fileName + '-' + name;
                if (!alreadyCached) {
                    image = this.processImageXObject(XObject2, name, objectData, true, details);
                }
                if (image != null && image.getWidth() == 1 && image.getHeight() == 1 && this.isType3Font) {
                    image.flush();
                    image = null;
                }
                if (image != null || alreadyCached) {
                    float[][] savedCMT;
                    block23: {
                        savedCMT = null;
                        if (!isForHTML && (this.renderDirectly || this.useHiResImageForDisplay)) {
                            this.gs.x = this.gs.CTM[2][0];
                            this.gs.y = this.gs.CTM[2][1];
                            if (this.finalImagesExtracted || this.rawImagesExtracted) {
                                int h;
                                int w = (int)Math.abs(this.gs.CTM[0][0]);
                                if (w == 0) {
                                    w = (int)Math.abs(this.gs.CTM[0][1]);
                                }
                                if ((h = (int)Math.abs(this.gs.CTM[1][1])) == 0) {
                                    h = (int)Math.abs(this.gs.CTM[1][0]);
                                }
                                this.pdfImages.setImageInfo(this.currentImage, this.pageNum, this.gs.x, this.gs.x, w, h);
                            }
                            if (this.renderDirectly) {
                                this.current.drawImage(this.pageNum, image, this.gs, alreadyCached, name, this.optionsApplied, -1);
                            } else if (image != null || alreadyCached) {
                                int id = this.current.drawImage(this.pageNum, image, this.gs, alreadyCached, name, this.optionsApplied, -1);
                                if (ImageCommands.rejectSuperimposedImages && key != null) {
                                    this.cache.setImposedKey(key, id);
                                }
                            }
                        } else if (this.clippedImagesExtracted || isForHTML) {
                            this.generateTransformedImage(image, name);
                        } else {
                            try {
                                this.generateTransformedImageSingle(image, name);
                            }
                            catch (Exception e) {
                                if (!LogWriter.isOutput()) break block23;
                                LogWriter.writeLog("Exception " + e + " on transforming image in file");
                            }
                        }
                    }
                    if (image != null) {
                        image.flush();
                    }
                    if (savedCMT != null) {
                        this.gs.CTM = savedCMT;
                    }
                }
            }
        }
    }

    ImageDecoder() {
    }

    public ImageDecoder(ImageHandler customImageHandler, boolean useHiResImageForDisplay, ObjectStore objectStoreStreamRef, boolean renderDirectly, PdfImageData pdfImages, int formLevel, PdfPageData pageData) {
        this.customImageHandler = customImageHandler;
        this.useHiResImageForDisplay = useHiResImageForDisplay;
        this.objectStoreStreamRef = objectStoreStreamRef;
        this.renderDirectly = renderDirectly;
        this.pdfImages = pdfImages;
        this.formLevel = formLevel;
        this.pageData = pageData;
    }

    public void setSamplingOnly(boolean getSamplingOnly) {
        this.getSamplingOnly = getSamplingOnly;
    }

    public String getImagesInFile() {
        return this.imagesInFile;
    }

    public void setParameters(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode, boolean isPrinting, boolean isType3Font, boolean useHiResImageForDisplay) {
        this.isPageContent = isPageContent;
        this.renderPage = renderPage;
        this.renderMode = renderMode;
        this.extractionMode = extractionMode;
        this.isPrinting = isPrinting;
        this.isType3Font = isType3Font;
        this.useHiResImageForDisplay = useHiResImageForDisplay;
        this.renderImages = renderPage && (renderMode & 2) == 2;
        this.finalImagesExtracted = (extractionMode & 4) == 4;
        this.extractRawCMYK = (extractionMode & 0x80) == 128;
        this.clippedImagesExtracted = (extractionMode & 0x20) == 32;
        this.rawImagesExtracted = (extractionMode & 2) == 2;
        this.createScaledVersion = this.finalImagesExtracted || this.renderImages;
    }

    public void setImageName(String currentImage) {
        this.currentImage = currentImage;
    }

    public int getOptionsApplied() {
        return this.optionsApplied;
    }

    public int processIDImage(int dataPointer, int startInlineStream, byte[] stream, int tokenNumber) throws Exception {
        int inline_start_pointer;
        XObject XObject2 = new XObject(6420);
        IDObjectDecoder objectDecoder = new IDObjectDecoder(this.currentPdfFile.getObjectReader());
        objectDecoder.setEndPt(dataPointer - 2);
        objectDecoder.readDictionaryAsObject(XObject2, startInlineStream, stream);
        BufferedImage image = null;
        int i = inline_start_pointer = dataPointer + 1;
        int streamLength = stream.length;
        while ((streamLength - i <= 3 || stream[i + 1] != 69 || stream[i + 2] != 73 || stream[i + 3] != 10) && (streamLength - i <= 3 || stream[i] != 32 && stream[i] != 10 && stream[i] != 13 && (stream[i + 3] != 32 || stream[i + 4] != 81) || stream[i + 1] != 69 || stream[i + 2] != 73 || stream[i + 3] != 32 && stream[i + 3] != 10 && stream[i + 3] != 13) && ++i != streamLength) {
        }
        if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
            Object col;
            String colKey;
            String image_name = this.fileName + "-IN-" + tokenNumber;
            int endPtr = i;
            if (i < stream.length && stream[endPtr] != 32 && stream[endPtr] != 10 && stream[endPtr] != 13) {
                ++endPtr;
            }
            if (stream[inline_start_pointer] == 10) {
                ++inline_start_pointer;
            }
            byte[] i_data = new byte[endPtr - inline_start_pointer];
            System.arraycopy(stream, inline_start_pointer, i_data, 0, endPtr - inline_start_pointer);
            XObject2.setStream(i_data);
            PdfObject ColorSpace2 = ((PdfObject)XObject2).getDictionary(2087749783);
            if (ColorSpace2 != null && (colKey = ColorSpace2.getGeneralStringValue()) != null && (col = this.cache.get(2, colKey)) != null) {
                ColorSpace2 = (PdfObject)col;
            }
            if (this.customImageHandler != null) {
                image = this.customImageHandler.processImageData(this.gs, XObject2);
            }
            PdfArrayIterator filters = ((PdfObject)XObject2).getMixedArray(1011108731);
            boolean needsDecoding = false;
            if (filters != null && filters.hasMoreTokens()) {
                int firstValue = filters.getNextValueAsConstant(false);
                needsDecoding = firstValue != 1399277700 && firstValue != 1180911742;
            }
            int i_w = ((PdfObject)XObject2).getInt(959726687);
            int i_h = ((PdfObject)XObject2).getInt(959926393);
            int i_bpc = ((PdfObject)XObject2).getInt(-1344207655);
            boolean inline_imageMask = ((PdfObject)XObject2).getBoolean(1516403337);
            if (needsDecoding) {
                PdfFilteredReader filter = new PdfFilteredReader();
                i_data = filter.decodeFilters(ObjectUtils.setupDecodeParms(XObject2, this.currentPdfFile.getObjectReader()), i_data, filters, i_w, i_h, null);
            }
            GenericColorSpace decodeColorData = new DeviceRGBColorSpace();
            if (ColorSpace2 != null) {
                decodeColorData = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, ColorSpace2);
                decodeColorData.setPrinting(this.isPrinting);
                this.cache.put(1, decodeColorData.getID(), "x");
            }
            if (i_data != null) {
                if (this.customImageHandler == null || image == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
                    image = this.processImage(decodeColorData, i_data, image_name, i_w, i_h, i_bpc, inline_imageMask, XObject2, false, 0);
                    this.currentImage = image_name;
                }
                if (this.isPrinting && image != null && this.gs != null && image.getHeight() == 1 && this.gs.CTM[1][1] < 1.0f) {
                    image = null;
                }
                if (image != null) {
                    if (this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6) {
                        this.generateTransformedImage(image, image_name);
                    } else if (this.renderDirectly || this.useHiResImageForDisplay) {
                        this.gs.x = this.gs.CTM[2][0];
                        this.gs.y = this.gs.CTM[2][1];
                        this.current.drawImage(this.pageNum, image, this.gs, false, image_name, this.optionsApplied, -1);
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(image, image_name);
                    } else {
                        this.generateTransformedImageSingle(image, image_name);
                    }
                    if (image != null) {
                        image.flush();
                    }
                }
            }
        }
        dataPointer = i + 3;
        return dataPointer;
    }

    public void generateTransformedImage(BufferedImage image, String image_name) {
        float x = 0.0f;
        float y = 0.0f;
        if (image != null) {
            String image_type;
            ImageTransformerDouble image_transformation = new ImageTransformerDouble(this.gs, image, this.createScaledVersion);
            image_transformation.doubleScaleTransformShear(this.current);
            image = image_transformation.getImage();
            if (this.current.getType() != 4 && this.current.getType() != 5 && this.current.getType() != 6) {
                image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                if (image_type == null) {
                    image_type = "tif";
                }
                if (this.objectStoreStreamRef.saveStoredImage("CLIP_" + this.currentImage, ImageCommands.addBackgroundToMask(image, this.isMask), false, false, image_type)) {
                    this.errorTracker.addPageFailureMessage("Problem saving " + image);
                }
            }
            if (this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6) {
                if (image != null) {
                    this.gs.x = x;
                    this.gs.y = y;
                    this.current.drawImage(this.pageNum, image, this.gs, false, image_name, this.optionsApplied, -1);
                }
            } else {
                if (this.finalImagesExtracted || this.renderImages) {
                    image_transformation.doubleScaleTransformScale();
                }
                image_transformation.completeImage();
                x = image_transformation.getImageX();
                y = image_transformation.getImageY();
                float w = image_transformation.getImageW();
                float h = image_transformation.getImageH();
                image = image_transformation.getImage();
                if (image != null) {
                    if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
                        this.pdfImages.setImageInfo(this.currentImage, this.pageNum, x, y, w, h);
                    }
                    if ((this.renderImages || !this.isPageContent) && image != null) {
                        this.gs.x = x;
                        this.gs.y = y;
                        this.current.drawImage(this.pageNum, image, this.gs, false, image_name, this.optionsApplied, -1);
                    }
                    if (!this.renderDirectly && this.isPageContent && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                        image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                        this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(image, this.isMask), false, false, image_type);
                    }
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    public void generateTransformedImageSingle(BufferedImage image, String image_name) {
        if (image != null) {
            boolean ignore_image;
            Area clipping_shape = this.gs.getClippingShape();
            ImageTransformer image_transformation = new ImageTransformer(this.gs, image, true);
            float x = image_transformation.getImageX();
            float y = image_transformation.getImageY();
            float w = image_transformation.getImageW();
            float h = image_transformation.getImageH();
            image = image_transformation.getImage();
            if (image != null && this.customImageHandler != null && clipping_shape != null && clipping_shape.getBounds().getWidth() > 1.0 && clipping_shape.getBounds().getHeight() > 1.0 && !this.customImageHandler.imageHasBeenScaled() && !(ignore_image = clipping_shape.contains(x, y, w, h))) {
                image_transformation.clipImage(clipping_shape);
                x = image_transformation.getImageX();
                y = image_transformation.getImageY();
                w = image_transformation.getImageW();
                h = image_transformation.getImageH();
            }
            if ((image = image_transformation.getImage()) != null) {
                if (this.finalImagesExtracted || this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, x, y, w, h);
                }
                if ((this.renderImages || !this.isPageContent) && image != null) {
                    this.gs.x = x;
                    this.gs.y = y;
                    this.current.drawImage(this.pageNum, image, this.gs, false, image_name, this.optionsApplied, -1);
                }
                if (this.isPageContent && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                    String image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(image, this.isMask), false, false, image_type);
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    BufferedImage processImage(GenericColorSpace decodeColorData, byte[] data, String name, int w, int h, int d, boolean imageMask, PdfObject XObject2, boolean saveRawData, int mode) throws PdfException {
        PdfObject TR;
        boolean arrayInverted;
        PdfObject newSMask;
        PdfObject newMask;
        PdfObject DecodeParms;
        byte[] index;
        byte[] maskCol;
        int pY;
        int pX;
        int compCount;
        int colorspaceID;
        String type;
        BufferedImage image;
        boolean isDownsampled;
        boolean removed;
        boolean isJPX;
        boolean isDCT;
        PdfArrayIterator Filters;
        float[] decodeArray;
        int rawd;
        block191: {
            int newH;
            int newW;
            this.cache.put(1, decodeColorData.getID(), "x");
            rawd = d;
            int sampling = 1;
            decodeArray = XObject2.getFloatArray(859785322);
            if (LogWriter.debug && decodeArray != null) {
                String val = "";
                for (float aDecodeArray : decodeArray) {
                    val = val + ' ' + aDecodeArray;
                }
            }
            Filters = XObject2.getMixedArray(1011108731);
            isDCT = false;
            isJPX = false;
            if (Filters != null && Filters.hasMoreTokens()) {
                while (Filters.hasMoreTokens()) {
                    int firstValue = Filters.getNextValueAsConstant(true);
                    isDCT = firstValue == 1180911742;
                    isJPX = firstValue == 1399277700;
                }
            } else {
                Filters = null;
            }
            removed = false;
            isDownsampled = false;
            image = null;
            type = "jpg";
            colorspaceID = decodeColorData.getID();
            compCount = decodeColorData.getColorSpace().getNumComponents();
            pX = 0;
            pY = 0;
            maskCol = new byte[4];
            if (imageMask) {
                ImageCommands.getMaskColor(maskCol, this.gs);
            }
            index = decodeColorData.getIndexedMap();
            if (this.renderPage && this.streamType != 1 && !this.current.avoidDownSamplingImage()) {
                if (this.isPrinting && SamplingFactory.isPrintDownsampleEnabled && w < 4000) {
                    pX = this.pageData.getCropBoxWidth(this.pageNum) * 4;
                    pY = this.pageData.getCropBoxHeight(this.pageNum) * 4;
                } else if (SamplingFactory.downsampleLevel == SamplingFactory.high || this.getSamplingOnly) {
                    float[][] CTM = new float[3][3];
                    for (int ii = 0; ii < 3; ++ii) {
                        for (int jj = 0; jj < 3; ++jj) {
                            CTM[ii][jj] = this.gs.CTM[ii][jj] < 0.0f ? -this.gs.CTM[ii][jj] : this.gs.CTM[ii][jj];
                        }
                    }
                    pX = CTM[0][0] == 0.0f || CTM[0][0] < CTM[0][1] ? (int)CTM[0][1] : (int)CTM[0][0];
                    pY = CTM[1][1] == 0.0f || CTM[1][1] < CTM[1][0] ? (int)CTM[1][0] : (int)CTM[1][1];
                    if (!this.getSamplingOnly && (w < 500 || h < 600 && (w < 1000 || isJPX))) {
                        pX = 0;
                        pY = 0;
                    }
                } else if (SamplingFactory.downsampleLevel == SamplingFactory.medium) {
                    pX = this.pageData.getCropBoxWidth(this.pageNum);
                    pY = this.pageData.getCropBoxHeight(this.pageNum);
                }
            }
            int maxHTMLImageSize = 4000;
            if (this.current.avoidDownSamplingImage() || w < 4000 && h < 4000 && (this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6)) {
                pX = -1;
                pY = -1;
            }
            if ((isDCT || isJPX) && this.multiplyer > 1.0f) {
                pX = (int)((float)pX * this.multiplyer);
                pY = (int)((float)pY * this.multiplyer);
            }
            DecodeParms = XObject2.getDictionary(1888135062);
            newMask = XObject2.getDictionary(489767739);
            newSMask = XObject2.getDictionary(489767774);
            if (d == 1 && (newSMask != null || XObject2.getObjectType() != 489767739) && decodeColorData.getID() == 1568372915 && h < 300) {
                pX = 0;
                pY = 0;
            }
            if ((newMask != null || newSMask != null) && LogWriter.isOutput()) {
                LogWriter.writeLog("newMask= " + newMask + " newSMask=" + newSMask);
            }
            arrayInverted = false;
            if (decodeArray != null) {
                arrayInverted = true;
                int count = decodeArray.length;
                for (int aa = 0; aa < count; aa += 2) {
                    if (decodeArray[aa] == 1.0f && decodeArray[aa + 1] == 0.0f) continue;
                    arrayInverted = false;
                    aa = count;
                }
            }
            if (!(!this.renderPage || newMask != null || decodeColorData.getID() == 1247168582 || !arrayInverted && decodeArray != null && decodeArray.length != 0 || d != 1 && d != 8 || pX <= 0 || pY <= 0 || !SamplingFactory.isPrintDownsampleEnabled && this.isPrinting)) {
                int scaleY;
                newW = w;
                newH = h;
                if (this.multiplyer <= 1.0f && !this.isPrinting) {
                    int maxAllowed = 1000;
                    if (decodeColorData.getID() == 1568372915) {
                        maxAllowed = 4000;
                    }
                    if (pX > maxAllowed) {
                        pX = maxAllowed;
                    }
                    if (pY > maxAllowed) {
                        pY = maxAllowed;
                    }
                }
                int smallestH = pY << 2;
                int smallestW = pX << 2;
                while (newW > smallestW && newH > smallestH) {
                    sampling <<= 1;
                    newW >>= 1;
                    newH >>= 1;
                }
                int scaleX = w / pX;
                if (scaleX < 1) {
                    scaleX = 1;
                }
                if ((scaleY = h / pY) < 1) {
                    scaleY = 1;
                }
                if ((sampling = scaleX) > scaleY) {
                    sampling = scaleY;
                }
            }
            if (this.getSamplingOnly) {
                byte[] objectData;
                float scaleX = (float)w / (float)pX;
                float scaleY = (float)h / (float)pY;
                this.samplingUsed = scaleX < scaleY ? scaleX : scaleY;
                boolean checkMask = false;
                if (newSMask != null && (objectData = this.currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(this.currentPdfFile.getObjectReader()))) != null) {
                    boolean ignoreMask;
                    if (DecodeParms == null) {
                        DecodeParms = newSMask.getDictionary(1888135062);
                    }
                    int maskW = newSMask.getInt(959726687);
                    int maskH = newSMask.getInt(959926393);
                    boolean isDownscaled = maskW / 2 > w && maskH / 2 > h;
                    boolean bl = ignoreMask = isDownscaled && DecodeParms != null && DecodeParms.getInt(1010783618) != -1 && DecodeParms.getInt(1970893723) != 15;
                    if (!ignoreMask) {
                        checkMask = true;
                    }
                }
                if (!checkMask) {
                    return null;
                }
            }
            if (sampling > 1 && this.multiplyer > 1.0f) {
                sampling = (int)((float)sampling / this.multiplyer);
            }
            if (sampling > 1) {
                isDownsampled = true;
                newW = w / sampling;
                newH = h / sampling;
                boolean saveData = false;
                if (imageMask && w > 2000 && h > 2000 && d == 1 && decodeColorData.getID() == 1785221209 && this.gs.CTM[0][0] > 0.0f && this.gs.CTM[1][1] > 0.0f) {
                    saveData = true;
                }
                if (d == 1 && (decodeColorData.getID() != 1785221209 || index == null)) {
                    if (this.formLevel < 2 && (saveData || !imageMask && saveRawData && decodeColorData.getID() == 1568372915)) {
                        boolean isRotated;
                        int count = data.length;
                        byte[] turnedData = new byte[count];
                        System.arraycopy(data, 0, turnedData, 0, count);
                        boolean isInverted = !saveData && !this.doNotRotate && (this.renderDirectly || this.useHiResImageForDisplay) && RenderUtils.isInverted(this.gs.CTM);
                        boolean bl = isRotated = !saveData && !this.doNotRotate && (this.renderDirectly || this.useHiResImageForDisplay) && RenderUtils.isRotated(this.gs.CTM);
                        if (this.renderDirectly) {
                            isInverted = false;
                            isRotated = false;
                        }
                        if (isRotated) {
                            turnedData = ImageOps.rotateImage(turnedData, w, h, d, 1, index);
                            int temp = h;
                            h = w;
                            w = temp;
                            temp = pX;
                            pX = pY;
                            pY = temp;
                        }
                        if (isInverted) {
                            turnedData = ImageOps.invertImage(turnedData, w, h, d, 1, index);
                        }
                        if (arrayInverted) {
                            for (int aa = 0; aa < count; ++aa) {
                                turnedData[aa] = (byte)(turnedData[aa] ^ 0xFF);
                            }
                        }
                        if (!(decodeColorData.getID() == 1785221209 && d == 1 && maskCol != null || (w >= 4000 || h >= 4000) && decodeColorData.getID() != 1568372915 || XObject2 instanceof MaskObject)) {
                            String key = this.pageNum + String.valueOf(this.imageCount);
                            if (saveData) {
                                this.current.getObjectStore().saveRawImageData(key, turnedData, w, h, pX, pY, maskCol, decodeColorData.getID());
                            } else {
                                this.current.getObjectStore().saveRawImageData(key, turnedData, w, h, pX, pY, null, decodeColorData.getID());
                            }
                        }
                        if (isRotated) {
                            int temp = h;
                            h = w;
                            w = temp;
                            temp = pX;
                            pX = pY;
                            pY = temp;
                        }
                    }
                    if (index != null) {
                        index = decodeColorData.convertIndexToRGB(index);
                    }
                    int size = newW * newH;
                    if (imageMask) {
                        size *= 4;
                        maskCol[3] = -1;
                    } else if (index != null) {
                        size *= 3;
                    }
                    byte[] newData = new byte[size];
                    int[] flag = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                    int origLineLength = w + 7 >> 3;
                    for (int y = 0; y < newH; ++y) {
                        for (int x = 0; x < newW; ++x) {
                            int ii;
                            int bytes = 0;
                            int count = 0;
                            int wCount = sampling;
                            int hCount = sampling;
                            int wGapLeft = w - x;
                            int hGapLeft = h - y;
                            if (wCount > wGapLeft) {
                                wCount = wGapLeft;
                            }
                            if (hCount > hGapLeft) {
                                hCount = hGapLeft;
                            }
                            for (int yy = 0; yy < hCount; ++yy) {
                                for (int xx = 0; xx < wCount; ++xx) {
                                    int bit;
                                    int ptr = (yy + y * sampling) * origLineLength + (x * sampling + xx >> 3);
                                    byte currentByte = ptr < data.length ? data[ptr] : (byte)0;
                                    if (imageMask && !arrayInverted) {
                                        currentByte = (byte)(currentByte ^ 0xFF);
                                    }
                                    if ((bit = currentByte & flag[7 - (x * sampling + xx & 7)]) != 0) {
                                        ++bytes;
                                    }
                                    ++count;
                                }
                            }
                            int offset = x + newW * y;
                            if (count > 0) {
                                if (imageMask) {
                                    for (ii = 0; ii < 4; ++ii) {
                                        newData[offset * 4 + ii] = arrayInverted ? (byte)(255 - (maskCol[ii] & 0xFF) * bytes / count) : (byte)((maskCol[ii] & 0xFF) * bytes / count);
                                    }
                                    continue;
                                }
                                if (index == null || decodeColorData.getID() == -2073385820) {
                                    // empty if block
                                }
                                if (index != null && d == 1) {
                                    for (int ii2 = 0; ii2 < 3; ++ii2) {
                                        if (index[0] == -1 && index[1] == -1 && index[2] == -1) {
                                            int av = (index[ii2] & 0xFF) + (index[ii2 + 3] & 0xFF);
                                            newData[offset * 3 + ii2] = (byte)(255 - av * bytes / count);
                                            continue;
                                        }
                                        float ratio = bytes / count;
                                        newData[offset * 3 + ii2] = (double)ratio > 0.5 ? index[ii2 + 3] : index[ii2];
                                    }
                                    continue;
                                }
                                if (index != null) {
                                    for (ii = 0; ii < 3; ++ii) {
                                        newData[offset * 3 + ii] = (byte)((index[ii] & 0xFF) * bytes / count);
                                    }
                                    continue;
                                }
                                newData[offset] = (byte)(255 * bytes / count);
                                continue;
                            }
                            if (imageMask) {
                                for (ii = 0; ii < 3; ++ii) {
                                    newData[offset * 4 + ii] = 0;
                                }
                                continue;
                            }
                            if (index != null) {
                                for (ii = 0; ii < 3; ++ii) {
                                    newData[offset * 3 + ii] = 0;
                                }
                                continue;
                            }
                            newData[offset] = -1;
                        }
                    }
                    data = newData;
                    if (index != null) {
                        compCount = 3;
                    }
                    h = newH;
                    w = newW;
                    decodeColorData.setIndex(null, 0);
                    if (decodeColorData.getID() == -2073385820) {
                        decodeColorData = new DeviceRGBColorSpace();
                        if (d == 1 && index == null) {
                            compCount = 1;
                            int count = data.length;
                            for (int aa = 0; aa < count; ++aa) {
                                data[aa] = (byte)(data[aa] ^ 0xFF);
                            }
                        }
                    }
                    d = 8;
                } else {
                    if (d == 8 && (Filters == null || !isDCT && !isJPX)) {
                        boolean hasIndex = decodeColorData.getIndexedMap() != null && (decodeColorData.getID() == 1785221209 || decodeColorData.getID() == 1008872003 || decodeColorData.getID() == 1498837125 || decodeColorData.getID() == 1247168582);
                        int oldSize = data.length;
                        int x = 0;
                        int y = 0;
                        int xx = 0;
                        int yy = 0;
                        int jj = 0;
                        int comp = 0;
                        int origLineLength = 0;
                        int indexCount = 1;
                        try {
                            byte[] newData;
                            if (hasIndex) {
                                comp = 1;
                                compCount = 3;
                                indexCount = 3;
                                index = decodeColorData.convertIndexToRGB(index);
                                decodeColorData.setIndex(null, 0);
                            } else {
                                comp = decodeColorData.getColorComponentCount();
                            }
                            if (w * h == oldSize || decodeColorData.getID() == 1568372915) {
                                comp = 1;
                            }
                            if (hasIndex) {
                                newData = new byte[newW * newH * indexCount];
                                origLineLength = w;
                            } else {
                                newData = new byte[newW * newH * comp];
                                origLineLength = w * comp;
                            }
                            for (y = 0; y < newH; ++y) {
                                for (x = 0; x < newW; ++x) {
                                    int wCount = sampling;
                                    int hCount = sampling;
                                    int wGapLeft = w - x;
                                    int hGapLeft = h - y;
                                    if (wCount > wGapLeft) {
                                        wCount = wGapLeft;
                                    }
                                    if (hCount > hGapLeft) {
                                        hCount = hGapLeft;
                                    }
                                    for (jj = 0; jj < comp; ++jj) {
                                        int newPtr;
                                        int aa;
                                        int byteTotal = 0;
                                        int count = 0;
                                        int[] indexAv = new int[indexCount];
                                        for (yy = 0; yy < hCount; ++yy) {
                                            for (xx = 0; xx < wCount; ++xx) {
                                                int ptr = (yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj);
                                                if (ptr >= oldSize) continue;
                                                if (!hasIndex) {
                                                    byteTotal += data[ptr] & 0xFF;
                                                } else {
                                                    for (aa = 0; aa < indexCount; ++aa) {
                                                        indexAv[aa] = indexAv[aa] + (index[(data[ptr] & 0xFF) * indexCount + aa] & 0xFF);
                                                    }
                                                }
                                                ++count;
                                            }
                                        }
                                        if (hasIndex) {
                                            newPtr = jj + x * indexCount + newW * y * indexCount;
                                            for (aa = 0; aa < indexCount; ++aa) {
                                                newData[newPtr + aa] = (byte)(indexAv[aa] / count);
                                            }
                                            continue;
                                        }
                                        if (count <= 0) continue;
                                        newPtr = jj + x * comp + newW * y * comp;
                                        newData[newPtr] = (byte)(byteTotal / count);
                                    }
                                }
                            }
                            data = newData;
                            h = newH;
                            w = newW;
                        }
                        catch (Exception e) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Exception: " + e.getMessage());
                            }
                            break block191;
                        }
                    }
                    if (isDCT || isJPX || index == null) {
                        // empty if block
                    }
                }
            }
        }
        if (decodeArray != null && decodeArray.length != 0 && (Filters == null || !isJPX && !isDCT) && index == null) {
            ImageCommands.applyDecodeArray(data, d, decodeArray, colorspaceID, XObject2);
        }
        if (imageMask) {
            float ratio = (float)h / (float)w;
            if (this.isPrinting && ratio < 0.1f && w > 4000 && h > 1 || ratio < 0.001f && w > 4000 && h > 1 || w == 1 && h == 1) {
                float iw;
                float ix = this.gs.CTM[2][0];
                float iy = this.gs.CTM[2][1];
                float ih = this.gs.CTM[1][1];
                if (ih == 0.0f) {
                    ih = this.gs.CTM[1][0];
                }
                if (ih < 0.0f) {
                    iy += ih;
                    ih = -ih;
                }
                if ((iw = this.gs.CTM[0][0]) == 0.0f) {
                    iw = this.gs.CTM[0][1];
                }
                if (iw < 0.0f) {
                    ix += iw;
                    iw = -iw;
                }
                if (this.gs.CTM[0][0] == 0.0f && this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][0] != 0.0f && this.gs.CTM[1][1] == 0.0f) {
                    float tmp = ih;
                    ih = iw;
                    iw = tmp;
                }
                if (iw < 1.0f) {
                    iw = 1.0f;
                }
                if (ih < 1.0f) {
                    ih = 1.0f;
                }
                int lwidth = -1;
                if (ih < 3.0f) {
                    lwidth = (int)ih;
                    ih = 1.0f;
                } else if (iw < 3.0f) {
                    lwidth = (int)iw;
                    iw = 1.0f;
                }
                GeneralPath currentShape = new GeneralPath(1);
                currentShape.moveTo(ix, iy);
                currentShape.lineTo(ix, iy + ih);
                currentShape.lineTo(ix + iw, iy + ih);
                currentShape.lineTo(ix + iw, iy);
                currentShape.closePath();
                if (this.renderPage && currentShape != null) {
                    float lastLineWidth = this.gs.getLineWidth();
                    if (lwidth > 0) {
                        this.gs.setLineWidth(lwidth);
                    }
                    this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
                    this.gs.setFillType(2);
                    this.current.drawShape(currentShape, this.gs, 70);
                    if (lwidth > 0) {
                        this.gs.setLineWidth(lastLineWidth);
                    }
                }
                return null;
            }
            if (h == 2 && d == 1 && ImageCommands.isRepeatingLine(data, h)) {
                float ix = this.gs.CTM[2][0];
                float iy = this.gs.CTM[2][1];
                float ih = this.gs.CTM[1][1];
                float iw = this.gs.CTM[0][0];
                if (this.gs.CTM[0][0] == 0.0f && this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][0] != 0.0f && this.gs.CTM[1][1] == 0.0f) {
                    float tmp = ih;
                    ih = iw;
                    iw = tmp;
                }
                double byteWidth = iw / (float)(data.length / h);
                double bitWidth = byteWidth / 8.0;
                for (int col = 0; col < data.length / h; ++col) {
                    int currentByte = data[col] & 0xFF;
                    int bitCount = 8;
                    double endX = 0.0;
                    boolean draw = false;
                    for (currentByte = (currentByte ^ 0xFFFFFFFF) & 0xFF; currentByte != 0 || draw; currentByte >>>= 1) {
                        --bitCount;
                        if ((currentByte & 1) == 1) {
                            if (draw) continue;
                            endX = ((double)bitCount + 0.5) * bitWidth + (double)col * byteWidth;
                            draw = true;
                            continue;
                        }
                        if (!draw) continue;
                        draw = false;
                        double startX = ((double)bitCount + 0.5) * bitWidth + (double)col * byteWidth;
                        GeneralPath currentShape = new GeneralPath(1);
                        currentShape.moveTo((float)((double)ix + startX), iy);
                        currentShape.lineTo((float)((double)ix + startX), iy + ih);
                        currentShape.lineTo((float)((double)ix + endX), iy + ih);
                        currentShape.lineTo((float)((double)ix + endX), iy);
                        currentShape.closePath();
                        if (!this.renderPage || currentShape == null) continue;
                        this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
                        this.gs.setFillType(2);
                        this.current.drawShape(currentShape, this.gs, 70);
                    }
                }
                return null;
            }
            if (isDownsampled) {
                DataBufferByte db = new DataBufferByte(data, data.length);
                int[] bands = new int[]{0, 1, 2, 3};
                image = new BufferedImage(w, h, 2);
                WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, bands, null);
                image.setData(raster);
            } else {
                boolean hasObjectBehind = true;
                if (h < 20) {
                    hasObjectBehind = true;
                } else if (mode != 0) {
                    hasObjectBehind = this.current.hasObjectsBehind(this.gs.CTM);
                }
                boolean isBlank = false;
                boolean keepNonTransparent = false;
                if (imageMask && d == 1 && decodeColorData.getID() == 1785221209 && maskCol[0] == 0 && maskCol[1] == 0 && maskCol[2] == 0) {
                    isBlank = true;
                    for (int aa = 0; aa < data.length; ++aa) {
                        if (data[aa] == -1) continue;
                        isBlank = false;
                        aa = data.length;
                    }
                    if (this.isPrinting && (mode == 0 || this.isType3Font || d == 1)) {
                        WritableRaster raster = Raster.createPackedRaster(new DataBufferByte(data, data.length), w, h, 1, null);
                        image = new BufferedImage(w, h, 12);
                        image.setData(raster);
                        keepNonTransparent = true;
                    } else if (isBlank) {
                        image = null;
                        removed = true;
                    } else {
                        byte[] newIndex = new byte[]{maskCol[0], maskCol[1], maskCol[2], -1, -1, -1};
                        image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, newIndex, true, true);
                    }
                }
                if (!isBlank) {
                    if (!(this.isPrinting || maskCol[0] != 0 || maskCol[1] != 0 || maskCol[2] != 0 || hasObjectBehind || this.isType3Font || decodeColorData.getID() == 1785221209)) {
                        if (d == 1) {
                            WritableRaster raster = Raster.createPackedRaster(new DataBufferByte(data, data.length), w, h, 1, null);
                            image = new BufferedImage(w, h, 12);
                            image.setData(raster);
                        } else {
                            int[] bands = new int[]{0};
                            WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(data, data.length), w, h, w, 1, bands, null);
                            image = new BufferedImage(w, h, 10);
                            image.setData(raster);
                        }
                    } else if (!keepNonTransparent) {
                        if (d == 8 && isDownsampled) {
                            byte[] newIndex = new byte[]{maskCol[0], maskCol[1], maskCol[2], -1, -1, -1};
                            image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, newIndex, true, true);
                        } else if (w < 4000 && h < 4000 || hasObjectBehind) {
                            byte[] newIndex = new byte[]{maskCol[0], maskCol[1], maskCol[2], -1, -1, -1};
                            image = ColorSpaceConvertor.convertIndexedToFlat(1, w, h, data, newIndex, true, false);
                        }
                    }
                }
            }
        } else if (Filters == null) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Image " + name + ' ' + w + "W * " + h + "H with No Compression at BPC " + d);
            }
            image = this.makeImage(decodeColorData, w, h, d, data, compCount, XObject2);
        } else if (isDCT) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("JPeg Image " + name + ' ' + w + "W * " + h + 'H' + " arrayInverted=" + arrayInverted);
            }
            if (colorspaceID == 1498837125 && this.extractRawCMYK) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Raw CMYK image " + name + " saved.");
                }
                if (!this.objectStoreStreamRef.saveRawCMYKImage(data, name)) {
                    this.errorTracker.addPageFailureMessage("Problem saving Raw CMYK image " + name);
                }
            }
            boolean decodedOnAltColorspace = false;
            if (decodeColorData.getID() == 1247168582) {
                int alt = decodeColorData.getAlternateColorSpace();
                GenericColorSpace altDecodeColorData = null;
                if (alt == 1785221209) {
                    altDecodeColorData = new DeviceRGBColorSpace();
                } else if (alt == 1498837125) {
                    altDecodeColorData = new DeviceCMYKColorSpace();
                }
                if (altDecodeColorData != null) {
                    try {
                        image = altDecodeColorData.JPEGToRGBImage(data, w, h, decodeArray, pX, pY, arrayInverted, XObject2);
                        if (image != null) {
                            decodedOnAltColorspace = true;
                            decodeColorData = altDecodeColorData;
                            if (decodeColorData.isImageYCCK()) {
                                this.hasYCCKimages = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        this.errorTracker.addPageFailureMessage("Unable to use alt colorspace with " + name + " to JPEG");
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                        image.flush();
                        image = null;
                    }
                }
            }
            if (!decodedOnAltColorspace) {
                try {
                    image = decodeColorData.JPEGToRGBImage(data, w, h, decodeArray, pX, pY, arrayInverted, XObject2);
                    if (decodeColorData.isImageYCCK()) {
                        this.hasYCCKimages = true;
                    }
                }
                catch (Exception e) {
                    this.errorTracker.addPageFailureMessage("Problem converting " + name + " to JPEG");
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                    image.flush();
                    image = null;
                }
            }
            type = "jpg";
            this.setRotationOptionsOnJPEGImage();
        } else if (isJPX) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("JPeg 2000 Image " + name + ' ' + w + "W * " + h + 'H');
            }
            if (!JAIHelper.isJAIused()) {
                if (System.getProperty("org.jpedal.jai") != null && System.getProperty("org.jpedal.jai").toLowerCase().equals("true")) {
                    if (!ImageCommands.JAImessageShow) {
                        ImageCommands.JAImessageShow = true;
                        System.err.println("JPeg 2000 Images need both JAI and imageio.jar on classpath");
                    }
                    throw new RuntimeException("JPeg 2000 Images need both JAI and imageio.jar on classpath");
                }
                System.err.println("JPeg 2000 Images needs the VM parameter -Dorg.jpedal.jai=true switch turned on");
                throw new RuntimeException("JPeg 2000 Images needs the VM parameter -Dorg.jpedal.jai=true switch turned on");
            }
            image = decodeColorData.JPEG2000ToRGBImage(data, w, h, decodeArray, pX, pY);
            type = "jpg";
            this.setRotationOptionsOnJPEGImage();
        } else {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog(name + ' ' + w + "W * " + h + "H BPC=" + d + ' ' + decodeColorData);
            }
            image = this.makeImage(decodeColorData, w, h, d, data, compCount, XObject2);
            if (d == 8 || this.gs.nonstrokeColorSpace.getID() == 1785221209 || this.gs.nonstrokeColorSpace.getID() == 1247168582) {
                type = "jpg";
            }
        }
        if (image != null) {
            if (newSMask != null && DecodeParms == null) {
                DecodeParms = newSMask.getDictionary(1888135062);
                if (decodeColorData.getID() == 1568372915 && w < newSMask.getInt(959726687) && h < newSMask.getInt(959926393)) {
                    int bytes = data.length;
                    boolean isEmpty = true;
                    for (int aa = 0; aa < bytes; ++aa) {
                        if (data[aa] == 0) continue;
                        isEmpty = false;
                        aa = bytes;
                    }
                    if (isEmpty) {
                        image = new BufferedImage(newSMask.getInt(959726687), newSMask.getInt(959926393), 10);
                    }
                }
            }
            if (newSMask != null) {
                image = this.addSMaskObject(decodeColorData, data, name, w, h, XObject2, isDCT, isJPX, image, DecodeParms, newSMask);
            } else if (newMask != null) {
                image = ImageCommands.addMaskObject(decodeColorData, d, isDCT, isJPX, image, colorspaceID, index, newMask, this.optionsApplied, this.currentPdfFile);
            }
            if (image != null) {
                image = ImageCommands.simulateOverprint(decodeColorData, data, isDCT, isJPX, image, colorspaceID, newMask, newSMask, this.current, this.gs);
            }
            if (image == null) {
                return null;
            }
            if (this.current.getType() != 4 && this.current.getType() != 5 && this.current.getType() != 6 && !this.renderDirectly && (this.finalImagesExtracted || this.rawImagesExtracted) && !this.cache.testIfImageAlreadySaved(XObject2)) {
                this.saveImage(name, this.createScaledVersion, image, type);
            }
        }
        if (image == null && !removed) {
            this.imagesProcessedFully = false;
        }
        if ((TR = this.gs.getTR()) != null) {
            image = ImageCommands.applyTR(image, TR, this.currentPdfFile);
        }
        if (DecodeParms != null && DecodeParms.getInt(1010122310) != -1 && this.current.hasObjectsBehind(this.gs.CTM) && image != null && image.getType() != 2 && (!isDCT || DecodeParms.getInt(862279027) == 0)) {
            image = ImageCommands.makeBlackandWhiteTransparent(image);
        }
        if (pX > 0 && pY > 0 && rawd == 1 && ImageCommands.sharpenDownsampledImages && (decodeColorData.getID() == 1568372915 || decodeColorData.getID() == 1785221209)) {
            Kernel kernel = new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
            ConvolveOp op = new ConvolveOp(kernel);
            image = op.filter(image, null);
        }
        ++this.imageCount;
        if (mode == 0 && this.isPrinting && image != null && d == 1 && maskCol != null && maskCol[0] == 0 && maskCol[1] == 0 && maskCol[2] == 0 && maskCol[3] == 0) {
            int iw = image.getWidth();
            int ih = image.getHeight();
            BufferedImage newImage = new BufferedImage(iw, ih, 10);
            newImage.getGraphics().setColor(Color.WHITE);
            newImage.getGraphics().fillRect(0, 0, iw, ih);
            newImage.getGraphics().drawImage(image, 0, 0, null);
            image = newImage;
        }
        return image;
    }

    private void setRotationOptionsOnJPEGImage() {
        if (this.imageStatus > 0 && this.gs.CTM[0][0] > 0.0f && this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][1] > 0.0f && this.gs.CTM[1][0] < 0.0f) {
            if (this.imageStatus == 1) {
                this.gs.CTM[0][1] = -this.gs.CTM[0][1];
                this.gs.CTM[1][1] = -this.gs.CTM[1][1];
                this.gs.CTM[2][1] = this.gs.CTM[2][1] - this.gs.CTM[1][1];
            } else if (this.imageStatus == 2) {
                ++this.optionsApplied;
            }
        } else if (this.optionsApplied > 0 && this.gs.CTM[0][0] < 0.0f && this.gs.CTM[1][1] < 0.0f && this.gs.CTM[0][1] == 0.0f && this.gs.CTM[1][0] == 0.0f) {
            this.gs.CTM[1][1] = -this.gs.CTM[1][1];
            this.gs.CTM[2][1] = this.gs.CTM[2][1] - this.gs.CTM[1][1] + this.gs.CTM[1][0];
            this.gs.CTM[2][0] = this.gs.CTM[2][0] - this.gs.CTM[0][1];
        }
    }

    private void saveImage(String name, boolean createScaledVersion, BufferedImage image, String type) {
        if (image != null && image.getSampleModel().getNumBands() == 1) {
            type = "tif";
        }
        if (this.isPageContent && (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted)) {
            this.objectStoreStreamRef.saveStoredImage(name, ImageCommands.addBackgroundToMask(image, this.isMask), false, createScaledVersion, type);
        }
    }

    private BufferedImage makeImage(GenericColorSpace decodeColorData, int w, int h, int d, byte[] data, int comp, PdfObject XObject2) {
        BufferedImage image;
        block59: {
            int[] bands;
            byte[] processedData;
            boolean isRotated;
            if (decodeColorData.getID() == 1568372915) {
                byte[] oldData;
                int requiredSize;
                int oldSize;
                if (d == 1) {
                    oldSize = data.length;
                    requiredSize = (w + 7 >> 3) * h;
                    if (oldSize < requiredSize) {
                        oldData = data;
                        data = new byte[requiredSize];
                        System.arraycopy(oldData, 0, data, 0, oldSize);
                        for (int aa = oldSize; aa < requiredSize; ++aa) {
                            data[aa] = -1;
                        }
                    }
                } else if (d == 8 && (oldSize = data.length) < (requiredSize = w * h)) {
                    oldData = data;
                    data = new byte[requiredSize];
                    System.arraycopy(oldData, 0, data, 0, oldSize);
                }
            }
            ColorSpace cs = decodeColorData.getColorSpace();
            int ID = decodeColorData.getID();
            image = null;
            byte[] index = decodeColorData.getIndexedMap();
            this.optionsApplied = 0;
            boolean isInverted = !this.doNotRotate && this.useHiResImageForDisplay && RenderUtils.isInverted(this.gs.CTM);
            boolean bl = isRotated = !this.doNotRotate && this.useHiResImageForDisplay && RenderUtils.isRotated(this.gs.CTM);
            if (XObject2.getGeneralType(608780341) == 489767739 && this.streamType != 1) {
                isInverted = false;
                isRotated = false;
            }
            if (isInverted) {
                int count = comp;
                if (ID == -2073385820) {
                    count = 1;
                } else if (ID == 960981604) {
                    count = decodeColorData.getColorComponentCount();
                }
                byte[] processedData2 = ImageOps.invertImage(data, w, h, d, count, index);
                if (processedData2 != null) {
                    data = processedData2;
                    ++this.optionsApplied;
                }
            }
            if (isRotated && (processedData = ImageOps.rotateImage(data, w, h, d, comp, index)) != null) {
                data = processedData;
                this.optionsApplied += 2;
                int temp = h;
                h = w;
                w = temp;
            }
            if (index != null) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Indexed " + w + ' ' + h);
                }
                if (!decodeColorData.isIndexConverted()) {
                    index = decodeColorData.convertIndexToRGB(index);
                }
                if (d == 8 && decodeColorData.getIndexSize() == 0 && decodeColorData.getID() == 1785221209) {
                    boolean hasPixels = false;
                    int indexCount = index.length;
                    for (int ii = 0; ii < indexCount; ++ii) {
                        if (index[ii] == 0) continue;
                        hasPixels = true;
                        ii = indexCount;
                    }
                    if (!hasPixels) {
                        int pixelCount = data.length;
                        for (int ii = 0; ii < pixelCount; ++ii) {
                            if (data[ii] == 0) continue;
                            hasPixels = true;
                            ii = pixelCount;
                        }
                    }
                    if (!hasPixels) {
                        return new BufferedImage(1, 1, 2);
                    }
                }
                try {
                    if (d == 1 && index.length == 6 && index[0] == index[3] && index[1] == index[4] && index[2] == index[5]) {
                        image = null;
                        break block59;
                    }
                    if (d == 8 && w == 1 && h == 1 && index[0] == -1 && index[1] == -1 && index[2] == -1 && ImageDecoder.allBytesZero(data)) {
                        image = new BufferedImage(1, 1, 1);
                        image.createGraphics().setPaint(Color.CYAN);
                        Raster raster = ColorSpaceConvertor.createInterleavedRaster(new byte[]{-1, -1, -1}, 1, 1);
                        image.setData(raster);
                        break block59;
                    }
                    image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, index, false, false);
                }
                catch (Exception e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                    break block59;
                }
            }
            if (d == 1) {
                image = new BufferedImage(w, h, 12);
                DataBufferByte db = new DataBufferByte(data, data.length);
                if (decodeColorData.getID() == -2073385820) {
                    int count = data.length;
                    for (int aa = 0; aa < count; ++aa) {
                        data[aa] = (byte)(data[aa] ^ 0xFF);
                    }
                }
                WritableRaster raster = Raster.createPackedRaster(db, w, h, d, null);
                image.setData(raster);
            } else if (ID == -2073385820 || ID == 960981604) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
                }
                image = decodeColorData.dataToRGB(data, w, h);
            } else if (comp == 4) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Converting ICC/CMYK colorspace to sRGB ");
                }
                image = ColorSpaceConvertor.convertFromICCCMYK(w, h, data);
            } else if (comp == 3) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Converting 3 comp colorspace to sRGB index=" + index);
                }
                if (w * h == data.length) {
                    if (d == 8 && index != null) {
                        image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, index, false, false);
                    } else {
                        DataBufferByte db = new DataBufferByte(data, data.length);
                        bands = new int[]{0};
                        image = new BufferedImage(w, h, 10);
                        WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w, 1, bands, null);
                        image.setData(raster);
                    }
                } else {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Converting data to sRGB ");
                    }
                    if (d == 4) {
                        int origSize = data.length;
                        int newSize = w * h * 3;
                        boolean isOdd = (w & 1) == 1;
                        int scanLine = w * 3 + 1 >> 1;
                        byte[] newData = new byte[newSize];
                        int ptr = 0;
                        int currentLine = 0;
                        for (int ii = 0; ii < origSize; ++ii) {
                            byte rawByte = data[ii];
                            ++currentLine;
                            newData[ptr] = (byte)(rawByte & 0xF0);
                            if (newData[ptr] == -16) {
                                newData[ptr] = -1;
                            }
                            ++ptr;
                            if (currentLine == scanLine && isOdd) {
                                currentLine = 0;
                            } else {
                                newData[ptr] = (byte)((rawByte & 0xF) << 4);
                                if (newData[ptr] == -16) {
                                    newData[ptr] = -1;
                                }
                                ++ptr;
                            }
                            if (ptr != newSize) continue;
                            ii = origSize;
                        }
                        data = newData;
                    }
                    image = new BufferedImage(w, h, 1);
                    data = ImageOps.checkSize(data, w, h, 3);
                    Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, w, h);
                    image.setData(raster);
                }
            } else if (comp == 1) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("comp=1 and d= " + d);
                }
                if (d != 8) {
                    int newSize = w * h;
                    byte[] newData = new byte[newSize];
                    switch (d) {
                        case 2: {
                            ColorSpaceConvertor.flatten2bpc(w, data, null, false, newSize, newData);
                            break;
                        }
                        case 4: {
                            ColorSpaceConvertor.flatten4bpc(w, data, newSize, newData);
                            break;
                        }
                        default: {
                            if (!LogWriter.isOutput()) break;
                            LogWriter.writeLog("unknown comp= " + d);
                        }
                    }
                    data = newData;
                }
                DataBufferByte db = new DataBufferByte(data, data.length);
                bands = new int[]{0};
                image = new BufferedImage(w, h, 10);
                WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w, 1, bands, null);
                image.setData(raster);
            } else if (LogWriter.isOutput()) {
                LogWriter.writeLog("Image " + cs.getType() + " not currently supported with components " + comp);
            }
        }
        return image;
    }

    private static boolean allBytesZero(byte[] data) {
        boolean allZero = true;
        for (byte bytes : data) {
            if (bytes == 0) continue;
            allZero = false;
            break;
        }
        return allZero;
    }

    private BufferedImage addSMaskObject(GenericColorSpace decodeColorData, byte[] data, String name, int w, int h, PdfObject XObject2, boolean isDCT, boolean isJPX, BufferedImage image, PdfObject DecodeParms, PdfObject newSMask) throws PdfException {
        byte[] objectData = this.currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(this.currentPdfFile.getObjectReader()));
        if (objectData != null) {
            boolean ignoreMask = DecodeParms != null && DecodeParms.getInt(1010783618) != -1 && DecodeParms.getInt(1970893723) != 15 && decodeColorData.getID() != 1247168582;
            PdfObject maskColorSpace = newSMask.getDictionary(2087749783);
            if (ignoreMask && (decodeColorData.getID() == 1785221209 || decodeColorData.getID() == 1498837125) && maskColorSpace.getParameterConstant(2087749783) == 1568372915) {
                ignoreMask = false;
            }
            if (isDCT && maskColorSpace.getParameterConstant(2087749783) == 1568372915) {
                int len = objectData.length;
                ignoreMask = true;
                for (int aa = 0; aa < len; ++aa) {
                    if (objectData[aa] == -1) continue;
                    ignoreMask = false;
                    aa = len;
                }
            }
            if (!ignoreMask) {
                int rawOptions = this.optionsApplied;
                if (this.optionsApplied == 0) {
                    this.doNotRotate = true;
                }
                int maskW = newSMask.getInt(959726687);
                int maskH = newSMask.getInt(959926393);
                boolean isWhiteAndDownscaled = false;
                boolean isIndexed = false;
                if (isWhiteAndDownscaled) {
                    PdfObject XObjectColorSpace = XObject2.getDictionary(2087749783);
                    PdfArrayIterator maskFilters = newSMask.getMixedArray(1011108731);
                    boolean isJBIG2 = false;
                    if (XObjectColorSpace.getParameterConstant(2087749783) == 1785221209 && maskFilters != null && maskFilters.hasMoreTokens()) {
                        while (maskFilters.hasMoreTokens()) {
                            int maskFirstValue = maskFilters.getNextValueAsConstant(true);
                            isJBIG2 = maskFirstValue == 1247500931;
                        }
                    }
                    isIndexed = data.length == 2 && XObjectColorSpace.getParameterConstant(2087749783) == 895578984;
                    boolean bl = isWhiteAndDownscaled = XObjectColorSpace != null && (XObjectColorSpace.getParameterConstant(2087749783) == 1785221209 && (!isDCT || isJBIG2) || isIndexed && XObjectColorSpace.getDictionary(895578984).getParameterConstant(2087749783) == 1785221209) && maskColorSpace.getParameterConstant(2087749783) == 1568372915;
                }
                if (isWhiteAndDownscaled && (isDCT || isJPX || isIndexed)) {
                    int c = objectData.length;
                    for (int ii = 0; ii < c; ++ii) {
                        objectData[ii] = (byte)(-1 - objectData[ii]);
                    }
                    image = this.processImageXObject(newSMask, name, objectData, true, null);
                } else {
                    BufferedImage smaskImage = this.processImageXObject(newSMask, name, objectData, true, null);
                    if (this.pageNum > 0 && this.pageData.getRotation(this.pageNum) == 0 && rawOptions == 2) {
                        int width = smaskImage.getWidth();
                        int height = smaskImage.getHeight();
                        BufferedImage biFlip = new BufferedImage(height, width, smaskImage.getType());
                        for (int i = 0; i < width; ++i) {
                            for (int j = 0; j < height; ++j) {
                                biFlip.setRGB(height - 1 - j, i, smaskImage.getRGB(i, j));
                            }
                        }
                        smaskImage = biFlip;
                    }
                    this.doNotRotate = false;
                    this.optionsApplied = rawOptions;
                    if (smaskImage != null) {
                        image = ImageCommands.applySmask(image, smaskImage, newSMask, false, decodeColorData.getID() == 1785221209, newSMask.getDictionary(2087749783), XObject2, this.gs);
                        smaskImage.flush();
                    }
                }
            }
        }
        return image;
    }
}

