/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Shape;
import java.awt.geom.Area;
import org.jpedal.io.PdfArray;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.LayerDecoder;
import org.jpedal.render.DynamicVectorRenderer;

public class ShapeCommands {
    static Shape B(boolean isStar, boolean isLowerCase, GraphicsState gs, int formLevel, PdfShape currentDrawShape, LayerDecoder layerDecoder, boolean renderPage, DynamicVectorRenderer current) {
        Shape currentShape = null;
        if (layerDecoder.isLayerVisible()) {
            if (isStar) {
                currentDrawShape.setEVENODDWindingRule();
            } else {
                currentDrawShape.setNONZEROWindingRule();
            }
            if (isLowerCase) {
                currentDrawShape.closeShape();
            }
            if ((currentShape = currentDrawShape.generateShapeFromPath(gs.CTM, gs.getLineWidth(), 66, current.getType())) != null && currentShape.getBounds2D().getWidth() < 1.0 && currentShape.getBounds2D().getHeight() < 1.0) {
                return null;
            }
            if (!isLowerCase && formLevel > 0 && currentShape != null && gs.getClippingShape() != null && gs.nonstrokeColorSpace.getID() == 1498837125 && gs.nonstrokeColorSpace.getColor().getRGB() == -1) {
                Area a = gs.getClippingShape();
                a.subtract(new Area(currentShape));
                currentShape = a;
            }
            if (renderPage && currentShape != null) {
                gs.setStrokeColor(gs.strokeColorSpace.getColor());
                gs.setNonstrokeColor(gs.nonstrokeColorSpace.getColor());
                if (gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && gs.getAlpha(1) == 0.0f) {
                    gs.setFillType(1);
                } else {
                    gs.setFillType(3);
                }
                current.drawShape(currentShape, gs, 66);
            }
        }
        currentDrawShape.setClip(false);
        currentDrawShape.resetPath();
        return currentShape;
    }

    static void D(CommandParser parser, GraphicsState gs) {
        String values = "";
        int items = parser.getOperandCount();
        if (items == 1) {
            values = parser.generateOpAsString(0, false);
        } else {
            for (int i = items - 1; i > -1; --i) {
                values = values + parser.generateOpAsString(i, false);
                values = values + ' ';
            }
        }
        if (values.equals("[ ] 0 ") || values.equals("[]0") || values.equals("[] 0 ")) {
            gs.setDashPhase(0);
            gs.setDashArray(new float[0]);
        } else {
            int pointer = values.indexOf(93);
            String dash = values.substring(0, pointer);
            int phase = (int)Float.parseFloat(values.substring(pointer + 1, values.length()).trim());
            float[] dash_array = PdfArray.convertToFloatArray(dash);
            for (int aa = 0; aa < dash_array.length; ++aa) {
                if (!((double)dash_array[aa] < 0.001)) continue;
                dash_array[aa] = 0.0f;
            }
            gs.setDashArray(dash_array);
            gs.setDashPhase(phase);
        }
    }

    static void J(boolean isLowerCase, int value, GraphicsState gs) {
        int style = 0;
        if (!isLowerCase) {
            if (value == 0) {
                style = 0;
            }
            if (value == 1) {
                style = 1;
            }
            if (value == 2) {
                style = 2;
            }
            gs.setJoinStyle(style);
        } else {
            if (value == 0) {
                style = 0;
            }
            if (value == 1) {
                style = 1;
            }
            if (value == 2) {
                style = 2;
            }
            gs.setCapStyle(style);
        }
    }

    static void N(PdfShape currentDrawShape, GraphicsState gs, int formLevel, Shape defaultClip, boolean renderPage, DynamicVectorRenderer current, PdfPageData pageData, int pageNum) {
        if (currentDrawShape.isClip()) {
            currentDrawShape.closeShape();
            Shape s = currentDrawShape.generateShapeFromPath(gs.CTM, 0.0f, 110, current.getType());
            if (currentDrawShape.getComplexClipCount() < 5) {
                if (currentDrawShape.getSegmentCount() > 5000) {
                    s = s.getBounds();
                }
            } else if (currentDrawShape.getSegmentCount() > 2500) {
                s = s.getBounds();
            }
            Area newClip = new Area(s);
            gs.updateClip(newClip);
            if (formLevel == 0) {
                gs.checkWholePageClip(pageData.getMediaBoxHeight(pageNum) + pageData.getMediaBoxY(pageNum));
            }
            currentDrawShape.setClip(false);
            if (renderPage) {
                current.drawClip(gs, defaultClip, false);
            }
        }
        currentDrawShape.resetPath();
    }

    static Shape S(boolean isLowerCase, LayerDecoder layerDecoder, GraphicsState gs, PdfShape currentDrawShape, DynamicVectorRenderer current, boolean renderPage) {
        Shape currentShape = null;
        if (layerDecoder.isLayerVisible()) {
            Area crop;
            if (isLowerCase) {
                currentDrawShape.closeShape();
            }
            if ((currentShape = currentDrawShape.generateShapeFromPath(gs.CTM, gs.getLineWidth(), 83, current.getType())) != null && (crop = gs.getClippingShape()) != null && (crop.getBounds().getWidth() == 0.0 || crop.getBounds().getHeight() == 0.0)) {
                currentShape = null;
            }
            if (currentShape != null) {
                if (currentShape.getBounds().getWidth() <= 1.0) {
                    currentShape = currentShape.getBounds2D();
                }
                if (renderPage) {
                    gs.setStrokeColor(gs.strokeColorSpace.getColor());
                    gs.setNonstrokeColor(gs.nonstrokeColorSpace.getColor());
                    gs.setFillType(1);
                    current.drawShape(currentShape, gs, 83);
                }
            }
        }
        currentDrawShape.setClip(false);
        currentDrawShape.resetPath();
        return currentShape;
    }
}

