/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;

public final class P11Util {
    private static Object LOCK = new Object();
    private static volatile Provider sun;
    private static volatile Provider sunRsaSign;
    private static volatile Provider sunJce;
    private static final char[] hexDigits;

    private P11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunProvider() {
        Provider p = sun;
        if (p == null) {
            Object object = LOCK;
            synchronized (object) {
                sun = p = P11Util.getProvider(sun, "SUN", "sun.security.provider.Sun");
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunRsaSignProvider() {
        Provider p = sunRsaSign;
        if (p == null) {
            Object object = LOCK;
            synchronized (object) {
                sunRsaSign = p = P11Util.getProvider(sunRsaSign, "SunRsaSign", "sun.security.rsa.SunRsaSign");
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunJceProvider() {
        Provider p = sunJce;
        if (p == null) {
            Object object = LOCK;
            synchronized (object) {
                sunJce = p = P11Util.getProvider(sunJce, "SunJCE", "com.sun.crypto.provider.SunJCE");
            }
        }
        return p;
    }

    private static Provider getProvider(Provider p, String providerName, String className) {
        if (p != null) {
            return p;
        }
        p = Security.getProvider(providerName);
        if (p == null) {
            try {
                Class<?> clazz = Class.forName(className);
                p = (Provider)clazz.newInstance();
            }
            catch (Exception e) {
                throw new ProviderException("Could not find provider " + providerName, e);
            }
        }
        return p;
    }

    static byte[] convert(byte[] input, int offset, int len) {
        if (offset == 0 && len == input.length) {
            return input;
        }
        byte[] t = new byte[len];
        System.arraycopy(input, offset, t, 0, len);
        return t;
    }

    static byte[] subarray(byte[] b, int ofs, int len) {
        byte[] out = new byte[len];
        System.arraycopy(b, ofs, out, 0, len);
        return out;
    }

    static byte[] concat(byte[] b1, byte[] b2) {
        byte[] b = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, b1.length, b2.length);
        return b;
    }

    static long[] concat(long[] b1, long[] b2) {
        if (b1.length == 0) {
            return b2;
        }
        long[] b = new long[b1.length + b2.length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, b1.length, b2.length);
        return b;
    }

    public static byte[] getMagnitude(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int n = b.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(b, 1, newarray, 0, n);
            b = newarray;
        }
        return b;
    }

    static byte[] getBytesUTF8(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] sha1(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(data);
            return md.digest();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }

    static String toString(byte[] b) {
        if (b == null) {
            return "(null)";
        }
        StringBuffer sb = new StringBuffer(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            int k = b[i] & 0xFF;
            if (i != 0) {
                sb.append(':');
            }
            sb.append(hexDigits[k >>> 4]);
            sb.append(hexDigits[k & 0xF]);
        }
        return sb.toString();
    }

    static {
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

