/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

abstract class BMContext
implements CompositeContext {
    float alpha;

    BMContext(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        if (src.getSampleModel().getDataType() != 3 || dstIn.getSampleModel().getDataType() != 3 || dstOut.getSampleModel().getDataType() != 3) {
            throw new IllegalStateException("Source and destination must store pixels as INT.");
        }
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int[] srcPixel = new int[4];
        int[] dstPixel = new int[4];
        int[] srcPixels = new int[width];
        int[] dstPixels = new int[width];
        for (int y = 0; y < height; ++y) {
            src.getDataElements(0, y, width, 1, srcPixels);
            dstIn.getDataElements(0, y, width, 1, dstPixels);
            for (int x = 0; x < width; ++x) {
                int pixel = srcPixels[x];
                srcPixel[0] = pixel >> 16 & 0xFF;
                srcPixel[1] = pixel >> 8 & 0xFF;
                srcPixel[2] = pixel & 0xFF;
                srcPixel[3] = pixel >> 24 & 0xFF;
                pixel = dstPixels[x];
                dstPixel[0] = pixel >> 16 & 0xFF;
                dstPixel[1] = pixel >> 8 & 0xFF;
                dstPixel[2] = pixel & 0xFF;
                dstPixel[3] = pixel >> 24 & 0xFF;
                int[] result = this.blend(srcPixel, dstPixel);
                this.alpha = (float)result[3] / 255.0f;
                dstPixels[x] = ((int)((float)dstPixel[3] + (float)(result[3] - dstPixel[3]) * this.alpha) & 0xFF) << 24 | ((int)((float)dstPixel[0] + (float)(result[0] - dstPixel[0]) * this.alpha) & 0xFF) << 16 | ((int)((float)dstPixel[1] + (float)(result[1] - dstPixel[1]) * this.alpha) & 0xFF) << 8 | (int)((float)dstPixel[2] + (float)(result[2] - dstPixel[2]) * this.alpha) & 0xFF;
            }
            dstOut.setDataElements(0, y, width, 1, dstPixels);
        }
    }

    int[] blend(int[] srcPixel, int[] dstPixel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

