/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.BaseWatchable;
import com.sun.pdfview.ImageInfo;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.PDFRenderer;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Cache {
    private Map<Integer, SoftReference> pages = Collections.synchronizedMap(new HashMap());

    public void addPage(Integer n, PDFPage pDFPage) {
        this.addPageRecord(n, pDFPage, null);
    }

    public void addPage(Integer n, PDFPage pDFPage, PDFParser pDFParser) {
        this.addPageRecord(n, pDFPage, pDFParser);
    }

    public void addImage(PDFPage pDFPage, ImageInfo imageInfo, BufferedImage bufferedImage) {
        this.addImageRecord(pDFPage, imageInfo, bufferedImage, null);
    }

    public void addImage(PDFPage pDFPage, ImageInfo imageInfo, BufferedImage bufferedImage, PDFRenderer pDFRenderer) {
        this.addImageRecord(pDFPage, imageInfo, bufferedImage, pDFRenderer);
    }

    public PDFPage getPage(Integer n) {
        PageRecord pageRecord = this.getPageRecord(n);
        if (pageRecord != null) {
            return (PDFPage)pageRecord.value;
        }
        return null;
    }

    public PDFParser getPageParser(Integer n) {
        PageRecord pageRecord = this.getPageRecord(n);
        if (pageRecord != null) {
            return (PDFParser)pageRecord.generator;
        }
        return null;
    }

    public BufferedImage getImage(PDFPage pDFPage, ImageInfo imageInfo) {
        Record record = this.getImageRecord(pDFPage, imageInfo);
        if (record != null) {
            return (BufferedImage)record.value;
        }
        return null;
    }

    public PDFRenderer getImageRenderer(PDFPage pDFPage, ImageInfo imageInfo) {
        Record record = this.getImageRecord(pDFPage, imageInfo);
        if (record != null) {
            return (PDFRenderer)record.generator;
        }
        return null;
    }

    public void removePage(Integer n) {
        this.removePageRecord(n);
    }

    public void removeImage(PDFPage pDFPage, ImageInfo imageInfo) {
        this.removeImageRecord(pDFPage, imageInfo);
    }

    PageRecord addPageRecord(Integer n, PDFPage pDFPage, PDFParser pDFParser) {
        PageRecord pageRecord = new PageRecord();
        pageRecord.value = pDFPage;
        pageRecord.generator = pDFParser;
        this.pages.put(n, new SoftReference<PageRecord>(pageRecord));
        return pageRecord;
    }

    PageRecord getPageRecord(Integer n) {
        SoftReference softReference = this.pages.get(n);
        if (softReference != null) {
            String string = softReference.get() == null ? " not in " : " in ";
            return (PageRecord)softReference.get();
        }
        return null;
    }

    PageRecord removePageRecord(Integer n) {
        SoftReference softReference = this.pages.remove(n);
        if (softReference != null) {
            return (PageRecord)softReference.get();
        }
        return null;
    }

    Record addImageRecord(PDFPage pDFPage, ImageInfo imageInfo, BufferedImage bufferedImage, PDFRenderer pDFRenderer) {
        Integer n = new Integer(pDFPage.getPageNumber());
        PageRecord pageRecord = this.getPageRecord(n);
        if (pageRecord == null) {
            pageRecord = this.addPageRecord(n, pDFPage, null);
        }
        Record record = new Record();
        record.value = bufferedImage;
        record.generator = pDFRenderer;
        pageRecord.images.put(imageInfo, new SoftReference<Record>(record));
        return record;
    }

    Record getImageRecord(PDFPage pDFPage, ImageInfo imageInfo) {
        SoftReference<Record> softReference;
        Integer n = new Integer(pDFPage.getPageNumber());
        PageRecord pageRecord = this.getPageRecord(n);
        if (pageRecord != null && (softReference = pageRecord.images.get(imageInfo)) != null) {
            String string = softReference.get() == null ? " not in " : " in ";
            return softReference.get();
        }
        return null;
    }

    Record removeImageRecord(PDFPage pDFPage, ImageInfo imageInfo) {
        SoftReference<Record> softReference;
        Integer n = new Integer(pDFPage.getPageNumber());
        PageRecord pageRecord = this.getPageRecord(n);
        if (pageRecord != null && (softReference = pageRecord.images.remove(imageInfo)) != null) {
            return softReference.get();
        }
        return null;
    }

    class PageRecord
    extends Record {
        Map<ImageInfo, SoftReference<Record>> images;

        public PageRecord() {
            this.images = Collections.synchronizedMap(new HashMap());
        }
    }

    class Record {
        Object value;
        BaseWatchable generator;

        Record() {
        }
    }
}

