/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PageChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class ThumbPanel
extends JPanel
implements Runnable,
Scrollable,
ImageObserver {
    PDFFile file;
    Image[] images;
    int border = 2;
    int lineheight = 96 + this.border;
    int defaultWidth = (this.lineheight - this.border) * 4 / 3;
    int[] xloc;
    Thread anim;
    int showing = -1;
    int needdrawn = -1;
    boolean defaultNotSet = true;
    PageChangeListener listener;

    public ThumbPanel(PDFFile pDFFile) {
        this.file = pDFFile;
        if (pDFFile != null) {
            int n = pDFFile.getNumPages();
            this.images = new Image[n];
            this.xloc = new int[n];
            this.setPreferredSize(new Dimension(this.defaultWidth, 200));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ThumbPanel.this.handleClick(mouseEvent.getX(), mouseEvent.getY());
                }
            });
            this.anim = new Thread(this);
            this.anim.setName(this.getClass().getName());
            this.anim.start();
        } else {
            this.images = new Image[0];
            this.setPreferredSize(new Dimension(this.defaultWidth, 200));
        }
    }

    @Override
    public void run() {
        int n = 0;
        while (this.anim == Thread.currentThread()) {
            int n2;
            if (this.needdrawn >= 0) {
                n = this.needdrawn;
                this.needdrawn = -1;
            }
            for (n2 = this.images.length; n2 > 0 && this.images[n] != null; --n2) {
                if (++n < this.images.length) continue;
                n = 0;
            }
            if (n2 == 0) break;
            try {
                Image image;
                int n3 = n + 1;
                PDFPage pDFPage = this.file.getPage(n3, true);
                int n4 = (int)Math.ceil((float)(this.lineheight - this.border) * pDFPage.getAspectRatio());
                int n5 = n;
                this.images[n5] = image = pDFPage.getImage(n4, this.lineheight - this.border, null, this, true, true);
                if (this.defaultNotSet) {
                    this.defaultNotSet = false;
                    this.setDefaultWidth(n4);
                }
                this.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                int n6 = this.lineheight - this.border;
                this.images[n] = new BufferedImage(n6, n6, 12);
            }
        }
    }

    public void addPageChangeListener(PageChangeListener pageChangeListener) {
        this.listener = pageChangeListener;
    }

    public void removePageChangeListener(PageChangeListener pageChangeListener) {
        this.listener = null;
    }

    public void stop() {
        this.anim = null;
    }

    public void setDefaultWidth(int n) {
        this.defaultWidth = n;
    }

    public void handleClick(int n, int n2) {
        int n3 = -1;
        int n4 = n2 / this.lineheight;
        for (int i = 0; i < this.xloc.length; ++i) {
            if (this.xloc[i] == 0) {
                ++n3;
            }
            if (n4 != n3 || this.xloc[i] + (this.images[i] != null ? this.images[i].getWidth(null) : this.defaultWidth) <= n) continue;
            this.showPage(i);
            break;
        }
    }

    public void pageShown(int n) {
        if (this.showing != n) {
            if (n >= 0 && this.getParent() instanceof JViewport) {
                int n2 = -this.lineheight;
                for (int i = 0; i <= n; ++i) {
                    if (this.xloc[i] != 0) continue;
                    n2 += this.lineheight;
                }
                Rectangle rectangle = new Rectangle(this.xloc[n], n2, this.images[n] == null ? this.defaultWidth : this.images[n].getWidth(null), this.lineheight);
                this.scrollRectToVisible(rectangle);
            }
            this.showing = n;
            this.repaint();
        }
    }

    public void showPage(int n) {
        this.pageShown(n);
        SwingUtilities.invokeLater(new GotoLater(n));
    }

    @Override
    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(Color.gray);
        int n4 = this.getWidth();
        graphics.fillRect(0, 0, n4, this.getHeight());
        for (int i = 0; i < this.images.length; ++i) {
            int n5 = this.defaultWidth + 2;
            if (this.images[i] != null) {
                n5 = this.images[i].getWidth(null) + 2;
            }
            if (n + n5 > n4 && n != 0) {
                n = 0;
                n2 += this.lineheight;
            }
            if (rectangle.intersects(new Rectangle(n, n2, n5, this.lineheight))) {
                if (this.images[i] != null) {
                    graphics.drawImage(this.images[i], n + 1, n2 + 1, this);
                } else {
                    if (this.needdrawn == -1) {
                        this.needdrawn = i;
                    }
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(n + 1, n2 + 1, n5 - this.border, this.lineheight - this.border);
                    graphics.setColor(Color.darkGray);
                    graphics.drawRect(n + 1, n2 + 1, n5 - this.border - 1, this.lineheight - this.border - 1);
                }
                if (i == this.showing) {
                    graphics.setColor(Color.red);
                    graphics.drawRect(n, n2, n5 - 1, this.lineheight - 1);
                    graphics.drawRect(n + 1, n2 + 1, n5 - 3, this.lineheight - 3);
                }
            }
            this.xloc[i] = n;
            if ((n += n5) <= n3) continue;
            n3 = n;
        }
        if (n3 == 0) {
            n3 = this.defaultWidth;
        }
        Dimension dimension = this.getPreferredSize();
        if (dimension.height != n2 + this.lineheight || dimension.width != n3) {
            this.setPreferredSize(new Dimension(n3, n2 + this.lineheight));
            this.revalidate();
        }
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xE0) == 0;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return Math.max(this.lineheight, rectangle.height / this.lineheight * this.lineheight);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.lineheight;
    }

    class GotoLater
    implements Runnable {
        int page;

        public GotoLater(int n) {
            this.page = n;
        }

        @Override
        public void run() {
            if (ThumbPanel.this.listener != null) {
                ThumbPanel.this.listener.gotoPage(this.page);
            }
        }
    }
}

