/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.colorspace;

import com.sun.pdfview.PDFObject;
import java.awt.color.ColorSpace;
import java.io.IOException;

public class CalGrayColor
extends ColorSpace {
    float[] white = new float[]{1.0f, 1.0f, 1.0f};
    float[] black = new float[]{0.0f, 0.0f, 0.0f};
    float gamma = 1.0f;
    static ColorSpace cie = ColorSpace.getInstance(1000);

    public CalGrayColor(PDFObject pDFObject) throws IOException {
        super(6, 1);
        PDFObject pDFObject2;
        int n;
        PDFObject pDFObject3 = pDFObject.getDictRef("WhitePoint");
        if (pDFObject3 != null) {
            for (n = 0; n < 3; ++n) {
                this.white[n] = pDFObject3.getAt(n).getFloatValue();
            }
        }
        if ((pDFObject3 = pDFObject.getDictRef("BlackPoint")) != null) {
            for (n = 0; n < 3; ++n) {
                this.black[n] = pDFObject3.getAt(n).getFloatValue();
            }
        }
        if ((pDFObject2 = pDFObject.getDictRef("Gamma")) != null) {
            this.gamma = pDFObject2.getFloatValue();
        }
    }

    public CalGrayColor() {
        super(6, 1);
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        if (fArray.length == 1) {
            float f = (float)Math.pow(fArray[0], this.gamma);
            float[] fArray2 = new float[]{this.white[0] * f, 0.0f, 0.0f};
            float[] fArray3 = cie.fromCIEXYZ(fArray2);
            return fArray3;
        }
        return this.black;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        return new float[1];
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return new float[1];
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return new float[3];
    }
}

