/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.font.OutlineFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.ttf.CMap;
import com.sun.pdfview.font.ttf.CMapFormat0;
import com.sun.pdfview.font.ttf.CMapFormat4;
import com.sun.pdfview.font.ttf.CmapTable;
import com.sun.pdfview.font.ttf.HeadTable;
import com.sun.pdfview.font.ttf.HmtxTable;
import com.sun.pdfview.font.ttf.NameTable;
import com.sun.pdfview.font.ttf.PostTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.OpenType;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class NativeFont
extends OutlineFont {
    protected static final char[] controlChars = new char[]{'\t', '\n', '\r'};
    protected static final short[] mapIDs = new short[]{3, 1, 0, 0, 0, 3, 1, 0};
    private Font f;
    private FontRenderContext basecontext = new FontRenderContext(new AffineTransform(), true, true);
    private CmapTable cmapTable;
    private PostTable postTable;
    private int unitsPerEm;
    private HmtxTable hmtxTable;

    public NativeFont(String string, PDFObject pDFObject, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFObject, pDFFontDescriptor);
        String string2 = pDFFontDescriptor.getFontName();
        PDFObject pDFObject2 = pDFFontDescriptor.getFontFile2();
        if (pDFObject2 != null) {
            byte[] byArray = pDFObject2.getStream();
            try {
                this.setFont(byArray);
            }
            catch (FontFormatException fontFormatException) {
                throw new PDFParseException("Font format exception: " + fontFormatException);
            }
        } else {
            int n;
            int n2 = pDFFontDescriptor.getFlags();
            int n3 = n = (n2 & 0x40000) != 0 ? 1 : 0;
            if (string2.indexOf("Bold") > 0) {
                n |= 1;
            }
            if (pDFFontDescriptor.getItalicAngle() != 0) {
                n |= 2;
            }
            if ((n2 & 1) != 0) {
                this.setFont(new Font("Monospaced", n, 1));
            } else if ((n2 & 2) != 0) {
                this.setFont(new Font("Serif", n, 1));
            } else {
                this.setFont(new Font("Sans-serif", n, 1));
            }
        }
    }

    @Override
    protected GeneralPath getOutline(String string, float f) {
        if (this.postTable != null && this.cmapTable != null) {
            CMap cMap;
            short s = this.postTable.getGlyphNameIndex(string);
            if (s == 0) {
                return null;
            }
            char c = '\u0000';
            for (int i = 0; i < mapIDs.length && ((cMap = this.cmapTable.getCMap(mapIDs[i], mapIDs[i + 1])) == null || (c = cMap.reverseMap(s)) == '\u0000'); i += 2) {
            }
            return this.getOutline(c, f);
        }
        return null;
    }

    @Override
    protected GeneralPath getOutline(char c, float f) {
        if (!this.f.canDisplay(c) && this.f.canDisplay((char)(c + 61440))) {
            c = (char)(c + 61440);
        }
        for (int i = 0; i < controlChars.length; ++i) {
            if (controlChars[i] != c) continue;
            c = (char)(0xF000 | c);
            break;
        }
        char[] cArray = new char[]{c};
        GlyphVector glyphVector = this.f.createGlyphVector(this.basecontext, cArray);
        GeneralPath generalPath = new GeneralPath(glyphVector.getGlyphOutline(0));
        CMap cMap = this.cmapTable.getCMap(mapIDs[0], mapIDs[1]);
        char c2 = cMap.map(c);
        float f2 = (float)this.hmtxTable.getAdvance(c2) / (float)this.unitsPerEm;
        float f3 = f / f2;
        generalPath.transform(AffineTransform.getScaleInstance(f3, -1.0));
        return generalPath;
    }

    protected void setFont(Font font) {
        this.f = font;
        if (font instanceof OpenType) {
            OpenType openType = (OpenType)((Object)font);
            byte[] byArray = openType.getFontTable(1668112752);
            byte[] byArray2 = openType.getFontTable(1886352244);
            TrueTypeFont trueTypeFont = new TrueTypeFont(65536);
            this.cmapTable = (CmapTable)TrueTypeTable.createTable(trueTypeFont, "cmap", ByteBuffer.wrap(byArray));
            trueTypeFont.addTable("cmap", this.cmapTable);
            this.postTable = (PostTable)TrueTypeTable.createTable(trueTypeFont, "post", ByteBuffer.wrap(byArray2));
            trueTypeFont.addTable("post", this.postTable);
        }
    }

    protected void setFont(byte[] byArray) throws FontFormatException, IOException {
        Object object;
        try {
            object = TrueTypeFont.parseFont(byArray);
            this.cmapTable = (CmapTable)((TrueTypeFont)object).getTable("cmap");
            this.postTable = (PostTable)((TrueTypeFont)object).getTable("post");
            this.hmtxTable = (HmtxTable)((TrueTypeFont)object).getTable("hmtx");
            HeadTable headTable = (HeadTable)((TrueTypeFont)object).getTable("head");
            this.unitsPerEm = headTable.getUnitsPerEm();
            NameTable nameTable = null;
            try {
                nameTable = (NameTable)((TrueTypeFont)object).getTable("name");
            }
            catch (Exception exception) {
                System.out.println("Error reading name table for font " + this.getBaseFont() + ".  Repairing!");
            }
            boolean bl = this.fixNameTable((TrueTypeFont)object, nameTable);
            boolean bl2 = this.fixCMapTable((TrueTypeFont)object, this.cmapTable);
            if (bl || bl2) {
                byArray = ((TrueTypeFont)object).writeFont();
            }
        }
        catch (Exception exception) {
            System.out.println("Error parsing font : " + this.getBaseFont());
            exception.printStackTrace();
        }
        object = new ByteArrayInputStream(byArray);
        this.f = Font.createFont(0, (InputStream)object);
        ((ByteArrayInputStream)object).close();
    }

    private boolean fixNameTable(TrueTypeFont trueTypeFont, NameTable nameTable) {
        if (nameTable == null) {
            nameTable = (NameTable)TrueTypeTable.createTable(trueTypeFont, "name");
            trueTypeFont.addTable("name", nameTable);
        }
        String string = this.getBaseFont();
        String string2 = "Regular";
        if (string.indexOf("Italic") > -1 || string.indexOf("italic") > -1) {
            string2 = "Italic";
        } else if (string.indexOf("Bold") > -1 || string.indexOf("bold") > -1) {
            string2 = "Bold";
        }
        if (string.indexOf(45) > -1) {
            string = string.substring(0, string.indexOf(45));
        }
        short s = 3;
        short s2 = 1;
        short s3 = 1033;
        short[] sArray = new short[]{0, 1, 2, 3, 4, 5, 6, 7};
        String[] stringArray = new String[]{"No copyright", string, string2, string + " " + string2, string + " " + string2, "1.0 (Fake)", string, "No Trademark"};
        boolean bl = false;
        for (int i = 0; i < sArray.length; ++i) {
            if (nameTable.getRecord(s, s2, s3, sArray[i]) != null) continue;
            nameTable.addRecord(s, s2, s3, sArray[i], stringArray[i]);
            bl = true;
        }
        return bl;
    }

    private boolean fixCMapTable(TrueTypeFont trueTypeFont, CmapTable cmapTable) {
        int n;
        CMapFormat4 cMapFormat4 = null;
        CMapFormat0 cMapFormat0 = null;
        for (n = 0; n < mapIDs.length; n += 2) {
            CMap cMap = this.cmapTable.getCMap(mapIDs[n], mapIDs[n + 1]);
            if (cMap == null) continue;
            if (cMapFormat4 == null && cMap instanceof CMapFormat4) {
                cMapFormat4 = (CMapFormat4)cMap;
                continue;
            }
            if (cMapFormat0 != null || !(cMap instanceof CMapFormat0)) continue;
            cMapFormat0 = (CMapFormat0)cMap;
        }
        if (cMapFormat0 == null && cMapFormat4 == null) {
            cMapFormat4 = (CMapFormat4)CMap.createMap((short)4, (short)0);
            cMapFormat4.addSegment((short)this.getFirstChar(), (short)this.getLastChar(), (short)0);
        }
        if (cMapFormat0 != null) {
            cMapFormat4 = (CMapFormat4)CMap.createMap((short)4, (short)0);
            cMapFormat4.addSegment((short)0, (short)1, (short)0);
            for (n = this.getFirstChar(); n <= this.getLastChar(); ++n) {
                short s = (short)(cMapFormat0.map((byte)n) & 0xFF);
                if (s == 0) continue;
                cMapFormat4.addSegment((short)n, (short)n, (short)(s - n));
            }
        }
        for (n = 0; n < controlChars.length; ++n) {
            short s = (short)(0xF000 | controlChars[n]);
            short s2 = (short)cMapFormat4.map(controlChars[n]);
            cMapFormat4.addSegment(s, s, (short)(s2 - s));
        }
        cmapTable = (CmapTable)TrueTypeTable.createTable(trueTypeFont, "cmap");
        cmapTable.addCMap((short)3, (short)1, cMapFormat4);
        trueTypeFont.addTable("cmap", cmapTable);
        this.cmapTable = cmapTable;
        return true;
    }
}

