/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.Glyf;
import java.nio.ByteBuffer;

public class GlyfSimple
extends Glyf {
    private short[] contourEndPts;
    private byte[] instructions;
    private byte[] flags;
    private short[] xCoords;
    private short[] yCoords;

    protected GlyfSimple() {
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        int n;
        int n2;
        int n3;
        int n4;
        short[] sArray = new short[this.getNumContours()];
        for (n4 = 0; n4 < sArray.length; ++n4) {
            sArray[n4] = byteBuffer.getShort();
        }
        this.setContourEndPoints(sArray);
        n4 = this.getContourEndPoint(this.getNumContours() - 1) + 1;
        short s = byteBuffer.getShort();
        byte[] byArray = new byte[s];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byteBuffer.get();
        }
        this.setInstructions(byArray);
        byte[] byArray2 = new byte[n4];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byteBuffer.get();
            if ((byArray2[i] & 8) == 0) continue;
            n3 = byArray2[i];
            n2 = byteBuffer.get() & 0xFF;
            for (n = 0; n < n2; ++n) {
                byArray2[++i] = n3;
            }
        }
        this.setFlags(byArray2);
        short[] sArray2 = new short[n4];
        for (n3 = 0; n3 < sArray2.length; ++n3) {
            if (n3 > 0) {
                sArray2[n3] = sArray2[n3 - 1];
            }
            if (this.xIsByte(n3)) {
                n2 = byteBuffer.get() & 0xFF;
                if (!this.xIsSame(n3)) {
                    n2 = -n2;
                }
                int n5 = n3;
                sArray2[n5] = (short)(sArray2[n5] + n2);
                continue;
            }
            if (this.xIsSame(n3)) continue;
            int n6 = n3;
            sArray2[n6] = (short)(sArray2[n6] + byteBuffer.getShort());
        }
        this.setXCoords(sArray2);
        short[] sArray3 = new short[n4];
        for (n2 = 0; n2 < sArray3.length; ++n2) {
            if (n2 > 0) {
                sArray3[n2] = sArray3[n2 - 1];
            }
            if (this.yIsByte(n2)) {
                n = byteBuffer.get() & 0xFF;
                if (!this.yIsSame(n2)) {
                    n = -n;
                }
                int n7 = n2;
                sArray3[n7] = (short)(sArray3[n7] + n);
                continue;
            }
            if (this.yIsSame(n2)) continue;
            int n8 = n2;
            sArray3[n8] = (short)(sArray3[n8] + byteBuffer.getShort());
        }
        this.setYCoords(sArray3);
    }

    @Override
    public ByteBuffer getData() {
        int n;
        ByteBuffer byteBuffer = super.getData();
        for (n = 0; n < this.getNumContours(); ++n) {
            byteBuffer.putShort(this.getContourEndPoint(n));
        }
        byteBuffer.putShort(this.getNumInstructions());
        for (n = 0; n < this.getNumInstructions(); ++n) {
            byteBuffer.put(this.getInstruction(n));
        }
        for (n = 0; n < this.getNumPoints(); ++n) {
            byte by = 0;
            while (n > 0 && this.getFlag(n) == this.getFlag(n - 1)) {
                by = (byte)(by + 1);
                ++n;
            }
            if (by > 0) {
                byteBuffer.put(by);
                continue;
            }
            byteBuffer.put(this.getFlag(n));
        }
        for (n = 0; n < this.getNumPoints(); ++n) {
            if (this.xIsByte(n)) {
                byteBuffer.put((byte)this.getXCoord(n));
                continue;
            }
            if (this.xIsSame(n)) continue;
            byteBuffer.putShort(this.getXCoord(n));
        }
        for (n = 0; n < this.getNumPoints(); ++n) {
            if (this.yIsByte(n)) {
                byteBuffer.put((byte)this.getYCoord(n));
                continue;
            }
            if (this.yIsSame(n)) continue;
            byteBuffer.putShort(this.getYCoord(n));
        }
        return byteBuffer;
    }

    @Override
    public short getLength() {
        int n;
        short s = super.getLength();
        s = (short)(s + this.getNumContours() * 2);
        s = (short)(s + (2 + this.getNumInstructions()));
        for (n = 0; n < this.getNumPoints(); ++n) {
            while (n > 0 && this.getFlag(n) == this.getFlag(n - 1)) {
            }
            s = (short)(s + 1);
        }
        for (n = 0; n < this.getNumPoints(); ++n) {
            if (this.xIsByte(n)) {
                s = (short)(s + 1);
            } else if (!this.xIsSame(n)) {
                s = (short)(s + 2);
            }
            if (this.yIsByte(n)) {
                s = (short)(s + 1);
                continue;
            }
            if (this.yIsSame(n)) continue;
            s = (short)(s + 2);
        }
        return s;
    }

    public short getContourEndPoint(int n) {
        return this.contourEndPts[n];
    }

    protected void setContourEndPoints(short[] sArray) {
        this.contourEndPts = sArray;
    }

    public short getNumInstructions() {
        return (short)this.instructions.length;
    }

    public byte getInstruction(int n) {
        return this.instructions[n];
    }

    protected void setInstructions(byte[] byArray) {
        this.instructions = byArray;
    }

    public short getNumPoints() {
        return (short)this.flags.length;
    }

    public byte getFlag(int n) {
        return this.flags[n];
    }

    public boolean onCurve(int n) {
        return (this.getFlag(n) & 1) != 0;
    }

    protected boolean xIsByte(int n) {
        return (this.getFlag(n) & 2) != 0;
    }

    protected boolean yIsByte(int n) {
        return (this.getFlag(n) & 4) != 0;
    }

    protected boolean repeat(int n) {
        return (this.getFlag(n) & 8) != 0;
    }

    protected boolean xIsSame(int n) {
        return (this.getFlag(n) & 0x10) != 0;
    }

    protected boolean yIsSame(int n) {
        return (this.getFlag(n) & 0x20) != 0;
    }

    protected void setFlags(byte[] byArray) {
        this.flags = byArray;
    }

    public short getXCoord(int n) {
        return this.xCoords[n];
    }

    protected void setXCoords(short[] sArray) {
        this.xCoords = sArray;
    }

    public short getYCoord(int n) {
        return this.yCoords[n];
    }

    protected void setYCoords(short[] sArray) {
        this.yCoords = sArray;
    }
}

