/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;

public class HheaTable
extends TrueTypeTable {
    private int version;
    private short ascent;
    private short descent;
    private short lineGap;
    private short advanceWidthMax;
    private short minLeftSideBearing;
    private short minRightSideBearing;
    private short xMaxExtent;
    private short caretSlopeRise;
    private short caretSlopeRun;
    private short caretOffset;
    private short metricDataFormat;
    private short numOfLongHorMetrics;

    protected HheaTable() {
        super(1751474532);
        this.setVersion(65536);
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() != 36) {
            throw new IllegalArgumentException("Bad Head table size");
        }
        this.setVersion(byteBuffer.getInt());
        this.setAscent(byteBuffer.getShort());
        this.setDescent(byteBuffer.getShort());
        this.setLineGap(byteBuffer.getShort());
        this.setAdvanceWidthMax(byteBuffer.getShort());
        this.setMinLeftSideBearing(byteBuffer.getShort());
        this.setMinRightSideBearing(byteBuffer.getShort());
        this.setXMaxExtent(byteBuffer.getShort());
        this.setCaretSlopeRise(byteBuffer.getShort());
        this.setCaretSlopeRun(byteBuffer.getShort());
        this.setCaretOffset(byteBuffer.getShort());
        byteBuffer.getShort();
        byteBuffer.getShort();
        byteBuffer.getShort();
        byteBuffer.getShort();
        this.setMetricDataFormat(byteBuffer.getShort());
        this.setNumOfLongHorMetrics(byteBuffer.getShort());
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putInt(this.getVersion());
        byteBuffer.putShort(this.getAscent());
        byteBuffer.putShort(this.getDescent());
        byteBuffer.putShort(this.getLineGap());
        byteBuffer.putShort(this.getAdvanceWidthMax());
        byteBuffer.putShort(this.getMinLeftSideBearing());
        byteBuffer.putShort(this.getMinRightSideBearing());
        byteBuffer.putShort(this.getXMaxExtent());
        byteBuffer.putShort(this.getCaretSlopeRise());
        byteBuffer.putShort(this.getCaretSlopeRun());
        byteBuffer.putShort(this.getCaretOffset());
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort(this.getMetricDataFormat());
        byteBuffer.putShort((short)this.getNumOfLongHorMetrics());
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public int getLength() {
        return 36;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        stringBuffer.append(string + "Version             : " + Integer.toHexString(this.getVersion()) + "\n");
        stringBuffer.append(string + "Ascent              : " + this.getAscent() + "\n");
        stringBuffer.append(string + "Descent             : " + this.getDescent() + "\n");
        stringBuffer.append(string + "LineGap             : " + this.getLineGap() + "\n");
        stringBuffer.append(string + "AdvanceWidthMax     : " + this.getAdvanceWidthMax() + "\n");
        stringBuffer.append(string + "MinLSB              : " + this.getMinLeftSideBearing() + "\n");
        stringBuffer.append(string + "MinRSB              : " + this.getMinRightSideBearing() + "\n");
        stringBuffer.append(string + "MaxExtent           : " + this.getXMaxExtent() + "\n");
        stringBuffer.append(string + "CaretSlopeRise      : " + this.getCaretSlopeRise() + "\n");
        stringBuffer.append(string + "CaretSlopeRun       : " + this.getCaretSlopeRun() + "\n");
        stringBuffer.append(string + "CaretOffset         : " + this.getCaretOffset() + "\n");
        stringBuffer.append(string + "MetricDataFormat    : " + this.getMetricDataFormat() + "\n");
        stringBuffer.append(string + "NumOfLongHorMetrics : " + this.getNumOfLongHorMetrics() + "\n");
        return stringBuffer.toString();
    }

    public short getAscent() {
        return this.ascent;
    }

    public void setAscent(short s) {
        this.ascent = s;
    }

    public short getDescent() {
        return this.descent;
    }

    public void setDescent(short s) {
        this.descent = s;
    }

    public short getLineGap() {
        return this.lineGap;
    }

    public void setLineGap(short s) {
        this.lineGap = s;
    }

    public short getAdvanceWidthMax() {
        return this.advanceWidthMax;
    }

    public void setAdvanceWidthMax(short s) {
        this.advanceWidthMax = s;
    }

    public short getMinLeftSideBearing() {
        return this.minLeftSideBearing;
    }

    public void setMinLeftSideBearing(short s) {
        this.minLeftSideBearing = s;
    }

    public short getMinRightSideBearing() {
        return this.minRightSideBearing;
    }

    public void setMinRightSideBearing(short s) {
        this.minRightSideBearing = s;
    }

    public short getXMaxExtent() {
        return this.xMaxExtent;
    }

    public void setXMaxExtent(short s) {
        this.xMaxExtent = s;
    }

    public short getCaretSlopeRise() {
        return this.caretSlopeRise;
    }

    public void setCaretSlopeRise(short s) {
        this.caretSlopeRise = s;
    }

    public short getCaretSlopeRun() {
        return this.caretSlopeRun;
    }

    public void setCaretSlopeRun(short s) {
        this.caretSlopeRun = s;
    }

    public short getCaretOffset() {
        return this.caretOffset;
    }

    public void setCaretOffset(short s) {
        this.caretOffset = s;
    }

    public short getMetricDataFormat() {
        return this.metricDataFormat;
    }

    public void setMetricDataFormat(short s) {
        this.metricDataFormat = s;
    }

    public int getNumOfLongHorMetrics() {
        return this.numOfLongHorMetrics & 0xFFFF;
    }

    public void setNumOfLongHorMetrics(short s) {
        this.numOfLongHorMetrics = s;
    }
}

