/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;

public class MaxpTable
extends TrueTypeTable {
    private int version;
    private int numGlyphs;
    private int maxPoints;
    private int maxContours;
    private int maxComponentPoints;
    private int maxComponentContours;
    private int maxZones;
    private int maxTwilightPoints;
    private int maxStorage;
    private int maxFunctionDefs;
    private int maxInstructionDefs;
    private int maxStackElements;
    private int maxSizeOfInstructions;
    private int maxComponentElements;
    private int maxComponentDepth;

    protected MaxpTable() {
        super(1835104368);
        this.setVersion(65536);
        this.setNumGlyphs(0);
        this.setMaxPoints(0);
        this.setMaxContours(0);
        this.setMaxComponentPoints(0);
        this.setMaxComponentContours(0);
        this.setMaxZones(2);
        this.setMaxTwilightPoints(0);
        this.setMaxStorage(0);
        this.setMaxFunctionDefs(0);
        this.setMaxInstructionDefs(0);
        this.setMaxStackElements(0);
        this.setMaxSizeOfInstructions(0);
        this.setMaxComponentElements(0);
        this.setMaxComponentDepth(0);
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() != 32) {
            throw new IllegalArgumentException("Bad size for Maxp table");
        }
        this.setVersion(byteBuffer.getInt());
        this.setNumGlyphs(byteBuffer.getShort());
        this.setMaxPoints(byteBuffer.getShort());
        this.setMaxContours(byteBuffer.getShort());
        this.setMaxComponentPoints(byteBuffer.getShort());
        this.setMaxComponentContours(byteBuffer.getShort());
        this.setMaxZones(byteBuffer.getShort());
        this.setMaxTwilightPoints(byteBuffer.getShort());
        this.setMaxStorage(byteBuffer.getShort());
        this.setMaxFunctionDefs(byteBuffer.getShort());
        this.setMaxInstructionDefs(byteBuffer.getShort());
        this.setMaxStackElements(byteBuffer.getShort());
        this.setMaxSizeOfInstructions(byteBuffer.getShort());
        this.setMaxComponentElements(byteBuffer.getShort());
        this.setMaxComponentDepth(byteBuffer.getShort());
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putInt(this.getVersion());
        byteBuffer.putShort((short)this.getNumGlyphs());
        byteBuffer.putShort((short)this.getMaxPoints());
        byteBuffer.putShort((short)this.getMaxContours());
        byteBuffer.putShort((short)this.getMaxComponentPoints());
        byteBuffer.putShort((short)this.getMaxComponentContours());
        byteBuffer.putShort((short)this.getMaxZones());
        byteBuffer.putShort((short)this.getMaxTwilightPoints());
        byteBuffer.putShort((short)this.getMaxStorage());
        byteBuffer.putShort((short)this.getMaxFunctionDefs());
        byteBuffer.putShort((short)this.getMaxInstructionDefs());
        byteBuffer.putShort((short)this.getMaxStackElements());
        byteBuffer.putShort((short)this.getMaxSizeOfInstructions());
        byteBuffer.putShort((short)this.getMaxComponentElements());
        byteBuffer.putShort((short)this.getMaxComponentDepth());
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public int getLength() {
        return 32;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getNumGlyphs() {
        return this.numGlyphs & 0xFFFF;
    }

    public void setNumGlyphs(int n) {
        this.numGlyphs = n;
    }

    public int getMaxPoints() {
        return this.maxPoints & 0xFFFF;
    }

    public void setMaxPoints(int n) {
        this.maxPoints = n;
    }

    public int getMaxContours() {
        return this.maxContours & 0xFFFF;
    }

    public void setMaxContours(int n) {
        this.maxContours = n;
    }

    public int getMaxComponentPoints() {
        return this.maxComponentPoints & 0xFFFF;
    }

    public void setMaxComponentPoints(int n) {
        this.maxComponentPoints = n;
    }

    public int getMaxComponentContours() {
        return this.maxComponentContours & 0xFFFF;
    }

    public void setMaxComponentContours(int n) {
        this.maxComponentContours = n;
    }

    public int getMaxZones() {
        return this.maxZones & 0xFFFF;
    }

    public void setMaxZones(int n) {
        this.maxZones = n;
    }

    public int getMaxTwilightPoints() {
        return this.maxTwilightPoints & 0xFFFF;
    }

    public void setMaxTwilightPoints(int n) {
        this.maxTwilightPoints = n;
    }

    public int getMaxStorage() {
        return this.maxStorage & 0xFFFF;
    }

    public void setMaxStorage(int n) {
        this.maxStorage = n;
    }

    public int getMaxFunctionDefs() {
        return this.maxFunctionDefs & 0xFFFF;
    }

    public void setMaxFunctionDefs(int n) {
        this.maxFunctionDefs = n;
    }

    public int getMaxInstructionDefs() {
        return this.maxInstructionDefs & 0xFFFF;
    }

    public void setMaxInstructionDefs(int n) {
        this.maxInstructionDefs = n;
    }

    public int getMaxStackElements() {
        return this.maxStackElements & 0xFFFF;
    }

    public void setMaxStackElements(int n) {
        this.maxStackElements = n;
    }

    public int getMaxSizeOfInstructions() {
        return this.maxSizeOfInstructions & 0xFFFF;
    }

    public void setMaxSizeOfInstructions(int n) {
        this.maxSizeOfInstructions = n;
    }

    public int getMaxComponentElements() {
        return this.maxComponentElements & 0xFFFF;
    }

    public void setMaxComponentElements(int n) {
        this.maxComponentElements = n;
    }

    public int getMaxComponentDepth() {
        return this.maxComponentDepth & 0xFFFF;
    }

    public void setMaxComponentDepth(int n) {
        this.maxComponentDepth = n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        stringBuffer.append(string + "Version          : " + Integer.toHexString(this.getVersion()) + "\n");
        stringBuffer.append(string + "NumGlyphs        : " + this.getNumGlyphs() + "\n");
        stringBuffer.append(string + "MaxPoints        : " + this.getMaxPoints() + "\n");
        stringBuffer.append(string + "MaxContours      : " + this.getMaxContours() + "\n");
        stringBuffer.append(string + "MaxCompPoints    : " + this.getMaxComponentPoints() + "\n");
        stringBuffer.append(string + "MaxCompContours  : " + this.getMaxComponentContours() + "\n");
        stringBuffer.append(string + "MaxZones         : " + this.getMaxZones() + "\n");
        stringBuffer.append(string + "MaxTwilightPoints: " + this.getMaxTwilightPoints() + "\n");
        stringBuffer.append(string + "MaxStorage       : " + this.getMaxStorage() + "\n");
        stringBuffer.append(string + "MaxFuncDefs      : " + this.getMaxFunctionDefs() + "\n");
        stringBuffer.append(string + "MaxInstDefs      : " + this.getMaxInstructionDefs() + "\n");
        stringBuffer.append(string + "MaxStackElements : " + this.getMaxStackElements() + "\n");
        stringBuffer.append(string + "MaxSizeInst      : " + this.getMaxSizeOfInstructions() + "\n");
        stringBuffer.append(string + "MaxCompElements  : " + this.getMaxComponentElements() + "\n");
        stringBuffer.append(string + "MaxCompDepth     : " + this.getMaxComponentDepth() + "\n");
        return stringBuffer.toString();
    }
}

