/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.RepaintManager;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.DisplayOffsets;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.ScalingFactory;

class SwingPainter {
    protected int lastFormPage = -1;
    protected int lastStart = -1;
    protected int lastEnd = -1;
    public Rectangle viewableArea = null;
    private int pageUsedForTransform;
    private int lastIndent = -1;
    private Rectangle cursorBoxOnScreen = null;
    private Rectangle lastCursorBoxOnScreen = null;
    private Color outlineColor;
    private AffineTransform cursorAf;
    private double indent = 0.0;
    private AffineTransform viewScaling = null;
    private PdfDecoder pdfDecoder;
    DisplayOffsets displayOffsets;
    DecoderOptions options = new DecoderOptions();

    public SwingPainter(PdfDecoder pdfDecoder, DecoderOptions options) {
        this.pdfDecoder = pdfDecoder;
        this.options = options;
        this.displayOffsets = options.getDisplayOffsets();
    }

    public void paintPage(Graphics2D g2, PdfDecoder pdfDecoder, Display pages, PdfPageData pageData, int pageNumber, DynamicVectorRenderer currentDisplay, int displayView, int displayRotation, int insetW, int insetH, TextLines textLines, Border myBorder, PageOffsets currentOffset, ExternalHandlers externalHandlers) {
        AcroRenderer formRenderer = pdfDecoder.getFormRenderer();
        Rectangle visibleRect = pdfDecoder.getVisibleRect();
        int pageCount = pdfDecoder.getPageCount();
        float scaling = pdfDecoder.getScaling();
        pages.init(scaling, pageCount, displayRotation, pageNumber, currentDisplay, false, pageData, insetW, insetH);
        AffineTransform rawAf = g2.getTransform();
        g2.translate(this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY());
        int start = pageNumber;
        int end = pageNumber;
        if (displayView != 1) {
            start = pages.getStartPage();
            end = pages.getEndPage();
            if (start == 0 || end == 0 || this.lastEnd != end || this.lastStart != start) {
                this.lastFormPage = -1;
            }
            this.lastEnd = end;
            this.lastStart = start;
        }
        if (this.lastFormPage != pageNumber && formRenderer != null) {
            formRenderer.displayComponentsOnscreen(start, end);
            if (formRenderer.getCompData().getStartComponentCountForPage(pageNumber) != -1) {
                this.lastFormPage = pageNumber;
            }
        }
        if (pdfDecoder.alignment == 2) {
            double width = pdfDecoder.getBounds().getWidth();
            int pdfWidth = pdfDecoder.getPDFWidth();
            if (displayView != 1) {
                pdfWidth = (int)pages.getPageSize(displayView).getWidth();
            }
            if (displayView == 3) {
                int page = pageNumber;
                if (pages.getBoolean(Display.BoolValue.SEPARATE_COVER) && (page & 1) == 1) {
                    --page;
                } else if (!pages.getBoolean(Display.BoolValue.SEPARATE_COVER) && (page & 1) == 0) {
                    --page;
                }
                int firstW = (displayRotation + pageData.getRotation(page)) % 180 == 90 ? pageData.getCropBoxHeight(page) : pageData.getCropBoxWidth(page);
                int secondW = page + 1 > pageCount ? firstW : ((displayRotation + pageData.getRotation(page + 1)) % 180 == 90 ? pageData.getCropBoxHeight(page + 1) : pageData.getCropBoxWidth(page + 1));
                int pageGap = 0;
                if (!pages.getBoolean(Display.BoolValue.TURNOVER_ON) || pageData.hasMultipleSizes() || pageCount == 2) {
                    pageGap = 5;
                }
                this.indent = (width - (double)((float)(firstW + secondW) * scaling)) / 2.0 - (double)pageGap - (double)insetW;
            } else {
                this.indent = (width - (double)pdfWidth) / 2.0;
            }
            if (displayView == 1) {
                this.lastIndent = (int)this.indent;
            } else if (displayView == 2 && this.lastIndent != -1) {
                this.indent = this.lastIndent;
                this.lastIndent = -1;
            } else {
                this.lastIndent = -1;
            }
            g2.translate(this.indent, 0.0);
            if (formRenderer != null && currentOffset != null) {
                formRenderer.getCompData().setPageValues(scaling, displayRotation, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), displayView, currentOffset.widestPageNR, currentOffset.widestPageR);
                formRenderer.getCompData().resetScaledLocation(scaling, displayRotation, (int)this.indent);
            }
        } else if (formRenderer != null && currentOffset != null) {
            this.lastIndent = -1;
            formRenderer.getCompData().setPageValues(scaling, displayRotation, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), displayView, currentOffset.widestPageNR, currentOffset.widestPageR);
            formRenderer.getCompData().resetScaledLocation(scaling, displayRotation, (int)this.indent);
        }
        pages.initRenderer(textLines.areas, g2, myBorder, (int)this.indent);
        pages.drawPage(this.viewScaling, pdfDecoder.displayScaling, this.pageUsedForTransform);
        if (displayView == 1) {
            if (this.viewScaling != null) {
                g2.transform(this.viewScaling);
            }
            if (this.cursorBoxOnScreen != null) {
                this.cursorAf = g2.getTransform();
            }
            pages.resetToDefaultClip();
        }
        if (displayView == 1) {
            SwingPainter.drawHighlightsForImage(g2, pages.getHighlightedImage(), scaling, displayRotation, insetW, insetH, pdfDecoder.max_x, pdfDecoder.max_y);
        } else {
            pages.setHighlightedImage(null);
        }
        pages.drawBorder();
        g2.setTransform(rawAf);
        if (displayView == 1) {
            pages.drawPreviewImage(g2, visibleRect);
        }
    }

    public void setCursorBoxOnScreen(Rectangle cursorBoxOnScreen, boolean isSamePage, AcroRenderer formRenderer) {
        this.cursorBoxOnScreen = cursorBoxOnScreen;
        if (!isSamePage && formRenderer != null) {
            formRenderer.removeDisplayComponentsFromScreen();
            this.lastFormPage = -1;
        }
    }

    public Rectangle getCursorBoxOnScreen() {
        return this.cursorBoxOnScreen;
    }

    public void drawCursor(Graphics g, int alignment) {
        if (this.cursorBoxOnScreen != null) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform defaultAf = g2.getTransform();
            if (this.cursorAf != null) {
                g2.setTransform(this.cursorAf);
                Shape clip = g2.getClip();
                if (alignment == 2 && clip != null) {
                    g2.setClip(null);
                }
                if (this.cursorBoxOnScreen != null && PdfDecoder.showMouseBox) {
                    SwingPainter.paintRectangle(g2, this.cursorBoxOnScreen, this.pdfDecoder.scaling, this.outlineColor);
                }
                this.lastCursorBoxOnScreen = this.cursorBoxOnScreen;
                g2.setClip(clip);
                g2.setTransform(defaultAf);
            }
        }
    }

    public final void updateCursorBoxOnScreen(Rectangle newOutlineRectangle, Color outlineColor, PdfDecoder pdfDecoder, int pageNumber) {
        PdfPageData pageData = pdfDecoder.getPdfPageData();
        int x_size = pdfDecoder.x_size;
        int y_size = pdfDecoder.y_size;
        if (newOutlineRectangle != null) {
            int diff;
            int x = newOutlineRectangle.x;
            int y = newOutlineRectangle.y;
            int w = newOutlineRectangle.width;
            int h = newOutlineRectangle.height;
            int cropX = pageData.getCropBoxX(pageNumber);
            int cropY = pageData.getCropBoxY(pageNumber);
            int cropW = pageData.getCropBoxWidth(pageNumber);
            int cropH = pageData.getCropBoxHeight(pageNumber);
            if (y > 0 && y < cropY) {
                y += cropY;
            }
            if (x < cropX) {
                diff = cropX - x;
                w -= diff;
                x = cropX;
            }
            if (y < cropY) {
                diff = cropY - y;
                h -= diff;
                y += diff;
            }
            if (x + w > cropW + cropX) {
                w = cropX + cropW - x;
            }
            if (y + h > cropY + cropH) {
                h = cropY + cropH - y;
            }
            this.cursorBoxOnScreen = new Rectangle(x, y, w, h);
        } else {
            this.cursorBoxOnScreen = null;
        }
        this.outlineColor = outlineColor;
        int strip = 30;
        int dx = 0;
        if (pdfDecoder.alignment == 2) {
            int width = pdfDecoder.getBounds().width;
            int pdfWidth = pdfDecoder.getPDFWidth();
            if (pdfDecoder.displayView != 1) {
                pdfWidth = (int)pdfDecoder.pages.getPageSize(pdfDecoder.displayView).getWidth();
            }
            dx = (width - pdfWidth) / 2;
        }
        RepaintManager currentManager = RepaintManager.currentManager(pdfDecoder);
        if (this.lastCursorBoxOnScreen != null) {
            if (pdfDecoder.displayRotation == 0 || pdfDecoder.displayRotation == 180) {
                currentManager.addDirtyRegion(pdfDecoder, pdfDecoder.insetW + dx, pdfDecoder.insetH, x_size + 5, y_size);
            } else {
                currentManager.addDirtyRegion(pdfDecoder, pdfDecoder.insetH + dx, pdfDecoder.insetW, y_size + 5, x_size);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            currentManager.addDirtyRegion(pdfDecoder, (int)((float)this.cursorBoxOnScreen.x * pdfDecoder.scaling) - strip, (int)((float)(pdfDecoder.max_y - this.cursorBoxOnScreen.y - this.cursorBoxOnScreen.height) * pdfDecoder.scaling) - strip, (int)((float)this.cursorBoxOnScreen.width * pdfDecoder.scaling) + strip + strip, (int)((float)this.cursorBoxOnScreen.height * pdfDecoder.scaling) + strip + strip);
        }
        if (this.viewScaling != null) {
            currentManager.markCompletelyDirty(pdfDecoder);
        }
        pdfDecoder.repaint();
    }

    public double getIndent() {
        return this.indent;
    }

    public void setPageRotation(int newRotation, PdfPageData pageData) {
        this.pdfDecoder.displayRotation = newRotation;
        if (this.pdfDecoder.displayView != 1) {
            newRotation = 0;
        }
        this.pageUsedForTransform = this.pdfDecoder.pageNumber;
        this.pdfDecoder.displayScaling = this.pdfDecoder.displayView != 1 && this.pdfDecoder.displayView != 3 ? ScalingFactory.getScalingForImage(1, 0, this.pdfDecoder.scaling, pageData) : ScalingFactory.getScalingForImage(this.pdfDecoder.pageNumber, newRotation, this.pdfDecoder.scaling, pageData);
        if (newRotation == 90) {
            this.pdfDecoder.displayScaling.translate((float)this.pdfDecoder.insetH / this.pdfDecoder.scaling, (float)this.pdfDecoder.insetW / this.pdfDecoder.scaling);
        } else if (newRotation == 270) {
            this.pdfDecoder.displayScaling.translate((float)(-this.pdfDecoder.insetH) / this.pdfDecoder.scaling, (float)(-this.pdfDecoder.insetW) / this.pdfDecoder.scaling);
        } else if (newRotation == 180) {
            this.pdfDecoder.displayScaling.translate((float)(-this.pdfDecoder.insetW) / this.pdfDecoder.scaling, (float)this.pdfDecoder.insetH / this.pdfDecoder.scaling);
        } else {
            this.pdfDecoder.displayScaling.translate((float)this.pdfDecoder.insetW / this.pdfDecoder.scaling, (float)(-this.pdfDecoder.insetH) / this.pdfDecoder.scaling);
        }
        this.pdfDecoder.pages.refreshDisplay();
        if (this.viewableArea != null) {
            this.viewScaling = new AffineTransform();
            double dx = (double)this.viewableArea.width / (double)pageData.getCropBoxWidth(this.pdfDecoder.pageNumber);
            double dy = (double)this.viewableArea.height / (double)pageData.getCropBoxHeight(this.pdfDecoder.pageNumber);
            double viewScale = dx;
            if (dy < dx) {
                viewScale = dy;
            }
            double x = this.viewableArea.x;
            double y = (double)this.viewableArea.y + ((double)this.viewableArea.height - (double)pageData.getCropBoxHeight(this.pdfDecoder.pageNumber) * viewScale);
            this.viewScaling.translate(x, y);
            this.viewScaling.scale(viewScale, viewScale);
        } else {
            this.viewScaling = null;
        }
    }

    public AffineTransform setViewableArea(Rectangle viewport, PdfDecoder pdfDecoder, PdfPageData pageData) throws PdfException {
        if (viewport != null) {
            double x = viewport.getX();
            double y = viewport.getY();
            double w = viewport.getWidth();
            double h = viewport.getHeight();
            double crw = pageData.getCropBoxWidth(pdfDecoder.pageNumber);
            double crh = pageData.getCropBoxHeight(pdfDecoder.pageNumber);
            if (x < 0.0 || y < 0.0 || x + w > crw || y + h > crh) {
                throw new PdfException("Viewport is not totally enclosed within displayed panel.");
            }
            if (crw != w || crh != h) {
                this.viewableArea = viewport;
                this.setPageRotation(pdfDecoder.displayRotation, pageData);
                pdfDecoder.repaint();
            }
        } else {
            this.resetViewableArea(pdfDecoder, pageData);
        }
        return this.viewScaling;
    }

    public DisplayOffsets getDisplayOffsets() {
        return this.displayOffsets;
    }

    public void resetViewableArea(PdfDecoder pdfDecoder, PdfPageData pageData) {
        if (this.viewableArea != null) {
            this.viewableArea = null;
            this.setPageRotation(pdfDecoder.displayRotation, pageData);
            pdfDecoder.repaint();
        }
    }

    public void resetMultiPageForms(int page, PdfDecoder pdfDecoder, AcroRenderer formRenderer, Display pages) {
        formRenderer.removeDisplayComponentsFromScreen();
        this.lastFormPage = -1;
        formRenderer.displayComponentsOnscreen(page, page);
        if (formRenderer.getCompData().getStartComponentCountForPage(page) != -1) {
            this.lastFormPage = page;
        }
    }

    public void forceRedraw() {
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
    }

    private static void drawHighlightsForImage(Graphics2D g2, int[] highlightedImage, float scaling, int displayRotation, int insetW, int insetH, int max_x, int max_y) {
        if (highlightedImage != null) {
            int finalY;
            int finalX;
            int x = (int)((float)highlightedImage[0] * scaling);
            int y = (int)((float)highlightedImage[1] * scaling);
            int w = (int)((float)highlightedImage[2] * scaling);
            int h = (int)((float)highlightedImage[3] * scaling);
            if (w < 0) {
                w = -w;
                x -= w;
            }
            if (h < 0) {
                h = -h;
                y -= h;
            }
            int finalW = w;
            int finalH = h;
            if (displayRotation == 90) {
                finalH = w;
                finalW = h;
                finalX = insetW + y;
                finalY = insetH + x;
            } else if (displayRotation == 180) {
                finalX = (int)((float)max_x * scaling - (float)x - (float)w) + insetW;
                finalY = insetH + y;
            } else if (displayRotation == 270) {
                finalH = w;
                finalW = h;
                finalY = (int)((float)max_x * scaling - (float)x - (float)w) + insetW;
                finalX = (int)((float)max_y * scaling - (float)y - (float)h) + insetH;
            } else {
                finalX = insetW + x;
                finalY = (int)((float)max_y * scaling - (float)y - (float)h) + insetH;
            }
            Color oldColor = g2.getColor();
            Composite oldComposite = g2.getComposite();
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(2.0f));
            g2.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
            if (BaseDisplay.invertHighlight) {
                g2.setColor(Color.WHITE);
                g2.setXORMode(Color.BLACK);
            } else {
                g2.setColor(DecoderOptions.highlightColor);
                g2.drawRect(finalX, finalY, finalW, finalH);
            }
            g2.fillRect(finalX, finalY, finalW, finalH);
            g2.setColor(oldColor);
            g2.setComposite(oldComposite);
            g2.setStroke(oldStroke);
        }
    }

    private static void paintRectangle(Graphics2D g2, Rectangle cursorBoxOnScreen, float scaling, Color outlineColor) {
        Stroke oldStroke = g2.getStroke();
        BasicStroke lineStroke = scaling < 0.0f ? new BasicStroke(1.0f / -scaling) : new BasicStroke(1.0f / scaling);
        g2.setStroke(lineStroke);
        g2.setColor(outlineColor);
        g2.draw(cursorBoxOnScreen);
        g2.setStroke(oldStroke);
    }

    public static BufferedImage getSelectedRectangleOnscreen(float t_x1, float t_y1, float t_x2, float t_y2, float scaling, int pageNumber, PdfPageData pageData, AcroRenderer formRenderer, DynamicVectorRenderer currentDisplay, PdfObjectReader currentPdfFile) {
        int mediaBoxH = pageData.getMediaBoxHeight(pageNumber);
        int crw = pageData.getCropBoxWidth(pageNumber);
        int crh = pageData.getCropBoxHeight(pageNumber);
        int crx = pageData.getCropBoxX(pageNumber);
        int cry = pageData.getCropBoxY(pageNumber);
        if (t_y2 < (float)cry) {
            t_y2 = cry;
        }
        if (t_x1 < (float)crx) {
            t_x1 = crx;
        }
        if (t_y1 > (float)(crh + cry)) {
            t_y1 = crh + cry;
        }
        if (t_x2 > (float)(crx + crw)) {
            t_x2 = crx + crw;
        }
        if (t_x2 - t_x1 < 1.0f || t_y1 - t_y2 < 1.0f) {
            return null;
        }
        float scalingFactor = scaling / 100.0f;
        float imgWidth = t_x2 - t_x1;
        float imgHeight = t_y1 - t_y2;
        BufferedImage img = new BufferedImage((int)(imgWidth * scalingFactor), (int)(imgHeight * scalingFactor), 1);
        Graphics2D g2 = img.createGraphics();
        if (cry > 0) {
            cry = mediaBoxH - crh - cry;
        }
        AffineTransform scaleAf = ScalingFactory.getScalingForImage(pageNumber, 0, scalingFactor, pageData);
        int cx = -crx;
        int cy = -cry;
        scaleAf.translate(cx, -cy);
        scaleAf.translate(-(t_x1 - (float)crx), (float)mediaBoxH - t_y1 - (float)cry);
        AffineTransform af = g2.getTransform();
        g2.transform(scaleAf);
        currentDisplay.setG2(g2);
        currentDisplay.paintBackground(new Rectangle(crx, cry, crw, crh));
        currentDisplay.setOptimsePainting(true);
        currentDisplay.paint(null, null, null);
        if (formRenderer != null && formRenderer.hasFormsOnPage(pageNumber)) {
            formRenderer.getCompData().renderFormsOntoG2(g2, pageNumber, scaling, 0, 0, null, null, currentPdfFile, pageData.getMediaBoxHeight(pageNumber));
        }
        g2.setTransform(af);
        g2.dispose();
        return img;
    }
}

