/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.pdf.color.shading.ShadedPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PatternDisplay;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.color.RotatedTexturePaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PatternObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class PatternColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 9108293275924704003L;
    private Map cachedPaints = new HashMap();
    private PdfObjectReader currentPdfFile = null;
    private boolean colorsReversed;

    public PatternColorSpace(PdfObjectReader currentPdfFile) {
        this.value = 1146450818;
        this.currentPdfFile = currentPdfFile;
        this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setColor(String[] value_loc, int operandCount) {
        PatternObject PatternObj = (PatternObject)this.patterns.get(value_loc[0]);
        String ref = PatternObj.getObjectRefAsString();
        if (ref != null && this.cachedPaints.containsKey(ref)) {
            this.currentColor = (PdfPaint)this.cachedPaints.get(ref);
            return;
        }
        this.currentPdfFile.checkResolved(PatternObj);
        byte[] streamData = this.currentPdfFile.readStream(PatternObj, true, true, true, false, false, PatternObj.getCacheName(this.currentPdfFile.getObjectReader()));
        int shadingType = PatternObj.getInt(1755231159);
        Object matrix = null;
        float[] inputs = PatternObj.getFloatArray(1145198201);
        if (inputs != null) {
            if (shadingType == 1) {
                float[][] Nmatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                if (inputs[5] < 0.0f) {
                    inputs[4] = 0.0f;
                    inputs[5] = 0.0f;
                }
                matrix = Nmatrix;
            } else {
                float[][] Nmatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
                this.colorsReversed = Nmatrix[2][0] < 0.0f;
                matrix = Matrix.multiply(Nmatrix, this.CTM);
            }
        }
        if (shadingType == 1) {
            this.currentColor = this.setupTiling(PatternObj, inputs, (float[][])matrix, streamData);
        } else if (shadingType == 2) {
            this.currentColor = this.setupShading(PatternObj, (float[][])matrix);
        }
    }

    private PdfPaint setupTiling(PdfObject PatternObj, float[] inputs, float[][] matrix, byte[] streamData) {
        boolean needsAdjusting = inputs != null && inputs[5] == (float)this.pageHeight && inputs[4] == 0.0f;
        this.inputs = inputs;
        PdfPaint paint = null;
        boolean tesslateOntoImage = true;
        BufferedImage img = null;
        AffineTransform imageScale = null;
        float[][] rawMatrix = null;
        if (matrix != null) {
            rawMatrix = new float[3][3];
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    rawMatrix[x][y] = matrix[x][y];
                }
            }
        }
        if (matrix != null && matrix[0][0] != 0.0f && (double)matrix[0][1] < 0.001 && (double)matrix[0][1] > -0.001) {
            matrix[0][1] = 0.0f;
        }
        if (matrix != null && matrix[1][1] != 0.0f && (double)matrix[1][0] < 0.001 && (double)matrix[1][0] > -0.001) {
            matrix[1][0] = 0.0f;
        }
        if (inputs != null) {
            for (int aa = 0; aa < 6; ++aa) {
                if (inputs[aa] == 0.0f || !((double)inputs[aa] < 0.001) || !((double)inputs[aa] > -0.001)) continue;
                inputs[aa] = 0.0f;
            }
        }
        if (matrix != null && matrix[0][0] < 0.0f && matrix[1][1] < 0.0f) {
            matrix[0][0] = -matrix[0][0];
            matrix[1][1] = -matrix[1][1];
            if (inputs != null) {
                inputs[0] = -inputs[0];
                inputs[3] = -inputs[3];
            }
        }
        boolean isRotated = false;
        boolean isUpsideDown = false;
        boolean isSideways = false;
        if (matrix != null) {
            boolean bl = isRotated = matrix[1][0] != 0.0f && matrix[0][1] != 0.0f && matrix[0][0] != 0.0f && matrix[1][1] != 0.0f;
            if (isRotated && matrix[0][0] != 0.0f && (double)matrix[0][0] < 0.001 && matrix[1][1] != 0.0f && (double)matrix[1][1] < 0.001) {
                isRotated = false;
                matrix[0][0] = -matrix[0][1];
                matrix[1][1] = -matrix[1][0];
                matrix[1][0] = 0.0f;
                matrix[0][1] = 0.0f;
            }
            if ((!isRotated || !(matrix[0][0] > 0.0f) || !(matrix[0][1] < 0.0f) || !(matrix[1][0] > 0.0f) || !(matrix[1][1] > 0.0f)) && isRotated && matrix[0][0] < 0.0f && matrix[0][1] < 0.0f && matrix[1][0] < 0.0f && matrix[1][1] > 0.0f) {
                matrix[0][0] = -matrix[0][0];
                matrix[1][0] = -matrix[1][0];
                isSideways = true;
            }
            boolean bl2 = isUpsideDown = matrix[1][1] < 0.0f || matrix[0][1] < 0.0f;
            if (matrix[0][0] > 0.0f && matrix[0][1] < 0.0f && matrix[1][0] > 0.0f && matrix[1][1] > 0.0f) {
                isUpsideDown = false;
            }
            if (matrix[0][0] > 0.1f && (isRotated || isUpsideDown)) {
                tesslateOntoImage = false;
            }
            if (isUpsideDown && matrix[0][1] > 0.0f && matrix[1][0] > 0.0f) {
                isUpsideDown = false;
            }
        }
        int rawXStep = (int)PatternObj.getFloatNumber(591672680);
        int rawYStep = (int)PatternObj.getFloatNumber(591672681);
        int XStep = rawXStep;
        int YStep = rawYStep;
        if (XStep == 0) {
            XStep = 1;
        }
        if (YStep == 0) {
            YStep = 1;
        }
        if (XStep < 0) {
            XStep = -XStep;
        }
        if (YStep < 0) {
            YStep = -YStep;
        }
        float dx = 0.0f;
        float dy = 0.0f;
        int input_dxx = 0;
        int input_dyy = 0;
        if (matrix != null) {
            if (matrix[1][1] < 0.0f) {
                matrix[2][1] = YStep;
            }
            if ((double)matrix[1][0] != 0.0) {
                matrix[2][1] = -matrix[1][0];
            }
        }
        ObjectStore localStore = new ObjectStore(null);
        DynamicVectorRenderer glyphDisplay = this.decodePatternContent(PatternObj, matrix, streamData, localStore);
        BufferedImage image = glyphDisplay.getSingleImagePattern();
        if (inputs != null && (double)inputs[0] < 1.5 && (double)inputs[3] < 1.5 && inputs[1] == 0.0f && inputs[2] == 0.0f && (image != null || rawXStep == Short.MIN_VALUE && rawYStep == Short.MIN_VALUE)) {
            AffineTransform image_at2 = new AffineTransform();
            image_at2.scale(1.0, -1.0);
            image_at2.translate(0.0, -image.getHeight());
            AffineTransformOp invert3 = new AffineTransformOp(image_at2, null);
            image = invert3.filter(image, null);
            if (image.getType() != 2) {
                image = ColorSpaceConvertor.convertToARGB(image);
            }
            return new PdfTexturePaint(image, new Rectangle((int)(inputs[4] - (float)image.getWidth()), (int)(inputs[5] - (float)image.getHeight()), image.getWidth(), image.getHeight()));
        }
        float rawWidth = 0.0f;
        float rawHeight = 0.0f;
        boolean isDownSampled = false;
        if (matrix != null) {
            rawWidth = matrix[0][0];
            if (rawWidth == 0.0f) {
                rawWidth = matrix[0][1];
            }
            if (rawWidth < 0.0f) {
                rawWidth = -rawWidth;
            }
            if ((rawHeight = matrix[1][1]) == 0.0f) {
                rawHeight = matrix[1][0];
            }
            if (rawHeight < 0.0f) {
                rawHeight = -rawHeight;
            }
        }
        if (matrix != null) {
            if (inputs != null && inputs[0] > 1.0f && inputs[3] > 1.0f && !isRotated) {
                img = new BufferedImage((int)((float)XStep * rawWidth), (int)((float)YStep * rawHeight), 2);
                Graphics2D g2 = img.createGraphics();
                g2.setClip(new Rectangle(0, 0, img.getWidth(), img.getHeight()));
                glyphDisplay.setG2(g2);
                glyphDisplay.paint(null, new AffineTransform(matrix[0][0], matrix[0][1], matrix[1][0], matrix[1][1], inputs[4], -inputs[5] / 2.0f), null);
            } else {
                BufferedImage tileImg = null;
                dx = matrix[0][0];
                dy = matrix[1][1];
                if (dx == 0.0f) {
                    dx = matrix[0][1];
                }
                if (dx < 0.0f) {
                    dx = -dx;
                }
                if (dy == 0.0f) {
                    dy = matrix[1][0];
                }
                if (dy < 0.0f) {
                    dy = -dy;
                }
                dx *= (float)XStep;
                dy *= (float)YStep;
                int imgW = XStep;
                int imgH = YStep;
                if (!isRotated) {
                    int rectX;
                    int tileH;
                    int tileW;
                    if (isUpsideDown) {
                        int xCount = (int)((float)XStep / dx);
                        int yCount = (int)((float)YStep / dy);
                        if (xCount > 0 && yCount > 0) {
                            imgW = (int)((float)(xCount + 1) * dx);
                            imgH = (int)((float)(yCount + 1) * dy);
                            XStep = imgW;
                            YStep = imgH;
                        }
                    } else if (inputs != null && inputs[0] > 0.0f && inputs[0] < 1.0f && inputs[3] > 0.0f && inputs[3] < 1.0f) {
                        imgW = (int)dx;
                        imgH = (int)dy;
                        if (imgH == 0) {
                            imgH = 1;
                        }
                        if ((input_dxx = (int)inputs[4]) > XStep) {
                            while (input_dxx > 0 && (input_dxx -= XStep) != 0) {
                            }
                            input_dxx /= 2;
                        }
                        if ((input_dyy = (int)inputs[5]) > imgH) {
                            while (input_dyy > 0) {
                                input_dyy -= imgH;
                            }
                        }
                    }
                    if (isDownSampled) {
                        img = new BufferedImage((int)(rawWidth + 0.5f), (int)(rawHeight + 0.5f), 2);
                        imageScale = AffineTransform.getScaleInstance((float)XStep / rawWidth, (float)YStep / rawHeight);
                    } else {
                        img = imgW < 1 || imgH < 1 ? new BufferedImage(1, 1, 2) : new BufferedImage(imgW, imgH, 2);
                    }
                    Graphics2D g2 = img.createGraphics();
                    AffineTransform defaultAf = g2.getTransform();
                    g2.setClip(new Rectangle(0, 0, img.getWidth(), img.getHeight()));
                    int startX = 0;
                    Rectangle actualTileRect = glyphDisplay.getOccupiedArea().getBounds();
                    int dxx = 0;
                    int dyy = 0;
                    if (actualTileRect.x < 0) {
                        tileW = actualTileRect.width - actualTileRect.x;
                        dxx = actualTileRect.x;
                    } else {
                        tileW = actualTileRect.width + actualTileRect.x;
                    }
                    if (actualTileRect.y < 0) {
                        tileH = actualTileRect.height - actualTileRect.y;
                        dyy = actualTileRect.y;
                    } else {
                        tileH = actualTileRect.height + actualTileRect.y;
                    }
                    if (tileH == 0) {
                        tileH = 1;
                    }
                    if (tesslateOntoImage) {
                        tileImg = tileW < 1 || tileH < 1 ? new BufferedImage(1, 1, 2) : new BufferedImage(tileW, tileH, 2);
                        Graphics2D tileG2 = tileImg.createGraphics();
                        tileG2.translate(-dxx, -dyy);
                        glyphDisplay.setG2(tileG2);
                        glyphDisplay.paint(null, null, null);
                    }
                    if ((rectX = actualTileRect.x) < 0 && !tesslateOntoImage) {
                        startX = (int)((float)(-rectX) * matrix[0][0]);
                    }
                    float max = YStep;
                    if (tesslateOntoImage) {
                        max = YStep + tileImg.getHeight() * 2;
                    }
                    int min = 0;
                    if (matrix[1][1] < 0.0f) {
                        min = (int)(-max / 2.0f);
                    }
                    if (needsAdjusting && matrix[0][0] > 0.0f && matrix[1][1] < 0.0f) {
                        min += this.pageHeight - this.pageWidth;
                    }
                    for (float y = (float)min; y < max; y += dy) {
                        for (float x = (float)startX; x < (float)XStep; x += dx) {
                            if (isUpsideDown) {
                                g2.translate(x, -y);
                            } else {
                                g2.translate(x, y);
                            }
                            if (tesslateOntoImage) {
                                AffineTransform tileAff = new AffineTransform();
                                ColorSpaceConvertor.drawImage(g2, tileImg, tileAff, null);
                            } else {
                                glyphDisplay.setG2(g2);
                                glyphDisplay.paint(null, imageScale, null);
                            }
                            g2.setTransform(defaultAf);
                        }
                    }
                }
            }
        } else {
            if (isDownSampled) {
                img = new BufferedImage((int)(rawWidth + 0.5f), (int)(rawHeight + 0.5f), 2);
                imageScale = AffineTransform.getScaleInstance((float)XStep / rawWidth, (float)YStep / rawHeight);
            } else {
                img = new BufferedImage(XStep, YStep, 2);
            }
            Graphics2D g2 = img.createGraphics();
            glyphDisplay.setG2(g2);
            glyphDisplay.paint(null, null, null);
            if (isUpsideDown && img.getHeight() > 1) {
                AffineTransform flip = new AffineTransform();
                flip.translate(0.0, img.getHeight());
                flip.scale(1.0, -1.0);
                AffineTransformOp invert = new AffineTransformOp(flip, ColorSpaces.hints);
                img = invert.filter(img, null);
            }
        }
        localStore.flush();
        if (img != null) {
            paint = new PdfTexturePaint(img, new Rectangle(input_dxx, input_dyy, img.getWidth(), img.getHeight()));
        }
        if (isRotated) {
            paint = new RotatedTexturePaint(isSideways, rawMatrix, PatternObj, tesslateOntoImage, glyphDisplay, matrix, XStep, YStep, dx, dy, imageScale);
        }
        if (paint != null) {
            this.cachedPaints.put(PatternObj.getObjectRefAsString(), paint);
        }
        return paint;
    }

    private DynamicVectorRenderer decodePatternContent(PdfObject PatternObj, float[][] matrix, byte[] streamData, ObjectStore localStore) {
        PatternDisplay glyphDisplay;
        block4: {
            PdfObject Resources = PatternObj.getDictionary(2004251818);
            PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(this.currentPdfFile);
            glyphDecoder.setParameters(false, true, 7, 0);
            glyphDecoder.setIntValue(-12, 1);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDisplay = new PatternDisplay(0, false, 20, localStore);
            glyphDisplay.setOptimisedRotation(false);
            try {
                glyphDecoder.setObjectValue(23, glyphDisplay);
                if (Resources != null) {
                    glyphDecoder.readResources(Resources, true);
                }
                glyphDecoder.setDefaultColors(this.gs.getStrokeColor(), this.gs.getNonstrokeColor());
                GraphicsState currentGraphicsState = new GraphicsState(0, 0);
                if (matrix != null) {
                    currentGraphicsState.CTM = matrix;
                }
                glyphDecoder.decodePageContent(currentGraphicsState, streamData);
            }
            catch (PdfException e) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return glyphDisplay;
    }

    private PdfPaint setupShading(PdfObject PatternObj, float[][] matrix) {
        PdfObject Shading = PatternObj.getDictionary(878474856);
        PdfObject ColorSpace2 = Shading.getDictionary(2087749783);
        GenericColorSpace newColorSpace = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, ColorSpace2);
        if (newColorSpace.getID() == 1247168582 && ColorSpace2.getParameterConstant(2054519176) == 1498837125) {
            newColorSpace = new DeviceCMYKColorSpace();
        }
        return new ShadedPaint(Shading, this.isPrinting, newColorSpace, this.currentPdfFile, matrix, this.colorsReversed, this.CTM);
    }
}

