/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Map;
import org.jpedal.fonts.CIDFontType2;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class CIDFontType0
extends Type1C {
    private static final long serialVersionUID = -5257169845658130184L;
    private CIDFontType2 subFont = null;

    public CIDFontType0(PdfObjectReader currentPdfFile, String substituteFontFile) {
        this.glyphs = new T1Glyphs(true);
        this.isCID = true;
        this.isCIDFont = true;
        this.TTstreamisCID = true;
        this.init(currentPdfFile);
        this.currentPdfFile = currentPdfFile;
        this.substituteFontFile = substituteFontFile;
    }

    @Override
    public void createFont(PdfObject pdfObject, String fontID, boolean renderPage, ObjectStore objectStore, Map substitutedFonts) throws Exception {
        this.fontTypes = -1684566726;
        this.fontID = fontID;
        PdfObject Descendent = pdfObject.getDictionary(-1547306032);
        PdfObject pdfFontDescriptor = Descendent.getDictionary(-1044665361);
        this.createCIDFont(pdfObject, Descendent);
        if (pdfFontDescriptor != null) {
            float value;
            float[] newFontBBox = pdfFontDescriptor.getFloatArray(676429196);
            if (newFontBBox != null) {
                this.FontBBox = newFontBBox;
            }
            if ((value = pdfFontDescriptor.getFloatNumber(859131783)) != 0.0f) {
                this.ascent = value;
            }
            if ((value = pdfFontDescriptor.getFloatNumber(860451719)) != 0.0f) {
                this.descent = value;
            }
            this.readEmbeddedFont(pdfFontDescriptor);
        }
        if (renderPage && !this.isFontEmbedded && this.substituteFontFile != null) {
            this.isFontSubstituted = true;
            this.subFont = new CIDFontType2(this.currentPdfFile, this.TTstreamisCID);
            this.subFont.substituteFontUsed(this.substituteFontFile);
            this.isFontEmbedded = true;
            this.glyphs.setFontEmbedded(true);
        }
        if (!this.isFontEmbedded) {
            this.selectDefaultFont();
        }
        if (renderPage) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    @Override
    public PdfJavaGlyphs getGlyphData() {
        if (this.subFont != null) {
            return this.subFont.getGlyphData();
        }
        return this.glyphs;
    }
}

