/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class T1Glyphs
extends PdfJavaGlyphs {
    private static final long serialVersionUID = 2482425584824639998L;
    private static String nybChars = "0123456789.ee -";
    public boolean is1C = false;
    private String[] charForGlyphIndex;
    protected Map charStrings = new HashMap();
    protected Map glyphNumbers = new HashMap();
    int max = 100;
    double[] operandsRead = new double[this.max];
    int operandReached = 0;
    float[] pt;
    private double xs = -1.0;
    private double ys = -1.0;
    private double x = 0.0;
    private double y = 0.0;
    private int ptCount = 0;
    int currentOp = 0;
    private int hintCount = 0;
    private boolean allowAll = false;
    private double h;
    private boolean isCID;
    private int[] nominalWidthX = new int[]{0};
    private int[] defaultWidthX = new int[]{0};
    private boolean defaultWidthsPassed = false;
    private int[] fdSelect = null;
    DynamicVectorRenderer dynamicVectorRenderer = null;

    public T1Glyphs(boolean isCID) {
        this.isCID = isCID;
    }

    public T1Glyphs(boolean isCID, boolean is1C) {
        this.charForGlyphIndex = new String[65536];
    }

    public T1Glyphs() {
    }

    public static String[] readFontNames(FontData fontData, int mode) {
        String[] fontNames;
        block9: {
            BufferedReader br;
            block8: {
                int nameEnd;
                int nameStart;
                fontNames = new String[]{null};
                br = new BufferedReader(new StringReader(new String(fontData.getBytes(0, fontData.length()))));
                String line = null;
                do {
                    block7: {
                        try {
                            line = br.readLine();
                        }
                        catch (IOException e) {
                            if (!LogWriter.isOutput()) break block7;
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                    }
                    if (line == null) break block8;
                } while (!line.startsWith("/FontName") || (nameStart = line.indexOf(47, 9)) == -1 || (nameEnd = line.indexOf(32, nameStart)) == -1);
                String name = line.substring(nameStart + 1, nameEnd);
                fontNames[0] = name.toLowerCase();
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception " + e + " closing stream");
                }
            }
        }
        if (fontData != null) {
            fontData.close();
        }
        return fontNames;
    }

    private boolean processFlex(GlyphFactory factory, boolean debug, int lastKey, boolean isFlex, int routine) {
        if (isFlex && this.ptCount == 14 && routine == 0) {
            isFlex = false;
            for (int i = 0; i < 12; i += 6) {
                factory.curveTo(this.pt[i], this.pt[i + 1], this.pt[i + 2], this.pt[i + 3], this.pt[i + 4], this.pt[i + 5]);
                if (!debug) continue;
                System.out.println("t1 flex " + this.pt[i] + ' ' + this.pt[i + 1] + ' ' + this.pt[i + 2] + ' ' + this.pt[i + 3] + ' ' + this.pt[i + 4] + ' ' + this.pt[i + 5]);
            }
        } else if (!isFlex && routine >= 0 && routine <= 2) {
            isFlex = true;
            this.ptCount = 0;
            this.pt = new float[16];
            if (debug) {
                System.out.println("flex on " + lastKey + ' ' + routine);
            }
        }
        return isFlex;
    }

    private void endchar(GlyphFactory factory, int rawInt, boolean debug, int dicEnd) {
        if (debug) {
            System.out.println("Endchar");
        }
        if (this.operandReached == 5) {
            --this.operandReached;
            ++this.currentOp;
        }
        if (this.operandReached == 4) {
            this.endchar(factory, rawInt);
        } else {
            factory.closePath();
        }
    }

    private int mask(boolean debug, int p, int lastKey) {
        if (debug) {
            System.out.println("hintmask/cntrmask " + lastKey);
        }
        this.hintCount += this.operandReached / 2;
        if (debug) {
            System.out.println("hintCount=" + this.hintCount);
        }
        for (int count = this.hintCount; count > 0; count -= 8) {
            ++p;
        }
        return p;
    }

    private double sbw(boolean debug) {
        double val;
        this.y = val = this.operandsRead[this.operandReached - 2];
        this.xs = this.x = (val = this.operandsRead[this.operandReached - 1]);
        this.ys = this.y;
        this.allowAll = true;
        double yy = this.y;
        this.h = this.operandsRead[this.operandReached - 3];
        if (debug) {
            System.out.println("sbw xs,ys set to " + this.x + ' ' + this.y);
        }
        return yy;
    }

    private void hmoveto(GlyphFactory factory, boolean debug, boolean isFirst) {
        if (isFirst && this.operandReached == 2) {
            ++this.currentOp;
        }
        double val = this.operandsRead[this.currentOp];
        this.x += val;
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (debug) {
            System.out.println("reset xs,ys to " + this.x + ' ' + this.y);
        }
        if (debug) {
            System.out.println("hmoveto " + this.x + ' ' + this.y);
        }
    }

    private void rmoveto(GlyphFactory factory, boolean debug, boolean isFirst) {
        if (isFirst && this.operandReached == 3) {
            ++this.currentOp;
        }
        if (debug) {
            System.out.println(this.currentOp + " " + this.operandReached + ' ' + isFirst + " x,y=(" + this.x + ' ' + this.y + ") xs,ys=(" + this.xs + ' ' + this.ys + ") rmoveto " + this.operandsRead[this.currentOp] + ' ' + this.operandsRead[this.currentOp + 1]);
        }
        double val = this.operandsRead[this.currentOp + 1];
        this.y += val;
        val = this.operandsRead[this.currentOp];
        this.x += val;
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (debug) {
            System.out.println("xs,ys=(" + this.xs + ' ' + this.ys + ") x=" + this.x + " y=" + this.y);
        }
    }

    private void vhhvcurveto(GlyphFactory factory, boolean debug, int key) {
        boolean isHor;
        boolean bl = isHor = key == 31;
        while (this.operandReached >= 4) {
            this.operandReached -= 4;
            if (isHor) {
                this.x += this.operandsRead[this.currentOp];
            } else {
                this.y += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (isHor) {
                this.y += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.x += this.operandsRead[this.currentOp + 4];
                }
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.y += this.operandsRead[this.currentOp + 4];
                }
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (debug) {
                System.out.println(this.currentOp + "vh/hvCurveto " + this.operandsRead[this.currentOp] + ' ' + this.operandsRead[this.currentOp + 1] + ' ' + this.operandsRead[this.currentOp + 2] + ' ' + this.operandsRead[this.currentOp + 3] + ' ' + this.operandsRead[this.currentOp + 4] + ' ' + this.operandsRead[this.currentOp + 5]);
            }
            this.currentOp += 4;
            isHor = !isHor;
        }
    }

    private void vvhhcurveto(GlyphFactory factory, boolean debug, int key) {
        boolean isVV;
        boolean bl = isVV = key == 26;
        if ((this.operandReached & 1) == 1) {
            if (isVV) {
                this.x += this.operandsRead[0];
            } else {
                this.y += this.operandsRead[0];
            }
            ++this.currentOp;
        }
        while (this.currentOp < this.operandReached) {
            if (isVV) {
                this.y += this.operandsRead[this.currentOp];
            } else {
                this.x += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (isVV) {
                this.y += this.operandsRead[this.currentOp + 3];
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            this.currentOp += 4;
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (!debug) continue;
            System.out.println("vv/hhCurveto " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    private void rlinecurve(GlyphFactory factory, boolean debug) {
        for (int lineCount = (this.operandReached - 6) / 2; lineCount > 0; --lineCount) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            factory.lineTo((float)this.x, (float)this.y);
            if (debug) {
                System.out.println("rlineCurve " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
            }
            this.currentOp += 2;
        }
        float[] coords = new float[6];
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        coords[0] = (float)this.x;
        coords[1] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 2];
        this.y += this.operandsRead[this.currentOp + 3];
        coords[2] = (float)this.x;
        coords[3] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 4];
        this.y += this.operandsRead[this.currentOp + 5];
        coords[4] = (float)this.x;
        coords[5] = (float)this.y;
        factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        if (debug) {
            System.out.println("rlineCurve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        this.currentOp += 6;
    }

    private void closepath(GlyphFactory factory, boolean debug) {
        if (this.xs != -1.0) {
            factory.lineTo((float)this.xs, (float)this.ys);
        }
        if (debug) {
            System.out.println("close to xs=" + this.xs + " ys=" + this.ys + ' ' + this.x + ',' + this.y);
        }
        this.xs = -1.0;
    }

    private void hsbw(GlyphFactory factory, String glyphName, boolean debug) {
        this.x += this.operandsRead[0];
        factory.moveTo((float)this.x, 0.0f);
        if (debug) {
            System.out.println("hsbw " + this.x + " xs,ys=" + this.xs + ' ' + this.ys);
        }
        this.allowAll = true;
    }

    private void pop(boolean debug) {
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        if (debug) {
            System.out.println("POP");
        }
        if (debug) {
            for (int i = 0; i < 6; ++i) {
                System.out.println(i + " == " + this.operandsRead[i] + ' ' + this.operandReached);
            }
        }
    }

    private void setcurrentpoint(boolean debug) {
        if (debug) {
            System.out.println("setCurrentPoint " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
        }
    }

    private void div(boolean debug) {
        if (debug) {
            for (int i = 0; i < 6; ++i) {
                System.out.println(i + " " + this.currentOp + ' ' + this.operandsRead[i] + ' ' + this.operandReached);
            }
        }
        double value = this.operandsRead[this.operandReached - 2] / this.operandsRead[this.operandReached - 1];
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        this.operandsRead[this.operandReached - 1] = value;
        if (debug) {
            for (int i = 0; i < 6; ++i) {
                System.out.println("after====" + i + " == " + this.operandsRead[i] + ' ' + this.operandReached);
            }
        }
        if (debug) {
            System.out.println("DIV");
        }
    }

    private void vmoveto(GlyphFactory factory, boolean debug, boolean isFirst) {
        if (isFirst && this.operandReached == 2) {
            ++this.currentOp;
        }
        this.y += this.operandsRead[this.currentOp];
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (debug) {
            System.out.println("Set xs,ys= " + this.xs + ' ' + this.ys);
        }
        if (debug) {
            System.out.println("vmoveto " + this.operandsRead[0] + ' ' + this.operandsRead[1] + " currentOp" + this.currentOp + " y=" + this.y + ' ' + isFirst);
        }
    }

    private void rlineto(GlyphFactory factory, boolean debug) {
        for (int lineCount = this.operandReached / 2; lineCount > 0; --lineCount) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            factory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
            if (!debug) continue;
            System.out.println("x,y= (" + this.x + ' ' + this.y + ") rlineto " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
        }
    }

    private void hvlineto(GlyphFactory factory, boolean debug, int key) {
        boolean isHor = key == 6;
        for (int start = 0; start < this.operandReached; ++start) {
            if (isHor) {
                this.x += this.operandsRead[start];
            } else {
                this.y += this.operandsRead[start];
            }
            factory.lineTo((float)this.x, (float)this.y);
            if (debug) {
                System.out.println("h/vlineto " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
            }
            isHor = !isHor;
        }
    }

    private void rrcurveto(GlyphFactory factory, boolean debug) {
        int curveCount = this.operandReached / 6;
        if (debug && curveCount > 1) {
            System.out.println("**********currentOp=" + this.currentOp + " curves=" + curveCount);
        }
        while (curveCount > 0) {
            float[] coords = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            coords[2] = (float)this.x;
            coords[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            coords[4] = (float)this.x;
            coords[5] = (float)this.y;
            factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            if (debug) {
                System.out.println("rrcurveto " + this.operandsRead[this.currentOp] + ' ' + this.operandsRead[this.currentOp + 1] + ' ' + this.operandsRead[this.currentOp + 2] + ' ' + this.operandsRead[this.currentOp + 3] + ' ' + this.operandsRead[this.currentOp + 4] + ' ' + this.operandsRead[this.currentOp + 5]);
            }
            this.currentOp += 6;
            --curveCount;
        }
    }

    private void endchar(GlyphFactory factory, int rawInt) {
        StandardFonts.checkLoaded(1);
        float adx = (float)(this.x + this.operandsRead[this.currentOp]);
        float ady = (float)(this.y + this.operandsRead[this.currentOp + 1]);
        String bchar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 2]);
        String achar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 3]);
        this.x = 0.0;
        this.y = 0.0;
        this.decodeGlyph(null, factory, bchar, rawInt, "", 0.0f, true);
        factory.closePath();
        factory.moveTo(adx, ady);
        this.x = adx;
        this.y = ady;
        this.decodeGlyph(null, factory, achar, rawInt, "", 0.0f, true);
        if (this.xs == -1.0) {
            this.xs = this.x;
            this.ys = this.y;
            System.out.println("ENDCHAR Set xs,ys= " + this.xs + ' ' + this.ys);
        }
    }

    private void rcurveline(GlyphFactory factory, boolean debug) {
        for (int curveCount = (this.operandReached - 2) / 6; curveCount > 0; --curveCount) {
            float[] coords = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            coords[2] = (float)this.x;
            coords[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            coords[4] = (float)this.x;
            coords[5] = (float)this.y;
            factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            if (debug) {
                System.out.println("rCurveline " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
            }
            this.currentOp += 6;
        }
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        factory.lineTo((float)this.x, (float)this.y);
        this.currentOp += 2;
        if (debug) {
            System.out.println("rCurveline " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
        }
    }

    private void seac(GlyphFactory factory, int rawInt, int currentOp) {
        StandardFonts.checkLoaded(1);
        float adx = (float)this.operandsRead[currentOp + 1];
        float ady = (float)this.operandsRead[currentOp + 2];
        String bchar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[currentOp + 3]);
        String achar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[currentOp + 4]);
        double preX = this.x;
        this.y = 0.0;
        this.decodeGlyph(null, factory, bchar, rawInt, "", 0.0f, true);
        factory.closePath();
        factory.moveTo(0.0f, 0.0f);
        this.x = (double)adx + preX;
        this.y = ady;
        this.decodeGlyph(null, factory, achar, rawInt, "", 0.0f, true);
    }

    private void flex1(GlyphFactory factory, boolean debug) {
        int points;
        double dx = 0.0;
        double dy = 0.0;
        double x1 = this.x;
        double y1 = this.y;
        for (int count = 0; count < 10; count += 2) {
            dx += this.operandsRead[count];
            dy += this.operandsRead[count + 1];
        }
        boolean isHorizontal = Math.abs(dx) > Math.abs(dy);
        for (points = 0; points < 6; points += 2) {
            this.x += this.operandsRead[points];
            this.y += this.operandsRead[points + 1];
            this.pt[points] = (float)this.x;
            this.pt[points + 1] = (float)this.y;
        }
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (debug) {
            System.out.println("flex1 first curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        for (points = 0; points < 4; points += 2) {
            this.x += this.operandsRead[points + 6];
            this.y += this.operandsRead[points + 7];
            this.pt[points] = (float)this.x;
            this.pt[points + 1] = (float)this.y;
        }
        if (isHorizontal) {
            this.x += this.operandsRead[10];
            this.y = y1;
        } else {
            this.x = x1;
            this.y += this.operandsRead[10];
        }
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (debug) {
            System.out.println("flex1 second curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    private void flex(GlyphFactory factory, boolean debug) {
        for (int curves = 0; curves < 12; curves += 6) {
            for (int points = 0; points < 6; points += 2) {
                this.x += this.operandsRead[curves + points];
                this.y += this.operandsRead[curves + points + 1];
                this.pt[points] = (float)this.x;
                this.pt[points + 1] = (float)this.y;
            }
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (!debug) continue;
            System.out.println("flex " + this.pt[0] + ' ' + this.pt[1] + ' ' + this.pt[2] + ' ' + this.pt[3] + ' ' + this.pt[4] + ' ' + this.pt[5]);
        }
    }

    private void hflex(GlyphFactory factory, boolean debug) {
        this.x += this.operandsRead[0];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[1];
        this.y += this.operandsRead[2];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[3];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (debug) {
            System.out.println("hflex first curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        this.x += this.operandsRead[4];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[5];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[6];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (debug) {
            System.out.println("hflex second curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    private void hflex1(GlyphFactory factory, boolean debug) {
        this.x += this.operandsRead[0];
        this.y += this.operandsRead[1];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[2];
        this.y += this.operandsRead[3];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[4];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (debug) {
            System.out.println("36 first curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        this.x += this.operandsRead[5];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[6];
        this.y += this.operandsRead[7];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[8];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (debug) {
            System.out.println("36 second curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] Trm, int rawInt, String displayValue, float currentWidth, String key) {
        PdfGlyph transformedGlyph2;
        if (this.lastTrm[0][0] != Trm[0][0] | this.lastTrm[1][0] != Trm[1][0] | this.lastTrm[0][1] != Trm[0][1] | this.lastTrm[1][1] != Trm[1][1]) {
            this.lastTrm = Trm;
            this.flush();
        }
        if ((transformedGlyph2 = this.getEmbeddedCachedShape(rawInt)) == null) {
            this.operandsRead = new double[this.max];
            this.operandReached = 0;
            this.x = -factory.getLSB();
            this.y = 0.0;
            this.decodeGlyph(key, factory, glyph, rawInt, displayValue, currentWidth, false);
            transformedGlyph2 = factory.getGlyph(false);
            if (transformedGlyph2 != null) {
                transformedGlyph2.setID(rawInt);
            }
            this.setEmbeddedCachedShape(rawInt, transformedGlyph2);
        }
        return transformedGlyph2;
    }

    @Override
    public final int getNumber(byte[] fontDataAsArray, int pos, double[] values, int valuePointer, boolean debug) {
        double x = 0.0;
        int b0 = fontDataAsArray[pos] & 0xFF;
        if (b0 < 28 | b0 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (b0 == 28) {
            x = (fontDataAsArray[pos + 1] << 8) + (fontDataAsArray[pos + 2] & 0xFF);
            pos += 3;
        } else if (b0 == 255) {
            if (this.is1C) {
                x = ((fontDataAsArray[pos + 1] & 0xFF) << 8) + (fontDataAsArray[pos + 2] & 0xFF);
                x += (double)(((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF)) / 65536.0;
                if (fontDataAsArray[pos + 1] < 0) {
                    x -= 65536.0;
                }
                if (debug) {
                    System.out.println("x=" + x);
                    for (int j = 0; j < 5; ++j) {
                        System.out.println(j + " " + fontDataAsArray[pos + j] + ' ' + (fontDataAsArray[pos + j] & 0xFF) + ' ' + (fontDataAsArray[pos + j] & 0x7F));
                    }
                }
            } else {
                x = ((fontDataAsArray[pos + 1] & 0xFF) << 24) + ((fontDataAsArray[pos + 2] & 0xFF) << 16) + ((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF);
            }
            pos += 5;
        } else if (b0 == 29) {
            x = ((fontDataAsArray[pos + 1] & 0xFF) << 24) + ((fontDataAsArray[pos + 2] & 0xFF) << 16) + ((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF);
            pos += 5;
        } else if (b0 == 30) {
            char[] buf = new char[65];
            ++pos;
            int i = 0;
            while (i < 64) {
                int b = fontDataAsArray[pos++] & 0xFF;
                int nyb0 = b >> 4 & 0xF;
                int nyb1 = b & 0xF;
                if (nyb0 == 15) break;
                buf[i++] = nybChars.charAt(nyb0);
                if (i == 64) break;
                if (nyb0 == 12) {
                    buf[i++] = 45;
                }
                if (i == 64 || nyb1 == 15) break;
                buf[i++] = nybChars.charAt(nyb1);
                if (i == 64) break;
                if (nyb1 != 12) continue;
                buf[i++] = 45;
            }
            x = Double.valueOf(new String(buf, 0, i));
        } else if (b0 < 247) {
            x = b0 - 139;
            ++pos;
        } else if (b0 < 251) {
            x = (b0 - 247 << 8) + (fontDataAsArray[pos + 1] & 0xFF) + 108;
            pos += 2;
        } else {
            x = -(b0 - 251 << 8) - (fontDataAsArray[pos + 1] & 0xFF) - 108;
            pos += 2;
        }
        values[valuePointer] = x;
        return pos;
    }

    @Override
    public final int getNumber(FontData fontDataAsObject, int pos, double[] values, int valuePointer, boolean debug) {
        double x = 0.0;
        int b0 = fontDataAsObject.getByte(pos) & 0xFF;
        if (b0 < 28 | b0 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (b0 == 28) {
            x = (fontDataAsObject.getByte(pos + 1) << 8) + (fontDataAsObject.getByte(pos + 2) & 0xFF);
            pos += 3;
        } else if (b0 == 255) {
            if (this.is1C) {
                int top = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 2) & 0xFF);
                if (top > 32768) {
                    top = 65536 - top;
                }
                double numb = top;
                double dec = ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
                x = numb + dec / 65536.0;
                if (fontDataAsObject.getByte(pos + 1) < 0) {
                    if (debug) {
                        System.out.println("Negative " + x);
                    }
                    x = -x;
                }
                if (debug) {
                    System.out.println("x=" + x);
                    for (int j = 0; j < 5; ++j) {
                        System.out.println(j + " " + fontDataAsObject.getByte(pos + j) + ' ' + (fontDataAsObject.getByte(pos + j) & 0xFF) + ' ' + (fontDataAsObject.getByte(pos + j) & 0x7F));
                    }
                }
            } else {
                x = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 24) + ((fontDataAsObject.getByte(pos + 2) & 0xFF) << 16) + ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
            }
            pos += 5;
        } else if (b0 == 29) {
            x = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 24) + ((fontDataAsObject.getByte(pos + 2) & 0xFF) << 16) + ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
            pos += 5;
        } else if (b0 == 30) {
            char[] buf = new char[65];
            ++pos;
            int i = 0;
            while (i < 64) {
                int b = fontDataAsObject.getByte(pos++) & 0xFF;
                int nyb0 = b >> 4 & 0xF;
                int nyb1 = b & 0xF;
                if (nyb0 == 15) break;
                buf[i++] = nybChars.charAt(nyb0);
                if (i == 64) break;
                if (nyb0 == 12) {
                    buf[i++] = 45;
                }
                if (i == 64 || nyb1 == 15) break;
                buf[i++] = nybChars.charAt(nyb1);
                if (i == 64) break;
                if (nyb1 != 12) continue;
                buf[i++] = 45;
            }
            x = Double.valueOf(new String(buf, 0, i));
        } else if (b0 < 247) {
            x = b0 - 139;
            ++pos;
        } else if (b0 < 251) {
            x = (b0 - 247 << 8) + (fontDataAsObject.getByte(pos + 1) & 0xFF) + 108;
            pos += 2;
        } else {
            x = -(b0 - 251 << 8) - (fontDataAsObject.getByte(pos + 1) & 0xFF) - 108;
            pos += 2;
        }
        values[valuePointer] = x;
        return pos;
    }

    protected void decodeGlyph(String embKey, GlyphFactory factory, String glyph, int rawInt, String displayValue, float currentWidth, boolean isRecursive) {
        block96: {
            int j;
            byte[] glyphStream;
            boolean debug = false;
            this.allowAll = false;
            if (this.isCID) {
                glyphStream = (byte[])this.charStrings.get(String.valueOf(rawInt));
            } else {
                if (glyph == null) {
                    glyph = displayValue;
                }
                if (glyph == null && (glyph = embKey) == null) {
                    glyph = ".notdef";
                }
                if ((glyphStream = (byte[])this.charStrings.get(glyph)) == null) {
                    if (embKey != null) {
                        glyphStream = (byte[])this.charStrings.get(embKey);
                    }
                    if (glyphStream == null) {
                        glyphStream = (byte[])this.charStrings.get(".notdef");
                    }
                }
            }
            if (glyphStream == null) break block96;
            boolean isFirst = true;
            this.ptCount = 0;
            int commandCount = -1;
            int p = 0;
            int lastNumberStart = 0;
            int key = 0;
            int dicEnd = glyphStream.length;
            int lastVal = 0;
            this.currentOp = 0;
            this.hintCount = 0;
            double ymin = 999999.0;
            double ymax = 0.0;
            double yy = 1000.0;
            boolean isFlex = false;
            this.pt = new float[6];
            int potentialWidth = 0;
            this.h = 100000.0;
            if (this.is1C) {
                this.operandsRead = new double[this.max];
                this.operandReached = 0;
                this.allowAll = true;
            }
            if (debug) {
                System.out.println("****************** " + displayValue + ' ' + glyph);
                for (j = 0; j < dicEnd; ++j) {
                    System.out.println(j + " " + (glyphStream[j] & 0xFF));
                }
                System.out.println("=====xs=" + this.xs + " ys=" + this.ys);
            }
            while (p < dicEnd) {
                block98: {
                    boolean isNumber;
                    block100: {
                        int lastKey;
                        block107: {
                            block109: {
                                byte[] newStream;
                                block108: {
                                    block106: {
                                        block105: {
                                            block104: {
                                                block103: {
                                                    block102: {
                                                        block101: {
                                                            block99: {
                                                                block97: {
                                                                    int nextVal = glyphStream[p] & 0xFF;
                                                                    if (nextVal > 31 || nextVal == 28) {
                                                                        lastNumberStart = p;
                                                                        p = this.getNumber(glyphStream, p, this.operandsRead, this.operandReached, debug);
                                                                        lastVal = (int)this.operandsRead[this.operandReached];
                                                                        ++this.operandReached;
                                                                        if (lastNumberStart == 0) {
                                                                            if (this.nominalWidthX.length == 1) {
                                                                                potentialWidth = this.nominalWidthX[0] + lastVal;
                                                                            } else {
                                                                                int glyphNo = (Integer)this.glyphNumbers.get("" + rawInt) - 1;
                                                                                if (glyphNo < this.fdSelect.length) {
                                                                                    potentialWidth = this.nominalWidthX[this.fdSelect[glyphNo]] + lastVal;
                                                                                }
                                                                            }
                                                                        }
                                                                        if (nextVal != 28 || !debug) continue;
                                                                        System.out.println("Shortint " + lastVal);
                                                                        continue;
                                                                    }
                                                                    ++commandCount;
                                                                    isNumber = false;
                                                                    lastKey = key;
                                                                    key = nextVal;
                                                                    ++p;
                                                                    this.currentOp = 0;
                                                                    if (key != 12) break block97;
                                                                    key = glyphStream[p] & 0xFF;
                                                                    ++p;
                                                                    if (key == 7) {
                                                                        yy = this.sbw(debug);
                                                                        this.operandReached = 0;
                                                                    } else if (this.allowAll) {
                                                                        if (key == 16) {
                                                                            isFlex = this.processFlex(factory, debug, lastKey, isFlex, lastVal);
                                                                            this.operandReached = 0;
                                                                        } else if (key == 33) {
                                                                            this.setcurrentpoint(debug);
                                                                            this.operandReached = 0;
                                                                        } else if (key == 34) {
                                                                            this.hflex(factory, debug);
                                                                            this.operandReached = 0;
                                                                        } else if (key == 35) {
                                                                            this.flex(factory, debug);
                                                                            this.operandReached = 0;
                                                                        } else if (key == 36) {
                                                                            this.hflex1(factory, debug);
                                                                            this.operandReached = 0;
                                                                        } else if (key == 37) {
                                                                            this.flex1(factory, debug);
                                                                            this.operandReached = 0;
                                                                        } else if (key == 6) {
                                                                            this.seac(factory, rawInt, this.currentOp);
                                                                            this.operandReached = 0;
                                                                        } else if (key == 12) {
                                                                            this.div(debug);
                                                                        } else if (key == 17) {
                                                                            this.pop(debug);
                                                                        } else if (key == 0) {
                                                                            this.operandReached = 0;
                                                                            if (debug) {
                                                                                System.out.println("Dot section");
                                                                            }
                                                                        } else if (debug) {
                                                                            this.operandReached = 0;
                                                                            System.out.println("1 Not implemented " + p + " id=" + key + " op=" + Type1.T1C[key]);
                                                                        } else {
                                                                            this.operandReached = 0;
                                                                        }
                                                                    }
                                                                    break block98;
                                                                }
                                                                if (key != 13) break block99;
                                                                this.hsbw(factory, glyph, debug);
                                                                this.operandReached = 0;
                                                                break block98;
                                                            }
                                                            if (!this.allowAll) break block98;
                                                            if (key == 0) break block100;
                                                            if (!(key == 1 | key == 3 | key == 18 | key == 23)) break block101;
                                                            this.hintCount += this.operandReached / 2;
                                                            this.operandReached = 0;
                                                            if (debug) {
                                                                System.out.println("One of hstem vstem hstemhm vstemhm " + key + ' ' + this.xs + ' ' + this.ys);
                                                            }
                                                            break block100;
                                                        }
                                                        if (key != 4) break block102;
                                                        if (isFlex) {
                                                            double val = this.operandsRead[this.currentOp];
                                                            this.y += val;
                                                            this.pt[this.ptCount] = (float)this.x;
                                                            ++this.ptCount;
                                                            this.pt[this.ptCount] = (float)this.y;
                                                            ++this.ptCount;
                                                            if (debug) {
                                                                System.out.println("flex value " + this.x + ' ' + this.y);
                                                            }
                                                        } else {
                                                            this.vmoveto(factory, debug, isFirst);
                                                        }
                                                        this.operandReached = 0;
                                                        break block100;
                                                    }
                                                    if (key != 5) break block103;
                                                    this.rlineto(factory, debug);
                                                    this.operandReached = 0;
                                                    break block100;
                                                }
                                                if (!(key == 6 | key == 7)) break block104;
                                                this.hvlineto(factory, debug, key);
                                                this.operandReached = 0;
                                                break block100;
                                            }
                                            if (key != 8) break block105;
                                            this.rrcurveto(factory, debug);
                                            this.operandReached = 0;
                                            break block100;
                                        }
                                        if (key != 9) break block106;
                                        this.closepath(factory, debug);
                                        this.operandReached = 0;
                                        break block100;
                                    }
                                    if (key != 10 && key != 29) break block107;
                                    if (debug) {
                                        System.out.println(key + " -------------- last Value=" + lastVal + ' ' + this.allowAll + " commandCount=" + commandCount + " operandReached=" + this.operandReached + ' ' + isFirst);
                                    }
                                    if (this.is1C || key != 10 || lastVal < 0 || lastVal > 2 || lastKey == 11 || this.operandReached <= 5) break block108;
                                    isFlex = this.processFlex(factory, debug, lastKey, isFlex, lastVal);
                                    this.operandReached = 0;
                                    break block100;
                                }
                                lastVal = key == 10 ? (lastVal += this.localBias) : (lastVal += this.globalBias);
                                if (key == 10) {
                                    newStream = (byte[])this.charStrings.get("subrs" + lastVal);
                                    if (debug) {
                                        System.out.println("=================callsubr " + lastVal);
                                    }
                                } else {
                                    if (debug) {
                                        System.out.println("=================callgsubr " + lastVal);
                                    }
                                    newStream = (byte[])this.charStrings.get("global" + lastVal);
                                }
                                if (newStream == null) break block109;
                                if (debug) {
                                    System.out.println("Subroutine=============" + lastVal + " op=" + this.currentOp + ' ' + this.operandReached);
                                }
                                int newLength = newStream.length;
                                int oldLength = glyphStream.length;
                                int totalLength = newLength + oldLength - 2;
                                dicEnd = dicEnd + newLength - 2;
                                byte[] combinedStream = new byte[totalLength];
                                System.arraycopy(glyphStream, 0, combinedStream, 0, lastNumberStart);
                                System.arraycopy(newStream, 0, combinedStream, lastNumberStart, newLength);
                                System.arraycopy(glyphStream, p, combinedStream, lastNumberStart + newLength, oldLength - p);
                                glyphStream = combinedStream;
                                p = lastNumberStart;
                                if (this.operandReached > 0) {
                                    --this.operandReached;
                                }
                                break block100;
                            }
                            if (!debug) break block100;
                            System.out.println("No data found for sub-routine " + this.charStrings);
                            break block100;
                        }
                        if (key == 11) {
                            if (debug) {
                                System.out.println("return=============" + p);
                            }
                        } else if (key == 14) {
                            this.endchar(factory, rawInt, debug, dicEnd);
                            this.operandReached = 0;
                            p = dicEnd + 1;
                        } else if (key == 16) {
                            if (debug) {
                                System.out.println("Blend");
                            }
                            this.operandReached = 0;
                        } else if (key == 19 | key == 20) {
                            p = this.mask(debug, p, lastKey);
                            this.operandReached = 0;
                        } else if (key == 21) {
                            if (isFlex) {
                                if (debug) {
                                    System.out.println(this.currentOp + " " + this.ptCount + ' ' + this.pt.length);
                                }
                                double val = this.operandsRead[this.currentOp + 1];
                                this.y += val;
                                val = this.operandsRead[this.currentOp];
                                this.x += val;
                                this.pt[this.ptCount] = (float)this.x;
                                ++this.ptCount;
                                this.pt[this.ptCount] = (float)this.y;
                                ++this.ptCount;
                                if (debug) {
                                    System.out.println("flex value " + this.pt[this.ptCount - 2] + ' ' + this.pt[this.ptCount - 1] + " count=" + this.ptCount);
                                }
                            } else {
                                this.rmoveto(factory, debug, isFirst);
                            }
                            this.operandReached = 0;
                        } else if (key == 22) {
                            if (isFlex) {
                                double val = this.operandsRead[this.currentOp];
                                this.x += val;
                                this.pt[this.ptCount] = (float)this.x;
                                ++this.ptCount;
                                this.pt[this.ptCount] = (float)this.y;
                                ++this.ptCount;
                                if (debug) {
                                    System.out.println("flex value " + this.x + ' ' + this.y);
                                }
                            } else {
                                this.hmoveto(factory, debug, isFirst);
                            }
                            this.operandReached = 0;
                        } else if (key == 24) {
                            this.rcurveline(factory, debug);
                            this.operandReached = 0;
                        } else if (key == 25) {
                            this.rlinecurve(factory, debug);
                            this.operandReached = 0;
                        } else if (key == 26 | key == 27) {
                            this.vvhhcurveto(factory, debug, key);
                            this.operandReached = 0;
                        } else if (key == 30 | key == 31) {
                            this.vhhvcurveto(factory, debug, key);
                            this.operandReached = 0;
                        } else if (debug) {
                            this.operandReached = 0;
                            System.out.println("Unsupported command " + p + ">>>>>" + this.hintCount + ">>>>>>key=" + key + ' ' + Type1.T1CcharCodes1Byte[key] + " <1<<" + this.operandsRead);
                            for (j = 0; j < dicEnd; ++j) {
                                System.out.println(j + " " + (glyphStream[j] & 0xFF));
                            }
                        }
                    }
                    if (debug && !isNumber) {
                        BufferedImage img = new BufferedImage(1000, 1000, 2);
                        Graphics2D g2 = img.createGraphics();
                        g2.setColor(Color.red);
                        for (int ii = 0; ii < 7; ++ii) {
                            g2.drawLine(ii * 100, 0, ii * 100, 1000);
                            g2.drawLine(0, ii * 100, 1000, ii * 100);
                        }
                        g2.setColor(Color.black);
                        PdfGlyph transformedGlyph2 = factory.getGlyph(true);
                        if (transformedGlyph2.getShape() != null) {
                            transformedGlyph2.render(1, g2, 1.0f, false);
                            ShowGUIMessage.showGUIMessage(p + " x  x,y=" + this.x + ' ' + this.y, img, p + " x ");
                        }
                    }
                }
                if (ymin > this.y) {
                    ymin = this.y;
                }
                if (ymax < this.y) {
                    ymax = this.y;
                }
                if (key == 19 || key == 29 || key == 10) continue;
                isFirst = false;
            }
            if (yy > this.h) {
                ymin = yy - this.h;
            }
            if (ymax < yy) {
                ymin = 0.0;
            } else if (yy != ymax) {
                float dy = (float)(ymax - (yy - ymin));
                ymin = dy < 0.0f ? (yy - ymax <= (double)dy ? (double)dy : (ymin -= (double)dy)) : 0.0;
                if (ymin < 0.0) {
                    ymin = 0.0;
                }
            }
            factory.setYMin((float)ymin, (float)ymax);
            if (debug & !isRecursive) {
                BufferedImage img = new BufferedImage(600, 600, 2);
                Graphics2D g2 = img.createGraphics();
                g2.setColor(Color.red);
                AffineTransform af = new AffineTransform();
                af.scale(0.25, 0.25);
                g2.transform(af);
                PdfGlyph transformedGlyph2 = factory.getGlyph(true);
                g2.setColor(Color.green);
                for (int j2 = 0; j2 < 7; ++j2) {
                    g2.drawLine(0, j2 * 50, 1000, j2 * 50);
                }
                transformedGlyph2.render(1, g2, 1.0f, false);
            }
        }
    }

    @Override
    public void setCharString(String glyph, byte[] stream, int glyphNo) {
        this.charStrings.put(glyph, stream);
        this.glyphNumbers.put(glyph, glyphNo);
    }

    @Override
    public void setIndexForCharString(int index, String charName) {
        if (this.charForGlyphIndex == null) {
            this.charForGlyphIndex = new String[65536];
        }
        if (index < this.charForGlyphIndex.length) {
            this.charForGlyphIndex[index] = charName;
        }
    }

    @Override
    public String getIndexForCharString(int index) {
        return this.charForGlyphIndex[index];
    }

    @Override
    public boolean is1C() {
        return this.is1C;
    }

    public void setWidthValues(int[] defaultWidthX, int[] nominalWidthX) {
        this.nominalWidthX = nominalWidthX;
        this.defaultWidthX = defaultWidthX;
    }

    @Override
    public void setis1C(boolean is1C) {
        this.is1C = is1C;
    }

    @Override
    public void setRenderer(DynamicVectorRenderer current) {
        this.dynamicVectorRenderer = current;
    }

    public void setFDSelect(int[] fdSelect) {
        this.fdSelect = fdSelect;
    }

    @Override
    public Map getCharStrings() {
        return this.charStrings;
    }
}

