/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.Map;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.CFF;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Head;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.Loca;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.Post;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class TTGlyphs
extends PdfJavaGlyphs {
    private static final long serialVersionUID = -8151179255804850800L;
    protected boolean hasGIDtoCID;
    protected int[] CIDToGIDMap;
    float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    private String[] diffTable = null;
    boolean isCorrupted = false;
    private CMAP currentCMAP;
    private Post currentPost;
    private Glyf currentGlyf;
    private Hmtx currentHmtx;
    private Hhea currentHhea;
    private FontFile2 fontTable;
    private Loca currentLoca;
    private CFF currentCFF;
    int type = 1217103210;
    private int unitsPerEm;
    private boolean hasCFF;
    private boolean isCID;

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] Trm, int rawInt, String displayValue, float currentWidth, String key) {
        PdfGlyph transformedGlyph2;
        int id = rawInt;
        if (this.hasGIDtoCID) {
            rawInt = this.CIDToGIDMap[rawInt];
        }
        if (this.lastTrm[0][0] != Trm[0][0] | this.lastTrm[1][0] != Trm[1][0] | this.lastTrm[0][1] != Trm[0][1] | this.lastTrm[1][1] != Trm[1][1]) {
            this.lastTrm = Trm;
            this.flush();
        }
        if ((transformedGlyph2 = this.getEmbeddedCachedShape(id)) == null) {
            block11: {
                int idx = rawInt;
                if (!(this.isCID && this.isIdentity() || this.currentCMAP == null)) {
                    idx = this.currentCMAP.convertIndexToCharacterCode(glyph, rawInt, this.remapFont, this.isSubsetted, this.diffTable);
                }
                if (idx < 1) {
                    idx = this.currentPost.convertGlyphToCharacterCode(glyph);
                }
                try {
                    if (this.hasCFF) {
                        transformedGlyph2 = this.currentCFF.getCFFGlyph(factory, glyph, Trm, idx, displayValue, currentWidth, key);
                        if (transformedGlyph2 != null) {
                            transformedGlyph2.setWidth(this.getUnscaledWidth(glyph, rawInt, displayValue, false));
                        }
                        if (transformedGlyph2 != null) {
                            transformedGlyph2.setID(rawInt);
                        }
                    } else {
                        transformedGlyph2 = this.getTTGlyph(idx, glyph, rawInt, displayValue, currentWidth);
                    }
                }
                catch (Exception e) {
                    transformedGlyph2 = null;
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            this.setEmbeddedCachedShape(id, transformedGlyph2);
        }
        return transformedGlyph2;
    }

    public PdfGlyph getTTGlyph(int idx, String glyph, int rawInt, String displayValue, float currentWidth) {
        if (this.isCorrupted) {
            idx = rawInt;
        }
        TTGlyph currentGlyph = null;
        try {
            int p;
            boolean debug = false;
            if (idx != -1 && (p = this.currentGlyf.getCharString(idx)) != -1) {
                currentGlyph = new TTGlyph(glyph, false, this.currentGlyf, this.fontTable, this.currentHmtx, idx, (float)this.unitsPerEm / 1000.0f, this.baseFontName);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace(System.out);
        }
        return currentGlyph;
    }

    @Override
    public void setDiffValues(String[] diffTable) {
        this.diffTable = diffTable;
    }

    @Override
    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean isSubstituted, boolean isCIDFont) {
        if (this.currentCMAP != null) {
            if (this.isCorrupted) {
                this.currentCMAP.setEncodingToUse(hasEncoding, fontEncoding, true, isCIDFont);
            } else {
                this.currentCMAP.setEncodingToUse(hasEncoding, fontEncoding, isSubstituted, isCIDFont);
            }
        }
    }

    @Override
    public int getConvertedGlyph(int idx) {
        if (this.currentCMAP == null) {
            return idx;
        }
        return this.currentCMAP.convertIndexToCharacterCode(null, idx, false, false, this.diffTable);
    }

    @Override
    public Map getCharStrings() {
        if (this.currentCMAP != null) {
            return this.currentCMAP.buildCharStringTable();
        }
        return this.currentGlyf.buildCharStringTable(0);
    }

    @Override
    public float getTTWidth(String glyph, int rawInt, String displayValue, boolean TTstreamisCID) {
        int idx = rawInt;
        float width = 0.0f;
        try {
            if (!TTstreamisCID) {
                idx = this.currentCMAP.convertIndexToCharacterCode(glyph, rawInt, this.remapFont, this.isSubsetted, this.diffTable);
            }
            if (idx < 1) {
                idx = this.currentPost.convertGlyphToCharacterCode(glyph);
            }
            width = this.currentHmtx.getWidth(idx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return width;
    }

    private float getUnscaledWidth(String glyph, int rawInt, String displayValue, boolean TTstreamisCID) {
        int idx = rawInt;
        float width = 0.0f;
        try {
            if (!TTstreamisCID) {
                idx = this.currentCMAP.convertIndexToCharacterCode(glyph, rawInt, this.remapFont, this.isSubsetted, this.diffTable);
            }
            if (idx < 1) {
                idx = this.currentPost.convertGlyphToCharacterCode(glyph);
            }
            width = this.currentHmtx.getUnscaledWidth(idx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return width;
    }

    @Override
    public void setGIDtoCID(int[] cidToGIDMap) {
        this.hasGIDtoCID = true;
        this.CIDToGIDMap = cidToGIDMap;
    }

    public static String[] readFontNames(FontData fontData, int mode) {
        FontFile2 currentFontFile = new FontFile2(fontData);
        int fontCount = currentFontFile.getFontCount();
        String[] fontNames = new String[fontCount];
        for (int i = 0; i < fontCount; ++i) {
            String name;
            currentFontFile.setSelectedFontIndex(i);
            Name currentName = new Name(currentFontFile);
            if (mode == 2) {
                name = currentName.getString(Name.POSTSCRIPT_NAME);
            } else if (mode == 3) {
                name = currentName.getString(Name.FONT_FAMILY_NAME);
            } else if (mode == 4) {
                name = currentName.getString(Name.FULL_FONT_NAME);
            } else {
                throw new RuntimeException("Unsupported mode " + mode + ". Unable to resolve font names");
            }
            fontNames[i] = name == null ? null : name.toLowerCase();
        }
        if (fontData != null) {
            fontData.close();
        }
        return fontNames;
    }

    public static void addStringValues(FontData fontData, Map fontDetails) {
        FontFile2 currentFontFile = new FontFile2(fontData);
        int fontCount = currentFontFile.getFontCount();
        for (int i = 0; i < fontCount; ++i) {
            currentFontFile.setSelectedFontIndex(i);
            Name currentName = new Name(currentFontFile);
            Map stringValues = currentName.getStrings();
            if (stringValues == null) continue;
            for (Object o : stringValues.keySet()) {
                Integer currentKey = (Integer)o;
                int keyInt = currentKey;
                if (keyInt >= Name.stringNames.length) continue;
                fontDetails.put(Name.stringNames[currentKey], stringValues.get(currentKey));
            }
        }
        if (fontData != null) {
            fontData.close();
        }
    }

    @Override
    public int readEmbeddedFont(boolean TTstreamisCID, byte[] fontDataAsArray, FontData fontData) {
        this.isCID = TTstreamisCID;
        FontFile2 currentFontFile = fontDataAsArray != null ? new FontFile2(fontDataAsArray) : new FontFile2(fontData);
        if (FontMappings.fontSubstitutionFontID == null) {
            currentFontFile.setPointer(0);
        } else {
            Integer fontID = FontMappings.fontSubstitutionFontID.get(this.fontName.toLowerCase());
            if (fontID != null) {
                currentFontFile.setPointer(fontID);
            } else {
                currentFontFile.setPointer(0);
            }
        }
        Head currentHead = new Head(currentFontFile);
        this.currentPost = new Post(currentFontFile);
        Maxp currentMaxp = new Maxp(currentFontFile);
        this.glyphCount = currentMaxp.getGlyphCount();
        this.currentLoca = new Loca(currentFontFile, this.glyphCount, currentHead.getFormat());
        this.isCorrupted = this.currentLoca.isCorrupted();
        this.currentGlyf = new Glyf(currentFontFile, this.glyphCount, this.currentLoca.getIndices());
        this.currentCFF = new CFF(currentFontFile, this.isCID);
        this.hasCFF = this.currentCFF.hasCFFData();
        if (this.hasCFF) {
            this.type = 6;
        }
        this.currentHhea = new Hhea(currentFontFile);
        this.FontBBox = currentHead.getFontBBox();
        this.currentHmtx = new Hmtx(currentFontFile, this.glyphCount, this.currentHhea.getNumberOfHMetrics(), (int)this.FontBBox[3]);
        int startPointer = currentFontFile.selectTable(2);
        if (startPointer != 0) {
            this.currentCMAP = new CMAP(currentFontFile, startPointer, this.currentGlyf);
        }
        this.unitsPerEm = currentHead.getUnitsPerEm();
        this.fontTable = new FontFile2(this.currentGlyf.getTableData(), true);
        if (fontData != null) {
            fontData.close();
        }
        return this.type;
    }

    @Override
    public float[] getFontBoundingBox() {
        return this.FontBBox;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    @Override
    public void setCorrupted(boolean corrupt) {
        this.isCorrupted = corrupt;
    }

    @Override
    public Table getTable(int type) {
        Table table;
        switch (type) {
            case 3: {
                table = this.currentLoca;
                break;
            }
            case 2: {
                table = this.currentCMAP;
                break;
            }
            case 5: {
                table = this.currentHhea;
                break;
            }
            case 6: {
                table = this.currentHmtx;
                break;
            }
            default: {
                throw new RuntimeException("table not yet added to getTable)");
            }
        }
        return table;
    }
}

