/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.utils.LogWriter;

public class CFFWriter
extends Type1
implements FontTableWriter {
    private static final long serialVersionUID = -4172447980016197351L;
    private static final boolean debugTopDictOffsets = false;
    private String name;
    private byte[][] subrs;
    private final String[] glyphNames;
    private byte[][] charstrings;
    private int[] charstringXDisplacement;
    private int[] charstringYDisplacement;
    private byte[] header;
    private byte[] nameIndex;
    private byte[] topDictIndex;
    private byte[] globalSubrIndex;
    private byte[] encodings;
    private byte[] charsets;
    private byte[] charStringsIndex;
    private byte[] privateDict;
    private byte[] localSubrIndex;
    private byte[] stringIndex;
    private final ArrayList<String> strings = new ArrayList();
    private int[] widthX;
    private int[] widthY;
    private int[] lsbX;
    private int[] lsbY;
    private int defaultWidthX;
    private int nominalWidthX;
    private ArrayList<CharstringElement> currentCharString;
    private int currentCharStringID;
    private float[] bbox = new float[4];
    private boolean inFlex = false;
    private CharstringElement currentFlexCommand;
    private boolean firstArgsAdded = false;
    private double emSquareSize = 1000.0;
    private double scale = 1.0;
    private boolean inSeac = false;

    public CFFWriter(PdfJavaGlyphs glyphs, String name) {
        String key;
        int i;
        this.glyphs = glyphs;
        this.name = name;
        Map charStringSegments = glyphs.getCharStrings();
        Object[] keys = charStringSegments.keySet().toArray();
        Arrays.sort(keys);
        int maxSubrNum = 0;
        int maxSubrLen = 0;
        int charCount = 0;
        for (i = 0; i < charStringSegments.size(); ++i) {
            key = (String)keys[i];
            if (key.startsWith("subrs")) {
                int len;
                int num = Integer.parseInt(key.replaceAll("[^0-9]", ""));
                if (num > maxSubrNum) {
                    maxSubrNum = num;
                }
                if ((len = ((byte[])charStringSegments.get(key)).length) <= maxSubrLen) continue;
                maxSubrLen = len;
                continue;
            }
            ++charCount;
        }
        this.subrs = new byte[maxSubrNum + 1][];
        this.glyphNames = new String[charCount];
        this.charstrings = new byte[charCount][];
        this.charstringXDisplacement = new int[charCount];
        this.charstringYDisplacement = new int[charCount];
        charCount = 0;
        for (i = 0; i < charStringSegments.size(); ++i) {
            key = (String)keys[i];
            Object obj = charStringSegments.get(key);
            byte[] cs = (byte[])obj;
            if (key.startsWith("subrs")) {
                int num = Integer.parseInt(key.replaceAll("[^0-9]", ""));
                this.subrs[num] = cs;
                continue;
            }
            this.glyphNames[charCount] = key;
            this.charstrings[charCount] = cs;
            ++charCount;
        }
        this.convertCharstrings();
    }

    private void convertCharstrings() {
        int i;
        block12: {
            try {
                int charstringID;
                this.widthX = new int[this.charstrings.length];
                this.widthY = new int[this.charstrings.length];
                this.lsbX = new int[this.charstrings.length];
                this.lsbY = new int[this.charstrings.length];
                byte[][] newCharstrings = new byte[this.charstrings.length][];
                for (charstringID = 0; charstringID < this.charstrings.length; ++charstringID) {
                    newCharstrings[charstringID] = this.convertCharstring(this.charstrings[charstringID], charstringID);
                }
                if (this.bbox[2] - this.bbox[0] > 1100.0f) {
                    this.emSquareSize = this.bbox[2] - this.bbox[0];
                    this.scale = 1.0 / (this.emSquareSize / 1000.0);
                    this.charstringXDisplacement = new int[this.charstringXDisplacement.length];
                    this.charstringYDisplacement = new int[this.charstringYDisplacement.length];
                    this.bbox = new float[4];
                    for (charstringID = 0; charstringID < this.charstrings.length; ++charstringID) {
                        newCharstrings[charstringID] = this.convertCharstring(this.charstrings[charstringID], charstringID);
                    }
                    this.charstrings = newCharstrings;
                } else {
                    this.charstrings = newCharstrings;
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block12;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        HashMap<Integer, Integer> valueCount = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < this.charstrings.length; ++i2) {
            Integer count = (Integer)valueCount.get(this.widthX[i2]);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            valueCount.put(this.widthX[i2], count);
        }
        Object[] values = valueCount.keySet().toArray();
        int maxCount = 0;
        this.defaultWidthX = 0;
        for (Object value : values) {
            int count = (Integer)valueCount.get(value);
            if (count <= maxCount) continue;
            maxCount = count;
            this.defaultWidthX = (Integer)value;
        }
        int total = 0;
        int count = 0;
        for (Object value : values) {
            if ((Integer)value == this.defaultWidthX) continue;
            ++count;
            total += ((Integer)value).intValue();
        }
        this.nominalWidthX = count != 0 ? total / count : 0;
        for (i = 0; i < this.widthX.length; ++i) {
            this.widthX[i] = this.widthX[i] == this.defaultWidthX ? Integer.MIN_VALUE : this.widthX[i] - this.nominalWidthX;
        }
        for (i = 0; i < this.widthX.length; ++i) {
            if (this.widthX[i] == Integer.MIN_VALUE) continue;
            byte[] width = FontWriter.setCharstringType2Number(this.widthX[i]);
            byte[] newCharstring = new byte[width.length + this.charstrings[i].length];
            System.arraycopy(width, 0, newCharstring, 0, width.length);
            System.arraycopy(this.charstrings[i], 0, newCharstring, width.length, this.charstrings[i].length);
            this.charstrings[i] = newCharstring;
        }
        for (i = 0; i < this.charstrings.length; ++i) {
            if (this.charstrings[i][this.charstrings[i].length - 1] == 14) continue;
            byte[] newCharstring = new byte[this.charstrings[i].length + 1];
            System.arraycopy(this.charstrings[i], 0, newCharstring, 0, this.charstrings[i].length);
            newCharstring[newCharstring.length - 1] = 14;
            this.charstrings[i] = newCharstring;
        }
    }

    private byte[] convertCharstring(byte[] charstring, int charstringID) {
        ByteArrayOutputStream bos;
        block8: {
            CharstringElement element;
            int[] cs = new int[charstring.length];
            for (int i = 0; i < charstring.length; ++i) {
                cs[i] = charstring[i];
                if (cs[i] >= 0) continue;
                int n = i;
                cs[n] = cs[n] + 256;
            }
            bos = new ByteArrayOutputStream();
            this.currentCharString = new ArrayList();
            this.currentCharStringID = charstringID;
            for (int i = 0; i < cs.length; i += element.getLength()) {
                element = new CharstringElement(cs, i);
            }
            if (this.emSquareSize != 1000.0 && !this.inSeac) {
                for (CharstringElement e : this.currentCharString) {
                    e.scale();
                }
                this.widthX[charstringID] = (int)(this.scale * (double)this.widthX[charstringID]);
                this.widthY[charstringID] = (int)(this.scale * (double)this.widthY[charstringID]);
                this.lsbX[charstringID] = (int)(this.scale * (double)this.lsbX[charstringID]);
                this.lsbY[charstringID] = (int)(this.scale * (double)this.lsbY[charstringID]);
            }
            for (CharstringElement e : this.currentCharString) {
                int[] d = e.getDisplacement();
                int n = charstringID;
                this.charstringXDisplacement[n] = this.charstringXDisplacement[n] + d[0];
                int n2 = charstringID;
                this.charstringYDisplacement[n2] = this.charstringYDisplacement[n2] + d[1];
                this.bbox[0] = (float)this.charstringXDisplacement[charstringID] < this.bbox[0] ? (float)this.charstringXDisplacement[charstringID] : this.bbox[0];
                this.bbox[1] = (float)this.charstringYDisplacement[charstringID] < this.bbox[1] ? (float)this.charstringYDisplacement[charstringID] : this.bbox[1];
                this.bbox[2] = (float)this.charstringXDisplacement[charstringID] > this.bbox[2] ? (float)this.charstringXDisplacement[charstringID] : this.bbox[2];
                this.bbox[3] = (float)this.charstringYDisplacement[charstringID] > this.bbox[3] ? (float)this.charstringYDisplacement[charstringID] : this.bbox[3];
            }
            try {
                for (CharstringElement currentElement : this.currentCharString) {
                    bos.write(currentElement.getType2Bytes());
                }
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return bos.toByteArray();
    }

    public int getSIDForString(String text) {
        int i;
        for (i = 0; i < Type1C.type1CStdStrings.length; ++i) {
            if (!text.equals(Type1C.type1CStdStrings[i])) continue;
            return i;
        }
        for (i = 0; i < this.strings.size(); ++i) {
            if (!text.equals(this.strings.get(i))) continue;
            return 391 + i;
        }
        this.strings.add(text);
        return 390 + this.strings.size();
    }

    @Override
    public byte[] writeTable() throws IOException {
        byte[] lastTopDictIndex;
        byte[] lastPrivateDict;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.localSubrIndex = new byte[0];
        this.privateDict = this.localSubrIndex;
        this.charStringsIndex = this.localSubrIndex;
        this.charsets = this.localSubrIndex;
        this.encodings = this.localSubrIndex;
        this.stringIndex = this.localSubrIndex;
        this.globalSubrIndex = this.localSubrIndex;
        this.topDictIndex = this.localSubrIndex;
        this.header = new byte[]{FontWriter.setNextUint8(1), FontWriter.setNextUint8(0), FontWriter.setNextUint8(4), FontWriter.setNextUint8(2)};
        this.nameIndex = CFFWriter.createIndex(new byte[][]{this.name.getBytes()});
        this.topDictIndex = CFFWriter.createIndex(new byte[][]{this.createTopDict()});
        this.globalSubrIndex = CFFWriter.createIndex(new byte[0][]);
        this.encodings = CFFWriter.createEncodings();
        this.charsets = this.createCharsets();
        this.charStringsIndex = CFFWriter.createIndex(this.charstrings);
        this.privateDict = this.createPrivateDict();
        this.stringIndex = CFFWriter.createIndex(this.createStrings());
        do {
            lastPrivateDict = new byte[this.privateDict.length];
            System.arraycopy(this.privateDict, 0, lastPrivateDict, 0, this.privateDict.length);
            this.privateDict = this.createPrivateDict();
        } while (!Arrays.equals(this.privateDict, lastPrivateDict));
        do {
            lastTopDictIndex = new byte[this.topDictIndex.length];
            System.arraycopy(this.topDictIndex, 0, lastTopDictIndex, 0, this.topDictIndex.length);
            this.topDictIndex = CFFWriter.createIndex(new byte[][]{this.createTopDict()});
        } while (!Arrays.equals(lastTopDictIndex, this.topDictIndex));
        bos.write(this.header);
        bos.write(this.nameIndex);
        bos.write(this.topDictIndex);
        bos.write(this.stringIndex);
        bos.write(this.globalSubrIndex);
        bos.write(this.encodings);
        bos.write(this.charsets);
        bos.write(this.charStringsIndex);
        bos.write(this.privateDict);
        return bos.toByteArray();
    }

    private static byte[] createIndex(byte[][] data) throws IOException {
        int count = data.length;
        if (count == 0) {
            return new byte[]{0, 0};
        }
        int[] offsets = new int[count + 1];
        offsets[0] = 1;
        for (int i = 1; i < count + 1; ++i) {
            byte[] cs = data[i - 1];
            offsets[i] = cs != null ? offsets[i - 1] + cs.length : offsets[i - 1];
        }
        byte offSize = CFFWriter.getOffsizeForMaxVal(offsets[count]);
        int len = 3 + offSize * offsets.length + offsets[count];
        ByteArrayOutputStream bos = new ByteArrayOutputStream(len);
        bos.write(FontWriter.setNextUint16(count));
        bos.write(FontWriter.setNextUint8(offSize));
        for (int offset : offsets) {
            bos.write(FontWriter.setUintAsBytes(offset, offSize));
        }
        for (byte[] item : data) {
            if (item == null) continue;
            bos.write(item);
        }
        return bos.toByteArray();
    }

    private byte[] createTopDict() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(FontWriter.set1cNumber(this.getSIDForString("1")));
        bos.write(0);
        if (this.copyright != null) {
            bos.write(FontWriter.set1cNumber(this.getSIDForString(this.copyright)));
            bos.write(1);
        }
        bos.write(FontWriter.set1cNumber((int)this.bbox[0]));
        bos.write(FontWriter.set1cNumber((int)this.bbox[1]));
        bos.write(FontWriter.set1cNumber((int)this.bbox[2]));
        bos.write(FontWriter.set1cNumber((int)this.bbox[3]));
        bos.write(5);
        int loc = this.header.length + this.nameIndex.length + this.topDictIndex.length + this.stringIndex.length + this.globalSubrIndex.length;
        if (this.encodings.length != 0) {
            bos.write(FontWriter.set1cNumber(loc));
            bos.write(16);
        }
        bos.write(FontWriter.set1cNumber(loc += this.encodings.length));
        bos.write(15);
        bos.write(FontWriter.set1cNumber(loc += this.charsets.length));
        bos.write(17);
        bos.write(FontWriter.set1cNumber(this.privateDict.length));
        bos.write(FontWriter.set1cNumber(loc += this.charStringsIndex.length));
        bos.write(18);
        return bos.toByteArray();
    }

    private byte[][] createStrings() {
        byte[][] result = new byte[this.strings.size()][];
        for (int i = 0; i < this.strings.size(); ++i) {
            result[i] = this.strings.get(i).getBytes();
        }
        return result;
    }

    private byte[] createCharsets() {
        String[] names = null;
        for (int i = 0; i < this.glyphNames.length; ++i) {
            if (!".notdef".equals(this.glyphNames[i])) continue;
            names = new String[this.glyphNames.length - 1];
            System.arraycopy(this.glyphNames, 0, names, 0, i);
            System.arraycopy(this.glyphNames, i + 1, names, i, names.length - i);
        }
        if (names == null) {
            names = this.glyphNames;
        }
        byte[] result = new byte[names.length * 2 + 1];
        for (int i = 0; i < names.length; ++i) {
            byte[] sid = FontWriter.setUintAsBytes(this.getSIDForString(names[i]), 2);
            result[1 + i * 2] = sid[0];
            result[2 + i * 2] = sid[1];
        }
        return result;
    }

    private static byte[] createEncodings() {
        return new byte[0];
    }

    private byte[] createPrivateDict() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(FontWriter.set1cNumber(this.defaultWidthX));
        bos.write(20);
        bos.write(FontWriter.set1cNumber(this.nominalWidthX));
        bos.write(21);
        return bos.toByteArray();
    }

    private static byte getOffsizeForMaxVal(int i) {
        byte result = 1;
        while (i > 256) {
            result = (byte)(result + 1);
            i /= 256;
        }
        return result;
    }

    @Override
    public int getIntValue(int i) {
        return -1;
    }

    public String[] getGlyphList() {
        return this.glyphNames;
    }

    public int[] getWidths() {
        int[] widths = new int[this.widthX.length];
        for (int i = 0; i < this.widthX.length; ++i) {
            widths[i] = this.widthX[i] == Integer.MIN_VALUE ? this.defaultWidthX : this.widthX[i] + this.nominalWidthX;
        }
        return widths;
    }

    public int[] getBearings() {
        return this.lsbX;
    }

    public float[] getBBox() {
        return this.bbox;
    }

    public double getEmSquareSize() {
        return this.emSquareSize;
    }

    static /* synthetic */ String[] access$1100(CFFWriter x0) {
        return x0.glyphNames;
    }

    static /* synthetic */ int[] access$1200(CFFWriter x0) {
        return x0.charstringXDisplacement;
    }

    static /* synthetic */ int[] access$1300(CFFWriter x0) {
        return x0.charstringYDisplacement;
    }

    static /* synthetic */ boolean access$1402(CFFWriter x0, boolean x1) {
        x0.inSeac = x1;
        return x0.inSeac;
    }

    static /* synthetic */ byte[][] access$1500(CFFWriter x0) {
        return x0.charstrings;
    }

    static /* synthetic */ byte[] access$1600(CFFWriter x0, byte[] x1, int x2) {
        return x0.convertCharstring(x1, x2);
    }

    static /* synthetic */ int access$602(CFFWriter x0, int x1) {
        x0.currentCharStringID = x1;
        return x0.currentCharStringID;
    }

    private class CharstringElement {
        private boolean isCommand = true;
        private String commandName;
        private int numberValue;
        private int length = 1;
        private ArrayList<CharstringElement> args = new ArrayList();
        private final boolean isResult;
        private CharstringElement parent;

        public CharstringElement(int number) {
            this.isResult = false;
            this.isCommand = false;
            this.numberValue = number;
        }

        public CharstringElement(CharstringElement parent) {
            this.isResult = true;
            this.isCommand = false;
            this.parent = parent;
            CFFWriter.this.currentCharString.add(this);
        }

        public CharstringElement(int[] charstring, int pos) {
            this.isResult = false;
            CFFWriter.this.currentCharString.add(this);
            int b = charstring[pos];
            if (b >= 32 && b <= 246) {
                this.numberValue = b - 139;
                this.isCommand = false;
            } else if (b >= 247 && b <= 250 || b >= 251 && b <= 254) {
                this.numberValue = b < 251 ? (b - 247) * 256 + charstring[pos + 1] + 108 : -((b - 251) * 256) - charstring[pos + 1] - 108;
                this.isCommand = false;
                this.length = 2;
            } else {
                boolean mergePrevious = false;
                block0 : switch (b) {
                    case 1: {
                        this.commandName = "hstem";
                        this.claimArguments(2, true, true);
                        break;
                    }
                    case 3: {
                        this.commandName = "vstem";
                        this.claimArguments(2, true, true);
                        break;
                    }
                    case 4: {
                        this.commandName = "vmoveto";
                        this.claimArguments(1, true, true);
                        if (!CFFWriter.this.inFlex) break;
                        if (((CFFWriter)CFFWriter.this).currentFlexCommand.args.size() == 2 && !CFFWriter.this.firstArgsAdded) {
                            int arg0 = ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)0).numberValue;
                            int arg1 = this.args.get((int)0).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)1).numberValue;
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.clear();
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(arg0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(arg1));
                            CFFWriter.this.firstArgsAdded = true;
                        } else {
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(0));
                        }
                        this.commandName = "";
                        break;
                    }
                    case 5: {
                        this.commandName = "rlineto";
                        this.claimArguments(2, true, true);
                        mergePrevious = true;
                        break;
                    }
                    case 6: {
                        this.commandName = "hlineto";
                        this.claimArguments(1, true, true);
                        break;
                    }
                    case 7: {
                        this.commandName = "vlineto";
                        this.claimArguments(1, true, true);
                        break;
                    }
                    case 8: {
                        this.commandName = "rrcurveto";
                        this.claimArguments(6, true, true);
                        mergePrevious = true;
                        break;
                    }
                    case 9: {
                        this.commandName = "closepath";
                        this.claimArguments(0, false, true);
                        break;
                    }
                    case 10: {
                        CharstringElement element;
                        int i;
                        this.commandName = "callsubr";
                        this.claimArguments(1, false, false);
                        int subrNumber = this.args.get((int)0).numberValue;
                        if (!CFFWriter.this.inFlex && subrNumber == 1) {
                            this.args.clear();
                            this.commandName = "flex";
                            CFFWriter.this.currentFlexCommand = this;
                            CFFWriter.this.inFlex = true;
                        }
                        if (CFFWriter.this.inFlex && subrNumber >= 0 && subrNumber <= 2) {
                            if (subrNumber != 0) break;
                            this.claimArguments(3, false, false);
                            if (this.args.size() >= 4) {
                                ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(3));
                            } else {
                                ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(0));
                            }
                            CFFWriter.this.inFlex = false;
                            CFFWriter.this.firstArgsAdded = false;
                            break;
                        }
                        byte[] rawSubr = CFFWriter.this.subrs[subrNumber];
                        int[] subr = new int[rawSubr.length];
                        for (i = 0; i < rawSubr.length; ++i) {
                            subr[i] = rawSubr[i];
                            if (subr[i] >= 0) continue;
                            int n = i;
                            subr[n] = subr[n] + 256;
                        }
                        for (int i2 = 0; i2 < subr.length; i2 += element.length) {
                            element = new CharstringElement(subr, i2);
                        }
                        break;
                    }
                    case 11: {
                        this.commandName = "return";
                        break;
                    }
                    case 12: {
                        int i;
                        this.length = 2;
                        switch (charstring[pos + 1]) {
                            case 0: {
                                this.commandName = "dotsection";
                                this.claimArguments(0, false, true);
                                break;
                            }
                            case 1: {
                                this.commandName = "vstem3";
                                this.claimArguments(6, true, true);
                                break;
                            }
                            case 2: {
                                this.commandName = "hstem3";
                                this.claimArguments(6, true, true);
                                break;
                            }
                            case 6: {
                                this.commandName = "seac";
                                this.claimArguments(5, true, true);
                                break;
                            }
                            case 7: {
                                this.commandName = "sbw";
                                this.claimArguments(4, true, true);
                                ((CFFWriter)CFFWriter.this).lsbX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(0).evaluate();
                                ((CFFWriter)CFFWriter.this).lsbY[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(1).evaluate();
                                ((CFFWriter)CFFWriter.this).widthX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(2).evaluate();
                                ((CFFWriter)CFFWriter.this).widthY[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(3).evaluate();
                                if (CFFWriter.this.lsbX[CFFWriter.this.currentCharStringID] == 0) break;
                                this.commandName = "rmoveto";
                                this.args.clear();
                                this.args.add(new CharstringElement(CFFWriter.this.lsbX[CFFWriter.this.currentCharStringID]));
                                this.args.add(new CharstringElement(CFFWriter.this.lsbY[CFFWriter.this.currentCharStringID]));
                                break;
                            }
                            case 12: {
                                this.commandName = "div";
                                this.claimArguments(2, false, false);
                                new CharstringElement(this);
                                break;
                            }
                            case 16: {
                                this.commandName = "callothersubr";
                                this.claimArguments(2, false, false);
                                if (this.args.size() <= 1) break;
                                int count = this.args.get((int)1).numberValue;
                                boolean foundEnough = this.claimArguments(count, false, false);
                                if (!foundEnough) {
                                    CFFWriter.this.currentCharString.remove(this);
                                    return;
                                }
                                for (i = 0; i < count; ++i) {
                                    new CharstringElement(this.args.get((int)(1 + count - i)).numberValue);
                                }
                                break block0;
                            }
                            case 17: {
                                this.commandName = "pop";
                                new CharstringElement(this);
                                break;
                            }
                            case 33: {
                                this.commandName = "setcurrentpoint";
                                this.claimArguments(2, true, true);
                                break;
                            }
                        }
                        break;
                    }
                    case 13: {
                        this.commandName = "hsbw";
                        this.claimArguments(2, true, true);
                        ((CFFWriter)CFFWriter.this).lsbX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(0).evaluate();
                        ((CFFWriter)CFFWriter.this).widthX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(1).evaluate();
                        if (CFFWriter.this.lsbX[CFFWriter.this.currentCharStringID] == 0) break;
                        this.commandName = "rmoveto";
                        this.args.set(1, new CharstringElement(0));
                        break;
                    }
                    case 14: {
                        this.commandName = "endchar";
                        this.claimArguments(0, false, true);
                        break;
                    }
                    case 21: {
                        this.commandName = "rmoveto";
                        this.claimArguments(2, true, true);
                        if (!CFFWriter.this.inFlex) break;
                        if (((CFFWriter)CFFWriter.this).currentFlexCommand.args.size() == 2 && !CFFWriter.this.firstArgsAdded) {
                            int arg0 = this.args.get((int)0).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)0).numberValue;
                            int arg1 = this.args.get((int)1).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)1).numberValue;
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.clear();
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(arg0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(arg1));
                            CFFWriter.this.firstArgsAdded = true;
                        } else {
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(1));
                        }
                        this.commandName = "";
                        break;
                    }
                    case 22: {
                        this.commandName = "hmoveto";
                        this.claimArguments(1, true, true);
                        if (!CFFWriter.this.inFlex) break;
                        if (((CFFWriter)CFFWriter.this).currentFlexCommand.args.size() == 2 && !CFFWriter.this.firstArgsAdded) {
                            int arg0 = this.args.get((int)0).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)0).numberValue;
                            int arg1 = ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)1).numberValue;
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.clear();
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(arg0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(arg1));
                            CFFWriter.this.firstArgsAdded = true;
                        } else {
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(0));
                        }
                        this.commandName = "";
                        break;
                    }
                    case 30: {
                        this.commandName = "vhcurveto";
                        this.claimArguments(4, true, true);
                        break;
                    }
                    case 31: {
                        this.commandName = "hvcurveto";
                        this.claimArguments(4, true, true);
                        break;
                    }
                    case 255: {
                        this.length = 5;
                        this.isCommand = false;
                        this.numberValue = (charstring[pos + 4] & 0xFF) + ((charstring[pos + 3] & 0xFF) << 8) + ((charstring[pos + 2] & 0xFF) << 16) + ((charstring[pos + 1] & 0xFF) << 24);
                        break;
                    }
                }
                if (mergePrevious) {
                    CharstringElement previous = (CharstringElement)CFFWriter.this.currentCharString.get(CFFWriter.this.currentCharString.indexOf(this) - 1);
                    if (this.commandName.equals(previous.commandName) && previous.args.size() <= 39 - this.args.size()) {
                        CFFWriter.this.currentCharString.remove(previous);
                        for (CharstringElement e : this.args) {
                            previous.args.add(e);
                        }
                        this.args = previous.args;
                    }
                }
            }
        }

        private int evaluate() {
            if (this.isResult) {
                return this.parent.evaluate();
            }
            if (this.isCommand && "div".equals(this.commandName)) {
                return this.args.get(1).evaluate() / this.args.get(0).evaluate();
            }
            return this.numberValue;
        }

        public int getLength() {
            return this.length;
        }

        public int[] getDisplacement() {
            if (!this.isCommand) {
                return new int[]{0, 0};
            }
            if (!"hstem".equals(this.commandName) && !"vstem".equals(this.commandName)) {
                if ("vmoveto".equals(this.commandName)) {
                    return new int[]{0, this.args.get(0).evaluate()};
                }
                if ("rlineto".equals(this.commandName)) {
                    int dx = 0;
                    int dy = 0;
                    for (int i = 0; i < this.args.size() / 2; ++i) {
                        dx += this.args.get(i * 2).evaluate();
                        dy += this.args.get(1 + i * 2).evaluate();
                    }
                    return new int[]{dx, dy};
                }
                if ("hlineto".equals(this.commandName)) {
                    return new int[]{this.args.get(0).evaluate(), 0};
                }
                if ("vlineto".equals(this.commandName)) {
                    return new int[]{0, this.args.get(0).evaluate()};
                }
                if ("rrcurveto".equals(this.commandName)) {
                    int dx = 0;
                    int dy = 0;
                    for (int i = 0; i < this.args.size() / 2; ++i) {
                        dx += this.args.get(i * 2).evaluate();
                        dy += this.args.get(1 + i * 2).evaluate();
                    }
                    return new int[]{dx, dy};
                }
                if (!("closepath".equals(this.commandName) || "callsubr".equals(this.commandName) || "return".equals(this.commandName) || "dotsection".equals(this.commandName) || "vstem3".equals(this.commandName) || "hstem3".equals(this.commandName) || "seac".equals(this.commandName) || "sbw".equals(this.commandName) || "div".equals(this.commandName) || "callothersubr".equals(this.commandName) || "pop".equals(this.commandName) || "setcurrentpoint".equals(this.commandName) || "hsbw".equals(this.commandName) || "endchar".equals(this.commandName))) {
                    if ("rmoveto".equals(this.commandName)) {
                        return new int[]{this.args.get(0).evaluate(), this.args.get(1).evaluate()};
                    }
                    if ("hmoveto".equals(this.commandName)) {
                        return new int[]{this.args.get(0).evaluate(), 0};
                    }
                    if ("vhcurveto".equals(this.commandName)) {
                        return new int[]{this.args.get(1).evaluate() + this.args.get(3).evaluate(), this.args.get(0).evaluate() + this.args.get(2).evaluate()};
                    }
                    if ("hvcurveto".equals(this.commandName)) {
                        return new int[]{this.args.get(0).evaluate() + this.args.get(1).evaluate(), this.args.get(2).evaluate() + this.args.get(3).evaluate()};
                    }
                    if ("flex".equals(this.commandName)) {
                        int dx = 0;
                        int dy = 0;
                        for (int i = 0; i < 6; ++i) {
                            dx += this.args.get(i * 2).evaluate();
                            dy += this.args.get(1 + i * 2).evaluate();
                        }
                        return new int[]{dx, dy};
                    }
                    if (this.commandName.length() == 0) {
                        return new int[]{0, 0};
                    }
                }
            }
            return new int[]{0, 0};
        }

        public void scale() {
            if (this.isResult) {
                return;
            }
            if (!this.isCommand) {
                this.numberValue = (int)((double)this.numberValue * CFFWriter.this.scale);
                return;
            }
            boolean scaleAll = false;
            if ("hstem".equals(this.commandName)) {
                scaleAll = true;
            } else if ("vstem".equals(this.commandName)) {
                scaleAll = true;
            } else if ("vmoveto".equals(this.commandName)) {
                scaleAll = true;
            } else if ("rlineto".equals(this.commandName)) {
                scaleAll = true;
            } else if ("hlineto".equals(this.commandName)) {
                scaleAll = true;
            } else if ("vlineto".equals(this.commandName)) {
                scaleAll = true;
            } else if ("rrcurveto".equals(this.commandName)) {
                scaleAll = true;
            } else if (!("closepath".equals(this.commandName) || "callsubr".equals(this.commandName) || "return".equals(this.commandName) || "dotsection".equals(this.commandName))) {
                if ("vstem3".equals(this.commandName)) {
                    scaleAll = true;
                } else if ("hstem3".equals(this.commandName)) {
                    scaleAll = true;
                } else if ("seac".equals(this.commandName)) {
                    for (int i = 0; i < 3; ++i) {
                        this.args.get(i).scale();
                    }
                } else if (!"sbw".equals(this.commandName)) {
                    if ("div".equals(this.commandName)) {
                        scaleAll = true;
                    } else if (!"callothersubr".equals(this.commandName) && !"pop".equals(this.commandName)) {
                        if ("setcurrentpoint".equals(this.commandName)) {
                            scaleAll = true;
                        } else if (!"hsbw".equals(this.commandName) && !"endchar".equals(this.commandName)) {
                            if ("rmoveto".equals(this.commandName)) {
                                scaleAll = true;
                            } else if ("hmoveto".equals(this.commandName)) {
                                scaleAll = true;
                            } else if ("vhcurveto".equals(this.commandName)) {
                                scaleAll = true;
                            } else if ("hvcurveto".equals(this.commandName)) {
                                scaleAll = true;
                            } else if ("flex".equals(this.commandName)) {
                                scaleAll = true;
                            } else if (this.commandName.length() == 0) {
                                // empty if block
                            }
                        }
                    }
                }
            }
            if (scaleAll) {
                for (CharstringElement e : this.args) {
                    e.scale();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public byte[] getType2Bytes() {
            if (!this.isCommand) {
                if (this.isResult) {
                    return new byte[0];
                }
                return FontWriter.setCharstringType2Number(this.numberValue);
            }
            noChange = false;
            commandNumber = new byte[]{};
            if ("hstem".equals(this.commandName)) {
                noChange = true;
                commandNumber = new byte[]{1};
            } else if ("vstem".equals(this.commandName)) {
                noChange = true;
                commandNumber = new byte[]{3};
            } else if ("vmoveto".equals(this.commandName)) {
                noChange = true;
                commandNumber = new byte[]{4};
            } else if ("rlineto".equals(this.commandName)) {
                noChange = true;
                commandNumber = new byte[]{5};
            } else if ("hlineto".equals(this.commandName)) {
                noChange = true;
                commandNumber = new byte[]{6};
            } else if ("vlineto".equals(this.commandName)) {
                noChange = true;
                commandNumber = new byte[]{7};
            } else if ("rrcurveto".equals(this.commandName)) {
                noChange = true;
                commandNumber = new byte[]{8};
            } else {
                if ("closepath".equals(this.commandName)) {
                    return new byte[0];
                }
                if ("callsubr".equals(this.commandName)) {
                    return new byte[0];
                }
                if ("return".equals(this.commandName)) {
                    return new byte[0];
                }
                if ("dotsection".equals(this.commandName)) {
                    return new byte[0];
                }
                if (!"vstem3".equals(this.commandName) && !"hstem3".equals(this.commandName)) {
                    if ("seac".equals(this.commandName)) {
                        adx = this.args.get((int)1).numberValue;
                        ady = this.args.get((int)2).numberValue;
                        bchar = this.args.get((int)3).numberValue;
                        achar = this.args.get((int)4).numberValue;
                        aCharUnicode = StandardFonts.getEncodedChar(1, achar).charAt(0);
                        bCharUnicode = StandardFonts.getEncodedChar(1, bchar).charAt(0);
                        accentIndex = -1;
                        baseIndex = -1;
                        for (i = 0; i < CFFWriter.access$1100(CFFWriter.this).length; ++i) {
                            adobePos = StandardFonts.getAdobeMap(CFFWriter.access$1100(CFFWriter.this)[i]);
                            if (adobePos < 0 || adobePos >= 512) continue;
                            if (adobePos == aCharUnicode) {
                                accentIndex = i;
                            }
                            if (adobePos != bCharUnicode) continue;
                            baseIndex = i;
                        }
                        if (accentIndex == -1 || baseIndex == -1) {
                            return new byte[0];
                        }
                        try {
                            bos = new ByteArrayOutputStream();
                            charstringStore = CFFWriter.access$600(CFFWriter.this);
                            CFFWriter.access$1200((CFFWriter)CFFWriter.this)[baseIndex] = 0;
                            CFFWriter.access$1300((CFFWriter)CFFWriter.this)[baseIndex] = 0;
                            CFFWriter.access$1402(CFFWriter.this, true);
                            rawBaseCharstring = CFFWriter.access$1600(CFFWriter.this, CFFWriter.access$1500(CFFWriter.this)[baseIndex], baseIndex);
                            CFFWriter.access$1402(CFFWriter.this, false);
                            CFFWriter.access$602(CFFWriter.this, charstringStore);
                            baseCharstring = new byte[rawBaseCharstring.length - 1];
                            System.arraycopy(rawBaseCharstring, 0, baseCharstring, 0, baseCharstring.length);
                            bos.write(baseCharstring);
                            bos.write(FontWriter.setCharstringType2Number(-CFFWriter.access$1200(CFFWriter.this)[baseIndex] + adx));
                            bos.write(FontWriter.setCharstringType2Number(-CFFWriter.access$1300(CFFWriter.this)[baseIndex] + ady));
                            bos.write(21);
                            CFFWriter.access$1200((CFFWriter)CFFWriter.this)[accentIndex] = 0;
                            CFFWriter.access$1300((CFFWriter)CFFWriter.this)[accentIndex] = 0;
                            accentCharstring = CFFWriter.access$1600(CFFWriter.this, CFFWriter.access$1500(CFFWriter.this)[accentIndex], accentIndex);
                            CFFWriter.access$602(CFFWriter.this, charstringStore);
                            bos.write(accentCharstring);
                            return bos.toByteArray();
                        }
                        catch (IOException e) {
                            if (!LogWriter.isOutput()) ** GOTO lbl127
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                    } else {
                        if ("sbw".equals(this.commandName)) {
                            return new byte[0];
                        }
                        if ("div".equals(this.commandName)) {
                            noChange = true;
                            commandNumber = new byte[]{12, 12};
                        } else if (!("callothersubr".equals(this.commandName) || "pop".equals(this.commandName) || "setcurrentpoint".equals(this.commandName))) {
                            if ("hsbw".equals(this.commandName)) {
                                return new byte[0];
                            }
                            if ("endchar".equals(this.commandName)) {
                                noChange = true;
                                commandNumber = new byte[]{14};
                            } else if ("rmoveto".equals(this.commandName)) {
                                noChange = true;
                                commandNumber = new byte[]{21};
                            } else if ("hmoveto".equals(this.commandName)) {
                                noChange = true;
                                commandNumber = new byte[]{22};
                            } else if ("vhcurveto".equals(this.commandName)) {
                                noChange = true;
                                commandNumber = new byte[]{30};
                            } else if ("hvcurveto".equals(this.commandName)) {
                                noChange = true;
                                commandNumber = new byte[]{31};
                            } else if ("flex".equals(this.commandName)) {
                                noChange = true;
                                commandNumber = new byte[]{12, 35};
                            } else if (this.commandName.length() == 0) {
                                return new byte[0];
                            }
                        }
                    }
                }
            }
lbl127:
            // 22 sources

            if (noChange) {
                block49: {
                    bos = this.getStreamWithArgs();
                    try {
                        bos.write(commandNumber);
                    }
                    catch (IOException e) {
                        if (!LogWriter.isOutput()) break block49;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                return bos.toByteArray();
            }
            return new byte[0];
        }

        private ByteArrayOutputStream getStreamWithArgs() {
            ByteArrayOutputStream result;
            block3: {
                result = new ByteArrayOutputStream();
                try {
                    for (CharstringElement arg : this.args) {
                        result.write(arg.getType2Bytes());
                    }
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            return result;
        }

        public String toString() {
            if (this.isCommand) {
                return this.commandName + this.args.toString();
            }
            if (this.isResult) {
                return "result of " + this.parent;
            }
            return String.valueOf(this.numberValue);
        }

        private void printStack() {
            System.out.println("Stack bottom");
            for (CharstringElement e : CFFWriter.this.currentCharString) {
                if (e.isCommand) continue;
                System.out.println(e);
            }
            System.out.println("Stack top");
        }

        private boolean claimArguments(int count, boolean takeFromBottom, boolean clearStack) {
            if (count > 0) {
                int currentIndex = CFFWriter.this.currentCharString.indexOf(this);
                if (currentIndex == -1) {
                    throw new RuntimeException("Not in list!");
                }
                int argsFound = 0;
                boolean failed = false;
                while (argsFound < count && !failed) {
                    CharstringElement e;
                    int pos;
                    boolean found = false;
                    if (takeFromBottom) {
                        for (pos = 0; !found && pos <= currentIndex; ++pos) {
                            e = (CharstringElement)CFFWriter.this.currentCharString.get(pos);
                            if (e.isCommand) continue;
                            ++argsFound;
                            this.args.add(e);
                            CFFWriter.this.currentCharString.remove(e);
                            found = true;
                        }
                    } else {
                        for (pos = currentIndex; !found && pos >= 0; --pos) {
                            e = (CharstringElement)CFFWriter.this.currentCharString.get(pos);
                            if (e.isCommand) continue;
                            ++argsFound;
                            this.args.add(e);
                            CFFWriter.this.currentCharString.remove(e);
                            found = true;
                            --currentIndex;
                        }
                    }
                    if (found) continue;
                    failed = true;
                }
                if (argsFound < count) {
                    return false;
                }
            }
            if (clearStack) {
                for (int i = 0; i < CFFWriter.this.currentCharString.size(); ++i) {
                    CharstringElement e = (CharstringElement)CFFWriter.this.currentCharString.get(i);
                    if (e.isCommand) continue;
                    CFFWriter.this.currentCharString.remove(e);
                }
            }
            return true;
        }
    }
}

