/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.OS2;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;

public class OS2Writer
extends OS2
implements FontTableWriter {
    private static final long serialVersionUID = -9180063907293716888L;
    int glyphCount = 0;
    int xAvgCharWidth = 0;
    int minCharCode;
    int maxCharCode;
    float[] bounds;
    double scaling = 1.0;
    PdfFont originalFont;
    PdfJavaGlyphs glyphs;

    public OS2Writer(PdfFont originalFont, PdfJavaGlyphs glyphs, int xAvgCharWidth, int minCharCode, int maxCharCode, float[] bounds, double emSquareSize) {
        this.originalFont = originalFont;
        this.glyphs = glyphs;
        this.glyphCount = glyphs.getGlyphCount();
        this.minCharCode = minCharCode;
        this.maxCharCode = maxCharCode;
        this.bounds = bounds;
        this.xAvgCharWidth = xAvgCharWidth;
        if (emSquareSize != 1000.0) {
            this.scaling = 1.0 / (emSquareSize / 1000.0);
        }
    }

    @Override
    public byte[] writeTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.originalFont.getFontType() == 1217103210) {
            TTGlyphs ttGlyphs = (TTGlyphs)this.glyphs;
            Hhea hhea = (Hhea)this.glyphs.getTable(5);
            int ascender = hhea.getIntValue(1);
            int descender = hhea.getIntValue(2);
            bos.write(FontWriter.setNextInt16(3));
            bos.write(FontWriter.setNextInt16(this.xAvgCharWidth));
            bos.write(FontWriter.setNextInt16(400));
            bos.write(FontWriter.setNextInt16(5));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16((int)((double)ascender * 0.3)));
            bos.write(FontWriter.setNextInt16((int)((double)ascender * 0.3)));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16((int)((double)ascender * 0.3)));
            bos.write(FontWriter.setNextInt16((int)((double)ascender * 0.3)));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16((int)((double)ascender * 0.3)));
            bos.write(FontWriter.setNextInt16((int)((double)ascender * 0.3)));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(new byte[4]);
            bos.write(FontWriter.setNextInt16(64));
            bos.write(FontWriter.setNextInt16(this.minCharCode));
            bos.write(FontWriter.setNextInt16(this.maxCharCode));
            bos.write(FontWriter.setNextInt16(ascender + descender));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(ascender));
            descender = Math.abs(descender);
            bos.write(FontWriter.setNextInt16(descender));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
        } else {
            bos.write(FontWriter.setNextInt16(3));
            bos.write(FontWriter.setNextInt16(this.xAvgCharWidth));
            bos.write(FontWriter.setNextInt16(400));
            bos.write(FontWriter.setNextInt16(5));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(102));
            bos.write(FontWriter.setNextInt16(102));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(102));
            bos.write(FontWriter.setNextInt16(102));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(102));
            bos.write(FontWriter.setNextInt16(102));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(new byte[4]);
            bos.write(FontWriter.setNextInt16(64));
            bos.write(FontWriter.setNextInt16(this.minCharCode));
            bos.write(FontWriter.setNextInt16(this.maxCharCode));
            bos.write(FontWriter.setNextInt16(1000));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16((int)((double)this.bounds[3] * this.scaling)));
            bos.write(FontWriter.setNextInt16(-((int)((double)this.bounds[1] * this.scaling))));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextUint32(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
            bos.write(FontWriter.setNextInt16(0));
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public int getIntValue(int key) {
        return 0;
    }
}

