/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.exception.PdfException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.EncryptionUsed;
import org.jpedal.io.ImageInputStreamFileBuffer;
import org.jpedal.io.NameLookup;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.io.RandomAccessMemoryMapBuffer;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.raw.FDFObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class PdfReader
implements PdfObjectReader,
Serializable {
    private static final long serialVersionUID = 9005615362777773174L;
    private PdfFileReader objectReader = new PdfFileReader();
    Map pagesReferences = new HashMap();
    private PageLookup pageLookup = new PageLookup();
    private long eof = 0L;
    private String tempFileName = null;
    private NameLookup nameLookup = null;
    RandomAccessBuffer pdf_datafile = null;
    private Javascript javascript;

    public PdfReader() {
    }

    public PdfReader(String password) {
        if (password == null) {
            password = "";
        }
        this.objectReader.setPassword(password);
    }

    public PdfReader(Certificate certificate, PrivateKey key) {
        this.objectReader.setCertificate(certificate, key);
    }

    @Override
    public String getReferenceforPage(int page) {
        return (String)this.pagesReferences.get(page);
    }

    @Override
    public final void closePdfFile() {
        block4: {
            try {
                this.objectReader.closeFile();
                if (this.pdf_datafile != null) {
                    this.pdf_datafile.close();
                }
                if (this.tempFileName != null) {
                    File fileToDelete = new File(this.tempFileName);
                    fileToDelete.delete();
                    this.tempFileName = null;
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception " + e + " closing file");
            }
        }
    }

    @Override
    public PdfObject getPDFObject(int key) {
        if (key == 1113489015) {
            return this.objectReader.encyptionObj;
        }
        throw new RuntimeException("Access to " + key + " not supported");
    }

    @Override
    public PdfFileReader getObjectReader() {
        return this.objectReader;
    }

    @Override
    public String convertNameToRef(String value) {
        if (this.nameLookup == null) {
            return null;
        }
        return (String)this.nameLookup.get(value);
    }

    @Override
    public final PdfObject readFDF() throws PdfException {
        FDFObject fdfObj;
        try {
            byte[] fileData = this.objectReader.readFDFData();
            fdfObj = new FDFObject("1 0 R");
            int ii = 0;
            while ((long)ii < this.eof && (fileData[ii] != 47 || fileData[ii + 1] != 70 || fileData[ii + 2] != 68 || fileData[ii + 3] != 70)) {
                ++ii;
            }
            ii += 4;
            while ((long)ii < this.eof && (fileData[ii] != 60 || fileData[ii + 1] != 60)) {
                ++ii;
            }
            ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
            objectDecoder.readDictionaryAsObject(fdfObj, ii += 2, fileData);
        }
        catch (Exception e) {
            block6: {
                try {
                    this.objectReader.closeFile();
                }
                catch (IOException e1) {
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception " + e + " closing file");
                }
            }
            throw new PdfException("Exception " + e + " reading trailer");
        }
        return fdfObj;
    }

    @Override
    public void readNames(PdfObject nameObject, Javascript javascript, boolean isKid) {
        this.nameLookup = new NameLookup(this.objectReader);
        this.nameLookup.readNames(nameObject, javascript, isKid);
    }

    @Override
    public int convertObjectToPageNumber(String ref) {
        return this.pageLookup.convertObjectToPageNumber(ref);
    }

    @Override
    public void setLookup(String currentPageOffset, int tempPageCount) {
        this.pageLookup.put(currentPageOffset, tempPageCount);
        this.pagesReferences.put(tempPageCount, currentPageOffset);
    }

    @Override
    public void dispose() {
        this.nameLookup = null;
        if (this.objectReader != null) {
            this.objectReader.dispose();
        }
        this.objectReader = null;
        if (this.pageLookup != null) {
            this.pageLookup.dispose();
        }
        this.pageLookup = null;
    }

    @Override
    public final void openPdfFile(InputStream in) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessMemoryMapBuffer(in);
            this.objectReader.init(this.pdf_datafile);
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e + " accessing file");
            }
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    @Override
    public final void openPdfFile(ImageInputStream iis) throws PdfException {
        try {
            ImageInputStreamFileBuffer pdf_datafile = new ImageInputStreamFileBuffer(iis);
            this.objectReader.init(pdf_datafile);
            this.eof = pdf_datafile.length();
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e + " accessing file");
            }
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    @Override
    public void checkParentForResources(PdfObject pdfObject) {
        String parent;
        if (pdfObject.getDictionary(2004251818) == null && (parent = pdfObject.getStringKey(1110793845)) != null) {
            PageObject parentObj = new PageObject(parent);
            this.readObject(parentObj);
            PdfObject resObj = ((PdfObject)parentObj).getDictionary(2004251818);
            if (resObj != null) {
                pdfObject.setDictionary(2004251818, resObj);
            }
        }
    }

    @Override
    public final void openPdfFile(String filename) throws PdfException {
        try {
            RandomAccessFileBuffer pdf_datafile = new RandomAccessFileBuffer(filename, "r");
            this.objectReader.init(pdf_datafile);
            this.eof = pdf_datafile.length();
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e + " accessing file");
            }
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    @Override
    public final void openPdfFile(byte[] data) throws PdfException {
        try {
            RandomAccessBuffer pdf_datafile;
            if (PdfFileReader.alwaysCacheInMemory == -1 || data.length < PdfFileReader.alwaysCacheInMemory) {
                pdf_datafile = new RandomAccessDataBuffer(data);
            } else {
                try {
                    File file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
                    this.tempFileName = file.getAbsolutePath();
                    FileOutputStream a = new FileOutputStream(file);
                    a.write(data);
                    a.flush();
                    a.close();
                    pdf_datafile = new RandomAccessFileBuffer(this.tempFileName, "r");
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create temporary file in " + ObjectStore.temp_dir);
                }
            }
            this.objectReader.init(pdf_datafile);
            this.eof = pdf_datafile.length();
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e + " accessing file");
            }
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    @Override
    public void checkResolved(PdfObject pdfObject) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(pdfObject);
    }

    @Override
    public byte[] readStream(PdfObject obj, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream, String cacheFile) {
        return this.objectReader.readStream(obj, cacheValue, decompress, keepRaw, isMetaData, isCompressedStream, cacheFile);
    }

    @Override
    public void readObject(PdfObject pdfObject) {
        this.objectReader.readObject(pdfObject);
    }

    @Override
    public EncryptionUsed getEncryptionType() {
        PdfFileReader objectReader = this.objectReader;
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        if (decryption == null) {
            return EncryptionUsed.NO_ENCRYPTION;
        }
        if (decryption.hasPassword()) {
            return EncryptionUsed.PASSWORD;
        }
        return EncryptionUsed.CERTIFICATE;
    }
}

