/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class Flate
extends BaseFilter
implements PdfFilter {
    private int predictor = 1;
    private int colors = 1;
    private int bitsPerComponent = 8;
    private int columns = 1;
    private boolean hasError = false;

    public Flate(PdfObject decodeParms) {
        super(decodeParms);
        if (decodeParms != null) {
            int columnsSet;
            int newColors;
            int newBitsPerComponent = decodeParms.getInt(-1344207655);
            if (newBitsPerComponent != -1) {
                this.bitsPerComponent = newBitsPerComponent;
            }
            if ((newColors = decodeParms.getInt(1010783618)) != -1) {
                this.colors = newColors;
            }
            if ((columnsSet = decodeParms.getInt(1162902911)) != -1) {
                this.columns = columnsSet;
            }
            this.predictor = decodeParms.getInt(1970893723);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decode(byte[] data) throws Exception {
        int bufSize = 512000;
        ByteArrayOutputStream bos = null;
        boolean failed = true;
        int orgSize = data.length;
        if (data != null) {
            while (failed) {
                Inflater inf = new Inflater();
                inf.setInput(data);
                int size = data.length;
                bos = new ByteArrayOutputStream(size);
                if (size < bufSize) {
                    bufSize = size;
                }
                byte[] buf = new byte[bufSize];
                try {
                    while (!inf.finished()) {
                        int count = inf.inflate(buf);
                        bos.write(buf, 0, count);
                        if (inf.getRemaining() != 0) continue;
                    }
                    failed = false;
                }
                catch (Exception ee) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception in Flate " + ee);
                    }
                    failed = true;
                    this.hasError = true;
                    if (data.length == orgSize && data.length > 10000) {
                        failed = false;
                        continue;
                    }
                    if (data.length > 10) {
                        byte[] newData = new byte[data.length - 1];
                        System.arraycopy(data, 0, newData, 0, data.length - 1);
                        data = newData;
                        continue;
                    }
                    failed = false;
                }
                finally {
                    inf.end();
                    inf = null;
                }
            }
            data = bos.toByteArray();
            return this.applyPredictor(this.predictor, data, this.colors, this.bitsPerComponent, this.columns);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map cachedObjects) throws Exception {
        this.bis = bis;
        this.streamCache = streamCache;
        this.cachedObjects = cachedObjects;
        if (bis != null) {
            InflaterInputStream inf = null;
            try {
                inf = new InflaterInputStream(bis);
                while (true) {
                    int b = ((InputStream)inf).read();
                    if (((InputStream)inf).available() == 0 || b == -1) break;
                    streamCache.write(b);
                }
                if (this.predictor != 1 && this.predictor != 10) {
                    streamCache.flush();
                    streamCache.close();
                    if (cacheName != null) {
                        this.setupCachedObjectForDecoding(cacheName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + e + " accessing Flate filter ");
                }
            }
            finally {
                if (inf != null) {
                    ((InputStream)inf).close();
                    inf = null;
                }
            }
        }
        this.applyPredictor(this.predictor, null, this.colors, this.bitsPerComponent, this.columns);
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }
}

