/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.font.OutlineFont;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFGlyph;
import com.sun.pdfview.font.Type3Font;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class FontToy
extends JPanel {
    JComboBox comboBox;
    private JMenuItem exitMenuItem = new JMenuItem("Exit");
    private JFileChooser openFileChooser = null;
    private JMenu fileMenu = new JMenu("File");
    private Set fonts;
    private PDFFont font;
    private JFrame jf = new JFrame("Font Toy");
    private Font gfont;
    private PDFGlyph glyph;
    private JComboBox glyphBox;
    private SpinnerListModel glyphModel = new SpinnerListModel();
    private JLabel glyphName = new JLabel();
    private JSpinner glyphSpinner = new JSpinner(this.glyphModel);
    private File inputFile = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenuItem openMenuItem = new JMenuItem("Open");
    private PDFFile pdf = null;

    public FontToy(String[] stringArray) throws IOException {
        Box box = Box.createHorizontalBox();
        this.glyphBox = new JComboBox();
        this.glyphBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Integer n = (Integer)itemEvent.getItem();
                    FontToy.this.glyphSelected(n);
                    FontToy.this.glyphSpinner.setValue(n);
                }
            }
        });
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FontToy.this.fontSelected((PDFFont)itemEvent.getItem());
                }
            }
        });
        this.comboBox.setMaximumSize(new Dimension(200, 50));
        box.add(new JLabel("Fonts:"));
        box.add(this.comboBox);
        box.add(Box.createHorizontalStrut(15));
        box.add(new JLabel("Glyphs:"));
        box.add(this.glyphBox);
        box.add(this.glyphName);
        box.add(this.glyphSpinner);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)box, "North");
        jPanel.add((Component)this, "Center");
        jPanel.setFocusable(true);
        jPanel.requestFocus();
        jPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.keyPressed(keyEvent);
            }
        });
        this.jf.setContentPane(jPanel);
        this.jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(-1);
            }
        });
        this.jf.setSize(640, 480);
        this.jf.setVisible(true);
        this.jf.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontToy.this.openPDF();
            }
        });
        this.glyphSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)FontToy.this.glyphSpinner.getValue();
                FontToy.this.glyphSelected(n);
                FontToy.this.glyphBox.setSelectedItem(n);
            }
        });
        if (stringArray.length > 0) {
            this.initialize(stringArray[0]);
        }
    }

    private void drawShape(Graphics2D graphics2D, GeneralPath generalPath, int n, int n2) {
        double d;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Rectangle2D rectangle2D = generalPath.getBounds2D();
        double d2 = (double)(n - 20) / rectangle2D.getWidth();
        if (d2 < (d = (double)(n2 - 20) / rectangle2D.getHeight())) {
            d = d2;
        } else {
            d2 = d;
        }
        double d3 = 10.0 - rectangle2D.getX() * d2;
        double d4 = (double)(n2 - 10) + rectangle2D.getY() * d;
        AffineTransform affineTransform = new AffineTransform(d2, 0.0, 0.0, -d, d3, d4);
        Rectangle2D rectangle2D2 = generalPath.createTransformedShape(affineTransform).getBounds2D();
        graphics2D.setColor(Color.CYAN);
        graphics2D.fill(generalPath.createTransformedShape(affineTransform));
        graphics2D.setColor(Color.BLACK);
        int n3 = 0;
        PathIterator pathIterator = generalPath.getPathIterator(affineTransform);
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    this.drawPoint(graphics2D, n3++, f, f2, false);
                    f3 = f;
                    f4 = f2;
                    break;
                }
                case 1: {
                    Line2D.Float float_ = new Line2D.Float(f, f2, fArray[0], fArray[1]);
                    graphics2D.draw(float_);
                    this.drawPoint(graphics2D, n3++, fArray[0], fArray[1], false);
                    f = fArray[0];
                    f2 = fArray[1];
                    break;
                }
                case 3: {
                    CubicCurve2D.Float float_ = new CubicCurve2D.Float(f, f2, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    graphics2D.draw(float_);
                    this.drawPoint(graphics2D, n3++, fArray[0], fArray[1], true);
                    this.drawPoint(graphics2D, n3++, fArray[2], fArray[3], true);
                    this.drawPoint(graphics2D, n3++, fArray[4], fArray[5], false);
                    f = fArray[4];
                    f2 = fArray[5];
                    break;
                }
                case 2: {
                    QuadCurve2D.Float float_ = new QuadCurve2D.Float(f, f2, fArray[0], fArray[1], fArray[2], fArray[3]);
                    graphics2D.draw(float_);
                    this.drawPoint(graphics2D, n3++, fArray[0], fArray[1], true);
                    this.drawPoint(graphics2D, n3++, fArray[2], fArray[3], false);
                    f = fArray[2];
                    f2 = fArray[3];
                    break;
                }
                case 4: {
                    Line2D.Float float_ = new Line2D.Float(f, f2, f3, f4);
                    graphics2D.draw(float_);
                    f = f3;
                    f2 = f4;
                }
            }
            pathIterator.next();
        }
    }

    public void drawPoint(Graphics2D graphics2D, int n, float f, float f2, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        if (bl) {
            generalPath.moveTo(f - 1.0f, f2 - 1.0f);
            generalPath.lineTo(f + 1.0f, f2 + 1.0f);
            generalPath.moveTo(f - 1.0f, f2 + 1.0f);
            generalPath.lineTo(f + 1.0f, f2 - 1.0f);
        } else {
            generalPath.moveTo(f - 1.0f, f2 - 1.0f);
            generalPath.lineTo(f - 1.0f, f2 + 1.0f);
            generalPath.lineTo(f + 1.0f, f2 + 1.0f);
            generalPath.lineTo(f + 1.0f, f2 - 1.0f);
            generalPath.closePath();
        }
        graphics2D.setColor(Color.red);
        graphics2D.draw(generalPath);
        graphics2D.setColor(Color.blue);
        graphics2D.setFont(this.gfont);
        graphics2D.drawString(String.valueOf(n), f + 3.0f, f2 + 3.0f);
    }

    private void drawPage(Graphics2D graphics2D, PDFPage pDFPage, int n, int n2) {
        Dimension dimension = pDFPage.getUnstretchedSize(n - 20, n2 - 20, null);
        Image image = pDFPage.getImage(dimension.width, dimension.height, null, null, true, true);
        graphics2D.drawImage(image, 0, 0, null);
    }

    private Set<PDFFont> findFonts(PDFObject pDFObject, Map<String, PDFObject> object) throws IOException {
        Object object2;
        Object object3;
        HashSet<PDFFont> hashSet = new HashSet<PDFFont>();
        PDFObject pDFObject2 = pDFObject.getDictRef("Resources");
        if (pDFObject2 != null) {
            PDFObject pDFObject3;
            String string;
            Iterator iterator;
            PDFObject pDFObject4;
            object3 = new HashMap();
            ((HashMap)object3).putAll(object);
            object2 = pDFObject2.getDictionary();
            ((HashMap)object3).putAll(object2);
            if (object2.containsKey("Font")) {
                pDFObject4 = (PDFObject)object2.get("Font");
                iterator = pDFObject4.getDictKeys();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    pDFObject3 = pDFObject4.getDictRef(string);
                    try {
                        PDFFont pDFFont = PDFFont.getFont(pDFObject3, (HashMap<String, PDFObject>)object3);
                        hashSet.add(pDFFont);
                    }
                    catch (Exception exception) {
                        System.out.println("Error finding font from " + pDFObject3);
                        exception.printStackTrace();
                    }
                }
            }
            if (object2.containsKey("XObject")) {
                pDFObject4 = (PDFObject)object2.get("XObject");
                iterator = pDFObject4.getDictKeys();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    pDFObject3 = pDFObject4.getDictRef(string);
                    hashSet.addAll(this.findFonts(pDFObject3, new HashMap<String, PDFObject>()));
                }
            }
            object = object3;
        }
        if ((object3 = pDFObject.getDictRef("Kids")) != null) {
            object2 = ((PDFObject)object3).getArray();
            for (int i = 0; i < ((PDFObject[])object2).length; ++i) {
                hashSet.addAll(this.findFonts((PDFObject)object2[i], (Map<String, PDFObject>)object));
            }
        }
        return hashSet;
    }

    private void fontSelected(PDFFont pDFFont) {
        this.setCurrentFont(pDFFont);
        int n = 0;
        int n2 = 255;
        if (pDFFont instanceof OutlineFont) {
            n = ((OutlineFont)pDFFont).getFirstChar();
            n2 = ((OutlineFont)pDFFont).getLastChar();
        } else if (pDFFont instanceof Type3Font) {
            n = ((Type3Font)pDFFont).getFirstChar();
            n2 = ((Type3Font)pDFFont).getLastChar();
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 255;
        }
        Vector<Integer> vector = new Vector<Integer>(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            vector.add(new Integer(i));
        }
        this.glyphBox.setModel(new DefaultComboBoxModel(vector));
        this.glyphModel = new SpinnerListModel(vector);
        this.glyphSpinner.setModel(this.glyphModel);
        Integer n3 = new Integer(n);
        this.glyphSelected(n3);
    }

    public Set getFonts() {
        return this.fonts;
    }

    public PDFFont getCurrentFont() {
        return this.font;
    }

    private void glyphSelected(Integer n) {
        char c = (char)n.intValue();
        String string = String.valueOf(c);
        PDFFont pDFFont = this.getCurrentFont();
        List<PDFGlyph> list = pDFFont.getGlyphs(string);
        PDFGlyph pDFGlyph = list.get(0);
        this.setCurrentGlyph(pDFGlyph);
        this.repaint();
    }

    private void initialize(String string) throws IOException {
        Object object;
        Object object2;
        this.jf.setTitle("PDFRenderer Font Toy - " + string);
        try {
            this.inputFile = new File(string);
            object2 = new FileInputStream(this.inputFile);
            object = new byte[(int)this.inputFile.length()];
            int n = 0;
            int n2 = 0;
            while (n >= 0) {
                n = ((FileInputStream)object2).read((byte[])object, n2, ((Object)object).length - n2);
            }
            ((FileInputStream)object2).close();
            ByteBuffer byteBuffer = ByteBuffer.allocate(((Object)object).length);
            byteBuffer.put((byte[])object);
            this.pdf = new PDFFile(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = this.pdf.getRoot();
        object = ((PDFObject)object2).getDictRef("Pages");
        this.fonts = this.findFonts((PDFObject)object, new HashMap<String, PDFObject>());
        this.gfont = new Font("Sans-serif", 0, 10);
        Object[] objectArray = this.getFonts().toArray();
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.fontSelected((PDFFont)objectArray[0]);
        this.validate();
    }

    public PDFGlyph getCurrentGlyph() {
        return this.glyph;
    }

    private void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2 = n = this.glyphBox.getSelectedIndex();
        if (keyEvent.getKeyCode() == 37) {
            if (--n2 < 0) {
                n2 = this.glyphBox.getItemCount() - 1;
            }
        } else if (keyEvent.getKeyCode() == 39 && ++n2 >= this.glyphBox.getItemCount()) {
            n2 = 0;
        }
        if (n2 != n) {
            this.glyphBox.setSelectedIndex(n2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            FontToy fontToy = new FontToy(stringArray);
        }
        catch (IOException iOException) {
            Logger.getLogger(FontToy.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    private void openPDF() {
        if (this.openFileChooser == null) {
            this.openFileChooser = new JFileChooser(this.inputFile);
            this.openFileChooser.setAcceptAllFileFilterUsed(false);
            this.openFileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                }

                @Override
                public String getDescription() {
                    return "PDF Files (*.pdf)";
                }
            });
        }
        switch (this.openFileChooser.showOpenDialog(this)) {
            case 0: {
                try {
                    this.initialize(this.openFileChooser.getSelectedFile().getPath());
                }
                catch (IOException iOException) {
                    Logger.getLogger(FontToy.class.getName()).log(Level.SEVERE, null, iOException);
                }
                break;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.BLACK);
        if (this.glyph == null) {
            return;
        }
        GeneralPath generalPath = this.glyph.getShape();
        PDFPage pDFPage = this.glyph.getPage();
        if (generalPath != null) {
            this.drawShape(graphics2D, generalPath, n, n2);
        } else if (pDFPage != null) {
            this.drawPage(graphics2D, pDFPage, n, n2);
        }
    }

    public void setCurrentFont(PDFFont pDFFont) {
        this.font = pDFFont;
    }

    public void setCurrentGlyph(PDFGlyph pDFGlyph) {
        this.glyph = pDFGlyph;
        this.glyphName.setText(pDFGlyph.getName());
    }
}

