/** @odoo-module **/

import { IntegerField } from "@web/views/fields/integer/integer_field";
import { FloatField } from "@web/views/fields/float/float_field";
import { patch } from "@web/core/utils/patch";
import { markup } from "@odoo/owl";

patch(IntegerField.prototype, "entrivis_required_numeric.IntegerField", {
    get formattedValue() {
        if (this.props.record.isRequired(this.props.name) && this.props.value == 0) {
            this.env.model.notificationService.add(
                markup(`<ul>Value for ${this.props.record.fields[this.props.name].string} field should be greater than 0.</ul>`),
                {
                    title: "Invalid field: ",
                    type: "danger",
                }
            );
            this.props.record.setInvalidField(this.props.name)
        }
        return this._super();
    }
});

patch(FloatField.prototype, "entrivis_required_numeric.FloatField", {
    get formattedValue() {
        if (this.props.record.isRequired(this.props.name) && (this.props.value == 0) || this.props.value == 0.0) {
            this.env.model.notificationService.add(
                markup(`<ul>Value for ${this.props.record.fields[this.props.name].string} field should be greater than 0.</ul>`),
                {
                    title: "Invalid field: ",
                    type: "danger",
                }
            );
            this.props.record.setInvalidField(this.props.name)
        }
        return this._super();
    }
});
