# Copyright 2023 Camptocamp SA
# Copyright 2023 Michael Tietz (MT Software) <mtietz@mt-software.de>
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl)


from odoo.addons.component.core import Component


class ShopfloorSingleProductTransfer(Component):
    _inherit = "shopfloor.single.product.transfer"

    def _set_quantity__check_location(
        self, move_line, location, package=None, confirmation=False
    ):
        # We add an additional check to verify if the location requires packages
        # and return a message to the user accordingly.
        if (
            location.package_restriction
            and not package
            and not move_line.result_package_id
        ):
            message = self.msg_store.location_requires_package()
            return self._response_for_set_quantity(
                move_line, message=message, asking_confirmation=None
            )
        return super()._set_quantity__check_location(
            move_line, location, package=package, confirmation=confirmation
        )
