# -- coding: utf-8 --
from odoo import models, fields


class ResConfigSettings(models.TransientModel):
    _inherit = 'res.config.settings'

    sms_provider_type = fields.Selection(
        selection=[
            ('spryng_sms', 'Spryng SMS'),
            ('odoo_iap', 'Odoo IAP'),
        ],
        string='SMS Provider',
        default='spryng_sms',
        config_parameter='spryng_sms.sms_provider_type'
    )

    spryng_sms_server_url = fields.Char(
        string='Spryng SMS server',
        config_parameter='spryng_sms.spryng_sms_server_url',
        default='https://rest.spryngsms.com/v1/messages'
    )

    spryng_sms_token = fields.Char(
        string='Spryng SMS token',
        config_parameter='spryng_sms.spryng_sms_token'
    )

    spryng_sms_user = fields.Char(
        string='Spryng SMS user',
        config_parameter='spryng_sms.spryng_sms_user'
    )

    spryng_sms_password = fields.Char(
        string='Spryng SMS password',
        config_parameter='spryng_sms.spryng_sms_password'
    )

    spryng_sms_route = fields.Char(
        string='Spryng SMS route',
        default='3209',
        config_parameter='spryng_sms.spryng_sms_route'
    )

    spryng_sms_originator = fields.Char(
        string='Spryng SMS originator',
        default='ODOO_MFM',
        config_parameter='spryng_sms.spryng_sms_originator'
    )
