# -*- coding: utf-8 -*-
from odoo import models, fields

class SmsSms(models.Model):
    _inherit = 'sms.sms'

    spryng_id = fields.Char(
        string='Spryng ID',
        copy=False,
    )

    spryng_delivered = fields.Boolean(
        string='Spryng delivered',
        copy=False
    )

    spryng_reason_code = fields.Selection(
        selection=[
            ('0', 'No error'),
            ('20', 'Recipient number unreachable'),
            ('21', 'Recipient number incorrect'),
            ('22', 'Delivery Failure'),
            ('31', 'The recipient is blacklisted (e.g. People that respond "STOP" to an earlier message can appear '
                   'in the blacklist)')
        ],
        string='Spryng reason code',
        copy=False,
    )

    spryng_operator_status_at = fields.Char(
        string='Spryng operator status at',
        copy=False,
    )

    spryng_status_code = fields.Integer(
        string='Spryng status code',
        default=200,
        copy=False,
    )

    spryng_status_error = fields.Text(
        string='Spryng status error',
        copy=False,
    )

    sms_send_from = fields.Selection(
        selection=[
            ('spryng', 'Spryng'),
            ('odoo_iap', 'Odoo IAP')],
        string='SMS send from',
        copy=False,
    )

    spryng_recipient = fields.Char(
        string='Spryng recipient',
        copy=False,
    )

    spryng_reference = fields.Char(
        string='Spryng reference',
        copy=False,
    )

    spryng_added = fields.Char(
        string='Spryng added',
        copy=False,
    )

    spryng_result_date = fields.Char(
        string='Spryng result date',
        copy=False,
    )

    spryng_operator = fields.Char(
        string='Spryng operator',
        copy=False,
    )

    def _postprocess_iap_sent_sms(self, iap_results, failure_reason=None, unlink_failed=False, unlink_sent=True):
        """
        Override of default Odoo function
        We update the Spryng SMS records in Odoo.
        ODOO URL: https://github.com/odoo/odoo/blob/d04c8b7e484db8306d858c891a7a2b11885fdcd9/addons/sms/models/sms_sms.py#L181
        """
        for state in self.IAP_TO_SMS_STATE.keys():
            sms_ids = [item['res_id'] for item in iap_results if item['state'] == state and item.get('spryng')]
            if sms_ids:
                sms_records = self.env['sms.sms'].sudo().browse(sms_ids)
                if state != 'success':
                   sms_records.write({
                        'state': 'error',
                        'failure_type': self.IAP_TO_SMS_STATE[state],
                    })
                else:
                    sms_records.write({
                        'state': 'sent',
                        'sms_send_from': 'spryng'
                    })
                notifications = self.env['mail.notification'].sudo().search([
                    ('notification_type', '=', 'sms'),
                    ('sms_id', 'in', sms_ids),
                    ('notification_status', 'not in', ('sent', 'canceled'))]
                )
                if notifications:
                    notifications.write({
                        'notification_status': 'sent' if state == 'success' else 'exception',
                        'failure_type': self.IAP_TO_SMS_STATE[state] if state != 'success' else False,
                        'failure_reason': failure_reason if failure_reason else False,
                    })
            else:
                sms_ids = [item['res_id']
                           for item in iap_results if item['state'] == state]
                sms_records = self.env['sms.sms'].sudo().browse(sms_ids)
                sms_records.write({
                    'sms_send_from': 'odoo_iap'
                })
        iap_results = [x for x in iap_results if not x.get('spryng')]
        return super()._postprocess_iap_sent_sms(iap_results, failure_reason, unlink_failed=unlink_failed, unlink_sent=unlink_sent)

    def action_generate_activity(self, error_message, res_model_id, res_id, sms_id):
        context = dict(self._context) or {}
        if res_model_id and res_id:
            record_id = self.env[res_model_id].browse(res_id)
            if not context.get('from_sms_api'):
                error_message = "Message sent failed due to '%s'" % dict(
                    sms_id._fields['spryng_reason_code']._description_selection(sms_id.env)).get(error_message)
            if isinstance(record_id, type(self.env['mail.activity.mixin'])):
                record_id.with_context(active_model=res_model_id, active_id=res_id).activity_schedule(
                    summary='SMS Sent Failed',
                    activity_type_id=self.env.ref('mail.mail_activity_data_todo').id,
                    user_id=self.env.user.id,
                    note=error_message
            )
