#  Copyright 2023 Simone Rubino - TAKOBI
#  License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl).

from odoo import models


class StockQuant (models.Model):
    _inherit = 'stock.quant'

    def _update_available_quantity(
        self, product_id, location_id, quantity,
        lot_id=None, package_id=None, owner_id=None, in_date=None,
    ):
        date_backdating = self.env.context.get('date_backdating')
        if date_backdating is not None:
            if in_date is not None:
                in_date = min(date_backdating, in_date)
            else:
                in_date = date_backdating
        return super()._update_available_quantity(
            product_id, location_id, quantity,
            lot_id=lot_id, package_id=package_id, owner_id=owner_id, in_date=in_date,
        )
