# Copyright 2023 ACSONE SA/NV
# License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl).

from odoo import models


class StockMove(models.Model):

    _inherit = "stock.move"

    def _prepare_move_line_vals(self, quantity=None, reserved_quant=None) -> dict:
        """
        This adds the reserved quant to the move line values
        """
        res = super()._prepare_move_line_vals(
            quantity=quantity, reserved_quant=reserved_quant
        )
        if reserved_quant is not None:
            res.update(
                {
                    "reserved_quant_id": reserved_quant.id,
                }
            )
        return res
