# Copyright 2020 Tecnativa - David Vidal
# License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl).
from odoo import fields, models


class StockImmediateTransfer(models.TransientModel):
    _inherit = 'stock.immediate.transfer'

    number_of_packages = fields.Integer(
        help="Set the number of packages for this picking(s)",
    )

    def process(self):
        if self.number_of_packages:
            self.pick_ids.write(
                {"number_of_packages": self.number_of_packages})
        return super().process()
