# Copyright 2020 Carlos Roca <carlos.roca@tecnativa.com>
# License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl.html).
import barcode  # pylint: disable=missing-manifest-dependency
from barcode.writer import SVGWriter  # pylint: disable=missing-manifest-dependency

from odoo import http
from odoo.http import request

from odoo.addons.web.controllers.main import ReportController


class ReportController(ReportController):
    @http.route()
    def report_barcode(
        self,
        type,  # pylint: disable=redefined-builtin
        value,
        width=600,
        height=100,
        humanreadable=0,
        quiet=1,
    ):
        if type == "gs1_128":
            Gs1_128 = barcode.get_barcode_class("gs1_128")
            gs1_182 = Gs1_128(str(value), writer=SVGWitoutTextWriter())
            image = gs1_182.render()
            return request.make_response(
                image, headers=[("Content-Type", "image/svg+xml")]
            )
        return super().report_barcode(
            type,
            value,
            width=width,
            height=height,
            humanreadable=humanreadable,
            quiet=quiet,
        )


class SVGWitoutTextWriter(SVGWriter):
    """ This class extend the SVGWriter of python-barcode to delete the text on
    the barcode image generated by this addon."""

    def _create_text(self, xpos, ypos):
        self.font_size = 0
        self.text = None
