# Copyright 2017 Eficent Business and IT Consulting Services, S.L.
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl.html).

from odoo import api, fields, models


class PurchaseOrder(models.Model):
    _inherit = 'purchase.order'

    stock_request_ids = fields.Many2many(comodel_name='stock.request',
                                         string='Stock Requests',
                                         compute='_compute_stock_request_ids')
    stock_request_count = fields.Integer('Stock Request #',
                                         compute='_compute_stock_request_ids')

    @api.depends('order_line')
    def _compute_stock_request_ids(self):
        for rec in self:
            rec.stock_request_ids = rec.order_line.mapped('stock_request_ids')
            rec.stock_request_count = len(rec.stock_request_ids)

    def action_view_stock_request(self):
        """
        :return dict: dictionary value for created view
        """
        action = self.env.ref(
            'stock_request.action_stock_request_form').read()[0]

        requests = self.mapped('stock_request_ids')
        if len(requests) > 1:
            action['domain'] = [('id', 'in', requests.ids)]
        elif requests:
            action['views'] = [
                (self.env.ref('stock_request.view_stock_request_form').id,
                 'form')]
            action['res_id'] = requests.id
        return action
