<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:PF="http://www.post.ch/xml">
	<xsl:output method="html" indent="no"/>
	<xsl:template match="/IC">
		<xsl:for-each select="KONAUS">
			<HTML>
				<head>
					<!-- ///////////////////////////////////// - Styles - ///////////////////////////////////////// -->
					<STYLE TYPE="text/css">
						STRONG
						{
							color:#CCCCCC;
						}
						WEAK
						{
							color:#FFFFFF;
						}
						.Text7
						{
							font-size:7pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
						.Text8
						{
							font-size:8pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
						.Text9
						{
							font-size:9pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
						.Text10
						{
							font-size:10pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
						.Text11
						{
							font-size:11pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
						.Text12
						{
							font-size:12pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
						.Text13
						{
							font-size:13pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
						.Text14
						{
							font-size:14pt;
							font-family:"Frutiger 45 Light", Arial, Helvetica, sans-serif;
						}
					</STYLE>
				</head>
				<body bgcolor="#FFFFFF" text="#000000">
					<table width="100%" border="0" cellspacing="1" class="Text9">
						<!-- ////////////////////////////// - Page setup - ////////////////////////////// -->
						<tr>
							<!-- empty line for columns setup -->
							<td width="7%" height="0"/>
							<td width="32%" height="0"/>
							<td width="12%" height="0"/>
							<td width="17%" height="0"/>
							<td width="17%" height="0"/>
							<td width="13%" height="0"/>
							<td width="2%" height="0"/>
						</tr>
						<!-- ////////////////////////////// - Logo-Zeile - ////////////////////////////// -->
						<tr>
							<td colspan="3">
								<!-- Leerspalten -->
								<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
							</td>
							<td colspan="4" nowrap="nowrap" align="right" height="68">
								<!-- Logo -->
								<IMG>
									<xsl:choose>
										<xsl:when test="BGM/PF:D_0037[. = '0']">
											<!-- Deutsch -->
											<xsl:attribute name="src">PFLogoD.gif</xsl:attribute>
											<xsl:attribute name="alt"/>
										</xsl:when>
										<xsl:when test="BGM/PF:D_0037[. = '1']">
											<!-- Franzoesisch -->
											<xsl:attribute name="src">PFLogoF.gif</xsl:attribute>
											<xsl:attribute name="alt"/>
										</xsl:when>
										<xsl:when test="BGM/PF:D_0037[. = '2']">
											<!-- Italienisch -->
											<xsl:attribute name="src">PFLogoI.gif</xsl:attribute>
											<xsl:attribute name="alt"/>
										</xsl:when>
										<xsl:when test="BGM/PF:D_0037[. = '3']">
											<!-- Englisch -->
											<xsl:attribute name="src">PFLogoE.gif</xsl:attribute>
											<xsl:attribute name="alt"/>
										</xsl:when>
									</xsl:choose>
									<xsl:attribute name="width">200</xsl:attribute>
								</IMG>
							</td>
						</tr>
						<!-- /////////////////////////// - Kontaktinformationszeilen - /////////////////// -->
						<TR valign="top" class="Text7">
							<b>
								<!--Absenderinfo -->
								<td colspan="3" nowrap="nowrap" height="68">
									<!-- Absender -->
									<xsl:call-template name="PrintSender">
										<xsl:with-param name="Sender" select="SG3/NAD/C058/D_3124/@Desc[../../../D_3035/@Value='HN' and position() = '1']"/>
									</xsl:call-template>
									<BR/>
									<!-- Betreuer -->
									<xsl:for-each select="SG3/NAD/C058/D_3124[../../D_3035/@Value='HN' and position() = '3']">
										<xsl:value-of select="./@Desc"/>
										<BR/>
										<xsl:value-of select="."/>
										<BR/>
									</xsl:for-each>
									<TABLE cellpadding="0" cellspacing="0" border="0" class="Text7">
										<TR>
											<!-- Telefon -->
											<TD>
												<xsl:value-of select="SG3/COM/C076/D_3148/@Desc[../../D_3155/@Value='TE' and //SG3/NAD/D_3035/@Value='HN']"/>
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</TD>
											<TD>
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</TD>
											<TD>
												<xsl:call-template name="PrintPhone">
													<xsl:with-param name="Number" select="SG3/COM/C076/D_3148[../D_3155/@Value='TE' and //SG3/NAD/D_3035/@Value='HN']"/>
													</xsl:call-template>
											</TD>
										</TR>
										<TR>
											<!-- Fax -->
											<TD>
												<xsl:value-of select="SG3/COM/C076/D_3148/@Desc[../../D_3155/@Value='FX' and //SG3/NAD/D_3035/@Value='HN']"/>
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</TD>
											<TD>
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</TD>
											<TD>
												<xsl:call-template name="PrintPhone">
													<xsl:with-param name="Number" select="SG3/COM/C076/D_3148[../D_3155/@Value='FX' and //SG3/NAD/D_3035/@Value='HN']"/>
												</xsl:call-template>
											</TD>
										</TR>
										<TR>
											<!-- Saldophone -->
											<TD>
												<xsl:value-of select="SG3/COM/C076/D_3148/@Desc[../../D_3155/@Value='SA' and //SG3/NAD/D_3035/@Value='HN']"/>
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</TD>
											<TD>
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</TD>
											<TD>
												<xsl:value-of select="SG3/COM/C076/D_3148[../D_3155/@Value='SA' and //SG3/NAD/D_3035/@Value='HN']"/>
											</TD>
										</TR>
									</TABLE>
									<!-- Internet -->
									<xsl:value-of select="SG3/COM/C076/D_3148[../D_3155/@Value='IN' and //SG3/NAD/D_3035/@Value='HN']"/>
								</td>
							</b>
							<!-- PostFinance Operations Center (removed w/P1433) -->
							<td colspan="4" nowrap="nowrap" height="68" align="left" class="Text8">
								<BR/>
								<BR/>
							</td>
						</TR>
						<!-- ////////////////// - Kontobezeichnungs- und Adresszeilen - ///////////////// -->
						<tr class="Text10">
							<!-- Kontobezeichnung -->
							<td colspan="3" nowrap="nowrap" height="113">
								<xsl:choose>
									<xsl:when test="SG3/NAD/C058/D_3124[../../D_3035/@Value='HQ'] != 0">
										<b>
											<xsl:value-of select="SG3/NAD/C058/D_3124/@Desc[../../../D_3035/@Value='HQ' and position() = 1]"/>
										</b>
										<BR/>
										<xsl:for-each select="SG3/NAD/C058/D_3124[../../D_3035/@Value='HQ']">
											<xsl:value-of select="."/>
											<BR/>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise/>
								</xsl:choose>
							</td>
							<!-- Kontobesitzter -->
							<td colspan="4" nowrap="nowrap" height="113" align="left">
								<xsl:for-each select="SG3/NAD/C058/D_3124[../../D_3035/@Value='HL']">
									<xsl:value-of select="."/>
									<BR/>
								</xsl:for-each>
							</td>
						</tr>
						<!-- //////////////////////////// - Werbetextzeilen - /////////////////////////// -->
						<tr class="Text10">
							<td colspan="7" height="91">
								<xsl:choose>
									<xsl:when test="PF:FTX/C108/D_4440[../../D_4451/@Value = 'AAI'] != 0">
										<xsl:for-each select="PF:FTX/C108/D_4440[../../D_4451/@Value = 'AAI']">
											<xsl:value-of select="."/>
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<!-- ////////////////////////////// - Titelzeile - ////////////////////////////// -->
						<tr>
							<!--Account Name Cell-->
							<td colspan="3" nowrap="nowrap" height="30" class="Text14">
								<b>
									<xsl:choose>
										<xsl:when test="contains(SG2/FII/PF:D_5388,'^')">
											<xsl:value-of select="substring-before(SG2/FII/PF:D_5388,'^')"/>
											<BR/>
											<xsl:value-of select="substring-after(SG2/FII/PF:D_5388,'^')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="SG2/FII/PF:D_5388"/>
										</xsl:otherwise>
									</xsl:choose>
								</b>
							</td>
							<!--Account Print Date Cell-->
							<td colspan="4" nowrap="nowrap" height="30" class="Text10">
								<xsl:value-of select="DTM/C507/D_2380/@Desc[../../D_2005/@Value = '202']"/>
								<xsl:text disable-output-escaping="yes">:&amp;nbsp;</xsl:text>
								<xsl:call-template name="PrintDate">
									<xsl:with-param name="Date" select="DTM/C507/D_2380[../D_2005/@Value = '202']"/>
									<xsl:with-param name="Format" select="0"/>
								</xsl:call-template>
							</td>
						</tr>
						<!-- /////////////////////// - Kontoinformationszeile 1 - /////////////////////// -->
						<tr>
							<!--Account Statement Period Cell-->
							<td colspan="3" nowrap="nowrap" valign="top">
								<b>
									<!-- Todo + Tages Auszug ausfiltern -->
									<xsl:value-of select="DTM/C507/D_2380/@Desc[../../D_2005/@Value = '194']"/>
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									<xsl:choose>
										<xsl:when test="DTM/C507/D_2380[../D_2005/@Value = '206'] != DTM/C507/D_2380[../D_2005/@Value = '194']">
											<xsl:call-template name="PrintDateFromTo">
												<xsl:with-param name="FDate" select="DTM/C507/D_2380[../D_2005/@Value = '194']"/>
												<xsl:with-param name="TDate" select="DTM/C507/D_2380[../D_2005/@Value = '206']"/>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="PrintDate">
												<xsl:with-param name="Date" select="DTM/C507/D_2380[../D_2005/@Value = '194']"/>
												<xsl:with-param name="Format" select="0"/>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</b>
							</td>
							<!--Account Cell-->
							<td colspan="2" nowrap="nowrap" valign="top">
								<b>
									<xsl:value-of select="SG2/FII/C078/D_3194/@Desc"/>
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									<xsl:call-template name="PrintAccount">
										<xsl:with-param name="Account" select="SG2/FII/C078/D_3194"/>
									</xsl:call-template>
								</b>
							</td>
							<!--Amount Cell-->
							<td nowrap="nowrap" align="right" valign="top">
								<b>
									<xsl:value-of select="SG2/FII/C078/D_6345/@Value"/>
								</b>
							</td>
							<!--Empty Cell-->
							<td align="right" nowrap="nowrap">
								<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
							</td>
						</tr>
						<!-- /////////////////////// - Kontoinformationszeile 2 (IBAN) -  /////////////// -->
						<tr>
							<!--Empty space-->
							<td colspan="3" nowrap="nowrap" height="10" valign="top">
							</td>
							<!--IBAN Cell-->
							<td colspan="4" nowrap="nowrap" height="10" valign="top">
								<xsl:value-of select="SG2/FII/C078/D_3192/@Desc"/>
								<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								<xsl:call-template name="PrintIBAN">
									<xsl:with-param name="IBAN" select="SG2/FII/C078/D_3192"/>
								</xsl:call-template>
							</td>
						</tr>
						<!-- /////////////////////// - Kontoinformationszeile 3 (BIC) -  /////////////// -->
						<tr>
							<!--Empty space-->
							<td colspan="3" nowrap="nowrap" height="30" valign="top">
							</td>
							<!--BIC Cell-->
							<td colspan="4" nowrap="nowrap" height="30" valign="top">
								<xsl:value-of select="SG2/FII/C078/D_3193/@Desc"/>
								<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								<xsl:call-template name="PrintBIC">
									<xsl:with-param name="BIC" select="SG2/FII/C078/D_3193"/>
								</xsl:call-template>
							</td>
						</tr>
						<!-- //////////////////////// - Detailueberschriftenzeile - ///////////////////// -->
						<tr>
							<!--Datum-->
							<td align="left" nowrap="nowrap" height="26">
								<xsl:value-of select="PF:FTX/C108/D_4440[../../D_4451/@Value = 'T26']"/>
							</td>
							<!--Text-->
							<td align="left" nowrap="nowrap" height="26">
								<xsl:value-of select="PF:FTX/C108/D_4440[../../D_4451/@Value = 'T27']"/>
							</td>
							<!--Gutschrift-->
							<td align="right" nowrap="nowrap" height="26">
								<xsl:value-of select="PF:FTX/C108/D_4440[../../D_4451/@Value = 'T28']"/>
							</td>
							<!--Lastschrift-->
							<td align="right" nowrap="nowrap" height="26">
								<xsl:value-of select="PF:FTX/C108/D_4440[../../D_4451/@Value = 'T29']"/>
							</td>
							<!--Valuta-->
							<td align="right" nowrap="nowrap" height="26">
								<xsl:value-of select="PF:FTX/C108/D_4440[../../D_4451/@Value = 'T30']"/>
							</td>
							<!--Saldo-->
							<td align="right" nowrap="nowrap" height="26">
								<xsl:value-of select="PF:FTX/C108/D_4440[../../D_4451/@Value = 'T31']"/>
							</td>
							<!--Detail (Lupe)-->
							<td align="right" nowrap="nowrap" height="26">
								<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
							</td>
						</tr>
						<!-- //////////////////////////// - Buchungszeilen - //////////////////////////// -->
						<xsl:for-each select="SG4">
							<xsl:choose>
								<!--First Transaktion in Annoucment-->
								<xsl:when test="LIN[PF:D_0805/@Value = 'LST']">
									<tr>
										<!--Datum-->
										<td align="left" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDate">
												<xsl:with-param name="Date" select="SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
												<xsl:with-param name="Format" select="2"/>
											</xsl:call-template>
										</td>
										<!--Text-->
										<td align="left" nowrap="nowrap" valign="top">
											<xsl:value-of select="FTX/C108/D_4440"/>
											<BR/>
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Gutschrift /  Lastschrift / Valuta -->
										<td nowrap="nowrap" colspan="3">
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Saldo-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG5/MOA/C516/D_5004[../D_5025/@Value = '315']"/>
												<xsl:with-param name="Signet" select="SG5/MOA/PF:D_5003"/>
											</xsl:call-template>
										</td>
										<!--Detail (Lupe)-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
									</tr>
								</xsl:when>
								<!--Last Transaktion in Annoucment-->
								<xsl:when test="LIN[PF:D_0805/@Value = 'LEN']">
									<tr>
										<!--Datum-->
										<td align="left" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDate">
												<xsl:with-param name="Date" select="SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
												<xsl:with-param name="Format" select="2"/>
											</xsl:call-template>
										</td>
										<!--Text -->
										<td align="left" valign="top">
											<xsl:value-of select="FTX/C108/D_4440"/>
											<BR/>
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Gutschrift /  Lastschrift / Valuta -->
										<td nowrap="nowrap" colspan="3">
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Saldo-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG5/MOA/C516/D_5004[../D_5025/@Value = '343']"/>
												<xsl:with-param name="Signet" select="SG5/MOA/PF:D_5003"/>
											</xsl:call-template>
										</td>
										<!--Detail (Lupe)-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
									</tr>
								</xsl:when>
								<!--Single Transaktion-->
								<xsl:when test="LIN[PF:D_0805/@Value = 'LNE']">
									<tr>
										<!--Datum-->
										<td align="left" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDate">
												<xsl:with-param name="Date" select="SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
												<xsl:with-param name="Format" select="2"/>
												<xsl:with-param name="PrevDate" select="preceding::SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
											</xsl:call-template>
										</td>
										<!--Text  -->
										<td align="left" valign="top">
											<xsl:for-each select="SG6/FTX/C108/D_4440[../../D_4451/@Value = 'ABN']">
												<xsl:value-of select="."/>
												<BR/>
											</xsl:for-each>
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Gutschrift-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG6/MOA/C516/D_5004[../D_5025/@Value = '210']"/>
												<xsl:with-param name="Signet" select="SG6/MOA/PF:D_5003[../C516/D_5025/@Value = '210']"/>
											</xsl:call-template>
										</td>
										<!--Lastschrift-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG6/MOA/C516/D_5004[../D_5025/@Value = '211']"/>
												<xsl:with-param name="Signet" select="SG6/MOA/PF:D_5003[../C516/D_5025/@Value = '211']"/>
											</xsl:call-template>
										</td>
										<!--Valuta -->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDate">
												<xsl:with-param name="Date" select="SG6/DTM/C507/D_2380[../D_2005/@Value = '209']"/>
												<xsl:with-param name="Format" select="2"/>
											</xsl:call-template>
										</td>
										<!--Saldo-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG5/MOA/C516/D_5004[../D_5025/@Value = '15']"/>
												<xsl:with-param name="Signet" select="SG5/MOA/PF:D_5003"/>
												<xsl:with-param name="Date" select="SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
												<xsl:with-param name="FollowDate" select="following::SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
											</xsl:call-template>
										</td>
										<!--Detail (Lupe)-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDetail">
												<xsl:with-param name="ImgRef" select="SG6/RFF/C506/D_1154[../D_1153/@Value = 'ZZZ']"/>
											</xsl:call-template>
										</td>
									</tr>
								</xsl:when>
								<!--Transaktion Collection-->
								<xsl:when test="LIN[PF:D_0805/@Value = 'LNS']">
									<tr>
										<!--Datum-->
										<td align="left" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDate">
												<xsl:with-param name="Date" select="SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
												<xsl:with-param name="Format" select="2"/>
												<xsl:with-param name="PrevDate" select="preceding::SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
											</xsl:call-template>
										</td>
										<!--Text -->
										<td align="left" valign="top">
											<xsl:for-each select="FTX/C108/D_4440[../../D_4453/@Value = '5']">
												<xsl:value-of select="."/>
												<BR/>
											</xsl:for-each>
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Gutschrift / Lastschrift / Valuta / Amount-->
										<td align="right" nowrap="nowrap" valign="top" colspan="4">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG6/MOA/C516/D_5004[../D_5025/@Value = '210']"/>
												<xsl:with-param name="Signet" select="SG6/MOA/PF:D_5003[../C516/D_5025/@Value = '210']"/>
											</xsl:call-template>
										</td>
										<!--Detail (Lupe)-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDetail">
												<xsl:with-param name="ImgRef" select="SG6/RFF/C506/D_1154[../D_1153/@Value = 'ZZZ']"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:for-each select="SG6">
										<tr>
											<!--Datum-->
											<td align="left" nowrap="nowrap" valign="top">
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</td>
											<!--Text -->
											<td align="left" valign="top">
												<xsl:for-each select="FTX/C108/D_4440[../../D_4451/@Value = 'ABN']">
													<xsl:value-of select="."/>
													<BR/>
												</xsl:for-each>
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</td>
											<!--Gutschrift-->
											<td align="right" nowrap="nowrap" valign="top">
												<xsl:call-template name="PrintAmount">
													<xsl:with-param name="Amount" select="MOA/C516/D_5004[../D_5025/@Value = '210']"/>
													<xsl:with-param name="Signet" select="MOA/PF:D_5003[../C516/D_5025/@Value = '210']"/>
												</xsl:call-template>
											</td>
											<!--Lastschrift-->
											<td align="right" nowrap="nowrap" valign="top">
												<xsl:call-template name="PrintAmount">
													<xsl:with-param name="Amount" select="MOA/C516/D_5004[../D_5025/@Value = '211']"/>
													<xsl:with-param name="Signet" select="MOA/PF:D_5003[../C516/D_5025/@Value = '211']"/>
												</xsl:call-template>
											</td>
											<!--Valuta -->
											<td align="right" nowrap="nowrap" valign="top">
												<xsl:call-template name="PrintDate">
													<xsl:with-param name="Date" select="DTM/C507/D_2380[../D_2005/@Value = '209']"/>
													<xsl:with-param name="Format" select="2"/>
												</xsl:call-template>
											</td>
											<!--Saldo-->
											<td align="right" nowrap="nowrap" valign="top">
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</td>
											<!--Detail (Lupe)-->
											<td align="right" nowrap="nowrap" valign="top">
												<xsl:call-template name="PrintDetail">
													<xsl:with-param name="ImgRef" select="SG6/RFF/C506/D_1154[../D_1153/@Value = 'ZZZ']"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
									<xsl:if test="string-length(FTX/C108/D_4440[../../D_4453/@Value = '8'] ) != '0'">
										<tr>
											<!--Datum-->
											<td align="left" nowrap="nowrap" height="26" valign="top">
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</td>
											<!--Text   -->
											<td align="left" height="26" valign="top">
												<xsl:value-of select="FTX/C108/D_4440[../../D_4453/@Value = '8']"/>
											</td>
											<!--Gutschrift /  Lastschrift / Valuta -->
											<td nowrap="nowrap" colspan="3">
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</td>
											<!--Saldo-->
											<td align="right" nowrap="nowrap" height="26" valign="top">
												<xsl:call-template name="PrintAmount">
													<xsl:with-param name="Amount" select="SG5/MOA/C516/D_5004[../D_5025/@Value = '15']"/>
													<xsl:with-param name="Signet" select="SG5/MOA/PF:D_5003"/>
													<xsl:with-param name="Date" select="SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
													<xsl:with-param name="FollowDate" select="following::SG5/DTM/C507/D_2380[../D_2005/@Value = '202']"/>
												</xsl:call-template>
											</td>
											<!--Detail (Lupe)-->
											<td align="right" nowrap="nowrap" height="26" valign="top">
												<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
											</td>
										</tr>
									</xsl:if>
								</xsl:when>
								<!--Summary Transaction-->
								<xsl:when test="LIN[PF:D_0805/@Value = 'LTI']">
									<tr>
										<!--Datum-->
										<td align="left" nowrap="nowrap" valign="top">
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Text -->
										<td align="left" valign="top">
											<xsl:for-each select="./FTX/C108/D_4440">
												<xsl:value-of select="."/>
												<BR/>
											</xsl:for-each>
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Gutschrift-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG6/MOA/C516/D_5004[../D_5025/@Value = '210']"/>
												<xsl:with-param name="Signet" select="SG6/MOA/PF:D_5003[../C516/D_5025/@Value = '210']"/>
											</xsl:call-template>
										</td>
										<!--Lastschrift-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintAmount">
												<xsl:with-param name="Amount" select="SG6/MOA/C516/D_5004[../D_5025/@Value = '211']"/>
												<xsl:with-param name="Signet" select="SG6/MOA/PF:D_5003[../C516/D_5025/@Value = '211']"/>
											</xsl:call-template>
										</td>
										<!--Valuta -->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Saldo-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
										</td>
										<!--Detail (Lupe)-->
										<td align="right" nowrap="nowrap" valign="top">
											<xsl:call-template name="PrintDetail">
												<xsl:with-param name="ImgRef" select="SG6/RFF/C506/D_1154[../D_1153/@Value = 'ZZZ']"/>
											</xsl:call-template>
										</td>
									</tr>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
						<!-- //////////////////////////// - Abschlusstextzeilen - /////////////////////// -->
						<!-- Leerzeile -->
						<tr class="Text10">
							<td colspan="7">
									<BR/>
							</td>
						</tr>
						<!-- Ueberprfungshinweis -->
						<xsl:for-each select="../IC_TRAILER/ICINFO">
							<tr class="Text10">
								<td colspan="7">
									<BR/>
									<xsl:value-of select="."/>
								</td>
							</tr>
						</xsl:for-each>
						<!-- Leerzeile -->
						<tr class="Text10">
							<td colspan="7">
									<BR/>
							</td>
						</tr>
						<!-- Grusszeilen -->
						<xsl:for-each select="../IC_TRAILER/ICGRUSS">
							<tr class="Text10">
								<td colspan="7">
										<xsl:value-of select="."/>
										<BR/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</body>
			</HTML>
		</xsl:for-each>
	</xsl:template>
	<!-- ******************************************** Tools/Functions ********************************************* -->
	<xsl:template name="PrintDate">
		<xsl:param name="Date"/>
		<xsl:param name="Format">0</xsl:param>
		<xsl:param name="PrevDate">0</xsl:param>
		<xsl:choose>
			<xsl:when test="not($PrevDate = $Date) and  $Date != '' ">
				<!-- interne Format definitionen -->
				<xsl:variable name="DezimalMark">.</xsl:variable>
				<xsl:variable name="InputFormat">
					<xsl:choose>
						<xsl:when test="string-length($Date) = '8'">abcdefgh.</xsl:when>
						<xsl:otherwise>abcdefghijkl.</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="OutputFormat">
					<xsl:choose>
						<xsl:when test="$Format = '0'">gh.ef.abcd</xsl:when>
						<xsl:when test="$Format = '1'">gh.</xsl:when>
						<xsl:when test="$Format = '2'">gh.ef.cd</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="TempDate" select="concat($Date,$DezimalMark)"/>
				<xsl:value-of select="translate($OutputFormat,$InputFormat,$TempDate)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="PrintAccount">
		<xsl:param name="Account"/>
		<xsl:choose>
			<xsl:when test="$Account != ''">
				<xsl:variable name="InputFormat">abcdefghi</xsl:variable>
				<xsl:variable name="CheckamtCode" select="translate('ab',$InputFormat,$Account)"/>
				<xsl:variable name="Ordnungsnummer" select="number(translate('cdefgh',$InputFormat,$Account))"/>
				<xsl:variable name="Pruefziffer" select="translate('i',$InputFormat,$Account)"/>
				<xsl:variable name="NewAccount">
					<xsl:choose>
						<xsl:when test="$CheckamtCode = '0'">
							<xsl:value-of select="concat($Ordnungsnummer,$Pruefziffer)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($CheckamtCode,'-',$Ordnungsnummer,'-',$Pruefziffer)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:value-of select="$NewAccount"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="PrintAmount">
		<xsl:param name="Amount"/>
		<xsl:param name="Signet">+</xsl:param>
		<xsl:param name="Date">0</xsl:param>
		<xsl:param name="FollowDate">1</xsl:param>
		<xsl:choose>
			<xsl:when test="$Amount != '' and not($Date = $FollowDate)">
				<xsl:if test="$Signet = '-'">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
					<xsl:value-of select="$Signet"/>
				</xsl:if>
				<xsl:value-of select="translate( format-number($Amount,'###,###,###,###,##0.00'), ','  , ' '  )"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="PrintBIC">
		<xsl:param name="BIC"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="$BIC"/>
	</xsl:template>
	<xsl:template name="PrintDetail">
		<xsl:param name="ImgRef"/>
		<xsl:choose>
			<xsl:when test="string-length($ImgRef) != '0'">
				<A>
					<xsl:attribute name="href"><xsl:value-of select="concat($ImgRef,'.png')"/></xsl:attribute>
					<IMG src="lupe.gif" alt="" height="13" border="0"/>
				</A>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="PrintIBAN">
		<xsl:param name="IBAN"/>
		<xsl:variable name="TempIBAN" select="translate ($IBAN,' ','')"/>
		<xsl:value-of select="substring($TempIBAN,1,4)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempIBAN,5,4)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempIBAN,9,4)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempIBAN,13,4)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempIBAN,17,4)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempIBAN,21,1)"/>
	</xsl:template>
	<xsl:template name="PrintPhone">
		<xsl:param name="Number"/>
		<xsl:variable name="TempNumber" select="translate ($Number,' ','')"/>
		<xsl:value-of select="substring($TempNumber,1,3)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempNumber,4,3)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempNumber,7,2)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		<xsl:value-of select="substring($TempNumber,9,2)"/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</xsl:template>
	<xsl:template name="PrintDateFromTo">
		<xsl:param name="FDate"/>
		<xsl:param name="TDate"/>
		<xsl:variable name="FInput">
			<xsl:choose>
				<xsl:when test="string-length($FDate) = '8'">abcdefgh.</xsl:when>
				<xsl:otherwise>abcdefghijkl.</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="TInput">
			<xsl:choose>
				<xsl:when test="string-length($TDate) = '8'">abcdefgh.</xsl:when>
				<xsl:otherwise>abcdefghijkl.</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="FDay" select="translate('gh',$FInput,concat($FDate,'.'))"/>
		<xsl:variable name="FMonth" select="translate('ef',$FInput,concat($FDate,'.'))"/>
		<xsl:variable name="FYear" select="translate('abcd',$FInput,concat($FDate,'.'))"/>
		<xsl:variable name="TDay" select="translate('gh',$FInput,concat($TDate,'.'))"/>
		<xsl:variable name="TMonth" select="translate('ef',$FInput,concat($TDate,'.'))"/>
		<xsl:variable name="TYear" select="translate('abcd',$FInput,concat($TDate,'.'))"/>
		<!-- Output -->
		<xsl:value-of select="$FDay"/>.<xsl:choose>
			<xsl:when test="$FYear != $TYear">
				<xsl:value-of select="$FMonth"/>.<xsl:value-of select="$FYear"/>
			</xsl:when>
			<xsl:when test="$FMonth != $TMonth">
				<xsl:value-of select="$FMonth"/>.</xsl:when>
		</xsl:choose>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;-&amp;nbsp;</xsl:text>
		<xsl:value-of select="$TDay"/>.<xsl:value-of select="$TMonth"/>.<xsl:value-of select="$TYear"/>
	</xsl:template>
	<xsl:template name="PrintSender">
		<xsl:param name="Sender"/>
		<xsl:variable name="TempSender" select="translate ($Sender,' ','')"/>
		<xsl:value-of select="substring($TempSender,1,11)"/>
	</xsl:template>
	<xsl:decimal-format name="decform" decimal-separator="." grouping-separator="'"/>
</xsl:stylesheet>
