# Copyright 2015 Laurent Mignon Acsone SA/NV (http://www.acsone.eu)
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).
MULTIPOLYGON_1 = """
     MULTIPOLYGON (((726469.938970306 5873145.03456248,
                     726520.174105436 5872946.03059195,
                     726394.076006275 5872675.04267336,
                     726404.709252018 5872259.98652277,
                     726212.557712441 5871801.78900894,
                     726471.645243121 5871748.01187117,
                     726384.798016214 5871474.60597039,
                     726524.862821204 5871416.52279756,
                     726560.408193573 5870936.9668625,
                     726765.583679957 5870941.58021817,
                     726800.675791552 5870794.8818083,
                     726830.398385972 5870610.25496982,
                     726667.324961485 5870525.33567258,
                     726559.158856422 5870713.41380138,
                     726483.618814776 5870842.15916191,
                     726282.880000044 5870874.76667995,
                     726075.942331799 5870940.79690473,
                     726060.620082161 5870636.20922038,
                     725995.373875086 5870504.36168216,
                     725871.917698916 5870508.73664946,
                     725866.910956205 5870440.22483982,
                     725760.074408205 5870513.2465806,
                     724947.130321146 5870506.55170525,
                     724956.64886783 5870684.35364044,
                     724709.437725183 5870717.82930599,
                     724640.837901402 5870502.91208435,
                     723632.716917063 5871035.58668793,
                     723353.587063504 5870580.71145654,
                     722975.340414945 5870644.60022452,
                     723063.193608096 5871187.48904965,
                     723286.565782157 5871691.25884814,
                     722865.254617585 5871951.28387527,
                     722963.962738856 5872074.84140304,
                     722831.245902295 5872122.76389775,
                     722813.837916803 5872242.00526964,
                     722827.655983236 5872300.44254147,
                     722913.370119188 5872418.02105384,
                     722942.233783707 5872432.93796481,
                     722984.741992683 5872520.85895895,
                     723012.381471722 5872637.73702376,
                     723086.082443995 5872667.76380156,
                     723157.229378648 5872668.62290333,
                     723214.748202491 5872698.34771906,
                     723250.508284339 5872761.5280976,
                     723286.16249158 5872815.86084868,
                     723315.028102666 5872830.77719621,
                     723502.328395902 5872819.6206505,
                     723518.483057357 5872818.65863173,
                     723567.82777813 5872844.15493286,
                     723749.413939088 5872937.98130854,
                     723848.429817139 5873019.41326079,
                     723893.228455684 5873056.25562596,
                     724000.782399525 5873179.05937195,
                     724022.179653074 5873203.48913931,
                     724167.213521721 5873219.79321866,
                     724240.443943894 5873257.62460164,
                     724345.033870514 5873311.65740904,
                     724427.033053176 5873354.0176493,
                     724458.116953997 5873354.38826826,
                     724601.342527281 5873356.09453768,
                     724659.368258544 5873356.78513641,
                     724699.259216658 5873263.86039926,
                     724734.038257937 5873182.84407915,
                     724769.196071982 5873148.4004069,
                     724792.808935311 5873125.2670227,
                     724828.594968331 5873107.84535952,
                     724909.660761314 5873068.37954232,
                     724968.429515518 5873010.80204763,
                     724969.116329931 5872952.53572905,
                     725027.883915669 5872894.95858978,
                     725144.902548535 5872823.50310579,
                     725202.982873244 5872824.19072548,
                     725231.165281494 5872845.9215328,
                     725260.549561619 5872868.5770444,
                     725323.492507265 5872998.67536266,
                     725345.617620278 5873044.40573114,
                     725374.316461685 5873073.88235996,
                     725461.097697554 5873104.044911,
                     725548.221016413 5873105.07306152,
                     725593.723206956 5873117.05713947,
                     725633.818030441 5873127.61507632,
                     725664.044374598 5873135.57621915,
                     725715.023293758 5873205.45921561,
                     725835.567474206 5873370.70034401,
                     725849.407491127 5873429.14029691,
                     725878.279489341 5873444.04917682,
                     725936.874293492 5873401.02996477,
                     725995.978527806 5873314.30901098,
                     726070.62161125 5873140.35732493,
                     726085.312084189 5873125.96087534,
                     726100.002508819 5873111.56442448,
                     726217.015284978 5873040.09276485,
                     726304.138055426 5873041.11333845,
                     726469.938970306 5873145.03456248)))"""

GEOLINE_1 = """
     LINESTRING (726469.938970306 5873145.03456248,
                 726520.174105436 5872946.03059195,
                 726394.076006275 5872675.04267336)"""

GEO_VIEW = {
    "geoengine_layers": {
        "actives": [],
        "backgrounds": [],
        "default_extent": "-123164.85222423, 5574694.9538936,"
        " 1578017.6490538, 6186191.1800898",
        "default_zoom": 0,
        "projection": "EPSG:3857",
        "restricted_extent": False,
    },
    "model": "test.dummy",
    "name": "test.dummy.geo_view",
    "type": "geoengine",
}

FORM_VIEW = {
    "fields": {
        "geo_multipolygon": {
            "geo_type": {"dim": 2, "srid": 3857, "type": "geo_multi_polygon"},
            "required": False,
            "searchable": True,
            "sortable": True,
            "store": True,
            "string": "Geo Multipolygon",
            "type": "geo_multi_polygon",
        }
    },
    "model": "test.dummy",
    "name": "test.dummy.form_view",
    "type": "form",
}

EXPECTED_GEO_COLUMN_MULTIPOLYGON = {
    "default_extent": "-123164.85222423, 5574694.9538936, "
    "1578017.6490538, 6186191.1800898",
    "geo_type": "MULTIPOLYGON",
    "srid": 3857,
}
