/**
 * vis-timeline and vis-graph2d
 * https://visjs.github.io/vis-timeline/
 *
 * Create a fully customizable, interactive timeline with items and ranges.
 *
 * @version 7.7.0
 * @date    2022-07-10T21:34:08.601Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */

(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.vis = global.vis || {}));
})(this, (function (exports) {
	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function commonjsRequire(path) {
		throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
	}

	var moment$3 = {exports: {}};

	var hasRequiredMoment;

	function requireMoment() {
	  if (hasRequiredMoment) return moment$3.exports;
	  hasRequiredMoment = 1;

	  (function (module, exports) {

	    (function (global, factory) {
	      module.exports = factory() ;
	    })(commonjsGlobal, function () {

	      var hookCallback;

	      function hooks() {
	        return hookCallback.apply(null, arguments);
	      } // This is done to register the method called with moment()
	      // without creating circular dependencies.


	      function setHookCallback(callback) {
	        hookCallback = callback;
	      }

	      function isArray(input) {
	        return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
	      }

	      function isObject(input) {
	        // IE8 will treat undefined and null as object if it wasn't for
	        // input != null
	        return input != null && Object.prototype.toString.call(input) === '[object Object]';
	      }

	      function hasOwnProp(a, b) {
	        return Object.prototype.hasOwnProperty.call(a, b);
	      }

	      function isObjectEmpty(obj) {
	        if (Object.getOwnPropertyNames) {
	          return Object.getOwnPropertyNames(obj).length === 0;
	        } else {
	          var k;

	          for (k in obj) {
	            if (hasOwnProp(obj, k)) {
	              return false;
	            }
	          }

	          return true;
	        }
	      }

	      function isUndefined(input) {
	        return input === void 0;
	      }

	      function isNumber(input) {
	        return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
	      }

	      function isDate(input) {
	        return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
	      }

	      function map(arr, fn) {
	        var res = [],
	            i,
	            arrLen = arr.length;

	        for (i = 0; i < arrLen; ++i) {
	          res.push(fn(arr[i], i));
	        }

	        return res;
	      }

	      function extend(a, b) {
	        for (var i in b) {
	          if (hasOwnProp(b, i)) {
	            a[i] = b[i];
	          }
	        }

	        if (hasOwnProp(b, 'toString')) {
	          a.toString = b.toString;
	        }

	        if (hasOwnProp(b, 'valueOf')) {
	          a.valueOf = b.valueOf;
	        }

	        return a;
	      }

	      function createUTC(input, format, locale, strict) {
	        return createLocalOrUTC(input, format, locale, strict, true).utc();
	      }

	      function defaultParsingFlags() {
	        // We need to deep clone this object.
	        return {
	          empty: false,
	          unusedTokens: [],
	          unusedInput: [],
	          overflow: -2,
	          charsLeftOver: 0,
	          nullInput: false,
	          invalidEra: null,
	          invalidMonth: null,
	          invalidFormat: false,
	          userInvalidated: false,
	          iso: false,
	          parsedDateParts: [],
	          era: null,
	          meridiem: null,
	          rfc2822: false,
	          weekdayMismatch: false
	        };
	      }

	      function getParsingFlags(m) {
	        if (m._pf == null) {
	          m._pf = defaultParsingFlags();
	        }

	        return m._pf;
	      }

	      var some;

	      if (Array.prototype.some) {
	        some = Array.prototype.some;
	      } else {
	        some = function (fun) {
	          var t = Object(this),
	              len = t.length >>> 0,
	              i;

	          for (i = 0; i < len; i++) {
	            if (i in t && fun.call(this, t[i], i, t)) {
	              return true;
	            }
	          }

	          return false;
	        };
	      }

	      function isValid(m) {
	        if (m._isValid == null) {
	          var flags = getParsingFlags(m),
	              parsedParts = some.call(flags.parsedDateParts, function (i) {
	            return i != null;
	          }),
	              isNowValid = !isNaN(m._d.getTime()) && flags.overflow < 0 && !flags.empty && !flags.invalidEra && !flags.invalidMonth && !flags.invalidWeekday && !flags.weekdayMismatch && !flags.nullInput && !flags.invalidFormat && !flags.userInvalidated && (!flags.meridiem || flags.meridiem && parsedParts);

	          if (m._strict) {
	            isNowValid = isNowValid && flags.charsLeftOver === 0 && flags.unusedTokens.length === 0 && flags.bigHour === undefined;
	          }

	          if (Object.isFrozen == null || !Object.isFrozen(m)) {
	            m._isValid = isNowValid;
	          } else {
	            return isNowValid;
	          }
	        }

	        return m._isValid;
	      }

	      function createInvalid(flags) {
	        var m = createUTC(NaN);

	        if (flags != null) {
	          extend(getParsingFlags(m), flags);
	        } else {
	          getParsingFlags(m).userInvalidated = true;
	        }

	        return m;
	      } // Plugins that add properties should also add the key here (null value),
	      // so we can properly clone ourselves.


	      var momentProperties = hooks.momentProperties = [],
	          updateInProgress = false;

	      function copyConfig(to, from) {
	        var i,
	            prop,
	            val,
	            momentPropertiesLen = momentProperties.length;

	        if (!isUndefined(from._isAMomentObject)) {
	          to._isAMomentObject = from._isAMomentObject;
	        }

	        if (!isUndefined(from._i)) {
	          to._i = from._i;
	        }

	        if (!isUndefined(from._f)) {
	          to._f = from._f;
	        }

	        if (!isUndefined(from._l)) {
	          to._l = from._l;
	        }

	        if (!isUndefined(from._strict)) {
	          to._strict = from._strict;
	        }

	        if (!isUndefined(from._tzm)) {
	          to._tzm = from._tzm;
	        }

	        if (!isUndefined(from._isUTC)) {
	          to._isUTC = from._isUTC;
	        }

	        if (!isUndefined(from._offset)) {
	          to._offset = from._offset;
	        }

	        if (!isUndefined(from._pf)) {
	          to._pf = getParsingFlags(from);
	        }

	        if (!isUndefined(from._locale)) {
	          to._locale = from._locale;
	        }

	        if (momentPropertiesLen > 0) {
	          for (i = 0; i < momentPropertiesLen; i++) {
	            prop = momentProperties[i];
	            val = from[prop];

	            if (!isUndefined(val)) {
	              to[prop] = val;
	            }
	          }
	        }

	        return to;
	      } // Moment prototype object


	      function Moment(config) {
	        copyConfig(this, config);
	        this._d = new Date(config._d != null ? config._d.getTime() : NaN);

	        if (!this.isValid()) {
	          this._d = new Date(NaN);
	        } // Prevent infinite loop in case updateOffset creates new moment
	        // objects.


	        if (updateInProgress === false) {
	          updateInProgress = true;
	          hooks.updateOffset(this);
	          updateInProgress = false;
	        }
	      }

	      function isMoment(obj) {
	        return obj instanceof Moment || obj != null && obj._isAMomentObject != null;
	      }

	      function warn(msg) {
	        if (hooks.suppressDeprecationWarnings === false && typeof console !== 'undefined' && console.warn) {
	          console.warn('Deprecation warning: ' + msg);
	        }
	      }

	      function deprecate(msg, fn) {
	        var firstTime = true;
	        return extend(function () {
	          if (hooks.deprecationHandler != null) {
	            hooks.deprecationHandler(null, msg);
	          }

	          if (firstTime) {
	            var args = [],
	                arg,
	                i,
	                key,
	                argLen = arguments.length;

	            for (i = 0; i < argLen; i++) {
	              arg = '';

	              if (typeof arguments[i] === 'object') {
	                arg += '\n[' + i + '] ';

	                for (key in arguments[0]) {
	                  if (hasOwnProp(arguments[0], key)) {
	                    arg += key + ': ' + arguments[0][key] + ', ';
	                  }
	                }

	                arg = arg.slice(0, -2); // Remove trailing comma and space
	              } else {
	                arg = arguments[i];
	              }

	              args.push(arg);
	            }

	            warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + new Error().stack);
	            firstTime = false;
	          }

	          return fn.apply(this, arguments);
	        }, fn);
	      }

	      var deprecations = {};

	      function deprecateSimple(name, msg) {
	        if (hooks.deprecationHandler != null) {
	          hooks.deprecationHandler(name, msg);
	        }

	        if (!deprecations[name]) {
	          warn(msg);
	          deprecations[name] = true;
	        }
	      }

	      hooks.suppressDeprecationWarnings = false;
	      hooks.deprecationHandler = null;

	      function isFunction(input) {
	        return typeof Function !== 'undefined' && input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
	      }

	      function set(config) {
	        var prop, i;

	        for (i in config) {
	          if (hasOwnProp(config, i)) {
	            prop = config[i];

	            if (isFunction(prop)) {
	              this[i] = prop;
	            } else {
	              this['_' + i] = prop;
	            }
	          }
	        }

	        this._config = config; // Lenient ordinal parsing accepts just a number in addition to
	        // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
	        // TODO: Remove "ordinalParse" fallback in next major release.

	        this._dayOfMonthOrdinalParseLenient = new RegExp((this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) + '|' + /\d{1,2}/.source);
	      }

	      function mergeConfigs(parentConfig, childConfig) {
	        var res = extend({}, parentConfig),
	            prop;

	        for (prop in childConfig) {
	          if (hasOwnProp(childConfig, prop)) {
	            if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
	              res[prop] = {};
	              extend(res[prop], parentConfig[prop]);
	              extend(res[prop], childConfig[prop]);
	            } else if (childConfig[prop] != null) {
	              res[prop] = childConfig[prop];
	            } else {
	              delete res[prop];
	            }
	          }
	        }

	        for (prop in parentConfig) {
	          if (hasOwnProp(parentConfig, prop) && !hasOwnProp(childConfig, prop) && isObject(parentConfig[prop])) {
	            // make sure changes to properties don't modify parent config
	            res[prop] = extend({}, res[prop]);
	          }
	        }

	        return res;
	      }

	      function Locale(config) {
	        if (config != null) {
	          this.set(config);
	        }
	      }

	      var keys;

	      if (Object.keys) {
	        keys = Object.keys;
	      } else {
	        keys = function (obj) {
	          var i,
	              res = [];

	          for (i in obj) {
	            if (hasOwnProp(obj, i)) {
	              res.push(i);
	            }
	          }

	          return res;
	        };
	      }

	      var defaultCalendar = {
	        sameDay: '[Today at] LT',
	        nextDay: '[Tomorrow at] LT',
	        nextWeek: 'dddd [at] LT',
	        lastDay: '[Yesterday at] LT',
	        lastWeek: '[Last] dddd [at] LT',
	        sameElse: 'L'
	      };

	      function calendar(key, mom, now) {
	        var output = this._calendar[key] || this._calendar['sameElse'];
	        return isFunction(output) ? output.call(mom, now) : output;
	      }

	      function zeroFill(number, targetLength, forceSign) {
	        var absNumber = '' + Math.abs(number),
	            zerosToFill = targetLength - absNumber.length,
	            sign = number >= 0;
	        return (sign ? forceSign ? '+' : '' : '-') + Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
	      }

	      var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,
	          localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,
	          formatFunctions = {},
	          formatTokenFunctions = {}; // token:    'M'
	      // padded:   ['MM', 2]
	      // ordinal:  'Mo'
	      // callback: function () { this.month() + 1 }

	      function addFormatToken(token, padded, ordinal, callback) {
	        var func = callback;

	        if (typeof callback === 'string') {
	          func = function () {
	            return this[callback]();
	          };
	        }

	        if (token) {
	          formatTokenFunctions[token] = func;
	        }

	        if (padded) {
	          formatTokenFunctions[padded[0]] = function () {
	            return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
	          };
	        }

	        if (ordinal) {
	          formatTokenFunctions[ordinal] = function () {
	            return this.localeData().ordinal(func.apply(this, arguments), token);
	          };
	        }
	      }

	      function removeFormattingTokens(input) {
	        if (input.match(/\[[\s\S]/)) {
	          return input.replace(/^\[|\]$/g, '');
	        }

	        return input.replace(/\\/g, '');
	      }

	      function makeFormatFunction(format) {
	        var array = format.match(formattingTokens),
	            i,
	            length;

	        for (i = 0, length = array.length; i < length; i++) {
	          if (formatTokenFunctions[array[i]]) {
	            array[i] = formatTokenFunctions[array[i]];
	          } else {
	            array[i] = removeFormattingTokens(array[i]);
	          }
	        }

	        return function (mom) {
	          var output = '',
	              i;

	          for (i = 0; i < length; i++) {
	            output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];
	          }

	          return output;
	        };
	      } // format date using native date object


	      function formatMoment(m, format) {
	        if (!m.isValid()) {
	          return m.localeData().invalidDate();
	        }

	        format = expandFormat(format, m.localeData());
	        formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);
	        return formatFunctions[format](m);
	      }

	      function expandFormat(format, locale) {
	        var i = 5;

	        function replaceLongDateFormatTokens(input) {
	          return locale.longDateFormat(input) || input;
	        }

	        localFormattingTokens.lastIndex = 0;

	        while (i >= 0 && localFormattingTokens.test(format)) {
	          format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
	          localFormattingTokens.lastIndex = 0;
	          i -= 1;
	        }

	        return format;
	      }

	      var defaultLongDateFormat = {
	        LTS: 'h:mm:ss A',
	        LT: 'h:mm A',
	        L: 'MM/DD/YYYY',
	        LL: 'MMMM D, YYYY',
	        LLL: 'MMMM D, YYYY h:mm A',
	        LLLL: 'dddd, MMMM D, YYYY h:mm A'
	      };

	      function longDateFormat(key) {
	        var format = this._longDateFormat[key],
	            formatUpper = this._longDateFormat[key.toUpperCase()];

	        if (format || !formatUpper) {
	          return format;
	        }

	        this._longDateFormat[key] = formatUpper.match(formattingTokens).map(function (tok) {
	          if (tok === 'MMMM' || tok === 'MM' || tok === 'DD' || tok === 'dddd') {
	            return tok.slice(1);
	          }

	          return tok;
	        }).join('');
	        return this._longDateFormat[key];
	      }

	      var defaultInvalidDate = 'Invalid date';

	      function invalidDate() {
	        return this._invalidDate;
	      }

	      var defaultOrdinal = '%d',
	          defaultDayOfMonthOrdinalParse = /\d{1,2}/;

	      function ordinal(number) {
	        return this._ordinal.replace('%d', number);
	      }

	      var defaultRelativeTime = {
	        future: 'in %s',
	        past: '%s ago',
	        s: 'a few seconds',
	        ss: '%d seconds',
	        m: 'a minute',
	        mm: '%d minutes',
	        h: 'an hour',
	        hh: '%d hours',
	        d: 'a day',
	        dd: '%d days',
	        w: 'a week',
	        ww: '%d weeks',
	        M: 'a month',
	        MM: '%d months',
	        y: 'a year',
	        yy: '%d years'
	      };

	      function relativeTime(number, withoutSuffix, string, isFuture) {
	        var output = this._relativeTime[string];
	        return isFunction(output) ? output(number, withoutSuffix, string, isFuture) : output.replace(/%d/i, number);
	      }

	      function pastFuture(diff, output) {
	        var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
	        return isFunction(format) ? format(output) : format.replace(/%s/i, output);
	      }

	      var aliases = {};

	      function addUnitAlias(unit, shorthand) {
	        var lowerCase = unit.toLowerCase();
	        aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
	      }

	      function normalizeUnits(units) {
	        return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
	      }

	      function normalizeObjectUnits(inputObject) {
	        var normalizedInput = {},
	            normalizedProp,
	            prop;

	        for (prop in inputObject) {
	          if (hasOwnProp(inputObject, prop)) {
	            normalizedProp = normalizeUnits(prop);

	            if (normalizedProp) {
	              normalizedInput[normalizedProp] = inputObject[prop];
	            }
	          }
	        }

	        return normalizedInput;
	      }

	      var priorities = {};

	      function addUnitPriority(unit, priority) {
	        priorities[unit] = priority;
	      }

	      function getPrioritizedUnits(unitsObj) {
	        var units = [],
	            u;

	        for (u in unitsObj) {
	          if (hasOwnProp(unitsObj, u)) {
	            units.push({
	              unit: u,
	              priority: priorities[u]
	            });
	          }
	        }

	        units.sort(function (a, b) {
	          return a.priority - b.priority;
	        });
	        return units;
	      }

	      function isLeapYear(year) {
	        return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
	      }

	      function absFloor(number) {
	        if (number < 0) {
	          // -0 -> 0
	          return Math.ceil(number) || 0;
	        } else {
	          return Math.floor(number);
	        }
	      }

	      function toInt(argumentForCoercion) {
	        var coercedNumber = +argumentForCoercion,
	            value = 0;

	        if (coercedNumber !== 0 && isFinite(coercedNumber)) {
	          value = absFloor(coercedNumber);
	        }

	        return value;
	      }

	      function makeGetSet(unit, keepTime) {
	        return function (value) {
	          if (value != null) {
	            set$1(this, unit, value);
	            hooks.updateOffset(this, keepTime);
	            return this;
	          } else {
	            return get(this, unit);
	          }
	        };
	      }

	      function get(mom, unit) {
	        return mom.isValid() ? mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
	      }

	      function set$1(mom, unit, value) {
	        if (mom.isValid() && !isNaN(value)) {
	          if (unit === 'FullYear' && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
	            value = toInt(value);

	            mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value, mom.month(), daysInMonth(value, mom.month()));
	          } else {
	            mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
	          }
	        }
	      } // MOMENTS


	      function stringGet(units) {
	        units = normalizeUnits(units);

	        if (isFunction(this[units])) {
	          return this[units]();
	        }

	        return this;
	      }

	      function stringSet(units, value) {
	        if (typeof units === 'object') {
	          units = normalizeObjectUnits(units);
	          var prioritized = getPrioritizedUnits(units),
	              i,
	              prioritizedLen = prioritized.length;

	          for (i = 0; i < prioritizedLen; i++) {
	            this[prioritized[i].unit](units[prioritized[i].unit]);
	          }
	        } else {
	          units = normalizeUnits(units);

	          if (isFunction(this[units])) {
	            return this[units](value);
	          }
	        }

	        return this;
	      }

	      var match1 = /\d/,
	          //       0 - 9
	      match2 = /\d\d/,
	          //      00 - 99
	      match3 = /\d{3}/,
	          //     000 - 999
	      match4 = /\d{4}/,
	          //    0000 - 9999
	      match6 = /[+-]?\d{6}/,
	          // -999999 - 999999
	      match1to2 = /\d\d?/,
	          //       0 - 99
	      match3to4 = /\d\d\d\d?/,
	          //     999 - 9999
	      match5to6 = /\d\d\d\d\d\d?/,
	          //   99999 - 999999
	      match1to3 = /\d{1,3}/,
	          //       0 - 999
	      match1to4 = /\d{1,4}/,
	          //       0 - 9999
	      match1to6 = /[+-]?\d{1,6}/,
	          // -999999 - 999999
	      matchUnsigned = /\d+/,
	          //       0 - inf
	      matchSigned = /[+-]?\d+/,
	          //    -inf - inf
	      matchOffset = /Z|[+-]\d\d:?\d\d/gi,
	          // +00:00 -00:00 +0000 -0000 or Z
	      matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi,
	          // +00 -00 +00:00 -00:00 +0000 -0000 or Z
	      matchTimestamp = /[+-]?\d+(\.\d{1,3})?/,
	          // 123456789 123456789.123
	      // any word (or two) characters or numbers including two/three word month in arabic.
	      // includes scottish gaelic two word and hyphenated months
	      matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,
	          regexes;
	      regexes = {};

	      function addRegexToken(token, regex, strictRegex) {
	        regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
	          return isStrict && strictRegex ? strictRegex : regex;
	        };
	      }

	      function getParseRegexForToken(token, config) {
	        if (!hasOwnProp(regexes, token)) {
	          return new RegExp(unescapeFormat(token));
	        }

	        return regexes[token](config._strict, config._locale);
	      } // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript


	      function unescapeFormat(s) {
	        return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
	          return p1 || p2 || p3 || p4;
	        }));
	      }

	      function regexEscape(s) {
	        return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
	      }

	      var tokens = {};

	      function addParseToken(token, callback) {
	        var i,
	            func = callback,
	            tokenLen;

	        if (typeof token === 'string') {
	          token = [token];
	        }

	        if (isNumber(callback)) {
	          func = function (input, array) {
	            array[callback] = toInt(input);
	          };
	        }

	        tokenLen = token.length;

	        for (i = 0; i < tokenLen; i++) {
	          tokens[token[i]] = func;
	        }
	      }

	      function addWeekParseToken(token, callback) {
	        addParseToken(token, function (input, array, config, token) {
	          config._w = config._w || {};
	          callback(input, config._w, config, token);
	        });
	      }

	      function addTimeToArrayFromToken(token, input, config) {
	        if (input != null && hasOwnProp(tokens, token)) {
	          tokens[token](input, config._a, config, token);
	        }
	      }

	      var YEAR = 0,
	          MONTH = 1,
	          DATE = 2,
	          HOUR = 3,
	          MINUTE = 4,
	          SECOND = 5,
	          MILLISECOND = 6,
	          WEEK = 7,
	          WEEKDAY = 8;

	      function mod(n, x) {
	        return (n % x + x) % x;
	      }

	      var indexOf;

	      if (Array.prototype.indexOf) {
	        indexOf = Array.prototype.indexOf;
	      } else {
	        indexOf = function (o) {
	          // I know
	          var i;

	          for (i = 0; i < this.length; ++i) {
	            if (this[i] === o) {
	              return i;
	            }
	          }

	          return -1;
	        };
	      }

	      function daysInMonth(year, month) {
	        if (isNaN(year) || isNaN(month)) {
	          return NaN;
	        }

	        var modMonth = mod(month, 12);
	        year += (month - modMonth) / 12;
	        return modMonth === 1 ? isLeapYear(year) ? 29 : 28 : 31 - modMonth % 7 % 2;
	      } // FORMATTING


	      addFormatToken('M', ['MM', 2], 'Mo', function () {
	        return this.month() + 1;
	      });
	      addFormatToken('MMM', 0, 0, function (format) {
	        return this.localeData().monthsShort(this, format);
	      });
	      addFormatToken('MMMM', 0, 0, function (format) {
	        return this.localeData().months(this, format);
	      }); // ALIASES

	      addUnitAlias('month', 'M'); // PRIORITY

	      addUnitPriority('month', 8); // PARSING

	      addRegexToken('M', match1to2);
	      addRegexToken('MM', match1to2, match2);
	      addRegexToken('MMM', function (isStrict, locale) {
	        return locale.monthsShortRegex(isStrict);
	      });
	      addRegexToken('MMMM', function (isStrict, locale) {
	        return locale.monthsRegex(isStrict);
	      });
	      addParseToken(['M', 'MM'], function (input, array) {
	        array[MONTH] = toInt(input) - 1;
	      });
	      addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
	        var month = config._locale.monthsParse(input, token, config._strict); // if we didn't find a month name, mark the date as invalid.


	        if (month != null) {
	          array[MONTH] = month;
	        } else {
	          getParsingFlags(config).invalidMonth = input;
	        }
	      }); // LOCALES

	      var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
	          defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
	          MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,
	          defaultMonthsShortRegex = matchWord,
	          defaultMonthsRegex = matchWord;

	      function localeMonths(m, format) {
	        if (!m) {
	          return isArray(this._months) ? this._months : this._months['standalone'];
	        }

	        return isArray(this._months) ? this._months[m.month()] : this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
	      }

	      function localeMonthsShort(m, format) {
	        if (!m) {
	          return isArray(this._monthsShort) ? this._monthsShort : this._monthsShort['standalone'];
	        }

	        return isArray(this._monthsShort) ? this._monthsShort[m.month()] : this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
	      }

	      function handleStrictParse(monthName, format, strict) {
	        var i,
	            ii,
	            mom,
	            llc = monthName.toLocaleLowerCase();

	        if (!this._monthsParse) {
	          // this is not used
	          this._monthsParse = [];
	          this._longMonthsParse = [];
	          this._shortMonthsParse = [];

	          for (i = 0; i < 12; ++i) {
	            mom = createUTC([2000, i]);
	            this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
	            this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
	          }
	        }

	        if (strict) {
	          if (format === 'MMM') {
	            ii = indexOf.call(this._shortMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	          } else {
	            ii = indexOf.call(this._longMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	          }
	        } else {
	          if (format === 'MMM') {
	            ii = indexOf.call(this._shortMonthsParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._longMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	          } else {
	            ii = indexOf.call(this._longMonthsParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._shortMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	          }
	        }
	      }

	      function localeMonthsParse(monthName, format, strict) {
	        var i, mom, regex;

	        if (this._monthsParseExact) {
	          return handleStrictParse.call(this, monthName, format, strict);
	        }

	        if (!this._monthsParse) {
	          this._monthsParse = [];
	          this._longMonthsParse = [];
	          this._shortMonthsParse = [];
	        } // TODO: add sorting
	        // Sorting makes sure if one month (or abbr) is a prefix of another
	        // see sorting in computeMonthsParse


	        for (i = 0; i < 12; i++) {
	          // make the regex if we don't have it already
	          mom = createUTC([2000, i]);

	          if (strict && !this._longMonthsParse[i]) {
	            this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
	            this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
	          }

	          if (!strict && !this._monthsParse[i]) {
	            regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
	            this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
	          } // test the regex


	          if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
	            return i;
	          } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
	            return i;
	          } else if (!strict && this._monthsParse[i].test(monthName)) {
	            return i;
	          }
	        }
	      } // MOMENTS


	      function setMonth(mom, value) {
	        var dayOfMonth;

	        if (!mom.isValid()) {
	          // No op
	          return mom;
	        }

	        if (typeof value === 'string') {
	          if (/^\d+$/.test(value)) {
	            value = toInt(value);
	          } else {
	            value = mom.localeData().monthsParse(value); // TODO: Another silent failure?

	            if (!isNumber(value)) {
	              return mom;
	            }
	          }
	        }

	        dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));

	        mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);

	        return mom;
	      }

	      function getSetMonth(value) {
	        if (value != null) {
	          setMonth(this, value);
	          hooks.updateOffset(this, true);
	          return this;
	        } else {
	          return get(this, 'Month');
	        }
	      }

	      function getDaysInMonth() {
	        return daysInMonth(this.year(), this.month());
	      }

	      function monthsShortRegex(isStrict) {
	        if (this._monthsParseExact) {
	          if (!hasOwnProp(this, '_monthsRegex')) {
	            computeMonthsParse.call(this);
	          }

	          if (isStrict) {
	            return this._monthsShortStrictRegex;
	          } else {
	            return this._monthsShortRegex;
	          }
	        } else {
	          if (!hasOwnProp(this, '_monthsShortRegex')) {
	            this._monthsShortRegex = defaultMonthsShortRegex;
	          }

	          return this._monthsShortStrictRegex && isStrict ? this._monthsShortStrictRegex : this._monthsShortRegex;
	        }
	      }

	      function monthsRegex(isStrict) {
	        if (this._monthsParseExact) {
	          if (!hasOwnProp(this, '_monthsRegex')) {
	            computeMonthsParse.call(this);
	          }

	          if (isStrict) {
	            return this._monthsStrictRegex;
	          } else {
	            return this._monthsRegex;
	          }
	        } else {
	          if (!hasOwnProp(this, '_monthsRegex')) {
	            this._monthsRegex = defaultMonthsRegex;
	          }

	          return this._monthsStrictRegex && isStrict ? this._monthsStrictRegex : this._monthsRegex;
	        }
	      }

	      function computeMonthsParse() {
	        function cmpLenRev(a, b) {
	          return b.length - a.length;
	        }

	        var shortPieces = [],
	            longPieces = [],
	            mixedPieces = [],
	            i,
	            mom;

	        for (i = 0; i < 12; i++) {
	          // make the regex if we don't have it already
	          mom = createUTC([2000, i]);
	          shortPieces.push(this.monthsShort(mom, ''));
	          longPieces.push(this.months(mom, ''));
	          mixedPieces.push(this.months(mom, ''));
	          mixedPieces.push(this.monthsShort(mom, ''));
	        } // Sorting makes sure if one month (or abbr) is a prefix of another it
	        // will match the longer piece.


	        shortPieces.sort(cmpLenRev);
	        longPieces.sort(cmpLenRev);
	        mixedPieces.sort(cmpLenRev);

	        for (i = 0; i < 12; i++) {
	          shortPieces[i] = regexEscape(shortPieces[i]);
	          longPieces[i] = regexEscape(longPieces[i]);
	        }

	        for (i = 0; i < 24; i++) {
	          mixedPieces[i] = regexEscape(mixedPieces[i]);
	        }

	        this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	        this._monthsShortRegex = this._monthsRegex;
	        this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	        this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	      } // FORMATTING


	      addFormatToken('Y', 0, 0, function () {
	        var y = this.year();
	        return y <= 9999 ? zeroFill(y, 4) : '+' + y;
	      });
	      addFormatToken(0, ['YY', 2], 0, function () {
	        return this.year() % 100;
	      });
	      addFormatToken(0, ['YYYY', 4], 0, 'year');
	      addFormatToken(0, ['YYYYY', 5], 0, 'year');
	      addFormatToken(0, ['YYYYYY', 6, true], 0, 'year'); // ALIASES

	      addUnitAlias('year', 'y'); // PRIORITIES

	      addUnitPriority('year', 1); // PARSING

	      addRegexToken('Y', matchSigned);
	      addRegexToken('YY', match1to2, match2);
	      addRegexToken('YYYY', match1to4, match4);
	      addRegexToken('YYYYY', match1to6, match6);
	      addRegexToken('YYYYYY', match1to6, match6);
	      addParseToken(['YYYYY', 'YYYYYY'], YEAR);
	      addParseToken('YYYY', function (input, array) {
	        array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
	      });
	      addParseToken('YY', function (input, array) {
	        array[YEAR] = hooks.parseTwoDigitYear(input);
	      });
	      addParseToken('Y', function (input, array) {
	        array[YEAR] = parseInt(input, 10);
	      }); // HELPERS

	      function daysInYear(year) {
	        return isLeapYear(year) ? 366 : 365;
	      } // HOOKS


	      hooks.parseTwoDigitYear = function (input) {
	        return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
	      }; // MOMENTS


	      var getSetYear = makeGetSet('FullYear', true);

	      function getIsLeapYear() {
	        return isLeapYear(this.year());
	      }

	      function createDate(y, m, d, h, M, s, ms) {
	        // can't just apply() to create a date:
	        // https://stackoverflow.com/q/181348
	        var date; // the date constructor remaps years 0-99 to 1900-1999

	        if (y < 100 && y >= 0) {
	          // preserve leap years using a full 400 year cycle, then reset
	          date = new Date(y + 400, m, d, h, M, s, ms);

	          if (isFinite(date.getFullYear())) {
	            date.setFullYear(y);
	          }
	        } else {
	          date = new Date(y, m, d, h, M, s, ms);
	        }

	        return date;
	      }

	      function createUTCDate(y) {
	        var date, args; // the Date.UTC function remaps years 0-99 to 1900-1999

	        if (y < 100 && y >= 0) {
	          args = Array.prototype.slice.call(arguments); // preserve leap years using a full 400 year cycle, then reset

	          args[0] = y + 400;
	          date = new Date(Date.UTC.apply(null, args));

	          if (isFinite(date.getUTCFullYear())) {
	            date.setUTCFullYear(y);
	          }
	        } else {
	          date = new Date(Date.UTC.apply(null, arguments));
	        }

	        return date;
	      } // start-of-first-week - start-of-year


	      function firstWeekOffset(year, dow, doy) {
	        var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
	        fwd = 7 + dow - doy,
	            // first-week day local weekday -- which local weekday is fwd
	        fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;
	        return -fwdlw + fwd - 1;
	      } // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday


	      function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
	        var localWeekday = (7 + weekday - dow) % 7,
	            weekOffset = firstWeekOffset(year, dow, doy),
	            dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
	            resYear,
	            resDayOfYear;

	        if (dayOfYear <= 0) {
	          resYear = year - 1;
	          resDayOfYear = daysInYear(resYear) + dayOfYear;
	        } else if (dayOfYear > daysInYear(year)) {
	          resYear = year + 1;
	          resDayOfYear = dayOfYear - daysInYear(year);
	        } else {
	          resYear = year;
	          resDayOfYear = dayOfYear;
	        }

	        return {
	          year: resYear,
	          dayOfYear: resDayOfYear
	        };
	      }

	      function weekOfYear(mom, dow, doy) {
	        var weekOffset = firstWeekOffset(mom.year(), dow, doy),
	            week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
	            resWeek,
	            resYear;

	        if (week < 1) {
	          resYear = mom.year() - 1;
	          resWeek = week + weeksInYear(resYear, dow, doy);
	        } else if (week > weeksInYear(mom.year(), dow, doy)) {
	          resWeek = week - weeksInYear(mom.year(), dow, doy);
	          resYear = mom.year() + 1;
	        } else {
	          resYear = mom.year();
	          resWeek = week;
	        }

	        return {
	          week: resWeek,
	          year: resYear
	        };
	      }

	      function weeksInYear(year, dow, doy) {
	        var weekOffset = firstWeekOffset(year, dow, doy),
	            weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
	        return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
	      } // FORMATTING


	      addFormatToken('w', ['ww', 2], 'wo', 'week');
	      addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek'); // ALIASES

	      addUnitAlias('week', 'w');
	      addUnitAlias('isoWeek', 'W'); // PRIORITIES

	      addUnitPriority('week', 5);
	      addUnitPriority('isoWeek', 5); // PARSING

	      addRegexToken('w', match1to2);
	      addRegexToken('ww', match1to2, match2);
	      addRegexToken('W', match1to2);
	      addRegexToken('WW', match1to2, match2);
	      addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
	        week[token.substr(0, 1)] = toInt(input);
	      }); // HELPERS
	      // LOCALES

	      function localeWeek(mom) {
	        return weekOfYear(mom, this._week.dow, this._week.doy).week;
	      }

	      var defaultLocaleWeek = {
	        dow: 0,
	        // Sunday is the first day of the week.
	        doy: 6 // The week that contains Jan 6th is the first week of the year.

	      };

	      function localeFirstDayOfWeek() {
	        return this._week.dow;
	      }

	      function localeFirstDayOfYear() {
	        return this._week.doy;
	      } // MOMENTS


	      function getSetWeek(input) {
	        var week = this.localeData().week(this);
	        return input == null ? week : this.add((input - week) * 7, 'd');
	      }

	      function getSetISOWeek(input) {
	        var week = weekOfYear(this, 1, 4).week;
	        return input == null ? week : this.add((input - week) * 7, 'd');
	      } // FORMATTING


	      addFormatToken('d', 0, 'do', 'day');
	      addFormatToken('dd', 0, 0, function (format) {
	        return this.localeData().weekdaysMin(this, format);
	      });
	      addFormatToken('ddd', 0, 0, function (format) {
	        return this.localeData().weekdaysShort(this, format);
	      });
	      addFormatToken('dddd', 0, 0, function (format) {
	        return this.localeData().weekdays(this, format);
	      });
	      addFormatToken('e', 0, 0, 'weekday');
	      addFormatToken('E', 0, 0, 'isoWeekday'); // ALIASES

	      addUnitAlias('day', 'd');
	      addUnitAlias('weekday', 'e');
	      addUnitAlias('isoWeekday', 'E'); // PRIORITY

	      addUnitPriority('day', 11);
	      addUnitPriority('weekday', 11);
	      addUnitPriority('isoWeekday', 11); // PARSING

	      addRegexToken('d', match1to2);
	      addRegexToken('e', match1to2);
	      addRegexToken('E', match1to2);
	      addRegexToken('dd', function (isStrict, locale) {
	        return locale.weekdaysMinRegex(isStrict);
	      });
	      addRegexToken('ddd', function (isStrict, locale) {
	        return locale.weekdaysShortRegex(isStrict);
	      });
	      addRegexToken('dddd', function (isStrict, locale) {
	        return locale.weekdaysRegex(isStrict);
	      });
	      addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
	        var weekday = config._locale.weekdaysParse(input, token, config._strict); // if we didn't get a weekday name, mark the date as invalid


	        if (weekday != null) {
	          week.d = weekday;
	        } else {
	          getParsingFlags(config).invalidWeekday = input;
	        }
	      });
	      addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
	        week[token] = toInt(input);
	      }); // HELPERS

	      function parseWeekday(input, locale) {
	        if (typeof input !== 'string') {
	          return input;
	        }

	        if (!isNaN(input)) {
	          return parseInt(input, 10);
	        }

	        input = locale.weekdaysParse(input);

	        if (typeof input === 'number') {
	          return input;
	        }

	        return null;
	      }

	      function parseIsoWeekday(input, locale) {
	        if (typeof input === 'string') {
	          return locale.weekdaysParse(input) % 7 || 7;
	        }

	        return isNaN(input) ? null : input;
	      } // LOCALES


	      function shiftWeekdays(ws, n) {
	        return ws.slice(n, 7).concat(ws.slice(0, n));
	      }

	      var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
	          defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
	          defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
	          defaultWeekdaysRegex = matchWord,
	          defaultWeekdaysShortRegex = matchWord,
	          defaultWeekdaysMinRegex = matchWord;

	      function localeWeekdays(m, format) {
	        var weekdays = isArray(this._weekdays) ? this._weekdays : this._weekdays[m && m !== true && this._weekdays.isFormat.test(format) ? 'format' : 'standalone'];
	        return m === true ? shiftWeekdays(weekdays, this._week.dow) : m ? weekdays[m.day()] : weekdays;
	      }

	      function localeWeekdaysShort(m) {
	        return m === true ? shiftWeekdays(this._weekdaysShort, this._week.dow) : m ? this._weekdaysShort[m.day()] : this._weekdaysShort;
	      }

	      function localeWeekdaysMin(m) {
	        return m === true ? shiftWeekdays(this._weekdaysMin, this._week.dow) : m ? this._weekdaysMin[m.day()] : this._weekdaysMin;
	      }

	      function handleStrictParse$1(weekdayName, format, strict) {
	        var i,
	            ii,
	            mom,
	            llc = weekdayName.toLocaleLowerCase();

	        if (!this._weekdaysParse) {
	          this._weekdaysParse = [];
	          this._shortWeekdaysParse = [];
	          this._minWeekdaysParse = [];

	          for (i = 0; i < 7; ++i) {
	            mom = createUTC([2000, 1]).day(i);
	            this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
	            this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
	            this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
	          }
	        }

	        if (strict) {
	          if (format === 'dddd') {
	            ii = indexOf.call(this._weekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	          } else if (format === 'ddd') {
	            ii = indexOf.call(this._shortWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	          } else {
	            ii = indexOf.call(this._minWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	          }
	        } else {
	          if (format === 'dddd') {
	            ii = indexOf.call(this._weekdaysParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._shortWeekdaysParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._minWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	          } else if (format === 'ddd') {
	            ii = indexOf.call(this._shortWeekdaysParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._weekdaysParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._minWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	          } else {
	            ii = indexOf.call(this._minWeekdaysParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._weekdaysParse, llc);

	            if (ii !== -1) {
	              return ii;
	            }

	            ii = indexOf.call(this._shortWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	          }
	        }
	      }

	      function localeWeekdaysParse(weekdayName, format, strict) {
	        var i, mom, regex;

	        if (this._weekdaysParseExact) {
	          return handleStrictParse$1.call(this, weekdayName, format, strict);
	        }

	        if (!this._weekdaysParse) {
	          this._weekdaysParse = [];
	          this._minWeekdaysParse = [];
	          this._shortWeekdaysParse = [];
	          this._fullWeekdaysParse = [];
	        }

	        for (i = 0; i < 7; i++) {
	          // make the regex if we don't have it already
	          mom = createUTC([2000, 1]).day(i);

	          if (strict && !this._fullWeekdaysParse[i]) {
	            this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\\.?') + '$', 'i');
	            this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$', 'i');
	            this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$', 'i');
	          }

	          if (!this._weekdaysParse[i]) {
	            regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
	            this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
	          } // test the regex


	          if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
	            return i;
	          } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
	            return i;
	          } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
	            return i;
	          } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
	            return i;
	          }
	        }
	      } // MOMENTS


	      function getSetDayOfWeek(input) {
	        if (!this.isValid()) {
	          return input != null ? this : NaN;
	        }

	        var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();

	        if (input != null) {
	          input = parseWeekday(input, this.localeData());
	          return this.add(input - day, 'd');
	        } else {
	          return day;
	        }
	      }

	      function getSetLocaleDayOfWeek(input) {
	        if (!this.isValid()) {
	          return input != null ? this : NaN;
	        }

	        var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
	        return input == null ? weekday : this.add(input - weekday, 'd');
	      }

	      function getSetISODayOfWeek(input) {
	        if (!this.isValid()) {
	          return input != null ? this : NaN;
	        } // behaves the same as moment#day except
	        // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
	        // as a setter, sunday should belong to the previous week.


	        if (input != null) {
	          var weekday = parseIsoWeekday(input, this.localeData());
	          return this.day(this.day() % 7 ? weekday : weekday - 7);
	        } else {
	          return this.day() || 7;
	        }
	      }

	      function weekdaysRegex(isStrict) {
	        if (this._weekdaysParseExact) {
	          if (!hasOwnProp(this, '_weekdaysRegex')) {
	            computeWeekdaysParse.call(this);
	          }

	          if (isStrict) {
	            return this._weekdaysStrictRegex;
	          } else {
	            return this._weekdaysRegex;
	          }
	        } else {
	          if (!hasOwnProp(this, '_weekdaysRegex')) {
	            this._weekdaysRegex = defaultWeekdaysRegex;
	          }

	          return this._weekdaysStrictRegex && isStrict ? this._weekdaysStrictRegex : this._weekdaysRegex;
	        }
	      }

	      function weekdaysShortRegex(isStrict) {
	        if (this._weekdaysParseExact) {
	          if (!hasOwnProp(this, '_weekdaysRegex')) {
	            computeWeekdaysParse.call(this);
	          }

	          if (isStrict) {
	            return this._weekdaysShortStrictRegex;
	          } else {
	            return this._weekdaysShortRegex;
	          }
	        } else {
	          if (!hasOwnProp(this, '_weekdaysShortRegex')) {
	            this._weekdaysShortRegex = defaultWeekdaysShortRegex;
	          }

	          return this._weekdaysShortStrictRegex && isStrict ? this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
	        }
	      }

	      function weekdaysMinRegex(isStrict) {
	        if (this._weekdaysParseExact) {
	          if (!hasOwnProp(this, '_weekdaysRegex')) {
	            computeWeekdaysParse.call(this);
	          }

	          if (isStrict) {
	            return this._weekdaysMinStrictRegex;
	          } else {
	            return this._weekdaysMinRegex;
	          }
	        } else {
	          if (!hasOwnProp(this, '_weekdaysMinRegex')) {
	            this._weekdaysMinRegex = defaultWeekdaysMinRegex;
	          }

	          return this._weekdaysMinStrictRegex && isStrict ? this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
	        }
	      }

	      function computeWeekdaysParse() {
	        function cmpLenRev(a, b) {
	          return b.length - a.length;
	        }

	        var minPieces = [],
	            shortPieces = [],
	            longPieces = [],
	            mixedPieces = [],
	            i,
	            mom,
	            minp,
	            shortp,
	            longp;

	        for (i = 0; i < 7; i++) {
	          // make the regex if we don't have it already
	          mom = createUTC([2000, 1]).day(i);
	          minp = regexEscape(this.weekdaysMin(mom, ''));
	          shortp = regexEscape(this.weekdaysShort(mom, ''));
	          longp = regexEscape(this.weekdays(mom, ''));
	          minPieces.push(minp);
	          shortPieces.push(shortp);
	          longPieces.push(longp);
	          mixedPieces.push(minp);
	          mixedPieces.push(shortp);
	          mixedPieces.push(longp);
	        } // Sorting makes sure if one weekday (or abbr) is a prefix of another it
	        // will match the longer piece.


	        minPieces.sort(cmpLenRev);
	        shortPieces.sort(cmpLenRev);
	        longPieces.sort(cmpLenRev);
	        mixedPieces.sort(cmpLenRev);
	        this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	        this._weekdaysShortRegex = this._weekdaysRegex;
	        this._weekdaysMinRegex = this._weekdaysRegex;
	        this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	        this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	        this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
	      } // FORMATTING


	      function hFormat() {
	        return this.hours() % 12 || 12;
	      }

	      function kFormat() {
	        return this.hours() || 24;
	      }

	      addFormatToken('H', ['HH', 2], 0, 'hour');
	      addFormatToken('h', ['hh', 2], 0, hFormat);
	      addFormatToken('k', ['kk', 2], 0, kFormat);
	      addFormatToken('hmm', 0, 0, function () {
	        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
	      });
	      addFormatToken('hmmss', 0, 0, function () {
	        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
	      });
	      addFormatToken('Hmm', 0, 0, function () {
	        return '' + this.hours() + zeroFill(this.minutes(), 2);
	      });
	      addFormatToken('Hmmss', 0, 0, function () {
	        return '' + this.hours() + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
	      });

	      function meridiem(token, lowercase) {
	        addFormatToken(token, 0, 0, function () {
	          return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
	        });
	      }

	      meridiem('a', true);
	      meridiem('A', false); // ALIASES

	      addUnitAlias('hour', 'h'); // PRIORITY

	      addUnitPriority('hour', 13); // PARSING

	      function matchMeridiem(isStrict, locale) {
	        return locale._meridiemParse;
	      }

	      addRegexToken('a', matchMeridiem);
	      addRegexToken('A', matchMeridiem);
	      addRegexToken('H', match1to2);
	      addRegexToken('h', match1to2);
	      addRegexToken('k', match1to2);
	      addRegexToken('HH', match1to2, match2);
	      addRegexToken('hh', match1to2, match2);
	      addRegexToken('kk', match1to2, match2);
	      addRegexToken('hmm', match3to4);
	      addRegexToken('hmmss', match5to6);
	      addRegexToken('Hmm', match3to4);
	      addRegexToken('Hmmss', match5to6);
	      addParseToken(['H', 'HH'], HOUR);
	      addParseToken(['k', 'kk'], function (input, array, config) {
	        var kInput = toInt(input);
	        array[HOUR] = kInput === 24 ? 0 : kInput;
	      });
	      addParseToken(['a', 'A'], function (input, array, config) {
	        config._isPm = config._locale.isPM(input);
	        config._meridiem = input;
	      });
	      addParseToken(['h', 'hh'], function (input, array, config) {
	        array[HOUR] = toInt(input);
	        getParsingFlags(config).bigHour = true;
	      });
	      addParseToken('hmm', function (input, array, config) {
	        var pos = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos));
	        array[MINUTE] = toInt(input.substr(pos));
	        getParsingFlags(config).bigHour = true;
	      });
	      addParseToken('hmmss', function (input, array, config) {
	        var pos1 = input.length - 4,
	            pos2 = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos1));
	        array[MINUTE] = toInt(input.substr(pos1, 2));
	        array[SECOND] = toInt(input.substr(pos2));
	        getParsingFlags(config).bigHour = true;
	      });
	      addParseToken('Hmm', function (input, array, config) {
	        var pos = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos));
	        array[MINUTE] = toInt(input.substr(pos));
	      });
	      addParseToken('Hmmss', function (input, array, config) {
	        var pos1 = input.length - 4,
	            pos2 = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos1));
	        array[MINUTE] = toInt(input.substr(pos1, 2));
	        array[SECOND] = toInt(input.substr(pos2));
	      }); // LOCALES

	      function localeIsPM(input) {
	        // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
	        // Using charAt should be more compatible.
	        return (input + '').toLowerCase().charAt(0) === 'p';
	      }

	      var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i,
	          // Setting the hour should keep the time, because the user explicitly
	      // specified which hour they want. So trying to maintain the same hour (in
	      // a new timezone) makes sense. Adding/subtracting hours does not follow
	      // this rule.
	      getSetHour = makeGetSet('Hours', true);

	      function localeMeridiem(hours, minutes, isLower) {
	        if (hours > 11) {
	          return isLower ? 'pm' : 'PM';
	        } else {
	          return isLower ? 'am' : 'AM';
	        }
	      }

	      var baseConfig = {
	        calendar: defaultCalendar,
	        longDateFormat: defaultLongDateFormat,
	        invalidDate: defaultInvalidDate,
	        ordinal: defaultOrdinal,
	        dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
	        relativeTime: defaultRelativeTime,
	        months: defaultLocaleMonths,
	        monthsShort: defaultLocaleMonthsShort,
	        week: defaultLocaleWeek,
	        weekdays: defaultLocaleWeekdays,
	        weekdaysMin: defaultLocaleWeekdaysMin,
	        weekdaysShort: defaultLocaleWeekdaysShort,
	        meridiemParse: defaultLocaleMeridiemParse
	      }; // internal storage for locale config files

	      var locales = {},
	          localeFamilies = {},
	          globalLocale;

	      function commonPrefix(arr1, arr2) {
	        var i,
	            minl = Math.min(arr1.length, arr2.length);

	        for (i = 0; i < minl; i += 1) {
	          if (arr1[i] !== arr2[i]) {
	            return i;
	          }
	        }

	        return minl;
	      }

	      function normalizeLocale(key) {
	        return key ? key.toLowerCase().replace('_', '-') : key;
	      } // pick the locale from the array
	      // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
	      // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root


	      function chooseLocale(names) {
	        var i = 0,
	            j,
	            next,
	            locale,
	            split;

	        while (i < names.length) {
	          split = normalizeLocale(names[i]).split('-');
	          j = split.length;
	          next = normalizeLocale(names[i + 1]);
	          next = next ? next.split('-') : null;

	          while (j > 0) {
	            locale = loadLocale(split.slice(0, j).join('-'));

	            if (locale) {
	              return locale;
	            }

	            if (next && next.length >= j && commonPrefix(split, next) >= j - 1) {
	              //the next array item is better than a shallower substring of this one
	              break;
	            }

	            j--;
	          }

	          i++;
	        }

	        return globalLocale;
	      }

	      function isLocaleNameSane(name) {
	        // Prevent names that look like filesystem paths, i.e contain '/' or '\'
	        return name.match('^[^/\\\\]*$') != null;
	      }

	      function loadLocale(name) {
	        var oldLocale = null,
	            aliasedRequire; // TODO: Find a better way to register and load all the locales in Node

	        if (locales[name] === undefined && 'object' !== 'undefined' && module && module.exports && isLocaleNameSane(name)) {
	          try {
	            oldLocale = globalLocale._abbr;
	            aliasedRequire = commonjsRequire;
	            aliasedRequire('./locale/' + name);
	            getSetGlobalLocale(oldLocale);
	          } catch (e) {
	            // mark as not found to avoid repeating expensive file require call causing high CPU
	            // when trying to find en-US, en_US, en-us for every format call
	            locales[name] = null; // null means not found
	          }
	        }

	        return locales[name];
	      } // This function will load locale and then set the global locale.  If
	      // no arguments are passed in, it will simply return the current global
	      // locale key.


	      function getSetGlobalLocale(key, values) {
	        var data;

	        if (key) {
	          if (isUndefined(values)) {
	            data = getLocale(key);
	          } else {
	            data = defineLocale(key, values);
	          }

	          if (data) {
	            // moment.duration._locale = moment._locale = data;
	            globalLocale = data;
	          } else {
	            if (typeof console !== 'undefined' && console.warn) {
	              //warn user if arguments are passed but the locale could not be set
	              console.warn('Locale ' + key + ' not found. Did you forget to load it?');
	            }
	          }
	        }

	        return globalLocale._abbr;
	      }

	      function defineLocale(name, config) {
	        if (config !== null) {
	          var locale,
	              parentConfig = baseConfig;
	          config.abbr = name;

	          if (locales[name] != null) {
	            deprecateSimple('defineLocaleOverride', 'use moment.updateLocale(localeName, config) to change ' + 'an existing locale. moment.defineLocale(localeName, ' + 'config) should only be used for creating a new locale ' + 'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
	            parentConfig = locales[name]._config;
	          } else if (config.parentLocale != null) {
	            if (locales[config.parentLocale] != null) {
	              parentConfig = locales[config.parentLocale]._config;
	            } else {
	              locale = loadLocale(config.parentLocale);

	              if (locale != null) {
	                parentConfig = locale._config;
	              } else {
	                if (!localeFamilies[config.parentLocale]) {
	                  localeFamilies[config.parentLocale] = [];
	                }

	                localeFamilies[config.parentLocale].push({
	                  name: name,
	                  config: config
	                });
	                return null;
	              }
	            }
	          }

	          locales[name] = new Locale(mergeConfigs(parentConfig, config));

	          if (localeFamilies[name]) {
	            localeFamilies[name].forEach(function (x) {
	              defineLocale(x.name, x.config);
	            });
	          } // backwards compat for now: also set the locale
	          // make sure we set the locale AFTER all child locales have been
	          // created, so we won't end up with the child locale set.


	          getSetGlobalLocale(name);
	          return locales[name];
	        } else {
	          // useful for testing
	          delete locales[name];
	          return null;
	        }
	      }

	      function updateLocale(name, config) {
	        if (config != null) {
	          var locale,
	              tmpLocale,
	              parentConfig = baseConfig;

	          if (locales[name] != null && locales[name].parentLocale != null) {
	            // Update existing child locale in-place to avoid memory-leaks
	            locales[name].set(mergeConfigs(locales[name]._config, config));
	          } else {
	            // MERGE
	            tmpLocale = loadLocale(name);

	            if (tmpLocale != null) {
	              parentConfig = tmpLocale._config;
	            }

	            config = mergeConfigs(parentConfig, config);

	            if (tmpLocale == null) {
	              // updateLocale is called for creating a new locale
	              // Set abbr so it will have a name (getters return
	              // undefined otherwise).
	              config.abbr = name;
	            }

	            locale = new Locale(config);
	            locale.parentLocale = locales[name];
	            locales[name] = locale;
	          } // backwards compat for now: also set the locale


	          getSetGlobalLocale(name);
	        } else {
	          // pass null for config to unupdate, useful for tests
	          if (locales[name] != null) {
	            if (locales[name].parentLocale != null) {
	              locales[name] = locales[name].parentLocale;

	              if (name === getSetGlobalLocale()) {
	                getSetGlobalLocale(name);
	              }
	            } else if (locales[name] != null) {
	              delete locales[name];
	            }
	          }
	        }

	        return locales[name];
	      } // returns locale data


	      function getLocale(key) {
	        var locale;

	        if (key && key._locale && key._locale._abbr) {
	          key = key._locale._abbr;
	        }

	        if (!key) {
	          return globalLocale;
	        }

	        if (!isArray(key)) {
	          //short-circuit everything else
	          locale = loadLocale(key);

	          if (locale) {
	            return locale;
	          }

	          key = [key];
	        }

	        return chooseLocale(key);
	      }

	      function listLocales() {
	        return keys(locales);
	      }

	      function checkOverflow(m) {
	        var overflow,
	            a = m._a;

	        if (a && getParsingFlags(m).overflow === -2) {
	          overflow = a[MONTH] < 0 || a[MONTH] > 11 ? MONTH : a[DATE] < 1 || a[DATE] > daysInMonth(a[YEAR], a[MONTH]) ? DATE : a[HOUR] < 0 || a[HOUR] > 24 || a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0) ? HOUR : a[MINUTE] < 0 || a[MINUTE] > 59 ? MINUTE : a[SECOND] < 0 || a[SECOND] > 59 ? SECOND : a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND : -1;

	          if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
	            overflow = DATE;
	          }

	          if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
	            overflow = WEEK;
	          }

	          if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
	            overflow = WEEKDAY;
	          }

	          getParsingFlags(m).overflow = overflow;
	        }

	        return m;
	      } // iso 8601 regex
	      // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)


	      var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
	          basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
	          tzRegex = /Z|[+-]\d\d(?::?\d\d)?/,
	          isoDates = [['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/], ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/], ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/], ['GGGG-[W]WW', /\d{4}-W\d\d/, false], ['YYYY-DDD', /\d{4}-\d{3}/], ['YYYY-MM', /\d{4}-\d\d/, false], ['YYYYYYMMDD', /[+-]\d{10}/], ['YYYYMMDD', /\d{8}/], ['GGGG[W]WWE', /\d{4}W\d{3}/], ['GGGG[W]WW', /\d{4}W\d{2}/, false], ['YYYYDDD', /\d{7}/], ['YYYYMM', /\d{6}/, false], ['YYYY', /\d{4}/, false]],
	          // iso time formats and regexes
	      isoTimes = [['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/], ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/], ['HH:mm:ss', /\d\d:\d\d:\d\d/], ['HH:mm', /\d\d:\d\d/], ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/], ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/], ['HHmmss', /\d\d\d\d\d\d/], ['HHmm', /\d\d\d\d/], ['HH', /\d\d/]],
	          aspNetJsonRegex = /^\/?Date\((-?\d+)/i,
	          // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
	      rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,
	          obsOffsets = {
	        UT: 0,
	        GMT: 0,
	        EDT: -4 * 60,
	        EST: -5 * 60,
	        CDT: -5 * 60,
	        CST: -6 * 60,
	        MDT: -6 * 60,
	        MST: -7 * 60,
	        PDT: -7 * 60,
	        PST: -8 * 60
	      }; // date from iso format

	      function configFromISO(config) {
	        var i,
	            l,
	            string = config._i,
	            match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
	            allowTime,
	            dateFormat,
	            timeFormat,
	            tzFormat,
	            isoDatesLen = isoDates.length,
	            isoTimesLen = isoTimes.length;

	        if (match) {
	          getParsingFlags(config).iso = true;

	          for (i = 0, l = isoDatesLen; i < l; i++) {
	            if (isoDates[i][1].exec(match[1])) {
	              dateFormat = isoDates[i][0];
	              allowTime = isoDates[i][2] !== false;
	              break;
	            }
	          }

	          if (dateFormat == null) {
	            config._isValid = false;
	            return;
	          }

	          if (match[3]) {
	            for (i = 0, l = isoTimesLen; i < l; i++) {
	              if (isoTimes[i][1].exec(match[3])) {
	                // match[2] should be 'T' or space
	                timeFormat = (match[2] || ' ') + isoTimes[i][0];
	                break;
	              }
	            }

	            if (timeFormat == null) {
	              config._isValid = false;
	              return;
	            }
	          }

	          if (!allowTime && timeFormat != null) {
	            config._isValid = false;
	            return;
	          }

	          if (match[4]) {
	            if (tzRegex.exec(match[4])) {
	              tzFormat = 'Z';
	            } else {
	              config._isValid = false;
	              return;
	            }
	          }

	          config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
	          configFromStringAndFormat(config);
	        } else {
	          config._isValid = false;
	        }
	      }

	      function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
	        var result = [untruncateYear(yearStr), defaultLocaleMonthsShort.indexOf(monthStr), parseInt(dayStr, 10), parseInt(hourStr, 10), parseInt(minuteStr, 10)];

	        if (secondStr) {
	          result.push(parseInt(secondStr, 10));
	        }

	        return result;
	      }

	      function untruncateYear(yearStr) {
	        var year = parseInt(yearStr, 10);

	        if (year <= 49) {
	          return 2000 + year;
	        } else if (year <= 999) {
	          return 1900 + year;
	        }

	        return year;
	      }

	      function preprocessRFC2822(s) {
	        // Remove comments and folding whitespace and replace multiple-spaces with a single space
	        return s.replace(/\([^()]*\)|[\n\t]/g, ' ').replace(/(\s\s+)/g, ' ').replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	      }

	      function checkWeekday(weekdayStr, parsedInput, config) {
	        if (weekdayStr) {
	          // TODO: Replace the vanilla JS Date object with an independent day-of-week check.
	          var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr),
	              weekdayActual = new Date(parsedInput[0], parsedInput[1], parsedInput[2]).getDay();

	          if (weekdayProvided !== weekdayActual) {
	            getParsingFlags(config).weekdayMismatch = true;
	            config._isValid = false;
	            return false;
	          }
	        }

	        return true;
	      }

	      function calculateOffset(obsOffset, militaryOffset, numOffset) {
	        if (obsOffset) {
	          return obsOffsets[obsOffset];
	        } else if (militaryOffset) {
	          // the only allowed military tz is Z
	          return 0;
	        } else {
	          var hm = parseInt(numOffset, 10),
	              m = hm % 100,
	              h = (hm - m) / 100;
	          return h * 60 + m;
	        }
	      } // date and time from ref 2822 format


	      function configFromRFC2822(config) {
	        var match = rfc2822.exec(preprocessRFC2822(config._i)),
	            parsedArray;

	        if (match) {
	          parsedArray = extractFromRFC2822Strings(match[4], match[3], match[2], match[5], match[6], match[7]);

	          if (!checkWeekday(match[1], parsedArray, config)) {
	            return;
	          }

	          config._a = parsedArray;
	          config._tzm = calculateOffset(match[8], match[9], match[10]);
	          config._d = createUTCDate.apply(null, config._a);

	          config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);

	          getParsingFlags(config).rfc2822 = true;
	        } else {
	          config._isValid = false;
	        }
	      } // date from 1) ASP.NET, 2) ISO, 3) RFC 2822 formats, or 4) optional fallback if parsing isn't strict


	      function configFromString(config) {
	        var matched = aspNetJsonRegex.exec(config._i);

	        if (matched !== null) {
	          config._d = new Date(+matched[1]);
	          return;
	        }

	        configFromISO(config);

	        if (config._isValid === false) {
	          delete config._isValid;
	        } else {
	          return;
	        }

	        configFromRFC2822(config);

	        if (config._isValid === false) {
	          delete config._isValid;
	        } else {
	          return;
	        }

	        if (config._strict) {
	          config._isValid = false;
	        } else {
	          // Final attempt, use Input Fallback
	          hooks.createFromInputFallback(config);
	        }
	      }

	      hooks.createFromInputFallback = deprecate('value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' + 'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' + 'discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.', function (config) {
	        config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
	      }); // Pick the first defined of two or three arguments.

	      function defaults(a, b, c) {
	        if (a != null) {
	          return a;
	        }

	        if (b != null) {
	          return b;
	        }

	        return c;
	      }

	      function currentDateArray(config) {
	        // hooks is actually the exported moment object
	        var nowValue = new Date(hooks.now());

	        if (config._useUTC) {
	          return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
	        }

	        return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
	      } // convert an array to a date.
	      // the array should mirror the parameters below
	      // note: all values past the year are optional and will default to the lowest possible value.
	      // [year, month, day , hour, minute, second, millisecond]


	      function configFromArray(config) {
	        var i,
	            date,
	            input = [],
	            currentDate,
	            expectedWeekday,
	            yearToUse;

	        if (config._d) {
	          return;
	        }

	        currentDate = currentDateArray(config); //compute day of the year from weeks and weekdays

	        if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
	          dayOfYearFromWeekInfo(config);
	        } //if the day of the year is set, figure out what it is


	        if (config._dayOfYear != null) {
	          yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

	          if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {
	            getParsingFlags(config)._overflowDayOfYear = true;
	          }

	          date = createUTCDate(yearToUse, 0, config._dayOfYear);
	          config._a[MONTH] = date.getUTCMonth();
	          config._a[DATE] = date.getUTCDate();
	        } // Default to current date.
	        // * if no year, month, day of month are given, default to today
	        // * if day of month is given, default month and year
	        // * if month is given, default only year
	        // * if year is given, don't default anything


	        for (i = 0; i < 3 && config._a[i] == null; ++i) {
	          config._a[i] = input[i] = currentDate[i];
	        } // Zero out whatever was not defaulted, including time


	        for (; i < 7; i++) {
	          config._a[i] = input[i] = config._a[i] == null ? i === 2 ? 1 : 0 : config._a[i];
	        } // Check for 24:00:00.000


	        if (config._a[HOUR] === 24 && config._a[MINUTE] === 0 && config._a[SECOND] === 0 && config._a[MILLISECOND] === 0) {
	          config._nextDay = true;
	          config._a[HOUR] = 0;
	        }

	        config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
	        expectedWeekday = config._useUTC ? config._d.getUTCDay() : config._d.getDay(); // Apply timezone offset from input. The actual utcOffset can be changed
	        // with parseZone.

	        if (config._tzm != null) {
	          config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
	        }

	        if (config._nextDay) {
	          config._a[HOUR] = 24;
	        } // check for mismatching day of week


	        if (config._w && typeof config._w.d !== 'undefined' && config._w.d !== expectedWeekday) {
	          getParsingFlags(config).weekdayMismatch = true;
	        }
	      }

	      function dayOfYearFromWeekInfo(config) {
	        var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow, curWeek;
	        w = config._w;

	        if (w.GG != null || w.W != null || w.E != null) {
	          dow = 1;
	          doy = 4; // TODO: We need to take the current isoWeekYear, but that depends on
	          // how we interpret now (local, utc, fixed offset). So create
	          // a now version of current config (take local/utc/offset flags, and
	          // create now).

	          weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
	          week = defaults(w.W, 1);
	          weekday = defaults(w.E, 1);

	          if (weekday < 1 || weekday > 7) {
	            weekdayOverflow = true;
	          }
	        } else {
	          dow = config._locale._week.dow;
	          doy = config._locale._week.doy;
	          curWeek = weekOfYear(createLocal(), dow, doy);
	          weekYear = defaults(w.gg, config._a[YEAR], curWeek.year); // Default to current week.

	          week = defaults(w.w, curWeek.week);

	          if (w.d != null) {
	            // weekday -- low day numbers are considered next week
	            weekday = w.d;

	            if (weekday < 0 || weekday > 6) {
	              weekdayOverflow = true;
	            }
	          } else if (w.e != null) {
	            // local weekday -- counting starts from beginning of week
	            weekday = w.e + dow;

	            if (w.e < 0 || w.e > 6) {
	              weekdayOverflow = true;
	            }
	          } else {
	            // default to beginning of week
	            weekday = dow;
	          }
	        }

	        if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
	          getParsingFlags(config)._overflowWeeks = true;
	        } else if (weekdayOverflow != null) {
	          getParsingFlags(config)._overflowWeekday = true;
	        } else {
	          temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
	          config._a[YEAR] = temp.year;
	          config._dayOfYear = temp.dayOfYear;
	        }
	      } // constant that refers to the ISO standard


	      hooks.ISO_8601 = function () {}; // constant that refers to the RFC 2822 form


	      hooks.RFC_2822 = function () {}; // date from string and format string


	      function configFromStringAndFormat(config) {
	        // TODO: Move this to another part of the creation flow to prevent circular deps
	        if (config._f === hooks.ISO_8601) {
	          configFromISO(config);
	          return;
	        }

	        if (config._f === hooks.RFC_2822) {
	          configFromRFC2822(config);
	          return;
	        }

	        config._a = [];
	        getParsingFlags(config).empty = true; // This array is used to make a Date, either with `new Date` or `Date.UTC`

	        var string = '' + config._i,
	            i,
	            parsedInput,
	            tokens,
	            token,
	            skipped,
	            stringLength = string.length,
	            totalParsedInputLength = 0,
	            era,
	            tokenLen;
	        tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];
	        tokenLen = tokens.length;

	        for (i = 0; i < tokenLen; i++) {
	          token = tokens[i];
	          parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];

	          if (parsedInput) {
	            skipped = string.substr(0, string.indexOf(parsedInput));

	            if (skipped.length > 0) {
	              getParsingFlags(config).unusedInput.push(skipped);
	            }

	            string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
	            totalParsedInputLength += parsedInput.length;
	          } // don't parse if it's not a known token


	          if (formatTokenFunctions[token]) {
	            if (parsedInput) {
	              getParsingFlags(config).empty = false;
	            } else {
	              getParsingFlags(config).unusedTokens.push(token);
	            }

	            addTimeToArrayFromToken(token, parsedInput, config);
	          } else if (config._strict && !parsedInput) {
	            getParsingFlags(config).unusedTokens.push(token);
	          }
	        } // add remaining unparsed input length to the string


	        getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;

	        if (string.length > 0) {
	          getParsingFlags(config).unusedInput.push(string);
	        } // clear _12h flag if hour is <= 12


	        if (config._a[HOUR] <= 12 && getParsingFlags(config).bigHour === true && config._a[HOUR] > 0) {
	          getParsingFlags(config).bigHour = undefined;
	        }

	        getParsingFlags(config).parsedDateParts = config._a.slice(0);
	        getParsingFlags(config).meridiem = config._meridiem; // handle meridiem

	        config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem); // handle era

	        era = getParsingFlags(config).era;

	        if (era !== null) {
	          config._a[YEAR] = config._locale.erasConvertYear(era, config._a[YEAR]);
	        }

	        configFromArray(config);
	        checkOverflow(config);
	      }

	      function meridiemFixWrap(locale, hour, meridiem) {
	        var isPm;

	        if (meridiem == null) {
	          // nothing to do
	          return hour;
	        }

	        if (locale.meridiemHour != null) {
	          return locale.meridiemHour(hour, meridiem);
	        } else if (locale.isPM != null) {
	          // Fallback
	          isPm = locale.isPM(meridiem);

	          if (isPm && hour < 12) {
	            hour += 12;
	          }

	          if (!isPm && hour === 12) {
	            hour = 0;
	          }

	          return hour;
	        } else {
	          // this is not supposed to happen
	          return hour;
	        }
	      } // date from string and array of format strings


	      function configFromStringAndArray(config) {
	        var tempConfig,
	            bestMoment,
	            scoreToBeat,
	            i,
	            currentScore,
	            validFormatFound,
	            bestFormatIsValid = false,
	            configfLen = config._f.length;

	        if (configfLen === 0) {
	          getParsingFlags(config).invalidFormat = true;
	          config._d = new Date(NaN);
	          return;
	        }

	        for (i = 0; i < configfLen; i++) {
	          currentScore = 0;
	          validFormatFound = false;
	          tempConfig = copyConfig({}, config);

	          if (config._useUTC != null) {
	            tempConfig._useUTC = config._useUTC;
	          }

	          tempConfig._f = config._f[i];
	          configFromStringAndFormat(tempConfig);

	          if (isValid(tempConfig)) {
	            validFormatFound = true;
	          } // if there is any input that was not parsed add a penalty for that format


	          currentScore += getParsingFlags(tempConfig).charsLeftOver; //or tokens

	          currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;
	          getParsingFlags(tempConfig).score = currentScore;

	          if (!bestFormatIsValid) {
	            if (scoreToBeat == null || currentScore < scoreToBeat || validFormatFound) {
	              scoreToBeat = currentScore;
	              bestMoment = tempConfig;

	              if (validFormatFound) {
	                bestFormatIsValid = true;
	              }
	            }
	          } else {
	            if (currentScore < scoreToBeat) {
	              scoreToBeat = currentScore;
	              bestMoment = tempConfig;
	            }
	          }
	        }

	        extend(config, bestMoment || tempConfig);
	      }

	      function configFromObject(config) {
	        if (config._d) {
	          return;
	        }

	        var i = normalizeObjectUnits(config._i),
	            dayOrDate = i.day === undefined ? i.date : i.day;
	        config._a = map([i.year, i.month, dayOrDate, i.hour, i.minute, i.second, i.millisecond], function (obj) {
	          return obj && parseInt(obj, 10);
	        });
	        configFromArray(config);
	      }

	      function createFromConfig(config) {
	        var res = new Moment(checkOverflow(prepareConfig(config)));

	        if (res._nextDay) {
	          // Adding is smart enough around DST
	          res.add(1, 'd');
	          res._nextDay = undefined;
	        }

	        return res;
	      }

	      function prepareConfig(config) {
	        var input = config._i,
	            format = config._f;
	        config._locale = config._locale || getLocale(config._l);

	        if (input === null || format === undefined && input === '') {
	          return createInvalid({
	            nullInput: true
	          });
	        }

	        if (typeof input === 'string') {
	          config._i = input = config._locale.preparse(input);
	        }

	        if (isMoment(input)) {
	          return new Moment(checkOverflow(input));
	        } else if (isDate(input)) {
	          config._d = input;
	        } else if (isArray(format)) {
	          configFromStringAndArray(config);
	        } else if (format) {
	          configFromStringAndFormat(config);
	        } else {
	          configFromInput(config);
	        }

	        if (!isValid(config)) {
	          config._d = null;
	        }

	        return config;
	      }

	      function configFromInput(config) {
	        var input = config._i;

	        if (isUndefined(input)) {
	          config._d = new Date(hooks.now());
	        } else if (isDate(input)) {
	          config._d = new Date(input.valueOf());
	        } else if (typeof input === 'string') {
	          configFromString(config);
	        } else if (isArray(input)) {
	          config._a = map(input.slice(0), function (obj) {
	            return parseInt(obj, 10);
	          });
	          configFromArray(config);
	        } else if (isObject(input)) {
	          configFromObject(config);
	        } else if (isNumber(input)) {
	          // from milliseconds
	          config._d = new Date(input);
	        } else {
	          hooks.createFromInputFallback(config);
	        }
	      }

	      function createLocalOrUTC(input, format, locale, strict, isUTC) {
	        var c = {};

	        if (format === true || format === false) {
	          strict = format;
	          format = undefined;
	        }

	        if (locale === true || locale === false) {
	          strict = locale;
	          locale = undefined;
	        }

	        if (isObject(input) && isObjectEmpty(input) || isArray(input) && input.length === 0) {
	          input = undefined;
	        } // object construction must be done this way.
	        // https://github.com/moment/moment/issues/1423


	        c._isAMomentObject = true;
	        c._useUTC = c._isUTC = isUTC;
	        c._l = locale;
	        c._i = input;
	        c._f = format;
	        c._strict = strict;
	        return createFromConfig(c);
	      }

	      function createLocal(input, format, locale, strict) {
	        return createLocalOrUTC(input, format, locale, strict, false);
	      }

	      var prototypeMin = deprecate('moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/', function () {
	        var other = createLocal.apply(null, arguments);

	        if (this.isValid() && other.isValid()) {
	          return other < this ? this : other;
	        } else {
	          return createInvalid();
	        }
	      }),
	          prototypeMax = deprecate('moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/', function () {
	        var other = createLocal.apply(null, arguments);

	        if (this.isValid() && other.isValid()) {
	          return other > this ? this : other;
	        } else {
	          return createInvalid();
	        }
	      }); // Pick a moment m from moments so that m[fn](other) is true for all
	      // other. This relies on the function fn to be transitive.
	      //
	      // moments should either be an array of moment objects or an array, whose
	      // first element is an array of moment objects.

	      function pickBy(fn, moments) {
	        var res, i;

	        if (moments.length === 1 && isArray(moments[0])) {
	          moments = moments[0];
	        }

	        if (!moments.length) {
	          return createLocal();
	        }

	        res = moments[0];

	        for (i = 1; i < moments.length; ++i) {
	          if (!moments[i].isValid() || moments[i][fn](res)) {
	            res = moments[i];
	          }
	        }

	        return res;
	      } // TODO: Use [].sort instead?


	      function min() {
	        var args = [].slice.call(arguments, 0);
	        return pickBy('isBefore', args);
	      }

	      function max() {
	        var args = [].slice.call(arguments, 0);
	        return pickBy('isAfter', args);
	      }

	      var now = function () {
	        return Date.now ? Date.now() : +new Date();
	      };

	      var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];

	      function isDurationValid(m) {
	        var key,
	            unitHasDecimal = false,
	            i,
	            orderLen = ordering.length;

	        for (key in m) {
	          if (hasOwnProp(m, key) && !(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
	            return false;
	          }
	        }

	        for (i = 0; i < orderLen; ++i) {
	          if (m[ordering[i]]) {
	            if (unitHasDecimal) {
	              return false; // only allow non-integers for smallest unit
	            }

	            if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
	              unitHasDecimal = true;
	            }
	          }
	        }

	        return true;
	      }

	      function isValid$1() {
	        return this._isValid;
	      }

	      function createInvalid$1() {
	        return createDuration(NaN);
	      }

	      function Duration(duration) {
	        var normalizedInput = normalizeObjectUnits(duration),
	            years = normalizedInput.year || 0,
	            quarters = normalizedInput.quarter || 0,
	            months = normalizedInput.month || 0,
	            weeks = normalizedInput.week || normalizedInput.isoWeek || 0,
	            days = normalizedInput.day || 0,
	            hours = normalizedInput.hour || 0,
	            minutes = normalizedInput.minute || 0,
	            seconds = normalizedInput.second || 0,
	            milliseconds = normalizedInput.millisecond || 0;
	        this._isValid = isDurationValid(normalizedInput); // representation for dateAddRemove

	        this._milliseconds = +milliseconds + seconds * 1e3 + // 1000
	        minutes * 6e4 + // 1000 * 60
	        hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
	        // Because of dateAddRemove treats 24 hours as different from a
	        // day when working around DST, we need to store them separately

	        this._days = +days + weeks * 7; // It is impossible to translate months into days without knowing
	        // which months you are are talking about, so we have to store
	        // it separately.

	        this._months = +months + quarters * 3 + years * 12;
	        this._data = {};
	        this._locale = getLocale();

	        this._bubble();
	      }

	      function isDuration(obj) {
	        return obj instanceof Duration;
	      }

	      function absRound(number) {
	        if (number < 0) {
	          return Math.round(-1 * number) * -1;
	        } else {
	          return Math.round(number);
	        }
	      } // compare two arrays, return the number of differences


	      function compareArrays(array1, array2, dontConvert) {
	        var len = Math.min(array1.length, array2.length),
	            lengthDiff = Math.abs(array1.length - array2.length),
	            diffs = 0,
	            i;

	        for (i = 0; i < len; i++) {
	          if (dontConvert && array1[i] !== array2[i] || !dontConvert && toInt(array1[i]) !== toInt(array2[i])) {
	            diffs++;
	          }
	        }

	        return diffs + lengthDiff;
	      } // FORMATTING


	      function offset(token, separator) {
	        addFormatToken(token, 0, 0, function () {
	          var offset = this.utcOffset(),
	              sign = '+';

	          if (offset < 0) {
	            offset = -offset;
	            sign = '-';
	          }

	          return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~offset % 60, 2);
	        });
	      }

	      offset('Z', ':');
	      offset('ZZ', ''); // PARSING

	      addRegexToken('Z', matchShortOffset);
	      addRegexToken('ZZ', matchShortOffset);
	      addParseToken(['Z', 'ZZ'], function (input, array, config) {
	        config._useUTC = true;
	        config._tzm = offsetFromString(matchShortOffset, input);
	      }); // HELPERS
	      // timezone chunker
	      // '+10:00' > ['10',  '00']
	      // '-1530'  > ['-15', '30']

	      var chunkOffset = /([\+\-]|\d\d)/gi;

	      function offsetFromString(matcher, string) {
	        var matches = (string || '').match(matcher),
	            chunk,
	            parts,
	            minutes;

	        if (matches === null) {
	          return null;
	        }

	        chunk = matches[matches.length - 1] || [];
	        parts = (chunk + '').match(chunkOffset) || ['-', 0, 0];
	        minutes = +(parts[1] * 60) + toInt(parts[2]);
	        return minutes === 0 ? 0 : parts[0] === '+' ? minutes : -minutes;
	      } // Return a moment from input, that is local/utc/zone equivalent to model.


	      function cloneWithOffset(input, model) {
	        var res, diff;

	        if (model._isUTC) {
	          res = model.clone();
	          diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf(); // Use low-level api, because this fn is low-level api.

	          res._d.setTime(res._d.valueOf() + diff);

	          hooks.updateOffset(res, false);
	          return res;
	        } else {
	          return createLocal(input).local();
	        }
	      }

	      function getDateOffset(m) {
	        // On Firefox.24 Date#getTimezoneOffset returns a floating point.
	        // https://github.com/moment/moment/pull/1871
	        return -Math.round(m._d.getTimezoneOffset());
	      } // HOOKS
	      // This function will be called whenever a moment is mutated.
	      // It is intended to keep the offset in sync with the timezone.


	      hooks.updateOffset = function () {}; // MOMENTS
	      // keepLocalTime = true means only change the timezone, without
	      // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
	      // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
	      // +0200, so we adjust the time as needed, to be valid.
	      //
	      // Keeping the time actually adds/subtracts (one hour)
	      // from the actual represented time. That is why we call updateOffset
	      // a second time. In case it wants us to change the offset again
	      // _changeInProgress == true case, then we have to adjust, because
	      // there is no such time in the given timezone.


	      function getSetOffset(input, keepLocalTime, keepMinutes) {
	        var offset = this._offset || 0,
	            localAdjust;

	        if (!this.isValid()) {
	          return input != null ? this : NaN;
	        }

	        if (input != null) {
	          if (typeof input === 'string') {
	            input = offsetFromString(matchShortOffset, input);

	            if (input === null) {
	              return this;
	            }
	          } else if (Math.abs(input) < 16 && !keepMinutes) {
	            input = input * 60;
	          }

	          if (!this._isUTC && keepLocalTime) {
	            localAdjust = getDateOffset(this);
	          }

	          this._offset = input;
	          this._isUTC = true;

	          if (localAdjust != null) {
	            this.add(localAdjust, 'm');
	          }

	          if (offset !== input) {
	            if (!keepLocalTime || this._changeInProgress) {
	              addSubtract(this, createDuration(input - offset, 'm'), 1, false);
	            } else if (!this._changeInProgress) {
	              this._changeInProgress = true;
	              hooks.updateOffset(this, true);
	              this._changeInProgress = null;
	            }
	          }

	          return this;
	        } else {
	          return this._isUTC ? offset : getDateOffset(this);
	        }
	      }

	      function getSetZone(input, keepLocalTime) {
	        if (input != null) {
	          if (typeof input !== 'string') {
	            input = -input;
	          }

	          this.utcOffset(input, keepLocalTime);
	          return this;
	        } else {
	          return -this.utcOffset();
	        }
	      }

	      function setOffsetToUTC(keepLocalTime) {
	        return this.utcOffset(0, keepLocalTime);
	      }

	      function setOffsetToLocal(keepLocalTime) {
	        if (this._isUTC) {
	          this.utcOffset(0, keepLocalTime);
	          this._isUTC = false;

	          if (keepLocalTime) {
	            this.subtract(getDateOffset(this), 'm');
	          }
	        }

	        return this;
	      }

	      function setOffsetToParsedOffset() {
	        if (this._tzm != null) {
	          this.utcOffset(this._tzm, false, true);
	        } else if (typeof this._i === 'string') {
	          var tZone = offsetFromString(matchOffset, this._i);

	          if (tZone != null) {
	            this.utcOffset(tZone);
	          } else {
	            this.utcOffset(0, true);
	          }
	        }

	        return this;
	      }

	      function hasAlignedHourOffset(input) {
	        if (!this.isValid()) {
	          return false;
	        }

	        input = input ? createLocal(input).utcOffset() : 0;
	        return (this.utcOffset() - input) % 60 === 0;
	      }

	      function isDaylightSavingTime() {
	        return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
	      }

	      function isDaylightSavingTimeShifted() {
	        if (!isUndefined(this._isDSTShifted)) {
	          return this._isDSTShifted;
	        }

	        var c = {},
	            other;
	        copyConfig(c, this);
	        c = prepareConfig(c);

	        if (c._a) {
	          other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
	          this._isDSTShifted = this.isValid() && compareArrays(c._a, other.toArray()) > 0;
	        } else {
	          this._isDSTShifted = false;
	        }

	        return this._isDSTShifted;
	      }

	      function isLocal() {
	        return this.isValid() ? !this._isUTC : false;
	      }

	      function isUtcOffset() {
	        return this.isValid() ? this._isUTC : false;
	      }

	      function isUtc() {
	        return this.isValid() ? this._isUTC && this._offset === 0 : false;
	      } // ASP.NET json date format regex


	      var aspNetRegex = /^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,
	          // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
	      // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
	      // and further modified to allow for strings containing both week and day
	      isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;

	      function createDuration(input, key) {
	        var duration = input,
	            // matching against regexp is expensive, do it on demand
	        match = null,
	            sign,
	            ret,
	            diffRes;

	        if (isDuration(input)) {
	          duration = {
	            ms: input._milliseconds,
	            d: input._days,
	            M: input._months
	          };
	        } else if (isNumber(input) || !isNaN(+input)) {
	          duration = {};

	          if (key) {
	            duration[key] = +input;
	          } else {
	            duration.milliseconds = +input;
	          }
	        } else if (match = aspNetRegex.exec(input)) {
	          sign = match[1] === '-' ? -1 : 1;
	          duration = {
	            y: 0,
	            d: toInt(match[DATE]) * sign,
	            h: toInt(match[HOUR]) * sign,
	            m: toInt(match[MINUTE]) * sign,
	            s: toInt(match[SECOND]) * sign,
	            ms: toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match

	          };
	        } else if (match = isoRegex.exec(input)) {
	          sign = match[1] === '-' ? -1 : 1;
	          duration = {
	            y: parseIso(match[2], sign),
	            M: parseIso(match[3], sign),
	            w: parseIso(match[4], sign),
	            d: parseIso(match[5], sign),
	            h: parseIso(match[6], sign),
	            m: parseIso(match[7], sign),
	            s: parseIso(match[8], sign)
	          };
	        } else if (duration == null) {
	          // checks for null or undefined
	          duration = {};
	        } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
	          diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));
	          duration = {};
	          duration.ms = diffRes.milliseconds;
	          duration.M = diffRes.months;
	        }

	        ret = new Duration(duration);

	        if (isDuration(input) && hasOwnProp(input, '_locale')) {
	          ret._locale = input._locale;
	        }

	        if (isDuration(input) && hasOwnProp(input, '_isValid')) {
	          ret._isValid = input._isValid;
	        }

	        return ret;
	      }

	      createDuration.fn = Duration.prototype;
	      createDuration.invalid = createInvalid$1;

	      function parseIso(inp, sign) {
	        // We'd normally use ~~inp for this, but unfortunately it also
	        // converts floats to ints.
	        // inp may be undefined, so careful calling replace on it.
	        var res = inp && parseFloat(inp.replace(',', '.')); // apply sign while we're at it

	        return (isNaN(res) ? 0 : res) * sign;
	      }

	      function positiveMomentsDifference(base, other) {
	        var res = {};
	        res.months = other.month() - base.month() + (other.year() - base.year()) * 12;

	        if (base.clone().add(res.months, 'M').isAfter(other)) {
	          --res.months;
	        }

	        res.milliseconds = +other - +base.clone().add(res.months, 'M');
	        return res;
	      }

	      function momentsDifference(base, other) {
	        var res;

	        if (!(base.isValid() && other.isValid())) {
	          return {
	            milliseconds: 0,
	            months: 0
	          };
	        }

	        other = cloneWithOffset(other, base);

	        if (base.isBefore(other)) {
	          res = positiveMomentsDifference(base, other);
	        } else {
	          res = positiveMomentsDifference(other, base);
	          res.milliseconds = -res.milliseconds;
	          res.months = -res.months;
	        }

	        return res;
	      } // TODO: remove 'name' arg after deprecation is removed


	      function createAdder(direction, name) {
	        return function (val, period) {
	          var dur, tmp; //invert the arguments, but complain about it

	          if (period !== null && !isNaN(+period)) {
	            deprecateSimple(name, 'moment().' + name + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' + 'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
	            tmp = val;
	            val = period;
	            period = tmp;
	          }

	          dur = createDuration(val, period);
	          addSubtract(this, dur, direction);
	          return this;
	        };
	      }

	      function addSubtract(mom, duration, isAdding, updateOffset) {
	        var milliseconds = duration._milliseconds,
	            days = absRound(duration._days),
	            months = absRound(duration._months);

	        if (!mom.isValid()) {
	          // No op
	          return;
	        }

	        updateOffset = updateOffset == null ? true : updateOffset;

	        if (months) {
	          setMonth(mom, get(mom, 'Month') + months * isAdding);
	        }

	        if (days) {
	          set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
	        }

	        if (milliseconds) {
	          mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
	        }

	        if (updateOffset) {
	          hooks.updateOffset(mom, days || months);
	        }
	      }

	      var add = createAdder(1, 'add'),
	          subtract = createAdder(-1, 'subtract');

	      function isString(input) {
	        return typeof input === 'string' || input instanceof String;
	      } // type MomentInput = Moment | Date | string | number | (number | string)[] | MomentInputObject | void; // null | undefined


	      function isMomentInput(input) {
	        return isMoment(input) || isDate(input) || isString(input) || isNumber(input) || isNumberOrStringArray(input) || isMomentInputObject(input) || input === null || input === undefined;
	      }

	      function isMomentInputObject(input) {
	        var objectTest = isObject(input) && !isObjectEmpty(input),
	            propertyTest = false,
	            properties = ['years', 'year', 'y', 'months', 'month', 'M', 'days', 'day', 'd', 'dates', 'date', 'D', 'hours', 'hour', 'h', 'minutes', 'minute', 'm', 'seconds', 'second', 's', 'milliseconds', 'millisecond', 'ms'],
	            i,
	            property,
	            propertyLen = properties.length;

	        for (i = 0; i < propertyLen; i += 1) {
	          property = properties[i];
	          propertyTest = propertyTest || hasOwnProp(input, property);
	        }

	        return objectTest && propertyTest;
	      }

	      function isNumberOrStringArray(input) {
	        var arrayTest = isArray(input),
	            dataTypeTest = false;

	        if (arrayTest) {
	          dataTypeTest = input.filter(function (item) {
	            return !isNumber(item) && isString(input);
	          }).length === 0;
	        }

	        return arrayTest && dataTypeTest;
	      }

	      function isCalendarSpec(input) {
	        var objectTest = isObject(input) && !isObjectEmpty(input),
	            propertyTest = false,
	            properties = ['sameDay', 'nextDay', 'lastDay', 'nextWeek', 'lastWeek', 'sameElse'],
	            i,
	            property;

	        for (i = 0; i < properties.length; i += 1) {
	          property = properties[i];
	          propertyTest = propertyTest || hasOwnProp(input, property);
	        }

	        return objectTest && propertyTest;
	      }

	      function getCalendarFormat(myMoment, now) {
	        var diff = myMoment.diff(now, 'days', true);
	        return diff < -6 ? 'sameElse' : diff < -1 ? 'lastWeek' : diff < 0 ? 'lastDay' : diff < 1 ? 'sameDay' : diff < 2 ? 'nextDay' : diff < 7 ? 'nextWeek' : 'sameElse';
	      }

	      function calendar$1(time, formats) {
	        // Support for single parameter, formats only overload to the calendar function
	        if (arguments.length === 1) {
	          if (!arguments[0]) {
	            time = undefined;
	            formats = undefined;
	          } else if (isMomentInput(arguments[0])) {
	            time = arguments[0];
	            formats = undefined;
	          } else if (isCalendarSpec(arguments[0])) {
	            formats = arguments[0];
	            time = undefined;
	          }
	        } // We want to compare the start of today, vs this.
	        // Getting start-of-today depends on whether we're local/utc/offset or not.


	        var now = time || createLocal(),
	            sod = cloneWithOffset(now, this).startOf('day'),
	            format = hooks.calendarFormat(this, sod) || 'sameElse',
	            output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);
	        return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
	      }

	      function clone() {
	        return new Moment(this);
	      }

	      function isAfter(input, units) {
	        var localInput = isMoment(input) ? input : createLocal(input);

	        if (!(this.isValid() && localInput.isValid())) {
	          return false;
	        }

	        units = normalizeUnits(units) || 'millisecond';

	        if (units === 'millisecond') {
	          return this.valueOf() > localInput.valueOf();
	        } else {
	          return localInput.valueOf() < this.clone().startOf(units).valueOf();
	        }
	      }

	      function isBefore(input, units) {
	        var localInput = isMoment(input) ? input : createLocal(input);

	        if (!(this.isValid() && localInput.isValid())) {
	          return false;
	        }

	        units = normalizeUnits(units) || 'millisecond';

	        if (units === 'millisecond') {
	          return this.valueOf() < localInput.valueOf();
	        } else {
	          return this.clone().endOf(units).valueOf() < localInput.valueOf();
	        }
	      }

	      function isBetween(from, to, units, inclusivity) {
	        var localFrom = isMoment(from) ? from : createLocal(from),
	            localTo = isMoment(to) ? to : createLocal(to);

	        if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
	          return false;
	        }

	        inclusivity = inclusivity || '()';
	        return (inclusivity[0] === '(' ? this.isAfter(localFrom, units) : !this.isBefore(localFrom, units)) && (inclusivity[1] === ')' ? this.isBefore(localTo, units) : !this.isAfter(localTo, units));
	      }

	      function isSame(input, units) {
	        var localInput = isMoment(input) ? input : createLocal(input),
	            inputMs;

	        if (!(this.isValid() && localInput.isValid())) {
	          return false;
	        }

	        units = normalizeUnits(units) || 'millisecond';

	        if (units === 'millisecond') {
	          return this.valueOf() === localInput.valueOf();
	        } else {
	          inputMs = localInput.valueOf();
	          return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
	        }
	      }

	      function isSameOrAfter(input, units) {
	        return this.isSame(input, units) || this.isAfter(input, units);
	      }

	      function isSameOrBefore(input, units) {
	        return this.isSame(input, units) || this.isBefore(input, units);
	      }

	      function diff(input, units, asFloat) {
	        var that, zoneDelta, output;

	        if (!this.isValid()) {
	          return NaN;
	        }

	        that = cloneWithOffset(input, this);

	        if (!that.isValid()) {
	          return NaN;
	        }

	        zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;
	        units = normalizeUnits(units);

	        switch (units) {
	          case 'year':
	            output = monthDiff(this, that) / 12;
	            break;

	          case 'month':
	            output = monthDiff(this, that);
	            break;

	          case 'quarter':
	            output = monthDiff(this, that) / 3;
	            break;

	          case 'second':
	            output = (this - that) / 1e3;
	            break;
	          // 1000

	          case 'minute':
	            output = (this - that) / 6e4;
	            break;
	          // 1000 * 60

	          case 'hour':
	            output = (this - that) / 36e5;
	            break;
	          // 1000 * 60 * 60

	          case 'day':
	            output = (this - that - zoneDelta) / 864e5;
	            break;
	          // 1000 * 60 * 60 * 24, negate dst

	          case 'week':
	            output = (this - that - zoneDelta) / 6048e5;
	            break;
	          // 1000 * 60 * 60 * 24 * 7, negate dst

	          default:
	            output = this - that;
	        }

	        return asFloat ? output : absFloor(output);
	      }

	      function monthDiff(a, b) {
	        if (a.date() < b.date()) {
	          // end-of-month calculations work correct when the start month has more
	          // days than the end month.
	          return -monthDiff(b, a);
	        } // difference in months


	        var wholeMonthDiff = (b.year() - a.year()) * 12 + (b.month() - a.month()),
	            // b is in (anchor - 1 month, anchor + 1 month)
	        anchor = a.clone().add(wholeMonthDiff, 'months'),
	            anchor2,
	            adjust;

	        if (b - anchor < 0) {
	          anchor2 = a.clone().add(wholeMonthDiff - 1, 'months'); // linear across the month

	          adjust = (b - anchor) / (anchor - anchor2);
	        } else {
	          anchor2 = a.clone().add(wholeMonthDiff + 1, 'months'); // linear across the month

	          adjust = (b - anchor) / (anchor2 - anchor);
	        } //check for negative zero, return zero if negative zero


	        return -(wholeMonthDiff + adjust) || 0;
	      }

	      hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
	      hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

	      function toString() {
	        return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
	      }

	      function toISOString(keepOffset) {
	        if (!this.isValid()) {
	          return null;
	        }

	        var utc = keepOffset !== true,
	            m = utc ? this.clone().utc() : this;

	        if (m.year() < 0 || m.year() > 9999) {
	          return formatMoment(m, utc ? 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');
	        }

	        if (isFunction(Date.prototype.toISOString)) {
	          // native implementation is ~50x faster, use it when we can
	          if (utc) {
	            return this.toDate().toISOString();
	          } else {
	            return new Date(this.valueOf() + this.utcOffset() * 60 * 1000).toISOString().replace('Z', formatMoment(m, 'Z'));
	          }
	        }

	        return formatMoment(m, utc ? 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYY-MM-DD[T]HH:mm:ss.SSSZ');
	      }
	      /**
	       * Return a human readable representation of a moment that can
	       * also be evaluated to get a new moment which is the same
	       *
	       * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
	       */


	      function inspect() {
	        if (!this.isValid()) {
	          return 'moment.invalid(/* ' + this._i + ' */)';
	        }

	        var func = 'moment',
	            zone = '',
	            prefix,
	            year,
	            datetime,
	            suffix;

	        if (!this.isLocal()) {
	          func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
	          zone = 'Z';
	        }

	        prefix = '[' + func + '("]';
	        year = 0 <= this.year() && this.year() <= 9999 ? 'YYYY' : 'YYYYYY';
	        datetime = '-MM-DD[T]HH:mm:ss.SSS';
	        suffix = zone + '[")]';
	        return this.format(prefix + year + datetime + suffix);
	      }

	      function format(inputString) {
	        if (!inputString) {
	          inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
	        }

	        var output = formatMoment(this, inputString);
	        return this.localeData().postformat(output);
	      }

	      function from(time, withoutSuffix) {
	        if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
	          return createDuration({
	            to: this,
	            from: time
	          }).locale(this.locale()).humanize(!withoutSuffix);
	        } else {
	          return this.localeData().invalidDate();
	        }
	      }

	      function fromNow(withoutSuffix) {
	        return this.from(createLocal(), withoutSuffix);
	      }

	      function to(time, withoutSuffix) {
	        if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
	          return createDuration({
	            from: this,
	            to: time
	          }).locale(this.locale()).humanize(!withoutSuffix);
	        } else {
	          return this.localeData().invalidDate();
	        }
	      }

	      function toNow(withoutSuffix) {
	        return this.to(createLocal(), withoutSuffix);
	      } // If passed a locale key, it will set the locale for this
	      // instance.  Otherwise, it will return the locale configuration
	      // variables for this instance.


	      function locale(key) {
	        var newLocaleData;

	        if (key === undefined) {
	          return this._locale._abbr;
	        } else {
	          newLocaleData = getLocale(key);

	          if (newLocaleData != null) {
	            this._locale = newLocaleData;
	          }

	          return this;
	        }
	      }

	      var lang = deprecate('moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.', function (key) {
	        if (key === undefined) {
	          return this.localeData();
	        } else {
	          return this.locale(key);
	        }
	      });

	      function localeData() {
	        return this._locale;
	      }

	      var MS_PER_SECOND = 1000,
	          MS_PER_MINUTE = 60 * MS_PER_SECOND,
	          MS_PER_HOUR = 60 * MS_PER_MINUTE,
	          MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR; // actual modulo - handles negative numbers (for dates before 1970):

	      function mod$1(dividend, divisor) {
	        return (dividend % divisor + divisor) % divisor;
	      }

	      function localStartOfDate(y, m, d) {
	        // the date constructor remaps years 0-99 to 1900-1999
	        if (y < 100 && y >= 0) {
	          // preserve leap years using a full 400 year cycle, then reset
	          return new Date(y + 400, m, d) - MS_PER_400_YEARS;
	        } else {
	          return new Date(y, m, d).valueOf();
	        }
	      }

	      function utcStartOfDate(y, m, d) {
	        // Date.UTC remaps years 0-99 to 1900-1999
	        if (y < 100 && y >= 0) {
	          // preserve leap years using a full 400 year cycle, then reset
	          return Date.UTC(y + 400, m, d) - MS_PER_400_YEARS;
	        } else {
	          return Date.UTC(y, m, d);
	        }
	      }

	      function startOf(units) {
	        var time, startOfDate;
	        units = normalizeUnits(units);

	        if (units === undefined || units === 'millisecond' || !this.isValid()) {
	          return this;
	        }

	        startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

	        switch (units) {
	          case 'year':
	            time = startOfDate(this.year(), 0, 1);
	            break;

	          case 'quarter':
	            time = startOfDate(this.year(), this.month() - this.month() % 3, 1);
	            break;

	          case 'month':
	            time = startOfDate(this.year(), this.month(), 1);
	            break;

	          case 'week':
	            time = startOfDate(this.year(), this.month(), this.date() - this.weekday());
	            break;

	          case 'isoWeek':
	            time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1));
	            break;

	          case 'day':
	          case 'date':
	            time = startOfDate(this.year(), this.month(), this.date());
	            break;

	          case 'hour':
	            time = this._d.valueOf();
	            time -= mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR);
	            break;

	          case 'minute':
	            time = this._d.valueOf();
	            time -= mod$1(time, MS_PER_MINUTE);
	            break;

	          case 'second':
	            time = this._d.valueOf();
	            time -= mod$1(time, MS_PER_SECOND);
	            break;
	        }

	        this._d.setTime(time);

	        hooks.updateOffset(this, true);
	        return this;
	      }

	      function endOf(units) {
	        var time, startOfDate;
	        units = normalizeUnits(units);

	        if (units === undefined || units === 'millisecond' || !this.isValid()) {
	          return this;
	        }

	        startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

	        switch (units) {
	          case 'year':
	            time = startOfDate(this.year() + 1, 0, 1) - 1;
	            break;

	          case 'quarter':
	            time = startOfDate(this.year(), this.month() - this.month() % 3 + 3, 1) - 1;
	            break;

	          case 'month':
	            time = startOfDate(this.year(), this.month() + 1, 1) - 1;
	            break;

	          case 'week':
	            time = startOfDate(this.year(), this.month(), this.date() - this.weekday() + 7) - 1;
	            break;

	          case 'isoWeek':
	            time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1) + 7) - 1;
	            break;

	          case 'day':
	          case 'date':
	            time = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
	            break;

	          case 'hour':
	            time = this._d.valueOf();
	            time += MS_PER_HOUR - mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR) - 1;
	            break;

	          case 'minute':
	            time = this._d.valueOf();
	            time += MS_PER_MINUTE - mod$1(time, MS_PER_MINUTE) - 1;
	            break;

	          case 'second':
	            time = this._d.valueOf();
	            time += MS_PER_SECOND - mod$1(time, MS_PER_SECOND) - 1;
	            break;
	        }

	        this._d.setTime(time);

	        hooks.updateOffset(this, true);
	        return this;
	      }

	      function valueOf() {
	        return this._d.valueOf() - (this._offset || 0) * 60000;
	      }

	      function unix() {
	        return Math.floor(this.valueOf() / 1000);
	      }

	      function toDate() {
	        return new Date(this.valueOf());
	      }

	      function toArray() {
	        var m = this;
	        return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
	      }

	      function toObject() {
	        var m = this;
	        return {
	          years: m.year(),
	          months: m.month(),
	          date: m.date(),
	          hours: m.hours(),
	          minutes: m.minutes(),
	          seconds: m.seconds(),
	          milliseconds: m.milliseconds()
	        };
	      }

	      function toJSON() {
	        // new Date(NaN).toJSON() === null
	        return this.isValid() ? this.toISOString() : null;
	      }

	      function isValid$2() {
	        return isValid(this);
	      }

	      function parsingFlags() {
	        return extend({}, getParsingFlags(this));
	      }

	      function invalidAt() {
	        return getParsingFlags(this).overflow;
	      }

	      function creationData() {
	        return {
	          input: this._i,
	          format: this._f,
	          locale: this._locale,
	          isUTC: this._isUTC,
	          strict: this._strict
	        };
	      }

	      addFormatToken('N', 0, 0, 'eraAbbr');
	      addFormatToken('NN', 0, 0, 'eraAbbr');
	      addFormatToken('NNN', 0, 0, 'eraAbbr');
	      addFormatToken('NNNN', 0, 0, 'eraName');
	      addFormatToken('NNNNN', 0, 0, 'eraNarrow');
	      addFormatToken('y', ['y', 1], 'yo', 'eraYear');
	      addFormatToken('y', ['yy', 2], 0, 'eraYear');
	      addFormatToken('y', ['yyy', 3], 0, 'eraYear');
	      addFormatToken('y', ['yyyy', 4], 0, 'eraYear');
	      addRegexToken('N', matchEraAbbr);
	      addRegexToken('NN', matchEraAbbr);
	      addRegexToken('NNN', matchEraAbbr);
	      addRegexToken('NNNN', matchEraName);
	      addRegexToken('NNNNN', matchEraNarrow);
	      addParseToken(['N', 'NN', 'NNN', 'NNNN', 'NNNNN'], function (input, array, config, token) {
	        var era = config._locale.erasParse(input, token, config._strict);

	        if (era) {
	          getParsingFlags(config).era = era;
	        } else {
	          getParsingFlags(config).invalidEra = input;
	        }
	      });
	      addRegexToken('y', matchUnsigned);
	      addRegexToken('yy', matchUnsigned);
	      addRegexToken('yyy', matchUnsigned);
	      addRegexToken('yyyy', matchUnsigned);
	      addRegexToken('yo', matchEraYearOrdinal);
	      addParseToken(['y', 'yy', 'yyy', 'yyyy'], YEAR);
	      addParseToken(['yo'], function (input, array, config, token) {
	        var match;

	        if (config._locale._eraYearOrdinalRegex) {
	          match = input.match(config._locale._eraYearOrdinalRegex);
	        }

	        if (config._locale.eraYearOrdinalParse) {
	          array[YEAR] = config._locale.eraYearOrdinalParse(input, match);
	        } else {
	          array[YEAR] = parseInt(input, 10);
	        }
	      });

	      function localeEras(m, format) {
	        var i,
	            l,
	            date,
	            eras = this._eras || getLocale('en')._eras;

	        for (i = 0, l = eras.length; i < l; ++i) {
	          switch (typeof eras[i].since) {
	            case 'string':
	              // truncate time
	              date = hooks(eras[i].since).startOf('day');
	              eras[i].since = date.valueOf();
	              break;
	          }

	          switch (typeof eras[i].until) {
	            case 'undefined':
	              eras[i].until = +Infinity;
	              break;

	            case 'string':
	              // truncate time
	              date = hooks(eras[i].until).startOf('day').valueOf();
	              eras[i].until = date.valueOf();
	              break;
	          }
	        }

	        return eras;
	      }

	      function localeErasParse(eraName, format, strict) {
	        var i,
	            l,
	            eras = this.eras(),
	            name,
	            abbr,
	            narrow;
	        eraName = eraName.toUpperCase();

	        for (i = 0, l = eras.length; i < l; ++i) {
	          name = eras[i].name.toUpperCase();
	          abbr = eras[i].abbr.toUpperCase();
	          narrow = eras[i].narrow.toUpperCase();

	          if (strict) {
	            switch (format) {
	              case 'N':
	              case 'NN':
	              case 'NNN':
	                if (abbr === eraName) {
	                  return eras[i];
	                }

	                break;

	              case 'NNNN':
	                if (name === eraName) {
	                  return eras[i];
	                }

	                break;

	              case 'NNNNN':
	                if (narrow === eraName) {
	                  return eras[i];
	                }

	                break;
	            }
	          } else if ([name, abbr, narrow].indexOf(eraName) >= 0) {
	            return eras[i];
	          }
	        }
	      }

	      function localeErasConvertYear(era, year) {
	        var dir = era.since <= era.until ? +1 : -1;

	        if (year === undefined) {
	          return hooks(era.since).year();
	        } else {
	          return hooks(era.since).year() + (year - era.offset) * dir;
	        }
	      }

	      function getEraName() {
	        var i,
	            l,
	            val,
	            eras = this.localeData().eras();

	        for (i = 0, l = eras.length; i < l; ++i) {
	          // truncate time
	          val = this.clone().startOf('day').valueOf();

	          if (eras[i].since <= val && val <= eras[i].until) {
	            return eras[i].name;
	          }

	          if (eras[i].until <= val && val <= eras[i].since) {
	            return eras[i].name;
	          }
	        }

	        return '';
	      }

	      function getEraNarrow() {
	        var i,
	            l,
	            val,
	            eras = this.localeData().eras();

	        for (i = 0, l = eras.length; i < l; ++i) {
	          // truncate time
	          val = this.clone().startOf('day').valueOf();

	          if (eras[i].since <= val && val <= eras[i].until) {
	            return eras[i].narrow;
	          }

	          if (eras[i].until <= val && val <= eras[i].since) {
	            return eras[i].narrow;
	          }
	        }

	        return '';
	      }

	      function getEraAbbr() {
	        var i,
	            l,
	            val,
	            eras = this.localeData().eras();

	        for (i = 0, l = eras.length; i < l; ++i) {
	          // truncate time
	          val = this.clone().startOf('day').valueOf();

	          if (eras[i].since <= val && val <= eras[i].until) {
	            return eras[i].abbr;
	          }

	          if (eras[i].until <= val && val <= eras[i].since) {
	            return eras[i].abbr;
	          }
	        }

	        return '';
	      }

	      function getEraYear() {
	        var i,
	            l,
	            dir,
	            val,
	            eras = this.localeData().eras();

	        for (i = 0, l = eras.length; i < l; ++i) {
	          dir = eras[i].since <= eras[i].until ? +1 : -1; // truncate time

	          val = this.clone().startOf('day').valueOf();

	          if (eras[i].since <= val && val <= eras[i].until || eras[i].until <= val && val <= eras[i].since) {
	            return (this.year() - hooks(eras[i].since).year()) * dir + eras[i].offset;
	          }
	        }

	        return this.year();
	      }

	      function erasNameRegex(isStrict) {
	        if (!hasOwnProp(this, '_erasNameRegex')) {
	          computeErasParse.call(this);
	        }

	        return isStrict ? this._erasNameRegex : this._erasRegex;
	      }

	      function erasAbbrRegex(isStrict) {
	        if (!hasOwnProp(this, '_erasAbbrRegex')) {
	          computeErasParse.call(this);
	        }

	        return isStrict ? this._erasAbbrRegex : this._erasRegex;
	      }

	      function erasNarrowRegex(isStrict) {
	        if (!hasOwnProp(this, '_erasNarrowRegex')) {
	          computeErasParse.call(this);
	        }

	        return isStrict ? this._erasNarrowRegex : this._erasRegex;
	      }

	      function matchEraAbbr(isStrict, locale) {
	        return locale.erasAbbrRegex(isStrict);
	      }

	      function matchEraName(isStrict, locale) {
	        return locale.erasNameRegex(isStrict);
	      }

	      function matchEraNarrow(isStrict, locale) {
	        return locale.erasNarrowRegex(isStrict);
	      }

	      function matchEraYearOrdinal(isStrict, locale) {
	        return locale._eraYearOrdinalRegex || matchUnsigned;
	      }

	      function computeErasParse() {
	        var abbrPieces = [],
	            namePieces = [],
	            narrowPieces = [],
	            mixedPieces = [],
	            i,
	            l,
	            eras = this.eras();

	        for (i = 0, l = eras.length; i < l; ++i) {
	          namePieces.push(regexEscape(eras[i].name));
	          abbrPieces.push(regexEscape(eras[i].abbr));
	          narrowPieces.push(regexEscape(eras[i].narrow));
	          mixedPieces.push(regexEscape(eras[i].name));
	          mixedPieces.push(regexEscape(eras[i].abbr));
	          mixedPieces.push(regexEscape(eras[i].narrow));
	        }

	        this._erasRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	        this._erasNameRegex = new RegExp('^(' + namePieces.join('|') + ')', 'i');
	        this._erasAbbrRegex = new RegExp('^(' + abbrPieces.join('|') + ')', 'i');
	        this._erasNarrowRegex = new RegExp('^(' + narrowPieces.join('|') + ')', 'i');
	      } // FORMATTING


	      addFormatToken(0, ['gg', 2], 0, function () {
	        return this.weekYear() % 100;
	      });
	      addFormatToken(0, ['GG', 2], 0, function () {
	        return this.isoWeekYear() % 100;
	      });

	      function addWeekYearFormatToken(token, getter) {
	        addFormatToken(0, [token, token.length], 0, getter);
	      }

	      addWeekYearFormatToken('gggg', 'weekYear');
	      addWeekYearFormatToken('ggggg', 'weekYear');
	      addWeekYearFormatToken('GGGG', 'isoWeekYear');
	      addWeekYearFormatToken('GGGGG', 'isoWeekYear'); // ALIASES

	      addUnitAlias('weekYear', 'gg');
	      addUnitAlias('isoWeekYear', 'GG'); // PRIORITY

	      addUnitPriority('weekYear', 1);
	      addUnitPriority('isoWeekYear', 1); // PARSING

	      addRegexToken('G', matchSigned);
	      addRegexToken('g', matchSigned);
	      addRegexToken('GG', match1to2, match2);
	      addRegexToken('gg', match1to2, match2);
	      addRegexToken('GGGG', match1to4, match4);
	      addRegexToken('gggg', match1to4, match4);
	      addRegexToken('GGGGG', match1to6, match6);
	      addRegexToken('ggggg', match1to6, match6);
	      addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
	        week[token.substr(0, 2)] = toInt(input);
	      });
	      addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
	        week[token] = hooks.parseTwoDigitYear(input);
	      }); // MOMENTS

	      function getSetWeekYear(input) {
	        return getSetWeekYearHelper.call(this, input, this.week(), this.weekday(), this.localeData()._week.dow, this.localeData()._week.doy);
	      }

	      function getSetISOWeekYear(input) {
	        return getSetWeekYearHelper.call(this, input, this.isoWeek(), this.isoWeekday(), 1, 4);
	      }

	      function getISOWeeksInYear() {
	        return weeksInYear(this.year(), 1, 4);
	      }

	      function getISOWeeksInISOWeekYear() {
	        return weeksInYear(this.isoWeekYear(), 1, 4);
	      }

	      function getWeeksInYear() {
	        var weekInfo = this.localeData()._week;

	        return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
	      }

	      function getWeeksInWeekYear() {
	        var weekInfo = this.localeData()._week;

	        return weeksInYear(this.weekYear(), weekInfo.dow, weekInfo.doy);
	      }

	      function getSetWeekYearHelper(input, week, weekday, dow, doy) {
	        var weeksTarget;

	        if (input == null) {
	          return weekOfYear(this, dow, doy).year;
	        } else {
	          weeksTarget = weeksInYear(input, dow, doy);

	          if (week > weeksTarget) {
	            week = weeksTarget;
	          }

	          return setWeekAll.call(this, input, week, weekday, dow, doy);
	        }
	      }

	      function setWeekAll(weekYear, week, weekday, dow, doy) {
	        var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
	            date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);
	        this.year(date.getUTCFullYear());
	        this.month(date.getUTCMonth());
	        this.date(date.getUTCDate());
	        return this;
	      } // FORMATTING


	      addFormatToken('Q', 0, 'Qo', 'quarter'); // ALIASES

	      addUnitAlias('quarter', 'Q'); // PRIORITY

	      addUnitPriority('quarter', 7); // PARSING

	      addRegexToken('Q', match1);
	      addParseToken('Q', function (input, array) {
	        array[MONTH] = (toInt(input) - 1) * 3;
	      }); // MOMENTS

	      function getSetQuarter(input) {
	        return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
	      } // FORMATTING


	      addFormatToken('D', ['DD', 2], 'Do', 'date'); // ALIASES

	      addUnitAlias('date', 'D'); // PRIORITY

	      addUnitPriority('date', 9); // PARSING

	      addRegexToken('D', match1to2);
	      addRegexToken('DD', match1to2, match2);
	      addRegexToken('Do', function (isStrict, locale) {
	        // TODO: Remove "ordinalParse" fallback in next major release.
	        return isStrict ? locale._dayOfMonthOrdinalParse || locale._ordinalParse : locale._dayOfMonthOrdinalParseLenient;
	      });
	      addParseToken(['D', 'DD'], DATE);
	      addParseToken('Do', function (input, array) {
	        array[DATE] = toInt(input.match(match1to2)[0]);
	      }); // MOMENTS

	      var getSetDayOfMonth = makeGetSet('Date', true); // FORMATTING

	      addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear'); // ALIASES

	      addUnitAlias('dayOfYear', 'DDD'); // PRIORITY

	      addUnitPriority('dayOfYear', 4); // PARSING

	      addRegexToken('DDD', match1to3);
	      addRegexToken('DDDD', match3);
	      addParseToken(['DDD', 'DDDD'], function (input, array, config) {
	        config._dayOfYear = toInt(input);
	      }); // HELPERS
	      // MOMENTS

	      function getSetDayOfYear(input) {
	        var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
	        return input == null ? dayOfYear : this.add(input - dayOfYear, 'd');
	      } // FORMATTING


	      addFormatToken('m', ['mm', 2], 0, 'minute'); // ALIASES

	      addUnitAlias('minute', 'm'); // PRIORITY

	      addUnitPriority('minute', 14); // PARSING

	      addRegexToken('m', match1to2);
	      addRegexToken('mm', match1to2, match2);
	      addParseToken(['m', 'mm'], MINUTE); // MOMENTS

	      var getSetMinute = makeGetSet('Minutes', false); // FORMATTING

	      addFormatToken('s', ['ss', 2], 0, 'second'); // ALIASES

	      addUnitAlias('second', 's'); // PRIORITY

	      addUnitPriority('second', 15); // PARSING

	      addRegexToken('s', match1to2);
	      addRegexToken('ss', match1to2, match2);
	      addParseToken(['s', 'ss'], SECOND); // MOMENTS

	      var getSetSecond = makeGetSet('Seconds', false); // FORMATTING

	      addFormatToken('S', 0, 0, function () {
	        return ~~(this.millisecond() / 100);
	      });
	      addFormatToken(0, ['SS', 2], 0, function () {
	        return ~~(this.millisecond() / 10);
	      });
	      addFormatToken(0, ['SSS', 3], 0, 'millisecond');
	      addFormatToken(0, ['SSSS', 4], 0, function () {
	        return this.millisecond() * 10;
	      });
	      addFormatToken(0, ['SSSSS', 5], 0, function () {
	        return this.millisecond() * 100;
	      });
	      addFormatToken(0, ['SSSSSS', 6], 0, function () {
	        return this.millisecond() * 1000;
	      });
	      addFormatToken(0, ['SSSSSSS', 7], 0, function () {
	        return this.millisecond() * 10000;
	      });
	      addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
	        return this.millisecond() * 100000;
	      });
	      addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
	        return this.millisecond() * 1000000;
	      }); // ALIASES

	      addUnitAlias('millisecond', 'ms'); // PRIORITY

	      addUnitPriority('millisecond', 16); // PARSING

	      addRegexToken('S', match1to3, match1);
	      addRegexToken('SS', match1to3, match2);
	      addRegexToken('SSS', match1to3, match3);
	      var token, getSetMillisecond;

	      for (token = 'SSSS'; token.length <= 9; token += 'S') {
	        addRegexToken(token, matchUnsigned);
	      }

	      function parseMs(input, array) {
	        array[MILLISECOND] = toInt(('0.' + input) * 1000);
	      }

	      for (token = 'S'; token.length <= 9; token += 'S') {
	        addParseToken(token, parseMs);
	      }

	      getSetMillisecond = makeGetSet('Milliseconds', false); // FORMATTING

	      addFormatToken('z', 0, 0, 'zoneAbbr');
	      addFormatToken('zz', 0, 0, 'zoneName'); // MOMENTS

	      function getZoneAbbr() {
	        return this._isUTC ? 'UTC' : '';
	      }

	      function getZoneName() {
	        return this._isUTC ? 'Coordinated Universal Time' : '';
	      }

	      var proto = Moment.prototype;
	      proto.add = add;
	      proto.calendar = calendar$1;
	      proto.clone = clone;
	      proto.diff = diff;
	      proto.endOf = endOf;
	      proto.format = format;
	      proto.from = from;
	      proto.fromNow = fromNow;
	      proto.to = to;
	      proto.toNow = toNow;
	      proto.get = stringGet;
	      proto.invalidAt = invalidAt;
	      proto.isAfter = isAfter;
	      proto.isBefore = isBefore;
	      proto.isBetween = isBetween;
	      proto.isSame = isSame;
	      proto.isSameOrAfter = isSameOrAfter;
	      proto.isSameOrBefore = isSameOrBefore;
	      proto.isValid = isValid$2;
	      proto.lang = lang;
	      proto.locale = locale;
	      proto.localeData = localeData;
	      proto.max = prototypeMax;
	      proto.min = prototypeMin;
	      proto.parsingFlags = parsingFlags;
	      proto.set = stringSet;
	      proto.startOf = startOf;
	      proto.subtract = subtract;
	      proto.toArray = toArray;
	      proto.toObject = toObject;
	      proto.toDate = toDate;
	      proto.toISOString = toISOString;
	      proto.inspect = inspect;

	      if (typeof Symbol !== 'undefined' && Symbol.for != null) {
	        proto[Symbol.for('nodejs.util.inspect.custom')] = function () {
	          return 'Moment<' + this.format() + '>';
	        };
	      }

	      proto.toJSON = toJSON;
	      proto.toString = toString;
	      proto.unix = unix;
	      proto.valueOf = valueOf;
	      proto.creationData = creationData;
	      proto.eraName = getEraName;
	      proto.eraNarrow = getEraNarrow;
	      proto.eraAbbr = getEraAbbr;
	      proto.eraYear = getEraYear;
	      proto.year = getSetYear;
	      proto.isLeapYear = getIsLeapYear;
	      proto.weekYear = getSetWeekYear;
	      proto.isoWeekYear = getSetISOWeekYear;
	      proto.quarter = proto.quarters = getSetQuarter;
	      proto.month = getSetMonth;
	      proto.daysInMonth = getDaysInMonth;
	      proto.week = proto.weeks = getSetWeek;
	      proto.isoWeek = proto.isoWeeks = getSetISOWeek;
	      proto.weeksInYear = getWeeksInYear;
	      proto.weeksInWeekYear = getWeeksInWeekYear;
	      proto.isoWeeksInYear = getISOWeeksInYear;
	      proto.isoWeeksInISOWeekYear = getISOWeeksInISOWeekYear;
	      proto.date = getSetDayOfMonth;
	      proto.day = proto.days = getSetDayOfWeek;
	      proto.weekday = getSetLocaleDayOfWeek;
	      proto.isoWeekday = getSetISODayOfWeek;
	      proto.dayOfYear = getSetDayOfYear;
	      proto.hour = proto.hours = getSetHour;
	      proto.minute = proto.minutes = getSetMinute;
	      proto.second = proto.seconds = getSetSecond;
	      proto.millisecond = proto.milliseconds = getSetMillisecond;
	      proto.utcOffset = getSetOffset;
	      proto.utc = setOffsetToUTC;
	      proto.local = setOffsetToLocal;
	      proto.parseZone = setOffsetToParsedOffset;
	      proto.hasAlignedHourOffset = hasAlignedHourOffset;
	      proto.isDST = isDaylightSavingTime;
	      proto.isLocal = isLocal;
	      proto.isUtcOffset = isUtcOffset;
	      proto.isUtc = isUtc;
	      proto.isUTC = isUtc;
	      proto.zoneAbbr = getZoneAbbr;
	      proto.zoneName = getZoneName;
	      proto.dates = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
	      proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
	      proto.years = deprecate('years accessor is deprecated. Use year instead', getSetYear);
	      proto.zone = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
	      proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);

	      function createUnix(input) {
	        return createLocal(input * 1000);
	      }

	      function createInZone() {
	        return createLocal.apply(null, arguments).parseZone();
	      }

	      function preParsePostFormat(string) {
	        return string;
	      }

	      var proto$1 = Locale.prototype;
	      proto$1.calendar = calendar;
	      proto$1.longDateFormat = longDateFormat;
	      proto$1.invalidDate = invalidDate;
	      proto$1.ordinal = ordinal;
	      proto$1.preparse = preParsePostFormat;
	      proto$1.postformat = preParsePostFormat;
	      proto$1.relativeTime = relativeTime;
	      proto$1.pastFuture = pastFuture;
	      proto$1.set = set;
	      proto$1.eras = localeEras;
	      proto$1.erasParse = localeErasParse;
	      proto$1.erasConvertYear = localeErasConvertYear;
	      proto$1.erasAbbrRegex = erasAbbrRegex;
	      proto$1.erasNameRegex = erasNameRegex;
	      proto$1.erasNarrowRegex = erasNarrowRegex;
	      proto$1.months = localeMonths;
	      proto$1.monthsShort = localeMonthsShort;
	      proto$1.monthsParse = localeMonthsParse;
	      proto$1.monthsRegex = monthsRegex;
	      proto$1.monthsShortRegex = monthsShortRegex;
	      proto$1.week = localeWeek;
	      proto$1.firstDayOfYear = localeFirstDayOfYear;
	      proto$1.firstDayOfWeek = localeFirstDayOfWeek;
	      proto$1.weekdays = localeWeekdays;
	      proto$1.weekdaysMin = localeWeekdaysMin;
	      proto$1.weekdaysShort = localeWeekdaysShort;
	      proto$1.weekdaysParse = localeWeekdaysParse;
	      proto$1.weekdaysRegex = weekdaysRegex;
	      proto$1.weekdaysShortRegex = weekdaysShortRegex;
	      proto$1.weekdaysMinRegex = weekdaysMinRegex;
	      proto$1.isPM = localeIsPM;
	      proto$1.meridiem = localeMeridiem;

	      function get$1(format, index, field, setter) {
	        var locale = getLocale(),
	            utc = createUTC().set(setter, index);
	        return locale[field](utc, format);
	      }

	      function listMonthsImpl(format, index, field) {
	        if (isNumber(format)) {
	          index = format;
	          format = undefined;
	        }

	        format = format || '';

	        if (index != null) {
	          return get$1(format, index, field, 'month');
	        }

	        var i,
	            out = [];

	        for (i = 0; i < 12; i++) {
	          out[i] = get$1(format, i, field, 'month');
	        }

	        return out;
	      } // ()
	      // (5)
	      // (fmt, 5)
	      // (fmt)
	      // (true)
	      // (true, 5)
	      // (true, fmt, 5)
	      // (true, fmt)


	      function listWeekdaysImpl(localeSorted, format, index, field) {
	        if (typeof localeSorted === 'boolean') {
	          if (isNumber(format)) {
	            index = format;
	            format = undefined;
	          }

	          format = format || '';
	        } else {
	          format = localeSorted;
	          index = format;
	          localeSorted = false;

	          if (isNumber(format)) {
	            index = format;
	            format = undefined;
	          }

	          format = format || '';
	        }

	        var locale = getLocale(),
	            shift = localeSorted ? locale._week.dow : 0,
	            i,
	            out = [];

	        if (index != null) {
	          return get$1(format, (index + shift) % 7, field, 'day');
	        }

	        for (i = 0; i < 7; i++) {
	          out[i] = get$1(format, (i + shift) % 7, field, 'day');
	        }

	        return out;
	      }

	      function listMonths(format, index) {
	        return listMonthsImpl(format, index, 'months');
	      }

	      function listMonthsShort(format, index) {
	        return listMonthsImpl(format, index, 'monthsShort');
	      }

	      function listWeekdays(localeSorted, format, index) {
	        return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
	      }

	      function listWeekdaysShort(localeSorted, format, index) {
	        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
	      }

	      function listWeekdaysMin(localeSorted, format, index) {
	        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
	      }

	      getSetGlobalLocale('en', {
	        eras: [{
	          since: '0001-01-01',
	          until: +Infinity,
	          offset: 1,
	          name: 'Anno Domini',
	          narrow: 'AD',
	          abbr: 'AD'
	        }, {
	          since: '0000-12-31',
	          until: -Infinity,
	          offset: 1,
	          name: 'Before Christ',
	          narrow: 'BC',
	          abbr: 'BC'
	        }],
	        dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
	        ordinal: function (number) {
	          var b = number % 10,
	              output = toInt(number % 100 / 10) === 1 ? 'th' : b === 1 ? 'st' : b === 2 ? 'nd' : b === 3 ? 'rd' : 'th';
	          return number + output;
	        }
	      }); // Side effect imports

	      hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
	      hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);
	      var mathAbs = Math.abs;

	      function abs() {
	        var data = this._data;
	        this._milliseconds = mathAbs(this._milliseconds);
	        this._days = mathAbs(this._days);
	        this._months = mathAbs(this._months);
	        data.milliseconds = mathAbs(data.milliseconds);
	        data.seconds = mathAbs(data.seconds);
	        data.minutes = mathAbs(data.minutes);
	        data.hours = mathAbs(data.hours);
	        data.months = mathAbs(data.months);
	        data.years = mathAbs(data.years);
	        return this;
	      }

	      function addSubtract$1(duration, input, value, direction) {
	        var other = createDuration(input, value);
	        duration._milliseconds += direction * other._milliseconds;
	        duration._days += direction * other._days;
	        duration._months += direction * other._months;
	        return duration._bubble();
	      } // supports only 2.0-style add(1, 's') or add(duration)


	      function add$1(input, value) {
	        return addSubtract$1(this, input, value, 1);
	      } // supports only 2.0-style subtract(1, 's') or subtract(duration)


	      function subtract$1(input, value) {
	        return addSubtract$1(this, input, value, -1);
	      }

	      function absCeil(number) {
	        if (number < 0) {
	          return Math.floor(number);
	        } else {
	          return Math.ceil(number);
	        }
	      }

	      function bubble() {
	        var milliseconds = this._milliseconds,
	            days = this._days,
	            months = this._months,
	            data = this._data,
	            seconds,
	            minutes,
	            hours,
	            years,
	            monthsFromDays; // if we have a mix of positive and negative values, bubble down first
	        // check: https://github.com/moment/moment/issues/2166

	        if (!(milliseconds >= 0 && days >= 0 && months >= 0 || milliseconds <= 0 && days <= 0 && months <= 0)) {
	          milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
	          days = 0;
	          months = 0;
	        } // The following code bubbles up values, see the tests for
	        // examples of what that means.


	        data.milliseconds = milliseconds % 1000;
	        seconds = absFloor(milliseconds / 1000);
	        data.seconds = seconds % 60;
	        minutes = absFloor(seconds / 60);
	        data.minutes = minutes % 60;
	        hours = absFloor(minutes / 60);
	        data.hours = hours % 24;
	        days += absFloor(hours / 24); // convert days to months

	        monthsFromDays = absFloor(daysToMonths(days));
	        months += monthsFromDays;
	        days -= absCeil(monthsToDays(monthsFromDays)); // 12 months -> 1 year

	        years = absFloor(months / 12);
	        months %= 12;
	        data.days = days;
	        data.months = months;
	        data.years = years;
	        return this;
	      }

	      function daysToMonths(days) {
	        // 400 years have 146097 days (taking into account leap year rules)
	        // 400 years have 12 months === 4800
	        return days * 4800 / 146097;
	      }

	      function monthsToDays(months) {
	        // the reverse of daysToMonths
	        return months * 146097 / 4800;
	      }

	      function as(units) {
	        if (!this.isValid()) {
	          return NaN;
	        }

	        var days,
	            months,
	            milliseconds = this._milliseconds;
	        units = normalizeUnits(units);

	        if (units === 'month' || units === 'quarter' || units === 'year') {
	          days = this._days + milliseconds / 864e5;
	          months = this._months + daysToMonths(days);

	          switch (units) {
	            case 'month':
	              return months;

	            case 'quarter':
	              return months / 3;

	            case 'year':
	              return months / 12;
	          }
	        } else {
	          // handle milliseconds separately because of floating point math errors (issue #1867)
	          days = this._days + Math.round(monthsToDays(this._months));

	          switch (units) {
	            case 'week':
	              return days / 7 + milliseconds / 6048e5;

	            case 'day':
	              return days + milliseconds / 864e5;

	            case 'hour':
	              return days * 24 + milliseconds / 36e5;

	            case 'minute':
	              return days * 1440 + milliseconds / 6e4;

	            case 'second':
	              return days * 86400 + milliseconds / 1000;
	            // Math.floor prevents floating point math errors here

	            case 'millisecond':
	              return Math.floor(days * 864e5) + milliseconds;

	            default:
	              throw new Error('Unknown unit ' + units);
	          }
	        }
	      } // TODO: Use this.as('ms')?


	      function valueOf$1() {
	        if (!this.isValid()) {
	          return NaN;
	        }

	        return this._milliseconds + this._days * 864e5 + this._months % 12 * 2592e6 + toInt(this._months / 12) * 31536e6;
	      }

	      function makeAs(alias) {
	        return function () {
	          return this.as(alias);
	        };
	      }

	      var asMilliseconds = makeAs('ms'),
	          asSeconds = makeAs('s'),
	          asMinutes = makeAs('m'),
	          asHours = makeAs('h'),
	          asDays = makeAs('d'),
	          asWeeks = makeAs('w'),
	          asMonths = makeAs('M'),
	          asQuarters = makeAs('Q'),
	          asYears = makeAs('y');

	      function clone$1() {
	        return createDuration(this);
	      }

	      function get$2(units) {
	        units = normalizeUnits(units);
	        return this.isValid() ? this[units + 's']() : NaN;
	      }

	      function makeGetter(name) {
	        return function () {
	          return this.isValid() ? this._data[name] : NaN;
	        };
	      }

	      var milliseconds = makeGetter('milliseconds'),
	          seconds = makeGetter('seconds'),
	          minutes = makeGetter('minutes'),
	          hours = makeGetter('hours'),
	          days = makeGetter('days'),
	          months = makeGetter('months'),
	          years = makeGetter('years');

	      function weeks() {
	        return absFloor(this.days() / 7);
	      }

	      var round = Math.round,
	          thresholds = {
	        ss: 44,
	        // a few seconds to seconds
	        s: 45,
	        // seconds to minute
	        m: 45,
	        // minutes to hour
	        h: 22,
	        // hours to day
	        d: 26,
	        // days to month/week
	        w: null,
	        // weeks to month
	        M: 11 // months to year

	      }; // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize

	      function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
	        return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
	      }

	      function relativeTime$1(posNegDuration, withoutSuffix, thresholds, locale) {
	        var duration = createDuration(posNegDuration).abs(),
	            seconds = round(duration.as('s')),
	            minutes = round(duration.as('m')),
	            hours = round(duration.as('h')),
	            days = round(duration.as('d')),
	            months = round(duration.as('M')),
	            weeks = round(duration.as('w')),
	            years = round(duration.as('y')),
	            a = seconds <= thresholds.ss && ['s', seconds] || seconds < thresholds.s && ['ss', seconds] || minutes <= 1 && ['m'] || minutes < thresholds.m && ['mm', minutes] || hours <= 1 && ['h'] || hours < thresholds.h && ['hh', hours] || days <= 1 && ['d'] || days < thresholds.d && ['dd', days];

	        if (thresholds.w != null) {
	          a = a || weeks <= 1 && ['w'] || weeks < thresholds.w && ['ww', weeks];
	        }

	        a = a || months <= 1 && ['M'] || months < thresholds.M && ['MM', months] || years <= 1 && ['y'] || ['yy', years];
	        a[2] = withoutSuffix;
	        a[3] = +posNegDuration > 0;
	        a[4] = locale;
	        return substituteTimeAgo.apply(null, a);
	      } // This function allows you to set the rounding function for relative time strings


	      function getSetRelativeTimeRounding(roundingFunction) {
	        if (roundingFunction === undefined) {
	          return round;
	        }

	        if (typeof roundingFunction === 'function') {
	          round = roundingFunction;
	          return true;
	        }

	        return false;
	      } // This function allows you to set a threshold for relative time strings


	      function getSetRelativeTimeThreshold(threshold, limit) {
	        if (thresholds[threshold] === undefined) {
	          return false;
	        }

	        if (limit === undefined) {
	          return thresholds[threshold];
	        }

	        thresholds[threshold] = limit;

	        if (threshold === 's') {
	          thresholds.ss = limit - 1;
	        }

	        return true;
	      }

	      function humanize(argWithSuffix, argThresholds) {
	        if (!this.isValid()) {
	          return this.localeData().invalidDate();
	        }

	        var withSuffix = false,
	            th = thresholds,
	            locale,
	            output;

	        if (typeof argWithSuffix === 'object') {
	          argThresholds = argWithSuffix;
	          argWithSuffix = false;
	        }

	        if (typeof argWithSuffix === 'boolean') {
	          withSuffix = argWithSuffix;
	        }

	        if (typeof argThresholds === 'object') {
	          th = Object.assign({}, thresholds, argThresholds);

	          if (argThresholds.s != null && argThresholds.ss == null) {
	            th.ss = argThresholds.s - 1;
	          }
	        }

	        locale = this.localeData();
	        output = relativeTime$1(this, !withSuffix, th, locale);

	        if (withSuffix) {
	          output = locale.pastFuture(+this, output);
	        }

	        return locale.postformat(output);
	      }

	      var abs$1 = Math.abs;

	      function sign(x) {
	        return (x > 0) - (x < 0) || +x;
	      }

	      function toISOString$1() {
	        // for ISO strings we do not use the normal bubbling rules:
	        //  * milliseconds bubble up until they become hours
	        //  * days do not bubble at all
	        //  * months bubble up until they become years
	        // This is because there is no context-free conversion between hours and days
	        // (think of clock changes)
	        // and also not between days and months (28-31 days per month)
	        if (!this.isValid()) {
	          return this.localeData().invalidDate();
	        }

	        var seconds = abs$1(this._milliseconds) / 1000,
	            days = abs$1(this._days),
	            months = abs$1(this._months),
	            minutes,
	            hours,
	            years,
	            s,
	            total = this.asSeconds(),
	            totalSign,
	            ymSign,
	            daysSign,
	            hmsSign;

	        if (!total) {
	          // this is the same as C#'s (Noda) and python (isodate)...
	          // but not other JS (goog.date)
	          return 'P0D';
	        } // 3600 seconds -> 60 minutes -> 1 hour


	        minutes = absFloor(seconds / 60);
	        hours = absFloor(minutes / 60);
	        seconds %= 60;
	        minutes %= 60; // 12 months -> 1 year

	        years = absFloor(months / 12);
	        months %= 12; // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js

	        s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, '') : '';
	        totalSign = total < 0 ? '-' : '';
	        ymSign = sign(this._months) !== sign(total) ? '-' : '';
	        daysSign = sign(this._days) !== sign(total) ? '-' : '';
	        hmsSign = sign(this._milliseconds) !== sign(total) ? '-' : '';
	        return totalSign + 'P' + (years ? ymSign + years + 'Y' : '') + (months ? ymSign + months + 'M' : '') + (days ? daysSign + days + 'D' : '') + (hours || minutes || seconds ? 'T' : '') + (hours ? hmsSign + hours + 'H' : '') + (minutes ? hmsSign + minutes + 'M' : '') + (seconds ? hmsSign + s + 'S' : '');
	      }

	      var proto$2 = Duration.prototype;
	      proto$2.isValid = isValid$1;
	      proto$2.abs = abs;
	      proto$2.add = add$1;
	      proto$2.subtract = subtract$1;
	      proto$2.as = as;
	      proto$2.asMilliseconds = asMilliseconds;
	      proto$2.asSeconds = asSeconds;
	      proto$2.asMinutes = asMinutes;
	      proto$2.asHours = asHours;
	      proto$2.asDays = asDays;
	      proto$2.asWeeks = asWeeks;
	      proto$2.asMonths = asMonths;
	      proto$2.asQuarters = asQuarters;
	      proto$2.asYears = asYears;
	      proto$2.valueOf = valueOf$1;
	      proto$2._bubble = bubble;
	      proto$2.clone = clone$1;
	      proto$2.get = get$2;
	      proto$2.milliseconds = milliseconds;
	      proto$2.seconds = seconds;
	      proto$2.minutes = minutes;
	      proto$2.hours = hours;
	      proto$2.days = days;
	      proto$2.weeks = weeks;
	      proto$2.months = months;
	      proto$2.years = years;
	      proto$2.humanize = humanize;
	      proto$2.toISOString = toISOString$1;
	      proto$2.toString = toISOString$1;
	      proto$2.toJSON = toISOString$1;
	      proto$2.locale = locale;
	      proto$2.localeData = localeData;
	      proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
	      proto$2.lang = lang; // FORMATTING

	      addFormatToken('X', 0, 0, 'unix');
	      addFormatToken('x', 0, 0, 'valueOf'); // PARSING

	      addRegexToken('x', matchSigned);
	      addRegexToken('X', matchTimestamp);
	      addParseToken('X', function (input, array, config) {
	        config._d = new Date(parseFloat(input) * 1000);
	      });
	      addParseToken('x', function (input, array, config) {
	        config._d = new Date(toInt(input));
	      }); //! moment.js

	      hooks.version = '2.29.4';
	      setHookCallback(createLocal);
	      hooks.fn = proto;
	      hooks.min = min;
	      hooks.max = max;
	      hooks.now = now;
	      hooks.utc = createUTC;
	      hooks.unix = createUnix;
	      hooks.months = listMonths;
	      hooks.isDate = isDate;
	      hooks.locale = getSetGlobalLocale;
	      hooks.invalid = createInvalid;
	      hooks.duration = createDuration;
	      hooks.isMoment = isMoment;
	      hooks.weekdays = listWeekdays;
	      hooks.parseZone = createInZone;
	      hooks.localeData = getLocale;
	      hooks.isDuration = isDuration;
	      hooks.monthsShort = listMonthsShort;
	      hooks.weekdaysMin = listWeekdaysMin;
	      hooks.defineLocale = defineLocale;
	      hooks.updateLocale = updateLocale;
	      hooks.locales = listLocales;
	      hooks.weekdaysShort = listWeekdaysShort;
	      hooks.normalizeUnits = normalizeUnits;
	      hooks.relativeTimeRounding = getSetRelativeTimeRounding;
	      hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
	      hooks.calendarFormat = getCalendarFormat;
	      hooks.prototype = proto; // currently HTML5 input type only supports 24-hour formats

	      hooks.HTML5_FMT = {
	        DATETIME_LOCAL: 'YYYY-MM-DDTHH:mm',
	        // <input type="datetime-local" />
	        DATETIME_LOCAL_SECONDS: 'YYYY-MM-DDTHH:mm:ss',
	        // <input type="datetime-local" step="1" />
	        DATETIME_LOCAL_MS: 'YYYY-MM-DDTHH:mm:ss.SSS',
	        // <input type="datetime-local" step="0.001" />
	        DATE: 'YYYY-MM-DD',
	        // <input type="date" />
	        TIME: 'HH:mm',
	        // <input type="time" />
	        TIME_SECONDS: 'HH:mm:ss',
	        // <input type="time" step="1" />
	        TIME_MS: 'HH:mm:ss.SSS',
	        // <input type="time" step="0.001" />
	        WEEK: 'GGGG-[W]WW',
	        // <input type="week" />
	        MONTH: 'YYYY-MM' // <input type="month" />

	      };
	      return hooks;
	    });
	  })(moment$3);

	  return moment$3.exports;
	}

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    function processRelativeTime(number, withoutSuffix, key, isFuture) {
	      var format = {
	        m: ['eine Minute', 'einer Minute'],
	        h: ['eine Stunde', 'einer Stunde'],
	        d: ['ein Tag', 'einem Tag'],
	        dd: [number + ' Tage', number + ' Tagen'],
	        w: ['eine Woche', 'einer Woche'],
	        M: ['ein Monat', 'einem Monat'],
	        MM: [number + ' Monate', number + ' Monaten'],
	        y: ['ein Jahr', 'einem Jahr'],
	        yy: [number + ' Jahre', number + ' Jahren']
	      };
	      return withoutSuffix ? format[key][0] : format[key][1];
	    }

	    var de = moment.defineLocale('de', {
	      months: 'Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),
	      monthsShort: 'Jan._Feb._März_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.'.split('_'),
	      monthsParseExact: true,
	      weekdays: 'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),
	      weekdaysShort: 'So._Mo._Di._Mi._Do._Fr._Sa.'.split('_'),
	      weekdaysMin: 'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),
	      weekdaysParseExact: true,
	      longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD.MM.YYYY',
	        LL: 'D. MMMM YYYY',
	        LLL: 'D. MMMM YYYY HH:mm',
	        LLLL: 'dddd, D. MMMM YYYY HH:mm'
	      },
	      calendar: {
	        sameDay: '[heute um] LT [Uhr]',
	        sameElse: 'L',
	        nextDay: '[morgen um] LT [Uhr]',
	        nextWeek: 'dddd [um] LT [Uhr]',
	        lastDay: '[gestern um] LT [Uhr]',
	        lastWeek: '[letzten] dddd [um] LT [Uhr]'
	      },
	      relativeTime: {
	        future: 'in %s',
	        past: 'vor %s',
	        s: 'ein paar Sekunden',
	        ss: '%d Sekunden',
	        m: processRelativeTime,
	        mm: '%d Minuten',
	        h: processRelativeTime,
	        hh: '%d Stunden',
	        d: processRelativeTime,
	        dd: processRelativeTime,
	        w: processRelativeTime,
	        ww: '%d Wochen',
	        M: processRelativeTime,
	        MM: processRelativeTime,
	        y: processRelativeTime,
	        yy: processRelativeTime
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}\./,
	      ordinal: '%d.',
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.

	      }
	    });
	    return de;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    var monthsShortDot = 'ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.'.split('_'),
	        monthsShort = 'ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic'.split('_'),
	        monthsParse = [/^ene/i, /^feb/i, /^mar/i, /^abr/i, /^may/i, /^jun/i, /^jul/i, /^ago/i, /^sep/i, /^oct/i, /^nov/i, /^dic/i],
	        monthsRegex = /^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;
	    var es = moment.defineLocale('es', {
	      months: 'enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre'.split('_'),
	      monthsShort: function (m, format) {
	        if (!m) {
	          return monthsShortDot;
	        } else if (/-MMM-/.test(format)) {
	          return monthsShort[m.month()];
	        } else {
	          return monthsShortDot[m.month()];
	        }
	      },
	      monthsRegex: monthsRegex,
	      monthsShortRegex: monthsRegex,
	      monthsStrictRegex: /^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,
	      monthsShortStrictRegex: /^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,
	      monthsParse: monthsParse,
	      longMonthsParse: monthsParse,
	      shortMonthsParse: monthsParse,
	      weekdays: 'domingo_lunes_martes_miércoles_jueves_viernes_sábado'.split('_'),
	      weekdaysShort: 'dom._lun._mar._mié._jue._vie._sáb.'.split('_'),
	      weekdaysMin: 'do_lu_ma_mi_ju_vi_sá'.split('_'),
	      weekdaysParseExact: true,
	      longDateFormat: {
	        LT: 'H:mm',
	        LTS: 'H:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D [de] MMMM [de] YYYY',
	        LLL: 'D [de] MMMM [de] YYYY H:mm',
	        LLLL: 'dddd, D [de] MMMM [de] YYYY H:mm'
	      },
	      calendar: {
	        sameDay: function () {
	          return '[hoy a la' + (this.hours() !== 1 ? 's' : '') + '] LT';
	        },
	        nextDay: function () {
	          return '[mañana a la' + (this.hours() !== 1 ? 's' : '') + '] LT';
	        },
	        nextWeek: function () {
	          return 'dddd [a la' + (this.hours() !== 1 ? 's' : '') + '] LT';
	        },
	        lastDay: function () {
	          return '[ayer a la' + (this.hours() !== 1 ? 's' : '') + '] LT';
	        },
	        lastWeek: function () {
	          return '[el] dddd [pasado a la' + (this.hours() !== 1 ? 's' : '') + '] LT';
	        },
	        sameElse: 'L'
	      },
	      relativeTime: {
	        future: 'en %s',
	        past: 'hace %s',
	        s: 'unos segundos',
	        ss: '%d segundos',
	        m: 'un minuto',
	        mm: '%d minutos',
	        h: 'una hora',
	        hh: '%d horas',
	        d: 'un día',
	        dd: '%d días',
	        w: 'una semana',
	        ww: '%d semanas',
	        M: 'un mes',
	        MM: '%d meses',
	        y: 'un año',
	        yy: '%d años'
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}º/,
	      ordinal: '%dº',
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.

	      },
	      invalidDate: 'Fecha inválida'
	    });
	    return es;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    var monthsStrictRegex = /^(janvier|février|mars|avril|mai|juin|juillet|août|septembre|octobre|novembre|décembre)/i,
	        monthsShortStrictRegex = /(janv\.?|févr\.?|mars|avr\.?|mai|juin|juil\.?|août|sept\.?|oct\.?|nov\.?|déc\.?)/i,
	        monthsRegex = /(janv\.?|févr\.?|mars|avr\.?|mai|juin|juil\.?|août|sept\.?|oct\.?|nov\.?|déc\.?|janvier|février|mars|avril|mai|juin|juillet|août|septembre|octobre|novembre|décembre)/i,
	        monthsParse = [/^janv/i, /^févr/i, /^mars/i, /^avr/i, /^mai/i, /^juin/i, /^juil/i, /^août/i, /^sept/i, /^oct/i, /^nov/i, /^déc/i];
	    var fr = moment.defineLocale('fr', {
	      months: 'janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre'.split('_'),
	      monthsShort: 'janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.'.split('_'),
	      monthsRegex: monthsRegex,
	      monthsShortRegex: monthsRegex,
	      monthsStrictRegex: monthsStrictRegex,
	      monthsShortStrictRegex: monthsShortStrictRegex,
	      monthsParse: monthsParse,
	      longMonthsParse: monthsParse,
	      shortMonthsParse: monthsParse,
	      weekdays: 'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),
	      weekdaysShort: 'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),
	      weekdaysMin: 'di_lu_ma_me_je_ve_sa'.split('_'),
	      weekdaysParseExact: true,
	      longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd D MMMM YYYY HH:mm'
	      },
	      calendar: {
	        sameDay: '[Aujourd’hui à] LT',
	        nextDay: '[Demain à] LT',
	        nextWeek: 'dddd [à] LT',
	        lastDay: '[Hier à] LT',
	        lastWeek: 'dddd [dernier à] LT',
	        sameElse: 'L'
	      },
	      relativeTime: {
	        future: 'dans %s',
	        past: 'il y a %s',
	        s: 'quelques secondes',
	        ss: '%d secondes',
	        m: 'une minute',
	        mm: '%d minutes',
	        h: 'une heure',
	        hh: '%d heures',
	        d: 'un jour',
	        dd: '%d jours',
	        w: 'une semaine',
	        ww: '%d semaines',
	        M: 'un mois',
	        MM: '%d mois',
	        y: 'un an',
	        yy: '%d ans'
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}(er|)/,
	      ordinal: function (number, period) {
	        switch (period) {
	          // TODO: Return 'e' when day of month > 1. Move this case inside
	          // block for masculine words below.
	          // See https://github.com/moment/moment/issues/3375
	          case 'D':
	            return number + (number === 1 ? 'er' : '');
	          // Words with masculine grammatical gender: mois, trimestre, jour

	          default:
	          case 'M':
	          case 'Q':
	          case 'DDD':
	          case 'd':
	            return number + (number === 1 ? 'er' : 'e');
	          // Words with feminine grammatical gender: semaine

	          case 'w':
	          case 'W':
	            return number + (number === 1 ? 're' : 'e');
	        }
	      },
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.

	      }
	    });
	    return fr;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    var it = moment.defineLocale('it', {
	      months: 'gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre'.split('_'),
	      monthsShort: 'gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic'.split('_'),
	      weekdays: 'domenica_lunedì_martedì_mercoledì_giovedì_venerdì_sabato'.split('_'),
	      weekdaysShort: 'dom_lun_mar_mer_gio_ven_sab'.split('_'),
	      weekdaysMin: 'do_lu_ma_me_gi_ve_sa'.split('_'),
	      longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd D MMMM YYYY HH:mm'
	      },
	      calendar: {
	        sameDay: function () {
	          return '[Oggi a' + (this.hours() > 1 ? 'lle ' : this.hours() === 0 ? ' ' : "ll'") + ']LT';
	        },
	        nextDay: function () {
	          return '[Domani a' + (this.hours() > 1 ? 'lle ' : this.hours() === 0 ? ' ' : "ll'") + ']LT';
	        },
	        nextWeek: function () {
	          return 'dddd [a' + (this.hours() > 1 ? 'lle ' : this.hours() === 0 ? ' ' : "ll'") + ']LT';
	        },
	        lastDay: function () {
	          return '[Ieri a' + (this.hours() > 1 ? 'lle ' : this.hours() === 0 ? ' ' : "ll'") + ']LT';
	        },
	        lastWeek: function () {
	          switch (this.day()) {
	            case 0:
	              return '[La scorsa] dddd [a' + (this.hours() > 1 ? 'lle ' : this.hours() === 0 ? ' ' : "ll'") + ']LT';

	            default:
	              return '[Lo scorso] dddd [a' + (this.hours() > 1 ? 'lle ' : this.hours() === 0 ? ' ' : "ll'") + ']LT';
	          }
	        },
	        sameElse: 'L'
	      },
	      relativeTime: {
	        future: 'tra %s',
	        past: '%s fa',
	        s: 'alcuni secondi',
	        ss: '%d secondi',
	        m: 'un minuto',
	        mm: '%d minuti',
	        h: "un'ora",
	        hh: '%d ore',
	        d: 'un giorno',
	        dd: '%d giorni',
	        w: 'una settimana',
	        ww: '%d settimane',
	        M: 'un mese',
	        MM: '%d mesi',
	        y: 'un anno',
	        yy: '%d anni'
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}º/,
	      ordinal: '%dº',
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.

	      }
	    });
	    return it;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    var ja = moment.defineLocale('ja', {
	      eras: [{
	        since: '2019-05-01',
	        offset: 1,
	        name: '令和',
	        narrow: '㋿',
	        abbr: 'R'
	      }, {
	        since: '1989-01-08',
	        until: '2019-04-30',
	        offset: 1,
	        name: '平成',
	        narrow: '㍻',
	        abbr: 'H'
	      }, {
	        since: '1926-12-25',
	        until: '1989-01-07',
	        offset: 1,
	        name: '昭和',
	        narrow: '㍼',
	        abbr: 'S'
	      }, {
	        since: '1912-07-30',
	        until: '1926-12-24',
	        offset: 1,
	        name: '大正',
	        narrow: '㍽',
	        abbr: 'T'
	      }, {
	        since: '1873-01-01',
	        until: '1912-07-29',
	        offset: 6,
	        name: '明治',
	        narrow: '㍾',
	        abbr: 'M'
	      }, {
	        since: '0001-01-01',
	        until: '1873-12-31',
	        offset: 1,
	        name: '西暦',
	        narrow: 'AD',
	        abbr: 'AD'
	      }, {
	        since: '0000-12-31',
	        until: -Infinity,
	        offset: 1,
	        name: '紀元前',
	        narrow: 'BC',
	        abbr: 'BC'
	      }],
	      eraYearOrdinalRegex: /(元|\d+)年/,
	      eraYearOrdinalParse: function (input, match) {
	        return match[1] === '元' ? 1 : parseInt(match[1] || input, 10);
	      },
	      months: '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
	      monthsShort: '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
	      weekdays: '日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日'.split('_'),
	      weekdaysShort: '日_月_火_水_木_金_土'.split('_'),
	      weekdaysMin: '日_月_火_水_木_金_土'.split('_'),
	      longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'YYYY/MM/DD',
	        LL: 'YYYY年M月D日',
	        LLL: 'YYYY年M月D日 HH:mm',
	        LLLL: 'YYYY年M月D日 dddd HH:mm',
	        l: 'YYYY/MM/DD',
	        ll: 'YYYY年M月D日',
	        lll: 'YYYY年M月D日 HH:mm',
	        llll: 'YYYY年M月D日(ddd) HH:mm'
	      },
	      meridiemParse: /午前|午後/i,
	      isPM: function (input) {
	        return input === '午後';
	      },
	      meridiem: function (hour, minute, isLower) {
	        if (hour < 12) {
	          return '午前';
	        } else {
	          return '午後';
	        }
	      },
	      calendar: {
	        sameDay: '[今日] LT',
	        nextDay: '[明日] LT',
	        nextWeek: function (now) {
	          if (now.week() !== this.week()) {
	            return '[来週]dddd LT';
	          } else {
	            return 'dddd LT';
	          }
	        },
	        lastDay: '[昨日] LT',
	        lastWeek: function (now) {
	          if (this.week() !== now.week()) {
	            return '[先週]dddd LT';
	          } else {
	            return 'dddd LT';
	          }
	        },
	        sameElse: 'L'
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}日/,
	      ordinal: function (number, period) {
	        switch (period) {
	          case 'y':
	            return number === 1 ? '元年' : number + '年';

	          case 'd':
	          case 'D':
	          case 'DDD':
	            return number + '日';

	          default:
	            return number;
	        }
	      },
	      relativeTime: {
	        future: '%s後',
	        past: '%s前',
	        s: '数秒',
	        ss: '%d秒',
	        m: '1分',
	        mm: '%d分',
	        h: '1時間',
	        hh: '%d時間',
	        d: '1日',
	        dd: '%d日',
	        M: '1ヶ月',
	        MM: '%dヶ月',
	        y: '1年',
	        yy: '%d年'
	      }
	    });
	    return ja;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    var monthsShortWithDots = 'jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.'.split('_'),
	        monthsShortWithoutDots = 'jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec'.split('_'),
	        monthsParse = [/^jan/i, /^feb/i, /^maart|mrt.?$/i, /^apr/i, /^mei$/i, /^jun[i.]?$/i, /^jul[i.]?$/i, /^aug/i, /^sep/i, /^okt/i, /^nov/i, /^dec/i],
	        monthsRegex = /^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;
	    var nl = moment.defineLocale('nl', {
	      months: 'januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december'.split('_'),
	      monthsShort: function (m, format) {
	        if (!m) {
	          return monthsShortWithDots;
	        } else if (/-MMM-/.test(format)) {
	          return monthsShortWithoutDots[m.month()];
	        } else {
	          return monthsShortWithDots[m.month()];
	        }
	      },
	      monthsRegex: monthsRegex,
	      monthsShortRegex: monthsRegex,
	      monthsStrictRegex: /^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,
	      monthsShortStrictRegex: /^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,
	      monthsParse: monthsParse,
	      longMonthsParse: monthsParse,
	      shortMonthsParse: monthsParse,
	      weekdays: 'zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag'.split('_'),
	      weekdaysShort: 'zo._ma._di._wo._do._vr._za.'.split('_'),
	      weekdaysMin: 'zo_ma_di_wo_do_vr_za'.split('_'),
	      weekdaysParseExact: true,
	      longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD-MM-YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd D MMMM YYYY HH:mm'
	      },
	      calendar: {
	        sameDay: '[vandaag om] LT',
	        nextDay: '[morgen om] LT',
	        nextWeek: 'dddd [om] LT',
	        lastDay: '[gisteren om] LT',
	        lastWeek: '[afgelopen] dddd [om] LT',
	        sameElse: 'L'
	      },
	      relativeTime: {
	        future: 'over %s',
	        past: '%s geleden',
	        s: 'een paar seconden',
	        ss: '%d seconden',
	        m: 'één minuut',
	        mm: '%d minuten',
	        h: 'één uur',
	        hh: '%d uur',
	        d: 'één dag',
	        dd: '%d dagen',
	        w: 'één week',
	        ww: '%d weken',
	        M: 'één maand',
	        MM: '%d maanden',
	        y: 'één jaar',
	        yy: '%d jaar'
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}(ste|de)/,
	      ordinal: function (number) {
	        return number + (number === 1 || number === 8 || number >= 20 ? 'ste' : 'de');
	      },
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.

	      }
	    });
	    return nl;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    var monthsNominative = 'styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień'.split('_'),
	        monthsSubjective = 'stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia'.split('_'),
	        monthsParse = [/^sty/i, /^lut/i, /^mar/i, /^kwi/i, /^maj/i, /^cze/i, /^lip/i, /^sie/i, /^wrz/i, /^paź/i, /^lis/i, /^gru/i];

	    function plural(n) {
	      return n % 10 < 5 && n % 10 > 1 && ~~(n / 10) % 10 !== 1;
	    }

	    function translate(number, withoutSuffix, key) {
	      var result = number + ' ';

	      switch (key) {
	        case 'ss':
	          return result + (plural(number) ? 'sekundy' : 'sekund');

	        case 'm':
	          return withoutSuffix ? 'minuta' : 'minutę';

	        case 'mm':
	          return result + (plural(number) ? 'minuty' : 'minut');

	        case 'h':
	          return withoutSuffix ? 'godzina' : 'godzinę';

	        case 'hh':
	          return result + (plural(number) ? 'godziny' : 'godzin');

	        case 'ww':
	          return result + (plural(number) ? 'tygodnie' : 'tygodni');

	        case 'MM':
	          return result + (plural(number) ? 'miesiące' : 'miesięcy');

	        case 'yy':
	          return result + (plural(number) ? 'lata' : 'lat');
	      }
	    }

	    var pl = moment.defineLocale('pl', {
	      months: function (momentToFormat, format) {
	        if (!momentToFormat) {
	          return monthsNominative;
	        } else if (/D MMMM/.test(format)) {
	          return monthsSubjective[momentToFormat.month()];
	        } else {
	          return monthsNominative[momentToFormat.month()];
	        }
	      },
	      monthsShort: 'sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru'.split('_'),
	      monthsParse: monthsParse,
	      longMonthsParse: monthsParse,
	      shortMonthsParse: monthsParse,
	      weekdays: 'niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota'.split('_'),
	      weekdaysShort: 'ndz_pon_wt_śr_czw_pt_sob'.split('_'),
	      weekdaysMin: 'Nd_Pn_Wt_Śr_Cz_Pt_So'.split('_'),
	      longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD.MM.YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd, D MMMM YYYY HH:mm'
	      },
	      calendar: {
	        sameDay: '[Dziś o] LT',
	        nextDay: '[Jutro o] LT',
	        nextWeek: function () {
	          switch (this.day()) {
	            case 0:
	              return '[W niedzielę o] LT';

	            case 2:
	              return '[We wtorek o] LT';

	            case 3:
	              return '[W środę o] LT';

	            case 6:
	              return '[W sobotę o] LT';

	            default:
	              return '[W] dddd [o] LT';
	          }
	        },
	        lastDay: '[Wczoraj o] LT',
	        lastWeek: function () {
	          switch (this.day()) {
	            case 0:
	              return '[W zeszłą niedzielę o] LT';

	            case 3:
	              return '[W zeszłą środę o] LT';

	            case 6:
	              return '[W zeszłą sobotę o] LT';

	            default:
	              return '[W zeszły] dddd [o] LT';
	          }
	        },
	        sameElse: 'L'
	      },
	      relativeTime: {
	        future: 'za %s',
	        past: '%s temu',
	        s: 'kilka sekund',
	        ss: translate,
	        m: translate,
	        mm: translate,
	        h: translate,
	        hh: translate,
	        d: '1 dzień',
	        dd: '%d dni',
	        w: 'tydzień',
	        ww: translate,
	        M: 'miesiąc',
	        MM: translate,
	        y: 'rok',
	        yy: translate
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}\./,
	      ordinal: '%d.',
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.

	      }
	    });
	    return pl;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    function plural(word, num) {
	      var forms = word.split('_');
	      return num % 10 === 1 && num % 100 !== 11 ? forms[0] : num % 10 >= 2 && num % 10 <= 4 && (num % 100 < 10 || num % 100 >= 20) ? forms[1] : forms[2];
	    }

	    function relativeTimeWithPlural(number, withoutSuffix, key) {
	      var format = {
	        ss: withoutSuffix ? 'секунда_секунды_секунд' : 'секунду_секунды_секунд',
	        mm: withoutSuffix ? 'минута_минуты_минут' : 'минуту_минуты_минут',
	        hh: 'час_часа_часов',
	        dd: 'день_дня_дней',
	        ww: 'неделя_недели_недель',
	        MM: 'месяц_месяца_месяцев',
	        yy: 'год_года_лет'
	      };

	      if (key === 'm') {
	        return withoutSuffix ? 'минута' : 'минуту';
	      } else {
	        return number + ' ' + plural(format[key], +number);
	      }
	    }

	    var monthsParse = [/^янв/i, /^фев/i, /^мар/i, /^апр/i, /^ма[йя]/i, /^июн/i, /^июл/i, /^авг/i, /^сен/i, /^окт/i, /^ноя/i, /^дек/i]; // http://new.gramota.ru/spravka/rules/139-prop : § 103
	    // Сокращения месяцев: http://new.gramota.ru/spravka/buro/search-answer?s=242637
	    // CLDR data:          http://www.unicode.org/cldr/charts/28/summary/ru.html#1753

	    var ru = moment.defineLocale('ru', {
	      months: {
	        format: 'января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря'.split('_'),
	        standalone: 'январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь'.split('_')
	      },
	      monthsShort: {
	        // по CLDR именно "июл." и "июн.", но какой смысл менять букву на точку?
	        format: 'янв._февр._мар._апр._мая_июня_июля_авг._сент._окт._нояб._дек.'.split('_'),
	        standalone: 'янв._февр._март_апр._май_июнь_июль_авг._сент._окт._нояб._дек.'.split('_')
	      },
	      weekdays: {
	        standalone: 'воскресенье_понедельник_вторник_среда_четверг_пятница_суббота'.split('_'),
	        format: 'воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу'.split('_'),
	        isFormat: /\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?] ?dddd/
	      },
	      weekdaysShort: 'вс_пн_вт_ср_чт_пт_сб'.split('_'),
	      weekdaysMin: 'вс_пн_вт_ср_чт_пт_сб'.split('_'),
	      monthsParse: monthsParse,
	      longMonthsParse: monthsParse,
	      shortMonthsParse: monthsParse,
	      // полные названия с падежами, по три буквы, для некоторых, по 4 буквы, сокращения с точкой и без точки
	      monthsRegex: /^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,
	      // копия предыдущего
	      monthsShortRegex: /^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,
	      // полные названия с падежами
	      monthsStrictRegex: /^(январ[яь]|феврал[яь]|марта?|апрел[яь]|ма[яй]|июн[яь]|июл[яь]|августа?|сентябр[яь]|октябр[яь]|ноябр[яь]|декабр[яь])/i,
	      // Выражение, которое соответствует только сокращённым формам
	      monthsShortStrictRegex: /^(янв\.|февр?\.|мар[т.]|апр\.|ма[яй]|июн[ья.]|июл[ья.]|авг\.|сент?\.|окт\.|нояб?\.|дек\.)/i,
	      longDateFormat: {
	        LT: 'H:mm',
	        LTS: 'H:mm:ss',
	        L: 'DD.MM.YYYY',
	        LL: 'D MMMM YYYY г.',
	        LLL: 'D MMMM YYYY г., H:mm',
	        LLLL: 'dddd, D MMMM YYYY г., H:mm'
	      },
	      calendar: {
	        sameDay: '[Сегодня, в] LT',
	        nextDay: '[Завтра, в] LT',
	        lastDay: '[Вчера, в] LT',
	        nextWeek: function (now) {
	          if (now.week() !== this.week()) {
	            switch (this.day()) {
	              case 0:
	                return '[В следующее] dddd, [в] LT';

	              case 1:
	              case 2:
	              case 4:
	                return '[В следующий] dddd, [в] LT';

	              case 3:
	              case 5:
	              case 6:
	                return '[В следующую] dddd, [в] LT';
	            }
	          } else {
	            if (this.day() === 2) {
	              return '[Во] dddd, [в] LT';
	            } else {
	              return '[В] dddd, [в] LT';
	            }
	          }
	        },
	        lastWeek: function (now) {
	          if (now.week() !== this.week()) {
	            switch (this.day()) {
	              case 0:
	                return '[В прошлое] dddd, [в] LT';

	              case 1:
	              case 2:
	              case 4:
	                return '[В прошлый] dddd, [в] LT';

	              case 3:
	              case 5:
	              case 6:
	                return '[В прошлую] dddd, [в] LT';
	            }
	          } else {
	            if (this.day() === 2) {
	              return '[Во] dddd, [в] LT';
	            } else {
	              return '[В] dddd, [в] LT';
	            }
	          }
	        },
	        sameElse: 'L'
	      },
	      relativeTime: {
	        future: 'через %s',
	        past: '%s назад',
	        s: 'несколько секунд',
	        ss: relativeTimeWithPlural,
	        m: relativeTimeWithPlural,
	        mm: relativeTimeWithPlural,
	        h: 'час',
	        hh: relativeTimeWithPlural,
	        d: 'день',
	        dd: relativeTimeWithPlural,
	        w: 'неделя',
	        ww: relativeTimeWithPlural,
	        M: 'месяц',
	        MM: relativeTimeWithPlural,
	        y: 'год',
	        yy: relativeTimeWithPlural
	      },
	      meridiemParse: /ночи|утра|дня|вечера/i,
	      isPM: function (input) {
	        return /^(дня|вечера)$/.test(input);
	      },
	      meridiem: function (hour, minute, isLower) {
	        if (hour < 4) {
	          return 'ночи';
	        } else if (hour < 12) {
	          return 'утра';
	        } else if (hour < 17) {
	          return 'дня';
	        } else {
	          return 'вечера';
	        }
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}-(й|го|я)/,
	      ordinal: function (number, period) {
	        switch (period) {
	          case 'M':
	          case 'd':
	          case 'DDD':
	            return number + '-й';

	          case 'D':
	            return number + '-го';

	          case 'w':
	          case 'W':
	            return number + '-я';

	          default:
	            return number;
	        }
	      },
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.

	      }
	    });
	    return ru;
	  });
	})();

	(function (module, exports) {

	  (function (global, factory) {
	    typeof commonjsRequire === 'function' ? factory(requireMoment()) : factory(global.moment);
	  })(commonjsGlobal, function (moment) {

	    function plural(word, num) {
	      var forms = word.split('_');
	      return num % 10 === 1 && num % 100 !== 11 ? forms[0] : num % 10 >= 2 && num % 10 <= 4 && (num % 100 < 10 || num % 100 >= 20) ? forms[1] : forms[2];
	    }

	    function relativeTimeWithPlural(number, withoutSuffix, key) {
	      var format = {
	        ss: withoutSuffix ? 'секунда_секунди_секунд' : 'секунду_секунди_секунд',
	        mm: withoutSuffix ? 'хвилина_хвилини_хвилин' : 'хвилину_хвилини_хвилин',
	        hh: withoutSuffix ? 'година_години_годин' : 'годину_години_годин',
	        dd: 'день_дні_днів',
	        MM: 'місяць_місяці_місяців',
	        yy: 'рік_роки_років'
	      };

	      if (key === 'm') {
	        return withoutSuffix ? 'хвилина' : 'хвилину';
	      } else if (key === 'h') {
	        return withoutSuffix ? 'година' : 'годину';
	      } else {
	        return number + ' ' + plural(format[key], +number);
	      }
	    }

	    function weekdaysCaseReplace(m, format) {
	      var weekdays = {
	        nominative: 'неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота'.split('_'),
	        accusative: 'неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу'.split('_'),
	        genitive: 'неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи'.split('_')
	      },
	          nounCase;

	      if (m === true) {
	        return weekdays['nominative'].slice(1, 7).concat(weekdays['nominative'].slice(0, 1));
	      }

	      if (!m) {
	        return weekdays['nominative'];
	      }

	      nounCase = /(\[[ВвУу]\]) ?dddd/.test(format) ? 'accusative' : /\[?(?:минулої|наступної)? ?\] ?dddd/.test(format) ? 'genitive' : 'nominative';
	      return weekdays[nounCase][m.day()];
	    }

	    function processHoursFunction(str) {
	      return function () {
	        return str + 'о' + (this.hours() === 11 ? 'б' : '') + '] LT';
	      };
	    }

	    var uk = moment.defineLocale('uk', {
	      months: {
	        format: 'січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня'.split('_'),
	        standalone: 'січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень'.split('_')
	      },
	      monthsShort: 'січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд'.split('_'),
	      weekdays: weekdaysCaseReplace,
	      weekdaysShort: 'нд_пн_вт_ср_чт_пт_сб'.split('_'),
	      weekdaysMin: 'нд_пн_вт_ср_чт_пт_сб'.split('_'),
	      longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD.MM.YYYY',
	        LL: 'D MMMM YYYY р.',
	        LLL: 'D MMMM YYYY р., HH:mm',
	        LLLL: 'dddd, D MMMM YYYY р., HH:mm'
	      },
	      calendar: {
	        sameDay: processHoursFunction('[Сьогодні '),
	        nextDay: processHoursFunction('[Завтра '),
	        lastDay: processHoursFunction('[Вчора '),
	        nextWeek: processHoursFunction('[У] dddd ['),
	        lastWeek: function () {
	          switch (this.day()) {
	            case 0:
	            case 3:
	            case 5:
	            case 6:
	              return processHoursFunction('[Минулої] dddd [').call(this);

	            case 1:
	            case 2:
	            case 4:
	              return processHoursFunction('[Минулого] dddd [').call(this);
	          }
	        },
	        sameElse: 'L'
	      },
	      relativeTime: {
	        future: 'за %s',
	        past: '%s тому',
	        s: 'декілька секунд',
	        ss: relativeTimeWithPlural,
	        m: relativeTimeWithPlural,
	        mm: relativeTimeWithPlural,
	        h: 'годину',
	        hh: relativeTimeWithPlural,
	        d: 'день',
	        dd: relativeTimeWithPlural,
	        M: 'місяць',
	        MM: relativeTimeWithPlural,
	        y: 'рік',
	        yy: relativeTimeWithPlural
	      },
	      // M. E.: those two are virtually unused but a user might want to implement them for his/her website for some reason
	      meridiemParse: /ночі|ранку|дня|вечора/,
	      isPM: function (input) {
	        return /^(дня|вечора)$/.test(input);
	      },
	      meridiem: function (hour, minute, isLower) {
	        if (hour < 4) {
	          return 'ночі';
	        } else if (hour < 12) {
	          return 'ранку';
	        } else if (hour < 17) {
	          return 'дня';
	        } else {
	          return 'вечора';
	        }
	      },
	      dayOfMonthOrdinalParse: /\d{1,2}-(й|го)/,
	      ordinal: function (number, period) {
	        switch (period) {
	          case 'M':
	          case 'd':
	          case 'DDD':
	          case 'w':
	          case 'W':
	            return number + '-й';

	          case 'D':
	            return number + '-го';

	          default:
	            return number;
	        }
	      },
	      week: {
	        dow: 1,
	        // Monday is the first day of the week.
	        doy: 7 // The week that contains Jan 7th is the first week of the year.

	      }
	    });
	    return uk;
	  });
	})();

	var from$6 = {exports: {}};

	var fails$v = function (exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};

	var fails$u = fails$v;
	var functionBindNative = !fails$u(function () {
	  var test = function () {
	    /* empty */
	  }.bind(); // eslint-disable-next-line no-prototype-builtins -- safe


	  return typeof test != 'function' || test.hasOwnProperty('prototype');
	});

	var NATIVE_BIND$4 = functionBindNative;
	var FunctionPrototype$3 = Function.prototype;
	var bind$j = FunctionPrototype$3.bind;
	var call$f = FunctionPrototype$3.call;
	var uncurryThis$v = NATIVE_BIND$4 && bind$j.bind(call$f, call$f);
	var functionUncurryThis = NATIVE_BIND$4 ? function (fn) {
	  return fn && uncurryThis$v(fn);
	} : function (fn) {
	  return fn && function () {
	    return call$f.apply(fn, arguments);
	  };
	};

	var ceil = Math.ceil;
	var floor$1 = Math.floor; // `ToIntegerOrInfinity` abstract operation
	// https://tc39.es/ecma262/#sec-tointegerorinfinity

	var toIntegerOrInfinity$5 = function (argument) {
	  var number = +argument; // eslint-disable-next-line no-self-compare -- safe

	  return number !== number || number === 0 ? 0 : (number > 0 ? floor$1 : ceil)(number);
	};

	var check = function (it) {
	  return it && it.Math == Math && it;
	}; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028


	var global$V = // eslint-disable-next-line es/no-global-this -- safe
	check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || // eslint-disable-next-line no-restricted-globals -- safe
	check(typeof self == 'object' && self) || check(typeof commonjsGlobal == 'object' && commonjsGlobal) || // eslint-disable-next-line no-new-func -- fallback
	function () {
	  return this;
	}() || Function('return this')();

	var shared$4 = {exports: {}};

	var isPure = true;

	var global$U = global$V; // eslint-disable-next-line es/no-object-defineproperty -- safe

	var defineProperty$e = Object.defineProperty;

	var setGlobal$1 = function (key, value) {
	  try {
	    defineProperty$e(global$U, key, {
	      value: value,
	      configurable: true,
	      writable: true
	    });
	  } catch (error) {
	    global$U[key] = value;
	  }

	  return value;
	};

	var global$T = global$V;
	var setGlobal = setGlobal$1;
	var SHARED = '__core-js_shared__';
	var store$3 = global$T[SHARED] || setGlobal(SHARED, {});
	var sharedStore = store$3;

	var store$2 = sharedStore;
	(shared$4.exports = function (key, value) {
	  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
	})('versions', []).push({
	  version: '3.21.1',
	  mode: 'pure' ,
	  copyright: '© 2014-2022 Denis Pushkarev (zloirock.ru)',
	  license: 'https://github.com/zloirock/core-js/blob/v3.21.1/LICENSE',
	  source: 'https://github.com/zloirock/core-js'
	});

	var global$S = global$V;
	var TypeError$k = global$S.TypeError; // `RequireObjectCoercible` abstract operation
	// https://tc39.es/ecma262/#sec-requireobjectcoercible

	var requireObjectCoercible$6 = function (it) {
	  if (it == undefined) throw TypeError$k("Can't call method on " + it);
	  return it;
	};

	var global$R = global$V;
	var requireObjectCoercible$5 = requireObjectCoercible$6;
	var Object$9 = global$R.Object; // `ToObject` abstract operation
	// https://tc39.es/ecma262/#sec-toobject

	var toObject$e = function (argument) {
	  return Object$9(requireObjectCoercible$5(argument));
	};

	var uncurryThis$u = functionUncurryThis;
	var toObject$d = toObject$e;
	var hasOwnProperty = uncurryThis$u({}.hasOwnProperty); // `HasOwnProperty` abstract operation
	// https://tc39.es/ecma262/#sec-hasownproperty

	var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
	  return hasOwnProperty(toObject$d(it), key);
	};

	var uncurryThis$t = functionUncurryThis;
	var id$1 = 0;
	var postfix = Math.random();
	var toString$c = uncurryThis$t(1.0.toString);

	var uid$4 = function (key) {
	  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$c(++id$1 + postfix, 36);
	};

	var path$t = {};

	// https://tc39.es/ecma262/#sec-iscallable

	var isCallable$k = function (argument) {
	  return typeof argument == 'function';
	};

	var path$s = path$t;
	var global$Q = global$V;
	var isCallable$j = isCallable$k;

	var aFunction = function (variable) {
	  return isCallable$j(variable) ? variable : undefined;
	};

	var getBuiltIn$c = function (namespace, method) {
	  return arguments.length < 2 ? aFunction(path$s[namespace]) || aFunction(global$Q[namespace]) : path$s[namespace] && path$s[namespace][method] || global$Q[namespace] && global$Q[namespace][method];
	};

	var getBuiltIn$b = getBuiltIn$c;
	var engineUserAgent = getBuiltIn$b('navigator', 'userAgent') || '';

	var global$P = global$V;
	var userAgent$6 = engineUserAgent;
	var process$3 = global$P.process;
	var Deno = global$P.Deno;
	var versions = process$3 && process$3.versions || Deno && Deno.version;
	var v8 = versions && versions.v8;
	var match, version;

	if (v8) {
	  match = v8.split('.'); // in old Chrome, versions of V8 isn't V8 = Chrome / 10
	  // but their correct versions are not interesting for us

	  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
	} // BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
	// so check `userAgent` even if `.v8` exists, but 0


	if (!version && userAgent$6) {
	  match = userAgent$6.match(/Edge\/(\d+)/);

	  if (!match || match[1] >= 74) {
	    match = userAgent$6.match(/Chrome\/(\d+)/);
	    if (match) version = +match[1];
	  }
	}

	var engineV8Version = version;

	/* eslint-disable es/no-symbol -- required for testing */
	var V8_VERSION$3 = engineV8Version;
	var fails$t = fails$v; // eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing

	var nativeSymbol = !!Object.getOwnPropertySymbols && !fails$t(function () {
	  var symbol = Symbol(); // Chrome 38 Symbol has incorrect toString conversion
	  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances

	  return !String(symbol) || !(Object(symbol) instanceof Symbol) || // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
	  !Symbol.sham && V8_VERSION$3 && V8_VERSION$3 < 41;
	});

	/* eslint-disable es/no-symbol -- required for testing */
	var NATIVE_SYMBOL$2 = nativeSymbol;
	var useSymbolAsUid = NATIVE_SYMBOL$2 && !Symbol.sham && typeof Symbol.iterator == 'symbol';

	var global$O = global$V;
	var shared$3 = shared$4.exports;
	var hasOwn$h = hasOwnProperty_1;
	var uid$3 = uid$4;
	var NATIVE_SYMBOL$1 = nativeSymbol;
	var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;
	var WellKnownSymbolsStore$1 = shared$3('wks');
	var Symbol$3 = global$O.Symbol;
	var symbolFor = Symbol$3 && Symbol$3['for'];
	var createWellKnownSymbol = USE_SYMBOL_AS_UID$1 ? Symbol$3 : Symbol$3 && Symbol$3.withoutSetter || uid$3;

	var wellKnownSymbol$m = function (name) {
	  if (!hasOwn$h(WellKnownSymbolsStore$1, name) || !(NATIVE_SYMBOL$1 || typeof WellKnownSymbolsStore$1[name] == 'string')) {
	    var description = 'Symbol.' + name;

	    if (NATIVE_SYMBOL$1 && hasOwn$h(Symbol$3, name)) {
	      WellKnownSymbolsStore$1[name] = Symbol$3[name];
	    } else if (USE_SYMBOL_AS_UID$1 && symbolFor) {
	      WellKnownSymbolsStore$1[name] = symbolFor(description);
	    } else {
	      WellKnownSymbolsStore$1[name] = createWellKnownSymbol(description);
	    }
	  }

	  return WellKnownSymbolsStore$1[name];
	};

	var wellKnownSymbol$l = wellKnownSymbol$m;
	var TO_STRING_TAG$4 = wellKnownSymbol$l('toStringTag');
	var test$2 = {};
	test$2[TO_STRING_TAG$4] = 'z';
	var toStringTagSupport = String(test$2) === '[object z]';

	var uncurryThis$s = functionUncurryThis;
	var toString$b = uncurryThis$s({}.toString);
	var stringSlice$1 = uncurryThis$s(''.slice);

	var classofRaw$1 = function (it) {
	  return stringSlice$1(toString$b(it), 8, -1);
	};

	var global$N = global$V;
	var TO_STRING_TAG_SUPPORT$2 = toStringTagSupport;
	var isCallable$i = isCallable$k;
	var classofRaw = classofRaw$1;
	var wellKnownSymbol$k = wellKnownSymbol$m;
	var TO_STRING_TAG$3 = wellKnownSymbol$k('toStringTag');
	var Object$8 = global$N.Object; // ES3 wrong here

	var CORRECT_ARGUMENTS = classofRaw(function () {
	  return arguments;
	}()) == 'Arguments'; // fallback for IE11 Script Access Denied error

	var tryGet = function (it, key) {
	  try {
	    return it[key];
	  } catch (error) {
	    /* empty */
	  }
	}; // getting tag from ES6+ `Object.prototype.toString`


	var classof$f = TO_STRING_TAG_SUPPORT$2 ? classofRaw : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
	  : typeof (tag = tryGet(O = Object$8(it), TO_STRING_TAG$3)) == 'string' ? tag // builtinTag case
	  : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
	  : (result = classofRaw(O)) == 'Object' && isCallable$i(O.callee) ? 'Arguments' : result;
	};

	var global$M = global$V;
	var classof$e = classof$f;
	var String$5 = global$M.String;

	var toString$a = function (argument) {
	  if (classof$e(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
	  return String$5(argument);
	};

	var uncurryThis$r = functionUncurryThis;
	var toIntegerOrInfinity$4 = toIntegerOrInfinity$5;
	var toString$9 = toString$a;
	var requireObjectCoercible$4 = requireObjectCoercible$6;
	var charAt$3 = uncurryThis$r(''.charAt);
	var charCodeAt$1 = uncurryThis$r(''.charCodeAt);
	var stringSlice = uncurryThis$r(''.slice);

	var createMethod$5 = function (CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = toString$9(requireObjectCoercible$4($this));
	    var position = toIntegerOrInfinity$4(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = charCodeAt$1(S, position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = charCodeAt$1(S, position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? charAt$3(S, position) : first : CONVERT_TO_STRING ? stringSlice(S, position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};

	var stringMultibyte = {
	  // `String.prototype.codePointAt` method
	  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
	  codeAt: createMethod$5(false),
	  // `String.prototype.at` method
	  // https://github.com/mathiasbynens/String.prototype.at
	  charAt: createMethod$5(true)
	};

	var uncurryThis$q = functionUncurryThis;
	var isCallable$h = isCallable$k;
	var store$1 = sharedStore;
	var functionToString = uncurryThis$q(Function.toString); // this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper

	if (!isCallable$h(store$1.inspectSource)) {
	  store$1.inspectSource = function (it) {
	    return functionToString(it);
	  };
	}

	var inspectSource$3 = store$1.inspectSource;

	var global$L = global$V;
	var isCallable$g = isCallable$k;
	var inspectSource$2 = inspectSource$3;
	var WeakMap$1 = global$L.WeakMap;
	var nativeWeakMap = isCallable$g(WeakMap$1) && /native code/.test(inspectSource$2(WeakMap$1));

	var isCallable$f = isCallable$k;

	var isObject$j = function (it) {
	  return typeof it == 'object' ? it !== null : isCallable$f(it);
	};

	var fails$s = fails$v; // Detect IE8's incomplete defineProperty implementation

	var descriptors = !fails$s(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty({}, 1, {
	    get: function () {
	      return 7;
	    }
	  })[1] != 7;
	});

	var objectDefineProperty = {};

	var global$K = global$V;
	var isObject$i = isObject$j;
	var document$3 = global$K.document; // typeof document.createElement is 'object' in old IE

	var EXISTS$1 = isObject$i(document$3) && isObject$i(document$3.createElement);

	var documentCreateElement$1 = function (it) {
	  return EXISTS$1 ? document$3.createElement(it) : {};
	};

	var DESCRIPTORS$h = descriptors;
	var fails$r = fails$v;
	var createElement$1 = documentCreateElement$1; // Thanks to IE8 for its funny defineProperty

	var ie8DomDefine = !DESCRIPTORS$h && !fails$r(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(createElement$1('div'), 'a', {
	    get: function () {
	      return 7;
	    }
	  }).a != 7;
	});

	var DESCRIPTORS$g = descriptors;
	var fails$q = fails$v; // V8 ~ Chrome 36-
	// https://bugs.chromium.org/p/v8/issues/detail?id=3334

	var v8PrototypeDefineBug = DESCRIPTORS$g && fails$q(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(function () {
	    /* empty */
	  }, 'prototype', {
	    value: 42,
	    writable: false
	  }).prototype != 42;
	});

	var global$J = global$V;
	var isObject$h = isObject$j;
	var String$4 = global$J.String;
	var TypeError$j = global$J.TypeError; // `Assert: Type(argument) is Object`

	var anObject$d = function (argument) {
	  if (isObject$h(argument)) return argument;
	  throw TypeError$j(String$4(argument) + ' is not an object');
	};

	var NATIVE_BIND$3 = functionBindNative;
	var call$e = Function.prototype.call;
	var functionCall = NATIVE_BIND$3 ? call$e.bind(call$e) : function () {
	  return call$e.apply(call$e, arguments);
	};

	var uncurryThis$p = functionUncurryThis;
	var objectIsPrototypeOf = uncurryThis$p({}.isPrototypeOf);

	var global$I = global$V;
	var getBuiltIn$a = getBuiltIn$c;
	var isCallable$e = isCallable$k;
	var isPrototypeOf$r = objectIsPrototypeOf;
	var USE_SYMBOL_AS_UID = useSymbolAsUid;
	var Object$7 = global$I.Object;
	var isSymbol$3 = USE_SYMBOL_AS_UID ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  var $Symbol = getBuiltIn$a('Symbol');
	  return isCallable$e($Symbol) && isPrototypeOf$r($Symbol.prototype, Object$7(it));
	};

	var global$H = global$V;
	var String$3 = global$H.String;

	var tryToString$4 = function (argument) {
	  try {
	    return String$3(argument);
	  } catch (error) {
	    return 'Object';
	  }
	};

	var global$G = global$V;
	var isCallable$d = isCallable$k;
	var tryToString$3 = tryToString$4;
	var TypeError$i = global$G.TypeError; // `Assert: IsCallable(argument) is true`

	var aCallable$b = function (argument) {
	  if (isCallable$d(argument)) return argument;
	  throw TypeError$i(tryToString$3(argument) + ' is not a function');
	};

	var aCallable$a = aCallable$b; // `GetMethod` abstract operation
	// https://tc39.es/ecma262/#sec-getmethod

	var getMethod$3 = function (V, P) {
	  var func = V[P];
	  return func == null ? undefined : aCallable$a(func);
	};

	var global$F = global$V;
	var call$d = functionCall;
	var isCallable$c = isCallable$k;
	var isObject$g = isObject$j;
	var TypeError$h = global$F.TypeError; // `OrdinaryToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-ordinarytoprimitive

	var ordinaryToPrimitive$1 = function (input, pref) {
	  var fn, val;
	  if (pref === 'string' && isCallable$c(fn = input.toString) && !isObject$g(val = call$d(fn, input))) return val;
	  if (isCallable$c(fn = input.valueOf) && !isObject$g(val = call$d(fn, input))) return val;
	  if (pref !== 'string' && isCallable$c(fn = input.toString) && !isObject$g(val = call$d(fn, input))) return val;
	  throw TypeError$h("Can't convert object to primitive value");
	};

	var global$E = global$V;
	var call$c = functionCall;
	var isObject$f = isObject$j;
	var isSymbol$2 = isSymbol$3;
	var getMethod$2 = getMethod$3;
	var ordinaryToPrimitive = ordinaryToPrimitive$1;
	var wellKnownSymbol$j = wellKnownSymbol$m;
	var TypeError$g = global$E.TypeError;
	var TO_PRIMITIVE$1 = wellKnownSymbol$j('toPrimitive'); // `ToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-toprimitive

	var toPrimitive$1 = function (input, pref) {
	  if (!isObject$f(input) || isSymbol$2(input)) return input;
	  var exoticToPrim = getMethod$2(input, TO_PRIMITIVE$1);
	  var result;

	  if (exoticToPrim) {
	    if (pref === undefined) pref = 'default';
	    result = call$c(exoticToPrim, input, pref);
	    if (!isObject$f(result) || isSymbol$2(result)) return result;
	    throw TypeError$g("Can't convert object to primitive value");
	  }

	  if (pref === undefined) pref = 'number';
	  return ordinaryToPrimitive(input, pref);
	};

	var toPrimitive = toPrimitive$1;
	var isSymbol$1 = isSymbol$3; // `ToPropertyKey` abstract operation
	// https://tc39.es/ecma262/#sec-topropertykey

	var toPropertyKey$4 = function (argument) {
	  var key = toPrimitive(argument, 'string');
	  return isSymbol$1(key) ? key : key + '';
	};

	var global$D = global$V;
	var DESCRIPTORS$f = descriptors;
	var IE8_DOM_DEFINE$1 = ie8DomDefine;
	var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
	var anObject$c = anObject$d;
	var toPropertyKey$3 = toPropertyKey$4;
	var TypeError$f = global$D.TypeError; // eslint-disable-next-line es/no-object-defineproperty -- safe

	var $defineProperty$1 = Object.defineProperty; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

	var $getOwnPropertyDescriptor$2 = Object.getOwnPropertyDescriptor;
	var ENUMERABLE = 'enumerable';
	var CONFIGURABLE$1 = 'configurable';
	var WRITABLE = 'writable'; // `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty

	objectDefineProperty.f = DESCRIPTORS$f ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
	  anObject$c(O);
	  P = toPropertyKey$3(P);
	  anObject$c(Attributes);

	  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
	    var current = $getOwnPropertyDescriptor$2(O, P);

	    if (current && current[WRITABLE]) {
	      O[P] = Attributes.value;
	      Attributes = {
	        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
	        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
	        writable: false
	      };
	    }
	  }

	  return $defineProperty$1(O, P, Attributes);
	} : $defineProperty$1 : function defineProperty(O, P, Attributes) {
	  anObject$c(O);
	  P = toPropertyKey$3(P);
	  anObject$c(Attributes);
	  if (IE8_DOM_DEFINE$1) try {
	    return $defineProperty$1(O, P, Attributes);
	  } catch (error) {
	    /* empty */
	  }
	  if ('get' in Attributes || 'set' in Attributes) throw TypeError$f('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};

	var createPropertyDescriptor$7 = function (bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};

	var DESCRIPTORS$e = descriptors;
	var definePropertyModule$5 = objectDefineProperty;
	var createPropertyDescriptor$6 = createPropertyDescriptor$7;
	var createNonEnumerableProperty$8 = DESCRIPTORS$e ? function (object, key, value) {
	  return definePropertyModule$5.f(object, key, createPropertyDescriptor$6(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};

	var shared$2 = shared$4.exports;
	var uid$2 = uid$4;
	var keys$7 = shared$2('keys');

	var sharedKey$4 = function (key) {
	  return keys$7[key] || (keys$7[key] = uid$2(key));
	};

	var hiddenKeys$6 = {};

	var NATIVE_WEAK_MAP = nativeWeakMap;
	var global$C = global$V;
	var uncurryThis$o = functionUncurryThis;
	var isObject$e = isObject$j;
	var createNonEnumerableProperty$7 = createNonEnumerableProperty$8;
	var hasOwn$g = hasOwnProperty_1;
	var shared$1 = sharedStore;
	var sharedKey$3 = sharedKey$4;
	var hiddenKeys$5 = hiddenKeys$6;
	var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
	var TypeError$e = global$C.TypeError;
	var WeakMap = global$C.WeakMap;
	var set$4, get, has;

	var enforce = function (it) {
	  return has(it) ? get(it) : set$4(it, {});
	};

	var getterFor = function (TYPE) {
	  return function (it) {
	    var state;

	    if (!isObject$e(it) || (state = get(it)).type !== TYPE) {
	      throw TypeError$e('Incompatible receiver, ' + TYPE + ' required');
	    }

	    return state;
	  };
	};

	if (NATIVE_WEAK_MAP || shared$1.state) {
	  var store = shared$1.state || (shared$1.state = new WeakMap());
	  var wmget = uncurryThis$o(store.get);
	  var wmhas = uncurryThis$o(store.has);
	  var wmset = uncurryThis$o(store.set);

	  set$4 = function (it, metadata) {
	    if (wmhas(store, it)) throw new TypeError$e(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    wmset(store, it, metadata);
	    return metadata;
	  };

	  get = function (it) {
	    return wmget(store, it) || {};
	  };

	  has = function (it) {
	    return wmhas(store, it);
	  };
	} else {
	  var STATE = sharedKey$3('state');
	  hiddenKeys$5[STATE] = true;

	  set$4 = function (it, metadata) {
	    if (hasOwn$g(it, STATE)) throw new TypeError$e(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    createNonEnumerableProperty$7(it, STATE, metadata);
	    return metadata;
	  };

	  get = function (it) {
	    return hasOwn$g(it, STATE) ? it[STATE] : {};
	  };

	  has = function (it) {
	    return hasOwn$g(it, STATE);
	  };
	}

	var internalState = {
	  set: set$4,
	  get: get,
	  has: has,
	  enforce: enforce,
	  getterFor: getterFor
	};

	var NATIVE_BIND$2 = functionBindNative;
	var FunctionPrototype$2 = Function.prototype;
	var apply$7 = FunctionPrototype$2.apply;
	var call$b = FunctionPrototype$2.call; // eslint-disable-next-line es/no-reflect -- safe

	var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND$2 ? call$b.bind(apply$7) : function () {
	  return call$b.apply(apply$7, arguments);
	});

	var objectGetOwnPropertyDescriptor = {};

	var objectPropertyIsEnumerable = {};

	var $propertyIsEnumerable$2 = {}.propertyIsEnumerable; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

	var getOwnPropertyDescriptor$6 = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug

	var NASHORN_BUG = getOwnPropertyDescriptor$6 && !$propertyIsEnumerable$2.call({
	  1: 2
	}, 1); // `Object.prototype.propertyIsEnumerable` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable

	objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor$6(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : $propertyIsEnumerable$2;

	var global$B = global$V;
	var uncurryThis$n = functionUncurryThis;
	var fails$p = fails$v;
	var classof$d = classofRaw$1;
	var Object$6 = global$B.Object;
	var split = uncurryThis$n(''.split); // fallback for non-array-like ES3 and non-enumerable old V8 strings

	var indexedObject = fails$p(function () {
	  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
	  // eslint-disable-next-line no-prototype-builtins -- safe
	  return !Object$6('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classof$d(it) == 'String' ? split(it, '') : Object$6(it);
	} : Object$6;

	var IndexedObject$3 = indexedObject;
	var requireObjectCoercible$3 = requireObjectCoercible$6;

	var toIndexedObject$b = function (it) {
	  return IndexedObject$3(requireObjectCoercible$3(it));
	};

	var DESCRIPTORS$d = descriptors;
	var call$a = functionCall;
	var propertyIsEnumerableModule$2 = objectPropertyIsEnumerable;
	var createPropertyDescriptor$5 = createPropertyDescriptor$7;
	var toIndexedObject$a = toIndexedObject$b;
	var toPropertyKey$2 = toPropertyKey$4;
	var hasOwn$f = hasOwnProperty_1;
	var IE8_DOM_DEFINE = ie8DomDefine; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

	var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor

	objectGetOwnPropertyDescriptor.f = DESCRIPTORS$d ? $getOwnPropertyDescriptor$1 : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject$a(O);
	  P = toPropertyKey$2(P);
	  if (IE8_DOM_DEFINE) try {
	    return $getOwnPropertyDescriptor$1(O, P);
	  } catch (error) {
	    /* empty */
	  }
	  if (hasOwn$f(O, P)) return createPropertyDescriptor$5(!call$a(propertyIsEnumerableModule$2.f, O, P), O[P]);
	};

	var fails$o = fails$v;
	var isCallable$b = isCallable$k;
	var replacement = /#|\.prototype\./;

	var isForced$2 = function (feature, detection) {
	  var value = data[normalize(feature)];
	  return value == POLYFILL ? true : value == NATIVE ? false : isCallable$b(detection) ? fails$o(detection) : !!detection;
	};

	var normalize = isForced$2.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};

	var data = isForced$2.data = {};
	var NATIVE = isForced$2.NATIVE = 'N';
	var POLYFILL = isForced$2.POLYFILL = 'P';
	var isForced_1 = isForced$2;

	var uncurryThis$m = functionUncurryThis;
	var aCallable$9 = aCallable$b;
	var NATIVE_BIND$1 = functionBindNative;
	var bind$i = uncurryThis$m(uncurryThis$m.bind); // optional / simple context binding

	var functionBindContext = function (fn, that) {
	  aCallable$9(fn);
	  return that === undefined ? fn : NATIVE_BIND$1 ? bind$i(fn, that) : function
	    /* ...args */
	  () {
	    return fn.apply(that, arguments);
	  };
	};

	var global$A = global$V;
	var apply$6 = functionApply;
	var uncurryThis$l = functionUncurryThis;
	var isCallable$a = isCallable$k;
	var getOwnPropertyDescriptor$5 = objectGetOwnPropertyDescriptor.f;
	var isForced$1 = isForced_1;
	var path$r = path$t;
	var bind$h = functionBindContext;
	var createNonEnumerableProperty$6 = createNonEnumerableProperty$8;
	var hasOwn$e = hasOwnProperty_1;

	var wrapConstructor = function (NativeConstructor) {
	  var Wrapper = function (a, b, c) {
	    if (this instanceof Wrapper) {
	      switch (arguments.length) {
	        case 0:
	          return new NativeConstructor();

	        case 1:
	          return new NativeConstructor(a);

	        case 2:
	          return new NativeConstructor(a, b);
	      }

	      return new NativeConstructor(a, b, c);
	    }

	    return apply$6(NativeConstructor, this, arguments);
	  };

	  Wrapper.prototype = NativeConstructor.prototype;
	  return Wrapper;
	};
	/*
	  options.target      - name of the target object
	  options.global      - target is the global object
	  options.stat        - export as static methods of target
	  options.proto       - export as prototype methods of target
	  options.real        - real prototype method for the `pure` version
	  options.forced      - export even if the native feature is available
	  options.bind        - bind methods to the target, required for the `pure` version
	  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
	  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
	  options.sham        - add a flag to not completely full polyfills
	  options.enumerable  - export as enumerable property
	  options.noTargetGet - prevent calling a getter on target
	  options.name        - the .name of the function if it does not match the key
	*/


	var _export = function (options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var PROTO = options.proto;
	  var nativeSource = GLOBAL ? global$A : STATIC ? global$A[TARGET] : (global$A[TARGET] || {}).prototype;
	  var target = GLOBAL ? path$r : path$r[TARGET] || createNonEnumerableProperty$6(path$r, TARGET, {})[TARGET];
	  var targetPrototype = target.prototype;
	  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
	  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

	  for (key in source) {
	    FORCED = isForced$1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contains in native

	    USE_NATIVE = !FORCED && nativeSource && hasOwn$e(nativeSource, key);
	    targetProperty = target[key];
	    if (USE_NATIVE) if (options.noTargetGet) {
	      descriptor = getOwnPropertyDescriptor$5(nativeSource, key);
	      nativeProperty = descriptor && descriptor.value;
	    } else nativeProperty = nativeSource[key]; // export native or implementation

	    sourceProperty = USE_NATIVE && nativeProperty ? nativeProperty : source[key];
	    if (USE_NATIVE && typeof targetProperty == typeof sourceProperty) continue; // bind timers to global for call from export context

	    if (options.bind && USE_NATIVE) resultProperty = bind$h(sourceProperty, global$A); // wrap global constructors for prevent changs in this version
	    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty); // make static versions for prototype methods
	    else if (PROTO && isCallable$a(sourceProperty)) resultProperty = uncurryThis$l(sourceProperty); // default case
	    else resultProperty = sourceProperty; // add a flag to not completely full polyfills

	    if (options.sham || sourceProperty && sourceProperty.sham || targetProperty && targetProperty.sham) {
	      createNonEnumerableProperty$6(resultProperty, 'sham', true);
	    }

	    createNonEnumerableProperty$6(target, key, resultProperty);

	    if (PROTO) {
	      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';

	      if (!hasOwn$e(path$r, VIRTUAL_PROTOTYPE)) {
	        createNonEnumerableProperty$6(path$r, VIRTUAL_PROTOTYPE, {});
	      } // export virtual prototype methods


	      createNonEnumerableProperty$6(path$r[VIRTUAL_PROTOTYPE], key, sourceProperty); // export real prototype methods

	      if (options.real && targetPrototype && !targetPrototype[key]) {
	        createNonEnumerableProperty$6(targetPrototype, key, sourceProperty);
	      }
	    }
	  }
	};

	var DESCRIPTORS$c = descriptors;
	var hasOwn$d = hasOwnProperty_1;
	var FunctionPrototype$1 = Function.prototype; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

	var getDescriptor = DESCRIPTORS$c && Object.getOwnPropertyDescriptor;
	var EXISTS = hasOwn$d(FunctionPrototype$1, 'name'); // additional protection from minified / mangled / dropped function names

	var PROPER = EXISTS && function something() {
	  /* empty */
	}.name === 'something';

	var CONFIGURABLE = EXISTS && (!DESCRIPTORS$c || DESCRIPTORS$c && getDescriptor(FunctionPrototype$1, 'name').configurable);
	var functionName = {
	  EXISTS: EXISTS,
	  PROPER: PROPER,
	  CONFIGURABLE: CONFIGURABLE
	};

	var objectDefineProperties = {};

	var toIntegerOrInfinity$3 = toIntegerOrInfinity$5;
	var max$3 = Math.max;
	var min$2 = Math.min; // Helper for a popular repeating case of the spec:
	// Let integer be ? ToInteger(index).
	// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).

	var toAbsoluteIndex$5 = function (index, length) {
	  var integer = toIntegerOrInfinity$3(index);
	  return integer < 0 ? max$3(integer + length, 0) : min$2(integer, length);
	};

	var toIntegerOrInfinity$2 = toIntegerOrInfinity$5;
	var min$1 = Math.min; // `ToLength` abstract operation
	// https://tc39.es/ecma262/#sec-tolength

	var toLength$1 = function (argument) {
	  return argument > 0 ? min$1(toIntegerOrInfinity$2(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
	};

	var toLength = toLength$1; // `LengthOfArrayLike` abstract operation
	// https://tc39.es/ecma262/#sec-lengthofarraylike

	var lengthOfArrayLike$d = function (obj) {
	  return toLength(obj.length);
	};

	var toIndexedObject$9 = toIndexedObject$b;
	var toAbsoluteIndex$4 = toAbsoluteIndex$5;
	var lengthOfArrayLike$c = lengthOfArrayLike$d; // `Array.prototype.{ indexOf, includes }` methods implementation

	var createMethod$4 = function (IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject$9($this);
	    var length = lengthOfArrayLike$c(O);
	    var index = toAbsoluteIndex$4(fromIndex, length);
	    var value; // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare -- NaN check

	    if (IS_INCLUDES && el != el) while (length > index) {
	      value = O[index++]; // eslint-disable-next-line no-self-compare -- NaN check

	      if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
	    } else for (; length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    }
	    return !IS_INCLUDES && -1;
	  };
	};

	var arrayIncludes = {
	  // `Array.prototype.includes` method
	  // https://tc39.es/ecma262/#sec-array.prototype.includes
	  includes: createMethod$4(true),
	  // `Array.prototype.indexOf` method
	  // https://tc39.es/ecma262/#sec-array.prototype.indexof
	  indexOf: createMethod$4(false)
	};

	var uncurryThis$k = functionUncurryThis;
	var hasOwn$c = hasOwnProperty_1;
	var toIndexedObject$8 = toIndexedObject$b;
	var indexOf$4 = arrayIncludes.indexOf;
	var hiddenKeys$4 = hiddenKeys$6;
	var push$6 = uncurryThis$k([].push);

	var objectKeysInternal = function (object, names) {
	  var O = toIndexedObject$8(object);
	  var i = 0;
	  var result = [];
	  var key;

	  for (key in O) !hasOwn$c(hiddenKeys$4, key) && hasOwn$c(O, key) && push$6(result, key); // Don't enum bug & hidden keys


	  while (names.length > i) if (hasOwn$c(O, key = names[i++])) {
	    ~indexOf$4(result, key) || push$6(result, key);
	  }

	  return result;
	};

	var enumBugKeys$3 = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];

	var internalObjectKeys$1 = objectKeysInternal;
	var enumBugKeys$2 = enumBugKeys$3; // `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys
	// eslint-disable-next-line es/no-object-keys -- safe

	var objectKeys$4 = Object.keys || function keys(O) {
	  return internalObjectKeys$1(O, enumBugKeys$2);
	};

	var DESCRIPTORS$b = descriptors;
	var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
	var definePropertyModule$4 = objectDefineProperty;
	var anObject$b = anObject$d;
	var toIndexedObject$7 = toIndexedObject$b;
	var objectKeys$3 = objectKeys$4; // `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe

	objectDefineProperties.f = DESCRIPTORS$b && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject$b(O);
	  var props = toIndexedObject$7(Properties);
	  var keys = objectKeys$3(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;

	  while (length > index) definePropertyModule$4.f(O, key = keys[index++], props[key]);

	  return O;
	};

	var getBuiltIn$9 = getBuiltIn$c;
	var html$2 = getBuiltIn$9('document', 'documentElement');

	/* global ActiveXObject -- old IE, WSH */
	var anObject$a = anObject$d;
	var definePropertiesModule$1 = objectDefineProperties;
	var enumBugKeys$1 = enumBugKeys$3;
	var hiddenKeys$3 = hiddenKeys$6;
	var html$1 = html$2;
	var documentCreateElement = documentCreateElement$1;
	var sharedKey$2 = sharedKey$4;
	var GT = '>';
	var LT = '<';
	var PROTOTYPE$1 = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO$1 = sharedKey$2('IE_PROTO');

	var EmptyConstructor = function () {
	  /* empty */
	};

	var scriptTag = function (content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	}; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype


	var NullProtoObjectViaActiveX = function (activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null; // avoid memory leak

	  return temp;
	}; // Create object with fake `null` prototype: use iframe Object with cleared prototype


	var NullProtoObjectViaIFrame = function () {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = documentCreateElement('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html$1.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475

	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	}; // Check for document.domain and active x support
	// No need to use active x approach when document.domain is not set
	// see https://github.com/es-shims/es5-shim/issues/150
	// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
	// avoid IE GC bug


	var activeXDocument;

	var NullProtoObject = function () {
	  try {
	    activeXDocument = new ActiveXObject('htmlfile');
	  } catch (error) {
	    /* ignore */
	  }

	  NullProtoObject = typeof document != 'undefined' ? document.domain && activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) // old IE
	  : NullProtoObjectViaIFrame() : NullProtoObjectViaActiveX(activeXDocument); // WSH

	  var length = enumBugKeys$1.length;

	  while (length--) delete NullProtoObject[PROTOTYPE$1][enumBugKeys$1[length]];

	  return NullProtoObject();
	};

	hiddenKeys$3[IE_PROTO$1] = true; // `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create

	var objectCreate = Object.create || function create(O, Properties) {
	  var result;

	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE$1] = anObject$a(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE$1] = null; // add "__proto__" for Object.getPrototypeOf polyfill

	    result[IE_PROTO$1] = O;
	  } else result = NullProtoObject();

	  return Properties === undefined ? result : definePropertiesModule$1.f(result, Properties);
	};

	var fails$n = fails$v;
	var correctPrototypeGetter = !fails$n(function () {
	  function F() {
	    /* empty */
	  }

	  F.prototype.constructor = null; // eslint-disable-next-line es/no-object-getprototypeof -- required for testing

	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});

	var global$z = global$V;
	var hasOwn$b = hasOwnProperty_1;
	var isCallable$9 = isCallable$k;
	var toObject$c = toObject$e;
	var sharedKey$1 = sharedKey$4;
	var CORRECT_PROTOTYPE_GETTER$1 = correctPrototypeGetter;
	var IE_PROTO = sharedKey$1('IE_PROTO');
	var Object$5 = global$z.Object;
	var ObjectPrototype$2 = Object$5.prototype; // `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof

	var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER$1 ? Object$5.getPrototypeOf : function (O) {
	  var object = toObject$c(O);
	  if (hasOwn$b(object, IE_PROTO)) return object[IE_PROTO];
	  var constructor = object.constructor;

	  if (isCallable$9(constructor) && object instanceof constructor) {
	    return constructor.prototype;
	  }

	  return object instanceof Object$5 ? ObjectPrototype$2 : null;
	};

	var createNonEnumerableProperty$5 = createNonEnumerableProperty$8;

	var redefine$4 = function (target, key, value, options) {
	  if (options && options.enumerable) target[key] = value;else createNonEnumerableProperty$5(target, key, value);
	};

	var fails$m = fails$v;
	var isCallable$8 = isCallable$k;
	var create$b = objectCreate;
	var getPrototypeOf$8 = objectGetPrototypeOf;
	var redefine$3 = redefine$4;
	var wellKnownSymbol$i = wellKnownSymbol$m;
	var ITERATOR$6 = wellKnownSymbol$i('iterator');
	var BUGGY_SAFARI_ITERATORS$1 = false; // `%IteratorPrototype%` object
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-object

	var IteratorPrototype$1, PrototypeOfArrayIteratorPrototype, arrayIterator;
	/* eslint-disable es/no-array-prototype-keys -- safe */

	if ([].keys) {
	  arrayIterator = [].keys(); // Safari 8 has buggy iterators w/o `next`

	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;else {
	    PrototypeOfArrayIteratorPrototype = getPrototypeOf$8(getPrototypeOf$8(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$1 = PrototypeOfArrayIteratorPrototype;
	  }
	}

	var NEW_ITERATOR_PROTOTYPE = IteratorPrototype$1 == undefined || fails$m(function () {
	  var test = {}; // FF44- legacy iterators case

	  return IteratorPrototype$1[ITERATOR$6].call(test) !== test;
	});
	if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$1 = {};else IteratorPrototype$1 = create$b(IteratorPrototype$1); // `%IteratorPrototype%[@@iterator]()` method
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator

	if (!isCallable$8(IteratorPrototype$1[ITERATOR$6])) {
	  redefine$3(IteratorPrototype$1, ITERATOR$6, function () {
	    return this;
	  });
	}

	var iteratorsCore = {
	  IteratorPrototype: IteratorPrototype$1,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
	};

	var TO_STRING_TAG_SUPPORT$1 = toStringTagSupport;
	var classof$c = classof$f; // `Object.prototype.toString` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.tostring

	var objectToString = TO_STRING_TAG_SUPPORT$1 ? {}.toString : function toString() {
	  return '[object ' + classof$c(this) + ']';
	};

	var TO_STRING_TAG_SUPPORT = toStringTagSupport;
	var defineProperty$d = objectDefineProperty.f;
	var createNonEnumerableProperty$4 = createNonEnumerableProperty$8;
	var hasOwn$a = hasOwnProperty_1;
	var toString$8 = objectToString;
	var wellKnownSymbol$h = wellKnownSymbol$m;
	var TO_STRING_TAG$2 = wellKnownSymbol$h('toStringTag');

	var setToStringTag$6 = function (it, TAG, STATIC, SET_METHOD) {
	  if (it) {
	    var target = STATIC ? it : it.prototype;

	    if (!hasOwn$a(target, TO_STRING_TAG$2)) {
	      defineProperty$d(target, TO_STRING_TAG$2, {
	        configurable: true,
	        value: TAG
	      });
	    }

	    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
	      createNonEnumerableProperty$4(target, 'toString', toString$8);
	    }
	  }
	};

	var iterators = {};

	var IteratorPrototype = iteratorsCore.IteratorPrototype;
	var create$a = objectCreate;
	var createPropertyDescriptor$4 = createPropertyDescriptor$7;
	var setToStringTag$5 = setToStringTag$6;
	var Iterators$5 = iterators;

	var returnThis$1 = function () {
	  return this;
	};

	var createIteratorConstructor$1 = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = create$a(IteratorPrototype, {
	    next: createPropertyDescriptor$4(+!ENUMERABLE_NEXT, next)
	  });
	  setToStringTag$5(IteratorConstructor, TO_STRING_TAG, false, true);
	  Iterators$5[TO_STRING_TAG] = returnThis$1;
	  return IteratorConstructor;
	};

	var global$y = global$V;
	var isCallable$7 = isCallable$k;
	var String$2 = global$y.String;
	var TypeError$d = global$y.TypeError;

	var aPossiblePrototype$1 = function (argument) {
	  if (typeof argument == 'object' || isCallable$7(argument)) return argument;
	  throw TypeError$d("Can't set " + String$2(argument) + ' as a prototype');
	};

	/* eslint-disable no-proto -- safe */
	var uncurryThis$j = functionUncurryThis;
	var anObject$9 = anObject$d;
	var aPossiblePrototype = aPossiblePrototype$1; // `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof
	// Works with __proto__ only. Old v8 can't work with null proto objects.
	// eslint-disable-next-line es/no-object-setprototypeof -- safe

	var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;

	  try {
	    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	    setter = uncurryThis$j(Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set);
	    setter(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) {
	    /* empty */
	  }

	  return function setPrototypeOf(O, proto) {
	    anObject$9(O);
	    aPossiblePrototype(proto);
	    if (CORRECT_SETTER) setter(O, proto);else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);

	var $$N = _export;
	var call$9 = functionCall;
	var FunctionName = functionName;
	var createIteratorConstructor = createIteratorConstructor$1;
	var getPrototypeOf$7 = objectGetPrototypeOf;
	var setToStringTag$4 = setToStringTag$6;
	var redefine$2 = redefine$4;
	var wellKnownSymbol$g = wellKnownSymbol$m;
	var Iterators$4 = iterators;
	var IteratorsCore = iteratorsCore;
	var PROPER_FUNCTION_NAME$1 = FunctionName.PROPER;
	var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR$5 = wellKnownSymbol$g('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';

	var returnThis = function () {
	  return this;
	};

	var defineIterator$3 = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor(IteratorConstructor, NAME, next);

	  var getIterationMethod = function (KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];

	    switch (KIND) {
	      case KEYS:
	        return function keys() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case VALUES:
	        return function values() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case ENTRIES:
	        return function entries() {
	          return new IteratorConstructor(this, KIND);
	        };
	    }

	    return function () {
	      return new IteratorConstructor(this);
	    };
	  };

	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR$5] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY; // fix native

	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = getPrototypeOf$7(anyNativeIterator.call(new Iterable()));

	    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {


	      setToStringTag$4(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
	      Iterators$4[TO_STRING_TAG] = returnThis;
	    }
	  } // fix Array.prototype.{ values, @@iterator }.name in V8 / FF


	  if (PROPER_FUNCTION_NAME$1 && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    {
	      INCORRECT_VALUES_NAME = true;

	      defaultIterator = function values() {
	        return call$9(nativeIterator, this);
	      };
	    }
	  } // export additional methods


	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        redefine$2(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else $$N({
	      target: NAME,
	      proto: true,
	      forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
	    }, methods);
	  } // define iterator


	  if ((FORCED) && IterablePrototype[ITERATOR$5] !== defaultIterator) {
	    redefine$2(IterablePrototype, ITERATOR$5, defaultIterator, {
	      name: DEFAULT
	    });
	  }

	  Iterators$4[NAME] = defaultIterator;
	  return methods;
	};

	var charAt$2 = stringMultibyte.charAt;
	var toString$7 = toString$a;
	var InternalStateModule$5 = internalState;
	var defineIterator$2 = defineIterator$3;
	var STRING_ITERATOR = 'String Iterator';
	var setInternalState$5 = InternalStateModule$5.set;
	var getInternalState$3 = InternalStateModule$5.getterFor(STRING_ITERATOR); // `String.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-string.prototype-@@iterator

	defineIterator$2(String, 'String', function (iterated) {
	  setInternalState$5(this, {
	    type: STRING_ITERATOR,
	    string: toString$7(iterated),
	    index: 0
	  }); // `%StringIteratorPrototype%.next` method
	  // https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
	}, function next() {
	  var state = getInternalState$3(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return {
	    value: undefined,
	    done: true
	  };
	  point = charAt$2(string, index);
	  state.index += point.length;
	  return {
	    value: point,
	    done: false
	  };
	});

	var call$8 = functionCall;
	var anObject$8 = anObject$d;
	var getMethod$1 = getMethod$3;

	var iteratorClose$2 = function (iterator, kind, value) {
	  var innerResult, innerError;
	  anObject$8(iterator);

	  try {
	    innerResult = getMethod$1(iterator, 'return');

	    if (!innerResult) {
	      if (kind === 'throw') throw value;
	      return value;
	    }

	    innerResult = call$8(innerResult, iterator);
	  } catch (error) {
	    innerError = true;
	    innerResult = error;
	  }

	  if (kind === 'throw') throw value;
	  if (innerError) throw innerResult;
	  anObject$8(innerResult);
	  return value;
	};

	var anObject$7 = anObject$d;
	var iteratorClose$1 = iteratorClose$2; // call something on iterator step with safe closing on error

	var callWithSafeIterationClosing$1 = function (iterator, fn, value, ENTRIES) {
	  try {
	    return ENTRIES ? fn(anObject$7(value)[0], value[1]) : fn(value);
	  } catch (error) {
	    iteratorClose$1(iterator, 'throw', error);
	  }
	};

	var wellKnownSymbol$f = wellKnownSymbol$m;
	var Iterators$3 = iterators;
	var ITERATOR$4 = wellKnownSymbol$f('iterator');
	var ArrayPrototype$k = Array.prototype; // check on default Array iterator

	var isArrayIteratorMethod$2 = function (it) {
	  return it !== undefined && (Iterators$3.Array === it || ArrayPrototype$k[ITERATOR$4] === it);
	};

	var uncurryThis$i = functionUncurryThis;
	var fails$l = fails$v;
	var isCallable$6 = isCallable$k;
	var classof$b = classof$f;
	var getBuiltIn$8 = getBuiltIn$c;
	var inspectSource$1 = inspectSource$3;

	var noop = function () {
	  /* empty */
	};

	var empty = [];
	var construct$4 = getBuiltIn$8('Reflect', 'construct');
	var constructorRegExp = /^\s*(?:class|function)\b/;
	var exec$2 = uncurryThis$i(constructorRegExp.exec);
	var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);

	var isConstructorModern = function isConstructor(argument) {
	  if (!isCallable$6(argument)) return false;

	  try {
	    construct$4(noop, empty, argument);
	    return true;
	  } catch (error) {
	    return false;
	  }
	};

	var isConstructorLegacy = function isConstructor(argument) {
	  if (!isCallable$6(argument)) return false;

	  switch (classof$b(argument)) {
	    case 'AsyncFunction':
	    case 'GeneratorFunction':
	    case 'AsyncGeneratorFunction':
	      return false;
	  }

	  try {
	    // we can't check .prototype since constructors produced by .bind haven't it
	    // `Function#toString` throws on some built-it function in some legacy engines
	    // (for example, `DOMQuad` and similar in FF41-)
	    return INCORRECT_TO_STRING || !!exec$2(constructorRegExp, inspectSource$1(argument));
	  } catch (error) {
	    return true;
	  }
	};

	isConstructorLegacy.sham = true; // `IsConstructor` abstract operation
	// https://tc39.es/ecma262/#sec-isconstructor

	var isConstructor$4 = !construct$4 || fails$l(function () {
	  var called;
	  return isConstructorModern(isConstructorModern.call) || !isConstructorModern(Object) || !isConstructorModern(function () {
	    called = true;
	  }) || called;
	}) ? isConstructorLegacy : isConstructorModern;

	var toPropertyKey$1 = toPropertyKey$4;
	var definePropertyModule$3 = objectDefineProperty;
	var createPropertyDescriptor$3 = createPropertyDescriptor$7;

	var createProperty$6 = function (object, key, value) {
	  var propertyKey = toPropertyKey$1(key);
	  if (propertyKey in object) definePropertyModule$3.f(object, propertyKey, createPropertyDescriptor$3(0, value));else object[propertyKey] = value;
	};

	var classof$a = classof$f;
	var getMethod = getMethod$3;
	var Iterators$2 = iterators;
	var wellKnownSymbol$e = wellKnownSymbol$m;
	var ITERATOR$3 = wellKnownSymbol$e('iterator');

	var getIteratorMethod$8 = function (it) {
	  if (it != undefined) return getMethod(it, ITERATOR$3) || getMethod(it, '@@iterator') || Iterators$2[classof$a(it)];
	};

	var global$x = global$V;
	var call$7 = functionCall;
	var aCallable$8 = aCallable$b;
	var anObject$6 = anObject$d;
	var tryToString$2 = tryToString$4;
	var getIteratorMethod$7 = getIteratorMethod$8;
	var TypeError$c = global$x.TypeError;

	var getIterator$7 = function (argument, usingIterator) {
	  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$7(argument) : usingIterator;
	  if (aCallable$8(iteratorMethod)) return anObject$6(call$7(iteratorMethod, argument));
	  throw TypeError$c(tryToString$2(argument) + ' is not iterable');
	};

	var global$w = global$V;
	var bind$g = functionBindContext;
	var call$6 = functionCall;
	var toObject$b = toObject$e;
	var callWithSafeIterationClosing = callWithSafeIterationClosing$1;
	var isArrayIteratorMethod$1 = isArrayIteratorMethod$2;
	var isConstructor$3 = isConstructor$4;
	var lengthOfArrayLike$b = lengthOfArrayLike$d;
	var createProperty$5 = createProperty$6;
	var getIterator$6 = getIterator$7;
	var getIteratorMethod$6 = getIteratorMethod$8;
	var Array$5 = global$w.Array; // `Array.from` method implementation
	// https://tc39.es/ecma262/#sec-array.from

	var arrayFrom = function from(arrayLike
	/* , mapfn = undefined, thisArg = undefined */
	) {
	  var O = toObject$b(arrayLike);
	  var IS_CONSTRUCTOR = isConstructor$3(this);
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  if (mapping) mapfn = bind$g(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
	  var iteratorMethod = getIteratorMethod$6(O);
	  var index = 0;
	  var length, result, step, iterator, next, value; // if the target is not iterable or it's an array with the default iterator - use a simple case

	  if (iteratorMethod && !(this == Array$5 && isArrayIteratorMethod$1(iteratorMethod))) {
	    iterator = getIterator$6(O, iteratorMethod);
	    next = iterator.next;
	    result = IS_CONSTRUCTOR ? new this() : [];

	    for (; !(step = call$6(next, iterator)).done; index++) {
	      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
	      createProperty$5(result, index, value);
	    }
	  } else {
	    length = lengthOfArrayLike$b(O);
	    result = IS_CONSTRUCTOR ? new this(length) : Array$5(length);

	    for (; length > index; index++) {
	      value = mapping ? mapfn(O[index], index) : O[index];
	      createProperty$5(result, index, value);
	    }
	  }

	  result.length = index;
	  return result;
	};

	var wellKnownSymbol$d = wellKnownSymbol$m;
	var ITERATOR$2 = wellKnownSymbol$d('iterator');
	var SAFE_CLOSING = false;

	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function () {
	      return {
	        done: !!called++
	      };
	    },
	    'return': function () {
	      SAFE_CLOSING = true;
	    }
	  };

	  iteratorWithReturn[ITERATOR$2] = function () {
	    return this;
	  }; // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing


	  Array.from(iteratorWithReturn, function () {
	    throw 2;
	  });
	} catch (error) {
	  /* empty */
	}

	var checkCorrectnessOfIteration$2 = function (exec, SKIP_CLOSING) {
	  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  var ITERATION_SUPPORT = false;

	  try {
	    var object = {};

	    object[ITERATOR$2] = function () {
	      return {
	        next: function () {
	          return {
	            done: ITERATION_SUPPORT = true
	          };
	        }
	      };
	    };

	    exec(object);
	  } catch (error) {
	    /* empty */
	  }

	  return ITERATION_SUPPORT;
	};

	var $$M = _export;
	var from$5 = arrayFrom;
	var checkCorrectnessOfIteration$1 = checkCorrectnessOfIteration$2;
	var INCORRECT_ITERATION$1 = !checkCorrectnessOfIteration$1(function (iterable) {
	  // eslint-disable-next-line es/no-array-from -- required for testing
	  Array.from(iterable);
	}); // `Array.from` method
	// https://tc39.es/ecma262/#sec-array.from

	$$M({
	  target: 'Array',
	  stat: true,
	  forced: INCORRECT_ITERATION$1
	}, {
	  from: from$5
	});

	var path$q = path$t;
	var from$4 = path$q.Array.from;

	var parent$1e = from$4;
	var from$3 = parent$1e;

	(function (module) {
	  module.exports = from$3;
	})(from$6);

	var _Array$from$1 = /*@__PURE__*/getDefaultExportFromCjs(from$6.exports);

	var getIteratorMethod$5 = {exports: {}};

	var toIndexedObject$6 = toIndexedObject$b;
	var Iterators$1 = iterators;
	var InternalStateModule$4 = internalState;
	objectDefineProperty.f;
	var defineIterator$1 = defineIterator$3;
	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState$4 = InternalStateModule$4.set;
	var getInternalState$2 = InternalStateModule$4.getterFor(ARRAY_ITERATOR); // `Array.prototype.entries` method
	// https://tc39.es/ecma262/#sec-array.prototype.entries
	// `Array.prototype.keys` method
	// https://tc39.es/ecma262/#sec-array.prototype.keys
	// `Array.prototype.values` method
	// https://tc39.es/ecma262/#sec-array.prototype.values
	// `Array.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
	// `CreateArrayIterator` internal method
	// https://tc39.es/ecma262/#sec-createarrayiterator

	defineIterator$1(Array, 'Array', function (iterated, kind) {
	  setInternalState$4(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject$6(iterated),
	    // target
	    index: 0,
	    // next index
	    kind: kind // kind

	  }); // `%ArrayIteratorPrototype%.next` method
	  // https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
	}, function () {
	  var state = getInternalState$2(this);
	  var target = state.target;
	  var kind = state.kind;
	  var index = state.index++;

	  if (!target || index >= target.length) {
	    state.target = undefined;
	    return {
	      value: undefined,
	      done: true
	    };
	  }

	  if (kind == 'keys') return {
	    value: index,
	    done: false
	  };
	  if (kind == 'values') return {
	    value: target[index],
	    done: false
	  };
	  return {
	    value: [index, target[index]],
	    done: false
	  };
	}, 'values'); // argumentsList[@@iterator] is %ArrayProto_values%
	// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
	// https://tc39.es/ecma262/#sec-createmappedargumentsobject

	Iterators$1.Arguments = Iterators$1.Array; // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

	var getIteratorMethod$4 = getIteratorMethod$8;
	var getIteratorMethod_1 = getIteratorMethod$4;

	// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods

	var domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};

	var DOMIterables$4 = domIterables;
	var global$v = global$V;
	var classof$9 = classof$f;
	var createNonEnumerableProperty$3 = createNonEnumerableProperty$8;
	var Iterators = iterators;
	var wellKnownSymbol$c = wellKnownSymbol$m;
	var TO_STRING_TAG$1 = wellKnownSymbol$c('toStringTag');

	for (var COLLECTION_NAME in DOMIterables$4) {
	  var Collection = global$v[COLLECTION_NAME];
	  var CollectionPrototype = Collection && Collection.prototype;

	  if (CollectionPrototype && classof$9(CollectionPrototype) !== TO_STRING_TAG$1) {
	    createNonEnumerableProperty$3(CollectionPrototype, TO_STRING_TAG$1, COLLECTION_NAME);
	  }

	  Iterators[COLLECTION_NAME] = Iterators.Array;
	}

	var parent$1d = getIteratorMethod_1;
	var getIteratorMethod$3 = parent$1d;

	var parent$1c = getIteratorMethod$3;
	var getIteratorMethod$2 = parent$1c;

	var parent$1b = getIteratorMethod$2;
	var getIteratorMethod$1 = parent$1b;

	(function (module) {
	  module.exports = getIteratorMethod$1;
	})(getIteratorMethod$5);

	var _getIteratorMethod = /*@__PURE__*/getDefaultExportFromCjs(getIteratorMethod$5.exports);

	var getOwnPropertySymbols$2 = {exports: {}};

	var classof$8 = classofRaw$1; // `IsArray` abstract operation
	// https://tc39.es/ecma262/#sec-isarray
	// eslint-disable-next-line es/no-array-isarray -- safe

	var isArray$d = Array.isArray || function isArray(argument) {
	  return classof$8(argument) == 'Array';
	};

	var objectGetOwnPropertyNames = {};

	var internalObjectKeys = objectKeysInternal;
	var enumBugKeys = enumBugKeys$3;
	var hiddenKeys$2 = enumBugKeys.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
	// https://tc39.es/ecma262/#sec-object.getownpropertynames
	// eslint-disable-next-line es/no-object-getownpropertynames -- safe

	objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return internalObjectKeys(O, hiddenKeys$2);
	};

	var objectGetOwnPropertyNamesExternal = {};

	var global$u = global$V;
	var toAbsoluteIndex$3 = toAbsoluteIndex$5;
	var lengthOfArrayLike$a = lengthOfArrayLike$d;
	var createProperty$4 = createProperty$6;
	var Array$4 = global$u.Array;
	var max$2 = Math.max;

	var arraySliceSimple = function (O, start, end) {
	  var length = lengthOfArrayLike$a(O);
	  var k = toAbsoluteIndex$3(start, length);
	  var fin = toAbsoluteIndex$3(end === undefined ? length : end, length);
	  var result = Array$4(max$2(fin - k, 0));

	  for (var n = 0; k < fin; k++, n++) createProperty$4(result, n, O[k]);

	  result.length = n;
	  return result;
	};

	/* eslint-disable es/no-object-getownpropertynames -- safe */
	var classof$7 = classofRaw$1;
	var toIndexedObject$5 = toIndexedObject$b;
	var $getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
	var arraySlice$6 = arraySliceSimple;
	var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];

	var getWindowNames = function (it) {
	  try {
	    return $getOwnPropertyNames$1(it);
	  } catch (error) {
	    return arraySlice$6(windowNames);
	  }
	}; // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window


	objectGetOwnPropertyNamesExternal.f = function getOwnPropertyNames(it) {
	  return windowNames && classof$7(it) == 'Window' ? getWindowNames(it) : $getOwnPropertyNames$1(toIndexedObject$5(it));
	};

	var objectGetOwnPropertySymbols = {};

	objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

	var uncurryThis$h = functionUncurryThis;
	var arraySlice$5 = uncurryThis$h([].slice);

	var wellKnownSymbolWrapped = {};

	var wellKnownSymbol$b = wellKnownSymbol$m;
	wellKnownSymbolWrapped.f = wellKnownSymbol$b;

	var path$p = path$t;
	var hasOwn$9 = hasOwnProperty_1;
	var wrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;
	var defineProperty$c = objectDefineProperty.f;

	var defineWellKnownSymbol$l = function (NAME) {
	  var Symbol = path$p.Symbol || (path$p.Symbol = {});
	  if (!hasOwn$9(Symbol, NAME)) defineProperty$c(Symbol, NAME, {
	    value: wrappedWellKnownSymbolModule$1.f(NAME)
	  });
	};

	var global$t = global$V;
	var isArray$c = isArray$d;
	var isConstructor$2 = isConstructor$4;
	var isObject$d = isObject$j;
	var wellKnownSymbol$a = wellKnownSymbol$m;
	var SPECIES$5 = wellKnownSymbol$a('species');
	var Array$3 = global$t.Array; // a part of `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate

	var arraySpeciesConstructor$1 = function (originalArray) {
	  var C;

	  if (isArray$c(originalArray)) {
	    C = originalArray.constructor; // cross-realm fallback

	    if (isConstructor$2(C) && (C === Array$3 || isArray$c(C.prototype))) C = undefined;else if (isObject$d(C)) {
	      C = C[SPECIES$5];
	      if (C === null) C = undefined;
	    }
	  }

	  return C === undefined ? Array$3 : C;
	};

	var arraySpeciesConstructor = arraySpeciesConstructor$1; // `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate

	var arraySpeciesCreate$4 = function (originalArray, length) {
	  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
	};

	var bind$f = functionBindContext;
	var uncurryThis$g = functionUncurryThis;
	var IndexedObject$2 = indexedObject;
	var toObject$a = toObject$e;
	var lengthOfArrayLike$9 = lengthOfArrayLike$d;
	var arraySpeciesCreate$3 = arraySpeciesCreate$4;
	var push$5 = uncurryThis$g([].push); // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation

	var createMethod$3 = function (TYPE) {
	  var IS_MAP = TYPE == 1;
	  var IS_FILTER = TYPE == 2;
	  var IS_SOME = TYPE == 3;
	  var IS_EVERY = TYPE == 4;
	  var IS_FIND_INDEX = TYPE == 6;
	  var IS_FILTER_REJECT = TYPE == 7;
	  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
	  return function ($this, callbackfn, that, specificCreate) {
	    var O = toObject$a($this);
	    var self = IndexedObject$2(O);
	    var boundFunction = bind$f(callbackfn, that);
	    var length = lengthOfArrayLike$9(self);
	    var index = 0;
	    var create = specificCreate || arraySpeciesCreate$3;
	    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
	    var value, result;

	    for (; length > index; index++) if (NO_HOLES || index in self) {
	      value = self[index];
	      result = boundFunction(value, index, O);

	      if (TYPE) {
	        if (IS_MAP) target[index] = result; // map
	        else if (result) switch (TYPE) {
	          case 3:
	            return true;
	          // some

	          case 5:
	            return value;
	          // find

	          case 6:
	            return index;
	          // findIndex

	          case 2:
	            push$5(target, value);
	          // filter
	        } else switch (TYPE) {
	          case 4:
	            return false;
	          // every

	          case 7:
	            push$5(target, value);
	          // filterReject
	        }
	      }
	    }

	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
	  };
	};

	var arrayIteration = {
	  // `Array.prototype.forEach` method
	  // https://tc39.es/ecma262/#sec-array.prototype.foreach
	  forEach: createMethod$3(0),
	  // `Array.prototype.map` method
	  // https://tc39.es/ecma262/#sec-array.prototype.map
	  map: createMethod$3(1),
	  // `Array.prototype.filter` method
	  // https://tc39.es/ecma262/#sec-array.prototype.filter
	  filter: createMethod$3(2),
	  // `Array.prototype.some` method
	  // https://tc39.es/ecma262/#sec-array.prototype.some
	  some: createMethod$3(3),
	  // `Array.prototype.every` method
	  // https://tc39.es/ecma262/#sec-array.prototype.every
	  every: createMethod$3(4),
	  // `Array.prototype.find` method
	  // https://tc39.es/ecma262/#sec-array.prototype.find
	  find: createMethod$3(5),
	  // `Array.prototype.findIndex` method
	  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
	  findIndex: createMethod$3(6),
	  // `Array.prototype.filterReject` method
	  // https://github.com/tc39/proposal-array-filtering
	  filterReject: createMethod$3(7)
	};

	var $$L = _export;
	var global$s = global$V;
	var getBuiltIn$7 = getBuiltIn$c;
	var apply$5 = functionApply;
	var call$5 = functionCall;
	var uncurryThis$f = functionUncurryThis;
	var DESCRIPTORS$a = descriptors;
	var NATIVE_SYMBOL = nativeSymbol;
	var fails$k = fails$v;
	var hasOwn$8 = hasOwnProperty_1;
	var isArray$b = isArray$d;
	var isCallable$5 = isCallable$k;
	var isObject$c = isObject$j;
	var isPrototypeOf$q = objectIsPrototypeOf;
	var isSymbol = isSymbol$3;
	var anObject$5 = anObject$d;
	var toObject$9 = toObject$e;
	var toIndexedObject$4 = toIndexedObject$b;
	var toPropertyKey = toPropertyKey$4;
	var $toString = toString$a;
	var createPropertyDescriptor$2 = createPropertyDescriptor$7;
	var nativeObjectCreate = objectCreate;
	var objectKeys$2 = objectKeys$4;
	var getOwnPropertyNamesModule$2 = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternal = objectGetOwnPropertyNamesExternal;
	var getOwnPropertySymbolsModule$2 = objectGetOwnPropertySymbols;
	var getOwnPropertyDescriptorModule$2 = objectGetOwnPropertyDescriptor;
	var definePropertyModule$2 = objectDefineProperty;
	var definePropertiesModule = objectDefineProperties;
	var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
	var arraySlice$4 = arraySlice$5;
	var redefine$1 = redefine$4;
	var shared = shared$4.exports;
	var sharedKey = sharedKey$4;
	var hiddenKeys$1 = hiddenKeys$6;
	var uid$1 = uid$4;
	var wellKnownSymbol$9 = wellKnownSymbol$m;
	var wrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
	var defineWellKnownSymbol$k = defineWellKnownSymbol$l;
	var setToStringTag$3 = setToStringTag$6;
	var InternalStateModule$3 = internalState;
	var $forEach$1 = arrayIteration.forEach;
	var HIDDEN = sharedKey('hidden');
	var SYMBOL = 'Symbol';
	var PROTOTYPE = 'prototype';
	var TO_PRIMITIVE = wellKnownSymbol$9('toPrimitive');
	var setInternalState$3 = InternalStateModule$3.set;
	var getInternalState$1 = InternalStateModule$3.getterFor(SYMBOL);
	var ObjectPrototype$1 = Object[PROTOTYPE];
	var $Symbol = global$s.Symbol;
	var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
	var TypeError$b = global$s.TypeError;
	var QObject = global$s.QObject;
	var $stringify$1 = getBuiltIn$7('JSON', 'stringify');
	var nativeGetOwnPropertyDescriptor$1 = getOwnPropertyDescriptorModule$2.f;
	var nativeDefineProperty = definePropertyModule$2.f;
	var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
	var nativePropertyIsEnumerable = propertyIsEnumerableModule$1.f;
	var push$4 = uncurryThis$f([].push);
	var AllSymbols = shared('symbols');
	var ObjectPrototypeSymbols = shared('op-symbols');
	var StringToSymbolRegistry = shared('string-to-symbol-registry');
	var SymbolToStringRegistry = shared('symbol-to-string-registry');
	var WellKnownSymbolsStore = shared('wks'); // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173

	var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild; // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687

	var setSymbolDescriptor = DESCRIPTORS$a && fails$k(function () {
	  return nativeObjectCreate(nativeDefineProperty({}, 'a', {
	    get: function () {
	      return nativeDefineProperty(this, 'a', {
	        value: 7
	      }).a;
	    }
	  })).a != 7;
	}) ? function (O, P, Attributes) {
	  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype$1, P);
	  if (ObjectPrototypeDescriptor) delete ObjectPrototype$1[P];
	  nativeDefineProperty(O, P, Attributes);

	  if (ObjectPrototypeDescriptor && O !== ObjectPrototype$1) {
	    nativeDefineProperty(ObjectPrototype$1, P, ObjectPrototypeDescriptor);
	  }
	} : nativeDefineProperty;

	var wrap$1 = function (tag, description) {
	  var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype);
	  setInternalState$3(symbol, {
	    type: SYMBOL,
	    tag: tag,
	    description: description
	  });
	  if (!DESCRIPTORS$a) symbol.description = description;
	  return symbol;
	};

	var $defineProperty = function defineProperty(O, P, Attributes) {
	  if (O === ObjectPrototype$1) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
	  anObject$5(O);
	  var key = toPropertyKey(P);
	  anObject$5(Attributes);

	  if (hasOwn$8(AllSymbols, key)) {
	    if (!Attributes.enumerable) {
	      if (!hasOwn$8(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor$2(1, {}));
	      O[HIDDEN][key] = true;
	    } else {
	      if (hasOwn$8(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
	      Attributes = nativeObjectCreate(Attributes, {
	        enumerable: createPropertyDescriptor$2(0, false)
	      });
	    }

	    return setSymbolDescriptor(O, key, Attributes);
	  }

	  return nativeDefineProperty(O, key, Attributes);
	};

	var $defineProperties = function defineProperties(O, Properties) {
	  anObject$5(O);
	  var properties = toIndexedObject$4(Properties);
	  var keys = objectKeys$2(properties).concat($getOwnPropertySymbols(properties));
	  $forEach$1(keys, function (key) {
	    if (!DESCRIPTORS$a || call$5($propertyIsEnumerable$1, properties, key)) $defineProperty(O, key, properties[key]);
	  });
	  return O;
	};

	var $create = function create(O, Properties) {
	  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
	};

	var $propertyIsEnumerable$1 = function propertyIsEnumerable(V) {
	  var P = toPropertyKey(V);
	  var enumerable = call$5(nativePropertyIsEnumerable, this, P);
	  if (this === ObjectPrototype$1 && hasOwn$8(AllSymbols, P) && !hasOwn$8(ObjectPrototypeSymbols, P)) return false;
	  return enumerable || !hasOwn$8(this, P) || !hasOwn$8(AllSymbols, P) || hasOwn$8(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
	};

	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
	  var it = toIndexedObject$4(O);
	  var key = toPropertyKey(P);
	  if (it === ObjectPrototype$1 && hasOwn$8(AllSymbols, key) && !hasOwn$8(ObjectPrototypeSymbols, key)) return;
	  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);

	  if (descriptor && hasOwn$8(AllSymbols, key) && !(hasOwn$8(it, HIDDEN) && it[HIDDEN][key])) {
	    descriptor.enumerable = true;
	  }

	  return descriptor;
	};

	var $getOwnPropertyNames = function getOwnPropertyNames(O) {
	  var names = nativeGetOwnPropertyNames(toIndexedObject$4(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (!hasOwn$8(AllSymbols, key) && !hasOwn$8(hiddenKeys$1, key)) push$4(result, key);
	  });
	  return result;
	};

	var $getOwnPropertySymbols = function getOwnPropertySymbols(O) {
	  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype$1;
	  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject$4(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (hasOwn$8(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn$8(ObjectPrototype$1, key))) {
	      push$4(result, AllSymbols[key]);
	    }
	  });
	  return result;
	}; // `Symbol` constructor
	// https://tc39.es/ecma262/#sec-symbol-constructor


	if (!NATIVE_SYMBOL) {
	  $Symbol = function Symbol() {
	    if (isPrototypeOf$q(SymbolPrototype, this)) throw TypeError$b('Symbol is not a constructor');
	    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
	    var tag = uid$1(description);

	    var setter = function (value) {
	      if (this === ObjectPrototype$1) call$5(setter, ObjectPrototypeSymbols, value);
	      if (hasOwn$8(this, HIDDEN) && hasOwn$8(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      setSymbolDescriptor(this, tag, createPropertyDescriptor$2(1, value));
	    };

	    if (DESCRIPTORS$a && USE_SETTER) setSymbolDescriptor(ObjectPrototype$1, tag, {
	      configurable: true,
	      set: setter
	    });
	    return wrap$1(tag, description);
	  };

	  SymbolPrototype = $Symbol[PROTOTYPE];
	  redefine$1(SymbolPrototype, 'toString', function toString() {
	    return getInternalState$1(this).tag;
	  });
	  redefine$1($Symbol, 'withoutSetter', function (description) {
	    return wrap$1(uid$1(description), description);
	  });
	  propertyIsEnumerableModule$1.f = $propertyIsEnumerable$1;
	  definePropertyModule$2.f = $defineProperty;
	  definePropertiesModule.f = $defineProperties;
	  getOwnPropertyDescriptorModule$2.f = $getOwnPropertyDescriptor;
	  getOwnPropertyNamesModule$2.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
	  getOwnPropertySymbolsModule$2.f = $getOwnPropertySymbols;

	  wrappedWellKnownSymbolModule.f = function (name) {
	    return wrap$1(wellKnownSymbol$9(name), name);
	  };

	  if (DESCRIPTORS$a) {
	    // https://github.com/tc39/proposal-Symbol-description
	    nativeDefineProperty(SymbolPrototype, 'description', {
	      configurable: true,
	      get: function description() {
	        return getInternalState$1(this).description;
	      }
	    });
	  }
	}

	$$L({
	  global: true,
	  wrap: true,
	  forced: !NATIVE_SYMBOL,
	  sham: !NATIVE_SYMBOL
	}, {
	  Symbol: $Symbol
	});
	$forEach$1(objectKeys$2(WellKnownSymbolsStore), function (name) {
	  defineWellKnownSymbol$k(name);
	});
	$$L({
	  target: SYMBOL,
	  stat: true,
	  forced: !NATIVE_SYMBOL
	}, {
	  // `Symbol.for` method
	  // https://tc39.es/ecma262/#sec-symbol.for
	  'for': function (key) {
	    var string = $toString(key);
	    if (hasOwn$8(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
	    var symbol = $Symbol(string);
	    StringToSymbolRegistry[string] = symbol;
	    SymbolToStringRegistry[symbol] = string;
	    return symbol;
	  },
	  // `Symbol.keyFor` method
	  // https://tc39.es/ecma262/#sec-symbol.keyfor
	  keyFor: function keyFor(sym) {
	    if (!isSymbol(sym)) throw TypeError$b(sym + ' is not a symbol');
	    if (hasOwn$8(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
	  },
	  useSetter: function () {
	    USE_SETTER = true;
	  },
	  useSimple: function () {
	    USE_SETTER = false;
	  }
	});
	$$L({
	  target: 'Object',
	  stat: true,
	  forced: !NATIVE_SYMBOL,
	  sham: !DESCRIPTORS$a
	}, {
	  // `Object.create` method
	  // https://tc39.es/ecma262/#sec-object.create
	  create: $create,
	  // `Object.defineProperty` method
	  // https://tc39.es/ecma262/#sec-object.defineproperty
	  defineProperty: $defineProperty,
	  // `Object.defineProperties` method
	  // https://tc39.es/ecma262/#sec-object.defineproperties
	  defineProperties: $defineProperties,
	  // `Object.getOwnPropertyDescriptor` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
	});
	$$L({
	  target: 'Object',
	  stat: true,
	  forced: !NATIVE_SYMBOL
	}, {
	  // `Object.getOwnPropertyNames` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertynames
	  getOwnPropertyNames: $getOwnPropertyNames,
	  // `Object.getOwnPropertySymbols` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertysymbols
	  getOwnPropertySymbols: $getOwnPropertySymbols
	}); // Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
	// https://bugs.chromium.org/p/v8/issues/detail?id=3443

	$$L({
	  target: 'Object',
	  stat: true,
	  forced: fails$k(function () {
	    getOwnPropertySymbolsModule$2.f(1);
	  })
	}, {
	  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
	    return getOwnPropertySymbolsModule$2.f(toObject$9(it));
	  }
	}); // `JSON.stringify` method behavior with symbols
	// https://tc39.es/ecma262/#sec-json.stringify

	if ($stringify$1) {
	  var FORCED_JSON_STRINGIFY = !NATIVE_SYMBOL || fails$k(function () {
	    var symbol = $Symbol(); // MS Edge converts symbol values to JSON as {}

	    return $stringify$1([symbol]) != '[null]' // WebKit converts symbol values to JSON as null
	    || $stringify$1({
	      a: symbol
	    }) != '{}' // V8 throws on boxed symbols
	    || $stringify$1(Object(symbol)) != '{}';
	  });
	  $$L({
	    target: 'JSON',
	    stat: true,
	    forced: FORCED_JSON_STRINGIFY
	  }, {
	    // eslint-disable-next-line no-unused-vars -- required for `.length`
	    stringify: function stringify(it, replacer, space) {
	      var args = arraySlice$4(arguments);
	      var $replacer = replacer;
	      if (!isObject$c(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined

	      if (!isArray$b(replacer)) replacer = function (key, value) {
	        if (isCallable$5($replacer)) value = call$5($replacer, this, key, value);
	        if (!isSymbol(value)) return value;
	      };
	      args[1] = replacer;
	      return apply$5($stringify$1, null, args);
	    }
	  });
	} // `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive


	if (!SymbolPrototype[TO_PRIMITIVE]) {
	  var valueOf = SymbolPrototype.valueOf; // eslint-disable-next-line no-unused-vars -- required for .length

	  redefine$1(SymbolPrototype, TO_PRIMITIVE, function (hint) {
	    // TODO: improve hint logic
	    return call$5(valueOf, this);
	  });
	} // `Symbol.prototype[@@toStringTag]` property
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag


	setToStringTag$3($Symbol, SYMBOL);
	hiddenKeys$1[HIDDEN] = true;

	var path$o = path$t;
	var getOwnPropertySymbols$1 = path$o.Object.getOwnPropertySymbols;

	var parent$1a = getOwnPropertySymbols$1;
	var getOwnPropertySymbols = parent$1a;

	(function (module) {
	  module.exports = getOwnPropertySymbols;
	})(getOwnPropertySymbols$2);

	var _Object$getOwnPropertySymbols = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertySymbols$2.exports);

	var getOwnPropertyDescriptor$4 = {exports: {}};

	var getOwnPropertyDescriptor$3 = {exports: {}};

	var $$K = _export;
	var fails$j = fails$v;
	var toIndexedObject$3 = toIndexedObject$b;
	var nativeGetOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	var DESCRIPTORS$9 = descriptors;
	var FAILS_ON_PRIMITIVES$3 = fails$j(function () {
	  nativeGetOwnPropertyDescriptor(1);
	});
	var FORCED$7 = !DESCRIPTORS$9 || FAILS_ON_PRIMITIVES$3; // `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor

	$$K({
	  target: 'Object',
	  stat: true,
	  forced: FORCED$7,
	  sham: !DESCRIPTORS$9
	}, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
	    return nativeGetOwnPropertyDescriptor(toIndexedObject$3(it), key);
	  }
	});

	var path$n = path$t;
	var Object$4 = path$n.Object;

	var getOwnPropertyDescriptor$2 = getOwnPropertyDescriptor$3.exports = function getOwnPropertyDescriptor(it, key) {
	  return Object$4.getOwnPropertyDescriptor(it, key);
	};

	if (Object$4.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor$2.sham = true;

	var parent$19 = getOwnPropertyDescriptor$3.exports;
	var getOwnPropertyDescriptor$1 = parent$19;

	(function (module) {
	  module.exports = getOwnPropertyDescriptor$1;
	})(getOwnPropertyDescriptor$4);

	var _Object$getOwnPropertyDescriptor = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptor$4.exports);

	var getOwnPropertyDescriptors$2 = {exports: {}};

	var getBuiltIn$6 = getBuiltIn$c;
	var uncurryThis$e = functionUncurryThis;
	var getOwnPropertyNamesModule$1 = objectGetOwnPropertyNames;
	var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
	var anObject$4 = anObject$d;
	var concat$6 = uncurryThis$e([].concat); // all object keys, includes non-enumerable and symbols

	var ownKeys$9 = getBuiltIn$6('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = getOwnPropertyNamesModule$1.f(anObject$4(it));
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
	  return getOwnPropertySymbols ? concat$6(keys, getOwnPropertySymbols(it)) : keys;
	};

	var $$J = _export;
	var DESCRIPTORS$8 = descriptors;
	var ownKeys$8 = ownKeys$9;
	var toIndexedObject$2 = toIndexedObject$b;
	var getOwnPropertyDescriptorModule$1 = objectGetOwnPropertyDescriptor;
	var createProperty$3 = createProperty$6; // `Object.getOwnPropertyDescriptors` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors

	$$J({
	  target: 'Object',
	  stat: true,
	  sham: !DESCRIPTORS$8
	}, {
	  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
	    var O = toIndexedObject$2(object);
	    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule$1.f;
	    var keys = ownKeys$8(O);
	    var result = {};
	    var index = 0;
	    var key, descriptor;

	    while (keys.length > index) {
	      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
	      if (descriptor !== undefined) createProperty$3(result, key, descriptor);
	    }

	    return result;
	  }
	});

	var path$m = path$t;
	var getOwnPropertyDescriptors$1 = path$m.Object.getOwnPropertyDescriptors;

	var parent$18 = getOwnPropertyDescriptors$1;
	var getOwnPropertyDescriptors = parent$18;

	(function (module) {
	  module.exports = getOwnPropertyDescriptors;
	})(getOwnPropertyDescriptors$2);

	var _Object$getOwnPropertyDescriptors = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptors$2.exports);

	var defineProperties$4 = {exports: {}};

	var defineProperties$3 = {exports: {}};

	var $$I = _export;
	var DESCRIPTORS$7 = descriptors;
	var defineProperties$2 = objectDefineProperties.f; // `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe

	$$I({
	  target: 'Object',
	  stat: true,
	  forced: Object.defineProperties !== defineProperties$2,
	  sham: !DESCRIPTORS$7
	}, {
	  defineProperties: defineProperties$2
	});

	var path$l = path$t;
	var Object$3 = path$l.Object;

	var defineProperties$1 = defineProperties$3.exports = function defineProperties(T, D) {
	  return Object$3.defineProperties(T, D);
	};

	if (Object$3.defineProperties.sham) defineProperties$1.sham = true;

	var parent$17 = defineProperties$3.exports;
	var defineProperties = parent$17;

	(function (module) {
	  module.exports = defineProperties;
	})(defineProperties$4);

	var _Object$defineProperties = /*@__PURE__*/getDefaultExportFromCjs(defineProperties$4.exports);

	var defineProperty$b = {exports: {}};

	var defineProperty$a = {exports: {}};

	var $$H = _export;
	var DESCRIPTORS$6 = descriptors;
	var defineProperty$9 = objectDefineProperty.f; // `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty
	// eslint-disable-next-line es/no-object-defineproperty -- safe

	$$H({
	  target: 'Object',
	  stat: true,
	  forced: Object.defineProperty !== defineProperty$9,
	  sham: !DESCRIPTORS$6
	}, {
	  defineProperty: defineProperty$9
	});

	var path$k = path$t;
	var Object$2 = path$k.Object;

	var defineProperty$8 = defineProperty$a.exports = function defineProperty(it, key, desc) {
	  return Object$2.defineProperty(it, key, desc);
	};

	if (Object$2.defineProperty.sham) defineProperty$8.sham = true;

	var parent$16 = defineProperty$a.exports;
	var defineProperty$7 = parent$16;

	(function (module) {
	  module.exports = defineProperty$7;
	})(defineProperty$b);

	var _Object$defineProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(defineProperty$b.exports);

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	var defineProperty$6 = {exports: {}};

	var parent$15 = defineProperty$7;
	var defineProperty$5 = parent$15;

	var parent$14 = defineProperty$5;
	var defineProperty$4 = parent$14;

	(function (module) {
	  module.exports = defineProperty$4;
	})(defineProperty$6);

	var _Object$defineProperty = /*@__PURE__*/getDefaultExportFromCjs(defineProperty$6.exports);

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;

	    _Object$defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);

	  _Object$defineProperty(Constructor, "prototype", {
	    writable: false
	  });

	  return Constructor;
	}

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    _Object$defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	var isArray$a = {exports: {}};

	var $$G = _export;
	var isArray$9 = isArray$d; // `Array.isArray` method
	// https://tc39.es/ecma262/#sec-array.isarray

	$$G({
	  target: 'Array',
	  stat: true
	}, {
	  isArray: isArray$9
	});

	var path$j = path$t;
	var isArray$8 = path$j.Array.isArray;

	var parent$13 = isArray$8;
	var isArray$7 = parent$13;

	var parent$12 = isArray$7;
	var isArray$6 = parent$12;

	var parent$11 = isArray$6;
	var isArray$5 = parent$11;

	(function (module) {
	  module.exports = isArray$5;
	})(isArray$a);

	var _Array$isArray$1 = /*@__PURE__*/getDefaultExportFromCjs(isArray$a.exports);

	function _arrayWithHoles(arr) {
	  if (_Array$isArray$1(arr)) return arr;
	}

	var symbol$5 = {exports: {}};

	var fails$i = fails$v;
	var wellKnownSymbol$8 = wellKnownSymbol$m;
	var V8_VERSION$2 = engineV8Version;
	var SPECIES$4 = wellKnownSymbol$8('species');

	var arrayMethodHasSpeciesSupport$5 = function (METHOD_NAME) {
	  // We can't use this feature detection in V8 since it causes
	  // deoptimization and serious performance degradation
	  // https://github.com/zloirock/core-js/issues/677
	  return V8_VERSION$2 >= 51 || !fails$i(function () {
	    var array = [];
	    var constructor = array.constructor = {};

	    constructor[SPECIES$4] = function () {
	      return {
	        foo: 1
	      };
	    };

	    return array[METHOD_NAME](Boolean).foo !== 1;
	  });
	};

	var $$F = _export;
	var global$r = global$V;
	var fails$h = fails$v;
	var isArray$4 = isArray$d;
	var isObject$b = isObject$j;
	var toObject$8 = toObject$e;
	var lengthOfArrayLike$8 = lengthOfArrayLike$d;
	var createProperty$2 = createProperty$6;
	var arraySpeciesCreate$2 = arraySpeciesCreate$4;
	var arrayMethodHasSpeciesSupport$4 = arrayMethodHasSpeciesSupport$5;
	var wellKnownSymbol$7 = wellKnownSymbol$m;
	var V8_VERSION$1 = engineV8Version;
	var IS_CONCAT_SPREADABLE = wellKnownSymbol$7('isConcatSpreadable');
	var MAX_SAFE_INTEGER$1 = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded';
	var TypeError$a = global$r.TypeError; // We can't use this feature detection in V8 since it causes
	// deoptimization and serious performance degradation
	// https://github.com/zloirock/core-js/issues/679

	var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION$1 >= 51 || !fails$h(function () {
	  var array = [];
	  array[IS_CONCAT_SPREADABLE] = false;
	  return array.concat()[0] !== array;
	});
	var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport$4('concat');

	var isConcatSpreadable = function (O) {
	  if (!isObject$b(O)) return false;
	  var spreadable = O[IS_CONCAT_SPREADABLE];
	  return spreadable !== undefined ? !!spreadable : isArray$4(O);
	};

	var FORCED$6 = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT; // `Array.prototype.concat` method
	// https://tc39.es/ecma262/#sec-array.prototype.concat
	// with adding support of @@isConcatSpreadable and @@species

	$$F({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$6
	}, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  concat: function concat(arg) {
	    var O = toObject$8(this);
	    var A = arraySpeciesCreate$2(O, 0);
	    var n = 0;
	    var i, k, length, len, E;

	    for (i = -1, length = arguments.length; i < length; i++) {
	      E = i === -1 ? O : arguments[i];

	      if (isConcatSpreadable(E)) {
	        len = lengthOfArrayLike$8(E);
	        if (n + len > MAX_SAFE_INTEGER$1) throw TypeError$a(MAXIMUM_ALLOWED_INDEX_EXCEEDED);

	        for (k = 0; k < len; k++, n++) if (k in E) createProperty$2(A, n, E[k]);
	      } else {
	        if (n >= MAX_SAFE_INTEGER$1) throw TypeError$a(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
	        createProperty$2(A, n++, E);
	      }
	    }

	    A.length = n;
	    return A;
	  }
	});

	var defineWellKnownSymbol$j = defineWellKnownSymbol$l; // `Symbol.asyncIterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.asynciterator

	defineWellKnownSymbol$j('asyncIterator');

	var defineWellKnownSymbol$i = defineWellKnownSymbol$l; // `Symbol.hasInstance` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.hasinstance

	defineWellKnownSymbol$i('hasInstance');

	var defineWellKnownSymbol$h = defineWellKnownSymbol$l; // `Symbol.isConcatSpreadable` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable

	defineWellKnownSymbol$h('isConcatSpreadable');

	var defineWellKnownSymbol$g = defineWellKnownSymbol$l; // `Symbol.iterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.iterator

	defineWellKnownSymbol$g('iterator');

	var defineWellKnownSymbol$f = defineWellKnownSymbol$l; // `Symbol.match` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.match

	defineWellKnownSymbol$f('match');

	var defineWellKnownSymbol$e = defineWellKnownSymbol$l; // `Symbol.matchAll` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.matchall

	defineWellKnownSymbol$e('matchAll');

	var defineWellKnownSymbol$d = defineWellKnownSymbol$l; // `Symbol.replace` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.replace

	defineWellKnownSymbol$d('replace');

	var defineWellKnownSymbol$c = defineWellKnownSymbol$l; // `Symbol.search` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.search

	defineWellKnownSymbol$c('search');

	var defineWellKnownSymbol$b = defineWellKnownSymbol$l; // `Symbol.species` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.species

	defineWellKnownSymbol$b('species');

	var defineWellKnownSymbol$a = defineWellKnownSymbol$l; // `Symbol.split` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.split

	defineWellKnownSymbol$a('split');

	var defineWellKnownSymbol$9 = defineWellKnownSymbol$l; // `Symbol.toPrimitive` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.toprimitive

	defineWellKnownSymbol$9('toPrimitive');

	var defineWellKnownSymbol$8 = defineWellKnownSymbol$l; // `Symbol.toStringTag` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.tostringtag

	defineWellKnownSymbol$8('toStringTag');

	var defineWellKnownSymbol$7 = defineWellKnownSymbol$l; // `Symbol.unscopables` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.unscopables

	defineWellKnownSymbol$7('unscopables');

	var global$q = global$V;
	var setToStringTag$2 = setToStringTag$6; // JSON[@@toStringTag] property
	// https://tc39.es/ecma262/#sec-json-@@tostringtag

	setToStringTag$2(global$q.JSON, 'JSON', true);

	var path$i = path$t;
	var symbol$4 = path$i.Symbol;

	var parent$10 = symbol$4;
	var symbol$3 = parent$10;

	var parent$$ = symbol$3;
	var symbol$2 = parent$$;

	var defineWellKnownSymbol$6 = defineWellKnownSymbol$l; // `Symbol.asyncDispose` well-known symbol
	// https://github.com/tc39/proposal-using-statement

	defineWellKnownSymbol$6('asyncDispose');

	var defineWellKnownSymbol$5 = defineWellKnownSymbol$l; // `Symbol.dispose` well-known symbol
	// https://github.com/tc39/proposal-using-statement

	defineWellKnownSymbol$5('dispose');

	var defineWellKnownSymbol$4 = defineWellKnownSymbol$l; // `Symbol.matcher` well-known symbol
	// https://github.com/tc39/proposal-pattern-matching

	defineWellKnownSymbol$4('matcher');

	var defineWellKnownSymbol$3 = defineWellKnownSymbol$l; // `Symbol.metadata` well-known symbol
	// https://github.com/tc39/proposal-decorators

	defineWellKnownSymbol$3('metadata');

	var defineWellKnownSymbol$2 = defineWellKnownSymbol$l; // `Symbol.observable` well-known symbol
	// https://github.com/tc39/proposal-observable

	defineWellKnownSymbol$2('observable');

	var defineWellKnownSymbol$1 = defineWellKnownSymbol$l; // `Symbol.patternMatch` well-known symbol
	// https://github.com/tc39/proposal-pattern-matching

	defineWellKnownSymbol$1('patternMatch');

	var defineWellKnownSymbol = defineWellKnownSymbol$l;
	defineWellKnownSymbol('replaceAll');

	var parent$_ = symbol$2; // TODO: Remove from `core-js@4`
	// TODO: Remove from `core-js@4`

	var symbol$1 = parent$_;

	(function (module) {
	  module.exports = symbol$1;
	})(symbol$5);

	var _Symbol$1 = /*@__PURE__*/getDefaultExportFromCjs(symbol$5.exports);

	function _iterableToArrayLimit(arr, i) {
	  var _i = arr == null ? null : typeof _Symbol$1 !== "undefined" && _getIteratorMethod(arr) || arr["@@iterator"];

	  if (_i == null) return;
	  var _arr = [];
	  var _n = true;
	  var _d = false;

	  var _s, _e;

	  try {
	    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
	      _arr.push(_s.value);

	      if (i && _arr.length === i) break;
	    }
	  } catch (err) {
	    _d = true;
	    _e = err;
	  } finally {
	    try {
	      if (!_n && _i["return"] != null) _i["return"]();
	    } finally {
	      if (_d) throw _e;
	    }
	  }

	  return _arr;
	}

	var slice$6 = {exports: {}};

	var $$E = _export;
	var global$p = global$V;
	var isArray$3 = isArray$d;
	var isConstructor$1 = isConstructor$4;
	var isObject$a = isObject$j;
	var toAbsoluteIndex$2 = toAbsoluteIndex$5;
	var lengthOfArrayLike$7 = lengthOfArrayLike$d;
	var toIndexedObject$1 = toIndexedObject$b;
	var createProperty$1 = createProperty$6;
	var wellKnownSymbol$6 = wellKnownSymbol$m;
	var arrayMethodHasSpeciesSupport$3 = arrayMethodHasSpeciesSupport$5;
	var un$Slice = arraySlice$5;
	var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport$3('slice');
	var SPECIES$3 = wellKnownSymbol$6('species');
	var Array$2 = global$p.Array;
	var max$1 = Math.max; // `Array.prototype.slice` method
	// https://tc39.es/ecma262/#sec-array.prototype.slice
	// fallback for not array-like ES3 strings and DOM objects

	$$E({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$3
	}, {
	  slice: function slice(start, end) {
	    var O = toIndexedObject$1(this);
	    var length = lengthOfArrayLike$7(O);
	    var k = toAbsoluteIndex$2(start, length);
	    var fin = toAbsoluteIndex$2(end === undefined ? length : end, length); // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible

	    var Constructor, result, n;

	    if (isArray$3(O)) {
	      Constructor = O.constructor; // cross-realm fallback

	      if (isConstructor$1(Constructor) && (Constructor === Array$2 || isArray$3(Constructor.prototype))) {
	        Constructor = undefined;
	      } else if (isObject$a(Constructor)) {
	        Constructor = Constructor[SPECIES$3];
	        if (Constructor === null) Constructor = undefined;
	      }

	      if (Constructor === Array$2 || Constructor === undefined) {
	        return un$Slice(O, k, fin);
	      }
	    }

	    result = new (Constructor === undefined ? Array$2 : Constructor)(max$1(fin - k, 0));

	    for (n = 0; k < fin; k++, n++) if (k in O) createProperty$1(result, n, O[k]);

	    result.length = n;
	    return result;
	  }
	});

	var path$h = path$t;

	var entryVirtual$o = function (CONSTRUCTOR) {
	  return path$h[CONSTRUCTOR + 'Prototype'];
	};

	var entryVirtual$n = entryVirtual$o;
	var slice$5 = entryVirtual$n('Array').slice;

	var isPrototypeOf$p = objectIsPrototypeOf;
	var method$l = slice$5;
	var ArrayPrototype$j = Array.prototype;

	var slice$4 = function (it) {
	  var own = it.slice;
	  return it === ArrayPrototype$j || isPrototypeOf$p(ArrayPrototype$j, it) && own === ArrayPrototype$j.slice ? method$l : own;
	};

	var parent$Z = slice$4;
	var slice$3 = parent$Z;

	var parent$Y = slice$3;
	var slice$2 = parent$Y;

	var parent$X = slice$2;
	var slice$1 = parent$X;

	(function (module) {
	  module.exports = slice$1;
	})(slice$6);

	var _sliceInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(slice$6.exports);

	var from$2 = {exports: {}};

	var parent$W = from$3;
	var from$1 = parent$W;

	var parent$V = from$1;
	var from = parent$V;

	(function (module) {
	  module.exports = from;
	})(from$2);

	var _Array$from = /*@__PURE__*/getDefaultExportFromCjs(from$2.exports);

	function _arrayLikeToArray$8(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;

	  for (var i = 0, arr2 = new Array(len); i < len; i++) {
	    arr2[i] = arr[i];
	  }

	  return arr2;
	}

	function _unsupportedIterableToArray$8(o, minLen) {
	  var _context;

	  if (!o) return;
	  if (typeof o === "string") return _arrayLikeToArray$8(o, minLen);

	  var n = _sliceInstanceProperty$1(_context = Object.prototype.toString.call(o)).call(_context, 8, -1);

	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return _Array$from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$8(o, minLen);
	}

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _slicedToArray(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray$8(arr, i) || _nonIterableRest();
	}

	var iterator$5 = {exports: {}};

	var WrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
	var iterator$4 = WrappedWellKnownSymbolModule.f('iterator');

	var parent$U = iterator$4;
	var iterator$3 = parent$U;

	var parent$T = iterator$3;
	var iterator$2 = parent$T;

	var parent$S = iterator$2;
	var iterator$1 = parent$S;

	(function (module) {
	  module.exports = iterator$1;
	})(iterator$5);

	var _Symbol$iterator$1 = /*@__PURE__*/getDefaultExportFromCjs(iterator$5.exports);

	function _typeof$1(obj) {
	  "@babel/helpers - typeof";

	  return _typeof$1 = "function" == typeof _Symbol$1 && "symbol" == typeof _Symbol$iterator$1 ? function (obj) {
	    return typeof obj;
	  } : function (obj) {
	    return obj && "function" == typeof _Symbol$1 && obj.constructor === _Symbol$1 && obj !== _Symbol$1.prototype ? "symbol" : typeof obj;
	  }, _typeof$1(obj);
	}

	function _arrayWithoutHoles(arr) {
	  if (_Array$isArray$1(arr)) return _arrayLikeToArray$8(arr);
	}

	function _iterableToArray(iter) {
	  if (typeof _Symbol$1 !== "undefined" && _getIteratorMethod(iter) != null || iter["@@iterator"] != null) return _Array$from(iter);
	}

	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _toConsumableArray(arr) {
	  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$8(arr) || _nonIterableSpread();
	}

	var symbol = {exports: {}};

	(function (module) {
	  module.exports = symbol$3;
	})(symbol);

	var _Symbol = /*@__PURE__*/getDefaultExportFromCjs(symbol.exports);

	var concat$5 = {exports: {}};

	var entryVirtual$m = entryVirtual$o;
	var concat$4 = entryVirtual$m('Array').concat;

	var isPrototypeOf$o = objectIsPrototypeOf;
	var method$k = concat$4;
	var ArrayPrototype$i = Array.prototype;

	var concat$3 = function (it) {
	  var own = it.concat;
	  return it === ArrayPrototype$i || isPrototypeOf$o(ArrayPrototype$i, it) && own === ArrayPrototype$i.concat ? method$k : own;
	};

	var parent$R = concat$3;
	var concat$2 = parent$R;

	(function (module) {
	  module.exports = concat$2;
	})(concat$5);

	var _concatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(concat$5.exports);

	var slice = {exports: {}};

	(function (module) {
	  module.exports = slice$3;
	})(slice);

	var _sliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(slice.exports);

	var ownKeys$7 = {exports: {}};

	var $$D = _export;
	var ownKeys$6 = ownKeys$9; // `Reflect.ownKeys` method
	// https://tc39.es/ecma262/#sec-reflect.ownkeys

	$$D({
	  target: 'Reflect',
	  stat: true
	}, {
	  ownKeys: ownKeys$6
	});

	var path$g = path$t;
	var ownKeys$5 = path$g.Reflect.ownKeys;

	var parent$Q = ownKeys$5;
	var ownKeys$4 = parent$Q;

	(function (module) {
	  module.exports = ownKeys$4;
	})(ownKeys$7);

	var _Reflect$ownKeys = /*@__PURE__*/getDefaultExportFromCjs(ownKeys$7.exports);

	var isArray$2 = {exports: {}};

	(function (module) {
	  module.exports = isArray$7;
	})(isArray$2);

	var _Array$isArray = /*@__PURE__*/getDefaultExportFromCjs(isArray$2.exports);

	var map$6 = {exports: {}};

	var $$C = _export;
	var $map = arrayIteration.map;
	var arrayMethodHasSpeciesSupport$2 = arrayMethodHasSpeciesSupport$5;
	var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport$2('map'); // `Array.prototype.map` method
	// https://tc39.es/ecma262/#sec-array.prototype.map
	// with adding support of @@species

	$$C({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$2
	}, {
	  map: function map(callbackfn
	  /* , thisArg */
	  ) {
	    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$l = entryVirtual$o;
	var map$5 = entryVirtual$l('Array').map;

	var isPrototypeOf$n = objectIsPrototypeOf;
	var method$j = map$5;
	var ArrayPrototype$h = Array.prototype;

	var map$4 = function (it) {
	  var own = it.map;
	  return it === ArrayPrototype$h || isPrototypeOf$n(ArrayPrototype$h, it) && own === ArrayPrototype$h.map ? method$j : own;
	};

	var parent$P = map$4;
	var map$3 = parent$P;

	(function (module) {
	  module.exports = map$3;
	})(map$6);

	var _mapInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(map$6.exports);

	var keys$6 = {exports: {}};

	var $$B = _export;
	var toObject$7 = toObject$e;
	var nativeKeys = objectKeys$4;
	var fails$g = fails$v;
	var FAILS_ON_PRIMITIVES$2 = fails$g(function () {
	  nativeKeys(1);
	}); // `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys

	$$B({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$2
	}, {
	  keys: function keys(it) {
	    return nativeKeys(toObject$7(it));
	  }
	});

	var path$f = path$t;
	var keys$5 = path$f.Object.keys;

	var parent$O = keys$5;
	var keys$4 = parent$O;

	(function (module) {
	  module.exports = keys$4;
	})(keys$6);

	var _Object$keys = /*@__PURE__*/getDefaultExportFromCjs(keys$6.exports);

	var now$3 = {exports: {}};

	var $$A = _export;
	var global$o = global$V;
	var uncurryThis$d = functionUncurryThis;
	var Date$1 = global$o.Date;
	var getTime = uncurryThis$d(Date$1.prototype.getTime); // `Date.now` method
	// https://tc39.es/ecma262/#sec-date.now

	$$A({
	  target: 'Date',
	  stat: true
	}, {
	  now: function now() {
	    return getTime(new Date$1());
	  }
	});

	var path$e = path$t;
	var now$2 = path$e.Date.now;

	var parent$N = now$2;
	var now$1 = parent$N;

	(function (module) {
	  module.exports = now$1;
	})(now$3);

	var _Date$now = /*@__PURE__*/getDefaultExportFromCjs(now$3.exports);

	var bind$e = {exports: {}};

	var global$n = global$V;
	var uncurryThis$c = functionUncurryThis;
	var aCallable$7 = aCallable$b;
	var isObject$9 = isObject$j;
	var hasOwn$7 = hasOwnProperty_1;
	var arraySlice$3 = arraySlice$5;
	var NATIVE_BIND = functionBindNative;
	var Function$3 = global$n.Function;
	var concat$1 = uncurryThis$c([].concat);
	var join = uncurryThis$c([].join);
	var factories = {};

	var construct$3 = function (C, argsLength, args) {
	  if (!hasOwn$7(factories, argsLength)) {
	    for (var list = [], i = 0; i < argsLength; i++) list[i] = 'a[' + i + ']';

	    factories[argsLength] = Function$3('C,a', 'return new C(' + join(list, ',') + ')');
	  }

	  return factories[argsLength](C, args);
	}; // `Function.prototype.bind` method implementation
	// https://tc39.es/ecma262/#sec-function.prototype.bind


	var functionBind = NATIVE_BIND ? Function$3.bind : function bind(that
	/* , ...args */
	) {
	  var F = aCallable$7(this);
	  var Prototype = F.prototype;
	  var partArgs = arraySlice$3(arguments, 1);

	  var boundFunction = function
	    /* args... */
	  bound() {
	    var args = concat$1(partArgs, arraySlice$3(arguments));
	    return this instanceof boundFunction ? construct$3(F, args.length, args) : F.apply(that, args);
	  };

	  if (isObject$9(Prototype)) boundFunction.prototype = Prototype;
	  return boundFunction;
	};

	var $$z = _export;
	var bind$d = functionBind; // `Function.prototype.bind` method
	// https://tc39.es/ecma262/#sec-function.prototype.bind

	$$z({
	  target: 'Function',
	  proto: true,
	  forced: Function.bind !== bind$d
	}, {
	  bind: bind$d
	});

	var entryVirtual$k = entryVirtual$o;
	var bind$c = entryVirtual$k('Function').bind;

	var isPrototypeOf$m = objectIsPrototypeOf;
	var method$i = bind$c;
	var FunctionPrototype = Function.prototype;

	var bind$b = function (it) {
	  var own = it.bind;
	  return it === FunctionPrototype || isPrototypeOf$m(FunctionPrototype, it) && own === FunctionPrototype.bind ? method$i : own;
	};

	var parent$M = bind$b;
	var bind$a = parent$M;

	(function (module) {
	  module.exports = bind$a;
	})(bind$e);

	var _bindInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(bind$e.exports);

	var forEach$9 = {exports: {}};

	var fails$f = fails$v;

	var arrayMethodIsStrict$6 = function (METHOD_NAME, argument) {
	  var method = [][METHOD_NAME];
	  return !!method && fails$f(function () {
	    // eslint-disable-next-line no-useless-call -- required for testing
	    method.call(null, argument || function () {
	      return 1;
	    }, 1);
	  });
	};

	var $forEach = arrayIteration.forEach;
	var arrayMethodIsStrict$5 = arrayMethodIsStrict$6;
	var STRICT_METHOD$5 = arrayMethodIsStrict$5('forEach'); // `Array.prototype.forEach` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.foreach

	var arrayForEach = !STRICT_METHOD$5 ? function forEach(callbackfn
	/* , thisArg */
	) {
	  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined); // eslint-disable-next-line es/no-array-prototype-foreach -- safe
	} : [].forEach;

	var $$y = _export;
	var forEach$8 = arrayForEach; // `Array.prototype.forEach` method
	// https://tc39.es/ecma262/#sec-array.prototype.foreach
	// eslint-disable-next-line es/no-array-prototype-foreach -- safe

	$$y({
	  target: 'Array',
	  proto: true,
	  forced: [].forEach != forEach$8
	}, {
	  forEach: forEach$8
	});

	var entryVirtual$j = entryVirtual$o;
	var forEach$7 = entryVirtual$j('Array').forEach;

	var parent$L = forEach$7;
	var forEach$6 = parent$L;

	var classof$6 = classof$f;
	var hasOwn$6 = hasOwnProperty_1;
	var isPrototypeOf$l = objectIsPrototypeOf;
	var method$h = forEach$6;
	var ArrayPrototype$g = Array.prototype;
	var DOMIterables$3 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var forEach$5 = function (it) {
	  var own = it.forEach;
	  return it === ArrayPrototype$g || isPrototypeOf$l(ArrayPrototype$g, it) && own === ArrayPrototype$g.forEach || hasOwn$6(DOMIterables$3, classof$6(it)) ? method$h : own;
	};

	(function (module) {
	  module.exports = forEach$5;
	})(forEach$9);

	var _forEachInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(forEach$9.exports);

	var reverse$6 = {exports: {}};

	var $$x = _export;
	var uncurryThis$b = functionUncurryThis;
	var isArray$1 = isArray$d;
	var un$Reverse = uncurryThis$b([].reverse);
	var test$1 = [1, 2]; // `Array.prototype.reverse` method
	// https://tc39.es/ecma262/#sec-array.prototype.reverse
	// fix for Safari 12.0 bug
	// https://bugs.webkit.org/show_bug.cgi?id=188794

	$$x({
	  target: 'Array',
	  proto: true,
	  forced: String(test$1) === String(test$1.reverse())
	}, {
	  reverse: function reverse() {
	    // eslint-disable-next-line no-self-assign -- dirty hack
	    if (isArray$1(this)) this.length = this.length;
	    return un$Reverse(this);
	  }
	});

	var entryVirtual$i = entryVirtual$o;
	var reverse$5 = entryVirtual$i('Array').reverse;

	var isPrototypeOf$k = objectIsPrototypeOf;
	var method$g = reverse$5;
	var ArrayPrototype$f = Array.prototype;

	var reverse$4 = function (it) {
	  var own = it.reverse;
	  return it === ArrayPrototype$f || isPrototypeOf$k(ArrayPrototype$f, it) && own === ArrayPrototype$f.reverse ? method$g : own;
	};

	var parent$K = reverse$4;
	var reverse$3 = parent$K;

	(function (module) {
	  module.exports = reverse$3;
	})(reverse$6);

	var _reverseInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reverse$6.exports);

	var splice$3 = {exports: {}};

	var $$w = _export;
	var global$m = global$V;
	var toAbsoluteIndex$1 = toAbsoluteIndex$5;
	var toIntegerOrInfinity$1 = toIntegerOrInfinity$5;
	var lengthOfArrayLike$6 = lengthOfArrayLike$d;
	var toObject$6 = toObject$e;
	var arraySpeciesCreate$1 = arraySpeciesCreate$4;
	var createProperty = createProperty$6;
	var arrayMethodHasSpeciesSupport$1 = arrayMethodHasSpeciesSupport$5;
	var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport$1('splice');
	var TypeError$9 = global$m.TypeError;
	var max = Math.max;
	var min = Math.min;
	var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded'; // `Array.prototype.splice` method
	// https://tc39.es/ecma262/#sec-array.prototype.splice
	// with adding support of @@species

	$$w({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$1
	}, {
	  splice: function splice(start, deleteCount
	  /* , ...items */
	  ) {
	    var O = toObject$6(this);
	    var len = lengthOfArrayLike$6(O);
	    var actualStart = toAbsoluteIndex$1(start, len);
	    var argumentsLength = arguments.length;
	    var insertCount, actualDeleteCount, A, k, from, to;

	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min(max(toIntegerOrInfinity$1(deleteCount), 0), len - actualStart);
	    }

	    if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER) {
	      throw TypeError$9(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
	    }

	    A = arraySpeciesCreate$1(O, actualDeleteCount);

	    for (k = 0; k < actualDeleteCount; k++) {
	      from = actualStart + k;
	      if (from in O) createProperty(A, k, O[from]);
	    }

	    A.length = actualDeleteCount;

	    if (insertCount < actualDeleteCount) {
	      for (k = actualStart; k < len - actualDeleteCount; k++) {
	        from = k + actualDeleteCount;
	        to = k + insertCount;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }

	      for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
	    } else if (insertCount > actualDeleteCount) {
	      for (k = len - actualDeleteCount; k > actualStart; k--) {
	        from = k + actualDeleteCount - 1;
	        to = k + insertCount - 1;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }
	    }

	    for (k = 0; k < insertCount; k++) {
	      O[k + actualStart] = arguments[k + 2];
	    }

	    O.length = len - actualDeleteCount + insertCount;
	    return A;
	  }
	});

	var entryVirtual$h = entryVirtual$o;
	var splice$2 = entryVirtual$h('Array').splice;

	var isPrototypeOf$j = objectIsPrototypeOf;
	var method$f = splice$2;
	var ArrayPrototype$e = Array.prototype;

	var splice$1 = function (it) {
	  var own = it.splice;
	  return it === ArrayPrototype$e || isPrototypeOf$j(ArrayPrototype$e, it) && own === ArrayPrototype$e.splice ? method$f : own;
	};

	var parent$J = splice$1;
	var splice = parent$J;

	(function (module) {
	  module.exports = splice;
	})(splice$3);

	var _spliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(splice$3.exports);

	var assign$5 = {exports: {}};

	var DESCRIPTORS$5 = descriptors;
	var uncurryThis$a = functionUncurryThis;
	var call$4 = functionCall;
	var fails$e = fails$v;
	var objectKeys$1 = objectKeys$4;
	var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
	var propertyIsEnumerableModule = objectPropertyIsEnumerable;
	var toObject$5 = toObject$e;
	var IndexedObject$1 = indexedObject; // eslint-disable-next-line es/no-object-assign -- safe

	var $assign = Object.assign; // eslint-disable-next-line es/no-object-defineproperty -- required for testing

	var defineProperty$3 = Object.defineProperty;
	var concat = uncurryThis$a([].concat); // `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign

	var objectAssign = !$assign || fails$e(function () {
	  // should have correct order of operations (Edge bug)
	  if (DESCRIPTORS$5 && $assign({
	    b: 1
	  }, $assign(defineProperty$3({}, 'a', {
	    enumerable: true,
	    get: function () {
	      defineProperty$3(this, 'b', {
	        value: 3,
	        enumerable: false
	      });
	    }
	  }), {
	    b: 2
	  })).b !== 1) return true; // should work with symbols and should have deterministic property order (V8 bug)

	  var A = {};
	  var B = {}; // eslint-disable-next-line es/no-symbol -- safe

	  var symbol = Symbol();
	  var alphabet = 'abcdefghijklmnopqrst';
	  A[symbol] = 7;
	  alphabet.split('').forEach(function (chr) {
	    B[chr] = chr;
	  });
	  return $assign({}, A)[symbol] != 7 || objectKeys$1($assign({}, B)).join('') != alphabet;
	}) ? function assign(target, source) {
	  // eslint-disable-line no-unused-vars -- required for `.length`
	  var T = toObject$5(target);
	  var argumentsLength = arguments.length;
	  var index = 1;
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
	  var propertyIsEnumerable = propertyIsEnumerableModule.f;

	  while (argumentsLength > index) {
	    var S = IndexedObject$1(arguments[index++]);
	    var keys = getOwnPropertySymbols ? concat(objectKeys$1(S), getOwnPropertySymbols(S)) : objectKeys$1(S);
	    var length = keys.length;
	    var j = 0;
	    var key;

	    while (length > j) {
	      key = keys[j++];
	      if (!DESCRIPTORS$5 || call$4(propertyIsEnumerable, S, key)) T[key] = S[key];
	    }
	  }

	  return T;
	} : $assign;

	var $$v = _export;
	var assign$4 = objectAssign; // `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign
	// eslint-disable-next-line es/no-object-assign -- required for testing

	$$v({
	  target: 'Object',
	  stat: true,
	  forced: Object.assign !== assign$4
	}, {
	  assign: assign$4
	});

	var path$d = path$t;
	var assign$3 = path$d.Object.assign;

	var parent$I = assign$3;
	var assign$2 = parent$I;

	(function (module) {
	  module.exports = assign$2;
	})(assign$5);

	var _Object$assign = /*@__PURE__*/getDefaultExportFromCjs(assign$5.exports);

	var includes$4 = {exports: {}};

	var $$u = _export;
	var $includes = arrayIncludes.includes;
	// https://tc39.es/ecma262/#sec-array.prototype.includes

	$$u({
	  target: 'Array',
	  proto: true
	}, {
	  includes: function includes(el
	  /* , fromIndex = 0 */
	  ) {
	    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	}); // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

	var entryVirtual$g = entryVirtual$o;
	var includes$3 = entryVirtual$g('Array').includes;

	var isObject$8 = isObject$j;
	var classof$5 = classofRaw$1;
	var wellKnownSymbol$5 = wellKnownSymbol$m;
	var MATCH$1 = wellKnownSymbol$5('match'); // `IsRegExp` abstract operation
	// https://tc39.es/ecma262/#sec-isregexp

	var isRegexp = function (it) {
	  var isRegExp;
	  return isObject$8(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$5(it) == 'RegExp');
	};

	var global$l = global$V;
	var isRegExp = isRegexp;
	var TypeError$8 = global$l.TypeError;

	var notARegexp = function (it) {
	  if (isRegExp(it)) {
	    throw TypeError$8("The method doesn't accept regular expressions");
	  }

	  return it;
	};

	var wellKnownSymbol$4 = wellKnownSymbol$m;
	var MATCH = wellKnownSymbol$4('match');

	var correctIsRegexpLogic = function (METHOD_NAME) {
	  var regexp = /./;

	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (error1) {
	    try {
	      regexp[MATCH] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (error2) {
	      /* empty */
	    }
	  }

	  return false;
	};

	var $$t = _export;
	var uncurryThis$9 = functionUncurryThis;
	var notARegExp = notARegexp;
	var requireObjectCoercible$2 = requireObjectCoercible$6;
	var toString$6 = toString$a;
	var correctIsRegExpLogic = correctIsRegexpLogic;
	var stringIndexOf = uncurryThis$9(''.indexOf); // `String.prototype.includes` method
	// https://tc39.es/ecma262/#sec-string.prototype.includes

	$$t({
	  target: 'String',
	  proto: true,
	  forced: !correctIsRegExpLogic('includes')
	}, {
	  includes: function includes(searchString
	  /* , position = 0 */
	  ) {
	    return !!~stringIndexOf(toString$6(requireObjectCoercible$2(this)), toString$6(notARegExp(searchString)), arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$f = entryVirtual$o;
	var includes$2 = entryVirtual$f('String').includes;

	var isPrototypeOf$i = objectIsPrototypeOf;
	var arrayMethod = includes$3;
	var stringMethod = includes$2;
	var ArrayPrototype$d = Array.prototype;
	var StringPrototype$2 = String.prototype;

	var includes$1 = function (it) {
	  var own = it.includes;
	  if (it === ArrayPrototype$d || isPrototypeOf$i(ArrayPrototype$d, it) && own === ArrayPrototype$d.includes) return arrayMethod;

	  if (typeof it == 'string' || it === StringPrototype$2 || isPrototypeOf$i(StringPrototype$2, it) && own === StringPrototype$2.includes) {
	    return stringMethod;
	  }

	  return own;
	};

	var parent$H = includes$1;
	var includes = parent$H;

	(function (module) {
	  module.exports = includes;
	})(includes$4);

	var _includesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(includes$4.exports);

	var getPrototypeOf$6 = {exports: {}};

	var $$s = _export;
	var fails$d = fails$v;
	var toObject$4 = toObject$e;
	var nativeGetPrototypeOf = objectGetPrototypeOf;
	var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;
	var FAILS_ON_PRIMITIVES$1 = fails$d(function () {
	  nativeGetPrototypeOf(1);
	}); // `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof

	$$s({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$1,
	  sham: !CORRECT_PROTOTYPE_GETTER
	}, {
	  getPrototypeOf: function getPrototypeOf(it) {
	    return nativeGetPrototypeOf(toObject$4(it));
	  }
	});

	var path$c = path$t;
	var getPrototypeOf$5 = path$c.Object.getPrototypeOf;

	var parent$G = getPrototypeOf$5;
	var getPrototypeOf$4 = parent$G;

	(function (module) {
	  module.exports = getPrototypeOf$4;
	})(getPrototypeOf$6);

	var _Object$getPrototypeOf$1 = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOf$6.exports);

	var filter$3 = {exports: {}};

	var $$r = _export;
	var $filter = arrayIteration.filter;
	var arrayMethodHasSpeciesSupport = arrayMethodHasSpeciesSupport$5;
	var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter'); // `Array.prototype.filter` method
	// https://tc39.es/ecma262/#sec-array.prototype.filter
	// with adding support of @@species

	$$r({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT
	}, {
	  filter: function filter(callbackfn
	  /* , thisArg */
	  ) {
	    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$e = entryVirtual$o;
	var filter$2 = entryVirtual$e('Array').filter;

	var isPrototypeOf$h = objectIsPrototypeOf;
	var method$e = filter$2;
	var ArrayPrototype$c = Array.prototype;

	var filter$1 = function (it) {
	  var own = it.filter;
	  return it === ArrayPrototype$c || isPrototypeOf$h(ArrayPrototype$c, it) && own === ArrayPrototype$c.filter ? method$e : own;
	};

	var parent$F = filter$1;
	var filter = parent$F;

	(function (module) {
	  module.exports = filter;
	})(filter$3);

	var _filterInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(filter$3.exports);

	var values$6 = {exports: {}};

	var DESCRIPTORS$4 = descriptors;
	var uncurryThis$8 = functionUncurryThis;
	var objectKeys = objectKeys$4;
	var toIndexedObject = toIndexedObject$b;
	var $propertyIsEnumerable = objectPropertyIsEnumerable.f;
	var propertyIsEnumerable = uncurryThis$8($propertyIsEnumerable);
	var push$3 = uncurryThis$8([].push); // `Object.{ entries, values }` methods implementation

	var createMethod$2 = function (TO_ENTRIES) {
	  return function (it) {
	    var O = toIndexedObject(it);
	    var keys = objectKeys(O);
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;

	    while (length > i) {
	      key = keys[i++];

	      if (!DESCRIPTORS$4 || propertyIsEnumerable(O, key)) {
	        push$3(result, TO_ENTRIES ? [key, O[key]] : O[key]);
	      }
	    }

	    return result;
	  };
	};

	var objectToArray = {
	  // `Object.entries` method
	  // https://tc39.es/ecma262/#sec-object.entries
	  entries: createMethod$2(true),
	  // `Object.values` method
	  // https://tc39.es/ecma262/#sec-object.values
	  values: createMethod$2(false)
	};

	var $$q = _export;
	var $values = objectToArray.values; // `Object.values` method
	// https://tc39.es/ecma262/#sec-object.values

	$$q({
	  target: 'Object',
	  stat: true
	}, {
	  values: function values(O) {
	    return $values(O);
	  }
	});

	var path$b = path$t;
	var values$5 = path$b.Object.values;

	var parent$E = values$5;
	var values$4 = parent$E;

	(function (module) {
	  module.exports = values$4;
	})(values$6);

	var _Object$values2 = /*@__PURE__*/getDefaultExportFromCjs(values$6.exports);

	var _parseInt$3 = {exports: {}};

	var whitespaces$4 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' + '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

	var uncurryThis$7 = functionUncurryThis;
	var requireObjectCoercible$1 = requireObjectCoercible$6;
	var toString$5 = toString$a;
	var whitespaces$3 = whitespaces$4;
	var replace$2 = uncurryThis$7(''.replace);
	var whitespace = '[' + whitespaces$3 + ']';
	var ltrim = RegExp('^' + whitespace + whitespace + '*');
	var rtrim = RegExp(whitespace + whitespace + '*$'); // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation

	var createMethod$1 = function (TYPE) {
	  return function ($this) {
	    var string = toString$5(requireObjectCoercible$1($this));
	    if (TYPE & 1) string = replace$2(string, ltrim, '');
	    if (TYPE & 2) string = replace$2(string, rtrim, '');
	    return string;
	  };
	};

	var stringTrim = {
	  // `String.prototype.{ trimLeft, trimStart }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
	  start: createMethod$1(1),
	  // `String.prototype.{ trimRight, trimEnd }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimend
	  end: createMethod$1(2),
	  // `String.prototype.trim` method
	  // https://tc39.es/ecma262/#sec-string.prototype.trim
	  trim: createMethod$1(3)
	};

	var global$k = global$V;
	var fails$c = fails$v;
	var uncurryThis$6 = functionUncurryThis;
	var toString$4 = toString$a;
	var trim$5 = stringTrim.trim;
	var whitespaces$2 = whitespaces$4;
	var $parseInt$1 = global$k.parseInt;
	var Symbol$2 = global$k.Symbol;
	var ITERATOR$1 = Symbol$2 && Symbol$2.iterator;
	var hex = /^[+-]?0x/i;
	var exec$1 = uncurryThis$6(hex.exec);
	var FORCED$5 = $parseInt$1(whitespaces$2 + '08') !== 8 || $parseInt$1(whitespaces$2 + '0x16') !== 22 // MS Edge 18- broken with boxed symbols
	|| ITERATOR$1 && !fails$c(function () {
	  $parseInt$1(Object(ITERATOR$1));
	}); // `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix

	var numberParseInt = FORCED$5 ? function parseInt(string, radix) {
	  var S = trim$5(toString$4(string));
	  return $parseInt$1(S, radix >>> 0 || (exec$1(hex, S) ? 16 : 10));
	} : $parseInt$1;

	var $$p = _export;
	var $parseInt = numberParseInt; // `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix

	$$p({
	  global: true,
	  forced: parseInt != $parseInt
	}, {
	  parseInt: $parseInt
	});

	var path$a = path$t;
	var _parseInt$2 = path$a.parseInt;

	var parent$D = _parseInt$2;
	var _parseInt$1 = parent$D;

	(function (module) {
	  module.exports = _parseInt$1;
	})(_parseInt$3);

	var _parseInt = /*@__PURE__*/getDefaultExportFromCjs(_parseInt$3.exports);

	var indexOf$3 = {exports: {}};

	/* eslint-disable es/no-array-prototype-indexof -- required for testing */


	var $$o = _export;
	var uncurryThis$5 = functionUncurryThis;
	var $IndexOf = arrayIncludes.indexOf;
	var arrayMethodIsStrict$4 = arrayMethodIsStrict$6;
	var un$IndexOf = uncurryThis$5([].indexOf);
	var NEGATIVE_ZERO = !!un$IndexOf && 1 / un$IndexOf([1], 1, -0) < 0;
	var STRICT_METHOD$4 = arrayMethodIsStrict$4('indexOf'); // `Array.prototype.indexOf` method
	// https://tc39.es/ecma262/#sec-array.prototype.indexof

	$$o({
	  target: 'Array',
	  proto: true,
	  forced: NEGATIVE_ZERO || !STRICT_METHOD$4
	}, {
	  indexOf: function indexOf(searchElement
	  /* , fromIndex = 0 */
	  ) {
	    var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
	    return NEGATIVE_ZERO // convert -0 to +0
	    ? un$IndexOf(this, searchElement, fromIndex) || 0 : $IndexOf(this, searchElement, fromIndex);
	  }
	});

	var entryVirtual$d = entryVirtual$o;
	var indexOf$2 = entryVirtual$d('Array').indexOf;

	var isPrototypeOf$g = objectIsPrototypeOf;
	var method$d = indexOf$2;
	var ArrayPrototype$b = Array.prototype;

	var indexOf$1 = function (it) {
	  var own = it.indexOf;
	  return it === ArrayPrototype$b || isPrototypeOf$g(ArrayPrototype$b, it) && own === ArrayPrototype$b.indexOf ? method$d : own;
	};

	var parent$C = indexOf$1;
	var indexOf = parent$C;

	(function (module) {
	  module.exports = indexOf;
	})(indexOf$3);

	var _indexOfInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(indexOf$3.exports);

	var trim$4 = {exports: {}};

	var PROPER_FUNCTION_NAME = functionName.PROPER;
	var fails$b = fails$v;
	var whitespaces$1 = whitespaces$4;
	var non = '\u200B\u0085\u180E'; // check that a method works with the correct list
	// of whitespaces and has a correct name

	var stringTrimForced = function (METHOD_NAME) {
	  return fails$b(function () {
	    return !!whitespaces$1[METHOD_NAME]() || non[METHOD_NAME]() !== non || PROPER_FUNCTION_NAME && whitespaces$1[METHOD_NAME].name !== METHOD_NAME;
	  });
	};

	var $$n = _export;
	var $trim = stringTrim.trim;
	var forcedStringTrimMethod = stringTrimForced; // `String.prototype.trim` method
	// https://tc39.es/ecma262/#sec-string.prototype.trim

	$$n({
	  target: 'String',
	  proto: true,
	  forced: forcedStringTrimMethod('trim')
	}, {
	  trim: function trim() {
	    return $trim(this);
	  }
	});

	var entryVirtual$c = entryVirtual$o;
	var trim$3 = entryVirtual$c('String').trim;

	var isPrototypeOf$f = objectIsPrototypeOf;
	var method$c = trim$3;
	var StringPrototype$1 = String.prototype;

	var trim$2 = function (it) {
	  var own = it.trim;
	  return typeof it == 'string' || it === StringPrototype$1 || isPrototypeOf$f(StringPrototype$1, it) && own === StringPrototype$1.trim ? method$c : own;
	};

	var parent$B = trim$2;
	var trim$1 = parent$B;

	(function (module) {
	  module.exports = trim$1;
	})(trim$4);

	var _trimInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(trim$4.exports);

	var create$9 = {exports: {}};

	var $$m = _export;
	var DESCRIPTORS$3 = descriptors;
	var create$8 = objectCreate; // `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create

	$$m({
	  target: 'Object',
	  stat: true,
	  sham: !DESCRIPTORS$3
	}, {
	  create: create$8
	});

	var path$9 = path$t;
	var Object$1 = path$9.Object;

	var create$7 = function create(P, D) {
	  return Object$1.create(P, D);
	};

	var parent$A = create$7;
	var create$6 = parent$A;

	(function (module) {
	  module.exports = create$6;
	})(create$9);

	var _Object$create$1 = /*@__PURE__*/getDefaultExportFromCjs(create$9.exports);

	var stringify$2 = {exports: {}};

	var $$l = _export;
	var global$j = global$V;
	var getBuiltIn$5 = getBuiltIn$c;
	var apply$4 = functionApply;
	var uncurryThis$4 = functionUncurryThis;
	var fails$a = fails$v;
	var Array$1 = global$j.Array;
	var $stringify = getBuiltIn$5('JSON', 'stringify');
	var exec = uncurryThis$4(/./.exec);
	var charAt$1 = uncurryThis$4(''.charAt);
	var charCodeAt = uncurryThis$4(''.charCodeAt);
	var replace$1 = uncurryThis$4(''.replace);
	var numberToString = uncurryThis$4(1.0.toString);
	var tester = /[\uD800-\uDFFF]/g;
	var low = /^[\uD800-\uDBFF]$/;
	var hi = /^[\uDC00-\uDFFF]$/;

	var fix = function (match, offset, string) {
	  var prev = charAt$1(string, offset - 1);
	  var next = charAt$1(string, offset + 1);

	  if (exec(low, match) && !exec(hi, next) || exec(hi, match) && !exec(low, prev)) {
	    return '\\u' + numberToString(charCodeAt(match, 0), 16);
	  }

	  return match;
	};

	var FORCED$4 = fails$a(function () {
	  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"' || $stringify('\uDEAD') !== '"\\udead"';
	});

	if ($stringify) {
	  // `JSON.stringify` method
	  // https://tc39.es/ecma262/#sec-json.stringify
	  // https://github.com/tc39/proposal-well-formed-stringify
	  $$l({
	    target: 'JSON',
	    stat: true,
	    forced: FORCED$4
	  }, {
	    // eslint-disable-next-line no-unused-vars -- required for `.length`
	    stringify: function stringify(it, replacer, space) {
	      for (var i = 0, l = arguments.length, args = Array$1(l); i < l; i++) args[i] = arguments[i];

	      var result = apply$4($stringify, null, args);
	      return typeof result == 'string' ? replace$1(result, tester, fix) : result;
	    }
	  });
	}

	var path$8 = path$t;
	var apply$3 = functionApply; // eslint-disable-next-line es/no-json -- safe

	if (!path$8.JSON) path$8.JSON = {
	  stringify: JSON.stringify
	}; // eslint-disable-next-line no-unused-vars -- required for `.length`

	var stringify$1 = function stringify(it, replacer, space) {
	  return apply$3(path$8.JSON.stringify, null, arguments);
	};

	var parent$z = stringify$1;
	var stringify = parent$z;

	(function (module) {
	  module.exports = stringify;
	})(stringify$2);

	var _JSON$stringify = /*@__PURE__*/getDefaultExportFromCjs(stringify$2.exports);

	var setTimeout$2 = {exports: {}};

	var global$i = global$V;
	var TypeError$7 = global$i.TypeError;

	var validateArgumentsLength$2 = function (passed, required) {
	  if (passed < required) throw TypeError$7('Not enough arguments');
	  return passed;
	};

	var $$k = _export;
	var global$h = global$V;
	var apply$2 = functionApply;
	var isCallable$4 = isCallable$k;
	var userAgent$5 = engineUserAgent;
	var arraySlice$2 = arraySlice$5;
	var validateArgumentsLength$1 = validateArgumentsLength$2;
	var MSIE = /MSIE .\./.test(userAgent$5); // <- dirty ie9- check

	var Function$2 = global$h.Function;

	var wrap = function (scheduler) {
	  return function (handler, timeout
	  /* , ...arguments */
	  ) {
	    var boundArgs = validateArgumentsLength$1(arguments.length, 1) > 2;
	    var fn = isCallable$4(handler) ? handler : Function$2(handler);
	    var args = boundArgs ? arraySlice$2(arguments, 2) : undefined;
	    return scheduler(boundArgs ? function () {
	      apply$2(fn, this, args);
	    } : fn, timeout);
	  };
	}; // ie9- setTimeout & setInterval additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers


	$$k({
	  global: true,
	  bind: true,
	  forced: MSIE
	}, {
	  // `setTimeout` method
	  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
	  setTimeout: wrap(global$h.setTimeout),
	  // `setInterval` method
	  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
	  setInterval: wrap(global$h.setInterval)
	});

	var path$7 = path$t;
	var setTimeout$1 = path$7.setTimeout;

	(function (module) {
	  module.exports = setTimeout$1;
	})(setTimeout$2);

	var _setTimeout = /*@__PURE__*/getDefaultExportFromCjs(setTimeout$2.exports);

	var fill$4 = {exports: {}};

	var toObject$3 = toObject$e;
	var toAbsoluteIndex = toAbsoluteIndex$5;
	var lengthOfArrayLike$5 = lengthOfArrayLike$d; // `Array.prototype.fill` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.fill

	var arrayFill = function fill(value
	/* , start = 0, end = @length */
	) {
	  var O = toObject$3(this);
	  var length = lengthOfArrayLike$5(O);
	  var argumentsLength = arguments.length;
	  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
	  var end = argumentsLength > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);

	  while (endPos > index) O[index++] = value;

	  return O;
	};

	var $$j = _export;
	var fill$3 = arrayFill;
	// https://tc39.es/ecma262/#sec-array.prototype.fill

	$$j({
	  target: 'Array',
	  proto: true
	}, {
	  fill: fill$3
	}); // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

	var entryVirtual$b = entryVirtual$o;
	var fill$2 = entryVirtual$b('Array').fill;

	var isPrototypeOf$e = objectIsPrototypeOf;
	var method$b = fill$2;
	var ArrayPrototype$a = Array.prototype;

	var fill$1 = function (it) {
	  var own = it.fill;
	  return it === ArrayPrototype$a || isPrototypeOf$e(ArrayPrototype$a, it) && own === ArrayPrototype$a.fill ? method$b : own;
	};

	var parent$y = fill$1;
	var fill = parent$y;

	(function (module) {
	  module.exports = fill;
	})(fill$4);

	var _fillInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(fill$4.exports);

	var componentEmitter = {exports: {}};

	(function (module) {
	  /**
	   * Expose `Emitter`.
	   */
	  {
	    module.exports = Emitter;
	  }
	  /**
	   * Initialize a new `Emitter`.
	   *
	   * @api public
	   */


	  function Emitter(obj) {
	    if (obj) return mixin(obj);
	  }
	  /**
	   * Mixin the emitter properties.
	   *
	   * @param {Object} obj
	   * @return {Object}
	   * @api private
	   */

	  function mixin(obj) {
	    for (var key in Emitter.prototype) {
	      obj[key] = Emitter.prototype[key];
	    }

	    return obj;
	  }
	  /**
	   * Listen on the given `event` with `fn`.
	   *
	   * @param {String} event
	   * @param {Function} fn
	   * @return {Emitter}
	   * @api public
	   */


	  Emitter.prototype.on = Emitter.prototype.addEventListener = function (event, fn) {
	    this._callbacks = this._callbacks || {};
	    (this._callbacks['$' + event] = this._callbacks['$' + event] || []).push(fn);
	    return this;
	  };
	  /**
	   * Adds an `event` listener that will be invoked a single
	   * time then automatically removed.
	   *
	   * @param {String} event
	   * @param {Function} fn
	   * @return {Emitter}
	   * @api public
	   */


	  Emitter.prototype.once = function (event, fn) {
	    function on() {
	      this.off(event, on);
	      fn.apply(this, arguments);
	    }

	    on.fn = fn;
	    this.on(event, on);
	    return this;
	  };
	  /**
	   * Remove the given callback for `event` or all
	   * registered callbacks.
	   *
	   * @param {String} event
	   * @param {Function} fn
	   * @return {Emitter}
	   * @api public
	   */


	  Emitter.prototype.off = Emitter.prototype.removeListener = Emitter.prototype.removeAllListeners = Emitter.prototype.removeEventListener = function (event, fn) {
	    this._callbacks = this._callbacks || {}; // all

	    if (0 == arguments.length) {
	      this._callbacks = {};
	      return this;
	    } // specific event


	    var callbacks = this._callbacks['$' + event];
	    if (!callbacks) return this; // remove all handlers

	    if (1 == arguments.length) {
	      delete this._callbacks['$' + event];
	      return this;
	    } // remove specific handler


	    var cb;

	    for (var i = 0; i < callbacks.length; i++) {
	      cb = callbacks[i];

	      if (cb === fn || cb.fn === fn) {
	        callbacks.splice(i, 1);
	        break;
	      }
	    } // Remove event specific arrays for event types that no
	    // one is subscribed for to avoid memory leak.


	    if (callbacks.length === 0) {
	      delete this._callbacks['$' + event];
	    }

	    return this;
	  };
	  /**
	   * Emit `event` with the given args.
	   *
	   * @param {String} event
	   * @param {Mixed} ...
	   * @return {Emitter}
	   */


	  Emitter.prototype.emit = function (event) {
	    this._callbacks = this._callbacks || {};
	    var args = new Array(arguments.length - 1),
	        callbacks = this._callbacks['$' + event];

	    for (var i = 1; i < arguments.length; i++) {
	      args[i - 1] = arguments[i];
	    }

	    if (callbacks) {
	      callbacks = callbacks.slice(0);

	      for (var i = 0, len = callbacks.length; i < len; ++i) {
	        callbacks[i].apply(this, args);
	      }
	    }

	    return this;
	  };
	  /**
	   * Return array of callbacks for `event`.
	   *
	   * @param {String} event
	   * @return {Array}
	   * @api public
	   */


	  Emitter.prototype.listeners = function (event) {
	    this._callbacks = this._callbacks || {};
	    return this._callbacks['$' + event] || [];
	  };
	  /**
	   * Check if this emitter has `event` handlers.
	   *
	   * @param {String} event
	   * @return {Boolean}
	   * @api public
	   */


	  Emitter.prototype.hasListeners = function (event) {
	    return !!this.listeners(event).length;
	  };
	})(componentEmitter);

	var Emitter = componentEmitter.exports;

	/*! Hammer.JS - v2.0.17-rc - 2019-12-16
	 * http://naver.github.io/egjs
	 *
	 * Forked By Naver egjs
	 * Copyright (c) hammerjs
	 * Licensed under the MIT license */
	function _extends() {
	  _extends = Object.assign || function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };

	  return _extends.apply(this, arguments);
	}

	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  subClass.__proto__ = superClass;
	}

	function _assertThisInitialized$1(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}
	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} target
	 * @param {...Object} objects_to_assign
	 * @returns {Object} target
	 */


	var assign;

	if (typeof Object.assign !== 'function') {
	  assign = function assign(target) {
	    if (target === undefined || target === null) {
	      throw new TypeError('Cannot convert undefined or null to object');
	    }

	    var output = Object(target);

	    for (var index = 1; index < arguments.length; index++) {
	      var source = arguments[index];

	      if (source !== undefined && source !== null) {
	        for (var nextKey in source) {
	          if (source.hasOwnProperty(nextKey)) {
	            output[nextKey] = source[nextKey];
	          }
	        }
	      }
	    }

	    return output;
	  };
	} else {
	  assign = Object.assign;
	}

	var assign$1 = assign;
	var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
	var TEST_ELEMENT = typeof document === "undefined" ? {
	  style: {}
	} : document.createElement('div');
	var TYPE_FUNCTION = 'function';
	var round = Math.round,
	    abs = Math.abs;
	var now = Date.now;
	/**
	 * @private
	 * get the prefixed property
	 * @param {Object} obj
	 * @param {String} property
	 * @returns {String|Undefined} prefixed
	 */

	function prefixed(obj, property) {
	  var prefix;
	  var prop;
	  var camelProp = property[0].toUpperCase() + property.slice(1);
	  var i = 0;

	  while (i < VENDOR_PREFIXES.length) {
	    prefix = VENDOR_PREFIXES[i];
	    prop = prefix ? prefix + camelProp : property;

	    if (prop in obj) {
	      return prop;
	    }

	    i++;
	  }

	  return undefined;
	}
	/* eslint-disable no-new-func, no-nested-ternary */


	var win;

	if (typeof window === "undefined") {
	  // window is undefined in node.js
	  win = {};
	} else {
	  win = window;
	}

	var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
	var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;

	function getTouchActionProps() {
	  if (!NATIVE_TOUCH_ACTION) {
	    return false;
	  }

	  var touchMap = {};
	  var cssSupports = win.CSS && win.CSS.supports;
	  ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
	    // If css.supports is not supported but there is native touch-action assume it supports
	    // all values. This is the case for IE 10 and 11.
	    return touchMap[val] = cssSupports ? win.CSS.supports('touch-action', val) : true;
	  });
	  return touchMap;
	}

	var TOUCH_ACTION_COMPUTE = 'compute';
	var TOUCH_ACTION_AUTO = 'auto';
	var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

	var TOUCH_ACTION_NONE = 'none';
	var TOUCH_ACTION_PAN_X = 'pan-x';
	var TOUCH_ACTION_PAN_Y = 'pan-y';
	var TOUCH_ACTION_MAP = getTouchActionProps();
	var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
	var SUPPORT_TOUCH = ('ontouchstart' in win);
	var SUPPORT_POINTER_EVENTS = prefixed(win, 'PointerEvent') !== undefined;
	var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
	var INPUT_TYPE_TOUCH = 'touch';
	var INPUT_TYPE_PEN = 'pen';
	var INPUT_TYPE_MOUSE = 'mouse';
	var INPUT_TYPE_KINECT = 'kinect';
	var COMPUTE_INTERVAL = 25;
	var INPUT_START = 1;
	var INPUT_MOVE = 2;
	var INPUT_END = 4;
	var INPUT_CANCEL = 8;
	var DIRECTION_NONE = 1;
	var DIRECTION_LEFT = 2;
	var DIRECTION_RIGHT = 4;
	var DIRECTION_UP = 8;
	var DIRECTION_DOWN = 16;
	var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
	var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
	var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
	var PROPS_XY = ['x', 'y'];
	var PROPS_CLIENT_XY = ['clientX', 'clientY'];
	/**
	 * @private
	 * walk objects and arrays
	 * @param {Object} obj
	 * @param {Function} iterator
	 * @param {Object} context
	 */

	function each(obj, iterator, context) {
	  var i;

	  if (!obj) {
	    return;
	  }

	  if (obj.forEach) {
	    obj.forEach(iterator, context);
	  } else if (obj.length !== undefined) {
	    i = 0;

	    while (i < obj.length) {
	      iterator.call(context, obj[i], i, obj);
	      i++;
	    }
	  } else {
	    for (i in obj) {
	      obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
	    }
	  }
	}
	/**
	 * @private
	 * let a boolean value also be a function that must return a boolean
	 * this first item in args will be used as the context
	 * @param {Boolean|Function} val
	 * @param {Array} [args]
	 * @returns {Boolean}
	 */


	function boolOrFn(val, args) {
	  if (typeof val === TYPE_FUNCTION) {
	    return val.apply(args ? args[0] || undefined : undefined, args);
	  }

	  return val;
	}
	/**
	 * @private
	 * small indexOf wrapper
	 * @param {String} str
	 * @param {String} find
	 * @returns {Boolean} found
	 */


	function inStr(str, find) {
	  return str.indexOf(find) > -1;
	}
	/**
	 * @private
	 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
	 * @param {String} actions
	 * @returns {*}
	 */


	function cleanTouchActions(actions) {
	  // none
	  if (inStr(actions, TOUCH_ACTION_NONE)) {
	    return TOUCH_ACTION_NONE;
	  }

	  var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
	  var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
	  // for different directions, e.g. horizontal pan but vertical swipe?)
	  // we need none (as otherwise with pan-x pan-y combined none of these
	  // recognizers will work, since the browser would handle all panning

	  if (hasPanX && hasPanY) {
	    return TOUCH_ACTION_NONE;
	  } // pan-x OR pan-y


	  if (hasPanX || hasPanY) {
	    return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
	  } // manipulation


	  if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
	    return TOUCH_ACTION_MANIPULATION;
	  }

	  return TOUCH_ACTION_AUTO;
	}
	/**
	 * @private
	 * Touch Action
	 * sets the touchAction property or uses the js alternative
	 * @param {Manager} manager
	 * @param {String} value
	 * @constructor
	 */


	var TouchAction = /*#__PURE__*/function () {
	  function TouchAction(manager, value) {
	    this.manager = manager;
	    this.set(value);
	  }
	  /**
	   * @private
	   * set the touchAction value on the element or enable the polyfill
	   * @param {String} value
	   */


	  var _proto = TouchAction.prototype;

	  _proto.set = function set(value) {
	    // find out the touch-action by the event handlers
	    if (value === TOUCH_ACTION_COMPUTE) {
	      value = this.compute();
	    }

	    if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
	      this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
	    }

	    this.actions = value.toLowerCase().trim();
	  };
	  /**
	   * @private
	   * just re-set the touchAction value
	   */


	  _proto.update = function update() {
	    this.set(this.manager.options.touchAction);
	  };
	  /**
	   * @private
	   * compute the value for the touchAction property based on the recognizer's settings
	   * @returns {String} value
	   */


	  _proto.compute = function compute() {
	    var actions = [];
	    each(this.manager.recognizers, function (recognizer) {
	      if (boolOrFn(recognizer.options.enable, [recognizer])) {
	        actions = actions.concat(recognizer.getTouchAction());
	      }
	    });
	    return cleanTouchActions(actions.join(' '));
	  };
	  /**
	   * @private
	   * this method is called on each input cycle and provides the preventing of the browser behavior
	   * @param {Object} input
	   */


	  _proto.preventDefaults = function preventDefaults(input) {
	    var srcEvent = input.srcEvent;
	    var direction = input.offsetDirection; // if the touch action did prevented once this session

	    if (this.manager.session.prevented) {
	      srcEvent.preventDefault();
	      return;
	    }

	    var actions = this.actions;
	    var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
	    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
	    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

	    if (hasNone) {
	      // do not prevent defaults if this is a tap gesture
	      var isTapPointer = input.pointers.length === 1;
	      var isTapMovement = input.distance < 2;
	      var isTapTouchTime = input.deltaTime < 250;

	      if (isTapPointer && isTapMovement && isTapTouchTime) {
	        return;
	      }
	    }

	    if (hasPanX && hasPanY) {
	      // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
	      return;
	    }

	    if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
	      return this.preventSrc(srcEvent);
	    }
	  };
	  /**
	   * @private
	   * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
	   * @param {Object} srcEvent
	   */


	  _proto.preventSrc = function preventSrc(srcEvent) {
	    this.manager.session.prevented = true;
	    srcEvent.preventDefault();
	  };

	  return TouchAction;
	}();
	/**
	 * @private
	 * find if a node is in the given parent
	 * @method hasParent
	 * @param {HTMLElement} node
	 * @param {HTMLElement} parent
	 * @return {Boolean} found
	 */


	function hasParent$1(node, parent) {
	  while (node) {
	    if (node === parent) {
	      return true;
	    }

	    node = node.parentNode;
	  }

	  return false;
	}
	/**
	 * @private
	 * get the center of all the pointers
	 * @param {Array} pointers
	 * @return {Object} center contains `x` and `y` properties
	 */


	function getCenter(pointers) {
	  var pointersLength = pointers.length; // no need to loop when only one touch

	  if (pointersLength === 1) {
	    return {
	      x: round(pointers[0].clientX),
	      y: round(pointers[0].clientY)
	    };
	  }

	  var x = 0;
	  var y = 0;
	  var i = 0;

	  while (i < pointersLength) {
	    x += pointers[i].clientX;
	    y += pointers[i].clientY;
	    i++;
	  }

	  return {
	    x: round(x / pointersLength),
	    y: round(y / pointersLength)
	  };
	}
	/**
	 * @private
	 * create a simple clone from the input used for storage of firstInput and firstMultiple
	 * @param {Object} input
	 * @returns {Object} clonedInputData
	 */


	function simpleCloneInputData(input) {
	  // make a simple copy of the pointers because we will get a reference if we don't
	  // we only need clientXY for the calculations
	  var pointers = [];
	  var i = 0;

	  while (i < input.pointers.length) {
	    pointers[i] = {
	      clientX: round(input.pointers[i].clientX),
	      clientY: round(input.pointers[i].clientY)
	    };
	    i++;
	  }

	  return {
	    timeStamp: now(),
	    pointers: pointers,
	    center: getCenter(pointers),
	    deltaX: input.deltaX,
	    deltaY: input.deltaY
	  };
	}
	/**
	 * @private
	 * calculate the absolute distance between two points
	 * @param {Object} p1 {x, y}
	 * @param {Object} p2 {x, y}
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} distance
	 */


	function getDistance(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.sqrt(x * x + y * y);
	}
	/**
	 * @private
	 * calculate the angle between two coordinates
	 * @param {Object} p1
	 * @param {Object} p2
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} angle
	 */


	function getAngle(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.atan2(y, x) * 180 / Math.PI;
	}
	/**
	 * @private
	 * get the direction between two points
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Number} direction
	 */


	function getDirection(x, y) {
	  if (x === y) {
	    return DIRECTION_NONE;
	  }

	  if (abs(x) >= abs(y)) {
	    return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	  }

	  return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	}

	function computeDeltaXY(session, input) {
	  var center = input.center; // let { offsetDelta:offset = {}, prevDelta = {}, prevInput = {} } = session;
	  // jscs throwing error on defalut destructured values and without defaults tests fail

	  var offset = session.offsetDelta || {};
	  var prevDelta = session.prevDelta || {};
	  var prevInput = session.prevInput || {};

	  if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
	    prevDelta = session.prevDelta = {
	      x: prevInput.deltaX || 0,
	      y: prevInput.deltaY || 0
	    };
	    offset = session.offsetDelta = {
	      x: center.x,
	      y: center.y
	    };
	  }

	  input.deltaX = prevDelta.x + (center.x - offset.x);
	  input.deltaY = prevDelta.y + (center.y - offset.y);
	}
	/**
	 * @private
	 * calculate the velocity between two points. unit is in px per ms.
	 * @param {Number} deltaTime
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Object} velocity `x` and `y`
	 */


	function getVelocity(deltaTime, x, y) {
	  return {
	    x: x / deltaTime || 0,
	    y: y / deltaTime || 0
	  };
	}
	/**
	 * @private
	 * calculate the scale factor between two pointersets
	 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} scale
	 */


	function getScale(start, end) {
	  return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
	}
	/**
	 * @private
	 * calculate the rotation degrees between two pointersets
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} rotation
	 */


	function getRotation(start, end) {
	  return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
	}
	/**
	 * @private
	 * velocity is calculated every x ms
	 * @param {Object} session
	 * @param {Object} input
	 */


	function computeIntervalInputData(session, input) {
	  var last = session.lastInterval || input;
	  var deltaTime = input.timeStamp - last.timeStamp;
	  var velocity;
	  var velocityX;
	  var velocityY;
	  var direction;

	  if (input.eventType !== INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
	    var deltaX = input.deltaX - last.deltaX;
	    var deltaY = input.deltaY - last.deltaY;
	    var v = getVelocity(deltaTime, deltaX, deltaY);
	    velocityX = v.x;
	    velocityY = v.y;
	    velocity = abs(v.x) > abs(v.y) ? v.x : v.y;
	    direction = getDirection(deltaX, deltaY);
	    session.lastInterval = input;
	  } else {
	    // use latest velocity info if it doesn't overtake a minimum period
	    velocity = last.velocity;
	    velocityX = last.velocityX;
	    velocityY = last.velocityY;
	    direction = last.direction;
	  }

	  input.velocity = velocity;
	  input.velocityX = velocityX;
	  input.velocityY = velocityY;
	  input.direction = direction;
	}
	/**
	* @private
	 * extend the data with some usable properties like scale, rotate, velocity etc
	 * @param {Object} manager
	 * @param {Object} input
	 */


	function computeInputData(manager, input) {
	  var session = manager.session;
	  var pointers = input.pointers;
	  var pointersLength = pointers.length; // store the first input to calculate the distance and direction

	  if (!session.firstInput) {
	    session.firstInput = simpleCloneInputData(input);
	  } // to compute scale and rotation we need to store the multiple touches


	  if (pointersLength > 1 && !session.firstMultiple) {
	    session.firstMultiple = simpleCloneInputData(input);
	  } else if (pointersLength === 1) {
	    session.firstMultiple = false;
	  }

	  var firstInput = session.firstInput,
	      firstMultiple = session.firstMultiple;
	  var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
	  var center = input.center = getCenter(pointers);
	  input.timeStamp = now();
	  input.deltaTime = input.timeStamp - firstInput.timeStamp;
	  input.angle = getAngle(offsetCenter, center);
	  input.distance = getDistance(offsetCenter, center);
	  computeDeltaXY(session, input);
	  input.offsetDirection = getDirection(input.deltaX, input.deltaY);
	  var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
	  input.overallVelocityX = overallVelocity.x;
	  input.overallVelocityY = overallVelocity.y;
	  input.overallVelocity = abs(overallVelocity.x) > abs(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
	  input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
	  input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
	  input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
	  computeIntervalInputData(session, input); // find the correct target

	  var target = manager.element;
	  var srcEvent = input.srcEvent;
	  var srcEventTarget;

	  if (srcEvent.composedPath) {
	    srcEventTarget = srcEvent.composedPath()[0];
	  } else if (srcEvent.path) {
	    srcEventTarget = srcEvent.path[0];
	  } else {
	    srcEventTarget = srcEvent.target;
	  }

	  if (hasParent$1(srcEventTarget, target)) {
	    target = srcEventTarget;
	  }

	  input.target = target;
	}
	/**
	 * @private
	 * handle input events
	 * @param {Manager} manager
	 * @param {String} eventType
	 * @param {Object} input
	 */


	function inputHandler(manager, eventType, input) {
	  var pointersLen = input.pointers.length;
	  var changedPointersLen = input.changedPointers.length;
	  var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
	  var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
	  input.isFirst = !!isFirst;
	  input.isFinal = !!isFinal;

	  if (isFirst) {
	    manager.session = {};
	  } // source event is the normalized value of the domEvents
	  // like 'touchstart, mouseup, pointerdown'


	  input.eventType = eventType; // compute scale, rotation etc

	  computeInputData(manager, input); // emit secret event

	  manager.emit('hammer.input', input);
	  manager.recognize(input);
	  manager.session.prevInput = input;
	}
	/**
	 * @private
	 * split string on whitespace
	 * @param {String} str
	 * @returns {Array} words
	 */


	function splitStr(str) {
	  return str.trim().split(/\s+/g);
	}
	/**
	 * @private
	 * addEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */


	function addEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.addEventListener(type, handler, false);
	  });
	}
	/**
	 * @private
	 * removeEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */


	function removeEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.removeEventListener(type, handler, false);
	  });
	}
	/**
	 * @private
	 * get the window object of an element
	 * @param {HTMLElement} element
	 * @returns {DocumentView|Window}
	 */


	function getWindowForElement(element) {
	  var doc = element.ownerDocument || element;
	  return doc.defaultView || doc.parentWindow || window;
	}
	/**
	 * @private
	 * create new input type manager
	 * @param {Manager} manager
	 * @param {Function} callback
	 * @returns {Input}
	 * @constructor
	 */


	var Input = /*#__PURE__*/function () {
	  function Input(manager, callback) {
	    var self = this;
	    this.manager = manager;
	    this.callback = callback;
	    this.element = manager.element;
	    this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
	    // so when disabled the input events are completely bypassed.

	    this.domHandler = function (ev) {
	      if (boolOrFn(manager.options.enable, [manager])) {
	        self.handler(ev);
	      }
	    };

	    this.init();
	  }
	  /**
	   * @private
	   * should handle the inputEvent data and trigger the callback
	   * @virtual
	   */


	  var _proto = Input.prototype;

	  _proto.handler = function handler() {};
	  /**
	   * @private
	   * bind the events
	   */


	  _proto.init = function init() {
	    this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };
	  /**
	   * @private
	   * unbind the events
	   */


	  _proto.destroy = function destroy() {
	    this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };

	  return Input;
	}();
	/**
	 * @private
	 * find if a array contains the object using indexOf or a simple polyFill
	 * @param {Array} src
	 * @param {String} find
	 * @param {String} [findByKey]
	 * @return {Boolean|Number} false when not found, or the index
	 */


	function inArray(src, find, findByKey) {
	  if (src.indexOf && !findByKey) {
	    return src.indexOf(find);
	  } else {
	    var i = 0;

	    while (i < src.length) {
	      if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
	        // do not use === here, test fails
	        return i;
	      }

	      i++;
	    }

	    return -1;
	  }
	}

	var POINTER_INPUT_MAP = {
	  pointerdown: INPUT_START,
	  pointermove: INPUT_MOVE,
	  pointerup: INPUT_END,
	  pointercancel: INPUT_CANCEL,
	  pointerout: INPUT_CANCEL
	}; // in IE10 the pointer types is defined as an enum

	var IE10_POINTER_TYPE_ENUM = {
	  2: INPUT_TYPE_TOUCH,
	  3: INPUT_TYPE_PEN,
	  4: INPUT_TYPE_MOUSE,
	  5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

	};
	var POINTER_ELEMENT_EVENTS = 'pointerdown';
	var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel'; // IE10 has prefixed support, and case-sensitive

	if (win.MSPointerEvent && !win.PointerEvent) {
	  POINTER_ELEMENT_EVENTS = 'MSPointerDown';
	  POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
	}
	/**
	 * @private
	 * Pointer events input
	 * @constructor
	 * @extends Input
	 */


	var PointerEventInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(PointerEventInput, _Input);

	  function PointerEventInput() {
	    var _this;

	    var proto = PointerEventInput.prototype;
	    proto.evEl = POINTER_ELEMENT_EVENTS;
	    proto.evWin = POINTER_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.store = _this.manager.session.pointerEvents = [];
	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = PointerEventInput.prototype;

	  _proto.handler = function handler(ev) {
	    var store = this.store;
	    var removePointer = false;
	    var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
	    var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
	    var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
	    var isTouch = pointerType === INPUT_TYPE_TOUCH; // get index of the event in the store

	    var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

	    if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
	      if (storeIndex < 0) {
	        store.push(ev);
	        storeIndex = store.length - 1;
	      }
	    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	      removePointer = true;
	    } // it not found, so the pointer hasn't been down (so it's probably a hover)


	    if (storeIndex < 0) {
	      return;
	    } // update the event in the store


	    store[storeIndex] = ev;
	    this.callback(this.manager, eventType, {
	      pointers: store,
	      changedPointers: [ev],
	      pointerType: pointerType,
	      srcEvent: ev
	    });

	    if (removePointer) {
	      // remove from the store
	      store.splice(storeIndex, 1);
	    }
	  };

	  return PointerEventInput;
	}(Input);
	/**
	 * @private
	 * convert array-like objects to real arrays
	 * @param {Object} obj
	 * @returns {Array}
	 */


	function toArray$1(obj) {
	  return Array.prototype.slice.call(obj, 0);
	}
	/**
	 * @private
	 * unique array with objects based on a key (like 'id') or just by the array's value
	 * @param {Array} src [{id:1},{id:2},{id:1}]
	 * @param {String} [key]
	 * @param {Boolean} [sort=False]
	 * @returns {Array} [{id:1},{id:2}]
	 */


	function uniqueArray(src, key, sort) {
	  var results = [];
	  var values = [];
	  var i = 0;

	  while (i < src.length) {
	    var val = key ? src[i][key] : src[i];

	    if (inArray(values, val) < 0) {
	      results.push(src[i]);
	    }

	    values[i] = val;
	    i++;
	  }

	  if (sort) {
	    if (!key) {
	      results = results.sort();
	    } else {
	      results = results.sort(function (a, b) {
	        return a[key] > b[key];
	      });
	    }
	  }

	  return results;
	}

	var TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Multi-user touch events input
	 * @constructor
	 * @extends Input
	 */

	var TouchInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(TouchInput, _Input);

	  function TouchInput() {
	    var _this;

	    TouchInput.prototype.evTarget = TOUCH_TARGET_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.targetIds = {}; // this.evTarget = TOUCH_TARGET_EVENTS;

	    return _this;
	  }

	  var _proto = TouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = TOUCH_INPUT_MAP[ev.type];
	    var touches = getTouches.call(this, ev, type);

	    if (!touches) {
	      return;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return TouchInput;
	}(Input);

	function getTouches(ev, type) {
	  var allTouches = toArray$1(ev.touches);
	  var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

	  if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
	    targetIds[allTouches[0].identifier] = true;
	    return [allTouches, allTouches];
	  }

	  var i;
	  var targetTouches;
	  var changedTouches = toArray$1(ev.changedTouches);
	  var changedTargetTouches = [];
	  var target = this.target; // get target touches from touches

	  targetTouches = allTouches.filter(function (touch) {
	    return hasParent$1(touch.target, target);
	  }); // collect touches

	  if (type === INPUT_START) {
	    i = 0;

	    while (i < targetTouches.length) {
	      targetIds[targetTouches[i].identifier] = true;
	      i++;
	    }
	  } // filter changed touches to only contain touches that exist in the collected target ids


	  i = 0;

	  while (i < changedTouches.length) {
	    if (targetIds[changedTouches[i].identifier]) {
	      changedTargetTouches.push(changedTouches[i]);
	    } // cleanup removed touches


	    if (type & (INPUT_END | INPUT_CANCEL)) {
	      delete targetIds[changedTouches[i].identifier];
	    }

	    i++;
	  }

	  if (!changedTargetTouches.length) {
	    return;
	  }

	  return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
	  uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
	}

	var MOUSE_INPUT_MAP = {
	  mousedown: INPUT_START,
	  mousemove: INPUT_MOVE,
	  mouseup: INPUT_END
	};
	var MOUSE_ELEMENT_EVENTS = 'mousedown';
	var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
	/**
	 * @private
	 * Mouse events input
	 * @constructor
	 * @extends Input
	 */

	var MouseInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(MouseInput, _Input);

	  function MouseInput() {
	    var _this;

	    var proto = MouseInput.prototype;
	    proto.evEl = MOUSE_ELEMENT_EVENTS;
	    proto.evWin = MOUSE_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.pressed = false; // mousedown state

	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = MouseInput.prototype;

	  _proto.handler = function handler(ev) {
	    var eventType = MOUSE_INPUT_MAP[ev.type]; // on start we want to have the left mouse button down

	    if (eventType & INPUT_START && ev.button === 0) {
	      this.pressed = true;
	    }

	    if (eventType & INPUT_MOVE && ev.which !== 1) {
	      eventType = INPUT_END;
	    } // mouse must be down


	    if (!this.pressed) {
	      return;
	    }

	    if (eventType & INPUT_END) {
	      this.pressed = false;
	    }

	    this.callback(this.manager, eventType, {
	      pointers: [ev],
	      changedPointers: [ev],
	      pointerType: INPUT_TYPE_MOUSE,
	      srcEvent: ev
	    });
	  };

	  return MouseInput;
	}(Input);
	/**
	 * @private
	 * Combined touch and mouse input
	 *
	 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
	 * This because touch devices also emit mouse events while doing a touch.
	 *
	 * @constructor
	 * @extends Input
	 */


	var DEDUP_TIMEOUT = 2500;
	var DEDUP_DISTANCE = 25;

	function setLastTouch(eventData) {
	  var _eventData$changedPoi = eventData.changedPointers,
	      touch = _eventData$changedPoi[0];

	  if (touch.identifier === this.primaryTouch) {
	    var lastTouch = {
	      x: touch.clientX,
	      y: touch.clientY
	    };
	    var lts = this.lastTouches;
	    this.lastTouches.push(lastTouch);

	    var removeLastTouch = function removeLastTouch() {
	      var i = lts.indexOf(lastTouch);

	      if (i > -1) {
	        lts.splice(i, 1);
	      }
	    };

	    setTimeout(removeLastTouch, DEDUP_TIMEOUT);
	  }
	}

	function recordTouches(eventType, eventData) {
	  if (eventType & INPUT_START) {
	    this.primaryTouch = eventData.changedPointers[0].identifier;
	    setLastTouch.call(this, eventData);
	  } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	    setLastTouch.call(this, eventData);
	  }
	}

	function isSyntheticEvent(eventData) {
	  var x = eventData.srcEvent.clientX;
	  var y = eventData.srcEvent.clientY;

	  for (var i = 0; i < this.lastTouches.length; i++) {
	    var t = this.lastTouches[i];
	    var dx = Math.abs(x - t.x);
	    var dy = Math.abs(y - t.y);

	    if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
	      return true;
	    }
	  }

	  return false;
	}

	var TouchMouseInput = /*#__PURE__*/function () {
	  var TouchMouseInput = /*#__PURE__*/function (_Input) {
	    _inheritsLoose(TouchMouseInput, _Input);

	    function TouchMouseInput(_manager, callback) {
	      var _this;

	      _this = _Input.call(this, _manager, callback) || this;

	      _this.handler = function (manager, inputEvent, inputData) {
	        var isTouch = inputData.pointerType === INPUT_TYPE_TOUCH;
	        var isMouse = inputData.pointerType === INPUT_TYPE_MOUSE;

	        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
	          return;
	        } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


	        if (isTouch) {
	          recordTouches.call(_assertThisInitialized$1(_assertThisInitialized$1(_this)), inputEvent, inputData);
	        } else if (isMouse && isSyntheticEvent.call(_assertThisInitialized$1(_assertThisInitialized$1(_this)), inputData)) {
	          return;
	        }

	        _this.callback(manager, inputEvent, inputData);
	      };

	      _this.touch = new TouchInput(_this.manager, _this.handler);
	      _this.mouse = new MouseInput(_this.manager, _this.handler);
	      _this.primaryTouch = null;
	      _this.lastTouches = [];
	      return _this;
	    }
	    /**
	     * @private
	     * handle mouse and touch events
	     * @param {Hammer} manager
	     * @param {String} inputEvent
	     * @param {Object} inputData
	     */


	    var _proto = TouchMouseInput.prototype;
	    /**
	     * @private
	     * remove the event listeners
	     */

	    _proto.destroy = function destroy() {
	      this.touch.destroy();
	      this.mouse.destroy();
	    };

	    return TouchMouseInput;
	  }(Input);

	  return TouchMouseInput;
	}();
	/**
	 * @private
	 * create new input type manager
	 * called by the Manager constructor
	 * @param {Hammer} manager
	 * @returns {Input}
	 */


	function createInputInstance(manager) {
	  var Type; // let inputClass = manager.options.inputClass;

	  var inputClass = manager.options.inputClass;

	  if (inputClass) {
	    Type = inputClass;
	  } else if (SUPPORT_POINTER_EVENTS) {
	    Type = PointerEventInput;
	  } else if (SUPPORT_ONLY_TOUCH) {
	    Type = TouchInput;
	  } else if (!SUPPORT_TOUCH) {
	    Type = MouseInput;
	  } else {
	    Type = TouchMouseInput;
	  }

	  return new Type(manager, inputHandler);
	}
	/**
	 * @private
	 * if the argument is an array, we want to execute the fn on each entry
	 * if it aint an array we don't want to do a thing.
	 * this is used by all the methods that accept a single and array argument.
	 * @param {*|Array} arg
	 * @param {String} fn
	 * @param {Object} [context]
	 * @returns {Boolean}
	 */


	function invokeArrayArg(arg, fn, context) {
	  if (Array.isArray(arg)) {
	    each(arg, context[fn], context);
	    return true;
	  }

	  return false;
	}

	var STATE_POSSIBLE = 1;
	var STATE_BEGAN = 2;
	var STATE_CHANGED = 4;
	var STATE_ENDED = 8;
	var STATE_RECOGNIZED = STATE_ENDED;
	var STATE_CANCELLED = 16;
	var STATE_FAILED = 32;
	/**
	 * @private
	 * get a unique id
	 * @returns {number} uniqueId
	 */

	var _uniqueId = 1;

	function uniqueId() {
	  return _uniqueId++;
	}
	/**
	 * @private
	 * get a recognizer by name if it is bound to a manager
	 * @param {Recognizer|String} otherRecognizer
	 * @param {Recognizer} recognizer
	 * @returns {Recognizer}
	 */


	function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
	  var manager = recognizer.manager;

	  if (manager) {
	    return manager.get(otherRecognizer);
	  }

	  return otherRecognizer;
	}
	/**
	 * @private
	 * get a usable string, used as event postfix
	 * @param {constant} state
	 * @returns {String} state
	 */


	function stateStr(state) {
	  if (state & STATE_CANCELLED) {
	    return 'cancel';
	  } else if (state & STATE_ENDED) {
	    return 'end';
	  } else if (state & STATE_CHANGED) {
	    return 'move';
	  } else if (state & STATE_BEGAN) {
	    return 'start';
	  }

	  return '';
	}
	/**
	 * @private
	 * Recognizer flow explained; *
	 * All recognizers have the initial state of POSSIBLE when a input session starts.
	 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
	 * Example session for mouse-input: mousedown -> mousemove -> mouseup
	 *
	 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
	 * which determines with state it should be.
	 *
	 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
	 * POSSIBLE to give it another change on the next cycle.
	 *
	 *               Possible
	 *                  |
	 *            +-----+---------------+
	 *            |                     |
	 *      +-----+-----+               |
	 *      |           |               |
	 *   Failed      Cancelled          |
	 *                          +-------+------+
	 *                          |              |
	 *                      Recognized       Began
	 *                                         |
	 *                                      Changed
	 *                                         |
	 *                                  Ended/Recognized
	 */

	/**
	 * @private
	 * Recognizer
	 * Every recognizer needs to extend from this class.
	 * @constructor
	 * @param {Object} options
	 */


	var Recognizer = /*#__PURE__*/function () {
	  function Recognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    this.options = _extends({
	      enable: true
	    }, options);
	    this.id = uniqueId();
	    this.manager = null; // default is enable true

	    this.state = STATE_POSSIBLE;
	    this.simultaneous = {};
	    this.requireFail = [];
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @return {Recognizer}
	   */


	  var _proto = Recognizer.prototype;

	  _proto.set = function set(options) {
	    assign$1(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

	    this.manager && this.manager.touchAction.update();
	    return this;
	  };
	  /**
	   * @private
	   * recognize simultaneous with an other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.recognizeWith = function recognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
	      return this;
	    }

	    var simultaneous = this.simultaneous;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (!simultaneous[otherRecognizer.id]) {
	      simultaneous[otherRecognizer.id] = otherRecognizer;
	      otherRecognizer.recognizeWith(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the simultaneous link. it doesnt remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRecognizeWith = function dropRecognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    delete this.simultaneous[otherRecognizer.id];
	    return this;
	  };
	  /**
	   * @private
	   * recognizer can only run when an other is failing
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.requireFailure = function requireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
	      return this;
	    }

	    var requireFail = this.requireFail;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (inArray(requireFail, otherRecognizer) === -1) {
	      requireFail.push(otherRecognizer);
	      otherRecognizer.requireFailure(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the requireFailure link. it does not remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRequireFailure = function dropRequireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    var index = inArray(this.requireFail, otherRecognizer);

	    if (index > -1) {
	      this.requireFail.splice(index, 1);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * has require failures boolean
	   * @returns {boolean}
	   */


	  _proto.hasRequireFailures = function hasRequireFailures() {
	    return this.requireFail.length > 0;
	  };
	  /**
	   * @private
	   * if the recognizer can recognize simultaneous with an other recognizer
	   * @param {Recognizer} otherRecognizer
	   * @returns {Boolean}
	   */


	  _proto.canRecognizeWith = function canRecognizeWith(otherRecognizer) {
	    return !!this.simultaneous[otherRecognizer.id];
	  };
	  /**
	   * @private
	   * You should use `tryEmit` instead of `emit` directly to check
	   * that all the needed recognizers has failed before emitting.
	   * @param {Object} input
	   */


	  _proto.emit = function emit(input) {
	    var self = this;
	    var state = this.state;

	    function emit(event) {
	      self.manager.emit(event, input);
	    } // 'panstart' and 'panmove'


	    if (state < STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }

	    emit(self.options.event); // simple 'eventName' events

	    if (input.additionalEvent) {
	      // additional event(panleft, panright, pinchin, pinchout...)
	      emit(input.additionalEvent);
	    } // panend and pancancel


	    if (state >= STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }
	  };
	  /**
	   * @private
	   * Check that all the require failure recognizers has failed,
	   * if true, it emits a gesture event,
	   * otherwise, setup the state to FAILED.
	   * @param {Object} input
	   */


	  _proto.tryEmit = function tryEmit(input) {
	    if (this.canEmit()) {
	      return this.emit(input);
	    } // it's failing anyway


	    this.state = STATE_FAILED;
	  };
	  /**
	   * @private
	   * can we emit?
	   * @returns {boolean}
	   */


	  _proto.canEmit = function canEmit() {
	    var i = 0;

	    while (i < this.requireFail.length) {
	      if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
	        return false;
	      }

	      i++;
	    }

	    return true;
	  };
	  /**
	   * @private
	   * update the recognizer
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    // make a new copy of the inputData
	    // so we can change the inputData without messing up the other recognizers
	    var inputDataClone = assign$1({}, inputData); // is is enabled and allow recognizing?

	    if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
	      this.reset();
	      this.state = STATE_FAILED;
	      return;
	    } // reset when we've reached the end


	    if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
	      this.state = STATE_POSSIBLE;
	    }

	    this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
	    // so trigger an event

	    if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
	      this.tryEmit(inputDataClone);
	    }
	  };
	  /**
	   * @private
	   * return the state of the recognizer
	   * the actual recognizing happens in this method
	   * @virtual
	   * @param {Object} inputData
	   * @returns {constant} STATE
	   */

	  /* jshint ignore:start */


	  _proto.process = function process(inputData) {};
	  /* jshint ignore:end */

	  /**
	   * @private
	   * return the preferred touch-action
	   * @virtual
	   * @returns {Array}
	   */


	  _proto.getTouchAction = function getTouchAction() {};
	  /**
	   * @private
	   * called when the gesture isn't allowed to recognize
	   * like when another is being recognized or it is disabled
	   * @virtual
	   */


	  _proto.reset = function reset() {};

	  return Recognizer;
	}();
	/**
	 * @private
	 * A tap is recognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
	 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
	 * a single tap.
	 *
	 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
	 * multi-taps being recognized.
	 * @constructor
	 * @extends Recognizer
	 */


	var TapRecognizer = /*#__PURE__*/function (_Recognizer) {
	  _inheritsLoose(TapRecognizer, _Recognizer);

	  function TapRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'tap',
	      pointers: 1,
	      taps: 1,
	      interval: 300,
	      // max time between the multi-tap taps
	      time: 250,
	      // max time of the pointer to be down (like finger on the screen)
	      threshold: 9,
	      // a minimal movement is ok, but keep it low
	      posThreshold: 10
	    }, options)) || this; // previous time and center,
	    // used for tap counting

	    _this.pTime = false;
	    _this.pCenter = false;
	    _this._timer = null;
	    _this._input = null;
	    _this.count = 0;
	    return _this;
	  }

	  var _proto = TapRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_MANIPULATION];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTouchTime = input.deltaTime < options.time;
	    this.reset();

	    if (input.eventType & INPUT_START && this.count === 0) {
	      return this.failTimeout();
	    } // we only allow little movement
	    // and we've reached an end event, so a tap is possible


	    if (validMovement && validTouchTime && validPointers) {
	      if (input.eventType !== INPUT_END) {
	        return this.failTimeout();
	      }

	      var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
	      var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
	      this.pTime = input.timeStamp;
	      this.pCenter = input.center;

	      if (!validMultiTap || !validInterval) {
	        this.count = 1;
	      } else {
	        this.count += 1;
	      }

	      this._input = input; // if tap count matches we have recognized it,
	      // else it has began recognizing...

	      var tapCount = this.count % options.taps;

	      if (tapCount === 0) {
	        // no failing requirements, immediately trigger the tap event
	        // or wait as long as the multitap interval to trigger
	        if (!this.hasRequireFailures()) {
	          return STATE_RECOGNIZED;
	        } else {
	          this._timer = setTimeout(function () {
	            _this2.state = STATE_RECOGNIZED;

	            _this2.tryEmit();
	          }, options.interval);
	          return STATE_BEGAN;
	        }
	      }
	    }

	    return STATE_FAILED;
	  };

	  _proto.failTimeout = function failTimeout() {
	    var _this3 = this;

	    this._timer = setTimeout(function () {
	      _this3.state = STATE_FAILED;
	    }, this.options.interval);
	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit() {
	    if (this.state === STATE_RECOGNIZED) {
	      this._input.tapCount = this.count;
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return TapRecognizer;
	}(Recognizer);
	/**
	 * @private
	 * This recognizer is just used as a base for the simple attribute recognizers.
	 * @constructor
	 * @extends Recognizer
	 */


	var AttrRecognizer = /*#__PURE__*/function (_Recognizer) {
	  _inheritsLoose(AttrRecognizer, _Recognizer);

	  function AttrRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _Recognizer.call(this, _extends({
	      pointers: 1
	    }, options)) || this;
	  }
	  /**
	   * @private
	   * Used to check if it the recognizer receives valid input, like input.distance > 10.
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {Boolean} recognized
	   */


	  var _proto = AttrRecognizer.prototype;

	  _proto.attrTest = function attrTest(input) {
	    var optionPointers = this.options.pointers;
	    return optionPointers === 0 || input.pointers.length === optionPointers;
	  };
	  /**
	   * @private
	   * Process the input and return the state for the recognizer
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {*} State
	   */


	  _proto.process = function process(input) {
	    var state = this.state;
	    var eventType = input.eventType;
	    var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
	    var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

	    if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
	      return state | STATE_CANCELLED;
	    } else if (isRecognized || isValid) {
	      if (eventType & INPUT_END) {
	        return state | STATE_ENDED;
	      } else if (!(state & STATE_BEGAN)) {
	        return STATE_BEGAN;
	      }

	      return state | STATE_CHANGED;
	    }

	    return STATE_FAILED;
	  };

	  return AttrRecognizer;
	}(Recognizer);
	/**
	 * @private
	 * direction cons to string
	 * @param {constant} direction
	 * @returns {String}
	 */


	function directionStr(direction) {
	  if (direction === DIRECTION_DOWN) {
	    return 'down';
	  } else if (direction === DIRECTION_UP) {
	    return 'up';
	  } else if (direction === DIRECTION_LEFT) {
	    return 'left';
	  } else if (direction === DIRECTION_RIGHT) {
	    return 'right';
	  }

	  return '';
	}
	/**
	 * @private
	 * Pan
	 * Recognized when the pointer is down and moved in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var PanRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(PanRecognizer, _AttrRecognizer);

	  function PanRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _AttrRecognizer.call(this, _extends({
	      event: 'pan',
	      threshold: 10,
	      pointers: 1,
	      direction: DIRECTION_ALL
	    }, options)) || this;
	    _this.pX = null;
	    _this.pY = null;
	    return _this;
	  }

	  var _proto = PanRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    var direction = this.options.direction;
	    var actions = [];

	    if (direction & DIRECTION_HORIZONTAL) {
	      actions.push(TOUCH_ACTION_PAN_Y);
	    }

	    if (direction & DIRECTION_VERTICAL) {
	      actions.push(TOUCH_ACTION_PAN_X);
	    }

	    return actions;
	  };

	  _proto.directionTest = function directionTest(input) {
	    var options = this.options;
	    var hasMoved = true;
	    var distance = input.distance;
	    var direction = input.direction;
	    var x = input.deltaX;
	    var y = input.deltaY; // lock to axis?

	    if (!(direction & options.direction)) {
	      if (options.direction & DIRECTION_HORIZONTAL) {
	        direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	        hasMoved = x !== this.pX;
	        distance = Math.abs(input.deltaX);
	      } else {
	        direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	        hasMoved = y !== this.pY;
	        distance = Math.abs(input.deltaY);
	      }
	    }

	    input.direction = direction;
	    return hasMoved && distance > options.threshold && direction & options.direction;
	  };

	  _proto.attrTest = function attrTest(input) {
	    return AttrRecognizer.prototype.attrTest.call(this, input) && ( // replace with a super call
	    this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
	  };

	  _proto.emit = function emit(input) {
	    this.pX = input.deltaX;
	    this.pY = input.deltaY;
	    var direction = directionStr(input.direction);

	    if (direction) {
	      input.additionalEvent = this.options.event + direction;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PanRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Swipe
	 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var SwipeRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(SwipeRecognizer, _AttrRecognizer);

	  function SwipeRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'swipe',
	      threshold: 10,
	      velocity: 0.3,
	      direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
	      pointers: 1
	    }, options)) || this;
	  }

	  var _proto = SwipeRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return PanRecognizer.prototype.getTouchAction.call(this);
	  };

	  _proto.attrTest = function attrTest(input) {
	    var direction = this.options.direction;
	    var velocity;

	    if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
	      velocity = input.overallVelocity;
	    } else if (direction & DIRECTION_HORIZONTAL) {
	      velocity = input.overallVelocityX;
	    } else if (direction & DIRECTION_VERTICAL) {
	      velocity = input.overallVelocityY;
	    }

	    return _AttrRecognizer.prototype.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers === this.options.pointers && abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
	  };

	  _proto.emit = function emit(input) {
	    var direction = directionStr(input.offsetDirection);

	    if (direction) {
	      this.manager.emit(this.options.event + direction, input);
	    }

	    this.manager.emit(this.options.event, input);
	  };

	  return SwipeRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Pinch
	 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var PinchRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(PinchRecognizer, _AttrRecognizer);

	  function PinchRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'pinch',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = PinchRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  _proto.emit = function emit(input) {
	    if (input.scale !== 1) {
	      var inOut = input.scale < 1 ? 'in' : 'out';
	      input.additionalEvent = this.options.event + inOut;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PinchRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Rotate
	 * Recognized when two or more pointer are moving in a circular motion.
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var RotateRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(RotateRecognizer, _AttrRecognizer);

	  function RotateRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'rotate',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = RotateRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  return RotateRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Press
	 * Recognized when the pointer is down for x ms without any movement.
	 * @constructor
	 * @extends Recognizer
	 */


	var PressRecognizer = /*#__PURE__*/function (_Recognizer) {
	  _inheritsLoose(PressRecognizer, _Recognizer);

	  function PressRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'press',
	      pointers: 1,
	      time: 251,
	      // minimal time of the pointer to be pressed
	      threshold: 9
	    }, options)) || this;
	    _this._timer = null;
	    _this._input = null;
	    return _this;
	  }

	  var _proto = PressRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_AUTO];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTime = input.deltaTime > options.time;
	    this._input = input; // we only allow little movement
	    // and we've reached an end event, so a tap is possible

	    if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
	      this.reset();
	    } else if (input.eventType & INPUT_START) {
	      this.reset();
	      this._timer = setTimeout(function () {
	        _this2.state = STATE_RECOGNIZED;

	        _this2.tryEmit();
	      }, options.time);
	    } else if (input.eventType & INPUT_END) {
	      return STATE_RECOGNIZED;
	    }

	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit(input) {
	    if (this.state !== STATE_RECOGNIZED) {
	      return;
	    }

	    if (input && input.eventType & INPUT_END) {
	      this.manager.emit(this.options.event + "up", input);
	    } else {
	      this._input.timeStamp = now();
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return PressRecognizer;
	}(Recognizer);

	var defaults = {
	  /**
	   * @private
	   * set if DOM events are being triggered.
	   * But this is slower and unused by simple implementations, so disabled by default.
	   * @type {Boolean}
	   * @default false
	   */
	  domEvents: false,

	  /**
	   * @private
	   * The value for the touchAction property/fallback.
	   * When set to `compute` it will magically set the correct value based on the added recognizers.
	   * @type {String}
	   * @default compute
	   */
	  touchAction: TOUCH_ACTION_COMPUTE,

	  /**
	   * @private
	   * @type {Boolean}
	   * @default true
	   */
	  enable: true,

	  /**
	   * @private
	   * EXPERIMENTAL FEATURE -- can be removed/changed
	   * Change the parent input target element.
	   * If Null, then it is being set the to main element.
	   * @type {Null|EventTarget}
	   * @default null
	   */
	  inputTarget: null,

	  /**
	   * @private
	   * force an input class
	   * @type {Null|Function}
	   * @default null
	   */
	  inputClass: null,

	  /**
	   * @private
	   * Some CSS properties can be used to improve the working of Hammer.
	   * Add them to this method and they will be set when creating a new Manager.
	   * @namespace
	   */
	  cssProps: {
	    /**
	     * @private
	     * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userSelect: "none",

	    /**
	     * @private
	     * Disable the Windows Phone grippers when pressing an element.
	     * @type {String}
	     * @default 'none'
	     */
	    touchSelect: "none",

	    /**
	     * @private
	     * Disables the default callout shown when you touch and hold a touch target.
	     * On iOS, when you touch and hold a touch target such as a link, Safari displays
	     * a callout containing information about the link. This property allows you to disable that callout.
	     * @type {String}
	     * @default 'none'
	     */
	    touchCallout: "none",

	    /**
	     * @private
	     * Specifies whether zooming is enabled. Used by IE10>
	     * @type {String}
	     * @default 'none'
	     */
	    contentZooming: "none",

	    /**
	     * @private
	     * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userDrag: "none",

	    /**
	     * @private
	     * Overrides the highlight color shown when the user taps a link or a JavaScript
	     * clickable element in iOS. This property obeys the alpha value, if specified.
	     * @type {String}
	     * @default 'rgba(0,0,0,0)'
	     */
	    tapHighlightColor: "rgba(0,0,0,0)"
	  }
	};
	/**
	 * @private
	 * Default recognizer setup when calling `Hammer()`
	 * When creating a new Manager these will be skipped.
	 * This is separated with other defaults because of tree-shaking.
	 * @type {Array}
	 */

	var preset = [[RotateRecognizer, {
	  enable: false
	}], [PinchRecognizer, {
	  enable: false
	}, ['rotate']], [SwipeRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}], [PanRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}, ['swipe']], [TapRecognizer], [TapRecognizer, {
	  event: 'doubletap',
	  taps: 2
	}, ['tap']], [PressRecognizer]];
	var STOP = 1;
	var FORCED_STOP = 2;
	/**
	 * @private
	 * add/remove the css properties as defined in manager.options.cssProps
	 * @param {Manager} manager
	 * @param {Boolean} add
	 */

	function toggleCssProps(manager, add) {
	  var element = manager.element;

	  if (!element.style) {
	    return;
	  }

	  var prop;
	  each(manager.options.cssProps, function (value, name) {
	    prop = prefixed(element.style, name);

	    if (add) {
	      manager.oldCssProps[prop] = element.style[prop];
	      element.style[prop] = value;
	    } else {
	      element.style[prop] = manager.oldCssProps[prop] || "";
	    }
	  });

	  if (!add) {
	    manager.oldCssProps = {};
	  }
	}
	/**
	 * @private
	 * trigger dom event
	 * @param {String} event
	 * @param {Object} data
	 */


	function triggerDomEvent(event, data) {
	  var gestureEvent = document.createEvent("Event");
	  gestureEvent.initEvent(event, true, true);
	  gestureEvent.gesture = data;
	  data.target.dispatchEvent(gestureEvent);
	}
	/**
	* @private
	 * Manager
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */


	var Manager = /*#__PURE__*/function () {
	  function Manager(element, options) {
	    var _this = this;

	    this.options = assign$1({}, defaults, options || {});
	    this.options.inputTarget = this.options.inputTarget || element;
	    this.handlers = {};
	    this.session = {};
	    this.recognizers = [];
	    this.oldCssProps = {};
	    this.element = element;
	    this.input = createInputInstance(this);
	    this.touchAction = new TouchAction(this, this.options.touchAction);
	    toggleCssProps(this, true);
	    each(this.options.recognizers, function (item) {
	      var recognizer = _this.add(new item[0](item[1]));

	      item[2] && recognizer.recognizeWith(item[2]);
	      item[3] && recognizer.requireFailure(item[3]);
	    }, this);
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @returns {Manager}
	   */


	  var _proto = Manager.prototype;

	  _proto.set = function set(options) {
	    assign$1(this.options, options); // Options that need a little more setup

	    if (options.touchAction) {
	      this.touchAction.update();
	    }

	    if (options.inputTarget) {
	      // Clean up existing event listeners and reinitialize
	      this.input.destroy();
	      this.input.target = options.inputTarget;
	      this.input.init();
	    }

	    return this;
	  };
	  /**
	   * @private
	   * stop recognizing for this session.
	   * This session will be discarded, when a new [input]start event is fired.
	   * When forced, the recognizer cycle is stopped immediately.
	   * @param {Boolean} [force]
	   */


	  _proto.stop = function stop(force) {
	    this.session.stopped = force ? FORCED_STOP : STOP;
	  };
	  /**
	   * @private
	   * run the recognizers!
	   * called by the inputHandler function on every movement of the pointers (touches)
	   * it walks through all the recognizers and tries to detect the gesture that is being made
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    var session = this.session;

	    if (session.stopped) {
	      return;
	    } // run the touch-action polyfill


	    this.touchAction.preventDefaults(inputData);
	    var recognizer;
	    var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
	    // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
	    // if no recognizer is detecting a thing, it is set to `null`

	    var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
	    // or when we're in a new session

	    if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
	      session.curRecognizer = null;
	      curRecognizer = null;
	    }

	    var i = 0;

	    while (i < recognizers.length) {
	      recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
	      // 1.   allow if the session is NOT forced stopped (see the .stop() method)
	      // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
	      //      that is being recognized.
	      // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
	      //      this can be setup with the `recognizeWith()` method on the recognizer.

	      if (session.stopped !== FORCED_STOP && ( // 1
	      !curRecognizer || recognizer === curRecognizer || // 2
	      recognizer.canRecognizeWith(curRecognizer))) {
	        // 3
	        recognizer.recognize(inputData);
	      } else {
	        recognizer.reset();
	      } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
	      // current active recognizer. but only if we don't already have an active recognizer


	      if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
	        session.curRecognizer = recognizer;
	        curRecognizer = recognizer;
	      }

	      i++;
	    }
	  };
	  /**
	   * @private
	   * get a recognizer by its event name.
	   * @param {Recognizer|String} recognizer
	   * @returns {Recognizer|Null}
	   */


	  _proto.get = function get(recognizer) {
	    if (recognizer instanceof Recognizer) {
	      return recognizer;
	    }

	    var recognizers = this.recognizers;

	    for (var i = 0; i < recognizers.length; i++) {
	      if (recognizers[i].options.event === recognizer) {
	        return recognizers[i];
	      }
	    }

	    return null;
	  };
	  /**
	   * @private add a recognizer to the manager
	   * existing recognizers with the same event name will be removed
	   * @param {Recognizer} recognizer
	   * @returns {Recognizer|Manager}
	   */


	  _proto.add = function add(recognizer) {
	    if (invokeArrayArg(recognizer, "add", this)) {
	      return this;
	    } // remove existing


	    var existing = this.get(recognizer.options.event);

	    if (existing) {
	      this.remove(existing);
	    }

	    this.recognizers.push(recognizer);
	    recognizer.manager = this;
	    this.touchAction.update();
	    return recognizer;
	  };
	  /**
	   * @private
	   * remove a recognizer by name or instance
	   * @param {Recognizer|String} recognizer
	   * @returns {Manager}
	   */


	  _proto.remove = function remove(recognizer) {
	    if (invokeArrayArg(recognizer, "remove", this)) {
	      return this;
	    }

	    var targetRecognizer = this.get(recognizer); // let's make sure this recognizer exists

	    if (recognizer) {
	      var recognizers = this.recognizers;
	      var index = inArray(recognizers, targetRecognizer);

	      if (index !== -1) {
	        recognizers.splice(index, 1);
	        this.touchAction.update();
	      }
	    }

	    return this;
	  };
	  /**
	   * @private
	   * bind event
	   * @param {String} events
	   * @param {Function} handler
	   * @returns {EventEmitter} this
	   */


	  _proto.on = function on(events, handler) {
	    if (events === undefined || handler === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      handlers[event] = handlers[event] || [];
	      handlers[event].push(handler);
	    });
	    return this;
	  };
	  /**
	   * @private unbind event, leave emit blank to remove all handlers
	   * @param {String} events
	   * @param {Function} [handler]
	   * @returns {EventEmitter} this
	   */


	  _proto.off = function off(events, handler) {
	    if (events === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      if (!handler) {
	        delete handlers[event];
	      } else {
	        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
	      }
	    });
	    return this;
	  };
	  /**
	   * @private emit event to the listeners
	   * @param {String} event
	   * @param {Object} data
	   */


	  _proto.emit = function emit(event, data) {
	    // we also want to trigger dom events
	    if (this.options.domEvents) {
	      triggerDomEvent(event, data);
	    } // no handlers, so skip it all


	    var handlers = this.handlers[event] && this.handlers[event].slice();

	    if (!handlers || !handlers.length) {
	      return;
	    }

	    data.type = event;

	    data.preventDefault = function () {
	      data.srcEvent.preventDefault();
	    };

	    var i = 0;

	    while (i < handlers.length) {
	      handlers[i](data);
	      i++;
	    }
	  };
	  /**
	   * @private
	   * destroy the manager and unbinds all events
	   * it doesn't unbind dom events, that is the user own responsibility
	   */


	  _proto.destroy = function destroy() {
	    this.element && toggleCssProps(this, false);
	    this.handlers = {};
	    this.session = {};
	    this.input.destroy();
	    this.element = null;
	  };

	  return Manager;
	}();

	var SINGLE_TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
	var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Touch events input
	 * @constructor
	 * @extends Input
	 */

	var SingleTouchInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(SingleTouchInput, _Input);

	  function SingleTouchInput() {
	    var _this;

	    var proto = SingleTouchInput.prototype;
	    proto.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
	    proto.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.started = false;
	    return _this;
	  }

	  var _proto = SingleTouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

	    if (type === INPUT_START) {
	      this.started = true;
	    }

	    if (!this.started) {
	      return;
	    }

	    var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

	    if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
	      this.started = false;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return SingleTouchInput;
	}(Input);

	function normalizeSingleTouches(ev, type) {
	  var all = toArray$1(ev.touches);
	  var changed = toArray$1(ev.changedTouches);

	  if (type & (INPUT_END | INPUT_CANCEL)) {
	    all = uniqueArray(all.concat(changed), 'identifier', true);
	  }

	  return [all, changed];
	}
	/**
	 * @private
	 * wrap a method with a deprecation warning and stack trace
	 * @param {Function} method
	 * @param {String} name
	 * @param {String} message
	 * @returns {Function} A new function wrapping the supplied method.
	 */


	function deprecate(method, name, message) {
	  var deprecationMessage = "DEPRECATED METHOD: " + name + "\n" + message + " AT \n";
	  return function () {
	    var e = new Error('get-stack-trace');
	    var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
	    var log = window.console && (window.console.warn || window.console.log);

	    if (log) {
	      log.call(window.console, deprecationMessage, stack);
	    }

	    return method.apply(this, arguments);
	  };
	}
	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} dest
	 * @param {Object} src
	 * @param {Boolean} [merge=false]
	 * @returns {Object} dest
	 */


	var extend$1 = deprecate(function (dest, src, merge) {
	  var keys = Object.keys(src);
	  var i = 0;

	  while (i < keys.length) {
	    if (!merge || merge && dest[keys[i]] === undefined) {
	      dest[keys[i]] = src[keys[i]];
	    }

	    i++;
	  }

	  return dest;
	}, 'extend', 'Use `assign`.');
	/**
	 * @private
	 * merge the values from src in the dest.
	 * means that properties that exist in dest will not be overwritten by src
	 * @param {Object} dest
	 * @param {Object} src
	 * @returns {Object} dest
	 */

	var merge$1 = deprecate(function (dest, src) {
	  return extend$1(dest, src, true);
	}, 'merge', 'Use `assign`.');
	/**
	 * @private
	 * simple class inheritance
	 * @param {Function} child
	 * @param {Function} base
	 * @param {Object} [properties]
	 */

	function inherit(child, base, properties) {
	  var baseP = base.prototype;
	  var childP;
	  childP = child.prototype = Object.create(baseP);
	  childP.constructor = child;
	  childP._super = baseP;

	  if (properties) {
	    assign$1(childP, properties);
	  }
	}
	/**
	 * @private
	 * simple function bind
	 * @param {Function} fn
	 * @param {Object} context
	 * @returns {Function}
	 */


	function bindFn(fn, context) {
	  return function boundFn() {
	    return fn.apply(context, arguments);
	  };
	}
	/**
	 * @private
	 * Simple way to create a manager with a default set of recognizers.
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */


	var Hammer$3 = /*#__PURE__*/function () {
	  var Hammer =
	  /**
	    * @private
	    * @const {string}
	    */
	  function Hammer(element, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return new Manager(element, _extends({
	      recognizers: preset.concat()
	    }, options));
	  };

	  Hammer.VERSION = "2.0.17-rc";
	  Hammer.DIRECTION_ALL = DIRECTION_ALL;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.DIRECTION_LEFT = DIRECTION_LEFT;
	  Hammer.DIRECTION_RIGHT = DIRECTION_RIGHT;
	  Hammer.DIRECTION_UP = DIRECTION_UP;
	  Hammer.DIRECTION_HORIZONTAL = DIRECTION_HORIZONTAL;
	  Hammer.DIRECTION_VERTICAL = DIRECTION_VERTICAL;
	  Hammer.DIRECTION_NONE = DIRECTION_NONE;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.INPUT_START = INPUT_START;
	  Hammer.INPUT_MOVE = INPUT_MOVE;
	  Hammer.INPUT_END = INPUT_END;
	  Hammer.INPUT_CANCEL = INPUT_CANCEL;
	  Hammer.STATE_POSSIBLE = STATE_POSSIBLE;
	  Hammer.STATE_BEGAN = STATE_BEGAN;
	  Hammer.STATE_CHANGED = STATE_CHANGED;
	  Hammer.STATE_ENDED = STATE_ENDED;
	  Hammer.STATE_RECOGNIZED = STATE_RECOGNIZED;
	  Hammer.STATE_CANCELLED = STATE_CANCELLED;
	  Hammer.STATE_FAILED = STATE_FAILED;
	  Hammer.Manager = Manager;
	  Hammer.Input = Input;
	  Hammer.TouchAction = TouchAction;
	  Hammer.TouchInput = TouchInput;
	  Hammer.MouseInput = MouseInput;
	  Hammer.PointerEventInput = PointerEventInput;
	  Hammer.TouchMouseInput = TouchMouseInput;
	  Hammer.SingleTouchInput = SingleTouchInput;
	  Hammer.Recognizer = Recognizer;
	  Hammer.AttrRecognizer = AttrRecognizer;
	  Hammer.Tap = TapRecognizer;
	  Hammer.Pan = PanRecognizer;
	  Hammer.Swipe = SwipeRecognizer;
	  Hammer.Pinch = PinchRecognizer;
	  Hammer.Rotate = RotateRecognizer;
	  Hammer.Press = PressRecognizer;
	  Hammer.on = addEventListeners;
	  Hammer.off = removeEventListeners;
	  Hammer.each = each;
	  Hammer.merge = merge$1;
	  Hammer.extend = extend$1;
	  Hammer.bindFn = bindFn;
	  Hammer.assign = assign$1;
	  Hammer.inherit = inherit;
	  Hammer.bindFn = bindFn;
	  Hammer.prefixed = prefixed;
	  Hammer.toArray = toArray$1;
	  Hammer.inArray = inArray;
	  Hammer.uniqueArray = uniqueArray;
	  Hammer.splitStr = splitStr;
	  Hammer.boolOrFn = boolOrFn;
	  Hammer.hasParent = hasParent$1;
	  Hammer.addEventListeners = addEventListeners;
	  Hammer.removeEventListeners = removeEventListeners;
	  Hammer.defaults = assign$1({}, defaults, {
	    preset: preset
	  });
	  return Hammer;
	}(); //  style loader but by script tag, not by the loader.


	Hammer$3.defaults;

	function ownKeys$3(object, enumerableOnly) { var keys = _Object$keys(object); if (_Object$getOwnPropertySymbols) { var symbols = _Object$getOwnPropertySymbols(object); enumerableOnly && (symbols = _filterInstanceProperty(symbols).call(symbols, function (sym) { return _Object$getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$2(target) { for (var i = 1; i < arguments.length; i++) { var _context22, _context23; var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? _forEachInstanceProperty(_context22 = ownKeys$3(Object(source), !0)).call(_context22, function (key) { _defineProperty(target, key, source[key]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(target, _Object$getOwnPropertyDescriptors(source)) : _forEachInstanceProperty(_context23 = ownKeys$3(Object(source))).call(_context23, function (key) { _Object$defineProperty$1(target, key, _Object$getOwnPropertyDescriptor(source, key)); }); } return target; }

	function _createForOfIteratorHelper$7(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray(o) || (it = _unsupportedIterableToArray$7(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$7(o, minLen) { var _context21; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$7(o, minLen); var n = _sliceInstanceProperty(_context21 = Object.prototype.toString.call(o)).call(_context21, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$7(o, minLen); }

	function _arrayLikeToArray$7(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
	/**
	 * Use this symbol to delete properies in deepObjectAssign.
	 */

	var DELETE = _Symbol("DELETE");
	/**
	 * Pure version of deepObjectAssign, it doesn't modify any of it's arguments.
	 *
	 * @param base - The base object that fullfils the whole interface T.
	 * @param updates - Updates that may change or delete props.
	 * @returns A brand new instance with all the supplied objects deeply merged.
	 */


	function pureDeepObjectAssign(base) {
	  var _context;

	  for (var _len = arguments.length, updates = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	    updates[_key - 1] = arguments[_key];
	  }

	  return deepObjectAssign.apply(void 0, _concatInstanceProperty(_context = [{}, base]).call(_context, updates));
	}
	/**
	 * Deep version of object assign with additional deleting by the DELETE symbol.
	 *
	 * @param values - Objects to be deeply merged.
	 * @returns The first object from values.
	 */


	function deepObjectAssign() {
	  var merged = deepObjectAssignNonentry.apply(void 0, arguments);
	  stripDelete(merged);
	  return merged;
	}
	/**
	 * Deep version of object assign with additional deleting by the DELETE symbol.
	 *
	 * @remarks
	 * This doesn't strip the DELETE symbols so they may end up in the final object.
	 * @param values - Objects to be deeply merged.
	 * @returns The first object from values.
	 */


	function deepObjectAssignNonentry() {
	  for (var _len2 = arguments.length, values = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	    values[_key2] = arguments[_key2];
	  }

	  if (values.length < 2) {
	    return values[0];
	  } else if (values.length > 2) {
	    var _context2;

	    return deepObjectAssignNonentry.apply(void 0, _concatInstanceProperty(_context2 = [deepObjectAssign(values[0], values[1])]).call(_context2, _toConsumableArray(_sliceInstanceProperty(values).call(values, 2))));
	  }

	  var a = values[0];
	  var b = values[1];

	  var _iterator = _createForOfIteratorHelper$7(_Reflect$ownKeys(b)),
	      _step;

	  try {
	    for (_iterator.s(); !(_step = _iterator.n()).done;) {
	      var prop = _step.value;
	      if (!Object.prototype.propertyIsEnumerable.call(b, prop)) ;else if (b[prop] === DELETE) {
	        delete a[prop];
	      } else if (a[prop] !== null && b[prop] !== null && _typeof$1(a[prop]) === "object" && _typeof$1(b[prop]) === "object" && !_Array$isArray(a[prop]) && !_Array$isArray(b[prop])) {
	        a[prop] = deepObjectAssignNonentry(a[prop], b[prop]);
	      } else {
	        a[prop] = clone(b[prop]);
	      }
	    }
	  } catch (err) {
	    _iterator.e(err);
	  } finally {
	    _iterator.f();
	  }

	  return a;
	}
	/**
	 * Deep clone given object or array. In case of primitive simply return.
	 *
	 * @param a - Anything.
	 * @returns Deep cloned object/array or unchanged a.
	 */


	function clone(a) {
	  if (_Array$isArray(a)) {
	    return _mapInstanceProperty(a).call(a, function (value) {
	      return clone(value);
	    });
	  } else if (_typeof$1(a) === "object" && a !== null) {
	    return deepObjectAssignNonentry({}, a);
	  } else {
	    return a;
	  }
	}
	/**
	 * Strip DELETE from given object.
	 *
	 * @param a - Object which may contain DELETE but won't after this is executed.
	 */


	function stripDelete(a) {
	  for (var _i = 0, _Object$keys$1 = _Object$keys(a); _i < _Object$keys$1.length; _i++) {
	    var prop = _Object$keys$1[_i];

	    if (a[prop] === DELETE) {
	      delete a[prop];
	    } else if (_typeof$1(a[prop]) === "object" && a[prop] !== null) {
	      stripDelete(a[prop]);
	    }
	  }
	}
	/**
	 * Seedable, fast and reasonably good (not crypto but more than okay for our
	 * needs) random number generator.
	 *
	 * @remarks
	 * Adapted from {@link https://web.archive.org/web/20110429100736/http://baagoe.com:80/en/RandomMusings/javascript}.
	 * Original algorithm created by Johannes Baagøe \<baagoe\@baagoe.com\> in 2010.
	 */

	/**
	 * Create a seeded pseudo random generator based on Alea by Johannes Baagøe.
	 *
	 * @param seed - All supplied arguments will be used as a seed. In case nothing
	 * is supplied the current time will be used to seed the generator.
	 * @returns A ready to use seeded generator.
	 */


	function Alea() {
	  for (var _len3 = arguments.length, seed = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
	    seed[_key3] = arguments[_key3];
	  }

	  return AleaImplementation(seed.length ? seed : [_Date$now()]);
	}
	/**
	 * An implementation of [[Alea]] without user input validation.
	 *
	 * @param seed - The data that will be used to seed the generator.
	 * @returns A ready to use seeded generator.
	 */


	function AleaImplementation(seed) {
	  var _mashSeed = mashSeed(seed),
	      _mashSeed2 = _slicedToArray(_mashSeed, 3),
	      s0 = _mashSeed2[0],
	      s1 = _mashSeed2[1],
	      s2 = _mashSeed2[2];

	  var c = 1;

	  var random = function random() {
	    var t = 2091639 * s0 + c * 2.3283064365386963e-10; // 2^-32

	    s0 = s1;
	    s1 = s2;
	    return s2 = t - (c = t | 0);
	  };

	  random.uint32 = function () {
	    return random() * 0x100000000;
	  }; // 2^32


	  random.fract53 = function () {
	    return random() + (random() * 0x200000 | 0) * 1.1102230246251565e-16;
	  }; // 2^-53


	  random.algorithm = "Alea";
	  random.seed = seed;
	  random.version = "0.9";
	  return random;
	}
	/**
	 * Turn arbitrary data into values [[AleaImplementation]] can use to generate
	 * random numbers.
	 *
	 * @param seed - Arbitrary data that will be used as the seed.
	 * @returns Three numbers to use as initial values for [[AleaImplementation]].
	 */


	function mashSeed() {
	  var mash = Mash();
	  var s0 = mash(" ");
	  var s1 = mash(" ");
	  var s2 = mash(" ");

	  for (var i = 0; i < arguments.length; i++) {
	    s0 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

	    if (s0 < 0) {
	      s0 += 1;
	    }

	    s1 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

	    if (s1 < 0) {
	      s1 += 1;
	    }

	    s2 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

	    if (s2 < 0) {
	      s2 += 1;
	    }
	  }

	  return [s0, s1, s2];
	}
	/**
	 * Create a new mash function.
	 *
	 * @returns A nonpure function that takes arbitrary [[Mashable]] data and turns
	 * them into numbers.
	 */


	function Mash() {
	  var n = 0xefc8249d;
	  return function (data) {
	    var string = data.toString();

	    for (var i = 0; i < string.length; i++) {
	      n += string.charCodeAt(i);
	      var h = 0.02519603282416938 * n;
	      n = h >>> 0;
	      h -= n;
	      h *= n;
	      n = h >>> 0;
	      h -= n;
	      n += h * 0x100000000; // 2^32
	    }

	    return (n >>> 0) * 2.3283064365386963e-10; // 2^-32
	  };
	}
	/**
	 * Setup a mock hammer.js object, for unit testing.
	 *
	 * Inspiration: https://github.com/uber/deck.gl/pull/658
	 *
	 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
	 */


	function hammerMock$1() {
	  var noop = function noop() {};

	  return {
	    on: noop,
	    off: noop,
	    destroy: noop,
	    emit: noop,
	    get: function get() {
	      return {
	        set: noop
	      };
	    }
	  };
	}

	var Hammer$1 = typeof window !== "undefined" ? window.Hammer || Hammer$3 : function () {
	  // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
	  return hammerMock$1();
	};
	/**
	 * Turn an element into an clickToUse element.
	 * When not active, the element has a transparent overlay. When the overlay is
	 * clicked, the mode is changed to active.
	 * When active, the element is displayed with a blue border around it, and
	 * the interactive contents of the element can be used. When clicked outside
	 * the element, the elements mode is changed to inactive.
	 *
	 * @param {Element} container
	 * @class Activator
	 */

	function Activator$1(container) {
	  var _this = this,
	      _context3;

	  this._cleanupQueue = [];
	  this.active = false;
	  this._dom = {
	    container: container,
	    overlay: document.createElement("div")
	  };

	  this._dom.overlay.classList.add("vis-overlay");

	  this._dom.container.appendChild(this._dom.overlay);

	  this._cleanupQueue.push(function () {
	    _this._dom.overlay.parentNode.removeChild(_this._dom.overlay);
	  });

	  var hammer = Hammer$1(this._dom.overlay);
	  hammer.on("tap", _bindInstanceProperty$1(_context3 = this._onTapOverlay).call(_context3, this));

	  this._cleanupQueue.push(function () {
	    hammer.destroy(); // FIXME: cleaning up hammer instances doesn't work (Timeline not removed
	    // from memory)
	  }); // block all touch events (except tap)


	  var events = ["tap", "doubletap", "press", "pinch", "pan", "panstart", "panmove", "panend"];

	  _forEachInstanceProperty(events).call(events, function (event) {
	    hammer.on(event, function (event) {
	      event.srcEvent.stopPropagation();
	    });
	  }); // attach a click event to the window, in order to deactivate when clicking outside the timeline


	  if (document && document.body) {
	    this._onClick = function (event) {
	      if (!_hasParent$1(event.target, container)) {
	        _this.deactivate();
	      }
	    };

	    document.body.addEventListener("click", this._onClick);

	    this._cleanupQueue.push(function () {
	      document.body.removeEventListener("click", _this._onClick);
	    });
	  } // prepare escape key listener for deactivating when active


	  this._escListener = function (event) {
	    if ("key" in event ? event.key === "Escape" : event.keyCode === 27
	    /* the keyCode is for IE11 */
	    ) {
	      _this.deactivate();
	    }
	  };
	} // turn into an event emitter


	Emitter(Activator$1.prototype); // The currently active activator

	Activator$1.current = null;
	/**
	 * Destroy the activator. Cleans up all created DOM and event listeners
	 */

	Activator$1.prototype.destroy = function () {
	  var _context4, _context5;

	  this.deactivate();

	  var _iterator2 = _createForOfIteratorHelper$7(_reverseInstanceProperty(_context4 = _spliceInstanceProperty(_context5 = this._cleanupQueue).call(_context5, 0)).call(_context4)),
	      _step2;

	  try {
	    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	      var callback = _step2.value;
	      callback();
	    }
	  } catch (err) {
	    _iterator2.e(err);
	  } finally {
	    _iterator2.f();
	  }
	};
	/**
	 * Activate the element
	 * Overlay is hidden, element is decorated with a blue shadow border
	 */


	Activator$1.prototype.activate = function () {
	  // we allow only one active activator at a time
	  if (Activator$1.current) {
	    Activator$1.current.deactivate();
	  }

	  Activator$1.current = this;
	  this.active = true;
	  this._dom.overlay.style.display = "none";

	  this._dom.container.classList.add("vis-active");

	  this.emit("change");
	  this.emit("activate"); // ugly hack: bind ESC after emitting the events, as the Network rebinds all
	  // keyboard events on a 'change' event

	  document.body.addEventListener("keydown", this._escListener);
	};
	/**
	 * Deactivate the element
	 * Overlay is displayed on top of the element
	 */


	Activator$1.prototype.deactivate = function () {
	  this.active = false;
	  this._dom.overlay.style.display = "block";

	  this._dom.container.classList.remove("vis-active");

	  document.body.removeEventListener("keydown", this._escListener);
	  this.emit("change");
	  this.emit("deactivate");
	};
	/**
	 * Handle a tap event: activate the container
	 *
	 * @param {Event}  event   The event
	 * @private
	 */


	Activator$1.prototype._onTapOverlay = function (event) {
	  // activate the container
	  this.activate();
	  event.srcEvent.stopPropagation();
	};
	/**
	 * Test whether the element has the requested parent element somewhere in
	 * its chain of parent nodes.
	 *
	 * @param {HTMLElement} element
	 * @param {HTMLElement} parent
	 * @returns {boolean} Returns true when the parent is found somewhere in the
	 *                    chain of parent nodes.
	 * @private
	 */


	function _hasParent$1(element, parent) {
	  while (element) {
	    if (element === parent) {
	      return true;
	    }

	    element = element.parentNode;
	  }

	  return false;
	} // utility functions
	// parse ASP.Net Date pattern,
	// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
	// code from http://momentjs.com/


	var ASPDateRegex$1 = /^\/?Date\((-?\d+)/i; // Color REs

	var fullHexRE = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
	var shortHexRE = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
	var rgbRE = /^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i;
	var rgbaRE = /^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;
	/**
	 * Test whether given object is a number.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if number, false otherwise.
	 */

	function isNumber(value) {
	  return value instanceof Number || typeof value === "number";
	}
	/**
	 * Remove everything in the DOM object.
	 *
	 * @param DOMobject - Node whose child nodes will be recursively deleted.
	 */


	function recursiveDOMDelete(DOMobject) {
	  if (DOMobject) {
	    while (DOMobject.hasChildNodes() === true) {
	      var child = DOMobject.firstChild;

	      if (child) {
	        recursiveDOMDelete(child);
	        DOMobject.removeChild(child);
	      }
	    }
	  }
	}
	/**
	 * Test whether given object is a string.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if string, false otherwise.
	 */


	function isString(value) {
	  return value instanceof String || typeof value === "string";
	}
	/**
	 * Test whether given object is a object (not primitive or null).
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if not null object, false otherwise.
	 */


	function isObject$7(value) {
	  return _typeof$1(value) === "object" && value !== null;
	}
	/**
	 * Test whether given object is a Date, or a String containing a Date.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if Date instance or string date representation, false otherwise.
	 */


	function isDate(value) {
	  if (value instanceof Date) {
	    return true;
	  } else if (isString(value)) {
	    // test whether this string contains a date
	    var match = ASPDateRegex$1.exec(value);

	    if (match) {
	      return true;
	    } else if (!isNaN(Date.parse(value))) {
	      return true;
	    }
	  }

	  return false;
	}
	/**
	 * Copy property from b to a if property present in a.
	 * If property in b explicitly set to null, delete it if `allowDeletion` set.
	 *
	 * Internal helper routine, should not be exported. Not added to `exports` for that reason.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param prop - Name of property to copy from b to a.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 */


	function copyOrDelete(a, b, prop, allowDeletion) {
	  var doDeletion = false;

	  if (allowDeletion === true) {
	    doDeletion = b[prop] === null && a[prop] !== undefined;
	  }

	  if (doDeletion) {
	    delete a[prop];
	  } else {
	    a[prop] = b[prop]; // Remember, this is a reference copy!
	  }
	}
	/**
	 * Fill an object with a possibly partially defined other object.
	 *
	 * Only copies values for the properties already present in a.
	 * That means an object is not created on a property if only the b object has it.
	 *
	 * @param a - The object that will have it's properties updated.
	 * @param b - The object with property updates.
	 * @param allowDeletion - If true, delete properties in a that are explicitly set to null in b.
	 */


	function fillIfDefined(a, b) {
	  var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

	  // NOTE: iteration of properties of a
	  // NOTE: prototype properties iterated over as well
	  for (var prop in a) {
	    if (b[prop] !== undefined) {
	      if (b[prop] === null || _typeof$1(b[prop]) !== "object") {
	        // Note: typeof null === 'object'
	        copyOrDelete(a, b, prop, allowDeletion);
	      } else {
	        var aProp = a[prop];
	        var bProp = b[prop];

	        if (isObject$7(aProp) && isObject$7(bProp)) {
	          fillIfDefined(aProp, bProp, allowDeletion);
	        }
	      }
	    }
	  }
	}
	/**
	 * Copy the values of all of the enumerable own properties from one or more source objects to a
	 * target object. Returns the target object.
	 *
	 * @param target - The target object to copy to.
	 * @param source - The source object from which to copy properties.
	 * @returns The target object.
	 */


	var extend = _Object$assign;
	/**
	 * Extend object a with selected properties of object b or a series of objects.
	 *
	 * @remarks
	 * Only properties with defined values are copied.
	 * @param props - Properties to be copied to a.
	 * @param a - The target.
	 * @param others - The sources.
	 * @returns Argument a.
	 */

	function selectiveExtend(props, a) {
	  if (!_Array$isArray(props)) {
	    throw new Error("Array with property names expected as first argument");
	  }

	  for (var _len4 = arguments.length, others = new Array(_len4 > 2 ? _len4 - 2 : 0), _key4 = 2; _key4 < _len4; _key4++) {
	    others[_key4 - 2] = arguments[_key4];
	  }

	  for (var _i2 = 0, _others = others; _i2 < _others.length; _i2++) {
	    var other = _others[_i2];

	    for (var p = 0; p < props.length; p++) {
	      var prop = props[p];

	      if (other && Object.prototype.hasOwnProperty.call(other, prop)) {
	        a[prop] = other[prop];
	      }
	    }
	  }

	  return a;
	}
	/**
	 * Extend object a with selected properties of object b.
	 * Only properties with defined values are copied.
	 *
	 * @remarks
	 * Previous version of this routine implied that multiple source objects could
	 * be used; however, the implementation was **wrong**. Since multiple (\>1)
	 * sources weren't used anywhere in the `vis.js` code, this has been removed
	 * @param props - Names of first-level properties to copy over.
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 * @returns Argument a.
	 */


	function selectiveDeepExtend(props, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

	  // TODO: add support for Arrays to deepExtend
	  if (_Array$isArray(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }

	  for (var p = 0; p < props.length; p++) {
	    var prop = props[p];

	    if (Object.prototype.hasOwnProperty.call(b, prop)) {
	      if (b[prop] && b[prop].constructor === Object) {
	        if (a[prop] === undefined) {
	          a[prop] = {};
	        }

	        if (a[prop].constructor === Object) {
	          deepExtend(a[prop], b[prop], false, allowDeletion);
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (_Array$isArray(b[prop])) {
	        throw new TypeError("Arrays are not supported by deepExtend");
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }

	  return a;
	}
	/**
	 * Extend object `a` with properties of object `b`, ignoring properties which
	 * are explicitly specified to be excluded.
	 *
	 * @remarks
	 * The properties of `b` are considered for copying. Properties which are
	 * themselves objects are are also extended. Only properties with defined
	 * values are copied.
	 * @param propsToExclude - Names of properties which should *not* be copied.
	 * @param a - Object to extend.
	 * @param b - Object to take properties from for extension.
	 * @param allowDeletion - If true, delete properties in a that are explicitly
	 * set to null in b.
	 * @returns Argument a.
	 */


	function selectiveNotDeepExtend(propsToExclude, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

	  // TODO: add support for Arrays to deepExtend
	  // NOTE: array properties have an else-below; apparently, there is a problem here.
	  if (_Array$isArray(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }

	  for (var prop in b) {
	    if (!Object.prototype.hasOwnProperty.call(b, prop)) {
	      continue;
	    } // Handle local properties only


	    if (_includesInstanceProperty(propsToExclude).call(propsToExclude, prop)) {
	      continue;
	    } // In exclusion list, skip


	    if (b[prop] && b[prop].constructor === Object) {
	      if (a[prop] === undefined) {
	        a[prop] = {};
	      }

	      if (a[prop].constructor === Object) {
	        deepExtend(a[prop], b[prop]); // NOTE: allowDeletion not propagated!
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    } else if (_Array$isArray(b[prop])) {
	      a[prop] = [];

	      for (var i = 0; i < b[prop].length; i++) {
	        a[prop].push(b[prop][i]);
	      }
	    } else {
	      copyOrDelete(a, b, prop, allowDeletion);
	    }
	  }

	  return a;
	}
	/**
	 * Deep extend an object a with the properties of object b.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param protoExtend - If true, the prototype values will also be extended.
	 * (That is the options objects that inherit from others will also get the
	 * inherited options).
	 * @param allowDeletion - If true, the values of fields that are null will be deleted.
	 * @returns Argument a.
	 */


	function deepExtend(a, b) {
	  var protoExtend = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

	  for (var prop in b) {
	    if (Object.prototype.hasOwnProperty.call(b, prop) || protoExtend === true) {
	      if (_typeof$1(b[prop]) === "object" && b[prop] !== null && _Object$getPrototypeOf$1(b[prop]) === Object.prototype) {
	        if (a[prop] === undefined) {
	          a[prop] = deepExtend({}, b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else if (_typeof$1(a[prop]) === "object" && a[prop] !== null && _Object$getPrototypeOf$1(a[prop]) === Object.prototype) {
	          deepExtend(a[prop], b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (_Array$isArray(b[prop])) {
	        var _context6;

	        a[prop] = _sliceInstanceProperty(_context6 = b[prop]).call(_context6);
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }

	  return a;
	}
	/**
	 * Test whether all elements in two arrays are equal.
	 *
	 * @param a - First array.
	 * @param b - Second array.
	 * @returns True if both arrays have the same length and same elements (1 = '1').
	 */


	function equalArray(a, b) {
	  if (a.length !== b.length) {
	    return false;
	  }

	  for (var i = 0, len = a.length; i < len; i++) {
	    if (a[i] != b[i]) {
	      return false;
	    }
	  }

	  return true;
	}
	/**
	 * Get the type of an object, for example exports.getType([]) returns 'Array'.
	 *
	 * @param object - Input value of unknown type.
	 * @returns Detected type.
	 */


	function getType(object) {
	  var type = _typeof$1(object);

	  if (type === "object") {
	    if (object === null) {
	      return "null";
	    }

	    if (object instanceof Boolean) {
	      return "Boolean";
	    }

	    if (object instanceof Number) {
	      return "Number";
	    }

	    if (object instanceof String) {
	      return "String";
	    }

	    if (_Array$isArray(object)) {
	      return "Array";
	    }

	    if (object instanceof Date) {
	      return "Date";
	    }

	    return "Object";
	  }

	  if (type === "number") {
	    return "Number";
	  }

	  if (type === "boolean") {
	    return "Boolean";
	  }

	  if (type === "string") {
	    return "String";
	  }

	  if (type === undefined) {
	    return "undefined";
	  }

	  return type;
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - First part.
	 * @param newValue - The value to be aadded into the array.
	 * @returns A new array with all items from arr and newValue (which is last).
	 */


	function copyAndExtendArray(arr, newValue) {
	  var _context7;

	  return _concatInstanceProperty(_context7 = []).call(_context7, _toConsumableArray(arr), [newValue]);
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - The array to be copied.
	 * @returns Shallow copy of arr.
	 */


	function copyArray(arr) {
	  return _sliceInstanceProperty(arr).call(arr);
	}
	/**
	 * Retrieve the absolute left value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute left position of this element in the browser page.
	 */


	function getAbsoluteLeft(elem) {
	  return elem.getBoundingClientRect().left;
	}
	/**
	 * Retrieve the absolute right value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute right position of this element in the browser page.
	 */


	function getAbsoluteRight(elem) {
	  return elem.getBoundingClientRect().right;
	}
	/**
	 * Retrieve the absolute top value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute top position of this element in the browser page.
	 */


	function getAbsoluteTop(elem) {
	  return elem.getBoundingClientRect().top;
	}
	/**
	 * Add a className to the given elements style.
	 *
	 * @param elem - The element to which the classes will be added.
	 * @param classNames - Space separated list of classes.
	 */


	function addClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var newClasses = classNames.split(" ");
	  classes = _concatInstanceProperty(classes).call(classes, _filterInstanceProperty(newClasses).call(newClasses, function (className) {
	    return !_includesInstanceProperty(classes).call(classes, className);
	  }));
	  elem.className = classes.join(" ");
	}
	/**
	 * Remove a className from the given elements style.
	 *
	 * @param elem - The element from which the classes will be removed.
	 * @param classNames - Space separated list of classes.
	 */


	function removeClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var oldClasses = classNames.split(" ");
	  classes = _filterInstanceProperty(classes).call(classes, function (className) {
	    return !_includesInstanceProperty(oldClasses).call(oldClasses, className);
	  });
	  elem.className = classes.join(" ");
	}
	/**
	 * For each method for both arrays and objects.
	 * In case of an array, the built-in Array.forEach() is applied (**No, it's not!**).
	 * In case of an Object, the method loops over all properties of the object.
	 *
	 * @param object - An Object or Array to be iterated over.
	 * @param callback - Array.forEach-like callback.
	 */


	function forEach$4(object, callback) {
	  if (_Array$isArray(object)) {
	    // array
	    var len = object.length;

	    for (var i = 0; i < len; i++) {
	      callback(object[i], i, object);
	    }
	  } else {
	    // object
	    for (var key in object) {
	      if (Object.prototype.hasOwnProperty.call(object, key)) {
	        callback(object[key], key, object);
	      }
	    }
	  }
	}
	/**
	 * Convert an object into an array: all objects properties are put into the array. The resulting array is unordered.
	 *
	 * @param o - Object that contains the properties and methods.
	 * @returns An array of unordered values.
	 */


	var toArray = _Object$values2;
	/**
	 * Update a property in an object.
	 *
	 * @param object - The object whose property will be updated.
	 * @param key - Name of the property to be updated.
	 * @param value - The new value to be assigned.
	 * @returns Whether the value was updated (true) or already strictly the same in the original object (false).
	 */

	function updateProperty(object, key, value) {
	  if (object[key] !== value) {
	    object[key] = value;
	    return true;
	  } else {
	    return false;
	  }
	}
	/**
	 * Throttle the given function to be only executed once per animation frame.
	 *
	 * @param fn - The original function.
	 * @returns The throttled function.
	 */


	function throttle(fn) {
	  var scheduled = false;
	  return function () {
	    if (!scheduled) {
	      scheduled = true;
	      requestAnimationFrame(function () {
	        scheduled = false;
	        fn();
	      });
	    }
	  };
	}
	/**
	 * Add and event listener. Works for all browsers.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.addEventListener(action, —, —).
	 * @param listener - Same as Element.addEventListener(—, listener, —).
	 * @param useCapture - Same as Element.addEventListener(—, —, useCapture).
	 */


	function addEventListener(element, action, listener, useCapture) {
	  if (element.addEventListener) {
	    var _context8;

	    if (useCapture === undefined) {
	      useCapture = false;
	    }

	    if (action === "mousewheel" && _includesInstanceProperty(_context8 = navigator.userAgent).call(_context8, "Firefox")) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.addEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.attachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Remove an event listener from an element.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.removeEventListener(action, —, —).
	 * @param listener - Same as Element.removeEventListener(—, listener, —).
	 * @param useCapture - Same as Element.removeEventListener(—, —, useCapture).
	 */


	function removeEventListener(element, action, listener, useCapture) {
	  if (element.removeEventListener) {
	    var _context9;

	    // non-IE browsers
	    if (useCapture === undefined) {
	      useCapture = false;
	    }

	    if (action === "mousewheel" && _includesInstanceProperty(_context9 = navigator.userAgent).call(_context9, "Firefox")) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.removeEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.detachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Cancels the event's default action if it is cancelable, without stopping further propagation of the event.
	 *
	 * @param event - The event whose default action should be prevented.
	 */


	function preventDefault(event) {
	  if (!event) {
	    event = window.event;
	  }

	  if (!event) ;else if (event.preventDefault) {
	    event.preventDefault(); // non-IE browsers
	  } else {
	    // @TODO: IE types? Does anyone care?
	    event.returnValue = false; // IE browsers
	  }
	}
	/**
	 * Get HTML element which is the target of the event.
	 *
	 * @param event - The event.
	 * @returns The element or null if not obtainable.
	 */


	function getTarget() {
	  var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window.event;
	  // code from http://www.quirksmode.org/js/events_properties.html
	  // @TODO: EventTarget can be almost anything, is it okay to return only Elements?
	  var target = null;
	  if (!event) ;else if (event.target) {
	    target = event.target;
	  } else if (event.srcElement) {
	    target = event.srcElement;
	  }

	  if (!(target instanceof Element)) {
	    return null;
	  }

	  if (target.nodeType != null && target.nodeType == 3) {
	    // defeat Safari bug
	    target = target.parentNode;

	    if (!(target instanceof Element)) {
	      return null;
	    }
	  }

	  return target;
	}
	/**
	 * Check if given element contains given parent somewhere in the DOM tree.
	 *
	 * @param element - The element to be tested.
	 * @param parent - The ancestor (not necessarily parent) of the element.
	 * @returns True if parent is an ancestor of the element, false otherwise.
	 */


	function hasParent(element, parent) {
	  var elem = element;

	  while (elem) {
	    if (elem === parent) {
	      return true;
	    } else if (elem.parentNode) {
	      elem = elem.parentNode;
	    } else {
	      return false;
	    }
	  }

	  return false;
	}

	var option = {
	  /**
	   * Convert a value into a boolean.
	   *
	   * @param value - Value to be converted intoboolean, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding boolean value, if none then the default value, if none then null.
	   */
	  asBoolean: function asBoolean(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (value != null) {
	      return value != false;
	    }

	    return defaultValue || null;
	  },

	  /**
	   * Convert a value into a number.
	   *
	   * @param value - Value to be converted intonumber, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding **boxed** number value, if none then the default value, if none then null.
	   */
	  asNumber: function asNumber(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (value != null) {
	      return Number(value) || defaultValue || null;
	    }

	    return defaultValue || null;
	  },

	  /**
	   * Convert a value into a string.
	   *
	   * @param value - Value to be converted intostring, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding **boxed** string value, if none then the default value, if none then null.
	   */
	  asString: function asString(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (value != null) {
	      return String(value);
	    }

	    return defaultValue || null;
	  },

	  /**
	   * Convert a value into a size.
	   *
	   * @param value - Value to be converted intosize, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding string value (number + 'px'), if none then the default value, if none then null.
	   */
	  asSize: function asSize(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (isString(value)) {
	      return value;
	    } else if (isNumber(value)) {
	      return value + "px";
	    } else {
	      return defaultValue || null;
	    }
	  },

	  /**
	   * Convert a value into a DOM Element.
	   *
	   * @param value - Value to be converted into DOM Element, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns The DOM Element, if none then the default value, if none then null.
	   */
	  asElement: function asElement(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    return value || defaultValue || null;
	  }
	};
	/**
	 * Convert hex color string into RGB color object.
	 *
	 * @remarks
	 * {@link http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb}
	 * @param hex - Hex color string (3 or 6 digits, with or without #).
	 * @returns RGB color object.
	 */

	function hexToRGB(hex) {
	  var result;

	  switch (hex.length) {
	    case 3:
	    case 4:
	      result = shortHexRE.exec(hex);
	      return result ? {
	        r: _parseInt(result[1] + result[1], 16),
	        g: _parseInt(result[2] + result[2], 16),
	        b: _parseInt(result[3] + result[3], 16)
	      } : null;

	    case 6:
	    case 7:
	      result = fullHexRE.exec(hex);
	      return result ? {
	        r: _parseInt(result[1], 16),
	        g: _parseInt(result[2], 16),
	        b: _parseInt(result[3], 16)
	      } : null;

	    default:
	      return null;
	  }
	}
	/**
	 * This function takes string color in hex or RGB format and adds the opacity, RGBA is passed through unchanged.
	 *
	 * @param color - The color string (hex, RGB, RGBA).
	 * @param opacity - The new opacity.
	 * @returns RGBA string, for example 'rgba(255, 0, 127, 0.3)'.
	 */


	function overrideOpacity(color, opacity) {
	  if (_includesInstanceProperty(color).call(color, "rgba")) {
	    return color;
	  } else if (_includesInstanceProperty(color).call(color, "rgb")) {
	    var rgb = color.substr(_indexOfInstanceProperty(color).call(color, "(") + 1).replace(")", "").split(",");
	    return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + opacity + ")";
	  } else {
	    var _rgb = hexToRGB(color);

	    if (_rgb == null) {
	      return color;
	    } else {
	      return "rgba(" + _rgb.r + "," + _rgb.g + "," + _rgb.b + "," + opacity + ")";
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into hex color string.
	 *
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 * @returns Hex color string (for example: '#0acdc0').
	 */


	function RGBToHex(red, green, blue) {
	  var _context10;

	  return "#" + _sliceInstanceProperty(_context10 = ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16)).call(_context10, 1);
	}
	/**
	 * Parse a color property into an object with border, background, and highlight colors.
	 *
	 * @param inputColor - Shorthand color string or input color object.
	 * @param defaultColor - Full color object to fill in missing values in inputColor.
	 * @returns Color object.
	 */


	function parseColor(inputColor, defaultColor) {
	  if (isString(inputColor)) {
	    var colorStr = inputColor;

	    if (isValidRGB(colorStr)) {
	      var _context11;

	      var rgb = _mapInstanceProperty(_context11 = colorStr.substr(4).substr(0, colorStr.length - 5).split(",")).call(_context11, function (value) {
	        return _parseInt(value);
	      });

	      colorStr = RGBToHex(rgb[0], rgb[1], rgb[2]);
	    }

	    if (isValidHex(colorStr) === true) {
	      var hsv = hexToHSV(colorStr);
	      var lighterColorHSV = {
	        h: hsv.h,
	        s: hsv.s * 0.8,
	        v: Math.min(1, hsv.v * 1.02)
	      };
	      var darkerColorHSV = {
	        h: hsv.h,
	        s: Math.min(1, hsv.s * 1.25),
	        v: hsv.v * 0.8
	      };
	      var darkerColorHex = HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
	      var lighterColorHex = HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
	      return {
	        background: colorStr,
	        border: darkerColorHex,
	        highlight: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        },
	        hover: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        }
	      };
	    } else {
	      return {
	        background: colorStr,
	        border: colorStr,
	        highlight: {
	          background: colorStr,
	          border: colorStr
	        },
	        hover: {
	          background: colorStr,
	          border: colorStr
	        }
	      };
	    }
	  } else {
	    if (defaultColor) {
	      var color = {
	        background: inputColor.background || defaultColor.background,
	        border: inputColor.border || defaultColor.border,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || defaultColor.highlight.background,
	          border: inputColor.highlight && inputColor.highlight.border || defaultColor.highlight.border
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || defaultColor.hover.border,
	          background: inputColor.hover && inputColor.hover.background || defaultColor.hover.background
	        }
	      };
	      return color;
	    } else {
	      var _color = {
	        background: inputColor.background || undefined,
	        border: inputColor.border || undefined,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || undefined,
	          border: inputColor.highlight && inputColor.highlight.border || undefined
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || undefined,
	          background: inputColor.hover && inputColor.hover.background || undefined
	        }
	      };
	      return _color;
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into HSV object.
	 *
	 * @remarks
	 * {@link http://www.javascripter.net/faq/rgb2hsv.htm}
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 * @returns HSV color object.
	 */


	function RGBToHSV(red, green, blue) {
	  red = red / 255;
	  green = green / 255;
	  blue = blue / 255;
	  var minRGB = Math.min(red, Math.min(green, blue));
	  var maxRGB = Math.max(red, Math.max(green, blue)); // Black-gray-white

	  if (minRGB === maxRGB) {
	    return {
	      h: 0,
	      s: 0,
	      v: minRGB
	    };
	  } // Colors other than black-gray-white:


	  var d = red === minRGB ? green - blue : blue === minRGB ? red - green : blue - red;
	  var h = red === minRGB ? 3 : blue === minRGB ? 1 : 5;
	  var hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
	  var saturation = (maxRGB - minRGB) / maxRGB;
	  var value = maxRGB;
	  return {
	    h: hue,
	    s: saturation,
	    v: value
	  };
	}

	var cssUtil = {
	  // split a string with css styles into an object with key/values
	  split: function split(cssText) {
	    var _context12;

	    var styles = {};

	    _forEachInstanceProperty(_context12 = cssText.split(";")).call(_context12, function (style) {
	      if (_trimInstanceProperty(style).call(style) != "") {
	        var _context13, _context14;

	        var parts = style.split(":");

	        var key = _trimInstanceProperty(_context13 = parts[0]).call(_context13);

	        var value = _trimInstanceProperty(_context14 = parts[1]).call(_context14);

	        styles[key] = value;
	      }
	    });

	    return styles;
	  },
	  // build a css text string from an object with key/values
	  join: function join(styles) {
	    var _context15;

	    return _mapInstanceProperty(_context15 = _Object$keys(styles)).call(_context15, function (key) {
	      return key + ": " + styles[key];
	    }).join("; ");
	  }
	};
	/**
	 * Append a string with css styles to an element.
	 *
	 * @param element - The element that will receive new styles.
	 * @param cssText - The styles to be appended.
	 */

	function addCssText(element, cssText) {
	  var currentStyles = cssUtil.split(element.style.cssText);
	  var newStyles = cssUtil.split(cssText);

	  var styles = _objectSpread$2(_objectSpread$2({}, currentStyles), newStyles);

	  element.style.cssText = cssUtil.join(styles);
	}
	/**
	 * Remove a string with css styles from an element.
	 *
	 * @param element - The element from which styles should be removed.
	 * @param cssText - The styles to be removed.
	 */


	function removeCssText(element, cssText) {
	  var styles = cssUtil.split(element.style.cssText);
	  var removeStyles = cssUtil.split(cssText);

	  for (var key in removeStyles) {
	    if (Object.prototype.hasOwnProperty.call(removeStyles, key)) {
	      delete styles[key];
	    }
	  }

	  element.style.cssText = cssUtil.join(styles);
	}
	/**
	 * Convert HSV \<0, 1\> into RGB color object.
	 *
	 * @remarks
	 * {@link https://gist.github.com/mjijackson/5311256}
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 * @returns RGB color object.
	 */


	function HSVToRGB(h, s, v) {
	  var r;
	  var g;
	  var b;
	  var i = Math.floor(h * 6);
	  var f = h * 6 - i;
	  var p = v * (1 - s);
	  var q = v * (1 - f * s);
	  var t = v * (1 - (1 - f) * s);

	  switch (i % 6) {
	    case 0:
	      r = v, g = t, b = p;
	      break;

	    case 1:
	      r = q, g = v, b = p;
	      break;

	    case 2:
	      r = p, g = v, b = t;
	      break;

	    case 3:
	      r = p, g = q, b = v;
	      break;

	    case 4:
	      r = t, g = p, b = v;
	      break;

	    case 5:
	      r = v, g = p, b = q;
	      break;
	  }

	  return {
	    r: Math.floor(r * 255),
	    g: Math.floor(g * 255),
	    b: Math.floor(b * 255)
	  };
	}
	/**
	 * Convert HSV \<0, 1\> into hex color string.
	 *
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 * @returns Hex color string.
	 */


	function HSVToHex(h, s, v) {
	  var rgb = HSVToRGB(h, s, v);
	  return RGBToHex(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Convert hex color string into HSV \<0, 1\>.
	 *
	 * @param hex - Hex color string.
	 * @returns HSV color object.
	 */


	function hexToHSV(hex) {
	  var rgb = hexToRGB(hex);

	  if (!rgb) {
	    throw new TypeError("'".concat(hex, "' is not a valid color."));
	  }

	  return RGBToHSV(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Validate hex color string.
	 *
	 * @param hex - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */


	function isValidHex(hex) {
	  var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
	  return isOk;
	}
	/**
	 * Validate RGB color string.
	 *
	 * @param rgb - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */


	function isValidRGB(rgb) {
	  return rgbRE.test(rgb);
	}
	/**
	 * Validate RGBA color string.
	 *
	 * @param rgba - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */


	function isValidRGBA(rgba) {
	  return rgbaRE.test(rgba);
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param fields - Names of properties to be bridged.
	 * @param referenceObject - The original object.
	 * @returns A new object inheriting from the referenceObject.
	 */


	function selectiveBridgeObject(fields, referenceObject) {
	  if (referenceObject !== null && _typeof$1(referenceObject) === "object") {
	    // !!! typeof null === 'object'
	    var objectTo = _Object$create$1(referenceObject);

	    for (var i = 0; i < fields.length; i++) {
	      if (Object.prototype.hasOwnProperty.call(referenceObject, fields[i])) {
	        if (_typeof$1(referenceObject[fields[i]]) == "object") {
	          objectTo[fields[i]] = bridgeObject(referenceObject[fields[i]]);
	        }
	      }
	    }

	    return objectTo;
	  } else {
	    return null;
	  }
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param referenceObject - The original object.
	 * @returns The Element if the referenceObject is an Element, or a new object inheriting from the referenceObject.
	 */


	function bridgeObject(referenceObject) {
	  if (referenceObject === null || _typeof$1(referenceObject) !== "object") {
	    return null;
	  }

	  if (referenceObject instanceof Element) {
	    // Avoid bridging DOM objects
	    return referenceObject;
	  }

	  var objectTo = _Object$create$1(referenceObject);

	  for (var i in referenceObject) {
	    if (Object.prototype.hasOwnProperty.call(referenceObject, i)) {
	      if (_typeof$1(referenceObject[i]) == "object") {
	        objectTo[i] = bridgeObject(referenceObject[i]);
	      }
	    }
	  }

	  return objectTo;
	}
	/**
	 * This method provides a stable sort implementation, very fast for presorted data.
	 *
	 * @param a - The array to be sorted (in-place).
	 * @param compare - An order comparator.
	 * @returns The argument a.
	 */


	function insertSort(a, compare) {
	  for (var i = 0; i < a.length; i++) {
	    var k = a[i];
	    var j = void 0;

	    for (j = i; j > 0 && compare(k, a[j - 1]) < 0; j--) {
	      a[j] = a[j - 1];
	    }

	    a[j] = k;
	  }

	  return a;
	}
	/**
	 * This is used to set the options of subobjects in the options object.
	 *
	 * A requirement of these subobjects is that they have an 'enabled' element
	 * which is optional for the user but mandatory for the program.
	 *
	 * The added value here of the merge is that option 'enabled' is set as required.
	 *
	 * @param mergeTarget - Either this.options or the options used for the groups.
	 * @param options - Options.
	 * @param option - Option key in the options argument.
	 * @param globalOptions - Global options, passed in to determine value of option 'enabled'.
	 */


	function mergeOptions(mergeTarget, options, option) {
	  var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

	  // Local helpers
	  var isPresent = function isPresent(obj) {
	    return obj !== null && obj !== undefined;
	  };

	  var isObject = function isObject(obj) {
	    return obj !== null && _typeof$1(obj) === "object";
	  }; // https://stackoverflow.com/a/34491287/1223531


	  var isEmpty = function isEmpty(obj) {
	    for (var x in obj) {
	      if (Object.prototype.hasOwnProperty.call(obj, x)) {
	        return false;
	      }
	    }

	    return true;
	  }; // Guards


	  if (!isObject(mergeTarget)) {
	    throw new Error("Parameter mergeTarget must be an object");
	  }

	  if (!isObject(options)) {
	    throw new Error("Parameter options must be an object");
	  }

	  if (!isPresent(option)) {
	    throw new Error("Parameter option must have a value");
	  }

	  if (!isObject(globalOptions)) {
	    throw new Error("Parameter globalOptions must be an object");
	  } //
	  // Actual merge routine, separated from main logic
	  // Only a single level of options is merged. Deeper levels are ref'd. This may actually be an issue.
	  //


	  var doMerge = function doMerge(target, options, option) {
	    if (!isObject(target[option])) {
	      target[option] = {};
	    }

	    var src = options[option];
	    var dst = target[option];

	    for (var prop in src) {
	      if (Object.prototype.hasOwnProperty.call(src, prop)) {
	        dst[prop] = src[prop];
	      }
	    }
	  }; // Local initialization


	  var srcOption = options[option];
	  var globalPassed = isObject(globalOptions) && !isEmpty(globalOptions);
	  var globalOption = globalPassed ? globalOptions[option] : undefined;
	  var globalEnabled = globalOption ? globalOption.enabled : undefined; /////////////////////////////////////////
	  // Main routine
	  /////////////////////////////////////////

	  if (srcOption === undefined) {
	    return; // Nothing to do
	  }

	  if (typeof srcOption === "boolean") {
	    if (!isObject(mergeTarget[option])) {
	      mergeTarget[option] = {};
	    }

	    mergeTarget[option].enabled = srcOption;
	    return;
	  }

	  if (srcOption === null && !isObject(mergeTarget[option])) {
	    // If possible, explicit copy from globals
	    if (isPresent(globalOption)) {
	      mergeTarget[option] = _Object$create$1(globalOption);
	    } else {
	      return; // Nothing to do
	    }
	  }

	  if (!isObject(srcOption)) {
	    return;
	  } //
	  // Ensure that 'enabled' is properly set. It is required internally
	  // Note that the value from options will always overwrite the existing value
	  //


	  var enabled = true; // default value

	  if (srcOption.enabled !== undefined) {
	    enabled = srcOption.enabled;
	  } else {
	    // Take from globals, if present
	    if (globalEnabled !== undefined) {
	      enabled = globalOption.enabled;
	    }
	  }

	  doMerge(mergeTarget, options, option);
	  mergeTarget[option].enabled = enabled;
	}
	/**
	 * This function does a binary search for a visible item in a sorted list. If we find a visible item, the code that uses
	 * this function will then iterate in both directions over this sorted list to find all visible items.
	 *
	 * @param orderedItems - Items ordered by start.
	 * @param comparator - -1 is lower, 0 is equal, 1 is higher.
	 * @param field - Property name on an item (That is item[field]).
	 * @param field2 - Second property name on an item (That is item[field][field2]).
	 * @returns Index of the found item or -1 if nothing was found.
	 */


	function binarySearchCustom(orderedItems, comparator, field, field2) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;

	  while (low <= high && iteration < maxIterations) {
	    var middle = Math.floor((low + high) / 2);
	    var item = orderedItems[middle];
	    var value = field2 === undefined ? item[field] : item[field][field2];
	    var searchResult = comparator(value);

	    if (searchResult == 0) {
	      // jihaa, found a visible item!
	      return middle;
	    } else if (searchResult == -1) {
	      // it is too small --> increase low
	      low = middle + 1;
	    } else {
	      // it is too big --> decrease high
	      high = middle - 1;
	    }

	    iteration++;
	  }

	  return -1;
	}
	/**
	 * This function does a binary search for a specific value in a sorted array.
	 * If it does not exist but is in between of two values, we return either the
	 * one before or the one after, depending on user input If it is found, we
	 * return the index, else -1.
	 *
	 * @param orderedItems - Sorted array.
	 * @param target - The searched value.
	 * @param field - Name of the property in items to be searched.
	 * @param sidePreference - If the target is between two values, should the index of the before or the after be returned?
	 * @param comparator - An optional comparator, returning -1, 0, 1 for \<, ===, \>.
	 * @returns The index of found value or -1 if nothing was found.
	 */


	function binarySearchValue(orderedItems, target, field, sidePreference, comparator) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;
	  var prevValue;
	  var value;
	  var nextValue;
	  var middle;
	  comparator = comparator != undefined ? comparator : function (a, b) {
	    return a == b ? 0 : a < b ? -1 : 1;
	  };

	  while (low <= high && iteration < maxIterations) {
	    // get a new guess
	    middle = Math.floor(0.5 * (high + low));
	    prevValue = orderedItems[Math.max(0, middle - 1)][field];
	    value = orderedItems[middle][field];
	    nextValue = orderedItems[Math.min(orderedItems.length - 1, middle + 1)][field];

	    if (comparator(value, target) == 0) {
	      // we found the target
	      return middle;
	    } else if (comparator(prevValue, target) < 0 && comparator(value, target) > 0) {
	      // target is in between of the previous and the current
	      return sidePreference == "before" ? Math.max(0, middle - 1) : middle;
	    } else if (comparator(value, target) < 0 && comparator(nextValue, target) > 0) {
	      // target is in between of the current and the next
	      return sidePreference == "before" ? middle : Math.min(orderedItems.length - 1, middle + 1);
	    } else {
	      // didnt find the target, we need to change our boundaries.
	      if (comparator(value, target) < 0) {
	        // it is too small --> increase low
	        low = middle + 1;
	      } else {
	        // it is too big --> decrease high
	        high = middle - 1;
	      }
	    }

	    iteration++;
	  } // didnt find anything. Return -1.


	  return -1;
	}
	/*
	 * Easing Functions.
	 * Only considering the t value for the range [0, 1] => [0, 1].
	 *
	 * Inspiration: from http://gizma.com/easing/
	 * https://gist.github.com/gre/1650294
	 */


	var easingFunctions = {
	  /**
	   * Provides no easing and no acceleration.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  linear: function linear(t) {
	    return t;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuad: function easeInQuad(t) {
	    return t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuad: function easeOutQuad(t) {
	    return t * (2 - t);
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuad: function easeInOutQuad(t) {
	    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInCubic: function easeInCubic(t) {
	    return t * t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutCubic: function easeOutCubic(t) {
	    return --t * t * t + 1;
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutCubic: function easeInOutCubic(t) {
	    return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuart: function easeInQuart(t) {
	    return t * t * t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuart: function easeOutQuart(t) {
	    return 1 - --t * t * t * t;
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuart: function easeInOutQuart(t) {
	    return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuint: function easeInQuint(t) {
	    return t * t * t * t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuint: function easeOutQuint(t) {
	    return 1 + --t * t * t * t * t;
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuint: function easeInOutQuint(t) {
	    return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
	  }
	};
	/**
	 * Experimentaly compute the width of the scrollbar for this browser.
	 *
	 * @returns The width in pixels.
	 */

	function getScrollBarWidth() {
	  var inner = document.createElement("p");
	  inner.style.width = "100%";
	  inner.style.height = "200px";
	  var outer = document.createElement("div");
	  outer.style.position = "absolute";
	  outer.style.top = "0px";
	  outer.style.left = "0px";
	  outer.style.visibility = "hidden";
	  outer.style.width = "200px";
	  outer.style.height = "150px";
	  outer.style.overflow = "hidden";
	  outer.appendChild(inner);
	  document.body.appendChild(outer);
	  var w1 = inner.offsetWidth;
	  outer.style.overflow = "scroll";
	  var w2 = inner.offsetWidth;

	  if (w1 == w2) {
	    w2 = outer.clientWidth;
	  }

	  document.body.removeChild(outer);
	  return w1 - w2;
	} // @TODO: This doesn't work properly.
	// It works only for single property objects,
	// otherwise it combines all of the types in a union.
	// export function topMost<K1 extends string, V1> (
	//   pile: Record<K1, undefined | V1>[],
	//   accessors: K1 | [K1]
	// ): undefined | V1
	// export function topMost<K1 extends string, K2 extends string, V1, V2> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2>>[],
	//   accessors: [K1, K2]
	// ): undefined | V1 | V2
	// export function topMost<K1 extends string, K2 extends string, K3 extends string, V1, V2, V3> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2 | Record<K3, undefined | V3>>>[],
	//   accessors: [K1, K2, K3]
	// ): undefined | V1 | V2 | V3

	/**
	 * Get the top most property value from a pile of objects.
	 *
	 * @param pile - Array of objects, no required format.
	 * @param accessors - Array of property names.
	 * For example `object['foo']['bar']` → `['foo', 'bar']`.
	 * @returns Value of the property with given accessors path from the first pile item where it's not undefined.
	 */


	function topMost(pile, accessors) {
	  var candidate;

	  if (!_Array$isArray(accessors)) {
	    accessors = [accessors];
	  }

	  var _iterator3 = _createForOfIteratorHelper$7(pile),
	      _step3;

	  try {
	    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
	      var member = _step3.value;

	      if (member) {
	        candidate = member[accessors[0]];

	        for (var i = 1; i < accessors.length; i++) {
	          if (candidate) {
	            candidate = candidate[accessors[i]];
	          }
	        }

	        if (typeof candidate !== "undefined") {
	          break;
	        }
	      }
	    }
	  } catch (err) {
	    _iterator3.e(err);
	  } finally {
	    _iterator3.f();
	  }

	  return candidate;
	}

	var htmlColors$1 = {
	  black: "#000000",
	  navy: "#000080",
	  darkblue: "#00008B",
	  mediumblue: "#0000CD",
	  blue: "#0000FF",
	  darkgreen: "#006400",
	  green: "#008000",
	  teal: "#008080",
	  darkcyan: "#008B8B",
	  deepskyblue: "#00BFFF",
	  darkturquoise: "#00CED1",
	  mediumspringgreen: "#00FA9A",
	  lime: "#00FF00",
	  springgreen: "#00FF7F",
	  aqua: "#00FFFF",
	  cyan: "#00FFFF",
	  midnightblue: "#191970",
	  dodgerblue: "#1E90FF",
	  lightseagreen: "#20B2AA",
	  forestgreen: "#228B22",
	  seagreen: "#2E8B57",
	  darkslategray: "#2F4F4F",
	  limegreen: "#32CD32",
	  mediumseagreen: "#3CB371",
	  turquoise: "#40E0D0",
	  royalblue: "#4169E1",
	  steelblue: "#4682B4",
	  darkslateblue: "#483D8B",
	  mediumturquoise: "#48D1CC",
	  indigo: "#4B0082",
	  darkolivegreen: "#556B2F",
	  cadetblue: "#5F9EA0",
	  cornflowerblue: "#6495ED",
	  mediumaquamarine: "#66CDAA",
	  dimgray: "#696969",
	  slateblue: "#6A5ACD",
	  olivedrab: "#6B8E23",
	  slategray: "#708090",
	  lightslategray: "#778899",
	  mediumslateblue: "#7B68EE",
	  lawngreen: "#7CFC00",
	  chartreuse: "#7FFF00",
	  aquamarine: "#7FFFD4",
	  maroon: "#800000",
	  purple: "#800080",
	  olive: "#808000",
	  gray: "#808080",
	  skyblue: "#87CEEB",
	  lightskyblue: "#87CEFA",
	  blueviolet: "#8A2BE2",
	  darkred: "#8B0000",
	  darkmagenta: "#8B008B",
	  saddlebrown: "#8B4513",
	  darkseagreen: "#8FBC8F",
	  lightgreen: "#90EE90",
	  mediumpurple: "#9370D8",
	  darkviolet: "#9400D3",
	  palegreen: "#98FB98",
	  darkorchid: "#9932CC",
	  yellowgreen: "#9ACD32",
	  sienna: "#A0522D",
	  brown: "#A52A2A",
	  darkgray: "#A9A9A9",
	  lightblue: "#ADD8E6",
	  greenyellow: "#ADFF2F",
	  paleturquoise: "#AFEEEE",
	  lightsteelblue: "#B0C4DE",
	  powderblue: "#B0E0E6",
	  firebrick: "#B22222",
	  darkgoldenrod: "#B8860B",
	  mediumorchid: "#BA55D3",
	  rosybrown: "#BC8F8F",
	  darkkhaki: "#BDB76B",
	  silver: "#C0C0C0",
	  mediumvioletred: "#C71585",
	  indianred: "#CD5C5C",
	  peru: "#CD853F",
	  chocolate: "#D2691E",
	  tan: "#D2B48C",
	  lightgrey: "#D3D3D3",
	  palevioletred: "#D87093",
	  thistle: "#D8BFD8",
	  orchid: "#DA70D6",
	  goldenrod: "#DAA520",
	  crimson: "#DC143C",
	  gainsboro: "#DCDCDC",
	  plum: "#DDA0DD",
	  burlywood: "#DEB887",
	  lightcyan: "#E0FFFF",
	  lavender: "#E6E6FA",
	  darksalmon: "#E9967A",
	  violet: "#EE82EE",
	  palegoldenrod: "#EEE8AA",
	  lightcoral: "#F08080",
	  khaki: "#F0E68C",
	  aliceblue: "#F0F8FF",
	  honeydew: "#F0FFF0",
	  azure: "#F0FFFF",
	  sandybrown: "#F4A460",
	  wheat: "#F5DEB3",
	  beige: "#F5F5DC",
	  whitesmoke: "#F5F5F5",
	  mintcream: "#F5FFFA",
	  ghostwhite: "#F8F8FF",
	  salmon: "#FA8072",
	  antiquewhite: "#FAEBD7",
	  linen: "#FAF0E6",
	  lightgoldenrodyellow: "#FAFAD2",
	  oldlace: "#FDF5E6",
	  red: "#FF0000",
	  fuchsia: "#FF00FF",
	  magenta: "#FF00FF",
	  deeppink: "#FF1493",
	  orangered: "#FF4500",
	  tomato: "#FF6347",
	  hotpink: "#FF69B4",
	  coral: "#FF7F50",
	  darkorange: "#FF8C00",
	  lightsalmon: "#FFA07A",
	  orange: "#FFA500",
	  lightpink: "#FFB6C1",
	  pink: "#FFC0CB",
	  gold: "#FFD700",
	  peachpuff: "#FFDAB9",
	  navajowhite: "#FFDEAD",
	  moccasin: "#FFE4B5",
	  bisque: "#FFE4C4",
	  mistyrose: "#FFE4E1",
	  blanchedalmond: "#FFEBCD",
	  papayawhip: "#FFEFD5",
	  lavenderblush: "#FFF0F5",
	  seashell: "#FFF5EE",
	  cornsilk: "#FFF8DC",
	  lemonchiffon: "#FFFACD",
	  floralwhite: "#FFFAF0",
	  snow: "#FFFAFA",
	  yellow: "#FFFF00",
	  lightyellow: "#FFFFE0",
	  ivory: "#FFFFF0",
	  white: "#FFFFFF"
	};
	/**
	 * @param {number} [pixelRatio=1]
	 */

	var ColorPicker$1 = /*#__PURE__*/function () {
	  /**
	   * @param {number} [pixelRatio=1]
	   */
	  function ColorPicker$1() {
	    var pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

	    _classCallCheck(this, ColorPicker$1);

	    this.pixelRatio = pixelRatio;
	    this.generated = false;
	    this.centerCoordinates = {
	      x: 289 / 2,
	      y: 289 / 2
	    };
	    this.r = 289 * 0.49;
	    this.color = {
	      r: 255,
	      g: 255,
	      b: 255,
	      a: 1.0
	    };
	    this.hueCircle = undefined;
	    this.initialColor = {
	      r: 255,
	      g: 255,
	      b: 255,
	      a: 1.0
	    };
	    this.previousColor = undefined;
	    this.applied = false; // bound by

	    this.updateCallback = function () {};

	    this.closeCallback = function () {}; // create all DOM elements


	    this._create();
	  }
	  /**
	   * this inserts the colorPicker into a div from the DOM
	   *
	   * @param {Element} container
	   */


	  _createClass(ColorPicker$1, [{
	    key: "insertTo",
	    value: function insertTo(container) {
	      if (this.hammer !== undefined) {
	        this.hammer.destroy();
	        this.hammer = undefined;
	      }

	      this.container = container;
	      this.container.appendChild(this.frame);

	      this._bindHammer();

	      this._setSize();
	    }
	    /**
	     * the callback is executed on apply and save. Bind it to the application
	     *
	     * @param {Function} callback
	     */

	  }, {
	    key: "setUpdateCallback",
	    value: function setUpdateCallback(callback) {
	      if (typeof callback === "function") {
	        this.updateCallback = callback;
	      } else {
	        throw new Error("Function attempted to set as colorPicker update callback is not a function.");
	      }
	    }
	    /**
	     * the callback is executed on apply and save. Bind it to the application
	     *
	     * @param {Function} callback
	     */

	  }, {
	    key: "setCloseCallback",
	    value: function setCloseCallback(callback) {
	      if (typeof callback === "function") {
	        this.closeCallback = callback;
	      } else {
	        throw new Error("Function attempted to set as colorPicker closing callback is not a function.");
	      }
	    }
	    /**
	     *
	     * @param {string} color
	     * @returns {string}
	     * @private
	     */

	  }, {
	    key: "_isColorString",
	    value: function _isColorString(color) {
	      if (typeof color === "string") {
	        return htmlColors$1[color];
	      }
	    }
	    /**
	     * Set the color of the colorPicker
	     * Supported formats:
	     * 'red'                   --> HTML color string
	     * '#ffffff'               --> hex string
	     * 'rgb(255,255,255)'      --> rgb string
	     * 'rgba(255,255,255,1.0)' --> rgba string
	     * {r:255,g:255,b:255}     --> rgb object
	     * {r:255,g:255,b:255,a:1.0} --> rgba object
	     *
	     * @param {string | object} color
	     * @param {boolean} [setInitial=true]
	     */

	  }, {
	    key: "setColor",
	    value: function setColor(color) {
	      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	      if (color === "none") {
	        return;
	      }

	      var rgba; // if a html color shorthand is used, convert to hex

	      var htmlColor = this._isColorString(color);

	      if (htmlColor !== undefined) {
	        color = htmlColor;
	      } // check format


	      if (isString(color) === true) {
	        if (isValidRGB(color) === true) {
	          var rgbaArray = color.substr(4).substr(0, color.length - 5).split(",");
	          rgba = {
	            r: rgbaArray[0],
	            g: rgbaArray[1],
	            b: rgbaArray[2],
	            a: 1.0
	          };
	        } else if (isValidRGBA(color) === true) {
	          var _rgbaArray = color.substr(5).substr(0, color.length - 6).split(",");

	          rgba = {
	            r: _rgbaArray[0],
	            g: _rgbaArray[1],
	            b: _rgbaArray[2],
	            a: _rgbaArray[3]
	          };
	        } else if (isValidHex(color) === true) {
	          var rgbObj = hexToRGB(color);
	          rgba = {
	            r: rgbObj.r,
	            g: rgbObj.g,
	            b: rgbObj.b,
	            a: 1.0
	          };
	        }
	      } else {
	        if (color instanceof Object) {
	          if (color.r !== undefined && color.g !== undefined && color.b !== undefined) {
	            var alpha = color.a !== undefined ? color.a : "1.0";
	            rgba = {
	              r: color.r,
	              g: color.g,
	              b: color.b,
	              a: alpha
	            };
	          }
	        }
	      } // set color


	      if (rgba === undefined) {
	        throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: " + _JSON$stringify(color));
	      } else {
	        this._setColor(rgba, setInitial);
	      }
	    }
	    /**
	     * this shows the color picker.
	     * The hue circle is constructed once and stored.
	     */

	  }, {
	    key: "show",
	    value: function show() {
	      if (this.closeCallback !== undefined) {
	        this.closeCallback();
	        this.closeCallback = undefined;
	      }

	      this.applied = false;
	      this.frame.style.display = "block";

	      this._generateHueCircle();
	    } // ------------------------------------------ PRIVATE ----------------------------- //

	    /**
	     * Hide the picker. Is called by the cancel button.
	     * Optional boolean to store the previous color for easy access later on.
	     *
	     * @param {boolean} [storePrevious=true]
	     * @private
	     */

	  }, {
	    key: "_hide",
	    value: function _hide() {
	      var _this2 = this;

	      var storePrevious = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

	      // store the previous color for next time;
	      if (storePrevious === true) {
	        this.previousColor = _Object$assign({}, this.color);
	      }

	      if (this.applied === true) {
	        this.updateCallback(this.initialColor);
	      }

	      this.frame.style.display = "none"; // call the closing callback, restoring the onclick method.
	      // this is in a setTimeout because it will trigger the show again before the click is done.

	      _setTimeout(function () {
	        if (_this2.closeCallback !== undefined) {
	          _this2.closeCallback();

	          _this2.closeCallback = undefined;
	        }
	      }, 0);
	    }
	    /**
	     * bound to the save button. Saves and hides.
	     *
	     * @private
	     */

	  }, {
	    key: "_save",
	    value: function _save() {
	      this.updateCallback(this.color);
	      this.applied = false;

	      this._hide();
	    }
	    /**
	     * Bound to apply button. Saves but does not close. Is undone by the cancel button.
	     *
	     * @private
	     */

	  }, {
	    key: "_apply",
	    value: function _apply() {
	      this.applied = true;
	      this.updateCallback(this.color);

	      this._updatePicker(this.color);
	    }
	    /**
	     * load the color from the previous session.
	     *
	     * @private
	     */

	  }, {
	    key: "_loadLast",
	    value: function _loadLast() {
	      if (this.previousColor !== undefined) {
	        this.setColor(this.previousColor, false);
	      } else {
	        alert("There is no last color to load...");
	      }
	    }
	    /**
	     * set the color, place the picker
	     *
	     * @param {object} rgba
	     * @param {boolean} [setInitial=true]
	     * @private
	     */

	  }, {
	    key: "_setColor",
	    value: function _setColor(rgba) {
	      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	      // store the initial color
	      if (setInitial === true) {
	        this.initialColor = _Object$assign({}, rgba);
	      }

	      this.color = rgba;
	      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
	      var angleConvert = 2 * Math.PI;
	      var radius = this.r * hsv.s;
	      var x = this.centerCoordinates.x + radius * Math.sin(angleConvert * hsv.h);
	      var y = this.centerCoordinates.y + radius * Math.cos(angleConvert * hsv.h);
	      this.colorPickerSelector.style.left = x - 0.5 * this.colorPickerSelector.clientWidth + "px";
	      this.colorPickerSelector.style.top = y - 0.5 * this.colorPickerSelector.clientHeight + "px";

	      this._updatePicker(rgba);
	    }
	    /**
	     * bound to opacity control
	     *
	     * @param {number} value
	     * @private
	     */

	  }, {
	    key: "_setOpacity",
	    value: function _setOpacity(value) {
	      this.color.a = value / 100;

	      this._updatePicker(this.color);
	    }
	    /**
	     * bound to brightness control
	     *
	     * @param {number} value
	     * @private
	     */

	  }, {
	    key: "_setBrightness",
	    value: function _setBrightness(value) {
	      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
	      hsv.v = value / 100;
	      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
	      rgba["a"] = this.color.a;
	      this.color = rgba;

	      this._updatePicker();
	    }
	    /**
	     * update the color picker. A black circle overlays the hue circle to mimic the brightness decreasing.
	     *
	     * @param {object} rgba
	     * @private
	     */

	  }, {
	    key: "_updatePicker",
	    value: function _updatePicker() {
	      var rgba = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.color;
	      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
	      var ctx = this.colorPickerCanvas.getContext("2d");

	      if (this.pixelRation === undefined) {
	        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	      }

	      ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0); // clear the canvas

	      var w = this.colorPickerCanvas.clientWidth;
	      var h = this.colorPickerCanvas.clientHeight;
	      ctx.clearRect(0, 0, w, h);
	      ctx.putImageData(this.hueCircle, 0, 0);
	      ctx.fillStyle = "rgba(0,0,0," + (1 - hsv.v) + ")";
	      ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);

	      _fillInstanceProperty(ctx).call(ctx);

	      this.brightnessRange.value = 100 * hsv.v;
	      this.opacityRange.value = 100 * rgba.a;
	      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
	      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
	    }
	    /**
	     * used by create to set the size of the canvas.
	     *
	     * @private
	     */

	  }, {
	    key: "_setSize",
	    value: function _setSize() {
	      this.colorPickerCanvas.style.width = "100%";
	      this.colorPickerCanvas.style.height = "100%";
	      this.colorPickerCanvas.width = 289 * this.pixelRatio;
	      this.colorPickerCanvas.height = 289 * this.pixelRatio;
	    }
	    /**
	     * create all dom elements
	     * TODO: cleanup, lots of similar dom elements
	     *
	     * @private
	     */

	  }, {
	    key: "_create",
	    value: function _create() {
	      var _context16, _context17, _context18, _context19;

	      this.frame = document.createElement("div");
	      this.frame.className = "vis-color-picker";
	      this.colorPickerDiv = document.createElement("div");
	      this.colorPickerSelector = document.createElement("div");
	      this.colorPickerSelector.className = "vis-selector";
	      this.colorPickerDiv.appendChild(this.colorPickerSelector);
	      this.colorPickerCanvas = document.createElement("canvas");
	      this.colorPickerDiv.appendChild(this.colorPickerCanvas);

	      if (!this.colorPickerCanvas.getContext) {
	        var noCanvas = document.createElement("DIV");
	        noCanvas.style.color = "red";
	        noCanvas.style.fontWeight = "bold";
	        noCanvas.style.padding = "10px";
	        noCanvas.innerText = "Error: your browser does not support HTML canvas";
	        this.colorPickerCanvas.appendChild(noCanvas);
	      } else {
	        var ctx = this.colorPickerCanvas.getContext("2d");
	        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	        this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
	      }

	      this.colorPickerDiv.className = "vis-color";
	      this.opacityDiv = document.createElement("div");
	      this.opacityDiv.className = "vis-opacity";
	      this.brightnessDiv = document.createElement("div");
	      this.brightnessDiv.className = "vis-brightness";
	      this.arrowDiv = document.createElement("div");
	      this.arrowDiv.className = "vis-arrow";
	      this.opacityRange = document.createElement("input");

	      try {
	        this.opacityRange.type = "range"; // Not supported on IE9

	        this.opacityRange.min = "0";
	        this.opacityRange.max = "100";
	      } catch (err) {// TODO: Add some error handling.
	      }

	      this.opacityRange.value = "100";
	      this.opacityRange.className = "vis-range";
	      this.brightnessRange = document.createElement("input");

	      try {
	        this.brightnessRange.type = "range"; // Not supported on IE9

	        this.brightnessRange.min = "0";
	        this.brightnessRange.max = "100";
	      } catch (err) {// TODO: Add some error handling.
	      }

	      this.brightnessRange.value = "100";
	      this.brightnessRange.className = "vis-range";
	      this.opacityDiv.appendChild(this.opacityRange);
	      this.brightnessDiv.appendChild(this.brightnessRange);
	      var me = this;

	      this.opacityRange.onchange = function () {
	        me._setOpacity(this.value);
	      };

	      this.opacityRange.oninput = function () {
	        me._setOpacity(this.value);
	      };

	      this.brightnessRange.onchange = function () {
	        me._setBrightness(this.value);
	      };

	      this.brightnessRange.oninput = function () {
	        me._setBrightness(this.value);
	      };

	      this.brightnessLabel = document.createElement("div");
	      this.brightnessLabel.className = "vis-label vis-brightness";
	      this.brightnessLabel.innerText = "brightness:";
	      this.opacityLabel = document.createElement("div");
	      this.opacityLabel.className = "vis-label vis-opacity";
	      this.opacityLabel.innerText = "opacity:";
	      this.newColorDiv = document.createElement("div");
	      this.newColorDiv.className = "vis-new-color";
	      this.newColorDiv.innerText = "new";
	      this.initialColorDiv = document.createElement("div");
	      this.initialColorDiv.className = "vis-initial-color";
	      this.initialColorDiv.innerText = "initial";
	      this.cancelButton = document.createElement("div");
	      this.cancelButton.className = "vis-button vis-cancel";
	      this.cancelButton.innerText = "cancel";
	      this.cancelButton.onclick = _bindInstanceProperty$1(_context16 = this._hide).call(_context16, this, false);
	      this.applyButton = document.createElement("div");
	      this.applyButton.className = "vis-button vis-apply";
	      this.applyButton.innerText = "apply";
	      this.applyButton.onclick = _bindInstanceProperty$1(_context17 = this._apply).call(_context17, this);
	      this.saveButton = document.createElement("div");
	      this.saveButton.className = "vis-button vis-save";
	      this.saveButton.innerText = "save";
	      this.saveButton.onclick = _bindInstanceProperty$1(_context18 = this._save).call(_context18, this);
	      this.loadButton = document.createElement("div");
	      this.loadButton.className = "vis-button vis-load";
	      this.loadButton.innerText = "load last";
	      this.loadButton.onclick = _bindInstanceProperty$1(_context19 = this._loadLast).call(_context19, this);
	      this.frame.appendChild(this.colorPickerDiv);
	      this.frame.appendChild(this.arrowDiv);
	      this.frame.appendChild(this.brightnessLabel);
	      this.frame.appendChild(this.brightnessDiv);
	      this.frame.appendChild(this.opacityLabel);
	      this.frame.appendChild(this.opacityDiv);
	      this.frame.appendChild(this.newColorDiv);
	      this.frame.appendChild(this.initialColorDiv);
	      this.frame.appendChild(this.cancelButton);
	      this.frame.appendChild(this.applyButton);
	      this.frame.appendChild(this.saveButton);
	      this.frame.appendChild(this.loadButton);
	    }
	    /**
	     * bind hammer to the color picker
	     *
	     * @private
	     */

	  }, {
	    key: "_bindHammer",
	    value: function _bindHammer() {
	      var _this3 = this;

	      this.drag = {};
	      this.pinch = {};
	      this.hammer = new Hammer$1(this.colorPickerCanvas);
	      this.hammer.get("pinch").set({
	        enable: true
	      });
	      this.hammer.on("hammer.input", function (event) {
	        if (event.isFirst) {
	          _this3._moveSelector(event);
	        }
	      });
	      this.hammer.on("tap", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panstart", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panmove", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panend", function (event) {
	        _this3._moveSelector(event);
	      });
	    }
	    /**
	     * generate the hue circle. This is relatively heavy (200ms) and is done only once on the first time it is shown.
	     *
	     * @private
	     */

	  }, {
	    key: "_generateHueCircle",
	    value: function _generateHueCircle() {
	      if (this.generated === false) {
	        var ctx = this.colorPickerCanvas.getContext("2d");

	        if (this.pixelRation === undefined) {
	          this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	        }

	        ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0); // clear the canvas

	        var w = this.colorPickerCanvas.clientWidth;
	        var h = this.colorPickerCanvas.clientHeight;
	        ctx.clearRect(0, 0, w, h); // draw hue circle

	        var x, y, hue, sat;
	        this.centerCoordinates = {
	          x: w * 0.5,
	          y: h * 0.5
	        };
	        this.r = 0.49 * w;
	        var angleConvert = 2 * Math.PI / 360;
	        var hfac = 1 / 360;
	        var sfac = 1 / this.r;
	        var rgb;

	        for (hue = 0; hue < 360; hue++) {
	          for (sat = 0; sat < this.r; sat++) {
	            x = this.centerCoordinates.x + sat * Math.sin(angleConvert * hue);
	            y = this.centerCoordinates.y + sat * Math.cos(angleConvert * hue);
	            rgb = HSVToRGB(hue * hfac, sat * sfac, 1);
	            ctx.fillStyle = "rgb(" + rgb.r + "," + rgb.g + "," + rgb.b + ")";
	            ctx.fillRect(x - 0.5, y - 0.5, 2, 2);
	          }
	        }

	        ctx.strokeStyle = "rgba(0,0,0,1)";
	        ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
	        ctx.stroke();
	        this.hueCircle = ctx.getImageData(0, 0, w, h);
	      }

	      this.generated = true;
	    }
	    /**
	     * move the selector. This is called by hammer functions.
	     *
	     * @param {Event}  event   The event
	     * @private
	     */

	  }, {
	    key: "_moveSelector",
	    value: function _moveSelector(event) {
	      var rect = this.colorPickerDiv.getBoundingClientRect();
	      var left = event.center.x - rect.left;
	      var top = event.center.y - rect.top;
	      var centerY = 0.5 * this.colorPickerDiv.clientHeight;
	      var centerX = 0.5 * this.colorPickerDiv.clientWidth;
	      var x = left - centerX;
	      var y = top - centerY;
	      var angle = Math.atan2(x, y);
	      var radius = 0.98 * Math.min(Math.sqrt(x * x + y * y), centerX);
	      var newTop = Math.cos(angle) * radius + centerY;
	      var newLeft = Math.sin(angle) * radius + centerX;
	      this.colorPickerSelector.style.top = newTop - 0.5 * this.colorPickerSelector.clientHeight + "px";
	      this.colorPickerSelector.style.left = newLeft - 0.5 * this.colorPickerSelector.clientWidth + "px"; // set color

	      var h = angle / (2 * Math.PI);
	      h = h < 0 ? h + 1 : h;
	      var s = radius / this.r;
	      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
	      hsv.h = h;
	      hsv.s = s;
	      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
	      rgba["a"] = this.color.a;
	      this.color = rgba; // update previews

	      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
	      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
	    }
	  }]);

	  return ColorPicker$1;
	}();
	/**
	 * Wrap given text (last argument) in HTML elements (all preceding arguments).
	 *
	 * @param {...any} rest - List of tag names followed by inner text.
	 * @returns An element or a text node.
	 */


	function wrapInTag() {
	  for (var _len5 = arguments.length, rest = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
	    rest[_key5] = arguments[_key5];
	  }

	  if (rest.length < 1) {
	    throw new TypeError("Invalid arguments.");
	  } else if (rest.length === 1) {
	    return document.createTextNode(rest[0]);
	  } else {
	    var element = document.createElement(rest[0]);
	    element.appendChild(wrapInTag.apply(void 0, _toConsumableArray(_sliceInstanceProperty(rest).call(rest, 1))));
	    return element;
	  }
	}
	/**
	 * The way this works is for all properties of this.possible options, you can supply the property name in any form to list the options.
	 * Boolean options are recognised as Boolean
	 * Number options should be written as array: [default value, min value, max value, stepsize]
	 * Colors should be written as array: ['color', '#ffffff']
	 * Strings with should be written as array: [option1, option2, option3, ..]
	 *
	 * The options are matched with their counterparts in each of the modules and the values used in the configuration are
	 */


	var Configurator$1 = /*#__PURE__*/function () {
	  /**
	   * @param {object} parentModule        | the location where parentModule.setOptions() can be called
	   * @param {object} defaultContainer    | the default container of the module
	   * @param {object} configureOptions    | the fully configured and predefined options set found in allOptions.js
	   * @param {number} pixelRatio          | canvas pixel ratio
	   * @param {Function} hideOption        | custom logic to dynamically hide options
	   */
	  function Configurator$1(parentModule, defaultContainer, configureOptions) {
	    var pixelRatio = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
	    var hideOption = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : function () {
	      return false;
	    };

	    _classCallCheck(this, Configurator$1);

	    this.parent = parentModule;
	    this.changedOptions = [];
	    this.container = defaultContainer;
	    this.allowCreation = false;
	    this.hideOption = hideOption;
	    this.options = {};
	    this.initialized = false;
	    this.popupCounter = 0;
	    this.defaultOptions = {
	      enabled: false,
	      filter: true,
	      container: undefined,
	      showButton: true
	    };

	    _Object$assign(this.options, this.defaultOptions);

	    this.configureOptions = configureOptions;
	    this.moduleOptions = {};
	    this.domElements = [];
	    this.popupDiv = {};
	    this.popupLimit = 5;
	    this.popupHistory = {};
	    this.colorPicker = new ColorPicker$1(pixelRatio);
	    this.wrapper = undefined;
	  }
	  /**
	   * refresh all options.
	   * Because all modules parse their options by themselves, we just use their options. We copy them here.
	   *
	   * @param {object} options
	   */


	  _createClass(Configurator$1, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        // reset the popup history because the indices may have been changed.
	        this.popupHistory = {};

	        this._removePopup();

	        var enabled = true;

	        if (typeof options === "string") {
	          this.options.filter = options;
	        } else if (_Array$isArray(options)) {
	          this.options.filter = options.join();
	        } else if (_typeof$1(options) === "object") {
	          if (options == null) {
	            throw new TypeError("options cannot be null");
	          }

	          if (options.container !== undefined) {
	            this.options.container = options.container;
	          }

	          if (_filterInstanceProperty(options) !== undefined) {
	            this.options.filter = _filterInstanceProperty(options);
	          }

	          if (options.showButton !== undefined) {
	            this.options.showButton = options.showButton;
	          }

	          if (options.enabled !== undefined) {
	            enabled = options.enabled;
	          }
	        } else if (typeof options === "boolean") {
	          this.options.filter = true;
	          enabled = options;
	        } else if (typeof options === "function") {
	          this.options.filter = options;
	          enabled = true;
	        }

	        if (_filterInstanceProperty(this.options) === false) {
	          enabled = false;
	        }

	        this.options.enabled = enabled;
	      }

	      this._clean();
	    }
	    /**
	     *
	     * @param {object} moduleOptions
	     */

	  }, {
	    key: "setModuleOptions",
	    value: function setModuleOptions(moduleOptions) {
	      this.moduleOptions = moduleOptions;

	      if (this.options.enabled === true) {
	        this._clean();

	        if (this.options.container !== undefined) {
	          this.container = this.options.container;
	        }

	        this._create();
	      }
	    }
	    /**
	     * Create all DOM elements
	     *
	     * @private
	     */

	  }, {
	    key: "_create",
	    value: function _create() {
	      this._clean();

	      this.changedOptions = [];

	      var filter = _filterInstanceProperty(this.options);

	      var counter = 0;
	      var show = false;

	      for (var _option in this.configureOptions) {
	        if (Object.prototype.hasOwnProperty.call(this.configureOptions, _option)) {
	          this.allowCreation = false;
	          show = false;

	          if (typeof filter === "function") {
	            show = filter(_option, []);
	            show = show || this._handleObject(this.configureOptions[_option], [_option], true);
	          } else if (filter === true || _indexOfInstanceProperty(filter).call(filter, _option) !== -1) {
	            show = true;
	          }

	          if (show !== false) {
	            this.allowCreation = true; // linebreak between categories

	            if (counter > 0) {
	              this._makeItem([]);
	            } // a header for the category


	            this._makeHeader(_option); // get the sub options


	            this._handleObject(this.configureOptions[_option], [_option]);
	          }

	          counter++;
	        }
	      }

	      this._makeButton();

	      this._push(); //~ this.colorPicker.insertTo(this.container);

	    }
	    /**
	     * draw all DOM elements on the screen
	     *
	     * @private
	     */

	  }, {
	    key: "_push",
	    value: function _push() {
	      this.wrapper = document.createElement("div");
	      this.wrapper.className = "vis-configuration-wrapper";
	      this.container.appendChild(this.wrapper);

	      for (var i = 0; i < this.domElements.length; i++) {
	        this.wrapper.appendChild(this.domElements[i]);
	      }

	      this._showPopupIfNeeded();
	    }
	    /**
	     * delete all DOM elements
	     *
	     * @private
	     */

	  }, {
	    key: "_clean",
	    value: function _clean() {
	      for (var i = 0; i < this.domElements.length; i++) {
	        this.wrapper.removeChild(this.domElements[i]);
	      }

	      if (this.wrapper !== undefined) {
	        this.container.removeChild(this.wrapper);
	        this.wrapper = undefined;
	      }

	      this.domElements = [];

	      this._removePopup();
	    }
	    /**
	     * get the value from the actualOptions if it exists
	     *
	     * @param {Array} path    | where to look for the actual option
	     * @returns {*}
	     * @private
	     */

	  }, {
	    key: "_getValue",
	    value: function _getValue(path) {
	      var base = this.moduleOptions;

	      for (var i = 0; i < path.length; i++) {
	        if (base[path[i]] !== undefined) {
	          base = base[path[i]];
	        } else {
	          base = undefined;
	          break;
	        }
	      }

	      return base;
	    }
	    /**
	     * all option elements are wrapped in an item
	     *
	     * @param {Array} path    | where to look for the actual option
	     * @param {Array.<Element>} domElements
	     * @returns {number}
	     * @private
	     */

	  }, {
	    key: "_makeItem",
	    value: function _makeItem(path) {
	      if (this.allowCreation === true) {
	        var item = document.createElement("div");
	        item.className = "vis-configuration vis-config-item vis-config-s" + path.length;

	        for (var _len6 = arguments.length, domElements = new Array(_len6 > 1 ? _len6 - 1 : 0), _key6 = 1; _key6 < _len6; _key6++) {
	          domElements[_key6 - 1] = arguments[_key6];
	        }

	        _forEachInstanceProperty(domElements).call(domElements, function (element) {
	          item.appendChild(element);
	        });

	        this.domElements.push(item);
	        return this.domElements.length;
	      }

	      return 0;
	    }
	    /**
	     * header for major subjects
	     *
	     * @param {string} name
	     * @private
	     */

	  }, {
	    key: "_makeHeader",
	    value: function _makeHeader(name) {
	      var div = document.createElement("div");
	      div.className = "vis-configuration vis-config-header";
	      div.innerText = name;

	      this._makeItem([], div);
	    }
	    /**
	     * make a label, if it is an object label, it gets different styling.
	     *
	     * @param {string} name
	     * @param {Array} path    | where to look for the actual option
	     * @param {string} objectLabel
	     * @returns {HTMLElement}
	     * @private
	     */

	  }, {
	    key: "_makeLabel",
	    value: function _makeLabel(name, path) {
	      var objectLabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var div = document.createElement("div");
	      div.className = "vis-configuration vis-config-label vis-config-s" + path.length;

	      if (objectLabel === true) {
	        while (div.firstChild) {
	          div.removeChild(div.firstChild);
	        }

	        div.appendChild(wrapInTag("i", "b", name));
	      } else {
	        div.innerText = name + ":";
	      }

	      return div;
	    }
	    /**
	     * make a dropdown list for multiple possible string optoins
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_makeDropdown",
	    value: function _makeDropdown(arr, value, path) {
	      var select = document.createElement("select");
	      select.className = "vis-configuration vis-config-select";
	      var selectedValue = 0;

	      if (value !== undefined) {
	        if (_indexOfInstanceProperty(arr).call(arr, value) !== -1) {
	          selectedValue = _indexOfInstanceProperty(arr).call(arr, value);
	        }
	      }

	      for (var i = 0; i < arr.length; i++) {
	        var _option2 = document.createElement("option");

	        _option2.value = arr[i];

	        if (i === selectedValue) {
	          _option2.selected = "selected";
	        }

	        _option2.innerText = arr[i];
	        select.appendChild(_option2);
	      }

	      var me = this;

	      select.onchange = function () {
	        me._update(this.value, path);
	      };

	      var label = this._makeLabel(path[path.length - 1], path);

	      this._makeItem(path, label, select);
	    }
	    /**
	     * make a range object for numeric options
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_makeRange",
	    value: function _makeRange(arr, value, path) {
	      var defaultValue = arr[0];
	      var min = arr[1];
	      var max = arr[2];
	      var step = arr[3];
	      var range = document.createElement("input");
	      range.className = "vis-configuration vis-config-range";

	      try {
	        range.type = "range"; // not supported on IE9

	        range.min = min;
	        range.max = max;
	      } catch (err) {// TODO: Add some error handling.
	      }

	      range.step = step; // set up the popup settings in case they are needed.

	      var popupString = "";
	      var popupValue = 0;

	      if (value !== undefined) {
	        var factor = 1.2;

	        if (value < 0 && value * factor < min) {
	          range.min = Math.ceil(value * factor);
	          popupValue = range.min;
	          popupString = "range increased";
	        } else if (value / factor < min) {
	          range.min = Math.ceil(value / factor);
	          popupValue = range.min;
	          popupString = "range increased";
	        }

	        if (value * factor > max && max !== 1) {
	          range.max = Math.ceil(value * factor);
	          popupValue = range.max;
	          popupString = "range increased";
	        }

	        range.value = value;
	      } else {
	        range.value = defaultValue;
	      }

	      var input = document.createElement("input");
	      input.className = "vis-configuration vis-config-rangeinput";
	      input.value = range.value;
	      var me = this;

	      range.onchange = function () {
	        input.value = this.value;

	        me._update(Number(this.value), path);
	      };

	      range.oninput = function () {
	        input.value = this.value;
	      };

	      var label = this._makeLabel(path[path.length - 1], path);

	      var itemIndex = this._makeItem(path, label, range, input); // if a popup is needed AND it has not been shown for this value, show it.


	      if (popupString !== "" && this.popupHistory[itemIndex] !== popupValue) {
	        this.popupHistory[itemIndex] = popupValue;

	        this._setupPopup(popupString, itemIndex);
	      }
	    }
	    /**
	     * make a button object
	     *
	     * @private
	     */

	  }, {
	    key: "_makeButton",
	    value: function _makeButton() {
	      var _this4 = this;

	      if (this.options.showButton === true) {
	        var generateButton = document.createElement("div");
	        generateButton.className = "vis-configuration vis-config-button";
	        generateButton.innerText = "generate options";

	        generateButton.onclick = function () {
	          _this4._printOptions();
	        };

	        generateButton.onmouseover = function () {
	          generateButton.className = "vis-configuration vis-config-button hover";
	        };

	        generateButton.onmouseout = function () {
	          generateButton.className = "vis-configuration vis-config-button";
	        };

	        this.optionsContainer = document.createElement("div");
	        this.optionsContainer.className = "vis-configuration vis-config-option-container";
	        this.domElements.push(this.optionsContainer);
	        this.domElements.push(generateButton);
	      }
	    }
	    /**
	     * prepare the popup
	     *
	     * @param {string} string
	     * @param {number} index
	     * @private
	     */

	  }, {
	    key: "_setupPopup",
	    value: function _setupPopup(string, index) {
	      var _this5 = this;

	      if (this.initialized === true && this.allowCreation === true && this.popupCounter < this.popupLimit) {
	        var div = document.createElement("div");
	        div.id = "vis-configuration-popup";
	        div.className = "vis-configuration-popup";
	        div.innerText = string;

	        div.onclick = function () {
	          _this5._removePopup();
	        };

	        this.popupCounter += 1;
	        this.popupDiv = {
	          html: div,
	          index: index
	        };
	      }
	    }
	    /**
	     * remove the popup from the dom
	     *
	     * @private
	     */

	  }, {
	    key: "_removePopup",
	    value: function _removePopup() {
	      if (this.popupDiv.html !== undefined) {
	        this.popupDiv.html.parentNode.removeChild(this.popupDiv.html);
	        clearTimeout(this.popupDiv.hideTimeout);
	        clearTimeout(this.popupDiv.deleteTimeout);
	        this.popupDiv = {};
	      }
	    }
	    /**
	     * Show the popup if it is needed.
	     *
	     * @private
	     */

	  }, {
	    key: "_showPopupIfNeeded",
	    value: function _showPopupIfNeeded() {
	      var _this6 = this;

	      if (this.popupDiv.html !== undefined) {
	        var correspondingElement = this.domElements[this.popupDiv.index];
	        var rect = correspondingElement.getBoundingClientRect();
	        this.popupDiv.html.style.left = rect.left + "px";
	        this.popupDiv.html.style.top = rect.top - 30 + "px"; // 30 is the height;

	        document.body.appendChild(this.popupDiv.html);
	        this.popupDiv.hideTimeout = _setTimeout(function () {
	          _this6.popupDiv.html.style.opacity = 0;
	        }, 1500);
	        this.popupDiv.deleteTimeout = _setTimeout(function () {
	          _this6._removePopup();
	        }, 1800);
	      }
	    }
	    /**
	     * make a checkbox for boolean options.
	     *
	     * @param {number} defaultValue
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_makeCheckbox",
	    value: function _makeCheckbox(defaultValue, value, path) {
	      var checkbox = document.createElement("input");
	      checkbox.type = "checkbox";
	      checkbox.className = "vis-configuration vis-config-checkbox";
	      checkbox.checked = defaultValue;

	      if (value !== undefined) {
	        checkbox.checked = value;

	        if (value !== defaultValue) {
	          if (_typeof$1(defaultValue) === "object") {
	            if (value !== defaultValue.enabled) {
	              this.changedOptions.push({
	                path: path,
	                value: value
	              });
	            }
	          } else {
	            this.changedOptions.push({
	              path: path,
	              value: value
	            });
	          }
	        }
	      }

	      var me = this;

	      checkbox.onchange = function () {
	        me._update(this.checked, path);
	      };

	      var label = this._makeLabel(path[path.length - 1], path);

	      this._makeItem(path, label, checkbox);
	    }
	    /**
	     * make a text input field for string options.
	     *
	     * @param {number} defaultValue
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_makeTextInput",
	    value: function _makeTextInput(defaultValue, value, path) {
	      var checkbox = document.createElement("input");
	      checkbox.type = "text";
	      checkbox.className = "vis-configuration vis-config-text";
	      checkbox.value = value;

	      if (value !== defaultValue) {
	        this.changedOptions.push({
	          path: path,
	          value: value
	        });
	      }

	      var me = this;

	      checkbox.onchange = function () {
	        me._update(this.value, path);
	      };

	      var label = this._makeLabel(path[path.length - 1], path);

	      this._makeItem(path, label, checkbox);
	    }
	    /**
	     * make a color field with a color picker for color fields
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_makeColorField",
	    value: function _makeColorField(arr, value, path) {
	      var _this7 = this;

	      var defaultColor = arr[1];
	      var div = document.createElement("div");
	      value = value === undefined ? defaultColor : value;

	      if (value !== "none") {
	        div.className = "vis-configuration vis-config-colorBlock";
	        div.style.backgroundColor = value;
	      } else {
	        div.className = "vis-configuration vis-config-colorBlock none";
	      }

	      value = value === undefined ? defaultColor : value;

	      div.onclick = function () {
	        _this7._showColorPicker(value, div, path);
	      };

	      var label = this._makeLabel(path[path.length - 1], path);

	      this._makeItem(path, label, div);
	    }
	    /**
	     * used by the color buttons to call the color picker.
	     *
	     * @param {number} value
	     * @param {HTMLElement} div
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_showColorPicker",
	    value: function _showColorPicker(value, div, path) {
	      var _this8 = this;

	      // clear the callback from this div
	      div.onclick = function () {};

	      this.colorPicker.insertTo(div);
	      this.colorPicker.show();
	      this.colorPicker.setColor(value);
	      this.colorPicker.setUpdateCallback(function (color) {
	        var colorString = "rgba(" + color.r + "," + color.g + "," + color.b + "," + color.a + ")";
	        div.style.backgroundColor = colorString;

	        _this8._update(colorString, path);
	      }); // on close of the colorpicker, restore the callback.

	      this.colorPicker.setCloseCallback(function () {
	        div.onclick = function () {
	          _this8._showColorPicker(value, div, path);
	        };
	      });
	    }
	    /**
	     * parse an object and draw the correct items
	     *
	     * @param {object} obj
	     * @param {Array} [path=[]]    | where to look for the actual option
	     * @param {boolean} [checkOnly=false]
	     * @returns {boolean}
	     * @private
	     */

	  }, {
	    key: "_handleObject",
	    value: function _handleObject(obj) {
	      var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
	      var checkOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var show = false;

	      var filter = _filterInstanceProperty(this.options);

	      var visibleInSet = false;

	      for (var subObj in obj) {
	        if (Object.prototype.hasOwnProperty.call(obj, subObj)) {
	          show = true;
	          var item = obj[subObj];
	          var newPath = copyAndExtendArray(path, subObj);

	          if (typeof filter === "function") {
	            show = filter(subObj, path); // if needed we must go deeper into the object.

	            if (show === false) {
	              if (!_Array$isArray(item) && typeof item !== "string" && typeof item !== "boolean" && item instanceof Object) {
	                this.allowCreation = false;
	                show = this._handleObject(item, newPath, true);
	                this.allowCreation = checkOnly === false;
	              }
	            }
	          }

	          if (show !== false) {
	            visibleInSet = true;

	            var value = this._getValue(newPath);

	            if (_Array$isArray(item)) {
	              this._handleArray(item, value, newPath);
	            } else if (typeof item === "string") {
	              this._makeTextInput(item, value, newPath);
	            } else if (typeof item === "boolean") {
	              this._makeCheckbox(item, value, newPath);
	            } else if (item instanceof Object) {
	              // skip the options that are not enabled
	              if (!this.hideOption(path, subObj, this.moduleOptions)) {
	                // initially collapse options with an disabled enabled option.
	                if (item.enabled !== undefined) {
	                  var enabledPath = copyAndExtendArray(newPath, "enabled");

	                  var enabledValue = this._getValue(enabledPath);

	                  if (enabledValue === true) {
	                    var label = this._makeLabel(subObj, newPath, true);

	                    this._makeItem(newPath, label);

	                    visibleInSet = this._handleObject(item, newPath) || visibleInSet;
	                  } else {
	                    this._makeCheckbox(item, enabledValue, newPath);
	                  }
	                } else {
	                  var _label = this._makeLabel(subObj, newPath, true);

	                  this._makeItem(newPath, _label);

	                  visibleInSet = this._handleObject(item, newPath) || visibleInSet;
	                }
	              }
	            } else {
	              console.error("dont know how to handle", item, subObj, newPath);
	            }
	          }
	        }
	      }

	      return visibleInSet;
	    }
	    /**
	     * handle the array type of option
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_handleArray",
	    value: function _handleArray(arr, value, path) {
	      if (typeof arr[0] === "string" && arr[0] === "color") {
	        this._makeColorField(arr, value, path);

	        if (arr[1] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: value
	          });
	        }
	      } else if (typeof arr[0] === "string") {
	        this._makeDropdown(arr, value, path);

	        if (arr[0] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: value
	          });
	        }
	      } else if (typeof arr[0] === "number") {
	        this._makeRange(arr, value, path);

	        if (arr[0] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: Number(value)
	          });
	        }
	      }
	    }
	    /**
	     * called to update the network with the new settings.
	     *
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */

	  }, {
	    key: "_update",
	    value: function _update(value, path) {
	      var options = this._constructOptions(value, path);

	      if (this.parent.body && this.parent.body.emitter && this.parent.body.emitter.emit) {
	        this.parent.body.emitter.emit("configChange", options);
	      }

	      this.initialized = true;
	      this.parent.setOptions(options);
	    }
	    /**
	     *
	     * @param {string | boolean} value
	     * @param {Array.<string>} path
	     * @param {{}} optionsObj
	     * @returns {{}}
	     * @private
	     */

	  }, {
	    key: "_constructOptions",
	    value: function _constructOptions(value, path) {
	      var optionsObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      var pointer = optionsObj; // when dropdown boxes can be string or boolean, we typecast it into correct types

	      value = value === "true" ? true : value;
	      value = value === "false" ? false : value;

	      for (var i = 0; i < path.length; i++) {
	        if (path[i] !== "global") {
	          if (pointer[path[i]] === undefined) {
	            pointer[path[i]] = {};
	          }

	          if (i !== path.length - 1) {
	            pointer = pointer[path[i]];
	          } else {
	            pointer[path[i]] = value;
	          }
	        }
	      }

	      return optionsObj;
	    }
	    /**
	     * @private
	     */

	  }, {
	    key: "_printOptions",
	    value: function _printOptions() {
	      var options = this.getOptions();

	      while (this.optionsContainer.firstChild) {
	        this.optionsContainer.removeChild(this.optionsContainer.firstChild);
	      }

	      this.optionsContainer.appendChild(wrapInTag("pre", "const options = " + _JSON$stringify(options, null, 2)));
	    }
	    /**
	     *
	     * @returns {{}} options
	     */

	  }, {
	    key: "getOptions",
	    value: function getOptions() {
	      var options = {};

	      for (var i = 0; i < this.changedOptions.length; i++) {
	        this._constructOptions(this.changedOptions[i].value, this.changedOptions[i].path, options);
	      }

	      return options;
	    }
	  }]);

	  return Configurator$1;
	}();
	/**
	 * Popup is a class to create a popup window with some text
	 */


	var Popup$1 = /*#__PURE__*/function () {
	  /**
	   * @param {Element} container       The container object.
	   * @param {string}  overflowMethod  How the popup should act to overflowing ('flip' or 'cap')
	   */
	  function Popup$1(container, overflowMethod) {
	    _classCallCheck(this, Popup$1);

	    this.container = container;
	    this.overflowMethod = overflowMethod || "cap";
	    this.x = 0;
	    this.y = 0;
	    this.padding = 5;
	    this.hidden = false; // create the frame

	    this.frame = document.createElement("div");
	    this.frame.className = "vis-tooltip";
	    this.container.appendChild(this.frame);
	  }
	  /**
	   * @param {number} x   Horizontal position of the popup window
	   * @param {number} y   Vertical position of the popup window
	   */


	  _createClass(Popup$1, [{
	    key: "setPosition",
	    value: function setPosition(x, y) {
	      this.x = _parseInt(x);
	      this.y = _parseInt(y);
	    }
	    /**
	     * Set the content for the popup window. This can be HTML code or text.
	     *
	     * @param {string | Element} content
	     */

	  }, {
	    key: "setText",
	    value: function setText(content) {
	      if (content instanceof Element) {
	        while (this.frame.firstChild) {
	          this.frame.removeChild(this.frame.firstChild);
	        }

	        this.frame.appendChild(content);
	      } else {
	        // String containing literal text, element has to be used for HTML due to
	        // XSS risks associated with innerHTML (i.e. prevent XSS by accident).
	        this.frame.innerText = content;
	      }
	    }
	    /**
	     * Show the popup window
	     *
	     * @param {boolean} [doShow]    Show or hide the window
	     */

	  }, {
	    key: "show",
	    value: function show(doShow) {
	      if (doShow === undefined) {
	        doShow = true;
	      }

	      if (doShow === true) {
	        var height = this.frame.clientHeight;
	        var width = this.frame.clientWidth;
	        var maxHeight = this.frame.parentNode.clientHeight;
	        var maxWidth = this.frame.parentNode.clientWidth;
	        var left = 0,
	            top = 0;

	        if (this.overflowMethod == "flip") {
	          var isLeft = false,
	              isTop = true; // Where around the position it's located

	          if (this.y - height < this.padding) {
	            isTop = false;
	          }

	          if (this.x + width > maxWidth - this.padding) {
	            isLeft = true;
	          }

	          if (isLeft) {
	            left = this.x - width;
	          } else {
	            left = this.x;
	          }

	          if (isTop) {
	            top = this.y - height;
	          } else {
	            top = this.y;
	          }
	        } else {
	          top = this.y - height;

	          if (top + height + this.padding > maxHeight) {
	            top = maxHeight - height - this.padding;
	          }

	          if (top < this.padding) {
	            top = this.padding;
	          }

	          left = this.x;

	          if (left + width + this.padding > maxWidth) {
	            left = maxWidth - width - this.padding;
	          }

	          if (left < this.padding) {
	            left = this.padding;
	          }
	        }

	        this.frame.style.left = left + "px";
	        this.frame.style.top = top + "px";
	        this.frame.style.visibility = "visible";
	        this.hidden = false;
	      } else {
	        this.hide();
	      }
	    }
	    /**
	     * Hide the popup window
	     */

	  }, {
	    key: "hide",
	    value: function hide() {
	      this.hidden = true;
	      this.frame.style.left = "0";
	      this.frame.style.top = "0";
	      this.frame.style.visibility = "hidden";
	    }
	    /**
	     * Remove the popup window
	     */

	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.frame.parentNode.removeChild(this.frame); // Remove element from DOM
	    }
	  }]);

	  return Popup$1;
	}();

	var errorFound$1 = false;
	var allOptions$3;
	var VALIDATOR_PRINT_STYLE$1 = "background: #FFeeee; color: #dd0000";
	/**
	 *  Used to validate options.
	 */

	var Validator$1 = /*#__PURE__*/function () {
	  function Validator$1() {
	    _classCallCheck(this, Validator$1);
	  }

	  _createClass(Validator$1, null, [{
	    key: "validate",
	    value:
	    /**
	     * Main function to be called
	     *
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {object} subObject
	     * @returns {boolean}
	     * @static
	     */
	    function validate(options, referenceOptions, subObject) {
	      errorFound$1 = false;
	      allOptions$3 = referenceOptions;
	      var usedOptions = referenceOptions;

	      if (subObject !== undefined) {
	        usedOptions = referenceOptions[subObject];
	      }

	      Validator$1.parse(options, usedOptions, []);
	      return errorFound$1;
	    }
	    /**
	     * Will traverse an object recursively and check every value
	     *
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {Array} path    | where to look for the actual option
	     * @static
	     */

	  }, {
	    key: "parse",
	    value: function parse(options, referenceOptions, path) {
	      for (var _option3 in options) {
	        if (Object.prototype.hasOwnProperty.call(options, _option3)) {
	          Validator$1.check(_option3, options, referenceOptions, path);
	        }
	      }
	    }
	    /**
	     * Check every value. If the value is an object, call the parse function on that object.
	     *
	     * @param {string} option
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {Array} path    | where to look for the actual option
	     * @static
	     */

	  }, {
	    key: "check",
	    value: function check(option, options, referenceOptions, path) {
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
	        Validator$1.getSuggestion(option, referenceOptions, path);
	        return;
	      }

	      var referenceOption = option;
	      var is_object = true;

	      if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
	        // NOTE: This only triggers if the __any__ is in the top level of the options object.
	        //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
	        // TODO: Examine if needed, remove if possible
	        // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
	        referenceOption = "__any__"; // if the any-subgroup is not a predefined object in the configurator,
	        // we do not look deeper into the object.

	        is_object = Validator$1.getType(options[option]) === "object";
	      }

	      var refOptionObj = referenceOptions[referenceOption];

	      if (is_object && refOptionObj.__type__ !== undefined) {
	        refOptionObj = refOptionObj.__type__;
	      }

	      Validator$1.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
	    }
	    /**
	     *
	     * @param {string}  option           | the option property
	     * @param {object}  options          | The supplied options object
	     * @param {object}  referenceOptions | The reference options containing all options and their allowed formats
	     * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
	     * @param {string}  refOptionObj     | This is the type object from the reference options
	     * @param {Array}   path             | where in the object is the option
	     * @static
	     */

	  }, {
	    key: "checkFields",
	    value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
	      var log = function log(message) {
	        console.error("%c" + message + Validator$1.printLocation(path, option), VALIDATOR_PRINT_STYLE$1);
	      };

	      var optionType = Validator$1.getType(options[option]);
	      var refOptionType = refOptionObj[optionType];

	      if (refOptionType !== undefined) {
	        // if the type is correct, we check if it is supposed to be one of a few select values
	        if (Validator$1.getType(refOptionType) === "array" && _indexOfInstanceProperty(refOptionType).call(refOptionType, options[option]) === -1) {
	          log('Invalid option detected in "' + option + '".' + " Allowed values are:" + Validator$1.print(refOptionType) + ' not "' + options[option] + '". ');
	          errorFound$1 = true;
	        } else if (optionType === "object" && referenceOption !== "__any__") {
	          path = copyAndExtendArray(path, option);
	          Validator$1.parse(options[option], referenceOptions[referenceOption], path);
	        }
	      } else if (refOptionObj["any"] === undefined) {
	        // type of the field is incorrect and the field cannot be any
	        log('Invalid type received for "' + option + '". Expected: ' + Validator$1.print(_Object$keys(refOptionObj)) + ". Received [" + optionType + '] "' + options[option] + '"');
	        errorFound$1 = true;
	      }
	    }
	    /**
	     *
	     * @param {object | boolean | number | string | Array.<number> | Date | Node | Moment | undefined | null} object
	     * @returns {string}
	     * @static
	     */

	  }, {
	    key: "getType",
	    value: function getType(object) {
	      var type = _typeof$1(object);

	      if (type === "object") {
	        if (object === null) {
	          return "null";
	        }

	        if (object instanceof Boolean) {
	          return "boolean";
	        }

	        if (object instanceof Number) {
	          return "number";
	        }

	        if (object instanceof String) {
	          return "string";
	        }

	        if (_Array$isArray(object)) {
	          return "array";
	        }

	        if (object instanceof Date) {
	          return "date";
	        }

	        if (object.nodeType !== undefined) {
	          return "dom";
	        }

	        if (object._isAMomentObject === true) {
	          return "moment";
	        }

	        return "object";
	      } else if (type === "number") {
	        return "number";
	      } else if (type === "boolean") {
	        return "boolean";
	      } else if (type === "string") {
	        return "string";
	      } else if (type === undefined) {
	        return "undefined";
	      }

	      return type;
	    }
	    /**
	     * @param {string} option
	     * @param {object} options
	     * @param {Array.<string>} path
	     * @static
	     */

	  }, {
	    key: "getSuggestion",
	    value: function getSuggestion(option, options, path) {
	      var localSearch = Validator$1.findInOptions(option, options, path, false);
	      var globalSearch = Validator$1.findInOptions(option, allOptions$3, [], true);
	      var localSearchThreshold = 8;
	      var globalSearchThreshold = 4;
	      var msg;

	      if (localSearch.indexMatch !== undefined) {
	        msg = " in " + Validator$1.printLocation(localSearch.path, option, "") + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
	      } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
	        msg = " in " + Validator$1.printLocation(localSearch.path, option, "") + "Perhaps it was misplaced? Matching option found at: " + Validator$1.printLocation(globalSearch.path, globalSearch.closestMatch, "");
	      } else if (localSearch.distance <= localSearchThreshold) {
	        msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator$1.printLocation(localSearch.path, option);
	      } else {
	        msg = ". Did you mean one of these: " + Validator$1.print(_Object$keys(options)) + Validator$1.printLocation(path, option);
	      }

	      console.error('%cUnknown option detected: "' + option + '"' + msg, VALIDATOR_PRINT_STYLE$1);
	      errorFound$1 = true;
	    }
	    /**
	     * traverse the options in search for a match.
	     *
	     * @param {string} option
	     * @param {object} options
	     * @param {Array} path    | where to look for the actual option
	     * @param {boolean} [recursive=false]
	     * @returns {{closestMatch: string, path: Array, distance: number}}
	     * @static
	     */

	  }, {
	    key: "findInOptions",
	    value: function findInOptions(option, options, path) {
	      var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	      var min = 1e9;
	      var closestMatch = "";
	      var closestMatchPath = [];
	      var lowerCaseOption = option.toLowerCase();
	      var indexMatch = undefined;

	      for (var op in options) {
	        var distance = void 0;

	        if (options[op].__type__ !== undefined && recursive === true) {
	          var result = Validator$1.findInOptions(option, options[op], copyAndExtendArray(path, op));

	          if (min > result.distance) {
	            closestMatch = result.closestMatch;
	            closestMatchPath = result.path;
	            min = result.distance;
	            indexMatch = result.indexMatch;
	          }
	        } else {
	          var _context20;

	          if (_indexOfInstanceProperty(_context20 = op.toLowerCase()).call(_context20, lowerCaseOption) !== -1) {
	            indexMatch = op;
	          }

	          distance = Validator$1.levenshteinDistance(option, op);

	          if (min > distance) {
	            closestMatch = op;
	            closestMatchPath = copyArray(path);
	            min = distance;
	          }
	        }
	      }

	      return {
	        closestMatch: closestMatch,
	        path: closestMatchPath,
	        distance: min,
	        indexMatch: indexMatch
	      };
	    }
	    /**
	     * @param {Array.<string>} path
	     * @param {object} option
	     * @param {string} prefix
	     * @returns {string}
	     * @static
	     */

	  }, {
	    key: "printLocation",
	    value: function printLocation(path, option) {
	      var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "Problem value found at: \n";
	      var str = "\n\n" + prefix + "options = {\n";

	      for (var i = 0; i < path.length; i++) {
	        for (var j = 0; j < i + 1; j++) {
	          str += "  ";
	        }

	        str += path[i] + ": {\n";
	      }

	      for (var _j = 0; _j < path.length + 1; _j++) {
	        str += "  ";
	      }

	      str += option + "\n";

	      for (var _i3 = 0; _i3 < path.length + 1; _i3++) {
	        for (var _j2 = 0; _j2 < path.length - _i3; _j2++) {
	          str += "  ";
	        }

	        str += "}\n";
	      }

	      return str + "\n\n";
	    }
	    /**
	     * @param {object} options
	     * @returns {string}
	     * @static
	     */

	  }, {
	    key: "print",
	    value: function print(options) {
	      return _JSON$stringify(options).replace(/(")|(\[)|(\])|(,"__type__")/g, "").replace(/(,)/g, ", ");
	    }
	    /**
	     *  Compute the edit distance between the two given strings
	     * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
	     *
	     * Copyright (c) 2011 Andrei Mackenzie
	     *
	     * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
	     *
	     * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
	     *
	     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	     *
	     * @param {string} a
	     * @param {string} b
	     * @returns {Array.<Array.<number>>}}
	     * @static
	     */

	  }, {
	    key: "levenshteinDistance",
	    value: function levenshteinDistance(a, b) {
	      if (a.length === 0) return b.length;
	      if (b.length === 0) return a.length;
	      var matrix = []; // increment along the first column of each row

	      var i;

	      for (i = 0; i <= b.length; i++) {
	        matrix[i] = [i];
	      } // increment each column in the first row


	      var j;

	      for (j = 0; j <= a.length; j++) {
	        matrix[0][j] = j;
	      } // Fill in the rest of the matrix


	      for (i = 1; i <= b.length; i++) {
	        for (j = 1; j <= a.length; j++) {
	          if (b.charAt(i - 1) == a.charAt(j - 1)) {
	            matrix[i][j] = matrix[i - 1][j - 1];
	          } else {
	            matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, // substitution
	            Math.min(matrix[i][j - 1] + 1, // insertion
	            matrix[i - 1][j] + 1)); // deletion
	          }
	        }
	      }

	      return matrix[b.length][a.length];
	    }
	  }]);

	  return Validator$1;
	}();

	var Activator$2 = Activator$1;
	var ColorPicker$2 = ColorPicker$1;
	var Configurator$2 = Configurator$1;
	var Hammer$2 = Hammer$1;
	var Popup$2 = Popup$1;
	var VALIDATOR_PRINT_STYLE = VALIDATOR_PRINT_STYLE$1;
	var Validator$2 = Validator$1;

	var util$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Activator: Activator$2,
		Alea: Alea,
		ColorPicker: ColorPicker$2,
		Configurator: Configurator$2,
		DELETE: DELETE,
		HSVToHex: HSVToHex,
		HSVToRGB: HSVToRGB,
		Hammer: Hammer$2,
		Popup: Popup$2,
		RGBToHSV: RGBToHSV,
		RGBToHex: RGBToHex,
		VALIDATOR_PRINT_STYLE: VALIDATOR_PRINT_STYLE,
		Validator: Validator$2,
		addClassName: addClassName,
		addCssText: addCssText,
		addEventListener: addEventListener,
		binarySearchCustom: binarySearchCustom,
		binarySearchValue: binarySearchValue,
		bridgeObject: bridgeObject,
		copyAndExtendArray: copyAndExtendArray,
		copyArray: copyArray,
		deepExtend: deepExtend,
		deepObjectAssign: deepObjectAssign,
		easingFunctions: easingFunctions,
		equalArray: equalArray,
		extend: extend,
		fillIfDefined: fillIfDefined,
		forEach: forEach$4,
		getAbsoluteLeft: getAbsoluteLeft,
		getAbsoluteRight: getAbsoluteRight,
		getAbsoluteTop: getAbsoluteTop,
		getScrollBarWidth: getScrollBarWidth,
		getTarget: getTarget,
		getType: getType,
		hasParent: hasParent,
		hexToHSV: hexToHSV,
		hexToRGB: hexToRGB,
		insertSort: insertSort,
		isDate: isDate,
		isNumber: isNumber,
		isObject: isObject$7,
		isString: isString,
		isValidHex: isValidHex,
		isValidRGB: isValidRGB,
		isValidRGBA: isValidRGBA,
		mergeOptions: mergeOptions,
		option: option,
		overrideOpacity: overrideOpacity,
		parseColor: parseColor,
		preventDefault: preventDefault,
		pureDeepObjectAssign: pureDeepObjectAssign,
		recursiveDOMDelete: recursiveDOMDelete,
		removeClassName: removeClassName,
		removeCssText: removeCssText,
		removeEventListener: removeEventListener,
		selectiveBridgeObject: selectiveBridgeObject,
		selectiveDeepExtend: selectiveDeepExtend,
		selectiveExtend: selectiveExtend,
		selectiveNotDeepExtend: selectiveNotDeepExtend,
		throttle: throttle,
		toArray: toArray,
		topMost: topMost,
		updateProperty: updateProperty
	});

	// DOM utility methods

	/**
	 * this prepares the JSON container for allocating SVG elements
	 * @param {Object} JSONcontainer
	 * @private
	 */
	function prepareElements(JSONcontainer) {
	  // cleanup the redundant svgElements;
	  for (var elementType in JSONcontainer) {
	    if (JSONcontainer.hasOwnProperty(elementType)) {
	      JSONcontainer[elementType].redundant = JSONcontainer[elementType].used;
	      JSONcontainer[elementType].used = [];
	    }
	  }
	}
	/**
	 * this cleans up all the unused SVG elements. By asking for the parentNode, we only need to supply the JSON container from
	 * which to remove the redundant elements.
	 *
	 * @param {Object} JSONcontainer
	 * @private
	 */

	function cleanupElements(JSONcontainer) {
	  // cleanup the redundant svgElements;
	  for (var elementType in JSONcontainer) {
	    if (JSONcontainer.hasOwnProperty(elementType)) {
	      if (JSONcontainer[elementType].redundant) {
	        for (var i = 0; i < JSONcontainer[elementType].redundant.length; i++) {
	          JSONcontainer[elementType].redundant[i].parentNode.removeChild(JSONcontainer[elementType].redundant[i]);
	        }

	        JSONcontainer[elementType].redundant = [];
	      }
	    }
	  }
	}
	/**
	 * Ensures that all elements are removed first up so they can be recreated cleanly
	 * @param {Object} JSONcontainer
	 */

	function resetElements(JSONcontainer) {
	  prepareElements(JSONcontainer);
	  cleanupElements(JSONcontainer);
	  prepareElements(JSONcontainer);
	}
	/**
	 * Allocate or generate an SVG element if needed. Store a reference to it in the JSON container and draw it in the svgContainer
	 * the JSON container and the SVG container have to be supplied so other svg containers (like the legend) can use this.
	 *
	 * @param {string} elementType
	 * @param {Object} JSONcontainer
	 * @param {Object} svgContainer
	 * @returns {Element}
	 * @private
	 */

	function getSVGElement(elementType, JSONcontainer, svgContainer) {
	  var element; // allocate SVG element, if it doesnt yet exist, create one.

	  if (JSONcontainer.hasOwnProperty(elementType)) {
	    // this element has been created before
	    // check if there is an redundant element
	    if (JSONcontainer[elementType].redundant.length > 0) {
	      element = JSONcontainer[elementType].redundant[0];
	      JSONcontainer[elementType].redundant.shift();
	    } else {
	      // create a new element and add it to the SVG
	      element = document.createElementNS('http://www.w3.org/2000/svg', elementType);
	      svgContainer.appendChild(element);
	    }
	  } else {
	    // create a new element and add it to the SVG, also create a new object in the svgElements to keep track of it.
	    element = document.createElementNS('http://www.w3.org/2000/svg', elementType);
	    JSONcontainer[elementType] = {
	      used: [],
	      redundant: []
	    };
	    svgContainer.appendChild(element);
	  }

	  JSONcontainer[elementType].used.push(element);
	  return element;
	}
	/**
	 * Allocate or generate an SVG element if needed. Store a reference to it in the JSON container and draw it in the svgContainer
	 * the JSON container and the SVG container have to be supplied so other svg containers (like the legend) can use this.
	 *
	 * @param {string} elementType
	 * @param {Object} JSONcontainer
	 * @param {Element} DOMContainer
	 * @param {Element} insertBefore
	 * @returns {*}
	 */

	function getDOMElement(elementType, JSONcontainer, DOMContainer, insertBefore) {
	  var element; // allocate DOM element, if it doesnt yet exist, create one.

	  if (JSONcontainer.hasOwnProperty(elementType)) {
	    // this element has been created before
	    // check if there is an redundant element
	    if (JSONcontainer[elementType].redundant.length > 0) {
	      element = JSONcontainer[elementType].redundant[0];
	      JSONcontainer[elementType].redundant.shift();
	    } else {
	      // create a new element and add it to the SVG
	      element = document.createElement(elementType);

	      if (insertBefore !== undefined) {
	        DOMContainer.insertBefore(element, insertBefore);
	      } else {
	        DOMContainer.appendChild(element);
	      }
	    }
	  } else {
	    // create a new element and add it to the SVG, also create a new object in the svgElements to keep track of it.
	    element = document.createElement(elementType);
	    JSONcontainer[elementType] = {
	      used: [],
	      redundant: []
	    };

	    if (insertBefore !== undefined) {
	      DOMContainer.insertBefore(element, insertBefore);
	    } else {
	      DOMContainer.appendChild(element);
	    }
	  }

	  JSONcontainer[elementType].used.push(element);
	  return element;
	}
	/**
	 * Draw a point object. This is a separate function because it can also be called by the legend.
	 * The reason the JSONcontainer and the target SVG svgContainer have to be supplied is so the legend can use these functions
	 * as well.
	 *
	 * @param {number} x
	 * @param {number} y
	 * @param {Object} groupTemplate: A template containing the necessary information to draw the datapoint e.g., {style: 'circle', size: 5, className: 'className' }
	 * @param {Object} JSONcontainer
	 * @param {Object} svgContainer
	 * @param {Object} labelObj
	 * @returns {vis.PointItem}
	 */

	function drawPoint(x, y, groupTemplate, JSONcontainer, svgContainer, labelObj) {
	  var point;

	  if (groupTemplate.style == 'circle') {
	    point = getSVGElement('circle', JSONcontainer, svgContainer);
	    point.setAttributeNS(null, "cx", x);
	    point.setAttributeNS(null, "cy", y);
	    point.setAttributeNS(null, "r", 0.5 * groupTemplate.size);
	  } else {
	    point = getSVGElement('rect', JSONcontainer, svgContainer);
	    point.setAttributeNS(null, "x", x - 0.5 * groupTemplate.size);
	    point.setAttributeNS(null, "y", y - 0.5 * groupTemplate.size);
	    point.setAttributeNS(null, "width", groupTemplate.size);
	    point.setAttributeNS(null, "height", groupTemplate.size);
	  }

	  if (groupTemplate.styles !== undefined) {
	    point.setAttributeNS(null, "style", groupTemplate.styles);
	  }

	  point.setAttributeNS(null, "class", groupTemplate.className + " vis-point"); //handle label

	  if (labelObj) {
	    var label = getSVGElement('text', JSONcontainer, svgContainer);

	    if (labelObj.xOffset) {
	      x = x + labelObj.xOffset;
	    }

	    if (labelObj.yOffset) {
	      y = y + labelObj.yOffset;
	    }

	    if (labelObj.content) {
	      label.textContent = labelObj.content;
	    }

	    if (labelObj.className) {
	      label.setAttributeNS(null, "class", labelObj.className + " vis-label");
	    }

	    label.setAttributeNS(null, "x", x);
	    label.setAttributeNS(null, "y", y);
	  }

	  return point;
	}
	/**
	 * draw a bar SVG element centered on the X coordinate
	 *
	 * @param {number} x
	 * @param {number} y
	 * @param {number} width
	 * @param {number} height
	 * @param {string} className
	 * @param {Object} JSONcontainer
	 * @param {Object} svgContainer
	 * @param {string} style
	 */

	function drawBar(x, y, width, height, className, JSONcontainer, svgContainer, style) {
	  if (height != 0) {
	    if (height < 0) {
	      height *= -1;
	      y -= height;
	    }

	    var rect = getSVGElement('rect', JSONcontainer, svgContainer);
	    rect.setAttributeNS(null, "x", x - 0.5 * width);
	    rect.setAttributeNS(null, "y", y);
	    rect.setAttributeNS(null, "width", width);
	    rect.setAttributeNS(null, "height", height);
	    rect.setAttributeNS(null, "class", className);

	    if (style) {
	      rect.setAttributeNS(null, "style", style);
	    }
	  }
	}
	/**
	 * get default language
	 * @returns {string}
	 */

	function getNavigatorLanguage() {
	  try {
	    if (!navigator) return 'en';

	    if (navigator.languages && navigator.languages.length) {
	      return navigator.languages;
	    } else {
	      return navigator.userLanguage || navigator.language || navigator.browserLanguage || 'en';
	    }
	  } catch (error) {
	    return 'en';
	  }
	}

	var DOMutil = /*#__PURE__*/Object.freeze({
		__proto__: null,
		prepareElements: prepareElements,
		cleanupElements: cleanupElements,
		resetElements: resetElements,
		getSVGElement: getSVGElement,
		getDOMElement: getDOMElement,
		drawPoint: drawPoint,
		drawBar: drawBar,
		getNavigatorLanguage: getNavigatorLanguage
	});

	var construct$2 = {exports: {}};

	var global$g = global$V;
	var isConstructor = isConstructor$4;
	var tryToString$1 = tryToString$4;
	var TypeError$6 = global$g.TypeError; // `Assert: IsConstructor(argument) is true`

	var aConstructor$2 = function (argument) {
	  if (isConstructor(argument)) return argument;
	  throw TypeError$6(tryToString$1(argument) + ' is not a constructor');
	};

	var $$i = _export;
	var getBuiltIn$4 = getBuiltIn$c;
	var apply$1 = functionApply;
	var bind$9 = functionBind;
	var aConstructor$1 = aConstructor$2;
	var anObject$3 = anObject$d;
	var isObject$6 = isObject$j;
	var create$5 = objectCreate;
	var fails$9 = fails$v;
	var nativeConstruct = getBuiltIn$4('Reflect', 'construct');
	var ObjectPrototype = Object.prototype;
	var push$2 = [].push; // `Reflect.construct` method
	// https://tc39.es/ecma262/#sec-reflect.construct
	// MS Edge supports only 2 arguments and argumentsList argument is optional
	// FF Nightly sets third argument as `new.target`, but does not create `this` from it

	var NEW_TARGET_BUG = fails$9(function () {
	  function F() {
	    /* empty */
	  }

	  return !(nativeConstruct(function () {
	    /* empty */
	  }, [], F) instanceof F);
	});
	var ARGS_BUG = !fails$9(function () {
	  nativeConstruct(function () {
	    /* empty */
	  });
	});
	var FORCED$3 = NEW_TARGET_BUG || ARGS_BUG;
	$$i({
	  target: 'Reflect',
	  stat: true,
	  forced: FORCED$3,
	  sham: FORCED$3
	}, {
	  construct: function construct(Target, args
	  /* , newTarget */
	  ) {
	    aConstructor$1(Target);
	    anObject$3(args);
	    var newTarget = arguments.length < 3 ? Target : aConstructor$1(arguments[2]);
	    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);

	    if (Target == newTarget) {
	      // w/o altered newTarget, optimization for 0-4 arguments
	      switch (args.length) {
	        case 0:
	          return new Target();

	        case 1:
	          return new Target(args[0]);

	        case 2:
	          return new Target(args[0], args[1]);

	        case 3:
	          return new Target(args[0], args[1], args[2]);

	        case 4:
	          return new Target(args[0], args[1], args[2], args[3]);
	      } // w/o altered newTarget, lot of arguments case


	      var $args = [null];
	      apply$1(push$2, $args, args);
	      return new (apply$1(bind$9, Target, $args))();
	    } // with altered newTarget, not support built-in constructors


	    var proto = newTarget.prototype;
	    var instance = create$5(isObject$6(proto) ? proto : ObjectPrototype);
	    var result = apply$1(Target, instance, args);
	    return isObject$6(result) ? result : instance;
	  }
	});

	var path$6 = path$t;
	var construct$1 = path$6.Reflect.construct;

	var parent$x = construct$1;
	var construct = parent$x;

	(function (module) {
	  module.exports = construct;
	})(construct$2);

	var _Reflect$construct = /*@__PURE__*/getDefaultExportFromCjs(construct$2.exports);

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	var create$4 = {exports: {}};

	var parent$w = create$6;
	var create$3 = parent$w;

	var parent$v = create$3;
	var create$2 = parent$v;

	(function (module) {
	  module.exports = create$2;
	})(create$4);

	var _Object$create = /*@__PURE__*/getDefaultExportFromCjs(create$4.exports);

	var setPrototypeOf$6 = {exports: {}};

	var $$h = _export;
	var setPrototypeOf$5 = objectSetPrototypeOf; // `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof

	$$h({
	  target: 'Object',
	  stat: true
	}, {
	  setPrototypeOf: setPrototypeOf$5
	});

	var path$5 = path$t;
	var setPrototypeOf$4 = path$5.Object.setPrototypeOf;

	var parent$u = setPrototypeOf$4;
	var setPrototypeOf$3 = parent$u;

	var parent$t = setPrototypeOf$3;
	var setPrototypeOf$2 = parent$t;

	var parent$s = setPrototypeOf$2;
	var setPrototypeOf$1 = parent$s;

	(function (module) {
	  module.exports = setPrototypeOf$1;
	})(setPrototypeOf$6);

	var _Object$setPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(setPrototypeOf$6.exports);

	var bind$8 = {exports: {}};

	var parent$r = bind$a;
	var bind$7 = parent$r;

	var parent$q = bind$7;
	var bind$6 = parent$q;

	(function (module) {
	  module.exports = bind$6;
	})(bind$8);

	var _bindInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(bind$8.exports);

	function _setPrototypeOf(o, p) {
	  var _context;

	  _setPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty(_context = _Object$setPrototypeOf).call(_context) : function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };
	  return _setPrototypeOf(o, p);
	}

	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }

	  subClass.prototype = _Object$create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });

	  _Object$defineProperty(subClass, "prototype", {
	    writable: false
	  });

	  if (superClass) _setPrototypeOf(subClass, superClass);
	}

	function _possibleConstructorReturn(self, call) {
	  if (call && (_typeof$1(call) === "object" || typeof call === "function")) {
	    return call;
	  } else if (call !== void 0) {
	    throw new TypeError("Derived constructors may only return object or undefined");
	  }

	  return _assertThisInitialized(self);
	}

	var getPrototypeOf$3 = {exports: {}};

	var parent$p = getPrototypeOf$4;
	var getPrototypeOf$2 = parent$p;

	var parent$o = getPrototypeOf$2;
	var getPrototypeOf$1 = parent$o;

	(function (module) {
	  module.exports = getPrototypeOf$1;
	})(getPrototypeOf$3);

	var _Object$getPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOf$3.exports);

	function _getPrototypeOf(o) {
	  var _context;

	  _getPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty(_context = _Object$getPrototypeOf).call(_context) : function _getPrototypeOf(o) {
	    return o.__proto__ || _Object$getPrototypeOf(o);
	  };
	  return _getPrototypeOf(o);
	}

	var regeneratorRuntime$1 = {exports: {}};

	var _typeof = {exports: {}};

	(function (module) {
	  var _Symbol = symbol$5.exports;
	  var _Symbol$iterator = iterator$5.exports;

	  function _typeof(obj) {
	    "@babel/helpers - typeof";

	    return (module.exports = _typeof = "function" == typeof _Symbol && "symbol" == typeof _Symbol$iterator ? function (obj) {
	      return typeof obj;
	    } : function (obj) {
	      return obj && "function" == typeof _Symbol && obj.constructor === _Symbol && obj !== _Symbol.prototype ? "symbol" : typeof obj;
	    }, module.exports.__esModule = true, module.exports["default"] = module.exports), _typeof(obj);
	  }

	  module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;
	})(_typeof);

	var forEach$3 = {exports: {}};

	var parent$n = forEach$5;
	var forEach$2 = parent$n;

	var parent$m = forEach$2;
	var forEach$1 = parent$m;

	(function (module) {
	  module.exports = forEach$1;
	})(forEach$3);

	var promise$5 = {exports: {}};

	var hasOwn$5 = hasOwnProperty_1;
	var ownKeys$2 = ownKeys$9;
	var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
	var definePropertyModule$1 = objectDefineProperty;

	var copyConstructorProperties$1 = function (target, source, exceptions) {
	  var keys = ownKeys$2(source);
	  var defineProperty = definePropertyModule$1.f;
	  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;

	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];

	    if (!hasOwn$5(target, key) && !(exceptions && hasOwn$5(exceptions, key))) {
	      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
	    }
	  }
	};

	var uncurryThis$3 = functionUncurryThis;
	var replace = uncurryThis$3(''.replace);

	var TEST = function (arg) {
	  return String(Error(arg).stack);
	}('zxcasd');

	var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
	var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);

	var clearErrorStack$1 = function (stack, dropEntries) {
	  if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string') {
	    while (dropEntries--) stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
	  }

	  return stack;
	};

	var isObject$5 = isObject$j;
	var createNonEnumerableProperty$2 = createNonEnumerableProperty$8; // `InstallErrorCause` abstract operation
	// https://tc39.es/proposal-error-cause/#sec-errorobjects-install-error-cause

	var installErrorCause$1 = function (O, options) {
	  if (isObject$5(options) && 'cause' in options) {
	    createNonEnumerableProperty$2(O, 'cause', options.cause);
	  }
	};

	var global$f = global$V;
	var bind$5 = functionBindContext;
	var call$3 = functionCall;
	var anObject$2 = anObject$d;
	var tryToString = tryToString$4;
	var isArrayIteratorMethod = isArrayIteratorMethod$2;
	var lengthOfArrayLike$4 = lengthOfArrayLike$d;
	var isPrototypeOf$d = objectIsPrototypeOf;
	var getIterator$5 = getIterator$7;
	var getIteratorMethod = getIteratorMethod$8;
	var iteratorClose = iteratorClose$2;
	var TypeError$5 = global$f.TypeError;

	var Result = function (stopped, result) {
	  this.stopped = stopped;
	  this.result = result;
	};

	var ResultPrototype = Result.prototype;

	var iterate$6 = function (iterable, unboundFunction, options) {
	  var that = options && options.that;
	  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
	  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
	  var INTERRUPTED = !!(options && options.INTERRUPTED);
	  var fn = bind$5(unboundFunction, that);
	  var iterator, iterFn, index, length, result, next, step;

	  var stop = function (condition) {
	    if (iterator) iteratorClose(iterator, 'normal', condition);
	    return new Result(true, condition);
	  };

	  var callFn = function (value) {
	    if (AS_ENTRIES) {
	      anObject$2(value);
	      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
	    }

	    return INTERRUPTED ? fn(value, stop) : fn(value);
	  };

	  if (IS_ITERATOR) {
	    iterator = iterable;
	  } else {
	    iterFn = getIteratorMethod(iterable);
	    if (!iterFn) throw TypeError$5(tryToString(iterable) + ' is not iterable'); // optimisation for array iterators

	    if (isArrayIteratorMethod(iterFn)) {
	      for (index = 0, length = lengthOfArrayLike$4(iterable); length > index; index++) {
	        result = callFn(iterable[index]);
	        if (result && isPrototypeOf$d(ResultPrototype, result)) return result;
	      }

	      return new Result(false);
	    }

	    iterator = getIterator$5(iterable, iterFn);
	  }

	  next = iterator.next;

	  while (!(step = call$3(next, iterator)).done) {
	    try {
	      result = callFn(step.value);
	    } catch (error) {
	      iteratorClose(iterator, 'throw', error);
	    }

	    if (typeof result == 'object' && result && isPrototypeOf$d(ResultPrototype, result)) return result;
	  }

	  return new Result(false);
	};

	var toString$3 = toString$a;

	var normalizeStringArgument$1 = function (argument, $default) {
	  return argument === undefined ? arguments.length < 2 ? '' : $default : toString$3(argument);
	};

	var fails$8 = fails$v;
	var createPropertyDescriptor$1 = createPropertyDescriptor$7;
	var errorStackInstallable = !fails$8(function () {
	  var error = Error('a');
	  if (!('stack' in error)) return true; // eslint-disable-next-line es/no-object-defineproperty -- safe

	  Object.defineProperty(error, 'stack', createPropertyDescriptor$1(1, 7));
	  return error.stack !== 7;
	});

	var $$g = _export;
	var global$e = global$V;
	var isPrototypeOf$c = objectIsPrototypeOf;
	var getPrototypeOf = objectGetPrototypeOf;
	var setPrototypeOf = objectSetPrototypeOf;
	var copyConstructorProperties = copyConstructorProperties$1;
	var create$1 = objectCreate;
	var createNonEnumerableProperty$1 = createNonEnumerableProperty$8;
	var createPropertyDescriptor = createPropertyDescriptor$7;
	var clearErrorStack = clearErrorStack$1;
	var installErrorCause = installErrorCause$1;
	var iterate$5 = iterate$6;
	var normalizeStringArgument = normalizeStringArgument$1;
	var wellKnownSymbol$3 = wellKnownSymbol$m;
	var ERROR_STACK_INSTALLABLE = errorStackInstallable;
	var TO_STRING_TAG = wellKnownSymbol$3('toStringTag');
	var Error$1 = global$e.Error;
	var push$1 = [].push;

	var $AggregateError = function AggregateError(errors, message
	/* , options */
	) {
	  var options = arguments.length > 2 ? arguments[2] : undefined;
	  var isInstance = isPrototypeOf$c(AggregateErrorPrototype, this);
	  var that;

	  if (setPrototypeOf) {
	    that = setPrototypeOf(new Error$1(), isInstance ? getPrototypeOf(this) : AggregateErrorPrototype);
	  } else {
	    that = isInstance ? this : create$1(AggregateErrorPrototype);
	    createNonEnumerableProperty$1(that, TO_STRING_TAG, 'Error');
	  }

	  if (message !== undefined) createNonEnumerableProperty$1(that, 'message', normalizeStringArgument(message));
	  if (ERROR_STACK_INSTALLABLE) createNonEnumerableProperty$1(that, 'stack', clearErrorStack(that.stack, 1));
	  installErrorCause(that, options);
	  var errorsArray = [];
	  iterate$5(errors, push$1, {
	    that: errorsArray
	  });
	  createNonEnumerableProperty$1(that, 'errors', errorsArray);
	  return that;
	};

	if (setPrototypeOf) setPrototypeOf($AggregateError, Error$1);else copyConstructorProperties($AggregateError, Error$1, {
	  name: true
	});
	var AggregateErrorPrototype = $AggregateError.prototype = create$1(Error$1.prototype, {
	  constructor: createPropertyDescriptor(1, $AggregateError),
	  message: createPropertyDescriptor(1, ''),
	  name: createPropertyDescriptor(1, 'AggregateError')
	}); // `AggregateError` constructor
	// https://tc39.es/ecma262/#sec-aggregate-error-constructor

	$$g({
	  global: true
	}, {
	  AggregateError: $AggregateError
	});

	var global$d = global$V;
	var nativePromiseConstructor = global$d.Promise;

	var redefine = redefine$4;

	var redefineAll$2 = function (target, src, options) {
	  for (var key in src) {
	    if (options && options.unsafe && target[key]) target[key] = src[key];else redefine(target, key, src[key], options);
	  }

	  return target;
	};

	var getBuiltIn$3 = getBuiltIn$c;
	var definePropertyModule = objectDefineProperty;
	var wellKnownSymbol$2 = wellKnownSymbol$m;
	var DESCRIPTORS$2 = descriptors;
	var SPECIES$2 = wellKnownSymbol$2('species');

	var setSpecies$2 = function (CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn$3(CONSTRUCTOR_NAME);
	  var defineProperty = definePropertyModule.f;

	  if (DESCRIPTORS$2 && Constructor && !Constructor[SPECIES$2]) {
	    defineProperty(Constructor, SPECIES$2, {
	      configurable: true,
	      get: function () {
	        return this;
	      }
	    });
	  }
	};

	var global$c = global$V;
	var isPrototypeOf$b = objectIsPrototypeOf;
	var TypeError$4 = global$c.TypeError;

	var anInstance$3 = function (it, Prototype) {
	  if (isPrototypeOf$b(Prototype, it)) return it;
	  throw TypeError$4('Incorrect invocation');
	};

	var anObject$1 = anObject$d;
	var aConstructor = aConstructor$2;
	var wellKnownSymbol$1 = wellKnownSymbol$m;
	var SPECIES$1 = wellKnownSymbol$1('species'); // `SpeciesConstructor` abstract operation
	// https://tc39.es/ecma262/#sec-speciesconstructor

	var speciesConstructor$2 = function (O, defaultConstructor) {
	  var C = anObject$1(O).constructor;
	  var S;
	  return C === undefined || (S = anObject$1(C)[SPECIES$1]) == undefined ? defaultConstructor : aConstructor(S);
	};

	var userAgent$4 = engineUserAgent;
	var engineIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent$4);

	var classof$4 = classofRaw$1;
	var global$b = global$V;
	var engineIsNode = classof$4(global$b.process) == 'process';

	var global$a = global$V;
	var apply = functionApply;
	var bind$4 = functionBindContext;
	var isCallable$3 = isCallable$k;
	var hasOwn$4 = hasOwnProperty_1;
	var fails$7 = fails$v;
	var html = html$2;
	var arraySlice$1 = arraySlice$5;
	var createElement = documentCreateElement$1;
	var validateArgumentsLength = validateArgumentsLength$2;
	var IS_IOS$1 = engineIsIos;
	var IS_NODE$3 = engineIsNode;
	var set$3 = global$a.setImmediate;
	var clear = global$a.clearImmediate;
	var process$2 = global$a.process;
	var Dispatch = global$a.Dispatch;
	var Function$1 = global$a.Function;
	var MessageChannel = global$a.MessageChannel;
	var String$1 = global$a.String;
	var counter = 0;
	var queue$1 = {};
	var ONREADYSTATECHANGE = 'onreadystatechange';
	var location, defer, channel, port;

	try {
	  // Deno throws a ReferenceError on `location` access without `--location` flag
	  location = global$a.location;
	} catch (error) {
	  /* empty */
	}

	var run = function (id) {
	  if (hasOwn$4(queue$1, id)) {
	    var fn = queue$1[id];
	    delete queue$1[id];
	    fn();
	  }
	};

	var runner = function (id) {
	  return function () {
	    run(id);
	  };
	};

	var listener = function (event) {
	  run(event.data);
	};

	var post = function (id) {
	  // old engines have not location.origin
	  global$a.postMessage(String$1(id), location.protocol + '//' + location.host);
	}; // Node.js 0.9+ & IE10+ has setImmediate, otherwise:


	if (!set$3 || !clear) {
	  set$3 = function setImmediate(handler) {
	    validateArgumentsLength(arguments.length, 1);
	    var fn = isCallable$3(handler) ? handler : Function$1(handler);
	    var args = arraySlice$1(arguments, 1);

	    queue$1[++counter] = function () {
	      apply(fn, undefined, args);
	    };

	    defer(counter);
	    return counter;
	  };

	  clear = function clearImmediate(id) {
	    delete queue$1[id];
	  }; // Node.js 0.8-


	  if (IS_NODE$3) {
	    defer = function (id) {
	      process$2.nextTick(runner(id));
	    }; // Sphere (JS game engine) Dispatch API

	  } else if (Dispatch && Dispatch.now) {
	    defer = function (id) {
	      Dispatch.now(runner(id));
	    }; // Browsers with MessageChannel, includes WebWorkers
	    // except iOS - https://github.com/zloirock/core-js/issues/624

	  } else if (MessageChannel && !IS_IOS$1) {
	    channel = new MessageChannel();
	    port = channel.port2;
	    channel.port1.onmessage = listener;
	    defer = bind$4(port.postMessage, port); // Browsers with postMessage, skip WebWorkers
	    // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
	  } else if (global$a.addEventListener && isCallable$3(global$a.postMessage) && !global$a.importScripts && location && location.protocol !== 'file:' && !fails$7(post)) {
	    defer = post;
	    global$a.addEventListener('message', listener, false); // IE8-
	  } else if (ONREADYSTATECHANGE in createElement('script')) {
	    defer = function (id) {
	      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
	        html.removeChild(this);
	        run(id);
	      };
	    }; // Rest old browsers

	  } else {
	    defer = function (id) {
	      setTimeout(runner(id), 0);
	    };
	  }
	}

	var task$1 = {
	  set: set$3,
	  clear: clear
	};

	var userAgent$3 = engineUserAgent;
	var global$9 = global$V;
	var engineIsIosPebble = /ipad|iphone|ipod/i.test(userAgent$3) && global$9.Pebble !== undefined;

	var userAgent$2 = engineUserAgent;
	var engineIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent$2);

	var global$8 = global$V;
	var bind$3 = functionBindContext;
	var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	var macrotask = task$1.set;
	var IS_IOS = engineIsIos;
	var IS_IOS_PEBBLE = engineIsIosPebble;
	var IS_WEBOS_WEBKIT = engineIsWebosWebkit;
	var IS_NODE$2 = engineIsNode;
	var MutationObserver = global$8.MutationObserver || global$8.WebKitMutationObserver;
	var document$2 = global$8.document;
	var process$1 = global$8.process;
	var Promise$1 = global$8.Promise; // Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`

	var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global$8, 'queueMicrotask');
	var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
	var flush, head, last, notify$1, toggle, node, promise$4, then; // modern engines have queueMicrotask method

	if (!queueMicrotask) {
	  flush = function () {
	    var parent, fn;
	    if (IS_NODE$2 && (parent = process$1.domain)) parent.exit();

	    while (head) {
	      fn = head.fn;
	      head = head.next;

	      try {
	        fn();
	      } catch (error) {
	        if (head) notify$1();else last = undefined;
	        throw error;
	      }
	    }

	    last = undefined;
	    if (parent) parent.enter();
	  }; // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
	  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898


	  if (!IS_IOS && !IS_NODE$2 && !IS_WEBOS_WEBKIT && MutationObserver && document$2) {
	    toggle = true;
	    node = document$2.createTextNode('');
	    new MutationObserver(flush).observe(node, {
	      characterData: true
	    });

	    notify$1 = function () {
	      node.data = toggle = !toggle;
	    }; // environments with maybe non-completely correct, but existent Promise

	  } else if (!IS_IOS_PEBBLE && Promise$1 && Promise$1.resolve) {
	    // Promise.resolve without an argument throws an error in LG WebOS 2
	    promise$4 = Promise$1.resolve(undefined); // workaround of WebKit ~ iOS Safari 10.1 bug

	    promise$4.constructor = Promise$1;
	    then = bind$3(promise$4.then, promise$4);

	    notify$1 = function () {
	      then(flush);
	    }; // Node.js without promises

	  } else if (IS_NODE$2) {
	    notify$1 = function () {
	      process$1.nextTick(flush);
	    }; // for other environments - macrotask based on:
	    // - setImmediate
	    // - MessageChannel
	    // - window.postMessag
	    // - onreadystatechange
	    // - setTimeout

	  } else {
	    // strange IE + webpack dev server bug - use .bind(global)
	    macrotask = bind$3(macrotask, global$8);

	    notify$1 = function () {
	      macrotask(flush);
	    };
	  }
	}

	var microtask$1 = queueMicrotask || function (fn) {
	  var task = {
	    fn: fn,
	    next: undefined
	  };
	  if (last) last.next = task;

	  if (!head) {
	    head = task;
	    notify$1();
	  }

	  last = task;
	};

	var newPromiseCapability$2 = {};

	var aCallable$6 = aCallable$b;

	var PromiseCapability = function (C) {
	  var resolve, reject;
	  this.promise = new C(function ($$resolve, $$reject) {
	    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
	    resolve = $$resolve;
	    reject = $$reject;
	  });
	  this.resolve = aCallable$6(resolve);
	  this.reject = aCallable$6(reject);
	}; // `NewPromiseCapability` abstract operation
	// https://tc39.es/ecma262/#sec-newpromisecapability


	newPromiseCapability$2.f = function (C) {
	  return new PromiseCapability(C);
	};

	var anObject = anObject$d;
	var isObject$4 = isObject$j;
	var newPromiseCapability$1 = newPromiseCapability$2;

	var promiseResolve$2 = function (C, x) {
	  anObject(C);
	  if (isObject$4(x) && x.constructor === C) return x;
	  var promiseCapability = newPromiseCapability$1.f(C);
	  var resolve = promiseCapability.resolve;
	  resolve(x);
	  return promiseCapability.promise;
	};

	var global$7 = global$V;

	var hostReportErrors$1 = function (a, b) {
	  var console = global$7.console;

	  if (console && console.error) {
	    arguments.length == 1 ? console.error(a) : console.error(a, b);
	  }
	};

	var perform$4 = function (exec) {
	  try {
	    return {
	      error: false,
	      value: exec()
	    };
	  } catch (error) {
	    return {
	      error: true,
	      value: error
	    };
	  }
	};

	var Queue$2 = function () {
	  this.head = null;
	  this.tail = null;
	};

	Queue$2.prototype = {
	  add: function (item) {
	    var entry = {
	      item: item,
	      next: null
	    };
	    if (this.head) this.tail.next = entry;else this.head = entry;
	    this.tail = entry;
	  },
	  get: function () {
	    var entry = this.head;

	    if (entry) {
	      this.head = entry.next;
	      if (this.tail === entry) this.tail = null;
	      return entry.item;
	    }
	  }
	};
	var queue = Queue$2;

	var engineIsBrowser = typeof window == 'object';

	var $$f = _export;
	var IS_PURE = isPure;
	var global$6 = global$V;
	var getBuiltIn$2 = getBuiltIn$c;
	var call$2 = functionCall;
	var NativePromise$1 = nativePromiseConstructor;
	var redefineAll$1 = redefineAll$2;
	var setToStringTag$1 = setToStringTag$6;
	var setSpecies$1 = setSpecies$2;
	var aCallable$5 = aCallable$b;
	var isCallable$2 = isCallable$k;
	var isObject$3 = isObject$j;
	var anInstance$2 = anInstance$3;
	var inspectSource = inspectSource$3;
	var iterate$4 = iterate$6;
	var checkCorrectnessOfIteration = checkCorrectnessOfIteration$2;
	var speciesConstructor$1 = speciesConstructor$2;
	var task = task$1.set;
	var microtask = microtask$1;
	var promiseResolve$1 = promiseResolve$2;
	var hostReportErrors = hostReportErrors$1;
	var newPromiseCapabilityModule$3 = newPromiseCapability$2;
	var perform$3 = perform$4;
	var Queue$1 = queue;
	var InternalStateModule$2 = internalState;
	var isForced = isForced_1;
	var wellKnownSymbol = wellKnownSymbol$m;
	var IS_BROWSER = engineIsBrowser;
	var IS_NODE$1 = engineIsNode;
	var V8_VERSION = engineV8Version;
	var SPECIES = wellKnownSymbol('species');
	var PROMISE = 'Promise';
	var getInternalState = InternalStateModule$2.getterFor(PROMISE);
	var setInternalState$2 = InternalStateModule$2.set;
	var getInternalPromiseState = InternalStateModule$2.getterFor(PROMISE);
	var NativePromisePrototype = NativePromise$1 && NativePromise$1.prototype;
	var PromiseConstructor = NativePromise$1;
	var PromisePrototype = NativePromisePrototype;
	var TypeError$3 = global$6.TypeError;
	var document$1 = global$6.document;
	var process = global$6.process;
	var newPromiseCapability = newPromiseCapabilityModule$3.f;
	var newGenericPromiseCapability = newPromiseCapability;
	var DISPATCH_EVENT = !!(document$1 && document$1.createEvent && global$6.dispatchEvent);
	var NATIVE_REJECTION_EVENT = isCallable$2(global$6.PromiseRejectionEvent);
	var UNHANDLED_REJECTION = 'unhandledrejection';
	var REJECTION_HANDLED = 'rejectionhandled';
	var PENDING = 0;
	var FULFILLED = 1;
	var REJECTED = 2;
	var HANDLED = 1;
	var UNHANDLED = 2;
	var SUBCLASSING = false;
	var Internal, OwnPromiseCapability, PromiseWrapper;
	var FORCED$2 = isForced(PROMISE, function () {
	  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(PromiseConstructor);
	  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(PromiseConstructor); // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
	  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
	  // We can't detect it synchronously, so just check versions

	  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true; // We need Promise#finally in the pure version for preventing prototype pollution

	  if (!PromisePrototype['finally']) return true; // We can't use @@species feature detection in V8 since it causes
	  // deoptimization and performance degradation
	  // https://github.com/zloirock/core-js/issues/679

	  if (V8_VERSION >= 51 && /native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) return false; // Detect correctness of subclassing with @@species support

	  var promise = new PromiseConstructor(function (resolve) {
	    resolve(1);
	  });

	  var FakePromise = function (exec) {
	    exec(function () {
	      /* empty */
	    }, function () {
	      /* empty */
	    });
	  };

	  var constructor = promise.constructor = {};
	  constructor[SPECIES] = FakePromise;
	  SUBCLASSING = promise.then(function () {
	    /* empty */
	  }) instanceof FakePromise;
	  if (!SUBCLASSING) return true; // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test

	  return !GLOBAL_CORE_JS_PROMISE && IS_BROWSER && !NATIVE_REJECTION_EVENT;
	});
	var INCORRECT_ITERATION = FORCED$2 || !checkCorrectnessOfIteration(function (iterable) {
	  PromiseConstructor.all(iterable)['catch'](function () {
	    /* empty */
	  });
	}); // helpers

	var isThenable = function (it) {
	  var then;
	  return isObject$3(it) && isCallable$2(then = it.then) ? then : false;
	};

	var callReaction = function (reaction, state) {
	  var value = state.value;
	  var ok = state.state == FULFILLED;
	  var handler = ok ? reaction.ok : reaction.fail;
	  var resolve = reaction.resolve;
	  var reject = reaction.reject;
	  var domain = reaction.domain;
	  var result, then, exited;

	  try {
	    if (handler) {
	      if (!ok) {
	        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
	        state.rejection = HANDLED;
	      }

	      if (handler === true) result = value;else {
	        if (domain) domain.enter();
	        result = handler(value); // can throw

	        if (domain) {
	          domain.exit();
	          exited = true;
	        }
	      }

	      if (result === reaction.promise) {
	        reject(TypeError$3('Promise-chain cycle'));
	      } else if (then = isThenable(result)) {
	        call$2(then, result, resolve, reject);
	      } else resolve(result);
	    } else reject(value);
	  } catch (error) {
	    if (domain && !exited) domain.exit();
	    reject(error);
	  }
	};

	var notify = function (state, isReject) {
	  if (state.notified) return;
	  state.notified = true;
	  microtask(function () {
	    var reactions = state.reactions;
	    var reaction;

	    while (reaction = reactions.get()) {
	      callReaction(reaction, state);
	    }

	    state.notified = false;
	    if (isReject && !state.rejection) onUnhandled(state);
	  });
	};

	var dispatchEvent = function (name, promise, reason) {
	  var event, handler;

	  if (DISPATCH_EVENT) {
	    event = document$1.createEvent('Event');
	    event.promise = promise;
	    event.reason = reason;
	    event.initEvent(name, false, true);
	    global$6.dispatchEvent(event);
	  } else event = {
	    promise: promise,
	    reason: reason
	  };

	  if (!NATIVE_REJECTION_EVENT && (handler = global$6['on' + name])) handler(event);else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
	};

	var onUnhandled = function (state) {
	  call$2(task, global$6, function () {
	    var promise = state.facade;
	    var value = state.value;
	    var IS_UNHANDLED = isUnhandled(state);
	    var result;

	    if (IS_UNHANDLED) {
	      result = perform$3(function () {
	        if (IS_NODE$1) {
	          process.emit('unhandledRejection', value, promise);
	        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
	      }); // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should

	      state.rejection = IS_NODE$1 || isUnhandled(state) ? UNHANDLED : HANDLED;
	      if (result.error) throw result.value;
	    }
	  });
	};

	var isUnhandled = function (state) {
	  return state.rejection !== HANDLED && !state.parent;
	};

	var onHandleUnhandled = function (state) {
	  call$2(task, global$6, function () {
	    var promise = state.facade;

	    if (IS_NODE$1) {
	      process.emit('rejectionHandled', promise);
	    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
	  });
	};

	var bind$2 = function (fn, state, unwrap) {
	  return function (value) {
	    fn(state, value, unwrap);
	  };
	};

	var internalReject = function (state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  state.value = value;
	  state.state = REJECTED;
	  notify(state, true);
	};

	var internalResolve = function (state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;

	  try {
	    if (state.facade === value) throw TypeError$3("Promise can't be resolved itself");
	    var then = isThenable(value);

	    if (then) {
	      microtask(function () {
	        var wrapper = {
	          done: false
	        };

	        try {
	          call$2(then, value, bind$2(internalResolve, wrapper, state), bind$2(internalReject, wrapper, state));
	        } catch (error) {
	          internalReject(wrapper, error, state);
	        }
	      });
	    } else {
	      state.value = value;
	      state.state = FULFILLED;
	      notify(state, false);
	    }
	  } catch (error) {
	    internalReject({
	      done: false
	    }, error, state);
	  }
	}; // constructor polyfill


	if (FORCED$2) {
	  // 25.4.3.1 Promise(executor)
	  PromiseConstructor = function Promise(executor) {
	    anInstance$2(this, PromisePrototype);
	    aCallable$5(executor);
	    call$2(Internal, this);
	    var state = getInternalState(this);

	    try {
	      executor(bind$2(internalResolve, state), bind$2(internalReject, state));
	    } catch (error) {
	      internalReject(state, error);
	    }
	  };

	  PromisePrototype = PromiseConstructor.prototype; // eslint-disable-next-line no-unused-vars -- required for `.length`

	  Internal = function Promise(executor) {
	    setInternalState$2(this, {
	      type: PROMISE,
	      done: false,
	      notified: false,
	      parent: false,
	      reactions: new Queue$1(),
	      rejection: false,
	      state: PENDING,
	      value: undefined
	    });
	  };

	  Internal.prototype = redefineAll$1(PromisePrototype, {
	    // `Promise.prototype.then` method
	    // https://tc39.es/ecma262/#sec-promise.prototype.then
	    // eslint-disable-next-line unicorn/no-thenable -- safe
	    then: function then(onFulfilled, onRejected) {
	      var state = getInternalPromiseState(this);
	      var reaction = newPromiseCapability(speciesConstructor$1(this, PromiseConstructor));
	      state.parent = true;
	      reaction.ok = isCallable$2(onFulfilled) ? onFulfilled : true;
	      reaction.fail = isCallable$2(onRejected) && onRejected;
	      reaction.domain = IS_NODE$1 ? process.domain : undefined;
	      if (state.state == PENDING) state.reactions.add(reaction);else microtask(function () {
	        callReaction(reaction, state);
	      });
	      return reaction.promise;
	    },
	    // `Promise.prototype.catch` method
	    // https://tc39.es/ecma262/#sec-promise.prototype.catch
	    'catch': function (onRejected) {
	      return this.then(undefined, onRejected);
	    }
	  });

	  OwnPromiseCapability = function () {
	    var promise = new Internal();
	    var state = getInternalState(promise);
	    this.promise = promise;
	    this.resolve = bind$2(internalResolve, state);
	    this.reject = bind$2(internalReject, state);
	  };

	  newPromiseCapabilityModule$3.f = newPromiseCapability = function (C) {
	    return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
	  };
	}

	$$f({
	  global: true,
	  wrap: true,
	  forced: FORCED$2
	}, {
	  Promise: PromiseConstructor
	});
	setToStringTag$1(PromiseConstructor, PROMISE, false, true);
	setSpecies$1(PROMISE);
	PromiseWrapper = getBuiltIn$2(PROMISE); // statics

	$$f({
	  target: PROMISE,
	  stat: true,
	  forced: FORCED$2
	}, {
	  // `Promise.reject` method
	  // https://tc39.es/ecma262/#sec-promise.reject
	  reject: function reject(r) {
	    var capability = newPromiseCapability(this);
	    call$2(capability.reject, undefined, r);
	    return capability.promise;
	  }
	});
	$$f({
	  target: PROMISE,
	  stat: true,
	  forced: IS_PURE 
	}, {
	  // `Promise.resolve` method
	  // https://tc39.es/ecma262/#sec-promise.resolve
	  resolve: function resolve(x) {
	    return promiseResolve$1(this === PromiseWrapper ? PromiseConstructor : this, x);
	  }
	});
	$$f({
	  target: PROMISE,
	  stat: true,
	  forced: INCORRECT_ITERATION
	}, {
	  // `Promise.all` method
	  // https://tc39.es/ecma262/#sec-promise.all
	  all: function all(iterable) {
	    var C = this;
	    var capability = newPromiseCapability(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$3(function () {
	      var $promiseResolve = aCallable$5(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate$4(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call$2($promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = value;
	          --remaining || resolve(values);
	        }, reject);
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  },
	  // `Promise.race` method
	  // https://tc39.es/ecma262/#sec-promise.race
	  race: function race(iterable) {
	    var C = this;
	    var capability = newPromiseCapability(C);
	    var reject = capability.reject;
	    var result = perform$3(function () {
	      var $promiseResolve = aCallable$5(C.resolve);
	      iterate$4(iterable, function (promise) {
	        call$2($promiseResolve, C, promise).then(capability.resolve, reject);
	      });
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var $$e = _export;
	var call$1 = functionCall;
	var aCallable$4 = aCallable$b;
	var newPromiseCapabilityModule$2 = newPromiseCapability$2;
	var perform$2 = perform$4;
	var iterate$3 = iterate$6; // `Promise.allSettled` method
	// https://tc39.es/ecma262/#sec-promise.allsettled

	$$e({
	  target: 'Promise',
	  stat: true
	}, {
	  allSettled: function allSettled(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule$2.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$2(function () {
	      var promiseResolve = aCallable$4(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate$3(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call$1(promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = {
	            status: 'fulfilled',
	            value: value
	          };
	          --remaining || resolve(values);
	        }, function (error) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = {
	            status: 'rejected',
	            reason: error
	          };
	          --remaining || resolve(values);
	        });
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var $$d = _export;
	var aCallable$3 = aCallable$b;
	var getBuiltIn$1 = getBuiltIn$c;
	var call = functionCall;
	var newPromiseCapabilityModule$1 = newPromiseCapability$2;
	var perform$1 = perform$4;
	var iterate$2 = iterate$6;
	var PROMISE_ANY_ERROR = 'No one promise resolved'; // `Promise.any` method
	// https://tc39.es/ecma262/#sec-promise.any

	$$d({
	  target: 'Promise',
	  stat: true
	}, {
	  any: function any(iterable) {
	    var C = this;
	    var AggregateError = getBuiltIn$1('AggregateError');
	    var capability = newPromiseCapabilityModule$1.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$1(function () {
	      var promiseResolve = aCallable$3(C.resolve);
	      var errors = [];
	      var counter = 0;
	      var remaining = 1;
	      var alreadyResolved = false;
	      iterate$2(iterable, function (promise) {
	        var index = counter++;
	        var alreadyRejected = false;
	        remaining++;
	        call(promiseResolve, C, promise).then(function (value) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyResolved = true;
	          resolve(value);
	        }, function (error) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyRejected = true;
	          errors[index] = error;
	          --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	        });
	      });
	      --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var $$c = _export;
	var NativePromise = nativePromiseConstructor;
	var fails$6 = fails$v;
	var getBuiltIn = getBuiltIn$c;
	var isCallable$1 = isCallable$k;
	var speciesConstructor = speciesConstructor$2;
	var promiseResolve = promiseResolve$2;

	var NON_GENERIC = !!NativePromise && fails$6(function () {
	  // eslint-disable-next-line unicorn/no-thenable -- required for testing
	  NativePromise.prototype['finally'].call({
	    then: function () {
	      /* empty */
	    }
	  }, function () {
	    /* empty */
	  });
	}); // `Promise.prototype.finally` method
	// https://tc39.es/ecma262/#sec-promise.prototype.finally

	$$c({
	  target: 'Promise',
	  proto: true,
	  real: true,
	  forced: NON_GENERIC
	}, {
	  'finally': function (onFinally) {
	    var C = speciesConstructor(this, getBuiltIn('Promise'));
	    var isFunction = isCallable$1(onFinally);
	    return this.then(isFunction ? function (x) {
	      return promiseResolve(C, onFinally()).then(function () {
	        return x;
	      });
	    } : onFinally, isFunction ? function (e) {
	      return promiseResolve(C, onFinally()).then(function () {
	        throw e;
	      });
	    } : onFinally);
	  }
	}); // makes sure that native promise-based APIs `Promise#finally` properly works with patched `Promise#then`

	var path$4 = path$t;
	var promise$3 = path$4.Promise;

	var parent$l = promise$3;
	var promise$2 = parent$l;

	var parent$k = promise$2;
	var promise$1 = parent$k;

	var $$b = _export;
	var newPromiseCapabilityModule = newPromiseCapability$2;
	var perform = perform$4; // `Promise.try` method
	// https://github.com/tc39/proposal-promise-try

	$$b({
	  target: 'Promise',
	  stat: true,
	  forced: true
	}, {
	  'try': function (callbackfn) {
	    var promiseCapability = newPromiseCapabilityModule.f(this);
	    var result = perform(callbackfn);
	    (result.error ? promiseCapability.reject : promiseCapability.resolve)(result.value);
	    return promiseCapability.promise;
	  }
	});

	var parent$j = promise$1; // TODO: Remove from `core-js@4`

	var promise = parent$j;

	(function (module) {
	  module.exports = promise;
	})(promise$5);

	var reverse$2 = {exports: {}};

	var parent$i = reverse$3;
	var reverse$1 = parent$i;

	var parent$h = reverse$1;
	var reverse = parent$h;

	(function (module) {
	  module.exports = reverse;
	})(reverse$2);

	(function (module) {
	  var _typeof$1 = _typeof.exports["default"];
	  var _Symbol = symbol$5.exports;
	  var _Object$defineProperty = defineProperty$6.exports;
	  var _Object$create = create$4.exports;
	  var _Object$getPrototypeOf = getPrototypeOf$3.exports;
	  var _forEachInstanceProperty = forEach$3.exports;
	  var _Object$setPrototypeOf = setPrototypeOf$6.exports;
	  var _Promise = promise$5.exports;
	  var _reverseInstanceProperty = reverse$2.exports;
	  var _sliceInstanceProperty = slice$6.exports;

	  function _regeneratorRuntime() {
	    /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */

	    module.exports = _regeneratorRuntime = function _regeneratorRuntime() {
	      return exports;
	    }, module.exports.__esModule = true, module.exports["default"] = module.exports;
	    var exports = {},
	        Op = Object.prototype,
	        hasOwn = Op.hasOwnProperty,
	        $Symbol = "function" == typeof _Symbol ? _Symbol : {},
	        iteratorSymbol = $Symbol.iterator || "@@iterator",
	        asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
	        toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

	    function define(obj, key, value) {
	      return _Object$defineProperty(obj, key, {
	        value: value,
	        enumerable: !0,
	        configurable: !0,
	        writable: !0
	      }), obj[key];
	    }

	    try {
	      define({}, "");
	    } catch (err) {
	      define = function define(obj, key, value) {
	        return obj[key] = value;
	      };
	    }

	    function wrap(innerFn, outerFn, self, tryLocsList) {
	      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
	          generator = _Object$create(protoGenerator.prototype),
	          context = new Context(tryLocsList || []);

	      return generator._invoke = function (innerFn, self, context) {
	        var state = "suspendedStart";
	        return function (method, arg) {
	          if ("executing" === state) throw new Error("Generator is already running");

	          if ("completed" === state) {
	            if ("throw" === method) throw arg;
	            return doneResult();
	          }

	          for (context.method = method, context.arg = arg;;) {
	            var delegate = context.delegate;

	            if (delegate) {
	              var delegateResult = maybeInvokeDelegate(delegate, context);

	              if (delegateResult) {
	                if (delegateResult === ContinueSentinel) continue;
	                return delegateResult;
	              }
	            }

	            if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
	              if ("suspendedStart" === state) throw state = "completed", context.arg;
	              context.dispatchException(context.arg);
	            } else "return" === context.method && context.abrupt("return", context.arg);
	            state = "executing";
	            var record = tryCatch(innerFn, self, context);

	            if ("normal" === record.type) {
	              if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
	              return {
	                value: record.arg,
	                done: context.done
	              };
	            }

	            "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
	          }
	        };
	      }(innerFn, self, context), generator;
	    }

	    function tryCatch(fn, obj, arg) {
	      try {
	        return {
	          type: "normal",
	          arg: fn.call(obj, arg)
	        };
	      } catch (err) {
	        return {
	          type: "throw",
	          arg: err
	        };
	      }
	    }

	    exports.wrap = wrap;
	    var ContinueSentinel = {};

	    function Generator() {}

	    function GeneratorFunction() {}

	    function GeneratorFunctionPrototype() {}

	    var IteratorPrototype = {};
	    define(IteratorPrototype, iteratorSymbol, function () {
	      return this;
	    });
	    var getProto = _Object$getPrototypeOf,
	        NativeIteratorPrototype = getProto && getProto(getProto(values([])));
	    NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);

	    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = _Object$create(IteratorPrototype);

	    function defineIteratorMethods(prototype) {
	      var _context;

	      _forEachInstanceProperty(_context = ["next", "throw", "return"]).call(_context, function (method) {
	        define(prototype, method, function (arg) {
	          return this._invoke(method, arg);
	        });
	      });
	    }

	    function AsyncIterator(generator, PromiseImpl) {
	      function invoke(method, arg, resolve, reject) {
	        var record = tryCatch(generator[method], generator, arg);

	        if ("throw" !== record.type) {
	          var result = record.arg,
	              value = result.value;
	          return value && "object" == _typeof$1(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
	            invoke("next", value, resolve, reject);
	          }, function (err) {
	            invoke("throw", err, resolve, reject);
	          }) : PromiseImpl.resolve(value).then(function (unwrapped) {
	            result.value = unwrapped, resolve(result);
	          }, function (error) {
	            return invoke("throw", error, resolve, reject);
	          });
	        }

	        reject(record.arg);
	      }

	      var previousPromise;

	      this._invoke = function (method, arg) {
	        function callInvokeWithMethodAndArg() {
	          return new PromiseImpl(function (resolve, reject) {
	            invoke(method, arg, resolve, reject);
	          });
	        }

	        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
	      };
	    }

	    function maybeInvokeDelegate(delegate, context) {
	      var method = delegate.iterator[context.method];

	      if (undefined === method) {
	        if (context.delegate = null, "throw" === context.method) {
	          if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel;
	          context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method");
	        }

	        return ContinueSentinel;
	      }

	      var record = tryCatch(method, delegate.iterator, context.arg);
	      if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
	      var info = record.arg;
	      return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
	    }

	    function pushTryEntry(locs) {
	      var entry = {
	        tryLoc: locs[0]
	      };
	      1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
	    }

	    function resetTryEntry(entry) {
	      var record = entry.completion || {};
	      record.type = "normal", delete record.arg, entry.completion = record;
	    }

	    function Context(tryLocsList) {
	      this.tryEntries = [{
	        tryLoc: "root"
	      }], _forEachInstanceProperty(tryLocsList).call(tryLocsList, pushTryEntry, this), this.reset(!0);
	    }

	    function values(iterable) {
	      if (iterable) {
	        var iteratorMethod = iterable[iteratorSymbol];
	        if (iteratorMethod) return iteratorMethod.call(iterable);
	        if ("function" == typeof iterable.next) return iterable;

	        if (!isNaN(iterable.length)) {
	          var i = -1,
	              next = function next() {
	            for (; ++i < iterable.length;) {
	              if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
	            }

	            return next.value = undefined, next.done = !0, next;
	          };

	          return next.next = next;
	        }
	      }

	      return {
	        next: doneResult
	      };
	    }

	    function doneResult() {
	      return {
	        value: undefined,
	        done: !0
	      };
	    }

	    return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
	      var ctor = "function" == typeof genFun && genFun.constructor;
	      return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
	    }, exports.mark = function (genFun) {
	      return _Object$setPrototypeOf ? _Object$setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = _Object$create(Gp), genFun;
	    }, exports.awrap = function (arg) {
	      return {
	        __await: arg
	      };
	    }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
	      return this;
	    }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	      void 0 === PromiseImpl && (PromiseImpl = _Promise);
	      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
	      return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
	        return result.done ? result.value : iter.next();
	      });
	    }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
	      return this;
	    }), define(Gp, "toString", function () {
	      return "[object Generator]";
	    }), exports.keys = function (object) {
	      var keys = [];

	      for (var key in object) {
	        keys.push(key);
	      }

	      return _reverseInstanceProperty(keys).call(keys), function next() {
	        for (; keys.length;) {
	          var key = keys.pop();
	          if (key in object) return next.value = key, next.done = !1, next;
	        }

	        return next.done = !0, next;
	      };
	    }, exports.values = values, Context.prototype = {
	      constructor: Context,
	      reset: function reset(skipTempReset) {
	        var _context2;

	        if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, _forEachInstanceProperty(_context2 = this.tryEntries).call(_context2, resetTryEntry), !skipTempReset) for (var name in this) {
	          "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+_sliceInstanceProperty(name).call(name, 1)) && (this[name] = undefined);
	        }
	      },
	      stop: function stop() {
	        this.done = !0;
	        var rootRecord = this.tryEntries[0].completion;
	        if ("throw" === rootRecord.type) throw rootRecord.arg;
	        return this.rval;
	      },
	      dispatchException: function dispatchException(exception) {
	        if (this.done) throw exception;
	        var context = this;

	        function handle(loc, caught) {
	          return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
	        }

	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i],
	              record = entry.completion;
	          if ("root" === entry.tryLoc) return handle("end");

	          if (entry.tryLoc <= this.prev) {
	            var hasCatch = hasOwn.call(entry, "catchLoc"),
	                hasFinally = hasOwn.call(entry, "finallyLoc");

	            if (hasCatch && hasFinally) {
	              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
	              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
	            } else if (hasCatch) {
	              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
	            } else {
	              if (!hasFinally) throw new Error("try statement without catch or finally");
	              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
	            }
	          }
	        }
	      },
	      abrupt: function abrupt(type, arg) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
	            var finallyEntry = entry;
	            break;
	          }
	        }

	        finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
	        var record = finallyEntry ? finallyEntry.completion : {};
	        return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
	      },
	      complete: function complete(record, afterLoc) {
	        if ("throw" === record.type) throw record.arg;
	        return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
	      },
	      finish: function finish(finallyLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
	        }
	      },
	      "catch": function _catch(tryLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc === tryLoc) {
	            var record = entry.completion;

	            if ("throw" === record.type) {
	              var thrown = record.arg;
	              resetTryEntry(entry);
	            }

	            return thrown;
	          }
	        }

	        throw new Error("illegal catch attempt");
	      },
	      delegateYield: function delegateYield(iterable, resultName, nextLoc) {
	        return this.delegate = {
	          iterator: values(iterable),
	          resultName: resultName,
	          nextLoc: nextLoc
	        }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
	      }
	    }, exports;
	  }

	  module.exports = _regeneratorRuntime, module.exports.__esModule = true, module.exports["default"] = module.exports;
	})(regeneratorRuntime$1);

	var runtime = regeneratorRuntime$1.exports();
	var regenerator = runtime; // Copied from https://github.com/facebook/regenerator/blob/main/packages/runtime/runtime.js#L736=

	try {
	  regeneratorRuntime = runtime;
	} catch (accidentalStrictMode) {
	  if (typeof globalThis === "object") {
	    globalThis.regeneratorRuntime = runtime;
	  } else {
	    Function("r", "regeneratorRuntime = r")(runtime);
	  }
	}

	var reduce$3 = {exports: {}};

	var global$5 = global$V;
	var aCallable$2 = aCallable$b;
	var toObject$2 = toObject$e;
	var IndexedObject = indexedObject;
	var lengthOfArrayLike$3 = lengthOfArrayLike$d;
	var TypeError$2 = global$5.TypeError; // `Array.prototype.{ reduce, reduceRight }` methods implementation

	var createMethod = function (IS_RIGHT) {
	  return function (that, callbackfn, argumentsLength, memo) {
	    aCallable$2(callbackfn);
	    var O = toObject$2(that);
	    var self = IndexedObject(O);
	    var length = lengthOfArrayLike$3(O);
	    var index = IS_RIGHT ? length - 1 : 0;
	    var i = IS_RIGHT ? -1 : 1;
	    if (argumentsLength < 2) while (true) {
	      if (index in self) {
	        memo = self[index];
	        index += i;
	        break;
	      }

	      index += i;

	      if (IS_RIGHT ? index < 0 : length <= index) {
	        throw TypeError$2('Reduce of empty array with no initial value');
	      }
	    }

	    for (; IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
	      memo = callbackfn(memo, self[index], index, O);
	    }

	    return memo;
	  };
	};

	var arrayReduce = {
	  // `Array.prototype.reduce` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduce
	  left: createMethod(false),
	  // `Array.prototype.reduceRight` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
	  right: createMethod(true)
	};

	var $$a = _export;
	var $reduce = arrayReduce.left;
	var arrayMethodIsStrict$3 = arrayMethodIsStrict$6;
	var CHROME_VERSION = engineV8Version;
	var IS_NODE = engineIsNode;
	var STRICT_METHOD$3 = arrayMethodIsStrict$3('reduce'); // Chrome 80-82 has a critical bug
	// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982

	var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83; // `Array.prototype.reduce` method
	// https://tc39.es/ecma262/#sec-array.prototype.reduce

	$$a({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$3 || CHROME_BUG
	}, {
	  reduce: function reduce(callbackfn
	  /* , initialValue */
	  ) {
	    var length = arguments.length;
	    return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$a = entryVirtual$o;
	var reduce$2 = entryVirtual$a('Array').reduce;

	var isPrototypeOf$a = objectIsPrototypeOf;
	var method$a = reduce$2;
	var ArrayPrototype$9 = Array.prototype;

	var reduce$1 = function (it) {
	  var own = it.reduce;
	  return it === ArrayPrototype$9 || isPrototypeOf$a(ArrayPrototype$9, it) && own === ArrayPrototype$9.reduce ? method$a : own;
	};

	var parent$g = reduce$1;
	var reduce = parent$g;

	(function (module) {
	  module.exports = reduce;
	})(reduce$3);

	var _reduceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reduce$3.exports);

	var flatMap$3 = {exports: {}};

	var global$4 = global$V;
	var isArray = isArray$d;
	var lengthOfArrayLike$2 = lengthOfArrayLike$d;
	var bind$1 = functionBindContext;
	var TypeError$1 = global$4.TypeError; // `FlattenIntoArray` abstract operation
	// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray

	var flattenIntoArray$1 = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
	  var targetIndex = start;
	  var sourceIndex = 0;
	  var mapFn = mapper ? bind$1(mapper, thisArg) : false;
	  var element, elementLen;

	  while (sourceIndex < sourceLen) {
	    if (sourceIndex in source) {
	      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

	      if (depth > 0 && isArray(element)) {
	        elementLen = lengthOfArrayLike$2(element);
	        targetIndex = flattenIntoArray$1(target, original, element, elementLen, targetIndex, depth - 1) - 1;
	      } else {
	        if (targetIndex >= 0x1FFFFFFFFFFFFF) throw TypeError$1('Exceed the acceptable array length');
	        target[targetIndex] = element;
	      }

	      targetIndex++;
	    }

	    sourceIndex++;
	  }

	  return targetIndex;
	};

	var flattenIntoArray_1 = flattenIntoArray$1;

	var $$9 = _export;
	var flattenIntoArray = flattenIntoArray_1;
	var aCallable$1 = aCallable$b;
	var toObject$1 = toObject$e;
	var lengthOfArrayLike$1 = lengthOfArrayLike$d;
	var arraySpeciesCreate = arraySpeciesCreate$4; // `Array.prototype.flatMap` method
	// https://tc39.es/ecma262/#sec-array.prototype.flatmap

	$$9({
	  target: 'Array',
	  proto: true
	}, {
	  flatMap: function flatMap(callbackfn
	  /* , thisArg */
	  ) {
	    var O = toObject$1(this);
	    var sourceLen = lengthOfArrayLike$1(O);
	    var A;
	    aCallable$1(callbackfn);
	    A = arraySpeciesCreate(O, 0);
	    A.length = flattenIntoArray(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    return A;
	  }
	});

	var entryVirtual$9 = entryVirtual$o;
	var flatMap$2 = entryVirtual$9('Array').flatMap;

	var isPrototypeOf$9 = objectIsPrototypeOf;
	var method$9 = flatMap$2;
	var ArrayPrototype$8 = Array.prototype;

	var flatMap$1 = function (it) {
	  var own = it.flatMap;
	  return it === ArrayPrototype$8 || isPrototypeOf$9(ArrayPrototype$8, it) && own === ArrayPrototype$8.flatMap ? method$9 : own;
	};

	var parent$f = flatMap$1;
	var flatMap = parent$f;

	(function (module) {
	  module.exports = flatMap;
	})(flatMap$3);

	var _flatMapInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(flatMap$3.exports);

	var map$2 = {exports: {}};

	var internalMetadata = {exports: {}};

	var fails$5 = fails$v;
	var arrayBufferNonExtensible = fails$5(function () {
	  if (typeof ArrayBuffer == 'function') {
	    var buffer = new ArrayBuffer(8); // eslint-disable-next-line es/no-object-isextensible, es/no-object-defineproperty -- safe

	    if (Object.isExtensible(buffer)) Object.defineProperty(buffer, 'a', {
	      value: 8
	    });
	  }
	});

	var fails$4 = fails$v;
	var isObject$2 = isObject$j;
	var classof$3 = classofRaw$1;
	var ARRAY_BUFFER_NON_EXTENSIBLE = arrayBufferNonExtensible; // eslint-disable-next-line es/no-object-isextensible -- safe

	var $isExtensible = Object.isExtensible;
	var FAILS_ON_PRIMITIVES = fails$4(function () {
	  $isExtensible(1);
	}); // `Object.isExtensible` method
	// https://tc39.es/ecma262/#sec-object.isextensible

	var objectIsExtensible = FAILS_ON_PRIMITIVES || ARRAY_BUFFER_NON_EXTENSIBLE ? function isExtensible(it) {
	  if (!isObject$2(it)) return false;
	  if (ARRAY_BUFFER_NON_EXTENSIBLE && classof$3(it) == 'ArrayBuffer') return false;
	  return $isExtensible ? $isExtensible(it) : true;
	} : $isExtensible;

	var fails$3 = fails$v;
	var freezing = !fails$3(function () {
	  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
	  return Object.isExtensible(Object.preventExtensions({}));
	});

	var $$8 = _export;
	var uncurryThis$2 = functionUncurryThis;
	var hiddenKeys = hiddenKeys$6;
	var isObject$1 = isObject$j;
	var hasOwn$3 = hasOwnProperty_1;
	var defineProperty$2 = objectDefineProperty.f;
	var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternalModule = objectGetOwnPropertyNamesExternal;
	var isExtensible = objectIsExtensible;
	var uid = uid$4;
	var FREEZING = freezing;
	var REQUIRED = false;
	var METADATA = uid('meta');
	var id = 0;

	var setMetadata = function (it) {
	  defineProperty$2(it, METADATA, {
	    value: {
	      objectID: 'O' + id++,
	      // object ID
	      weakData: {} // weak collections IDs

	    }
	  });
	};

	var fastKey$1 = function (it, create) {
	  // return a primitive with prefix
	  if (!isObject$1(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;

	  if (!hasOwn$3(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible(it)) return 'F'; // not necessary to add metadata

	    if (!create) return 'E'; // add missing metadata

	    setMetadata(it); // return object ID
	  }

	  return it[METADATA].objectID;
	};

	var getWeakData = function (it, create) {
	  if (!hasOwn$3(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible(it)) return true; // not necessary to add metadata

	    if (!create) return false; // add missing metadata

	    setMetadata(it); // return the store of weak collections IDs
	  }

	  return it[METADATA].weakData;
	}; // add metadata on freeze-family methods calling


	var onFreeze = function (it) {
	  if (FREEZING && REQUIRED && isExtensible(it) && !hasOwn$3(it, METADATA)) setMetadata(it);
	  return it;
	};

	var enable = function () {
	  meta.enable = function () {
	    /* empty */
	  };

	  REQUIRED = true;
	  var getOwnPropertyNames = getOwnPropertyNamesModule.f;
	  var splice = uncurryThis$2([].splice);
	  var test = {};
	  test[METADATA] = 1; // prevent exposing of metadata key

	  if (getOwnPropertyNames(test).length) {
	    getOwnPropertyNamesModule.f = function (it) {
	      var result = getOwnPropertyNames(it);

	      for (var i = 0, length = result.length; i < length; i++) {
	        if (result[i] === METADATA) {
	          splice(result, i, 1);
	          break;
	        }
	      }

	      return result;
	    };

	    $$8({
	      target: 'Object',
	      stat: true,
	      forced: true
	    }, {
	      getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
	    });
	  }
	};

	var meta = internalMetadata.exports = {
	  enable: enable,
	  fastKey: fastKey$1,
	  getWeakData: getWeakData,
	  onFreeze: onFreeze
	};
	hiddenKeys[METADATA] = true;

	var $$7 = _export;
	var global$3 = global$V;
	var InternalMetadataModule = internalMetadata.exports;
	var fails$2 = fails$v;
	var createNonEnumerableProperty = createNonEnumerableProperty$8;
	var iterate$1 = iterate$6;
	var anInstance$1 = anInstance$3;
	var isCallable = isCallable$k;
	var isObject = isObject$j;
	var setToStringTag = setToStringTag$6;
	var defineProperty$1 = objectDefineProperty.f;
	var forEach = arrayIteration.forEach;
	var DESCRIPTORS$1 = descriptors;
	var InternalStateModule$1 = internalState;
	var setInternalState$1 = InternalStateModule$1.set;
	var internalStateGetterFor$1 = InternalStateModule$1.getterFor;

	var collection$2 = function (CONSTRUCTOR_NAME, wrapper, common) {
	  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
	  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
	  var ADDER = IS_MAP ? 'set' : 'add';
	  var NativeConstructor = global$3[CONSTRUCTOR_NAME];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  var exported = {};
	  var Constructor;

	  if (!DESCRIPTORS$1 || !isCallable(NativeConstructor) || !(IS_WEAK || NativePrototype.forEach && !fails$2(function () {
	    new NativeConstructor().entries().next();
	  }))) {
	    // create collection constructor
	    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
	    InternalMetadataModule.enable();
	  } else {
	    Constructor = wrapper(function (target, iterable) {
	      setInternalState$1(anInstance$1(target, Prototype), {
	        type: CONSTRUCTOR_NAME,
	        collection: new NativeConstructor()
	      });
	      if (iterable != undefined) iterate$1(iterable, target[ADDER], {
	        that: target,
	        AS_ENTRIES: IS_MAP
	      });
	    });
	    var Prototype = Constructor.prototype;
	    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);
	    forEach(['add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries'], function (KEY) {
	      var IS_ADDER = KEY == 'add' || KEY == 'set';

	      if (KEY in NativePrototype && !(IS_WEAK && KEY == 'clear')) {
	        createNonEnumerableProperty(Prototype, KEY, function (a, b) {
	          var collection = getInternalState(this).collection;
	          if (!IS_ADDER && IS_WEAK && !isObject(a)) return KEY == 'get' ? undefined : false;
	          var result = collection[KEY](a === 0 ? 0 : a, b);
	          return IS_ADDER ? this : result;
	        });
	      }
	    });
	    IS_WEAK || defineProperty$1(Prototype, 'size', {
	      configurable: true,
	      get: function () {
	        return getInternalState(this).collection.size;
	      }
	    });
	  }

	  setToStringTag(Constructor, CONSTRUCTOR_NAME, false, true);
	  exported[CONSTRUCTOR_NAME] = Constructor;
	  $$7({
	    global: true,
	    forced: true
	  }, exported);
	  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
	  return Constructor;
	};

	var defineProperty = objectDefineProperty.f;
	var create = objectCreate;
	var redefineAll = redefineAll$2;
	var bind = functionBindContext;
	var anInstance = anInstance$3;
	var iterate = iterate$6;
	var defineIterator = defineIterator$3;
	var setSpecies = setSpecies$2;
	var DESCRIPTORS = descriptors;
	var fastKey = internalMetadata.exports.fastKey;
	var InternalStateModule = internalState;
	var setInternalState = InternalStateModule.set;
	var internalStateGetterFor = InternalStateModule.getterFor;
	var collectionStrong$2 = {
	  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var Constructor = wrapper(function (that, iterable) {
	      anInstance(that, Prototype);
	      setInternalState(that, {
	        type: CONSTRUCTOR_NAME,
	        index: create(null),
	        first: undefined,
	        last: undefined,
	        size: 0
	      });
	      if (!DESCRIPTORS) that.size = 0;
	      if (iterable != undefined) iterate(iterable, that[ADDER], {
	        that: that,
	        AS_ENTRIES: IS_MAP
	      });
	    });
	    var Prototype = Constructor.prototype;
	    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

	    var define = function (that, key, value) {
	      var state = getInternalState(that);
	      var entry = getEntry(that, key);
	      var previous, index; // change existing entry

	      if (entry) {
	        entry.value = value; // create new entry
	      } else {
	        state.last = entry = {
	          index: index = fastKey(key, true),
	          key: key,
	          value: value,
	          previous: previous = state.last,
	          next: undefined,
	          removed: false
	        };
	        if (!state.first) state.first = entry;
	        if (previous) previous.next = entry;
	        if (DESCRIPTORS) state.size++;else that.size++; // add to index

	        if (index !== 'F') state.index[index] = entry;
	      }

	      return that;
	    };

	    var getEntry = function (that, key) {
	      var state = getInternalState(that); // fast case

	      var index = fastKey(key);
	      var entry;
	      if (index !== 'F') return state.index[index]; // frozen object case

	      for (entry = state.first; entry; entry = entry.next) {
	        if (entry.key == key) return entry;
	      }
	    };

	    redefineAll(Prototype, {
	      // `{ Map, Set }.prototype.clear()` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.clear
	      // https://tc39.es/ecma262/#sec-set.prototype.clear
	      clear: function clear() {
	        var that = this;
	        var state = getInternalState(that);
	        var data = state.index;
	        var entry = state.first;

	        while (entry) {
	          entry.removed = true;
	          if (entry.previous) entry.previous = entry.previous.next = undefined;
	          delete data[entry.index];
	          entry = entry.next;
	        }

	        state.first = state.last = undefined;
	        if (DESCRIPTORS) state.size = 0;else that.size = 0;
	      },
	      // `{ Map, Set }.prototype.delete(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.delete
	      // https://tc39.es/ecma262/#sec-set.prototype.delete
	      'delete': function (key) {
	        var that = this;
	        var state = getInternalState(that);
	        var entry = getEntry(that, key);

	        if (entry) {
	          var next = entry.next;
	          var prev = entry.previous;
	          delete state.index[entry.index];
	          entry.removed = true;
	          if (prev) prev.next = next;
	          if (next) next.previous = prev;
	          if (state.first == entry) state.first = next;
	          if (state.last == entry) state.last = prev;
	          if (DESCRIPTORS) state.size--;else that.size--;
	        }

	        return !!entry;
	      },
	      // `{ Map, Set }.prototype.forEach(callbackfn, thisArg = undefined)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.foreach
	      // https://tc39.es/ecma262/#sec-set.prototype.foreach
	      forEach: function forEach(callbackfn
	      /* , that = undefined */
	      ) {
	        var state = getInternalState(this);
	        var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	        var entry;

	        while (entry = entry ? entry.next : state.first) {
	          boundFunction(entry.value, entry.key, this); // revert to the last existing entry

	          while (entry && entry.removed) entry = entry.previous;
	        }
	      },
	      // `{ Map, Set}.prototype.has(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.has
	      // https://tc39.es/ecma262/#sec-set.prototype.has
	      has: function has(key) {
	        return !!getEntry(this, key);
	      }
	    });
	    redefineAll(Prototype, IS_MAP ? {
	      // `Map.prototype.get(key)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.get
	      get: function get(key) {
	        var entry = getEntry(this, key);
	        return entry && entry.value;
	      },
	      // `Map.prototype.set(key, value)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.set
	      set: function set(key, value) {
	        return define(this, key === 0 ? 0 : key, value);
	      }
	    } : {
	      // `Set.prototype.add(value)` method
	      // https://tc39.es/ecma262/#sec-set.prototype.add
	      add: function add(value) {
	        return define(this, value = value === 0 ? 0 : value, value);
	      }
	    });
	    if (DESCRIPTORS) defineProperty(Prototype, 'size', {
	      get: function () {
	        return getInternalState(this).size;
	      }
	    });
	    return Constructor;
	  },
	  setStrong: function (Constructor, CONSTRUCTOR_NAME, IS_MAP) {
	    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
	    var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
	    var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME); // `{ Map, Set }.prototype.{ keys, values, entries, @@iterator }()` methods
	    // https://tc39.es/ecma262/#sec-map.prototype.entries
	    // https://tc39.es/ecma262/#sec-map.prototype.keys
	    // https://tc39.es/ecma262/#sec-map.prototype.values
	    // https://tc39.es/ecma262/#sec-map.prototype-@@iterator
	    // https://tc39.es/ecma262/#sec-set.prototype.entries
	    // https://tc39.es/ecma262/#sec-set.prototype.keys
	    // https://tc39.es/ecma262/#sec-set.prototype.values
	    // https://tc39.es/ecma262/#sec-set.prototype-@@iterator

	    defineIterator(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
	      setInternalState(this, {
	        type: ITERATOR_NAME,
	        target: iterated,
	        state: getInternalCollectionState(iterated),
	        kind: kind,
	        last: undefined
	      });
	    }, function () {
	      var state = getInternalIteratorState(this);
	      var kind = state.kind;
	      var entry = state.last; // revert to the last existing entry

	      while (entry && entry.removed) entry = entry.previous; // get next entry


	      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
	        // or finish the iteration
	        state.target = undefined;
	        return {
	          value: undefined,
	          done: true
	        };
	      } // return step by kind


	      if (kind == 'keys') return {
	        value: entry.key,
	        done: false
	      };
	      if (kind == 'values') return {
	        value: entry.value,
	        done: false
	      };
	      return {
	        value: [entry.key, entry.value],
	        done: false
	      };
	    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true); // `{ Map, Set }.prototype[@@species]` accessors
	    // https://tc39.es/ecma262/#sec-get-map-@@species
	    // https://tc39.es/ecma262/#sec-get-set-@@species

	    setSpecies(CONSTRUCTOR_NAME);
	  }
	};

	var collection$1 = collection$2;
	var collectionStrong$1 = collectionStrong$2; // `Map` constructor
	// https://tc39.es/ecma262/#sec-map-objects

	collection$1('Map', function (init) {
	  return function Map() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong$1);

	var path$3 = path$t;
	var map$1 = path$3.Map;

	var parent$e = map$1;
	var map = parent$e;

	(function (module) {
	  module.exports = map;
	})(map$2);

	var _Map = /*@__PURE__*/getDefaultExportFromCjs(map$2.exports);

	var set$2 = {exports: {}};

	var collection = collection$2;
	var collectionStrong = collectionStrong$2; // `Set` constructor
	// https://tc39.es/ecma262/#sec-set-objects

	collection('Set', function (init) {
	  return function Set() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong);

	var path$2 = path$t;
	var set$1 = path$2.Set;

	var parent$d = set$1;
	var set = parent$d;

	(function (module) {
	  module.exports = set;
	})(set$2);

	var _Set = /*@__PURE__*/getDefaultExportFromCjs(set$2.exports);

	var iterator = {exports: {}};

	(function (module) {
	  module.exports = iterator$3;
	})(iterator);

	var _Symbol$iterator2 = /*@__PURE__*/getDefaultExportFromCjs(iterator.exports);

	var getIterator$4 = {exports: {}};

	var getIterator$3 = getIterator$7;
	var getIterator_1 = getIterator$3;

	var parent$c = getIterator_1;
	var getIterator$2 = parent$c;

	var parent$b = getIterator$2;
	var getIterator$1 = parent$b;

	var parent$a = getIterator$1;
	var getIterator = parent$a;

	(function (module) {
	  module.exports = getIterator;
	})(getIterator$4);

	var _getIterator = /*@__PURE__*/getDefaultExportFromCjs(getIterator$4.exports);

	var sort$3 = {exports: {}};

	var arraySlice = arraySliceSimple;
	var floor = Math.floor;

	var mergeSort = function (array, comparefn) {
	  var length = array.length;
	  var middle = floor(length / 2);
	  return length < 8 ? insertionSort(array, comparefn) : merge(array, mergeSort(arraySlice(array, 0, middle), comparefn), mergeSort(arraySlice(array, middle), comparefn), comparefn);
	};

	var insertionSort = function (array, comparefn) {
	  var length = array.length;
	  var i = 1;
	  var element, j;

	  while (i < length) {
	    j = i;
	    element = array[i];

	    while (j && comparefn(array[j - 1], element) > 0) {
	      array[j] = array[--j];
	    }

	    if (j !== i++) array[j] = element;
	  }

	  return array;
	};

	var merge = function (array, left, right, comparefn) {
	  var llength = left.length;
	  var rlength = right.length;
	  var lindex = 0;
	  var rindex = 0;

	  while (lindex < llength || rindex < rlength) {
	    array[lindex + rindex] = lindex < llength && rindex < rlength ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++] : lindex < llength ? left[lindex++] : right[rindex++];
	  }

	  return array;
	};

	var arraySort = mergeSort;

	var userAgent$1 = engineUserAgent;
	var firefox = userAgent$1.match(/firefox\/(\d+)/i);
	var engineFfVersion = !!firefox && +firefox[1];

	var UA = engineUserAgent;
	var engineIsIeOrEdge = /MSIE|Trident/.test(UA);

	var userAgent = engineUserAgent;
	var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);
	var engineWebkitVersion = !!webkit && +webkit[1];

	var $$6 = _export;
	var uncurryThis$1 = functionUncurryThis;
	var aCallable = aCallable$b;
	var toObject = toObject$e;
	var lengthOfArrayLike = lengthOfArrayLike$d;
	var toString$2 = toString$a;
	var fails$1 = fails$v;
	var internalSort = arraySort;
	var arrayMethodIsStrict$2 = arrayMethodIsStrict$6;
	var FF = engineFfVersion;
	var IE_OR_EDGE = engineIsIeOrEdge;
	var V8 = engineV8Version;
	var WEBKIT = engineWebkitVersion;
	var test = [];
	var un$Sort = uncurryThis$1(test.sort);
	var push = uncurryThis$1(test.push); // IE8-

	var FAILS_ON_UNDEFINED = fails$1(function () {
	  test.sort(undefined);
	}); // V8 bug

	var FAILS_ON_NULL = fails$1(function () {
	  test.sort(null);
	}); // Old WebKit

	var STRICT_METHOD$2 = arrayMethodIsStrict$2('sort');
	var STABLE_SORT = !fails$1(function () {
	  // feature detection can be too slow, so check engines versions
	  if (V8) return V8 < 70;
	  if (FF && FF > 3) return;
	  if (IE_OR_EDGE) return true;
	  if (WEBKIT) return WEBKIT < 603;
	  var result = '';
	  var code, chr, value, index; // generate an array with more 512 elements (Chakra and old V8 fails only in this case)

	  for (code = 65; code < 76; code++) {
	    chr = String.fromCharCode(code);

	    switch (code) {
	      case 66:
	      case 69:
	      case 70:
	      case 72:
	        value = 3;
	        break;

	      case 68:
	      case 71:
	        value = 4;
	        break;

	      default:
	        value = 2;
	    }

	    for (index = 0; index < 47; index++) {
	      test.push({
	        k: chr + index,
	        v: value
	      });
	    }
	  }

	  test.sort(function (a, b) {
	    return b.v - a.v;
	  });

	  for (index = 0; index < test.length; index++) {
	    chr = test[index].k.charAt(0);
	    if (result.charAt(result.length - 1) !== chr) result += chr;
	  }

	  return result !== 'DGBEFHACIJK';
	});
	var FORCED$1 = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD$2 || !STABLE_SORT;

	var getSortCompare = function (comparefn) {
	  return function (x, y) {
	    if (y === undefined) return -1;
	    if (x === undefined) return 1;
	    if (comparefn !== undefined) return +comparefn(x, y) || 0;
	    return toString$2(x) > toString$2(y) ? 1 : -1;
	  };
	}; // `Array.prototype.sort` method
	// https://tc39.es/ecma262/#sec-array.prototype.sort


	$$6({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$1
	}, {
	  sort: function sort(comparefn) {
	    if (comparefn !== undefined) aCallable(comparefn);
	    var array = toObject(this);
	    if (STABLE_SORT) return comparefn === undefined ? un$Sort(array) : un$Sort(array, comparefn);
	    var items = [];
	    var arrayLength = lengthOfArrayLike(array);
	    var itemsLength, index;

	    for (index = 0; index < arrayLength; index++) {
	      if (index in array) push(items, array[index]);
	    }

	    internalSort(items, getSortCompare(comparefn));
	    itemsLength = items.length;
	    index = 0;

	    while (index < itemsLength) array[index] = items[index++];

	    while (index < arrayLength) delete array[index++];

	    return array;
	  }
	});

	var entryVirtual$8 = entryVirtual$o;
	var sort$2 = entryVirtual$8('Array').sort;

	var isPrototypeOf$8 = objectIsPrototypeOf;
	var method$8 = sort$2;
	var ArrayPrototype$7 = Array.prototype;

	var sort$1 = function (it) {
	  var own = it.sort;
	  return it === ArrayPrototype$7 || isPrototypeOf$8(ArrayPrototype$7, it) && own === ArrayPrototype$7.sort ? method$8 : own;
	};

	var parent$9 = sort$1;
	var sort = parent$9;

	(function (module) {
	  module.exports = sort;
	})(sort$3);

	var _sortInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(sort$3.exports);

	var some$3 = {exports: {}};

	var $$5 = _export;
	var $some = arrayIteration.some;
	var arrayMethodIsStrict$1 = arrayMethodIsStrict$6;
	var STRICT_METHOD$1 = arrayMethodIsStrict$1('some'); // `Array.prototype.some` method
	// https://tc39.es/ecma262/#sec-array.prototype.some

	$$5({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$1
	}, {
	  some: function some(callbackfn
	  /* , thisArg */
	  ) {
	    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$7 = entryVirtual$o;
	var some$2 = entryVirtual$7('Array').some;

	var isPrototypeOf$7 = objectIsPrototypeOf;
	var method$7 = some$2;
	var ArrayPrototype$6 = Array.prototype;

	var some$1 = function (it) {
	  var own = it.some;
	  return it === ArrayPrototype$6 || isPrototypeOf$7(ArrayPrototype$6, it) && own === ArrayPrototype$6.some ? method$7 : own;
	};

	var parent$8 = some$1;
	var some = parent$8;

	(function (module) {
	  module.exports = some;
	})(some$3);

	var _someInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(some$3.exports);

	var keys$3 = {exports: {}};

	var entryVirtual$6 = entryVirtual$o;
	var keys$2 = entryVirtual$6('Array').keys;

	var parent$7 = keys$2;
	var keys$1 = parent$7;

	var classof$2 = classof$f;
	var hasOwn$2 = hasOwnProperty_1;
	var isPrototypeOf$6 = objectIsPrototypeOf;
	var method$6 = keys$1;
	var ArrayPrototype$5 = Array.prototype;
	var DOMIterables$2 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var keys = function (it) {
	  var own = it.keys;
	  return it === ArrayPrototype$5 || isPrototypeOf$6(ArrayPrototype$5, it) && own === ArrayPrototype$5.keys || hasOwn$2(DOMIterables$2, classof$2(it)) ? method$6 : own;
	};

	(function (module) {
	  module.exports = keys;
	})(keys$3);

	var _keysInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(keys$3.exports);

	var values$3 = {exports: {}};

	var entryVirtual$5 = entryVirtual$o;
	var values$2 = entryVirtual$5('Array').values;

	var parent$6 = values$2;
	var values$1 = parent$6;

	var classof$1 = classof$f;
	var hasOwn$1 = hasOwnProperty_1;
	var isPrototypeOf$5 = objectIsPrototypeOf;
	var method$5 = values$1;
	var ArrayPrototype$4 = Array.prototype;
	var DOMIterables$1 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var values = function (it) {
	  var own = it.values;
	  return it === ArrayPrototype$4 || isPrototypeOf$5(ArrayPrototype$4, it) && own === ArrayPrototype$4.values || hasOwn$1(DOMIterables$1, classof$1(it)) ? method$5 : own;
	};

	(function (module) {
	  module.exports = values;
	})(values$3);

	var _valuesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(values$3.exports);

	var entries$3 = {exports: {}};

	var entryVirtual$4 = entryVirtual$o;
	var entries$2 = entryVirtual$4('Array').entries;

	var parent$5 = entries$2;
	var entries$1 = parent$5;

	var classof = classof$f;
	var hasOwn = hasOwnProperty_1;
	var isPrototypeOf$4 = objectIsPrototypeOf;
	var method$4 = entries$1;
	var ArrayPrototype$3 = Array.prototype;
	var DOMIterables = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var entries = function (it) {
	  var own = it.entries;
	  return it === ArrayPrototype$3 || isPrototypeOf$4(ArrayPrototype$3, it) && own === ArrayPrototype$3.entries || hasOwn(DOMIterables, classof(it)) ? method$4 : own;
	};

	(function (module) {
	  module.exports = entries;
	})(entries$3);

	var _entriesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(entries$3.exports);

	// Unique ID creation requires a high quality random # generator. In the browser we therefore
	// require the crypto API and do not support built-in fallback to lower quality random number
	// generators (like Math.random()).
	// getRandomValues needs to be invoked in a context where "this" is a Crypto implementation. Also,
	// find the complete implementation of crypto (msCrypto) on IE11.
	var getRandomValues = typeof crypto != 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto != 'undefined' && typeof msCrypto.getRandomValues == 'function' && msCrypto.getRandomValues.bind(msCrypto);
	var rnds8 = new Uint8Array(16); // eslint-disable-line no-undef

	function rng() {
	  if (!getRandomValues) {
	    throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
	  }

	  return getRandomValues(rnds8);
	}

	/**
	 * Convert array of 16 byte values to UUID string format of the form:
	 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
	 */
	var byteToHex = [];

	for (var i$1 = 0; i$1 < 256; ++i$1) {
	  byteToHex[i$1] = (i$1 + 0x100).toString(16).substr(1);
	}

	function bytesToUuid(buf, offset) {
	  var i = offset || 0;
	  var bth = byteToHex; // join used to fix memory issue caused by concatenation: https://bugs.chromium.org/p/v8/issues/detail?id=3175#c4

	  return [bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]]].join('');
	}

	function uuidToBytes(uuid) {
	  // Note: We assume we're being passed a valid uuid string
	  var bytes = [];
	  uuid.replace(/[a-fA-F0-9]{2}/g, function (hex) {
	    bytes.push(parseInt(hex, 16));
	  });
	  return bytes;
	}

	function stringToBytes(str) {
	  str = unescape(encodeURIComponent(str)); // UTF8 escape

	  var bytes = new Array(str.length);

	  for (var i = 0; i < str.length; i++) {
	    bytes[i] = str.charCodeAt(i);
	  }

	  return bytes;
	}

	var DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
	var URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
	function v35 (name, version, hashfunc) {
	  var generateUUID = function generateUUID(value, namespace, buf, offset) {
	    var off = buf && offset || 0;
	    if (typeof value == 'string') value = stringToBytes(value);
	    if (typeof namespace == 'string') namespace = uuidToBytes(namespace);
	    if (!Array.isArray(value)) throw TypeError('value must be an array of bytes');
	    if (!Array.isArray(namespace) || namespace.length !== 16) throw TypeError('namespace must be uuid string or an Array of 16 byte values'); // Per 4.3

	    var bytes = hashfunc(namespace.concat(value));
	    bytes[6] = bytes[6] & 0x0f | version;
	    bytes[8] = bytes[8] & 0x3f | 0x80;

	    if (buf) {
	      for (var idx = 0; idx < 16; ++idx) {
	        buf[off + idx] = bytes[idx];
	      }
	    }

	    return buf || bytesToUuid(bytes);
	  }; // Function#name is not settable on some platforms (#270)


	  try {
	    generateUUID.name = name;
	  } catch (err) {} // For CommonJS default export support


	  generateUUID.DNS = DNS;
	  generateUUID.URL = URL;
	  return generateUUID;
	}

	/*
	 * Browser-compatible JavaScript MD5
	 *
	 * Modification of JavaScript MD5
	 * https://github.com/blueimp/JavaScript-MD5
	 *
	 * Copyright 2011, Sebastian Tschan
	 * https://blueimp.net
	 *
	 * Licensed under the MIT license:
	 * https://opensource.org/licenses/MIT
	 *
	 * Based on
	 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
	 * Digest Algorithm, as defined in RFC 1321.
	 * Version 2.2 Copyright (C) Paul Johnston 1999 - 2009
	 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
	 * Distributed under the BSD License
	 * See http://pajhome.org.uk/crypt/md5 for more info.
	 */
	function md5(bytes) {
	  if (typeof bytes == 'string') {
	    var msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

	    bytes = new Array(msg.length);

	    for (var i = 0; i < msg.length; i++) {
	      bytes[i] = msg.charCodeAt(i);
	    }
	  }

	  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
	}
	/*
	 * Convert an array of little-endian words to an array of bytes
	 */


	function md5ToHexEncodedArray(input) {
	  var i;
	  var x;
	  var output = [];
	  var length32 = input.length * 32;
	  var hexTab = '0123456789abcdef';
	  var hex;

	  for (i = 0; i < length32; i += 8) {
	    x = input[i >> 5] >>> i % 32 & 0xff;
	    hex = parseInt(hexTab.charAt(x >>> 4 & 0x0f) + hexTab.charAt(x & 0x0f), 16);
	    output.push(hex);
	  }

	  return output;
	}
	/*
	 * Calculate the MD5 of an array of little-endian words, and a bit length.
	 */


	function wordsToMd5(x, len) {
	  /* append padding */
	  x[len >> 5] |= 0x80 << len % 32;
	  x[(len + 64 >>> 9 << 4) + 14] = len;
	  var i;
	  var olda;
	  var oldb;
	  var oldc;
	  var oldd;
	  var a = 1732584193;
	  var b = -271733879;
	  var c = -1732584194;
	  var d = 271733878;

	  for (i = 0; i < x.length; i += 16) {
	    olda = a;
	    oldb = b;
	    oldc = c;
	    oldd = d;
	    a = md5ff(a, b, c, d, x[i], 7, -680876936);
	    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
	    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
	    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
	    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
	    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
	    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
	    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
	    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
	    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
	    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
	    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
	    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
	    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
	    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
	    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
	    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
	    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
	    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
	    b = md5gg(b, c, d, a, x[i], 20, -373897302);
	    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
	    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
	    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
	    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
	    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
	    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
	    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
	    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
	    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
	    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
	    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
	    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
	    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
	    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
	    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
	    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
	    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
	    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
	    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
	    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
	    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
	    d = md5hh(d, a, b, c, x[i], 11, -358537222);
	    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
	    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
	    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
	    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
	    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
	    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
	    a = md5ii(a, b, c, d, x[i], 6, -198630844);
	    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
	    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
	    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
	    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
	    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
	    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
	    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
	    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
	    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
	    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
	    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
	    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
	    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
	    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
	    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
	    a = safeAdd(a, olda);
	    b = safeAdd(b, oldb);
	    c = safeAdd(c, oldc);
	    d = safeAdd(d, oldd);
	  }

	  return [a, b, c, d];
	}
	/*
	 * Convert an array bytes to an array of little-endian words
	 * Characters >255 have their high-byte silently ignored.
	 */


	function bytesToWords(input) {
	  var i;
	  var output = [];
	  output[(input.length >> 2) - 1] = undefined;

	  for (i = 0; i < output.length; i += 1) {
	    output[i] = 0;
	  }

	  var length8 = input.length * 8;

	  for (i = 0; i < length8; i += 8) {
	    output[i >> 5] |= (input[i / 8] & 0xff) << i % 32;
	  }

	  return output;
	}
	/*
	 * Add integers, wrapping at 2^32. This uses 16-bit operations internally
	 * to work around bugs in some JS interpreters.
	 */


	function safeAdd(x, y) {
	  var lsw = (x & 0xffff) + (y & 0xffff);
	  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
	  return msw << 16 | lsw & 0xffff;
	}
	/*
	 * Bitwise rotate a 32-bit number to the left.
	 */


	function bitRotateLeft(num, cnt) {
	  return num << cnt | num >>> 32 - cnt;
	}
	/*
	 * These functions implement the four basic operations the algorithm uses.
	 */


	function md5cmn(q, a, b, x, s, t) {
	  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
	}

	function md5ff(a, b, c, d, x, s, t) {
	  return md5cmn(b & c | ~b & d, a, b, x, s, t);
	}

	function md5gg(a, b, c, d, x, s, t) {
	  return md5cmn(b & d | c & ~d, a, b, x, s, t);
	}

	function md5hh(a, b, c, d, x, s, t) {
	  return md5cmn(b ^ c ^ d, a, b, x, s, t);
	}

	function md5ii(a, b, c, d, x, s, t) {
	  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
	}

	v35('v3', 0x30, md5);

	function v4(options, buf, offset) {
	  var i = buf && offset || 0;

	  if (typeof options == 'string') {
	    buf = options === 'binary' ? new Array(16) : null;
	    options = null;
	  }

	  options = options || {};
	  var rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

	  rnds[6] = rnds[6] & 0x0f | 0x40;
	  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

	  if (buf) {
	    for (var ii = 0; ii < 16; ++ii) {
	      buf[i + ii] = rnds[ii];
	    }
	  }

	  return buf || bytesToUuid(rnds);
	}

	// Adapted from Chris Veness' SHA1 code at
	// http://www.movable-type.co.uk/scripts/sha1.html
	function f(s, x, y, z) {
	  switch (s) {
	    case 0:
	      return x & y ^ ~x & z;

	    case 1:
	      return x ^ y ^ z;

	    case 2:
	      return x & y ^ x & z ^ y & z;

	    case 3:
	      return x ^ y ^ z;
	  }
	}

	function ROTL(x, n) {
	  return x << n | x >>> 32 - n;
	}

	function sha1(bytes) {
	  var K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];
	  var H = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];

	  if (typeof bytes == 'string') {
	    var msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

	    bytes = new Array(msg.length);

	    for (var i = 0; i < msg.length; i++) {
	      bytes[i] = msg.charCodeAt(i);
	    }
	  }

	  bytes.push(0x80);
	  var l = bytes.length / 4 + 2;
	  var N = Math.ceil(l / 16);
	  var M = new Array(N);

	  for (var i = 0; i < N; i++) {
	    M[i] = new Array(16);

	    for (var j = 0; j < 16; j++) {
	      M[i][j] = bytes[i * 64 + j * 4] << 24 | bytes[i * 64 + j * 4 + 1] << 16 | bytes[i * 64 + j * 4 + 2] << 8 | bytes[i * 64 + j * 4 + 3];
	    }
	  }

	  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
	  M[N - 1][14] = Math.floor(M[N - 1][14]);
	  M[N - 1][15] = (bytes.length - 1) * 8 & 0xffffffff;

	  for (var i = 0; i < N; i++) {
	    var W = new Array(80);

	    for (var t = 0; t < 16; t++) {
	      W[t] = M[i][t];
	    }

	    for (var t = 16; t < 80; t++) {
	      W[t] = ROTL(W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16], 1);
	    }

	    var a = H[0];
	    var b = H[1];
	    var c = H[2];
	    var d = H[3];
	    var e = H[4];

	    for (var t = 0; t < 80; t++) {
	      var s = Math.floor(t / 20);
	      var T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[t] >>> 0;
	      e = d;
	      d = c;
	      c = ROTL(b, 30) >>> 0;
	      b = a;
	      a = T;
	    }

	    H[0] = H[0] + a >>> 0;
	    H[1] = H[1] + b >>> 0;
	    H[2] = H[2] + c >>> 0;
	    H[3] = H[3] + d >>> 0;
	    H[4] = H[4] + e >>> 0;
	  }

	  return [H[0] >> 24 & 0xff, H[0] >> 16 & 0xff, H[0] >> 8 & 0xff, H[0] & 0xff, H[1] >> 24 & 0xff, H[1] >> 16 & 0xff, H[1] >> 8 & 0xff, H[1] & 0xff, H[2] >> 24 & 0xff, H[2] >> 16 & 0xff, H[2] >> 8 & 0xff, H[2] & 0xff, H[3] >> 24 & 0xff, H[3] >> 16 & 0xff, H[3] >> 8 & 0xff, H[3] & 0xff, H[4] >> 24 & 0xff, H[4] >> 16 & 0xff, H[4] >> 8 & 0xff, H[4] & 0xff];
	}

	v35('v5', 0x50, sha1);

	var _Symbol$iterator;

	function ownKeys$1(object, enumerableOnly) { var keys = _Object$keys(object); if (_Object$getOwnPropertySymbols) { var symbols = _Object$getOwnPropertySymbols(object); enumerableOnly && (symbols = _filterInstanceProperty(symbols).call(symbols, function (sym) { return _Object$getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$1(target) { for (var i = 1; i < arguments.length; i++) { var _context32, _context33; var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? _forEachInstanceProperty(_context32 = ownKeys$1(Object(source), !0)).call(_context32, function (key) { _defineProperty(target, key, source[key]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(target, _Object$getOwnPropertyDescriptors(source)) : _forEachInstanceProperty(_context33 = ownKeys$1(Object(source))).call(_context33, function (key) { _Object$defineProperty$1(target, key, _Object$getOwnPropertyDescriptor(source, key)); }); } return target; }

	function _createSuper$d(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$d(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$d() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	function _createForOfIteratorHelper$6(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray(o) || (it = _unsupportedIterableToArray$6(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$6(o, minLen) { var _context31; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$6(o, minLen); var n = _sliceInstanceProperty(_context31 = Object.prototype.toString.call(o)).call(_context31, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$6(o, minLen); }

	function _arrayLikeToArray$6(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
	/**
	 * Create new data pipe.
	 *
	 * @param from - The source data set or data view.
	 * @remarks
	 * Example usage:
	 * ```typescript
	 * interface AppItem {
	 *   whoami: string;
	 *   appData: unknown;
	 *   visData: VisItem;
	 * }
	 * interface VisItem {
	 *   id: number;
	 *   label: string;
	 *   color: string;
	 *   x: number;
	 *   y: number;
	 * }
	 *
	 * const ds1 = new DataSet<AppItem, "whoami">([], { fieldId: "whoami" });
	 * const ds2 = new DataSet<VisItem, "id">();
	 *
	 * const pipe = createNewDataPipeFrom(ds1)
	 *   .filter((item): boolean => item.enabled === true)
	 *   .map<VisItem, "id">((item): VisItem => item.visData)
	 *   .to(ds2);
	 *
	 * pipe.start();
	 * ```
	 * @returns A factory whose methods can be used to configure the pipe.
	 */

	function createNewDataPipeFrom(from) {
	  return new DataPipeUnderConstruction(from);
	}
	/**
	 * Internal implementation of the pipe. This should be accessible only through
	 * `createNewDataPipeFrom` from the outside.
	 *
	 * @typeParam SI - Source item type.
	 * @typeParam SP - Source item type's id property name.
	 * @typeParam TI - Target item type.
	 * @typeParam TP - Target item type's id property name.
	 */


	var SimpleDataPipe = /*#__PURE__*/function () {
	  /**
	   * Bound listeners for use with `DataInterface['on' | 'off']`.
	   */

	  /**
	   * Create a new data pipe.
	   *
	   * @param _source - The data set or data view that will be observed.
	   * @param _transformers - An array of transforming functions to be used to
	   * filter or transform the items in the pipe.
	   * @param _target - The data set or data view that will receive the items.
	   */
	  function SimpleDataPipe(_source, _transformers, _target) {
	    var _context, _context2, _context3;

	    _classCallCheck(this, SimpleDataPipe);

	    _defineProperty(this, "_source", void 0);

	    _defineProperty(this, "_transformers", void 0);

	    _defineProperty(this, "_target", void 0);

	    _defineProperty(this, "_listeners", {
	      add: _bindInstanceProperty$1(_context = this._add).call(_context, this),
	      remove: _bindInstanceProperty$1(_context2 = this._remove).call(_context2, this),
	      update: _bindInstanceProperty$1(_context3 = this._update).call(_context3, this)
	    });

	    this._source = _source;
	    this._transformers = _transformers;
	    this._target = _target;
	  }
	  /** @inheritDoc */


	  _createClass(SimpleDataPipe, [{
	    key: "all",
	    value: function all() {
	      this._target.update(this._transformItems(this._source.get()));

	      return this;
	    }
	    /** @inheritDoc */

	  }, {
	    key: "start",
	    value: function start() {
	      this._source.on("add", this._listeners.add);

	      this._source.on("remove", this._listeners.remove);

	      this._source.on("update", this._listeners.update);

	      return this;
	    }
	    /** @inheritDoc */

	  }, {
	    key: "stop",
	    value: function stop() {
	      this._source.off("add", this._listeners.add);

	      this._source.off("remove", this._listeners.remove);

	      this._source.off("update", this._listeners.update);

	      return this;
	    }
	    /**
	     * Apply the transformers to the items.
	     *
	     * @param items - The items to be transformed.
	     * @returns The transformed items.
	     */

	  }, {
	    key: "_transformItems",
	    value: function _transformItems(items) {
	      var _context4;

	      return _reduceInstanceProperty(_context4 = this._transformers).call(_context4, function (items, transform) {
	        return transform(items);
	      }, items);
	    }
	    /**
	     * Handle an add event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the ids of the added items.
	     */

	  }, {
	    key: "_add",
	    value: function _add(_name, payload) {
	      if (payload == null) {
	        return;
	      }

	      this._target.add(this._transformItems(this._source.get(payload.items)));
	    }
	    /**
	     * Handle an update event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the ids of the updated items.
	     */

	  }, {
	    key: "_update",
	    value: function _update(_name, payload) {
	      if (payload == null) {
	        return;
	      }

	      this._target.update(this._transformItems(this._source.get(payload.items)));
	    }
	    /**
	     * Handle a remove event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the data of the removed items.
	     */

	  }, {
	    key: "_remove",
	    value: function _remove(_name, payload) {
	      if (payload == null) {
	        return;
	      }

	      this._target.remove(this._transformItems(payload.oldData));
	    }
	  }]);

	  return SimpleDataPipe;
	}();
	/**
	 * Internal implementation of the pipe factory. This should be accessible
	 * only through `createNewDataPipeFrom` from the outside.
	 *
	 * @typeParam TI - Target item type.
	 * @typeParam TP - Target item type's id property name.
	 */


	var DataPipeUnderConstruction = /*#__PURE__*/function () {
	  /**
	   * Array transformers used to transform items within the pipe. This is typed
	   * as any for the sake of simplicity.
	   */

	  /**
	   * Create a new data pipe factory. This is an internal constructor that
	   * should never be called from outside of this file.
	   *
	   * @param _source - The source data set or data view for this pipe.
	   */
	  function DataPipeUnderConstruction(_source) {
	    _classCallCheck(this, DataPipeUnderConstruction);

	    _defineProperty(this, "_source", void 0);

	    _defineProperty(this, "_transformers", []);

	    this._source = _source;
	  }
	  /**
	   * Filter the items.
	   *
	   * @param callback - A filtering function that returns true if given item
	   * should be piped and false if not.
	   * @returns This factory for further configuration.
	   */


	  _createClass(DataPipeUnderConstruction, [{
	    key: "filter",
	    value: function filter(callback) {
	      this._transformers.push(function (input) {
	        return _filterInstanceProperty(input).call(input, callback);
	      });

	      return this;
	    }
	    /**
	     * Map each source item to a new type.
	     *
	     * @param callback - A mapping function that takes a source item and returns
	     * corresponding mapped item.
	     * @typeParam TI - Target item type.
	     * @typeParam TP - Target item type's id property name.
	     * @returns This factory for further configuration.
	     */

	  }, {
	    key: "map",
	    value: function map(callback) {
	      this._transformers.push(function (input) {
	        return _mapInstanceProperty(input).call(input, callback);
	      });

	      return this;
	    }
	    /**
	     * Map each source item to zero or more items of a new type.
	     *
	     * @param callback - A mapping function that takes a source item and returns
	     * an array of corresponding mapped items.
	     * @typeParam TI - Target item type.
	     * @typeParam TP - Target item type's id property name.
	     * @returns This factory for further configuration.
	     */

	  }, {
	    key: "flatMap",
	    value: function flatMap(callback) {
	      this._transformers.push(function (input) {
	        return _flatMapInstanceProperty(input).call(input, callback);
	      });

	      return this;
	    }
	    /**
	     * Connect this pipe to given data set.
	     *
	     * @param target - The data set that will receive the items from this pipe.
	     * @returns The pipe connected between given data sets and performing
	     * configured transformation on the processed items.
	     */

	  }, {
	    key: "to",
	    value: function to(target) {
	      return new SimpleDataPipe(this._source, this._transformers, target);
	    }
	  }]);

	  return DataPipeUnderConstruction;
	}();
	/**
	 * Determine whether a value can be used as an id.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if the value is valid id, false otherwise.
	 */


	function isId(value) {
	  return typeof value === "string" || typeof value === "number";
	}
	/**
	 * A queue.
	 *
	 * @typeParam T - The type of method names to be replaced by queued versions.
	 */


	var Queue = /*#__PURE__*/function () {
	  /** Delay in milliseconds. If defined the queue will be periodically flushed. */

	  /** Maximum number of entries in the queue before it will be flushed. */

	  /**
	   * Construct a new Queue.
	   *
	   * @param options - Queue configuration.
	   */
	  function Queue(options) {
	    _classCallCheck(this, Queue);

	    _defineProperty(this, "delay", void 0);

	    _defineProperty(this, "max", void 0);

	    _defineProperty(this, "_queue", []);

	    _defineProperty(this, "_timeout", null);

	    _defineProperty(this, "_extended", null);

	    // options
	    this.delay = null;
	    this.max = Infinity;
	    this.setOptions(options);
	  }
	  /**
	   * Update the configuration of the queue.
	   *
	   * @param options - Queue configuration.
	   */


	  _createClass(Queue, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options && typeof options.delay !== "undefined") {
	        this.delay = options.delay;
	      }

	      if (options && typeof options.max !== "undefined") {
	        this.max = options.max;
	      }

	      this._flushIfNeeded();
	    }
	    /**
	     * Extend an object with queuing functionality.
	     * The object will be extended with a function flush, and the methods provided in options.replace will be replaced with queued ones.
	     *
	     * @param object - The object to be extended.
	     * @param options - Additional options.
	     * @returns The created queue.
	     */

	  }, {
	    key: "destroy",
	    value:
	    /**
	     * Destroy the queue. The queue will first flush all queued actions, and in case it has extended an object, will restore the original object.
	     */
	    function destroy() {
	      this.flush();

	      if (this._extended) {
	        var object = this._extended.object;
	        var methods = this._extended.methods;

	        for (var i = 0; i < methods.length; i++) {
	          var method = methods[i];

	          if (method.original) {
	            // @TODO: better solution?
	            object[method.name] = method.original;
	          } else {
	            // @TODO: better solution?
	            delete object[method.name];
	          }
	        }

	        this._extended = null;
	      }
	    }
	    /**
	     * Replace a method on an object with a queued version.
	     *
	     * @param object - Object having the method.
	     * @param method - The method name.
	     */

	  }, {
	    key: "replace",
	    value: function replace(object, method) {
	      /* eslint-disable-next-line @typescript-eslint/no-this-alias -- Function this is necessary in the function bellow, so class this has to be saved into a variable here. */
	      var me = this;
	      var original = object[method];

	      if (!original) {
	        throw new Error("Method " + method + " undefined");
	      }

	      object[method] = function () {
	        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	          args[_key] = arguments[_key];
	        }

	        // add this call to the queue
	        me.queue({
	          args: args,
	          fn: original,
	          context: this
	        });
	      };
	    }
	    /**
	     * Queue a call.
	     *
	     * @param entry - The function or entry to be queued.
	     */

	  }, {
	    key: "queue",
	    value: function queue(entry) {
	      if (typeof entry === "function") {
	        this._queue.push({
	          fn: entry
	        });
	      } else {
	        this._queue.push(entry);
	      }

	      this._flushIfNeeded();
	    }
	    /**
	     * Check whether the queue needs to be flushed.
	     */

	  }, {
	    key: "_flushIfNeeded",
	    value: function _flushIfNeeded() {
	      var _this = this;

	      // flush when the maximum is exceeded.
	      if (this._queue.length > this.max) {
	        this.flush();
	      } // flush after a period of inactivity when a delay is configured


	      if (this._timeout != null) {
	        clearTimeout(this._timeout);
	        this._timeout = null;
	      }

	      if (this.queue.length > 0 && typeof this.delay === "number") {
	        this._timeout = _setTimeout(function () {
	          _this.flush();
	        }, this.delay);
	      }
	    }
	    /**
	     * Flush all queued calls
	     */

	  }, {
	    key: "flush",
	    value: function flush() {
	      var _context5, _context6;

	      _forEachInstanceProperty(_context5 = _spliceInstanceProperty(_context6 = this._queue).call(_context6, 0)).call(_context5, function (entry) {
	        entry.fn.apply(entry.context || entry.fn, entry.args || []);
	      });
	    }
	  }], [{
	    key: "extend",
	    value: function extend(object, options) {
	      var queue = new Queue(options);

	      if (object.flush !== undefined) {
	        throw new Error("Target object already has a property flush");
	      }

	      object.flush = function () {
	        queue.flush();
	      };

	      var methods = [{
	        name: "flush",
	        original: undefined
	      }];

	      if (options && options.replace) {
	        for (var i = 0; i < options.replace.length; i++) {
	          var name = options.replace[i];
	          methods.push({
	            name: name,
	            // @TODO: better solution?
	            original: object[name]
	          }); // @TODO: better solution?

	          queue.replace(object, name);
	        }
	      }

	      queue._extended = {
	        object: object,
	        methods: methods
	      };
	      return queue;
	    }
	  }]);

	  return Queue;
	}();
	/**
	 * [[DataSet]] code that can be reused in [[DataView]] or other similar implementations of [[DataInterface]].
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */


	var DataSetPart = /*#__PURE__*/function () {
	  function DataSetPart() {
	    _classCallCheck(this, DataSetPart);

	    _defineProperty(this, "_subscribers", {
	      "*": [],
	      add: [],
	      remove: [],
	      update: []
	    });

	    _defineProperty(this, "subscribe", DataSetPart.prototype.on);

	    _defineProperty(this, "unsubscribe", DataSetPart.prototype.off);
	  }

	  _createClass(DataSetPart, [{
	    key: "_trigger",
	    value:
	    /**
	     * Trigger an event
	     *
	     * @param event - Event name.
	     * @param payload - Event payload.
	     * @param senderId - Id of the sender.
	     */
	    function _trigger(event, payload, senderId) {
	      var _context7, _context8;

	      if (event === "*") {
	        throw new Error("Cannot trigger event *");
	      }

	      _forEachInstanceProperty(_context7 = _concatInstanceProperty(_context8 = []).call(_context8, _toConsumableArray(this._subscribers[event]), _toConsumableArray(this._subscribers["*"]))).call(_context7, function (subscriber) {
	        subscriber(event, payload, senderId != null ? senderId : null);
	      });
	    }
	    /**
	     * Subscribe to an event, add an event listener.
	     *
	     * @remarks Non-function callbacks are ignored.
	     * @param event - Event name.
	     * @param callback - Callback method.
	     */

	  }, {
	    key: "on",
	    value: function on(event, callback) {
	      if (typeof callback === "function") {
	        this._subscribers[event].push(callback);
	      } // @TODO: Maybe throw for invalid callbacks?

	    }
	    /**
	     * Unsubscribe from an event, remove an event listener.
	     *
	     * @remarks If the same callback was subscribed more than once **all** occurences will be removed.
	     * @param event - Event name.
	     * @param callback - Callback method.
	     */

	  }, {
	    key: "off",
	    value: function off(event, callback) {
	      var _context9;

	      this._subscribers[event] = _filterInstanceProperty(_context9 = this._subscribers[event]).call(_context9, function (subscriber) {
	        return subscriber !== callback;
	      });
	    }
	    /**
	     * @deprecated Use on instead (PS: DataView.subscribe === DataView.on).
	     */

	  }]);

	  return DataSetPart;
	}();
	/**
	 * Data stream
	 *
	 * @remarks
	 * [[DataStream]] offers an always up to date stream of items from a [[DataSet]] or [[DataView]].
	 * That means that the stream is evaluated at the time of iteration, conversion to another data type or when [[cache]] is called, not when the [[DataStream]] was created.
	 * Multiple invocations of for example [[toItemArray]] may yield different results (if the data source like for example [[DataSet]] gets modified).
	 * @typeParam Item - The item type this stream is going to work with.
	 */


	_Symbol$iterator = _Symbol$iterator2;

	var DataStream = /*#__PURE__*/function () {
	  /**
	   * Create a new data stream.
	   *
	   * @param pairs - The id, item pairs.
	   */
	  function DataStream(pairs) {
	    _classCallCheck(this, DataStream);

	    _defineProperty(this, "_pairs", void 0);

	    this._pairs = pairs;
	  }
	  /**
	   * Return an iterable of key, value pairs for every entry in the stream.
	   */


	  _createClass(DataStream, [{
	    key: _Symbol$iterator,
	    value:
	    /*#__PURE__*/
	    regenerator.mark(function value() {
	      var _iterator, _step, _step$value, id, item;

	      return regenerator.wrap(function value$(_context10) {
	        while (1) {
	          switch (_context10.prev = _context10.next) {
	            case 0:
	              _iterator = _createForOfIteratorHelper$6(this._pairs);
	              _context10.prev = 1;

	              _iterator.s();

	            case 3:
	              if ((_step = _iterator.n()).done) {
	                _context10.next = 9;
	                break;
	              }

	              _step$value = _slicedToArray(_step.value, 2), id = _step$value[0], item = _step$value[1];
	              _context10.next = 7;
	              return [id, item];

	            case 7:
	              _context10.next = 3;
	              break;

	            case 9:
	              _context10.next = 14;
	              break;

	            case 11:
	              _context10.prev = 11;
	              _context10.t0 = _context10["catch"](1);

	              _iterator.e(_context10.t0);

	            case 14:
	              _context10.prev = 14;

	              _iterator.f();

	              return _context10.finish(14);

	            case 17:
	            case "end":
	              return _context10.stop();
	          }
	        }
	      }, value, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of key, value pairs for every entry in the stream.
	     */

	  }, {
	    key: "entries",
	    value:
	    /*#__PURE__*/
	    regenerator.mark(function entries() {
	      var _iterator2, _step2, _step2$value, id, item;

	      return regenerator.wrap(function entries$(_context11) {
	        while (1) {
	          switch (_context11.prev = _context11.next) {
	            case 0:
	              _iterator2 = _createForOfIteratorHelper$6(this._pairs);
	              _context11.prev = 1;

	              _iterator2.s();

	            case 3:
	              if ((_step2 = _iterator2.n()).done) {
	                _context11.next = 9;
	                break;
	              }

	              _step2$value = _slicedToArray(_step2.value, 2), id = _step2$value[0], item = _step2$value[1];
	              _context11.next = 7;
	              return [id, item];

	            case 7:
	              _context11.next = 3;
	              break;

	            case 9:
	              _context11.next = 14;
	              break;

	            case 11:
	              _context11.prev = 11;
	              _context11.t0 = _context11["catch"](1);

	              _iterator2.e(_context11.t0);

	            case 14:
	              _context11.prev = 14;

	              _iterator2.f();

	              return _context11.finish(14);

	            case 17:
	            case "end":
	              return _context11.stop();
	          }
	        }
	      }, entries, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of keys in the stream.
	     */

	  }, {
	    key: "keys",
	    value:
	    /*#__PURE__*/
	    regenerator.mark(function keys() {
	      var _iterator3, _step3, _step3$value, id;

	      return regenerator.wrap(function keys$(_context12) {
	        while (1) {
	          switch (_context12.prev = _context12.next) {
	            case 0:
	              _iterator3 = _createForOfIteratorHelper$6(this._pairs);
	              _context12.prev = 1;

	              _iterator3.s();

	            case 3:
	              if ((_step3 = _iterator3.n()).done) {
	                _context12.next = 9;
	                break;
	              }

	              _step3$value = _slicedToArray(_step3.value, 1), id = _step3$value[0];
	              _context12.next = 7;
	              return id;

	            case 7:
	              _context12.next = 3;
	              break;

	            case 9:
	              _context12.next = 14;
	              break;

	            case 11:
	              _context12.prev = 11;
	              _context12.t0 = _context12["catch"](1);

	              _iterator3.e(_context12.t0);

	            case 14:
	              _context12.prev = 14;

	              _iterator3.f();

	              return _context12.finish(14);

	            case 17:
	            case "end":
	              return _context12.stop();
	          }
	        }
	      }, keys, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of values in the stream.
	     */

	  }, {
	    key: "values",
	    value:
	    /*#__PURE__*/
	    regenerator.mark(function values() {
	      var _iterator4, _step4, _step4$value, item;

	      return regenerator.wrap(function values$(_context13) {
	        while (1) {
	          switch (_context13.prev = _context13.next) {
	            case 0:
	              _iterator4 = _createForOfIteratorHelper$6(this._pairs);
	              _context13.prev = 1;

	              _iterator4.s();

	            case 3:
	              if ((_step4 = _iterator4.n()).done) {
	                _context13.next = 9;
	                break;
	              }

	              _step4$value = _slicedToArray(_step4.value, 2), item = _step4$value[1];
	              _context13.next = 7;
	              return item;

	            case 7:
	              _context13.next = 3;
	              break;

	            case 9:
	              _context13.next = 14;
	              break;

	            case 11:
	              _context13.prev = 11;
	              _context13.t0 = _context13["catch"](1);

	              _iterator4.e(_context13.t0);

	            case 14:
	              _context13.prev = 14;

	              _iterator4.f();

	              return _context13.finish(14);

	            case 17:
	            case "end":
	              return _context13.stop();
	          }
	        }
	      }, values, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an array containing all the ids in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     * @returns The array with all ids from this stream.
	     */

	  }, {
	    key: "toIdArray",
	    value: function toIdArray() {
	      var _context14;

	      return _mapInstanceProperty(_context14 = _toConsumableArray(this._pairs)).call(_context14, function (pair) {
	        return pair[0];
	      });
	    }
	    /**
	     * Return an array containing all the items in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     * @returns The array with all items from this stream.
	     */

	  }, {
	    key: "toItemArray",
	    value: function toItemArray() {
	      var _context15;

	      return _mapInstanceProperty(_context15 = _toConsumableArray(this._pairs)).call(_context15, function (pair) {
	        return pair[1];
	      });
	    }
	    /**
	     * Return an array containing all the entries in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     * @returns The array with all entries from this stream.
	     */

	  }, {
	    key: "toEntryArray",
	    value: function toEntryArray() {
	      return _toConsumableArray(this._pairs);
	    }
	    /**
	     * Return an object map containing all the items in this stream accessible by ids.
	     *
	     * @remarks
	     * In case of duplicate ids (coerced to string so `7 == '7'`) the last encoutered appears in the returned object.
	     * @returns The object map of all id → item pairs from this stream.
	     */

	  }, {
	    key: "toObjectMap",
	    value: function toObjectMap() {
	      var map = _Object$create$1(null);

	      var _iterator5 = _createForOfIteratorHelper$6(this._pairs),
	          _step5;

	      try {
	        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
	          var _step5$value = _slicedToArray(_step5.value, 2),
	              id = _step5$value[0],
	              item = _step5$value[1];

	          map[id] = item;
	        }
	      } catch (err) {
	        _iterator5.e(err);
	      } finally {
	        _iterator5.f();
	      }

	      return map;
	    }
	    /**
	     * Return a map containing all the items in this stream accessible by ids.
	     *
	     * @returns The map of all id → item pairs from this stream.
	     */

	  }, {
	    key: "toMap",
	    value: function toMap() {
	      return new _Map(this._pairs);
	    }
	    /**
	     * Return a set containing all the (unique) ids in this stream.
	     *
	     * @returns The set of all ids from this stream.
	     */

	  }, {
	    key: "toIdSet",
	    value: function toIdSet() {
	      return new _Set(this.toIdArray());
	    }
	    /**
	     * Return a set containing all the (unique) items in this stream.
	     *
	     * @returns The set of all items from this stream.
	     */

	  }, {
	    key: "toItemSet",
	    value: function toItemSet() {
	      return new _Set(this.toItemArray());
	    }
	    /**
	     * Cache the items from this stream.
	     *
	     * @remarks
	     * This method allows for items to be fetched immediatelly and used (possibly multiple times) later.
	     * It can also be used to optimize performance as [[DataStream]] would otherwise reevaluate everything upon each iteration.
	     *
	     * ## Example
	     * ```javascript
	     * const ds = new DataSet([…])
	     *
	     * const cachedStream = ds.stream()
	     *   .filter(…)
	     *   .sort(…)
	     *   .map(…)
	     *   .cached(…) // Data are fetched, processed and cached here.
	     *
	     * ds.clear()
	     * chachedStream // Still has all the items.
	     * ```
	     * @returns A new [[DataStream]] with cached items (detached from the original [[DataSet]]).
	     */

	  }, {
	    key: "cache",
	    value: function cache() {
	      return new DataStream(_toConsumableArray(this._pairs));
	    }
	    /**
	     * Get the distinct values of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     * @typeParam T - The type of the distinct value.
	     * @returns A set of all distinct properties.
	     */

	  }, {
	    key: "distinct",
	    value: function distinct(callback) {
	      var set = new _Set();

	      var _iterator6 = _createForOfIteratorHelper$6(this._pairs),
	          _step6;

	      try {
	        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
	          var _step6$value = _slicedToArray(_step6.value, 2),
	              id = _step6$value[0],
	              item = _step6$value[1];

	          set.add(callback(item, id));
	        }
	      } catch (err) {
	        _iterator6.e(err);
	      } finally {
	        _iterator6.f();
	      }

	      return set;
	    }
	    /**
	     * Filter the items of the stream.
	     *
	     * @param callback - The function that decides whether an item will be included.
	     * @returns A new data stream with the filtered items.
	     */

	  }, {
	    key: "filter",
	    value: function filter(callback) {
	      var pairs = this._pairs;
	      return new DataStream(_defineProperty({}, _Symbol$iterator2, /*#__PURE__*/regenerator.mark(function _callee() {
	        var _iterator7, _step7, _step7$value, id, item;

	        return regenerator.wrap(function _callee$(_context16) {
	          while (1) {
	            switch (_context16.prev = _context16.next) {
	              case 0:
	                _iterator7 = _createForOfIteratorHelper$6(pairs);
	                _context16.prev = 1;

	                _iterator7.s();

	              case 3:
	                if ((_step7 = _iterator7.n()).done) {
	                  _context16.next = 10;
	                  break;
	                }

	                _step7$value = _slicedToArray(_step7.value, 2), id = _step7$value[0], item = _step7$value[1];

	                if (!callback(item, id)) {
	                  _context16.next = 8;
	                  break;
	                }

	                _context16.next = 8;
	                return [id, item];

	              case 8:
	                _context16.next = 3;
	                break;

	              case 10:
	                _context16.next = 15;
	                break;

	              case 12:
	                _context16.prev = 12;
	                _context16.t0 = _context16["catch"](1);

	                _iterator7.e(_context16.t0);

	              case 15:
	                _context16.prev = 15;

	                _iterator7.f();

	                return _context16.finish(15);

	              case 18:
	              case "end":
	                return _context16.stop();
	            }
	          }
	        }, _callee, null, [[1, 12, 15, 18]]);
	      })));
	    }
	    /**
	     * Execute a callback for each item of the stream.
	     *
	     * @param callback - The function that will be invoked for each item.
	     */

	  }, {
	    key: "forEach",
	    value: function forEach(callback) {
	      var _iterator8 = _createForOfIteratorHelper$6(this._pairs),
	          _step8;

	      try {
	        for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
	          var _step8$value = _slicedToArray(_step8.value, 2),
	              id = _step8$value[0],
	              item = _step8$value[1];

	          callback(item, id);
	        }
	      } catch (err) {
	        _iterator8.e(err);
	      } finally {
	        _iterator8.f();
	      }
	    }
	    /**
	     * Map the items into a different type.
	     *
	     * @param callback - The function that does the conversion.
	     * @typeParam Mapped - The type of the item after mapping.
	     * @returns A new data stream with the mapped items.
	     */

	  }, {
	    key: "map",
	    value: function map(callback) {
	      var pairs = this._pairs;
	      return new DataStream(_defineProperty({}, _Symbol$iterator2, /*#__PURE__*/regenerator.mark(function _callee2() {
	        var _iterator9, _step9, _step9$value, id, item;

	        return regenerator.wrap(function _callee2$(_context17) {
	          while (1) {
	            switch (_context17.prev = _context17.next) {
	              case 0:
	                _iterator9 = _createForOfIteratorHelper$6(pairs);
	                _context17.prev = 1;

	                _iterator9.s();

	              case 3:
	                if ((_step9 = _iterator9.n()).done) {
	                  _context17.next = 9;
	                  break;
	                }

	                _step9$value = _slicedToArray(_step9.value, 2), id = _step9$value[0], item = _step9$value[1];
	                _context17.next = 7;
	                return [id, callback(item, id)];

	              case 7:
	                _context17.next = 3;
	                break;

	              case 9:
	                _context17.next = 14;
	                break;

	              case 11:
	                _context17.prev = 11;
	                _context17.t0 = _context17["catch"](1);

	                _iterator9.e(_context17.t0);

	              case 14:
	                _context17.prev = 14;

	                _iterator9.f();

	                return _context17.finish(14);

	              case 17:
	              case "end":
	                return _context17.stop();
	            }
	          }
	        }, _callee2, null, [[1, 11, 14, 17]]);
	      })));
	    }
	    /**
	     * Get the item with the maximum value of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     * @returns The item with the maximum if found otherwise null.
	     */

	  }, {
	    key: "max",
	    value: function max(callback) {
	      var iter = _getIterator(this._pairs);

	      var curr = iter.next();

	      if (curr.done) {
	        return null;
	      }

	      var maxItem = curr.value[1];
	      var maxValue = callback(curr.value[1], curr.value[0]);

	      while (!(curr = iter.next()).done) {
	        var _curr$value = _slicedToArray(curr.value, 2),
	            id = _curr$value[0],
	            item = _curr$value[1];

	        var _value = callback(item, id);

	        if (_value > maxValue) {
	          maxValue = _value;
	          maxItem = item;
	        }
	      }

	      return maxItem;
	    }
	    /**
	     * Get the item with the minimum value of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     * @returns The item with the minimum if found otherwise null.
	     */

	  }, {
	    key: "min",
	    value: function min(callback) {
	      var iter = _getIterator(this._pairs);

	      var curr = iter.next();

	      if (curr.done) {
	        return null;
	      }

	      var minItem = curr.value[1];
	      var minValue = callback(curr.value[1], curr.value[0]);

	      while (!(curr = iter.next()).done) {
	        var _curr$value2 = _slicedToArray(curr.value, 2),
	            id = _curr$value2[0],
	            item = _curr$value2[1];

	        var _value2 = callback(item, id);

	        if (_value2 < minValue) {
	          minValue = _value2;
	          minItem = item;
	        }
	      }

	      return minItem;
	    }
	    /**
	     * Reduce the items into a single value.
	     *
	     * @param callback - The function that does the reduction.
	     * @param accumulator - The initial value of the accumulator.
	     * @typeParam T - The type of the accumulated value.
	     * @returns The reduced value.
	     */

	  }, {
	    key: "reduce",
	    value: function reduce(callback, accumulator) {
	      var _iterator10 = _createForOfIteratorHelper$6(this._pairs),
	          _step10;

	      try {
	        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
	          var _step10$value = _slicedToArray(_step10.value, 2),
	              id = _step10$value[0],
	              item = _step10$value[1];

	          accumulator = callback(accumulator, item, id);
	        }
	      } catch (err) {
	        _iterator10.e(err);
	      } finally {
	        _iterator10.f();
	      }

	      return accumulator;
	    }
	    /**
	     * Sort the items.
	     *
	     * @param callback - Item comparator.
	     * @returns A new stream with sorted items.
	     */

	  }, {
	    key: "sort",
	    value: function sort(callback) {
	      var _this2 = this;

	      return new DataStream(_defineProperty({}, _Symbol$iterator2, function () {
	        var _context18;

	        return _getIterator(_sortInstanceProperty(_context18 = _toConsumableArray(_this2._pairs)).call(_context18, function (_ref, _ref2) {
	          var _ref3 = _slicedToArray(_ref, 2),
	              idA = _ref3[0],
	              itemA = _ref3[1];

	          var _ref4 = _slicedToArray(_ref2, 2),
	              idB = _ref4[0],
	              itemB = _ref4[1];

	          return callback(itemA, itemB, idA, idB);
	        }));
	      }));
	    }
	  }]);

	  return DataStream;
	}();
	/**
	 * Add an id to given item if it doesn't have one already.
	 *
	 * @remarks
	 * The item will be modified.
	 * @param item - The item that will have an id after a call to this function.
	 * @param idProp - The key of the id property.
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 * @returns true
	 */


	function ensureFullItem(item, idProp) {
	  if (item[idProp] == null) {
	    // generate an id
	    item[idProp] = v4();
	  }

	  return item;
	}
	/**
	 * # DataSet
	 *
	 * Vis.js comes with a flexible DataSet, which can be used to hold and
	 * manipulate unstructured data and listen for changes in the data. The DataSet
	 * is key/value based. Data items can be added, updated and removed from the
	 * DataSet, and one can subscribe to changes in the DataSet. The data in the
	 * DataSet can be filtered and ordered. Data can be normalized when appending it
	 * to the DataSet as well.
	 *
	 * ## Example
	 *
	 * The following example shows how to use a DataSet.
	 *
	 * ```javascript
	 * // create a DataSet
	 * var options = {};
	 * var data = new vis.DataSet(options);
	 *
	 * // add items
	 * // note that the data items can contain different properties and data formats
	 * data.add([
	 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
	 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
	 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
	 *   {id: 4, text: 'item 4'}
	 * ]);
	 *
	 * // subscribe to any change in the DataSet
	 * data.on('*', function (event, properties, senderId) {
	 *   console.log('event', event, properties);
	 * });
	 *
	 * // update an existing item
	 * data.update({id: 2, group: 1});
	 *
	 * // remove an item
	 * data.remove(4);
	 *
	 * // get all ids
	 * var ids = data.getIds();
	 * console.log('ids', ids);
	 *
	 * // get a specific item
	 * var item1 = data.get(1);
	 * console.log('item1', item1);
	 *
	 * // retrieve a filtered subset of the data
	 * var items = data.get({
	 *   filter: function (item) {
	 *     return item.group == 1;
	 *   }
	 * });
	 * console.log('filtered items', items);
	 * ```
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */


	var DataSet = /*#__PURE__*/function (_DataSetPart) {
	  _inherits(DataSet, _DataSetPart);

	  var _super = _createSuper$d(DataSet);

	  /**
	   * Construct a new DataSet.
	   *
	   * @param data - Initial data or options.
	   * @param options - Options (type error if data is also options).
	   */
	  function DataSet(data, options) {
	    var _this3;

	    _classCallCheck(this, DataSet);

	    _this3 = _super.call(this); // correctly read optional arguments

	    _defineProperty(_assertThisInitialized(_this3), "flush", void 0);

	    _defineProperty(_assertThisInitialized(_this3), "length", void 0);

	    _defineProperty(_assertThisInitialized(_this3), "_options", void 0);

	    _defineProperty(_assertThisInitialized(_this3), "_data", void 0);

	    _defineProperty(_assertThisInitialized(_this3), "_idProp", void 0);

	    _defineProperty(_assertThisInitialized(_this3), "_queue", null);

	    if (data && !_Array$isArray(data)) {
	      options = data;
	      data = [];
	    }

	    _this3._options = options || {};
	    _this3._data = new _Map(); // map with data indexed by id

	    _this3.length = 0; // number of items in the DataSet

	    _this3._idProp = _this3._options.fieldId || "id"; // name of the field containing id
	    // add initial data when provided

	    if (data && data.length) {
	      _this3.add(data);
	    }

	    _this3.setOptions(options);

	    return _this3;
	  }
	  /**
	   * Set new options.
	   *
	   * @param options - The new options.
	   */


	  _createClass(DataSet, [{
	    key: "idProp",
	    get:
	    /** Flush all queued calls. */

	    /** @inheritDoc */

	    /** @inheritDoc */
	    function get() {
	      return this._idProp;
	    }
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options && options.queue !== undefined) {
	        if (options.queue === false) {
	          // delete queue if loaded
	          if (this._queue) {
	            this._queue.destroy();

	            this._queue = null;
	          }
	        } else {
	          // create queue and update its options
	          if (!this._queue) {
	            this._queue = Queue.extend(this, {
	              replace: ["add", "update", "remove"]
	            });
	          }

	          if (options.queue && _typeof$1(options.queue) === "object") {
	            this._queue.setOptions(options.queue);
	          }
	        }
	      }
	    }
	    /**
	     * Add a data item or an array with items.
	     *
	     * After the items are added to the DataSet, the DataSet will trigger an event `add`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet()
	     *
	     * // add items
	     * const ids = data.add([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { text: 'item without an id' }
	     * ])
	     *
	     * console.log(ids) // [1, 2, '<UUIDv4>']
	     * ```
	     *
	     * @param data - Items to be added (ids will be generated if missing).
	     * @param senderId - Sender id.
	     * @returns addedIds - Array with the ids (generated if not present) of the added items.
	     * @throws When an item with the same id as any of the added items already exists.
	     */

	  }, {
	    key: "add",
	    value: function add(data, senderId) {
	      var _this4 = this;

	      var addedIds = [];
	      var id;

	      if (_Array$isArray(data)) {
	        // Array
	        var idsToAdd = _mapInstanceProperty(data).call(data, function (d) {
	          return d[_this4._idProp];
	        });

	        if (_someInstanceProperty(idsToAdd).call(idsToAdd, function (id) {
	          return _this4._data.has(id);
	        })) {
	          throw new Error("A duplicate id was found in the parameter array.");
	        }

	        for (var i = 0, len = data.length; i < len; i++) {
	          id = this._addItem(data[i]);
	          addedIds.push(id);
	        }
	      } else if (data && _typeof$1(data) === "object") {
	        // Single item
	        id = this._addItem(data);
	        addedIds.push(id);
	      } else {
	        throw new Error("Unknown dataType");
	      }

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }

	      return addedIds;
	    }
	    /**
	     * Update existing items. When an item does not exist, it will be created.
	     *
	     * @remarks
	     * The provided properties will be merged in the existing item. When an item does not exist, it will be created.
	     *
	     * After the items are updated, the DataSet will trigger an event `add` for the added items, and an event `update`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' }
	     * ])
	     *
	     * // update items
	     * const ids = data.update([
	     *   { id: 2, text: 'item 2 (updated)' },
	     *   { id: 4, text: 'item 4 (new)' }
	     * ])
	     *
	     * console.log(ids) // [2, 4]
	     * ```
	     *
	     * ## Warning for TypeScript users
	     * This method may introduce partial items into the data set. Use add or updateOnly instead for better type safety.
	     * @param data - Items to be updated (if the id is already present) or added (if the id is missing).
	     * @param senderId - Sender id.
	     * @returns updatedIds - The ids of the added (these may be newly generated if there was no id in the item from the data) or updated items.
	     * @throws When the supplied data is neither an item nor an array of items.
	     */

	  }, {
	    key: "update",
	    value: function update(data, senderId) {
	      var _this5 = this;

	      var addedIds = [];
	      var updatedIds = [];
	      var oldData = [];
	      var updatedData = [];
	      var idProp = this._idProp;

	      var addOrUpdate = function addOrUpdate(item) {
	        var origId = item[idProp];

	        if (origId != null && _this5._data.has(origId)) {
	          var fullItem = item; // it has an id, therefore it is a fullitem

	          var oldItem = _Object$assign({}, _this5._data.get(origId)); // update item


	          var id = _this5._updateItem(fullItem);

	          updatedIds.push(id);
	          updatedData.push(fullItem);
	          oldData.push(oldItem);
	        } else {
	          // add new item
	          var _id = _this5._addItem(item);

	          addedIds.push(_id);
	        }
	      };

	      if (_Array$isArray(data)) {
	        // Array
	        for (var i = 0, len = data.length; i < len; i++) {
	          if (data[i] && _typeof$1(data[i]) === "object") {
	            addOrUpdate(data[i]);
	          } else {
	            console.warn("Ignoring input item, which is not an object at index " + i);
	          }
	        }
	      } else if (data && _typeof$1(data) === "object") {
	        // Single item
	        addOrUpdate(data);
	      } else {
	        throw new Error("Unknown dataType");
	      }

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }

	      if (updatedIds.length) {
	        var props = {
	          items: updatedIds,
	          oldData: oldData,
	          data: updatedData
	        }; // TODO: remove deprecated property 'data' some day
	        //Object.defineProperty(props, 'data', {
	        //  'get': (function() {
	        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
	        //    return updatedData;
	        //  }).bind(this)
	        //});

	        this._trigger("update", props, senderId);
	      }

	      return _concatInstanceProperty(addedIds).call(addedIds, updatedIds);
	    }
	    /**
	     * Update existing items. When an item does not exist, an error will be thrown.
	     *
	     * @remarks
	     * The provided properties will be deeply merged into the existing item.
	     * When an item does not exist (id not present in the data set or absent), an error will be thrown and nothing will be changed.
	     *
	     * After the items are updated, the DataSet will trigger an event `update`.
	     * When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' },
	     * ])
	     *
	     * // update items
	     * const ids = data.update([
	     *   { id: 2, text: 'item 2 (updated)' }, // works
	     *   // { id: 4, text: 'item 4 (new)' }, // would throw
	     *   // { text: 'item 4 (new)' }, // would also throw
	     * ])
	     *
	     * console.log(ids) // [2]
	     * ```
	     * @param data - Updates (the id and optionally other props) to the items in this data set.
	     * @param senderId - Sender id.
	     * @returns updatedIds - The ids of the updated items.
	     * @throws When the supplied data is neither an item nor an array of items, when the ids are missing.
	     */

	  }, {
	    key: "updateOnly",
	    value: function updateOnly(data, senderId) {
	      var _context19,
	          _this6 = this;

	      if (!_Array$isArray(data)) {
	        data = [data];
	      }

	      var updateEventData = _mapInstanceProperty(_context19 = _mapInstanceProperty(data).call(data, function (update) {
	        var oldData = _this6._data.get(update[_this6._idProp]);

	        if (oldData == null) {
	          throw new Error("Updating non-existent items is not allowed.");
	        }

	        return {
	          oldData: oldData,
	          update: update
	        };
	      })).call(_context19, function (_ref5) {
	        var oldData = _ref5.oldData,
	            update = _ref5.update;
	        var id = oldData[_this6._idProp];
	        var updatedData = pureDeepObjectAssign(oldData, update);

	        _this6._data.set(id, updatedData);

	        return {
	          id: id,
	          oldData: oldData,
	          updatedData: updatedData
	        };
	      });

	      if (updateEventData.length) {
	        var props = {
	          items: _mapInstanceProperty(updateEventData).call(updateEventData, function (value) {
	            return value.id;
	          }),
	          oldData: _mapInstanceProperty(updateEventData).call(updateEventData, function (value) {
	            return value.oldData;
	          }),
	          data: _mapInstanceProperty(updateEventData).call(updateEventData, function (value) {
	            return value.updatedData;
	          })
	        }; // TODO: remove deprecated property 'data' some day
	        //Object.defineProperty(props, 'data', {
	        //  'get': (function() {
	        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
	        //    return updatedData;
	        //  }).bind(this)
	        //});

	        this._trigger("update", props, senderId);

	        return props.items;
	      } else {
	        return [];
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "get",
	    value: function get(first, second) {
	      // @TODO: Woudn't it be better to split this into multiple methods?
	      // parse the arguments
	      var id = undefined;
	      var ids = undefined;
	      var options = undefined;

	      if (isId(first)) {
	        // get(id [, options])
	        id = first;
	        options = second;
	      } else if (_Array$isArray(first)) {
	        // get(ids [, options])
	        ids = first;
	        options = second;
	      } else {
	        // get([, options])
	        options = first;
	      } // determine the return type


	      var returnType = options && options.returnType === "Object" ? "Object" : "Array"; // @TODO: WTF is this? Or am I missing something?
	      // var returnType
	      // if (options && options.returnType) {
	      //   var allowedValues = ['Array', 'Object']
	      //   returnType =
	      //     allowedValues.indexOf(options.returnType) == -1
	      //       ? 'Array'
	      //       : options.returnType
	      // } else {
	      //   returnType = 'Array'
	      // }
	      // build options

	      var filter = options && _filterInstanceProperty(options);

	      var items = [];
	      var item = undefined;
	      var itemIds = undefined;
	      var itemId = undefined; // convert items

	      if (id != null) {
	        // return a single item
	        item = this._data.get(id);

	        if (item && filter && !filter(item)) {
	          item = undefined;
	        }
	      } else if (ids != null) {
	        // return a subset of items
	        for (var i = 0, len = ids.length; i < len; i++) {
	          item = this._data.get(ids[i]);

	          if (item != null && (!filter || filter(item))) {
	            items.push(item);
	          }
	        }
	      } else {
	        var _context20;

	        // return all items
	        itemIds = _toConsumableArray(_keysInstanceProperty(_context20 = this._data).call(_context20));

	        for (var _i = 0, _len2 = itemIds.length; _i < _len2; _i++) {
	          itemId = itemIds[_i];
	          item = this._data.get(itemId);

	          if (item != null && (!filter || filter(item))) {
	            items.push(item);
	          }
	        }
	      } // order the results


	      if (options && options.order && id == undefined) {
	        this._sort(items, options.order);
	      } // filter fields of the items


	      if (options && options.fields) {
	        var fields = options.fields;

	        if (id != undefined && item != null) {
	          item = this._filterFields(item, fields);
	        } else {
	          for (var _i2 = 0, _len3 = items.length; _i2 < _len3; _i2++) {
	            items[_i2] = this._filterFields(items[_i2], fields);
	          }
	        }
	      } // return the results


	      if (returnType == "Object") {
	        var result = {};

	        for (var _i3 = 0, _len4 = items.length; _i3 < _len4; _i3++) {
	          var resultant = items[_i3]; // @TODO: Shoudn't this be this._fieldId?
	          // result[resultant.id] = resultant

	          var _id2 = resultant[this._idProp];
	          result[_id2] = resultant;
	        }

	        return result;
	      } else {
	        if (id != null) {
	          var _item;

	          // a single item
	          return (_item = item) !== null && _item !== void 0 ? _item : null;
	        } else {
	          // just return our array
	          return items;
	        }
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "getIds",
	    value: function getIds(options) {
	      var data = this._data;

	      var filter = options && _filterInstanceProperty(options);

	      var order = options && options.order;

	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data));

	      var ids = [];

	      if (filter) {
	        // get filtered items
	        if (order) {
	          // create ordered list
	          var items = [];

	          for (var i = 0, len = itemIds.length; i < len; i++) {
	            var id = itemIds[i];

	            var item = this._data.get(id);

	            if (item != null && filter(item)) {
	              items.push(item);
	            }
	          }

	          this._sort(items, order);

	          for (var _i4 = 0, _len5 = items.length; _i4 < _len5; _i4++) {
	            ids.push(items[_i4][this._idProp]);
	          }
	        } else {
	          // create unordered list
	          for (var _i5 = 0, _len6 = itemIds.length; _i5 < _len6; _i5++) {
	            var _id3 = itemIds[_i5];

	            var _item2 = this._data.get(_id3);

	            if (_item2 != null && filter(_item2)) {
	              ids.push(_item2[this._idProp]);
	            }
	          }
	        }
	      } else {
	        // get all items
	        if (order) {
	          // create an ordered list
	          var _items = [];

	          for (var _i6 = 0, _len7 = itemIds.length; _i6 < _len7; _i6++) {
	            var _id4 = itemIds[_i6];

	            _items.push(data.get(_id4));
	          }

	          this._sort(_items, order);

	          for (var _i7 = 0, _len8 = _items.length; _i7 < _len8; _i7++) {
	            ids.push(_items[_i7][this._idProp]);
	          }
	        } else {
	          // create unordered list
	          for (var _i8 = 0, _len9 = itemIds.length; _i8 < _len9; _i8++) {
	            var _id5 = itemIds[_i8];

	            var _item3 = data.get(_id5);

	            if (_item3 != null) {
	              ids.push(_item3[this._idProp]);
	            }
	          }
	        }
	      }

	      return ids;
	    }
	    /** @inheritDoc */

	  }, {
	    key: "getDataSet",
	    value: function getDataSet() {
	      return this;
	    }
	    /** @inheritDoc */

	  }, {
	    key: "forEach",
	    value: function forEach(callback, options) {
	      var filter = options && _filterInstanceProperty(options);

	      var data = this._data;

	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data));

	      if (options && options.order) {
	        // execute forEach on ordered list
	        var items = this.get(options);

	        for (var i = 0, len = items.length; i < len; i++) {
	          var item = items[i];
	          var id = item[this._idProp];
	          callback(item, id);
	        }
	      } else {
	        // unordered
	        for (var _i9 = 0, _len10 = itemIds.length; _i9 < _len10; _i9++) {
	          var _id6 = itemIds[_i9];

	          var _item4 = this._data.get(_id6);

	          if (_item4 != null && (!filter || filter(_item4))) {
	            callback(_item4, _id6);
	          }
	        }
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "map",
	    value: function map(callback, options) {
	      var filter = options && _filterInstanceProperty(options);

	      var mappedItems = [];
	      var data = this._data;

	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data)); // convert and filter items


	      for (var i = 0, len = itemIds.length; i < len; i++) {
	        var id = itemIds[i];

	        var item = this._data.get(id);

	        if (item != null && (!filter || filter(item))) {
	          mappedItems.push(callback(item, id));
	        }
	      } // order items


	      if (options && options.order) {
	        this._sort(mappedItems, options.order);
	      }

	      return mappedItems;
	    }
	    /**
	     * Filter the fields of an item.
	     *
	     * @param item - The item whose fields should be filtered.
	     * @param fields - The names of the fields that will be kept.
	     * @typeParam K - Field name type.
	     * @returns The item without any additional fields.
	     */

	  }, {
	    key: "_filterFields",
	    value: function _filterFields(item, fields) {
	      var _context21;

	      if (!item) {
	        // item is null
	        return item;
	      }

	      return _reduceInstanceProperty(_context21 = _Array$isArray(fields) ? // Use the supplied array
	      fields : // Use the keys of the supplied object
	      _Object$keys(fields)).call(_context21, function (filteredItem, field) {
	        filteredItem[field] = item[field];
	        return filteredItem;
	      }, {});
	    }
	    /**
	     * Sort the provided array with items.
	     *
	     * @param items - Items to be sorted in place.
	     * @param order - A field name or custom sort function.
	     * @typeParam T - The type of the items in the items array.
	     */

	  }, {
	    key: "_sort",
	    value: function _sort(items, order) {
	      if (typeof order === "string") {
	        // order by provided field name
	        var name = order; // field name

	        _sortInstanceProperty(items).call(items, function (a, b) {
	          // @TODO: How to treat missing properties?
	          var av = a[name];
	          var bv = b[name];
	          return av > bv ? 1 : av < bv ? -1 : 0;
	        });
	      } else if (typeof order === "function") {
	        // order by sort function
	        _sortInstanceProperty(items).call(items, order);
	      } else {
	        // TODO: extend order by an Object {field:string, direction:string}
	        //       where direction can be 'asc' or 'desc'
	        throw new TypeError("Order must be a function or a string");
	      }
	    }
	    /**
	     * Remove an item or multiple items by “reference” (only the id is used) or by id.
	     *
	     * The method ignores removal of non-existing items, and returns an array containing the ids of the items which are actually removed from the DataSet.
	     *
	     * After the items are removed, the DataSet will trigger an event `remove` for the removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' }
	     * ])
	     *
	     * // remove items
	     * const ids = data.remove([2, { id: 3 }, 4])
	     *
	     * console.log(ids) // [2, 3]
	     * ```
	     *
	     * @param id - One or more items or ids of items to be removed.
	     * @param senderId - Sender id.
	     * @returns The ids of the removed items.
	     */

	  }, {
	    key: "remove",
	    value: function remove(id, senderId) {
	      var removedIds = [];
	      var removedItems = []; // force everything to be an array for simplicity

	      var ids = _Array$isArray(id) ? id : [id];

	      for (var i = 0, len = ids.length; i < len; i++) {
	        var item = this._remove(ids[i]);

	        if (item) {
	          var itemId = item[this._idProp];

	          if (itemId != null) {
	            removedIds.push(itemId);
	            removedItems.push(item);
	          }
	        }
	      }

	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        }, senderId);
	      }

	      return removedIds;
	    }
	    /**
	     * Remove an item by its id or reference.
	     *
	     * @param id - Id of an item or the item itself.
	     * @returns The removed item if removed, null otherwise.
	     */

	  }, {
	    key: "_remove",
	    value: function _remove(id) {
	      // @TODO: It origianlly returned the item although the docs say id.
	      // The code expects the item, so probably an error in the docs.
	      var ident; // confirm the id to use based on the args type

	      if (isId(id)) {
	        ident = id;
	      } else if (id && _typeof$1(id) === "object") {
	        ident = id[this._idProp]; // look for the identifier field using ._idProp
	      } // do the removing if the item is found


	      if (ident != null && this._data.has(ident)) {
	        var item = this._data.get(ident) || null;

	        this._data.delete(ident);

	        --this.length;
	        return item;
	      }

	      return null;
	    }
	    /**
	     * Clear the entire data set.
	     *
	     * After the items are removed, the [[DataSet]] will trigger an event `remove` for all removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * @param senderId - Sender id.
	     * @returns removedIds - The ids of all removed items.
	     */

	  }, {
	    key: "clear",
	    value: function clear(senderId) {
	      var _context22;

	      var ids = _toConsumableArray(_keysInstanceProperty(_context22 = this._data).call(_context22));

	      var items = [];

	      for (var i = 0, len = ids.length; i < len; i++) {
	        items.push(this._data.get(ids[i]));
	      }

	      this._data.clear();

	      this.length = 0;

	      this._trigger("remove", {
	        items: ids,
	        oldData: items
	      }, senderId);

	      return ids;
	    }
	    /**
	     * Find the item with maximum value of a specified field.
	     *
	     * @param field - Name of the property that should be searched for max value.
	     * @returns Item containing max value, or null if no items.
	     */

	  }, {
	    key: "max",
	    value: function max(field) {
	      var _context23;

	      var max = null;
	      var maxField = null;

	      var _iterator11 = _createForOfIteratorHelper$6(_valuesInstanceProperty(_context23 = this._data).call(_context23)),
	          _step11;

	      try {
	        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
	          var item = _step11.value;
	          var itemField = item[field];

	          if (typeof itemField === "number" && (maxField == null || itemField > maxField)) {
	            max = item;
	            maxField = itemField;
	          }
	        }
	      } catch (err) {
	        _iterator11.e(err);
	      } finally {
	        _iterator11.f();
	      }

	      return max || null;
	    }
	    /**
	     * Find the item with minimum value of a specified field.
	     *
	     * @param field - Name of the property that should be searched for min value.
	     * @returns Item containing min value, or null if no items.
	     */

	  }, {
	    key: "min",
	    value: function min(field) {
	      var _context24;

	      var min = null;
	      var minField = null;

	      var _iterator12 = _createForOfIteratorHelper$6(_valuesInstanceProperty(_context24 = this._data).call(_context24)),
	          _step12;

	      try {
	        for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
	          var item = _step12.value;
	          var itemField = item[field];

	          if (typeof itemField === "number" && (minField == null || itemField < minField)) {
	            min = item;
	            minField = itemField;
	          }
	        }
	      } catch (err) {
	        _iterator12.e(err);
	      } finally {
	        _iterator12.f();
	      }

	      return min || null;
	    }
	    /**
	     * Find all distinct values of a specified field
	     *
	     * @param prop - The property name whose distinct values should be returned.
	     * @returns Unordered array containing all distinct values. Items without specified property are ignored.
	     */

	  }, {
	    key: "distinct",
	    value: function distinct(prop) {
	      var data = this._data;

	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data));

	      var values = [];
	      var count = 0;

	      for (var i = 0, len = itemIds.length; i < len; i++) {
	        var id = itemIds[i];
	        var item = data.get(id);
	        var _value3 = item[prop];
	        var exists = false;

	        for (var j = 0; j < count; j++) {
	          if (values[j] == _value3) {
	            exists = true;
	            break;
	          }
	        }

	        if (!exists && _value3 !== undefined) {
	          values[count] = _value3;
	          count++;
	        }
	      }

	      return values;
	    }
	    /**
	     * Add a single item. Will fail when an item with the same id already exists.
	     *
	     * @param item - A new item to be added.
	     * @returns Added item's id. An id is generated when it is not present in the item.
	     */

	  }, {
	    key: "_addItem",
	    value: function _addItem(item) {
	      var fullItem = ensureFullItem(item, this._idProp);
	      var id = fullItem[this._idProp]; // check whether this id is already taken

	      if (this._data.has(id)) {
	        // item already exists
	        throw new Error("Cannot add item: item with id " + id + " already exists");
	      }

	      this._data.set(id, fullItem);

	      ++this.length;
	      return id;
	    }
	    /**
	     * Update a single item: merge with existing item.
	     * Will fail when the item has no id, or when there does not exist an item with the same id.
	     *
	     * @param update - The new item
	     * @returns The id of the updated item.
	     */

	  }, {
	    key: "_updateItem",
	    value: function _updateItem(update) {
	      var id = update[this._idProp];

	      if (id == null) {
	        throw new Error("Cannot update item: item has no id (item: " + _JSON$stringify(update) + ")");
	      }

	      var item = this._data.get(id);

	      if (!item) {
	        // item doesn't exist
	        throw new Error("Cannot update item: no item with id " + id + " found");
	      }

	      this._data.set(id, _objectSpread$1(_objectSpread$1({}, item), update));

	      return id;
	    }
	    /** @inheritDoc */

	  }, {
	    key: "stream",
	    value: function stream(ids) {
	      if (ids) {
	        var data = this._data;
	        return new DataStream(_defineProperty({}, _Symbol$iterator2, /*#__PURE__*/regenerator.mark(function _callee3() {
	          var _iterator13, _step13, id, item;

	          return regenerator.wrap(function _callee3$(_context25) {
	            while (1) {
	              switch (_context25.prev = _context25.next) {
	                case 0:
	                  _iterator13 = _createForOfIteratorHelper$6(ids);
	                  _context25.prev = 1;

	                  _iterator13.s();

	                case 3:
	                  if ((_step13 = _iterator13.n()).done) {
	                    _context25.next = 11;
	                    break;
	                  }

	                  id = _step13.value;
	                  item = data.get(id);

	                  if (!(item != null)) {
	                    _context25.next = 9;
	                    break;
	                  }

	                  _context25.next = 9;
	                  return [id, item];

	                case 9:
	                  _context25.next = 3;
	                  break;

	                case 11:
	                  _context25.next = 16;
	                  break;

	                case 13:
	                  _context25.prev = 13;
	                  _context25.t0 = _context25["catch"](1);

	                  _iterator13.e(_context25.t0);

	                case 16:
	                  _context25.prev = 16;

	                  _iterator13.f();

	                  return _context25.finish(16);

	                case 19:
	                case "end":
	                  return _context25.stop();
	              }
	            }
	          }, _callee3, null, [[1, 13, 16, 19]]);
	        })));
	      } else {
	        var _context26;

	        return new DataStream(_defineProperty({}, _Symbol$iterator2, _bindInstanceProperty$1(_context26 = _entriesInstanceProperty(this._data)).call(_context26, this._data)));
	      }
	    }
	  }]);

	  return DataSet;
	}(DataSetPart);
	/**
	 * DataView
	 *
	 * A DataView offers a filtered and/or formatted view on a DataSet. One can subscribe to changes in a DataView, and easily get filtered or formatted data without having to specify filters and field types all the time.
	 *
	 * ## Example
	 * ```javascript
	 * // create a DataSet
	 * var data = new vis.DataSet();
	 * data.add([
	 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
	 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
	 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
	 *   {id: 4, text: 'item 4'}
	 * ]);
	 *
	 * // create a DataView
	 * // the view will only contain items having a property group with value 1,
	 * // and will only output fields id, text, and date.
	 * var view = new vis.DataView(data, {
	 *   filter: function (item) {
	 *     return (item.group == 1);
	 *   },
	 *   fields: ['id', 'text', 'date']
	 * });
	 *
	 * // subscribe to any change in the DataView
	 * view.on('*', function (event, properties, senderId) {
	 *   console.log('event', event, properties);
	 * });
	 *
	 * // update an item in the data set
	 * data.update({id: 2, group: 1});
	 *
	 * // get all ids in the view
	 * var ids = view.getIds();
	 * console.log('ids', ids); // will output [1, 2]
	 *
	 * // get all items in the view
	 * var items = view.get();
	 * ```
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */


	var DataView = /*#__PURE__*/function (_DataSetPart2) {
	  _inherits(DataView, _DataSetPart2);

	  var _super2 = _createSuper$d(DataView);

	  /**
	   * Create a DataView.
	   *
	   * @param data - The instance containing data (directly or indirectly).
	   * @param options - Options to configure this data view.
	   */
	  function DataView(data, options) {
	    var _context27;

	    var _this7;

	    _classCallCheck(this, DataView);

	    _this7 = _super2.call(this);

	    _defineProperty(_assertThisInitialized(_this7), "length", 0);

	    _defineProperty(_assertThisInitialized(_this7), "_listener", void 0);

	    _defineProperty(_assertThisInitialized(_this7), "_data", void 0);

	    _defineProperty(_assertThisInitialized(_this7), "_ids", new _Set());

	    _defineProperty(_assertThisInitialized(_this7), "_options", void 0);

	    _this7._options = options || {};
	    _this7._listener = _bindInstanceProperty$1(_context27 = _this7._onEvent).call(_context27, _assertThisInitialized(_this7));

	    _this7.setData(data);

	    return _this7;
	  } // TODO: implement a function .config() to dynamically update things like configured filter
	  // and trigger changes accordingly

	  /**
	   * Set a data source for the view.
	   *
	   * @param data - The instance containing data (directly or indirectly).
	   * @remarks
	   * Note that when the data view is bound to a data set it won't be garbage
	   * collected unless the data set is too. Use `dataView.setData(null)` or
	   * `dataView.dispose()` to enable garbage collection before you lose the last
	   * reference.
	   */


	  _createClass(DataView, [{
	    key: "idProp",
	    get:
	    /** @inheritDoc */

	    /** @inheritDoc */
	    function get() {
	      return this.getDataSet().idProp;
	    }
	  }, {
	    key: "setData",
	    value: function setData(data) {
	      if (this._data) {
	        // unsubscribe from current dataset
	        if (this._data.off) {
	          this._data.off("*", this._listener);
	        } // trigger a remove of all items in memory


	        var ids = this._data.getIds({
	          filter: _filterInstanceProperty(this._options)
	        });

	        var items = this._data.get(ids);

	        this._ids.clear();

	        this.length = 0;

	        this._trigger("remove", {
	          items: ids,
	          oldData: items
	        });
	      }

	      if (data != null) {
	        this._data = data; // trigger an add of all added items

	        var _ids = this._data.getIds({
	          filter: _filterInstanceProperty(this._options)
	        });

	        for (var i = 0, len = _ids.length; i < len; i++) {
	          var id = _ids[i];

	          this._ids.add(id);
	        }

	        this.length = _ids.length;

	        this._trigger("add", {
	          items: _ids
	        });
	      } else {
	        this._data = new DataSet();
	      } // subscribe to new dataset


	      if (this._data.on) {
	        this._data.on("*", this._listener);
	      }
	    }
	    /**
	     * Refresh the DataView.
	     * Useful when the DataView has a filter function containing a variable parameter.
	     */

	  }, {
	    key: "refresh",
	    value: function refresh() {
	      var ids = this._data.getIds({
	        filter: _filterInstanceProperty(this._options)
	      });

	      var oldIds = _toConsumableArray(this._ids);

	      var newIds = {};
	      var addedIds = [];
	      var removedIds = [];
	      var removedItems = []; // check for additions

	      for (var i = 0, len = ids.length; i < len; i++) {
	        var id = ids[i];
	        newIds[id] = true;

	        if (!this._ids.has(id)) {
	          addedIds.push(id);

	          this._ids.add(id);
	        }
	      } // check for removals


	      for (var _i10 = 0, _len11 = oldIds.length; _i10 < _len11; _i10++) {
	        var _id7 = oldIds[_i10];

	        var item = this._data.get(_id7);

	        if (item == null) {
	          // @TODO: Investigate.
	          // Doesn't happen during tests or examples.
	          // Is it really impossible or could it eventually happen?
	          // How to handle it if it does? The types guarantee non-nullable items.
	          console.error("If you see this, report it please.");
	        } else if (!newIds[_id7]) {
	          removedIds.push(_id7);
	          removedItems.push(item);

	          this._ids.delete(_id7);
	        }
	      }

	      this.length += addedIds.length - removedIds.length; // trigger events

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        });
	      }

	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        });
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "get",
	    value: function get(first, second) {
	      if (this._data == null) {
	        return null;
	      } // parse the arguments


	      var ids = null;
	      var options;

	      if (isId(first) || _Array$isArray(first)) {
	        ids = first;
	        options = second;
	      } else {
	        options = first;
	      } // extend the options with the default options and provided options


	      var viewOptions = _Object$assign({}, this._options, options); // create a combined filter method when needed


	      var thisFilter = _filterInstanceProperty(this._options);

	      var optionsFilter = options && _filterInstanceProperty(options);

	      if (thisFilter && optionsFilter) {
	        viewOptions.filter = function (item) {
	          return thisFilter(item) && optionsFilter(item);
	        };
	      }

	      if (ids == null) {
	        return this._data.get(viewOptions);
	      } else {
	        return this._data.get(ids, viewOptions);
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "getIds",
	    value: function getIds(options) {
	      if (this._data.length) {
	        var defaultFilter = _filterInstanceProperty(this._options);

	        var optionsFilter = options != null ? _filterInstanceProperty(options) : null;
	        var filter;

	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }

	        return this._data.getIds({
	          filter: filter,
	          order: options && options.order
	        });
	      } else {
	        return [];
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "forEach",
	    value: function forEach(callback, options) {
	      if (this._data) {
	        var _context28;

	        var defaultFilter = _filterInstanceProperty(this._options);

	        var optionsFilter = options && _filterInstanceProperty(options);

	        var filter;

	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }

	        _forEachInstanceProperty(_context28 = this._data).call(_context28, callback, {
	          filter: filter,
	          order: options && options.order
	        });
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "map",
	    value: function map(callback, options) {
	      if (this._data) {
	        var _context29;

	        var defaultFilter = _filterInstanceProperty(this._options);

	        var optionsFilter = options && _filterInstanceProperty(options);

	        var filter;

	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }

	        return _mapInstanceProperty(_context29 = this._data).call(_context29, callback, {
	          filter: filter,
	          order: options && options.order
	        });
	      } else {
	        return [];
	      }
	    }
	    /** @inheritDoc */

	  }, {
	    key: "getDataSet",
	    value: function getDataSet() {
	      return this._data.getDataSet();
	    }
	    /** @inheritDoc */

	  }, {
	    key: "stream",
	    value: function stream(ids) {
	      var _context30;

	      return this._data.stream(ids || _defineProperty({}, _Symbol$iterator2, _bindInstanceProperty$1(_context30 = _keysInstanceProperty(this._ids)).call(_context30, this._ids)));
	    }
	    /**
	     * Render the instance unusable prior to garbage collection.
	     *
	     * @remarks
	     * The intention of this method is to help discover scenarios where the data
	     * view is being used when the programmer thinks it has been garbage collected
	     * already. It's stricter version of `dataView.setData(null)`.
	     */

	  }, {
	    key: "dispose",
	    value: function dispose() {
	      var _this$_data;

	      if ((_this$_data = this._data) !== null && _this$_data !== void 0 && _this$_data.off) {
	        this._data.off("*", this._listener);
	      }

	      var message = "This data view has already been disposed of.";
	      var replacement = {
	        get: function get() {
	          throw new Error(message);
	        },
	        set: function set() {
	          throw new Error(message);
	        },
	        configurable: false
	      };

	      var _iterator14 = _createForOfIteratorHelper$6(_Reflect$ownKeys(DataView.prototype)),
	          _step14;

	      try {
	        for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
	          var key = _step14.value;

	          _Object$defineProperty$1(this, key, replacement);
	        }
	      } catch (err) {
	        _iterator14.e(err);
	      } finally {
	        _iterator14.f();
	      }
	    }
	    /**
	     * Event listener. Will propagate all events from the connected data set to the subscribers of the DataView, but will filter the items and only trigger when there are changes in the filtered data set.
	     *
	     * @param event - The name of the event.
	     * @param params - Parameters of the event.
	     * @param senderId - Id supplied by the sender.
	     */

	  }, {
	    key: "_onEvent",
	    value: function _onEvent(event, params, senderId) {
	      if (!params || !params.items || !this._data) {
	        return;
	      }

	      var ids = params.items;
	      var addedIds = [];
	      var updatedIds = [];
	      var removedIds = [];
	      var oldItems = [];
	      var updatedItems = [];
	      var removedItems = [];

	      switch (event) {
	        case "add":
	          // filter the ids of the added items
	          for (var i = 0, len = ids.length; i < len; i++) {
	            var id = ids[i];
	            var item = this.get(id);

	            if (item) {
	              this._ids.add(id);

	              addedIds.push(id);
	            }
	          }

	          break;

	        case "update":
	          // determine the event from the views viewpoint: an updated
	          // item can be added, updated, or removed from this view.
	          for (var _i11 = 0, _len12 = ids.length; _i11 < _len12; _i11++) {
	            var _id8 = ids[_i11];

	            var _item5 = this.get(_id8);

	            if (_item5) {
	              if (this._ids.has(_id8)) {
	                updatedIds.push(_id8);
	                updatedItems.push(params.data[_i11]);
	                oldItems.push(params.oldData[_i11]);
	              } else {
	                this._ids.add(_id8);

	                addedIds.push(_id8);
	              }
	            } else {
	              if (this._ids.has(_id8)) {
	                this._ids.delete(_id8);

	                removedIds.push(_id8);
	                removedItems.push(params.oldData[_i11]);
	              }
	            }
	          }

	          break;

	        case "remove":
	          // filter the ids of the removed items
	          for (var _i12 = 0, _len13 = ids.length; _i12 < _len13; _i12++) {
	            var _id9 = ids[_i12];

	            if (this._ids.has(_id9)) {
	              this._ids.delete(_id9);

	              removedIds.push(_id9);
	              removedItems.push(params.oldData[_i12]);
	            }
	          }

	          break;
	      }

	      this.length += addedIds.length - removedIds.length;

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }

	      if (updatedIds.length) {
	        this._trigger("update", {
	          items: updatedIds,
	          oldData: oldItems,
	          data: updatedItems
	        }, senderId);
	      }

	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        }, senderId);
	      }
	    }
	  }]);

	  return DataView;
	}(DataSetPart);
	/**
	 * Check that given value is compatible with Vis Data Set interface.
	 *
	 * @param idProp - The expected property to contain item id.
	 * @param v - The value to be tested.
	 * @returns True if all expected values and methods match, false otherwise.
	 */


	function isDataSetLike(idProp, v) {
	  return _typeof$1(v) === "object" && v !== null && idProp === v.idProp && typeof v.add === "function" && typeof v.clear === "function" && typeof v.distinct === "function" && typeof _forEachInstanceProperty(v) === "function" && typeof v.get === "function" && typeof v.getDataSet === "function" && typeof v.getIds === "function" && typeof v.length === "number" && typeof _mapInstanceProperty(v) === "function" && typeof v.max === "function" && typeof v.min === "function" && typeof v.off === "function" && typeof v.on === "function" && typeof v.remove === "function" && typeof v.setOptions === "function" && typeof v.stream === "function" && typeof v.update === "function" && typeof v.updateOnly === "function";
	}
	/**
	 * Check that given value is compatible with Vis Data View interface.
	 *
	 * @param idProp - The expected property to contain item id.
	 * @param v - The value to be tested.
	 * @returns True if all expected values and methods match, false otherwise.
	 */


	function isDataViewLike$1(idProp, v) {
	  return _typeof$1(v) === "object" && v !== null && idProp === v.idProp && typeof _forEachInstanceProperty(v) === "function" && typeof v.get === "function" && typeof v.getDataSet === "function" && typeof v.getIds === "function" && typeof v.length === "number" && typeof _mapInstanceProperty(v) === "function" && typeof v.off === "function" && typeof v.on === "function" && typeof v.stream === "function" && isDataSetLike(idProp, v.getDataSet());
	}

	// use this instance. Else, load via commonjs.
	//
	// Note: This doesn't work in ESM.

	var moment$2 = typeof window !== 'undefined' && window['moment'] || requireMoment();

	var momentExports = requireMoment();

	var lib$1 = {exports: {}};

	var _default$1 = {};

	var lib = {exports: {}};

	var _default = {};

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */

	function getDefaultWhiteList$1() {
	  // 白名单值说明：
	  // true: 允许该属性
	  // Function: function (val) { } 返回true表示允许该属性，其他值均表示不允许
	  // RegExp: regexp.test(val) 返回true表示允许该属性，其他值均表示不允许
	  // 除上面列出的值外均表示不允许
	  var whiteList = {};
	  whiteList['align-content'] = false; // default: auto

	  whiteList['align-items'] = false; // default: auto

	  whiteList['align-self'] = false; // default: auto

	  whiteList['alignment-adjust'] = false; // default: auto

	  whiteList['alignment-baseline'] = false; // default: baseline

	  whiteList['all'] = false; // default: depending on individual properties

	  whiteList['anchor-point'] = false; // default: none

	  whiteList['animation'] = false; // default: depending on individual properties

	  whiteList['animation-delay'] = false; // default: 0

	  whiteList['animation-direction'] = false; // default: normal

	  whiteList['animation-duration'] = false; // default: 0

	  whiteList['animation-fill-mode'] = false; // default: none

	  whiteList['animation-iteration-count'] = false; // default: 1

	  whiteList['animation-name'] = false; // default: none

	  whiteList['animation-play-state'] = false; // default: running

	  whiteList['animation-timing-function'] = false; // default: ease

	  whiteList['azimuth'] = false; // default: center

	  whiteList['backface-visibility'] = false; // default: visible

	  whiteList['background'] = true; // default: depending on individual properties

	  whiteList['background-attachment'] = true; // default: scroll

	  whiteList['background-clip'] = true; // default: border-box

	  whiteList['background-color'] = true; // default: transparent

	  whiteList['background-image'] = true; // default: none

	  whiteList['background-origin'] = true; // default: padding-box

	  whiteList['background-position'] = true; // default: 0% 0%

	  whiteList['background-repeat'] = true; // default: repeat

	  whiteList['background-size'] = true; // default: auto

	  whiteList['baseline-shift'] = false; // default: baseline

	  whiteList['binding'] = false; // default: none

	  whiteList['bleed'] = false; // default: 6pt

	  whiteList['bookmark-label'] = false; // default: content()

	  whiteList['bookmark-level'] = false; // default: none

	  whiteList['bookmark-state'] = false; // default: open

	  whiteList['border'] = true; // default: depending on individual properties

	  whiteList['border-bottom'] = true; // default: depending on individual properties

	  whiteList['border-bottom-color'] = true; // default: current color

	  whiteList['border-bottom-left-radius'] = true; // default: 0

	  whiteList['border-bottom-right-radius'] = true; // default: 0

	  whiteList['border-bottom-style'] = true; // default: none

	  whiteList['border-bottom-width'] = true; // default: medium

	  whiteList['border-collapse'] = true; // default: separate

	  whiteList['border-color'] = true; // default: depending on individual properties

	  whiteList['border-image'] = true; // default: none

	  whiteList['border-image-outset'] = true; // default: 0

	  whiteList['border-image-repeat'] = true; // default: stretch

	  whiteList['border-image-slice'] = true; // default: 100%

	  whiteList['border-image-source'] = true; // default: none

	  whiteList['border-image-width'] = true; // default: 1

	  whiteList['border-left'] = true; // default: depending on individual properties

	  whiteList['border-left-color'] = true; // default: current color

	  whiteList['border-left-style'] = true; // default: none

	  whiteList['border-left-width'] = true; // default: medium

	  whiteList['border-radius'] = true; // default: 0

	  whiteList['border-right'] = true; // default: depending on individual properties

	  whiteList['border-right-color'] = true; // default: current color

	  whiteList['border-right-style'] = true; // default: none

	  whiteList['border-right-width'] = true; // default: medium

	  whiteList['border-spacing'] = true; // default: 0

	  whiteList['border-style'] = true; // default: depending on individual properties

	  whiteList['border-top'] = true; // default: depending on individual properties

	  whiteList['border-top-color'] = true; // default: current color

	  whiteList['border-top-left-radius'] = true; // default: 0

	  whiteList['border-top-right-radius'] = true; // default: 0

	  whiteList['border-top-style'] = true; // default: none

	  whiteList['border-top-width'] = true; // default: medium

	  whiteList['border-width'] = true; // default: depending on individual properties

	  whiteList['bottom'] = false; // default: auto

	  whiteList['box-decoration-break'] = true; // default: slice

	  whiteList['box-shadow'] = true; // default: none

	  whiteList['box-sizing'] = true; // default: content-box

	  whiteList['box-snap'] = true; // default: none

	  whiteList['box-suppress'] = true; // default: show

	  whiteList['break-after'] = true; // default: auto

	  whiteList['break-before'] = true; // default: auto

	  whiteList['break-inside'] = true; // default: auto

	  whiteList['caption-side'] = false; // default: top

	  whiteList['chains'] = false; // default: none

	  whiteList['clear'] = true; // default: none

	  whiteList['clip'] = false; // default: auto

	  whiteList['clip-path'] = false; // default: none

	  whiteList['clip-rule'] = false; // default: nonzero

	  whiteList['color'] = true; // default: implementation dependent

	  whiteList['color-interpolation-filters'] = true; // default: auto

	  whiteList['column-count'] = false; // default: auto

	  whiteList['column-fill'] = false; // default: balance

	  whiteList['column-gap'] = false; // default: normal

	  whiteList['column-rule'] = false; // default: depending on individual properties

	  whiteList['column-rule-color'] = false; // default: current color

	  whiteList['column-rule-style'] = false; // default: medium

	  whiteList['column-rule-width'] = false; // default: medium

	  whiteList['column-span'] = false; // default: none

	  whiteList['column-width'] = false; // default: auto

	  whiteList['columns'] = false; // default: depending on individual properties

	  whiteList['contain'] = false; // default: none

	  whiteList['content'] = false; // default: normal

	  whiteList['counter-increment'] = false; // default: none

	  whiteList['counter-reset'] = false; // default: none

	  whiteList['counter-set'] = false; // default: none

	  whiteList['crop'] = false; // default: auto

	  whiteList['cue'] = false; // default: depending on individual properties

	  whiteList['cue-after'] = false; // default: none

	  whiteList['cue-before'] = false; // default: none

	  whiteList['cursor'] = false; // default: auto

	  whiteList['direction'] = false; // default: ltr

	  whiteList['display'] = true; // default: depending on individual properties

	  whiteList['display-inside'] = true; // default: auto

	  whiteList['display-list'] = true; // default: none

	  whiteList['display-outside'] = true; // default: inline-level

	  whiteList['dominant-baseline'] = false; // default: auto

	  whiteList['elevation'] = false; // default: level

	  whiteList['empty-cells'] = false; // default: show

	  whiteList['filter'] = false; // default: none

	  whiteList['flex'] = false; // default: depending on individual properties

	  whiteList['flex-basis'] = false; // default: auto

	  whiteList['flex-direction'] = false; // default: row

	  whiteList['flex-flow'] = false; // default: depending on individual properties

	  whiteList['flex-grow'] = false; // default: 0

	  whiteList['flex-shrink'] = false; // default: 1

	  whiteList['flex-wrap'] = false; // default: nowrap

	  whiteList['float'] = false; // default: none

	  whiteList['float-offset'] = false; // default: 0 0

	  whiteList['flood-color'] = false; // default: black

	  whiteList['flood-opacity'] = false; // default: 1

	  whiteList['flow-from'] = false; // default: none

	  whiteList['flow-into'] = false; // default: none

	  whiteList['font'] = true; // default: depending on individual properties

	  whiteList['font-family'] = true; // default: implementation dependent

	  whiteList['font-feature-settings'] = true; // default: normal

	  whiteList['font-kerning'] = true; // default: auto

	  whiteList['font-language-override'] = true; // default: normal

	  whiteList['font-size'] = true; // default: medium

	  whiteList['font-size-adjust'] = true; // default: none

	  whiteList['font-stretch'] = true; // default: normal

	  whiteList['font-style'] = true; // default: normal

	  whiteList['font-synthesis'] = true; // default: weight style

	  whiteList['font-variant'] = true; // default: normal

	  whiteList['font-variant-alternates'] = true; // default: normal

	  whiteList['font-variant-caps'] = true; // default: normal

	  whiteList['font-variant-east-asian'] = true; // default: normal

	  whiteList['font-variant-ligatures'] = true; // default: normal

	  whiteList['font-variant-numeric'] = true; // default: normal

	  whiteList['font-variant-position'] = true; // default: normal

	  whiteList['font-weight'] = true; // default: normal

	  whiteList['grid'] = false; // default: depending on individual properties

	  whiteList['grid-area'] = false; // default: depending on individual properties

	  whiteList['grid-auto-columns'] = false; // default: auto

	  whiteList['grid-auto-flow'] = false; // default: none

	  whiteList['grid-auto-rows'] = false; // default: auto

	  whiteList['grid-column'] = false; // default: depending on individual properties

	  whiteList['grid-column-end'] = false; // default: auto

	  whiteList['grid-column-start'] = false; // default: auto

	  whiteList['grid-row'] = false; // default: depending on individual properties

	  whiteList['grid-row-end'] = false; // default: auto

	  whiteList['grid-row-start'] = false; // default: auto

	  whiteList['grid-template'] = false; // default: depending on individual properties

	  whiteList['grid-template-areas'] = false; // default: none

	  whiteList['grid-template-columns'] = false; // default: none

	  whiteList['grid-template-rows'] = false; // default: none

	  whiteList['hanging-punctuation'] = false; // default: none

	  whiteList['height'] = true; // default: auto

	  whiteList['hyphens'] = false; // default: manual

	  whiteList['icon'] = false; // default: auto

	  whiteList['image-orientation'] = false; // default: auto

	  whiteList['image-resolution'] = false; // default: normal

	  whiteList['ime-mode'] = false; // default: auto

	  whiteList['initial-letters'] = false; // default: normal

	  whiteList['inline-box-align'] = false; // default: last

	  whiteList['justify-content'] = false; // default: auto

	  whiteList['justify-items'] = false; // default: auto

	  whiteList['justify-self'] = false; // default: auto

	  whiteList['left'] = false; // default: auto

	  whiteList['letter-spacing'] = true; // default: normal

	  whiteList['lighting-color'] = true; // default: white

	  whiteList['line-box-contain'] = false; // default: block inline replaced

	  whiteList['line-break'] = false; // default: auto

	  whiteList['line-grid'] = false; // default: match-parent

	  whiteList['line-height'] = false; // default: normal

	  whiteList['line-snap'] = false; // default: none

	  whiteList['line-stacking'] = false; // default: depending on individual properties

	  whiteList['line-stacking-ruby'] = false; // default: exclude-ruby

	  whiteList['line-stacking-shift'] = false; // default: consider-shifts

	  whiteList['line-stacking-strategy'] = false; // default: inline-line-height

	  whiteList['list-style'] = true; // default: depending on individual properties

	  whiteList['list-style-image'] = true; // default: none

	  whiteList['list-style-position'] = true; // default: outside

	  whiteList['list-style-type'] = true; // default: disc

	  whiteList['margin'] = true; // default: depending on individual properties

	  whiteList['margin-bottom'] = true; // default: 0

	  whiteList['margin-left'] = true; // default: 0

	  whiteList['margin-right'] = true; // default: 0

	  whiteList['margin-top'] = true; // default: 0

	  whiteList['marker-offset'] = false; // default: auto

	  whiteList['marker-side'] = false; // default: list-item

	  whiteList['marks'] = false; // default: none

	  whiteList['mask'] = false; // default: border-box

	  whiteList['mask-box'] = false; // default: see individual properties

	  whiteList['mask-box-outset'] = false; // default: 0

	  whiteList['mask-box-repeat'] = false; // default: stretch

	  whiteList['mask-box-slice'] = false; // default: 0 fill

	  whiteList['mask-box-source'] = false; // default: none

	  whiteList['mask-box-width'] = false; // default: auto

	  whiteList['mask-clip'] = false; // default: border-box

	  whiteList['mask-image'] = false; // default: none

	  whiteList['mask-origin'] = false; // default: border-box

	  whiteList['mask-position'] = false; // default: center

	  whiteList['mask-repeat'] = false; // default: no-repeat

	  whiteList['mask-size'] = false; // default: border-box

	  whiteList['mask-source-type'] = false; // default: auto

	  whiteList['mask-type'] = false; // default: luminance

	  whiteList['max-height'] = true; // default: none

	  whiteList['max-lines'] = false; // default: none

	  whiteList['max-width'] = true; // default: none

	  whiteList['min-height'] = true; // default: 0

	  whiteList['min-width'] = true; // default: 0

	  whiteList['move-to'] = false; // default: normal

	  whiteList['nav-down'] = false; // default: auto

	  whiteList['nav-index'] = false; // default: auto

	  whiteList['nav-left'] = false; // default: auto

	  whiteList['nav-right'] = false; // default: auto

	  whiteList['nav-up'] = false; // default: auto

	  whiteList['object-fit'] = false; // default: fill

	  whiteList['object-position'] = false; // default: 50% 50%

	  whiteList['opacity'] = false; // default: 1

	  whiteList['order'] = false; // default: 0

	  whiteList['orphans'] = false; // default: 2

	  whiteList['outline'] = false; // default: depending on individual properties

	  whiteList['outline-color'] = false; // default: invert

	  whiteList['outline-offset'] = false; // default: 0

	  whiteList['outline-style'] = false; // default: none

	  whiteList['outline-width'] = false; // default: medium

	  whiteList['overflow'] = false; // default: depending on individual properties

	  whiteList['overflow-wrap'] = false; // default: normal

	  whiteList['overflow-x'] = false; // default: visible

	  whiteList['overflow-y'] = false; // default: visible

	  whiteList['padding'] = true; // default: depending on individual properties

	  whiteList['padding-bottom'] = true; // default: 0

	  whiteList['padding-left'] = true; // default: 0

	  whiteList['padding-right'] = true; // default: 0

	  whiteList['padding-top'] = true; // default: 0

	  whiteList['page'] = false; // default: auto

	  whiteList['page-break-after'] = false; // default: auto

	  whiteList['page-break-before'] = false; // default: auto

	  whiteList['page-break-inside'] = false; // default: auto

	  whiteList['page-policy'] = false; // default: start

	  whiteList['pause'] = false; // default: implementation dependent

	  whiteList['pause-after'] = false; // default: implementation dependent

	  whiteList['pause-before'] = false; // default: implementation dependent

	  whiteList['perspective'] = false; // default: none

	  whiteList['perspective-origin'] = false; // default: 50% 50%

	  whiteList['pitch'] = false; // default: medium

	  whiteList['pitch-range'] = false; // default: 50

	  whiteList['play-during'] = false; // default: auto

	  whiteList['position'] = false; // default: static

	  whiteList['presentation-level'] = false; // default: 0

	  whiteList['quotes'] = false; // default: text

	  whiteList['region-fragment'] = false; // default: auto

	  whiteList['resize'] = false; // default: none

	  whiteList['rest'] = false; // default: depending on individual properties

	  whiteList['rest-after'] = false; // default: none

	  whiteList['rest-before'] = false; // default: none

	  whiteList['richness'] = false; // default: 50

	  whiteList['right'] = false; // default: auto

	  whiteList['rotation'] = false; // default: 0

	  whiteList['rotation-point'] = false; // default: 50% 50%

	  whiteList['ruby-align'] = false; // default: auto

	  whiteList['ruby-merge'] = false; // default: separate

	  whiteList['ruby-position'] = false; // default: before

	  whiteList['shape-image-threshold'] = false; // default: 0.0

	  whiteList['shape-outside'] = false; // default: none

	  whiteList['shape-margin'] = false; // default: 0

	  whiteList['size'] = false; // default: auto

	  whiteList['speak'] = false; // default: auto

	  whiteList['speak-as'] = false; // default: normal

	  whiteList['speak-header'] = false; // default: once

	  whiteList['speak-numeral'] = false; // default: continuous

	  whiteList['speak-punctuation'] = false; // default: none

	  whiteList['speech-rate'] = false; // default: medium

	  whiteList['stress'] = false; // default: 50

	  whiteList['string-set'] = false; // default: none

	  whiteList['tab-size'] = false; // default: 8

	  whiteList['table-layout'] = false; // default: auto

	  whiteList['text-align'] = true; // default: start

	  whiteList['text-align-last'] = true; // default: auto

	  whiteList['text-combine-upright'] = true; // default: none

	  whiteList['text-decoration'] = true; // default: none

	  whiteList['text-decoration-color'] = true; // default: currentColor

	  whiteList['text-decoration-line'] = true; // default: none

	  whiteList['text-decoration-skip'] = true; // default: objects

	  whiteList['text-decoration-style'] = true; // default: solid

	  whiteList['text-emphasis'] = true; // default: depending on individual properties

	  whiteList['text-emphasis-color'] = true; // default: currentColor

	  whiteList['text-emphasis-position'] = true; // default: over right

	  whiteList['text-emphasis-style'] = true; // default: none

	  whiteList['text-height'] = true; // default: auto

	  whiteList['text-indent'] = true; // default: 0

	  whiteList['text-justify'] = true; // default: auto

	  whiteList['text-orientation'] = true; // default: mixed

	  whiteList['text-overflow'] = true; // default: clip

	  whiteList['text-shadow'] = true; // default: none

	  whiteList['text-space-collapse'] = true; // default: collapse

	  whiteList['text-transform'] = true; // default: none

	  whiteList['text-underline-position'] = true; // default: auto

	  whiteList['text-wrap'] = true; // default: normal

	  whiteList['top'] = false; // default: auto

	  whiteList['transform'] = false; // default: none

	  whiteList['transform-origin'] = false; // default: 50% 50% 0

	  whiteList['transform-style'] = false; // default: flat

	  whiteList['transition'] = false; // default: depending on individual properties

	  whiteList['transition-delay'] = false; // default: 0s

	  whiteList['transition-duration'] = false; // default: 0s

	  whiteList['transition-property'] = false; // default: all

	  whiteList['transition-timing-function'] = false; // default: ease

	  whiteList['unicode-bidi'] = false; // default: normal

	  whiteList['vertical-align'] = false; // default: baseline

	  whiteList['visibility'] = false; // default: visible

	  whiteList['voice-balance'] = false; // default: center

	  whiteList['voice-duration'] = false; // default: auto

	  whiteList['voice-family'] = false; // default: implementation dependent

	  whiteList['voice-pitch'] = false; // default: medium

	  whiteList['voice-range'] = false; // default: medium

	  whiteList['voice-rate'] = false; // default: normal

	  whiteList['voice-stress'] = false; // default: normal

	  whiteList['voice-volume'] = false; // default: medium

	  whiteList['volume'] = false; // default: medium

	  whiteList['white-space'] = false; // default: normal

	  whiteList['widows'] = false; // default: 2

	  whiteList['width'] = true; // default: auto

	  whiteList['will-change'] = false; // default: auto

	  whiteList['word-break'] = true; // default: normal

	  whiteList['word-spacing'] = true; // default: normal

	  whiteList['word-wrap'] = true; // default: normal

	  whiteList['wrap-flow'] = false; // default: auto

	  whiteList['wrap-through'] = false; // default: wrap

	  whiteList['writing-mode'] = false; // default: horizontal-tb

	  whiteList['z-index'] = false; // default: auto

	  return whiteList;
	}
	/**
	 * 匹配到白名单上的一个属性时
	 *
	 * @param {String} name
	 * @param {String} value
	 * @param {Object} options
	 * @return {String}
	 */


	function onAttr(name, value, options) {// do nothing
	}
	/**
	 * 匹配到不在白名单上的一个属性时
	 *
	 * @param {String} name
	 * @param {String} value
	 * @param {Object} options
	 * @return {String}
	 */


	function onIgnoreAttr(name, value, options) {// do nothing
	}

	var REGEXP_URL_JAVASCRIPT = /javascript\s*\:/img;
	/**
	 * 过滤属性值
	 *
	 * @param {String} name
	 * @param {String} value
	 * @return {String}
	 */

	function safeAttrValue$1(name, value) {
	  if (REGEXP_URL_JAVASCRIPT.test(value)) return '';
	  return value;
	}

	_default.whiteList = getDefaultWhiteList$1();
	_default.getDefaultWhiteList = getDefaultWhiteList$1;
	_default.onAttr = onAttr;
	_default.onIgnoreAttr = onIgnoreAttr;
	_default.safeAttrValue = safeAttrValue$1;

	var util$1 = {
	  indexOf: function (arr, item) {
	    var i, j;

	    if (Array.prototype.indexOf) {
	      return arr.indexOf(item);
	    }

	    for (i = 0, j = arr.length; i < j; i++) {
	      if (arr[i] === item) {
	        return i;
	      }
	    }

	    return -1;
	  },
	  forEach: function (arr, fn, scope) {
	    var i, j;

	    if (Array.prototype.forEach) {
	      return arr.forEach(fn, scope);
	    }

	    for (i = 0, j = arr.length; i < j; i++) {
	      fn.call(scope, arr[i], i, arr);
	    }
	  },
	  trim: function (str) {
	    if (String.prototype.trim) {
	      return str.trim();
	    }

	    return str.replace(/(^\s*)|(\s*$)/g, '');
	  },
	  trimRight: function (str) {
	    if (String.prototype.trimRight) {
	      return str.trimRight();
	    }

	    return str.replace(/(\s*$)/g, '');
	  }
	};

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */
	var _$3 = util$1;
	/**
	 * 解析style
	 *
	 * @param {String} css
	 * @param {Function} onAttr 处理属性的函数
	 *   参数格式： function (sourcePosition, position, name, value, source)
	 * @return {String}
	 */

	function parseStyle$1(css, onAttr) {
	  css = _$3.trimRight(css);
	  if (css[css.length - 1] !== ';') css += ';';
	  var cssLength = css.length;
	  var isParenthesisOpen = false;
	  var lastPos = 0;
	  var i = 0;
	  var retCSS = '';

	  function addNewAttr() {
	    // 如果没有正常的闭合圆括号，则直接忽略当前属性
	    if (!isParenthesisOpen) {
	      var source = _$3.trim(css.slice(lastPos, i));

	      var j = source.indexOf(':');

	      if (j !== -1) {
	        var name = _$3.trim(source.slice(0, j));

	        var value = _$3.trim(source.slice(j + 1)); // 必须有属性名称


	        if (name) {
	          var ret = onAttr(lastPos, retCSS.length, name, value, source);
	          if (ret) retCSS += ret + '; ';
	        }
	      }
	    }

	    lastPos = i + 1;
	  }

	  for (; i < cssLength; i++) {
	    var c = css[i];

	    if (c === '/' && css[i + 1] === '*') {
	      // 备注开始
	      var j = css.indexOf('*/', i + 2); // 如果没有正常的备注结束，则后面的部分全部跳过

	      if (j === -1) break; // 直接将当前位置调到备注结尾，并且初始化状态

	      i = j + 1;
	      lastPos = i + 1;
	      isParenthesisOpen = false;
	    } else if (c === '(') {
	      isParenthesisOpen = true;
	    } else if (c === ')') {
	      isParenthesisOpen = false;
	    } else if (c === ';') {
	      if (isParenthesisOpen) ; else {
	        addNewAttr();
	      }
	    } else if (c === '\n') {
	      addNewAttr();
	    }
	  }

	  return _$3.trim(retCSS);
	}

	var parser$2 = parseStyle$1;

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */
	var DEFAULT$1 = _default;
	var parseStyle = parser$2;
	/**
	 * 返回值是否为空
	 *
	 * @param {Object} obj
	 * @return {Boolean}
	 */

	function isNull$1(obj) {
	  return obj === undefined || obj === null;
	}
	/**
	 * 浅拷贝对象
	 *
	 * @param {Object} obj
	 * @return {Object}
	 */


	function shallowCopyObject$1(obj) {
	  var ret = {};

	  for (var i in obj) {
	    ret[i] = obj[i];
	  }

	  return ret;
	}
	/**
	 * 创建CSS过滤器
	 *
	 * @param {Object} options
	 *   - {Object} whiteList
	 *   - {Function} onAttr
	 *   - {Function} onIgnoreAttr
	 *   - {Function} safeAttrValue
	 */


	function FilterCSS$2(options) {
	  options = shallowCopyObject$1(options || {});
	  options.whiteList = options.whiteList || DEFAULT$1.whiteList;
	  options.onAttr = options.onAttr || DEFAULT$1.onAttr;
	  options.onIgnoreAttr = options.onIgnoreAttr || DEFAULT$1.onIgnoreAttr;
	  options.safeAttrValue = options.safeAttrValue || DEFAULT$1.safeAttrValue;
	  this.options = options;
	}

	FilterCSS$2.prototype.process = function (css) {
	  // 兼容各种奇葩输入
	  css = css || '';
	  css = css.toString();
	  if (!css) return '';
	  var me = this;
	  var options = me.options;
	  var whiteList = options.whiteList;
	  var onAttr = options.onAttr;
	  var onIgnoreAttr = options.onIgnoreAttr;
	  var safeAttrValue = options.safeAttrValue;
	  var retCSS = parseStyle(css, function (sourcePosition, position, name, value, source) {
	    var check = whiteList[name];
	    var isWhite = false;
	    if (check === true) isWhite = check;else if (typeof check === 'function') isWhite = check(value);else if (check instanceof RegExp) isWhite = check.test(value);
	    if (isWhite !== true) isWhite = false; // 如果过滤后 value 为空则直接忽略

	    value = safeAttrValue(name, value);
	    if (!value) return;
	    var opts = {
	      position: position,
	      sourcePosition: sourcePosition,
	      source: source,
	      isWhite: isWhite
	    };

	    if (isWhite) {
	      var ret = onAttr(name, value, opts);

	      if (isNull$1(ret)) {
	        return name + ':' + value;
	      } else {
	        return ret;
	      }
	    } else {
	      var ret = onIgnoreAttr(name, value, opts);

	      if (!isNull$1(ret)) {
	        return ret;
	      }
	    }
	  });
	  return retCSS;
	};

	var css = FilterCSS$2;

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */

	(function (module, exports) {
	  var DEFAULT = _default;
	  var FilterCSS = css;
	  /**
	   * XSS过滤
	   *
	   * @param {String} css 要过滤的CSS代码
	   * @param {Object} options 选项：whiteList, onAttr, onIgnoreAttr
	   * @return {String}
	   */

	  function filterCSS(html, options) {
	    var xss = new FilterCSS(options);
	    return xss.process(html);
	  } // 输出


	  exports = module.exports = filterCSS;
	  exports.FilterCSS = FilterCSS;

	  for (var i in DEFAULT) exports[i] = DEFAULT[i]; // 在浏览器端使用


	  if (typeof window !== 'undefined') {
	    window.filterCSS = module.exports;
	  }
	})(lib, lib.exports);

	var util = {
	  indexOf: function (arr, item) {
	    var i, j;

	    if (Array.prototype.indexOf) {
	      return arr.indexOf(item);
	    }

	    for (i = 0, j = arr.length; i < j; i++) {
	      if (arr[i] === item) {
	        return i;
	      }
	    }

	    return -1;
	  },
	  forEach: function (arr, fn, scope) {
	    var i, j;

	    if (Array.prototype.forEach) {
	      return arr.forEach(fn, scope);
	    }

	    for (i = 0, j = arr.length; i < j; i++) {
	      fn.call(scope, arr[i], i, arr);
	    }
	  },
	  trim: function (str) {
	    if (String.prototype.trim) {
	      return str.trim();
	    }

	    return str.replace(/(^\s*)|(\s*$)/g, "");
	  },
	  spaceIndex: function (str) {
	    var reg = /\s|\n|\t/;
	    var match = reg.exec(str);
	    return match ? match.index : -1;
	  }
	};

	/**
	 * default settings
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */
	var FilterCSS$1 = lib.exports.FilterCSS;
	var getDefaultCSSWhiteList = lib.exports.getDefaultWhiteList;
	var _$2 = util;

	function getDefaultWhiteList() {
	  return {
	    a: ["target", "href", "title"],
	    abbr: ["title"],
	    address: [],
	    area: ["shape", "coords", "href", "alt"],
	    article: [],
	    aside: [],
	    audio: ["autoplay", "controls", "crossorigin", "loop", "muted", "preload", "src"],
	    b: [],
	    bdi: ["dir"],
	    bdo: ["dir"],
	    big: [],
	    blockquote: ["cite"],
	    br: [],
	    caption: [],
	    center: [],
	    cite: [],
	    code: [],
	    col: ["align", "valign", "span", "width"],
	    colgroup: ["align", "valign", "span", "width"],
	    dd: [],
	    del: ["datetime"],
	    details: ["open"],
	    div: [],
	    dl: [],
	    dt: [],
	    em: [],
	    figcaption: [],
	    figure: [],
	    font: ["color", "size", "face"],
	    footer: [],
	    h1: [],
	    h2: [],
	    h3: [],
	    h4: [],
	    h5: [],
	    h6: [],
	    header: [],
	    hr: [],
	    i: [],
	    img: ["src", "alt", "title", "width", "height"],
	    ins: ["datetime"],
	    li: [],
	    mark: [],
	    nav: [],
	    ol: [],
	    p: [],
	    pre: [],
	    s: [],
	    section: [],
	    small: [],
	    span: [],
	    sub: [],
	    summary: [],
	    sup: [],
	    strong: [],
	    strike: [],
	    table: ["width", "border", "align", "valign"],
	    tbody: ["align", "valign"],
	    td: ["width", "rowspan", "colspan", "align", "valign"],
	    tfoot: ["align", "valign"],
	    th: ["width", "rowspan", "colspan", "align", "valign"],
	    thead: ["align", "valign"],
	    tr: ["rowspan", "align", "valign"],
	    tt: [],
	    u: [],
	    ul: [],
	    video: ["autoplay", "controls", "crossorigin", "loop", "muted", "playsinline", "poster", "preload", "src", "height", "width"]
	  };
	}

	var defaultCSSFilter = new FilterCSS$1();
	/**
	 * default onTag function
	 *
	 * @param {String} tag
	 * @param {String} html
	 * @param {Object} options
	 * @return {String}
	 */

	function onTag(tag, html, options) {// do nothing
	}
	/**
	 * default onIgnoreTag function
	 *
	 * @param {String} tag
	 * @param {String} html
	 * @param {Object} options
	 * @return {String}
	 */


	function onIgnoreTag(tag, html, options) {// do nothing
	}
	/**
	 * default onTagAttr function
	 *
	 * @param {String} tag
	 * @param {String} name
	 * @param {String} value
	 * @return {String}
	 */


	function onTagAttr(tag, name, value) {// do nothing
	}
	/**
	 * default onIgnoreTagAttr function
	 *
	 * @param {String} tag
	 * @param {String} name
	 * @param {String} value
	 * @return {String}
	 */


	function onIgnoreTagAttr(tag, name, value) {// do nothing
	}
	/**
	 * default escapeHtml function
	 *
	 * @param {String} html
	 */


	function escapeHtml(html) {
	  return html.replace(REGEXP_LT, "&lt;").replace(REGEXP_GT, "&gt;");
	}
	/**
	 * default safeAttrValue function
	 *
	 * @param {String} tag
	 * @param {String} name
	 * @param {String} value
	 * @param {Object} cssFilter
	 * @return {String}
	 */


	function safeAttrValue(tag, name, value, cssFilter) {
	  // unescape attribute value firstly
	  value = friendlyAttrValue(value);

	  if (name === "href" || name === "src") {
	    // filter `href` and `src` attribute
	    // only allow the value that starts with `http://` | `https://` | `mailto:` | `/` | `#`
	    value = _$2.trim(value);
	    if (value === "#") return "#";

	    if (!(value.substr(0, 7) === "http://" || value.substr(0, 8) === "https://" || value.substr(0, 7) === "mailto:" || value.substr(0, 4) === "tel:" || value.substr(0, 11) === "data:image/" || value.substr(0, 6) === "ftp://" || value.substr(0, 2) === "./" || value.substr(0, 3) === "../" || value[0] === "#" || value[0] === "/")) {
	      return "";
	    }
	  } else if (name === "background") {
	    // filter `background` attribute (maybe no use)
	    // `javascript:`
	    REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;

	    if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
	      return "";
	    }
	  } else if (name === "style") {
	    // `expression()`
	    REGEXP_DEFAULT_ON_TAG_ATTR_7.lastIndex = 0;

	    if (REGEXP_DEFAULT_ON_TAG_ATTR_7.test(value)) {
	      return "";
	    } // `url()`


	    REGEXP_DEFAULT_ON_TAG_ATTR_8.lastIndex = 0;

	    if (REGEXP_DEFAULT_ON_TAG_ATTR_8.test(value)) {
	      REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;

	      if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
	        return "";
	      }
	    }

	    if (cssFilter !== false) {
	      cssFilter = cssFilter || defaultCSSFilter;
	      value = cssFilter.process(value);
	    }
	  } // escape `<>"` before returns


	  value = escapeAttrValue(value);
	  return value;
	} // RegExp list


	var REGEXP_LT = /</g;
	var REGEXP_GT = />/g;
	var REGEXP_QUOTE = /"/g;
	var REGEXP_QUOTE_2 = /&quot;/g;
	var REGEXP_ATTR_VALUE_1 = /&#([a-zA-Z0-9]*);?/gim;
	var REGEXP_ATTR_VALUE_COLON = /&colon;?/gim;
	var REGEXP_ATTR_VALUE_NEWLINE = /&newline;?/gim; // var REGEXP_DEFAULT_ON_TAG_ATTR_3 = /\/\*|\*\//gm;

	var REGEXP_DEFAULT_ON_TAG_ATTR_4 = /((j\s*a\s*v\s*a|v\s*b|l\s*i\s*v\s*e)\s*s\s*c\s*r\s*i\s*p\s*t\s*|m\s*o\s*c\s*h\s*a):/gi; // var REGEXP_DEFAULT_ON_TAG_ATTR_5 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:/gi;
	// var REGEXP_DEFAULT_ON_TAG_ATTR_6 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:\s*image\//gi;

	var REGEXP_DEFAULT_ON_TAG_ATTR_7 = /e\s*x\s*p\s*r\s*e\s*s\s*s\s*i\s*o\s*n\s*\(.*/gi;
	var REGEXP_DEFAULT_ON_TAG_ATTR_8 = /u\s*r\s*l\s*\(.*/gi;
	/**
	 * escape double quote
	 *
	 * @param {String} str
	 * @return {String} str
	 */

	function escapeQuote(str) {
	  return str.replace(REGEXP_QUOTE, "&quot;");
	}
	/**
	 * unescape double quote
	 *
	 * @param {String} str
	 * @return {String} str
	 */


	function unescapeQuote(str) {
	  return str.replace(REGEXP_QUOTE_2, '"');
	}
	/**
	 * escape html entities
	 *
	 * @param {String} str
	 * @return {String}
	 */


	function escapeHtmlEntities(str) {
	  return str.replace(REGEXP_ATTR_VALUE_1, function replaceUnicode(str, code) {
	    return code[0] === "x" || code[0] === "X" ? String.fromCharCode(parseInt(code.substr(1), 16)) : String.fromCharCode(parseInt(code, 10));
	  });
	}
	/**
	 * escape html5 new danger entities
	 *
	 * @param {String} str
	 * @return {String}
	 */


	function escapeDangerHtml5Entities(str) {
	  return str.replace(REGEXP_ATTR_VALUE_COLON, ":").replace(REGEXP_ATTR_VALUE_NEWLINE, " ");
	}
	/**
	 * clear nonprintable characters
	 *
	 * @param {String} str
	 * @return {String}
	 */


	function clearNonPrintableCharacter(str) {
	  var str2 = "";

	  for (var i = 0, len = str.length; i < len; i++) {
	    str2 += str.charCodeAt(i) < 32 ? " " : str.charAt(i);
	  }

	  return _$2.trim(str2);
	}
	/**
	 * get friendly attribute value
	 *
	 * @param {String} str
	 * @return {String}
	 */


	function friendlyAttrValue(str) {
	  str = unescapeQuote(str);
	  str = escapeHtmlEntities(str);
	  str = escapeDangerHtml5Entities(str);
	  str = clearNonPrintableCharacter(str);
	  return str;
	}
	/**
	 * unescape attribute value
	 *
	 * @param {String} str
	 * @return {String}
	 */


	function escapeAttrValue(str) {
	  str = escapeQuote(str);
	  str = escapeHtml(str);
	  return str;
	}
	/**
	 * `onIgnoreTag` function for removing all the tags that are not in whitelist
	 */


	function onIgnoreTagStripAll() {
	  return "";
	}
	/**
	 * remove tag body
	 * specify a `tags` list, if the tag is not in the `tags` list then process by the specify function (optional)
	 *
	 * @param {array} tags
	 * @param {function} next
	 */


	function StripTagBody(tags, next) {
	  if (typeof next !== "function") {
	    next = function () {};
	  }

	  var isRemoveAllTag = !Array.isArray(tags);

	  function isRemoveTag(tag) {
	    if (isRemoveAllTag) return true;
	    return _$2.indexOf(tags, tag) !== -1;
	  }

	  var removeList = [];
	  var posStart = false;
	  return {
	    onIgnoreTag: function (tag, html, options) {
	      if (isRemoveTag(tag)) {
	        if (options.isClosing) {
	          var ret = "[/removed]";
	          var end = options.position + ret.length;
	          removeList.push([posStart !== false ? posStart : options.position, end]);
	          posStart = false;
	          return ret;
	        } else {
	          if (!posStart) {
	            posStart = options.position;
	          }

	          return "[removed]";
	        }
	      } else {
	        return next(tag, html, options);
	      }
	    },
	    remove: function (html) {
	      var rethtml = "";
	      var lastPos = 0;

	      _$2.forEach(removeList, function (pos) {
	        rethtml += html.slice(lastPos, pos[0]);
	        lastPos = pos[1];
	      });

	      rethtml += html.slice(lastPos);
	      return rethtml;
	    }
	  };
	}
	/**
	 * remove html comments
	 *
	 * @param {String} html
	 * @return {String}
	 */


	function stripCommentTag(html) {
	  var retHtml = "";
	  var lastPos = 0;

	  while (lastPos < html.length) {
	    var i = html.indexOf("<!--", lastPos);

	    if (i === -1) {
	      retHtml += html.slice(lastPos);
	      break;
	    }

	    retHtml += html.slice(lastPos, i);
	    var j = html.indexOf("-->", i);

	    if (j === -1) {
	      break;
	    }

	    lastPos = j + 3;
	  }

	  return retHtml;
	}
	/**
	 * remove invisible characters
	 *
	 * @param {String} html
	 * @return {String}
	 */


	function stripBlankChar(html) {
	  var chars = html.split("");
	  chars = chars.filter(function (char) {
	    var c = char.charCodeAt(0);
	    if (c === 127) return false;

	    if (c <= 31) {
	      if (c === 10 || c === 13) return true;
	      return false;
	    }

	    return true;
	  });
	  return chars.join("");
	}

	_default$1.whiteList = getDefaultWhiteList();
	_default$1.getDefaultWhiteList = getDefaultWhiteList;
	_default$1.onTag = onTag;
	_default$1.onIgnoreTag = onIgnoreTag;
	_default$1.onTagAttr = onTagAttr;
	_default$1.onIgnoreTagAttr = onIgnoreTagAttr;
	_default$1.safeAttrValue = safeAttrValue;
	_default$1.escapeHtml = escapeHtml;
	_default$1.escapeQuote = escapeQuote;
	_default$1.unescapeQuote = unescapeQuote;
	_default$1.escapeHtmlEntities = escapeHtmlEntities;
	_default$1.escapeDangerHtml5Entities = escapeDangerHtml5Entities;
	_default$1.clearNonPrintableCharacter = clearNonPrintableCharacter;
	_default$1.friendlyAttrValue = friendlyAttrValue;
	_default$1.escapeAttrValue = escapeAttrValue;
	_default$1.onIgnoreTagStripAll = onIgnoreTagStripAll;
	_default$1.StripTagBody = StripTagBody;
	_default$1.stripCommentTag = stripCommentTag;
	_default$1.stripBlankChar = stripBlankChar;
	_default$1.cssFilter = defaultCSSFilter;
	_default$1.getDefaultCSSWhiteList = getDefaultCSSWhiteList;

	var parser$1 = {};

	/**
	 * Simple HTML Parser
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */
	var _$1 = util;
	/**
	 * get tag name
	 *
	 * @param {String} html e.g. '<a hef="#">'
	 * @return {String}
	 */

	function getTagName(html) {
	  var i = _$1.spaceIndex(html);

	  var tagName;

	  if (i === -1) {
	    tagName = html.slice(1, -1);
	  } else {
	    tagName = html.slice(1, i + 1);
	  }

	  tagName = _$1.trim(tagName).toLowerCase();
	  if (tagName.slice(0, 1) === "/") tagName = tagName.slice(1);
	  if (tagName.slice(-1) === "/") tagName = tagName.slice(0, -1);
	  return tagName;
	}
	/**
	 * is close tag?
	 *
	 * @param {String} html 如：'<a hef="#">'
	 * @return {Boolean}
	 */


	function isClosing(html) {
	  return html.slice(0, 2) === "</";
	}
	/**
	 * parse input html and returns processed html
	 *
	 * @param {String} html
	 * @param {Function} onTag e.g. function (sourcePosition, position, tag, html, isClosing)
	 * @param {Function} escapeHtml
	 * @return {String}
	 */


	function parseTag$1(html, onTag, escapeHtml) {

	  var rethtml = "";
	  var lastPos = 0;
	  var tagStart = false;
	  var quoteStart = false;
	  var currentPos = 0;
	  var len = html.length;
	  var currentTagName = "";
	  var currentHtml = "";

	  chariterator: for (currentPos = 0; currentPos < len; currentPos++) {
	    var c = html.charAt(currentPos);

	    if (tagStart === false) {
	      if (c === "<") {
	        tagStart = currentPos;
	        continue;
	      }
	    } else {
	      if (quoteStart === false) {
	        if (c === "<") {
	          rethtml += escapeHtml(html.slice(lastPos, currentPos));
	          tagStart = currentPos;
	          lastPos = currentPos;
	          continue;
	        }

	        if (c === ">") {
	          rethtml += escapeHtml(html.slice(lastPos, tagStart));
	          currentHtml = html.slice(tagStart, currentPos + 1);
	          currentTagName = getTagName(currentHtml);
	          rethtml += onTag(tagStart, rethtml.length, currentTagName, currentHtml, isClosing(currentHtml));
	          lastPos = currentPos + 1;
	          tagStart = false;
	          continue;
	        }

	        if (c === '"' || c === "'") {
	          var i = 1;
	          var ic = html.charAt(currentPos - i);

	          while (ic.trim() === "" || ic === "=") {
	            if (ic === "=") {
	              quoteStart = c;
	              continue chariterator;
	            }

	            ic = html.charAt(currentPos - ++i);
	          }
	        }
	      } else {
	        if (c === quoteStart) {
	          quoteStart = false;
	          continue;
	        }
	      }
	    }
	  }

	  if (lastPos < html.length) {
	    rethtml += escapeHtml(html.substr(lastPos));
	  }

	  return rethtml;
	}

	var REGEXP_ILLEGAL_ATTR_NAME = /[^a-zA-Z0-9\\_:.-]/gim;
	/**
	 * parse input attributes and returns processed attributes
	 *
	 * @param {String} html e.g. `href="#" target="_blank"`
	 * @param {Function} onAttr e.g. `function (name, value)`
	 * @return {String}
	 */

	function parseAttr$1(html, onAttr) {

	  var lastPos = 0;
	  var lastMarkPos = 0;
	  var retAttrs = [];
	  var tmpName = false;
	  var len = html.length;

	  function addAttr(name, value) {
	    name = _$1.trim(name);
	    name = name.replace(REGEXP_ILLEGAL_ATTR_NAME, "").toLowerCase();
	    if (name.length < 1) return;
	    var ret = onAttr(name, value || "");
	    if (ret) retAttrs.push(ret);
	  } // 逐个分析字符


	  for (var i = 0; i < len; i++) {
	    var c = html.charAt(i);
	    var v, j;

	    if (tmpName === false && c === "=") {
	      tmpName = html.slice(lastPos, i);
	      lastPos = i + 1;
	      lastMarkPos = html.charAt(lastPos) === '"' || html.charAt(lastPos) === "'" ? lastPos : findNextQuotationMark(html, i + 1);
	      continue;
	    }

	    if (tmpName !== false) {
	      if (i === lastMarkPos) {
	        j = html.indexOf(c, i + 1);

	        if (j === -1) {
	          break;
	        } else {
	          v = _$1.trim(html.slice(lastMarkPos + 1, j));
	          addAttr(tmpName, v);
	          tmpName = false;
	          i = j;
	          lastPos = i + 1;
	          continue;
	        }
	      }
	    }

	    if (/\s|\n|\t/.test(c)) {
	      html = html.replace(/\s|\n|\t/g, " ");

	      if (tmpName === false) {
	        j = findNextEqual(html, i);

	        if (j === -1) {
	          v = _$1.trim(html.slice(lastPos, i));
	          addAttr(v);
	          tmpName = false;
	          lastPos = i + 1;
	          continue;
	        } else {
	          i = j - 1;
	          continue;
	        }
	      } else {
	        j = findBeforeEqual(html, i - 1);

	        if (j === -1) {
	          v = _$1.trim(html.slice(lastPos, i));
	          v = stripQuoteWrap(v);
	          addAttr(tmpName, v);
	          tmpName = false;
	          lastPos = i + 1;
	          continue;
	        } else {
	          continue;
	        }
	      }
	    }
	  }

	  if (lastPos < html.length) {
	    if (tmpName === false) {
	      addAttr(html.slice(lastPos));
	    } else {
	      addAttr(tmpName, stripQuoteWrap(_$1.trim(html.slice(lastPos))));
	    }
	  }

	  return _$1.trim(retAttrs.join(" "));
	}

	function findNextEqual(str, i) {
	  for (; i < str.length; i++) {
	    var c = str[i];
	    if (c === " ") continue;
	    if (c === "=") return i;
	    return -1;
	  }
	}

	function findNextQuotationMark(str, i) {
	  for (; i < str.length; i++) {
	    var c = str[i];
	    if (c === " ") continue;
	    if (c === "'" || c === '"') return i;
	    return -1;
	  }
	}

	function findBeforeEqual(str, i) {
	  for (; i > 0; i--) {
	    var c = str[i];
	    if (c === " ") continue;
	    if (c === "=") return i;
	    return -1;
	  }
	}

	function isQuoteWrapString(text) {
	  if (text[0] === '"' && text[text.length - 1] === '"' || text[0] === "'" && text[text.length - 1] === "'") {
	    return true;
	  } else {
	    return false;
	  }
	}

	function stripQuoteWrap(text) {
	  if (isQuoteWrapString(text)) {
	    return text.substr(1, text.length - 2);
	  } else {
	    return text;
	  }
	}

	parser$1.parseTag = parseTag$1;
	parser$1.parseAttr = parseAttr$1;

	/**
	 * filter xss
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */
	var FilterCSS = lib.exports.FilterCSS;
	var DEFAULT = _default$1;
	var parser = parser$1;
	var parseTag = parser.parseTag;
	var parseAttr = parser.parseAttr;
	var _ = util;
	/**
	 * returns `true` if the input value is `undefined` or `null`
	 *
	 * @param {Object} obj
	 * @return {Boolean}
	 */

	function isNull(obj) {
	  return obj === undefined || obj === null;
	}
	/**
	 * get attributes for a tag
	 *
	 * @param {String} html
	 * @return {Object}
	 *   - {String} html
	 *   - {Boolean} closing
	 */


	function getAttrs(html) {
	  var i = _.spaceIndex(html);

	  if (i === -1) {
	    return {
	      html: "",
	      closing: html[html.length - 2] === "/"
	    };
	  }

	  html = _.trim(html.slice(i + 1, -1));
	  var isClosing = html[html.length - 1] === "/";
	  if (isClosing) html = _.trim(html.slice(0, -1));
	  return {
	    html: html,
	    closing: isClosing
	  };
	}
	/**
	 * shallow copy
	 *
	 * @param {Object} obj
	 * @return {Object}
	 */


	function shallowCopyObject(obj) {
	  var ret = {};

	  for (var i in obj) {
	    ret[i] = obj[i];
	  }

	  return ret;
	}

	function keysToLowerCase(obj) {
	  var ret = {};

	  for (var i in obj) {
	    if (Array.isArray(obj[i])) {
	      ret[i.toLowerCase()] = obj[i].map(function (item) {
	        return item.toLowerCase();
	      });
	    } else {
	      ret[i.toLowerCase()] = obj[i];
	    }
	  }

	  return ret;
	}
	/**
	 * FilterXSS class
	 *
	 * @param {Object} options
	 *        whiteList (or allowList), onTag, onTagAttr, onIgnoreTag,
	 *        onIgnoreTagAttr, safeAttrValue, escapeHtml
	 *        stripIgnoreTagBody, allowCommentTag, stripBlankChar
	 *        css{whiteList, onAttr, onIgnoreAttr} `css=false` means don't use `cssfilter`
	 */


	function FilterXSS(options) {
	  options = shallowCopyObject(options || {});

	  if (options.stripIgnoreTag) {
	    if (options.onIgnoreTag) {
	      console.error('Notes: cannot use these two options "stripIgnoreTag" and "onIgnoreTag" at the same time');
	    }

	    options.onIgnoreTag = DEFAULT.onIgnoreTagStripAll;
	  }

	  if (options.whiteList || options.allowList) {
	    options.whiteList = keysToLowerCase(options.whiteList || options.allowList);
	  } else {
	    options.whiteList = DEFAULT.whiteList;
	  }

	  options.onTag = options.onTag || DEFAULT.onTag;
	  options.onTagAttr = options.onTagAttr || DEFAULT.onTagAttr;
	  options.onIgnoreTag = options.onIgnoreTag || DEFAULT.onIgnoreTag;
	  options.onIgnoreTagAttr = options.onIgnoreTagAttr || DEFAULT.onIgnoreTagAttr;
	  options.safeAttrValue = options.safeAttrValue || DEFAULT.safeAttrValue;
	  options.escapeHtml = options.escapeHtml || DEFAULT.escapeHtml;
	  this.options = options;

	  if (options.css === false) {
	    this.cssFilter = false;
	  } else {
	    options.css = options.css || {};
	    this.cssFilter = new FilterCSS(options.css);
	  }
	}
	/**
	 * start process and returns result
	 *
	 * @param {String} html
	 * @return {String}
	 */


	FilterXSS.prototype.process = function (html) {
	  // compatible with the input
	  html = html || "";
	  html = html.toString();
	  if (!html) return "";
	  var me = this;
	  var options = me.options;
	  var whiteList = options.whiteList;
	  var onTag = options.onTag;
	  var onIgnoreTag = options.onIgnoreTag;
	  var onTagAttr = options.onTagAttr;
	  var onIgnoreTagAttr = options.onIgnoreTagAttr;
	  var safeAttrValue = options.safeAttrValue;
	  var escapeHtml = options.escapeHtml;
	  var cssFilter = me.cssFilter; // remove invisible characters

	  if (options.stripBlankChar) {
	    html = DEFAULT.stripBlankChar(html);
	  } // remove html comments


	  if (!options.allowCommentTag) {
	    html = DEFAULT.stripCommentTag(html);
	  } // if enable stripIgnoreTagBody


	  var stripIgnoreTagBody = false;

	  if (options.stripIgnoreTagBody) {
	    stripIgnoreTagBody = DEFAULT.StripTagBody(options.stripIgnoreTagBody, onIgnoreTag);
	    onIgnoreTag = stripIgnoreTagBody.onIgnoreTag;
	  }

	  var retHtml = parseTag(html, function (sourcePosition, position, tag, html, isClosing) {
	    var info = {
	      sourcePosition: sourcePosition,
	      position: position,
	      isClosing: isClosing,
	      isWhite: Object.prototype.hasOwnProperty.call(whiteList, tag)
	    }; // call `onTag()`

	    var ret = onTag(tag, html, info);
	    if (!isNull(ret)) return ret;

	    if (info.isWhite) {
	      if (info.isClosing) {
	        return "</" + tag + ">";
	      }

	      var attrs = getAttrs(html);
	      var whiteAttrList = whiteList[tag];
	      var attrsHtml = parseAttr(attrs.html, function (name, value) {
	        // call `onTagAttr()`
	        var isWhiteAttr = _.indexOf(whiteAttrList, name) !== -1;
	        var ret = onTagAttr(tag, name, value, isWhiteAttr);
	        if (!isNull(ret)) return ret;

	        if (isWhiteAttr) {
	          // call `safeAttrValue()`
	          value = safeAttrValue(tag, name, value, cssFilter);

	          if (value) {
	            return name + '="' + value + '"';
	          } else {
	            return name;
	          }
	        } else {
	          // call `onIgnoreTagAttr()`
	          ret = onIgnoreTagAttr(tag, name, value, isWhiteAttr);
	          if (!isNull(ret)) return ret;
	          return;
	        }
	      }); // build new tag html

	      html = "<" + tag;
	      if (attrsHtml) html += " " + attrsHtml;
	      if (attrs.closing) html += " /";
	      html += ">";
	      return html;
	    } else {
	      // call `onIgnoreTag()`
	      ret = onIgnoreTag(tag, html, info);
	      if (!isNull(ret)) return ret;
	      return escapeHtml(html);
	    }
	  }, escapeHtml); // if enable stripIgnoreTagBody

	  if (stripIgnoreTagBody) {
	    retHtml = stripIgnoreTagBody.remove(retHtml);
	  }

	  return retHtml;
	};

	var xss = FilterXSS;

	/**
	 * xss
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */

	(function (module, exports) {
	  var DEFAULT = _default$1;
	  var parser = parser$1;
	  var FilterXSS = xss;
	  /**
	   * filter xss function
	   *
	   * @param {String} html
	   * @param {Object} options { whiteList, onTag, onTagAttr, onIgnoreTag, onIgnoreTagAttr, safeAttrValue, escapeHtml }
	   * @return {String}
	   */

	  function filterXSS(html, options) {
	    var xss = new FilterXSS(options);
	    return xss.process(html);
	  }

	  exports = module.exports = filterXSS;
	  exports.filterXSS = filterXSS;
	  exports.FilterXSS = FilterXSS;

	  (function () {
	    for (var i in DEFAULT) {
	      exports[i] = DEFAULT[i];
	    }

	    for (var j in parser) {
	      exports[j] = parser[j];
	    }
	  })(); // using `xss` on the browser, output `filterXSS` to the globals


	  if (typeof window !== "undefined") {
	    window.filterXSS = module.exports;
	  } // using `xss` on the WebWorker, output `filterXSS` to the globals


	  function isWorkerEnv() {
	    return typeof self !== "undefined" && typeof DedicatedWorkerGlobalScope !== "undefined" && self instanceof DedicatedWorkerGlobalScope;
	  }

	  if (isWorkerEnv()) {
	    self.filterXSS = module.exports;
	  }
	})(lib$1, lib$1.exports);

	var xssFilter = lib$1.exports;

	function ownKeys(object, enumerableOnly) { var keys = _Object$keys(object); if (_Object$getOwnPropertySymbols) { var symbols = _Object$getOwnPropertySymbols(object); enumerableOnly && (symbols = _filterInstanceProperty(symbols).call(symbols, function (sym) { return _Object$getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var _context8, _context9; var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? _forEachInstanceProperty(_context8 = ownKeys(Object(source), !0)).call(_context8, function (key) { _defineProperty(target, key, source[key]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(target, _Object$getOwnPropertyDescriptors(source)) : _forEachInstanceProperty(_context9 = ownKeys(Object(source))).call(_context9, function (key) { _Object$defineProperty$1(target, key, _Object$getOwnPropertyDescriptor(source, key)); }); } return target; }
	/**
	 * Test if an object implements the DataView interface from vis-data.
	 * Uses the idProp property instead of expecting a hardcoded id field "id".
	 */

	function isDataViewLike(obj) {
	  var _obj$idProp;

	  if (!obj) {
	    return false;
	  }

	  var idProp = (_obj$idProp = obj.idProp) !== null && _obj$idProp !== void 0 ? _obj$idProp : obj._idProp;

	  if (!idProp) {
	    return false;
	  }

	  return isDataViewLike$1(idProp, obj);
	} // parse ASP.Net Date pattern,
	// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
	// code from http://momentjs.com/

	var ASPDateRegex = /^\/?Date\((-?\d+)/i;
	var NumericRegex = /^\d+$/;
	/**
	 * Convert an object into another type
	 *
	 * @param object - Value of unknown type.
	 * @param type - Name of the desired type.
	 *
	 * @returns Object in the desired type.
	 * @throws Error
	 */

	function convert(object, type) {
	  var match;

	  if (object === undefined) {
	    return undefined;
	  }

	  if (object === null) {
	    return null;
	  }

	  if (!type) {
	    return object;
	  }

	  if (!(typeof type === "string") && !(type instanceof String)) {
	    throw new Error("Type must be a string");
	  } //noinspection FallthroughInSwitchStatementJS


	  switch (type) {
	    case "boolean":
	    case "Boolean":
	      return Boolean(object);

	    case "number":
	    case "Number":
	      if (isString(object) && !isNaN(Date.parse(object))) {
	        return momentExports(object).valueOf();
	      } else {
	        // @TODO: I don't think that Number and String constructors are a good idea.
	        // This could also fail if the object doesn't have valueOf method or if it's redefined.
	        // For example: Object.create(null) or { valueOf: 7 }.
	        return Number(object.valueOf());
	      }

	    case "string":
	    case "String":
	      return String(object);

	    case "Date":
	      try {
	        return convert(object, "Moment").toDate();
	      } catch (e) {
	        if (e instanceof TypeError) {
	          throw new TypeError("Cannot convert object of type " + getType(object) + " to type " + type);
	        } else {
	          throw e;
	        }
	      }

	    case "Moment":
	      if (isNumber(object)) {
	        return momentExports(object);
	      }

	      if (object instanceof Date) {
	        return momentExports(object.valueOf());
	      } else if (momentExports.isMoment(object)) {
	        return momentExports(object);
	      }

	      if (isString(object)) {
	        match = ASPDateRegex.exec(object);

	        if (match) {
	          // object is an ASP date
	          return momentExports(Number(match[1])); // parse number
	        }

	        match = NumericRegex.exec(object);

	        if (match) {
	          return momentExports(Number(object));
	        }

	        return momentExports(object); // parse string
	      } else {
	        throw new TypeError("Cannot convert object of type " + getType(object) + " to type " + type);
	      }

	    case "ISODate":
	      if (isNumber(object)) {
	        return new Date(object);
	      } else if (object instanceof Date) {
	        return object.toISOString();
	      } else if (momentExports.isMoment(object)) {
	        return object.toDate().toISOString();
	      } else if (isString(object)) {
	        match = ASPDateRegex.exec(object);

	        if (match) {
	          // object is an ASP date
	          return new Date(Number(match[1])).toISOString(); // parse number
	        } else {
	          return momentExports(object).format(); // ISO 8601
	        }
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type ISODate");
	      }

	    case "ASPDate":
	      if (isNumber(object)) {
	        return "/Date(" + object + ")/";
	      } else if (object instanceof Date || momentExports.isMoment(object)) {
	        return "/Date(" + object.valueOf() + ")/";
	      } else if (isString(object)) {
	        match = ASPDateRegex.exec(object);
	        var value;

	        if (match) {
	          // object is an ASP date
	          value = new Date(Number(match[1])).valueOf(); // parse number
	        } else {
	          value = new Date(object).valueOf(); // parse string
	        }

	        return "/Date(" + value + ")/";
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type ASPDate");
	      }

	    default:
	      throw new Error("Unknown type ".concat(type));
	  }
	}
	/**
	 * Create a Data Set like wrapper to seamlessly coerce data types.
	 *
	 * @param rawDS - The Data Set with raw uncoerced data.
	 * @param type - A record assigning a data type to property name.
	 *
	 * @remarks
	 * The write operations (`add`, `remove`, `update` and `updateOnly`) write into
	 * the raw (uncoerced) data set. These values are then picked up by a pipe
	 * which coerces the values using the [[convert]] function and feeds them into
	 * the coerced data set. When querying (`forEach`, `get`, `getIds`, `off` and
	 * `on`) the values are then fetched from the coerced data set and already have
	 * the required data types. The values are coerced only once when inserted and
	 * then the same value is returned each time until it is updated or deleted.
	 *
	 * For example: `typeCoercedDataSet.add({ id: 7, start: "2020-01-21" })` would
	 * result in `typeCoercedDataSet.get(7)` returning `{ id: 7, start: moment(new
	 * Date("2020-01-21")).toDate() }`.
	 *
	 * Use the dispose method prior to throwing a reference to this away. Otherwise
	 * the pipe connecting the two Data Sets will keep the unaccessible coerced
	 * Data Set alive and updated as long as the raw Data Set exists.
	 *
	 * @returns A Data Set like object that saves data into the raw Data Set and
	 * retrieves them from the coerced Data Set.
	 */

	function typeCoerceDataSet(rawDS) {
	  var _context, _context3, _context4, _context5, _context6, _context7;

	  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
	    start: "Date",
	    end: "Date"
	  };
	  var idProp = rawDS._idProp;
	  var coercedDS = new DataSet({
	    fieldId: idProp
	  });

	  var pipe = _mapInstanceProperty(_context = createNewDataPipeFrom(rawDS)).call(_context, function (item) {
	    var _context2;

	    return _reduceInstanceProperty(_context2 = _Object$keys(item)).call(_context2, function (acc, key) {
	      acc[key] = convert(item[key], type[key]);
	      return acc;
	    }, {});
	  }).to(coercedDS);

	  pipe.all().start();
	  return {
	    // Write only.
	    add: function add() {
	      var _rawDS$getDataSet;

	      return (_rawDS$getDataSet = rawDS.getDataSet()).add.apply(_rawDS$getDataSet, arguments);
	    },
	    remove: function remove() {
	      var _rawDS$getDataSet2;

	      return (_rawDS$getDataSet2 = rawDS.getDataSet()).remove.apply(_rawDS$getDataSet2, arguments);
	    },
	    update: function update() {
	      var _rawDS$getDataSet3;

	      return (_rawDS$getDataSet3 = rawDS.getDataSet()).update.apply(_rawDS$getDataSet3, arguments);
	    },
	    updateOnly: function updateOnly() {
	      var _rawDS$getDataSet4;

	      return (_rawDS$getDataSet4 = rawDS.getDataSet()).updateOnly.apply(_rawDS$getDataSet4, arguments);
	    },
	    clear: function clear() {
	      var _rawDS$getDataSet5;

	      return (_rawDS$getDataSet5 = rawDS.getDataSet()).clear.apply(_rawDS$getDataSet5, arguments);
	    },
	    // Read only.
	    forEach: _bindInstanceProperty$1(_context3 = _forEachInstanceProperty(coercedDS)).call(_context3, coercedDS),
	    get: _bindInstanceProperty$1(_context4 = coercedDS.get).call(_context4, coercedDS),
	    getIds: _bindInstanceProperty$1(_context5 = coercedDS.getIds).call(_context5, coercedDS),
	    off: _bindInstanceProperty$1(_context6 = coercedDS.off).call(_context6, coercedDS),
	    on: _bindInstanceProperty$1(_context7 = coercedDS.on).call(_context7, coercedDS),

	    get length() {
	      return coercedDS.length;
	    },

	    // Non standard.
	    idProp: idProp,
	    type: type,
	    rawDS: rawDS,
	    coercedDS: coercedDS,
	    dispose: function dispose() {
	      return pipe.stop();
	    }
	  };
	} // Configure XSS protection

	var setupXSSCleaner = function setupXSSCleaner(options) {
	  var customXSS = new xssFilter.FilterXSS(options);
	  return function (string) {
	    return customXSS.process(string);
	  };
	};

	var setupNoOpCleaner = function setupNoOpCleaner(string) {
	  return string;
	}; // when nothing else is configured: filter XSS with the lib's default options


	var configuredXSSProtection = setupXSSCleaner();

	var setupXSSProtection = function setupXSSProtection(options) {
	  // No options? Do nothing.
	  if (!options) {
	    return;
	  } // Disable XSS protection completely on request


	  if (options.disabled === true) {
	    configuredXSSProtection = setupNoOpCleaner;
	    console.warn('You disabled XSS protection for vis-Timeline. I sure hope you know what you\'re doing!');
	  } else {
	    // Configure XSS protection with some custom options.
	    // For a list of valid options check the lib's documentation:
	    // https://github.com/leizongmin/js-xss#custom-filter-rules
	    if (options.filterOptions) {
	      configuredXSSProtection = setupXSSCleaner(options.filterOptions);
	    }
	  }
	};

	var availableUtils = _objectSpread(_objectSpread({}, util$2), {}, {
	  convert: convert,
	  setupXSSProtection: setupXSSProtection
	});

	_Object$defineProperty$1(availableUtils, 'xss', {
	  get: function get() {
	    return configuredXSSProtection;
	  }
	});

	var _parseFloat$3 = {exports: {}};

	var global$2 = global$V;
	var fails = fails$v;
	var uncurryThis = functionUncurryThis;
	var toString$1 = toString$a;
	var trim = stringTrim.trim;
	var whitespaces = whitespaces$4;
	var charAt = uncurryThis(''.charAt);
	var n$ParseFloat = global$2.parseFloat;
	var Symbol$1 = global$2.Symbol;
	var ITERATOR = Symbol$1 && Symbol$1.iterator;
	var FORCED = 1 / n$ParseFloat(whitespaces + '-0') !== -Infinity // MS Edge 18- broken with boxed symbols
	|| ITERATOR && !fails(function () {
	  n$ParseFloat(Object(ITERATOR));
	}); // `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string

	var numberParseFloat = FORCED ? function parseFloat(string) {
	  var trimmedString = trim(toString$1(string));
	  var result = n$ParseFloat(trimmedString);
	  return result === 0 && charAt(trimmedString, 0) == '-' ? -0 : result;
	} : n$ParseFloat;

	var $$4 = _export;
	var $parseFloat = numberParseFloat; // `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string

	$$4({
	  global: true,
	  forced: parseFloat != $parseFloat
	}, {
	  parseFloat: $parseFloat
	});

	var path$1 = path$t;
	var _parseFloat$2 = path$1.parseFloat;

	var parent$4 = _parseFloat$2;
	var _parseFloat$1 = parent$4;

	(function (module) {
	  module.exports = _parseFloat$1;
	})(_parseFloat$3);

	var _parseFloat = /*@__PURE__*/getDefaultExportFromCjs(_parseFloat$3.exports);

	/** Prototype for visual components */

	var Component = /*#__PURE__*/function () {
	  /**
	  * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} [body]
	  * @param {Object} [options]
	  */
	  function Component(body, options) {
	    _classCallCheck(this, Component);

	    // eslint-disable-line no-unused-vars
	    this.options = null;
	    this.props = null;
	  }
	  /**
	   * Set options for the component. The new options will be merged into the
	   * current options.
	   * @param {Object} options
	   */


	  _createClass(Component, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        availableUtils.extend(this.options, options);
	      }
	    }
	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */

	  }, {
	    key: "redraw",
	    value: function redraw() {
	      // should be implemented by the component
	      return false;
	    }
	    /**
	     * Destroy the component. Cleanup DOM and event listeners
	     */

	  }, {
	    key: "destroy",
	    value: function destroy() {// should be implemented by the component
	    }
	    /**
	     * Test whether the component is resized since the last time _isResized() was
	     * called.
	     * @return {Boolean} Returns true if the component is resized
	     * @protected
	     */

	  }, {
	    key: "_isResized",
	    value: function _isResized() {
	      var resized = this.props._previousWidth !== this.props.width || this.props._previousHeight !== this.props.height;
	      this.props._previousWidth = this.props.width;
	      this.props._previousHeight = this.props.height;
	      return resized;
	    }
	  }]);

	  return Component;
	}();

	var repeat$4 = {exports: {}};

	var global$1 = global$V;
	var toIntegerOrInfinity = toIntegerOrInfinity$5;
	var toString = toString$a;
	var requireObjectCoercible = requireObjectCoercible$6;
	var RangeError = global$1.RangeError; // `String.prototype.repeat` method implementation
	// https://tc39.es/ecma262/#sec-string.prototype.repeat

	var stringRepeat = function repeat(count) {
	  var str = toString(requireObjectCoercible(this));
	  var result = '';
	  var n = toIntegerOrInfinity(count);
	  if (n < 0 || n == Infinity) throw RangeError('Wrong number of repetitions');

	  for (; n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;

	  return result;
	};

	var $$3 = _export;
	var repeat$3 = stringRepeat; // `String.prototype.repeat` method
	// https://tc39.es/ecma262/#sec-string.prototype.repeat

	$$3({
	  target: 'String',
	  proto: true
	}, {
	  repeat: repeat$3
	});

	var entryVirtual$3 = entryVirtual$o;
	var repeat$2 = entryVirtual$3('String').repeat;

	var isPrototypeOf$3 = objectIsPrototypeOf;
	var method$3 = repeat$2;
	var StringPrototype = String.prototype;

	var repeat$1 = function (it) {
	  var own = it.repeat;
	  return typeof it == 'string' || it === StringPrototype || isPrototypeOf$3(StringPrototype, it) && own === StringPrototype.repeat ? method$3 : own;
	};

	var parent$3 = repeat$1;
	var repeat = parent$3;

	(function (module) {
	  module.exports = repeat;
	})(repeat$4);

	var _repeatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(repeat$4.exports);

	/**
	 * used in Core to convert the options into a volatile variable
	 * 
	 * @param {function} moment
	 * @param {Object} body
	 * @param {Array | Object} hiddenDates
	 * @returns {number}
	 */
	function convertHiddenOptions(moment, body, hiddenDates) {
	  if (hiddenDates && !_Array$isArray(hiddenDates)) {
	    return convertHiddenOptions(moment, body, [hiddenDates]);
	  }

	  body.hiddenDates = [];

	  if (hiddenDates) {
	    if (_Array$isArray(hiddenDates) == true) {
	      var _context;

	      for (var i = 0; i < hiddenDates.length; i++) {
	        if (_repeatInstanceProperty(hiddenDates[i]) === undefined) {
	          var dateItem = {};
	          dateItem.start = moment(hiddenDates[i].start).toDate().valueOf();
	          dateItem.end = moment(hiddenDates[i].end).toDate().valueOf();
	          body.hiddenDates.push(dateItem);
	        }
	      }

	      _sortInstanceProperty(_context = body.hiddenDates).call(_context, function (a, b) {
	        return a.start - b.start;
	      }); // sort by start time

	    }
	  }
	}
	/**
	 * create new entrees for the repeating hidden dates
	 *
	 * @param {function} moment
	 * @param {Object} body
	 * @param {Array | Object} hiddenDates
	 * @returns {null}
	 */

	function updateHiddenDates(moment, body, hiddenDates) {
	  if (hiddenDates && !_Array$isArray(hiddenDates)) {
	    return updateHiddenDates(moment, body, [hiddenDates]);
	  }

	  if (hiddenDates && body.domProps.centerContainer.width !== undefined) {
	    convertHiddenOptions(moment, body, hiddenDates);
	    var start = moment(body.range.start);
	    var end = moment(body.range.end);
	    var totalRange = body.range.end - body.range.start;
	    var pixelTime = totalRange / body.domProps.centerContainer.width;

	    for (var i = 0; i < hiddenDates.length; i++) {
	      if (_repeatInstanceProperty(hiddenDates[i]) !== undefined) {
	        var startDate = moment(hiddenDates[i].start);
	        var endDate = moment(hiddenDates[i].end);

	        if (startDate._d == "Invalid Date") {
	          throw new Error("Supplied start date is not valid: ".concat(hiddenDates[i].start));
	        }

	        if (endDate._d == "Invalid Date") {
	          throw new Error("Supplied end date is not valid: ".concat(hiddenDates[i].end));
	        }

	        var duration = endDate - startDate;

	        if (duration >= 4 * pixelTime) {
	          var offset = 0;
	          var runUntil = end.clone();

	          switch (_repeatInstanceProperty(hiddenDates[i])) {
	            case "daily":
	              // case of time
	              if (startDate.day() != endDate.day()) {
	                offset = 1;
	              }

	              startDate.dayOfYear(start.dayOfYear());
	              startDate.year(start.year());
	              startDate.subtract(7, 'days');
	              endDate.dayOfYear(start.dayOfYear());
	              endDate.year(start.year());
	              endDate.subtract(7 - offset, 'days');
	              runUntil.add(1, 'weeks');
	              break;

	            case "weekly":
	              {
	                var dayOffset = endDate.diff(startDate, 'days');
	                var day = startDate.day(); // set the start date to the range.start

	                startDate.date(start.date());
	                startDate.month(start.month());
	                startDate.year(start.year());
	                endDate = startDate.clone(); // force

	                startDate.day(day);
	                endDate.day(day);
	                endDate.add(dayOffset, 'days');
	                startDate.subtract(1, 'weeks');
	                endDate.subtract(1, 'weeks');
	                runUntil.add(1, 'weeks');
	                break;
	              }

	            case "monthly":
	              if (startDate.month() != endDate.month()) {
	                offset = 1;
	              }

	              startDate.month(start.month());
	              startDate.year(start.year());
	              startDate.subtract(1, 'months');
	              endDate.month(start.month());
	              endDate.year(start.year());
	              endDate.subtract(1, 'months');
	              endDate.add(offset, 'months');
	              runUntil.add(1, 'months');
	              break;

	            case "yearly":
	              if (startDate.year() != endDate.year()) {
	                offset = 1;
	              }

	              startDate.year(start.year());
	              startDate.subtract(1, 'years');
	              endDate.year(start.year());
	              endDate.subtract(1, 'years');
	              endDate.add(offset, 'years');
	              runUntil.add(1, 'years');
	              break;

	            default:
	              console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:", _repeatInstanceProperty(hiddenDates[i]));
	              return;
	          }

	          while (startDate < runUntil) {
	            body.hiddenDates.push({
	              start: startDate.valueOf(),
	              end: endDate.valueOf()
	            });

	            switch (_repeatInstanceProperty(hiddenDates[i])) {
	              case "daily":
	                startDate.add(1, 'days');
	                endDate.add(1, 'days');
	                break;

	              case "weekly":
	                startDate.add(1, 'weeks');
	                endDate.add(1, 'weeks');
	                break;

	              case "monthly":
	                startDate.add(1, 'months');
	                endDate.add(1, 'months');
	                break;

	              case "yearly":
	                startDate.add(1, 'y');
	                endDate.add(1, 'y');
	                break;

	              default:
	                console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:", _repeatInstanceProperty(hiddenDates[i]));
	                return;
	            }
	          }

	          body.hiddenDates.push({
	            start: startDate.valueOf(),
	            end: endDate.valueOf()
	          });
	        }
	      }
	    } // remove duplicates, merge where possible


	    removeDuplicates(body); // ensure the new positions are not on hidden dates

	    var startHidden = getIsHidden(body.range.start, body.hiddenDates);
	    var endHidden = getIsHidden(body.range.end, body.hiddenDates);
	    var rangeStart = body.range.start;
	    var rangeEnd = body.range.end;

	    if (startHidden.hidden == true) {
	      rangeStart = body.range.startToFront == true ? startHidden.startDate - 1 : startHidden.endDate + 1;
	    }

	    if (endHidden.hidden == true) {
	      rangeEnd = body.range.endToFront == true ? endHidden.startDate - 1 : endHidden.endDate + 1;
	    }

	    if (startHidden.hidden == true || endHidden.hidden == true) {
	      body.range._applyRange(rangeStart, rangeEnd);
	    }
	  }
	}
	/**
	 * remove duplicates from the hidden dates list. Duplicates are evil. They mess everything up.
	 * Scales with N^2
	 *
	 * @param {Object} body
	 */

	function removeDuplicates(body) {
	  var _context2;

	  var hiddenDates = body.hiddenDates;
	  var safeDates = [];

	  for (var i = 0; i < hiddenDates.length; i++) {
	    for (var j = 0; j < hiddenDates.length; j++) {
	      if (i != j && hiddenDates[j].remove != true && hiddenDates[i].remove != true) {
	        // j inside i
	        if (hiddenDates[j].start >= hiddenDates[i].start && hiddenDates[j].end <= hiddenDates[i].end) {
	          hiddenDates[j].remove = true;
	        } // j start inside i
	        else if (hiddenDates[j].start >= hiddenDates[i].start && hiddenDates[j].start <= hiddenDates[i].end) {
	          hiddenDates[i].end = hiddenDates[j].end;
	          hiddenDates[j].remove = true;
	        } // j end inside i
	        else if (hiddenDates[j].end >= hiddenDates[i].start && hiddenDates[j].end <= hiddenDates[i].end) {
	          hiddenDates[i].start = hiddenDates[j].start;
	          hiddenDates[j].remove = true;
	        }
	      }
	    }
	  }

	  for (i = 0; i < hiddenDates.length; i++) {
	    if (hiddenDates[i].remove !== true) {
	      safeDates.push(hiddenDates[i]);
	    }
	  }

	  body.hiddenDates = safeDates;

	  _sortInstanceProperty(_context2 = body.hiddenDates).call(_context2, function (a, b) {
	    return a.start - b.start;
	  }); // sort by start time

	}
	/**
	 * Prints dates to console
	 * @param {array} dates
	 */

	function printDates(dates) {
	  for (var i = 0; i < dates.length; i++) {
	    console.log(i, new Date(dates[i].start), new Date(dates[i].end), dates[i].start, dates[i].end, dates[i].remove);
	  }
	}
	/**
	 * Used in TimeStep to avoid the hidden times.
	 * @param {function} moment
	 * @param {TimeStep} timeStep
	 * @param {Date} previousTime
	 */

	function stepOverHiddenDates(moment, timeStep, previousTime) {
	  var stepInHidden = false;
	  var currentValue = timeStep.current.valueOf();

	  for (var i = 0; i < timeStep.hiddenDates.length; i++) {
	    var startDate = timeStep.hiddenDates[i].start;
	    var endDate = timeStep.hiddenDates[i].end;

	    if (currentValue >= startDate && currentValue < endDate) {
	      stepInHidden = true;
	      break;
	    }
	  }

	  if (stepInHidden == true && currentValue < timeStep._end.valueOf() && currentValue != previousTime) {
	    var prevValue = moment(previousTime);
	    var newValue = moment(endDate); //check if the next step should be major

	    if (prevValue.year() != newValue.year()) {
	      timeStep.switchedYear = true;
	    } else if (prevValue.month() != newValue.month()) {
	      timeStep.switchedMonth = true;
	    } else if (prevValue.dayOfYear() != newValue.dayOfYear()) {
	      timeStep.switchedDay = true;
	    }

	    timeStep.current = newValue;
	  }
	} ///**
	// * Used in TimeStep to avoid the hidden times.
	// * @param timeStep
	// * @param previousTime
	// */
	//checkFirstStep = function(timeStep) {
	//  var stepInHidden = false;
	//  var currentValue = timeStep.current.valueOf();
	//  for (var i = 0; i < timeStep.hiddenDates.length; i++) {
	//    var startDate = timeStep.hiddenDates[i].start;
	//    var endDate = timeStep.hiddenDates[i].end;
	//    if (currentValue >= startDate && currentValue < endDate) {
	//      stepInHidden = true;
	//      break;
	//    }
	//  }
	//
	//  if (stepInHidden == true && currentValue <= timeStep._end.valueOf()) {
	//    var newValue = moment(endDate);
	//    timeStep.current = newValue.toDate();
	//  }
	//};

	/**
	 * replaces the Core toScreen methods
	 *
	 * @param {timeline.Core} Core
	 * @param {Date} time
	 * @param {number} width
	 * @returns {number}
	 */

	function toScreen(Core, time, width) {
	  var conversion;

	  if (Core.body.hiddenDates.length == 0) {
	    conversion = Core.range.conversion(width);
	    return (time.valueOf() - conversion.offset) * conversion.scale;
	  } else {
	    var hidden = getIsHidden(time, Core.body.hiddenDates);

	    if (hidden.hidden == true) {
	      time = hidden.startDate;
	    }

	    var duration = getHiddenDurationBetween(Core.body.hiddenDates, Core.range.start, Core.range.end);

	    if (time < Core.range.start) {
	      conversion = Core.range.conversion(width, duration);
	      var hiddenBeforeStart = getHiddenDurationBeforeStart(Core.body.hiddenDates, time, conversion.offset);
	      time = Core.options.moment(time).toDate().valueOf();
	      time = time + hiddenBeforeStart;
	      return -(conversion.offset - time.valueOf()) * conversion.scale;
	    } else if (time > Core.range.end) {
	      var rangeAfterEnd = {
	        start: Core.range.start,
	        end: time
	      };
	      time = correctTimeForHidden(Core.options.moment, Core.body.hiddenDates, rangeAfterEnd, time);
	      conversion = Core.range.conversion(width, duration);
	      return (time.valueOf() - conversion.offset) * conversion.scale;
	    } else {
	      time = correctTimeForHidden(Core.options.moment, Core.body.hiddenDates, Core.range, time);
	      conversion = Core.range.conversion(width, duration);
	      return (time.valueOf() - conversion.offset) * conversion.scale;
	    }
	  }
	}
	/**
	 * Replaces the core toTime methods
	 *
	 * @param {timeline.Core} Core
	 * @param {number} x
	 * @param {number} width
	 * @returns {Date}
	 */

	function toTime(Core, x, width) {
	  if (Core.body.hiddenDates.length == 0) {
	    var conversion = Core.range.conversion(width);
	    return new Date(x / conversion.scale + conversion.offset);
	  } else {
	    var hiddenDuration = getHiddenDurationBetween(Core.body.hiddenDates, Core.range.start, Core.range.end);
	    var totalDuration = Core.range.end - Core.range.start - hiddenDuration;
	    var partialDuration = totalDuration * x / width;
	    var accumulatedHiddenDuration = getAccumulatedHiddenDuration(Core.body.hiddenDates, Core.range, partialDuration);
	    return new Date(accumulatedHiddenDuration + partialDuration + Core.range.start);
	  }
	}
	/**
	 * Support function
	 *
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {number} start
	 * @param {number} end
	 * @returns {number}
	 */

	function getHiddenDurationBetween(hiddenDates, start, end) {
	  var duration = 0;

	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end; // if time after the cutout, and the

	    if (startDate >= start && endDate < end) {
	      duration += endDate - startDate;
	    }
	  }

	  return duration;
	}
	/**
	 * Support function
	 *
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {number} start
	 * @param {number} end
	 * @returns {number}
	 */

	function getHiddenDurationBeforeStart(hiddenDates, start, end) {
	  var duration = 0;

	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end;

	    if (startDate >= start && endDate <= end) {
	      duration += endDate - startDate;
	    }
	  }

	  return duration;
	}
	/**
	 * Support function
	 * @param {function} moment
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {{start: number, end: number}} range
	 * @param {Date} time
	 * @returns {number}
	 */

	function correctTimeForHidden(moment, hiddenDates, range, time) {
	  time = moment(time).toDate().valueOf();
	  time -= getHiddenDurationBefore(moment, hiddenDates, range, time);
	  return time;
	}
	/**
	 * Support function
	 * @param {function} moment
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {{start: number, end: number}} range
	 * @param {Date} time
	 * @returns {number}
	 */

	function getHiddenDurationBefore(moment, hiddenDates, range, time) {
	  var timeOffset = 0;
	  time = moment(time).toDate().valueOf();

	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end; // if time after the cutout, and the

	    if (startDate >= range.start && endDate < range.end) {
	      if (time >= endDate) {
	        timeOffset += endDate - startDate;
	      }
	    }
	  }

	  return timeOffset;
	}
	/**
	 * sum the duration from start to finish, including the hidden duration,
	 * until the required amount has been reached, return the accumulated hidden duration
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {{start: number, end: number}} range
	 * @param {number} [requiredDuration=0]
	 * @returns {number}
	 */

	function getAccumulatedHiddenDuration(hiddenDates, range, requiredDuration) {
	  var hiddenDuration = 0;
	  var duration = 0;
	  var previousPoint = range.start; //printDates(hiddenDates)

	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end; // if time after the cutout, and the

	    if (startDate >= range.start && endDate < range.end) {
	      duration += startDate - previousPoint;
	      previousPoint = endDate;

	      if (duration >= requiredDuration) {
	        break;
	      } else {
	        hiddenDuration += endDate - startDate;
	      }
	    }
	  }

	  return hiddenDuration;
	}
	/**
	 * used to step over to either side of a hidden block. Correction is disabled on tablets, might be set to true
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {Date} time
	 * @param {number} direction
	 * @param {boolean} correctionEnabled
	 * @returns {Date|number}
	 */

	function snapAwayFromHidden(hiddenDates, time, direction, correctionEnabled) {
	  var isHidden = getIsHidden(time, hiddenDates);

	  if (isHidden.hidden == true) {
	    if (direction < 0) {
	      if (correctionEnabled == true) {
	        return isHidden.startDate - (isHidden.endDate - time) - 1;
	      } else {
	        return isHidden.startDate - 1;
	      }
	    } else {
	      if (correctionEnabled == true) {
	        return isHidden.endDate + (time - isHidden.startDate) + 1;
	      } else {
	        return isHidden.endDate + 1;
	      }
	    }
	  } else {
	    return time;
	  }
	}
	/**
	 * Check if a time is hidden
	 *
	 * @param {Date} time
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @returns {{hidden: boolean, startDate: Window.start, endDate: *}}
	 */

	function getIsHidden(time, hiddenDates) {
	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end;

	    if (time >= startDate && time < endDate) {
	      // if the start is entering a hidden zone
	      return {
	        hidden: true,
	        startDate: startDate,
	        endDate: endDate
	      };
	    }
	  }

	  return {
	    hidden: false,
	    startDate: startDate,
	    endDate: endDate
	  };
	}

	var DateUtil = /*#__PURE__*/Object.freeze({
		__proto__: null,
		convertHiddenOptions: convertHiddenOptions,
		updateHiddenDates: updateHiddenDates,
		removeDuplicates: removeDuplicates,
		printDates: printDates,
		stepOverHiddenDates: stepOverHiddenDates,
		toScreen: toScreen,
		toTime: toTime,
		getHiddenDurationBetween: getHiddenDurationBetween,
		getHiddenDurationBeforeStart: getHiddenDurationBeforeStart,
		correctTimeForHidden: correctTimeForHidden,
		getHiddenDurationBefore: getHiddenDurationBefore,
		getAccumulatedHiddenDuration: getAccumulatedHiddenDuration,
		snapAwayFromHidden: snapAwayFromHidden,
		getIsHidden: getIsHidden
	});

	function _createSuper$c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$c(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$c() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Range controls a numeric range with a start and end value.
	 * The Range adjusts the range based on mouse events or programmatic changes,
	 * and triggers events when the range is changing or has been changed.
	 */

	var Range = /*#__PURE__*/function (_Component) {
	  _inherits(Range, _Component);

	  var _super = _createSuper$c(Range);

	  /**
	  * @param {{dom: Object, domProps: Object, emitter: Emitter}} body
	  * @param {Object} [options]    See description at Range.setOptions
	  * @constructor Range
	  * @extends Component
	  */
	  function Range(body, options) {
	    var _context, _context2, _context3, _context4, _context5, _context6, _context7;

	    var _this;

	    _classCallCheck(this, Range);

	    _this = _super.call(this);
	    var now = moment$2().hours(0).minutes(0).seconds(0).milliseconds(0);
	    var start = now.clone().add(-3, 'days').valueOf();
	    var end = now.clone().add(3, 'days').valueOf();
	    _this.millisecondsPerPixelCache = undefined;

	    if (options === undefined) {
	      _this.start = start;
	      _this.end = end;
	    } else {
	      _this.start = options.start || start;
	      _this.end = options.end || end;
	    }

	    _this.rolling = false;
	    _this.body = body;
	    _this.deltaDifference = 0;
	    _this.scaleOffset = 0;
	    _this.startToFront = false;
	    _this.endToFront = true; // default options

	    _this.defaultOptions = {
	      rtl: false,
	      start: null,
	      end: null,
	      moment: moment$2,
	      direction: 'horizontal',
	      // 'horizontal' or 'vertical'
	      moveable: true,
	      zoomable: true,
	      min: null,
	      max: null,
	      zoomMin: 10,
	      // milliseconds
	      zoomMax: 1000 * 60 * 60 * 24 * 365 * 10000,
	      // milliseconds
	      rollingMode: {
	        follow: false,
	        offset: 0.5
	      }
	    };
	    _this.options = availableUtils.extend({}, _this.defaultOptions);
	    _this.props = {
	      touch: {}
	    };
	    _this.animationTimer = null; // drag listeners for dragging

	    _this.body.emitter.on('panstart', _bindInstanceProperty$1(_context = _this._onDragStart).call(_context, _assertThisInitialized(_this)));

	    _this.body.emitter.on('panmove', _bindInstanceProperty$1(_context2 = _this._onDrag).call(_context2, _assertThisInitialized(_this)));

	    _this.body.emitter.on('panend', _bindInstanceProperty$1(_context3 = _this._onDragEnd).call(_context3, _assertThisInitialized(_this))); // mouse wheel for zooming


	    _this.body.emitter.on('mousewheel', _bindInstanceProperty$1(_context4 = _this._onMouseWheel).call(_context4, _assertThisInitialized(_this))); // pinch to zoom


	    _this.body.emitter.on('touch', _bindInstanceProperty$1(_context5 = _this._onTouch).call(_context5, _assertThisInitialized(_this)));

	    _this.body.emitter.on('pinch', _bindInstanceProperty$1(_context6 = _this._onPinch).call(_context6, _assertThisInitialized(_this))); // on click of rolling mode button


	    _this.body.dom.rollingModeBtn.addEventListener('click', _bindInstanceProperty$1(_context7 = _this.startRolling).call(_context7, _assertThisInitialized(_this)));

	    _this.setOptions(options);

	    return _this;
	  }
	  /**
	   * Set options for the range controller
	   * @param {Object} options      Available options:
	   *                              {number | Date | String} start  Start date for the range
	   *                              {number | Date | String} end    End date for the range
	   *                              {number} min    Minimum value for start
	   *                              {number} max    Maximum value for end
	   *                              {number} zoomMin    Set a minimum value for
	   *                                                  (end - start).
	   *                              {number} zoomMax    Set a maximum value for
	   *                                                  (end - start).
	   *                              {boolean} moveable Enable moving of the range
	   *                                                 by dragging. True by default
	   *                              {boolean} zoomable Enable zooming of the range
	   *                                                 by pinching/scrolling. True by default
	   */


	  _createClass(Range, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        // copy the options that we know
	        var fields = ['animation', 'direction', 'min', 'max', 'zoomMin', 'zoomMax', 'moveable', 'zoomable', 'moment', 'activate', 'hiddenDates', 'zoomKey', 'zoomFriction', 'rtl', 'showCurrentTime', 'rollingMode', 'horizontalScroll'];
	        availableUtils.selectiveExtend(fields, this.options, options);

	        if (options.rollingMode && options.rollingMode.follow) {
	          this.startRolling();
	        }

	        if ('start' in options || 'end' in options) {
	          // apply a new range. both start and end are optional
	          this.setRange(options.start, options.end);
	        }
	      }
	    }
	    /**
	     * Start auto refreshing the current time bar
	     */

	  }, {
	    key: "startRolling",
	    value: function startRolling() {
	      var me = this;
	      /**
	       *  Updates the current time.
	       */

	      function update() {
	        me.stopRolling();
	        me.rolling = true;
	        var interval = me.end - me.start;
	        var t = availableUtils.convert(new Date(), 'Date').valueOf();
	        var rollingModeOffset = me.options.rollingMode && me.options.rollingMode.offset || 0.5;
	        var start = t - interval * rollingModeOffset;
	        var end = t + interval * (1 - rollingModeOffset);
	        var options = {
	          animation: false
	        };
	        me.setRange(start, end, options); // determine interval to refresh

	        var scale = me.conversion(me.body.domProps.center.width).scale;
	        interval = 1 / scale / 10;
	        if (interval < 30) interval = 30;
	        if (interval > 1000) interval = 1000;
	        me.body.dom.rollingModeBtn.style.visibility = "hidden"; // start a renderTimer to adjust for the new time

	        me.currentTimeTimer = _setTimeout(update, interval);
	      }

	      update();
	    }
	    /**
	     * Stop auto refreshing the current time bar
	     */

	  }, {
	    key: "stopRolling",
	    value: function stopRolling() {
	      if (this.currentTimeTimer !== undefined) {
	        clearTimeout(this.currentTimeTimer);
	        this.rolling = false;
	        this.body.dom.rollingModeBtn.style.visibility = "visible";
	      }
	    }
	    /**
	     * Set a new start and end range
	     * @param {Date | number | string} start
	     * @param {Date | number | string} end
	     * @param {Object} options      Available options:
	     *                              {boolean | {duration: number, easingFunction: string}} [animation=false]
	     *                                    If true, the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     *                              {boolean} [byUser=false]
	     *                              {Event}  event  Mouse event
	     * @param {Function} callback     a callback function to be executed at the end of this function  
	     * @param {Function} frameCallback    a callback function executed each frame of the range animation.
	     *                                    The callback will be passed three parameters:
	     *                                    {number} easeCoefficient    an easing coefficent
	     *                                    {boolean} willDraw          If true the caller will redraw after the callback completes
	     *                                    {boolean} done              If true then animation is ending after the current frame
	     * @return {void}
	     */

	  }, {
	    key: "setRange",
	    value: function setRange(start, end, options, callback, frameCallback) {
	      if (!options) {
	        options = {};
	      }

	      if (options.byUser !== true) {
	        options.byUser = false;
	      }

	      var me = this;
	      var finalStart = start != undefined ? availableUtils.convert(start, 'Date').valueOf() : null;
	      var finalEnd = end != undefined ? availableUtils.convert(end, 'Date').valueOf() : null;

	      this._cancelAnimation();

	      this.millisecondsPerPixelCache = undefined;

	      if (options.animation) {
	        // true or an Object
	        var initStart = this.start;
	        var initEnd = this.end;
	        var duration = _typeof$1(options.animation) === 'object' && 'duration' in options.animation ? options.animation.duration : 500;
	        var easingName = _typeof$1(options.animation) === 'object' && 'easingFunction' in options.animation ? options.animation.easingFunction : 'easeInOutQuad';
	        var easingFunction = availableUtils.easingFunctions[easingName];

	        if (!easingFunction) {
	          var _context8;

	          throw new Error(_concatInstanceProperty(_context8 = "Unknown easing function ".concat(_JSON$stringify(easingName), ". Choose from: ")).call(_context8, _Object$keys(availableUtils.easingFunctions).join(', ')));
	        }

	        var initTime = _Date$now();

	        var anyChanged = false;

	        var next = function next() {
	          if (!me.props.touch.dragging) {
	            var now = _Date$now();

	            var time = now - initTime;
	            var ease = easingFunction(time / duration);
	            var done = time > duration;
	            var s = done || finalStart === null ? finalStart : initStart + (finalStart - initStart) * ease;
	            var e = done || finalEnd === null ? finalEnd : initEnd + (finalEnd - initEnd) * ease;
	            changed = me._applyRange(s, e);
	            updateHiddenDates(me.options.moment, me.body, me.options.hiddenDates);
	            anyChanged = anyChanged || changed;
	            var params = {
	              start: new Date(me.start),
	              end: new Date(me.end),
	              byUser: options.byUser,
	              event: options.event
	            };

	            if (frameCallback) {
	              frameCallback(ease, changed, done);
	            }

	            if (changed) {
	              me.body.emitter.emit('rangechange', params);
	            }

	            if (done) {
	              if (anyChanged) {
	                me.body.emitter.emit('rangechanged', params);

	                if (callback) {
	                  return callback();
	                }
	              }
	            } else {
	              // animate with as high as possible frame rate, leave 20 ms in between
	              // each to prevent the browser from blocking
	              me.animationTimer = _setTimeout(next, 20);
	            }
	          }
	        };

	        return next();
	      } else {
	        var changed = this._applyRange(finalStart, finalEnd);

	        updateHiddenDates(this.options.moment, this.body, this.options.hiddenDates);

	        if (changed) {
	          var params = {
	            start: new Date(this.start),
	            end: new Date(this.end),
	            byUser: options.byUser,
	            event: options.event
	          };
	          this.body.emitter.emit('rangechange', params);
	          clearTimeout(me.timeoutID);
	          me.timeoutID = _setTimeout(function () {
	            me.body.emitter.emit('rangechanged', params);
	          }, 200);

	          if (callback) {
	            return callback();
	          }
	        }
	      }
	    }
	    /**
	     * Get the number of milliseconds per pixel.
	     *
	     * @returns {undefined|number}
	     */

	  }, {
	    key: "getMillisecondsPerPixel",
	    value: function getMillisecondsPerPixel() {
	      if (this.millisecondsPerPixelCache === undefined) {
	        this.millisecondsPerPixelCache = (this.end - this.start) / this.body.dom.center.clientWidth;
	      }

	      return this.millisecondsPerPixelCache;
	    }
	    /**
	     * Stop an animation
	     * @private
	     */

	  }, {
	    key: "_cancelAnimation",
	    value: function _cancelAnimation() {
	      if (this.animationTimer) {
	        clearTimeout(this.animationTimer);
	        this.animationTimer = null;
	      }
	    }
	    /**
	     * Set a new start and end range. This method is the same as setRange, but
	     * does not trigger a range change and range changed event, and it returns
	     * true when the range is changed
	     * @param {number} [start]
	     * @param {number} [end]
	     * @return {boolean} changed
	     * @private
	     */

	  }, {
	    key: "_applyRange",
	    value: function _applyRange(start, end) {
	      var newStart = start != null ? availableUtils.convert(start, 'Date').valueOf() : this.start;
	      var newEnd = end != null ? availableUtils.convert(end, 'Date').valueOf() : this.end;
	      var max = this.options.max != null ? availableUtils.convert(this.options.max, 'Date').valueOf() : null;
	      var min = this.options.min != null ? availableUtils.convert(this.options.min, 'Date').valueOf() : null;
	      var diff; // check for valid number

	      if (isNaN(newStart) || newStart === null) {
	        throw new Error("Invalid start \"".concat(start, "\""));
	      }

	      if (isNaN(newEnd) || newEnd === null) {
	        throw new Error("Invalid end \"".concat(end, "\""));
	      } // prevent end < start


	      if (newEnd < newStart) {
	        newEnd = newStart;
	      } // prevent start < min


	      if (min !== null) {
	        if (newStart < min) {
	          diff = min - newStart;
	          newStart += diff;
	          newEnd += diff; // prevent end > max

	          if (max != null) {
	            if (newEnd > max) {
	              newEnd = max;
	            }
	          }
	        }
	      } // prevent end > max


	      if (max !== null) {
	        if (newEnd > max) {
	          diff = newEnd - max;
	          newStart -= diff;
	          newEnd -= diff; // prevent start < min

	          if (min != null) {
	            if (newStart < min) {
	              newStart = min;
	            }
	          }
	        }
	      } // prevent (end-start) < zoomMin


	      if (this.options.zoomMin !== null) {
	        var zoomMin = _parseFloat(this.options.zoomMin);

	        if (zoomMin < 0) {
	          zoomMin = 0;
	        }

	        if (newEnd - newStart < zoomMin) {
	          // compensate for a scale of 0.5 ms
	          var compensation = 0.5;

	          if (this.end - this.start === zoomMin && newStart >= this.start - compensation && newEnd <= this.end) {
	            // ignore this action, we are already zoomed to the minimum
	            newStart = this.start;
	            newEnd = this.end;
	          } else {
	            // zoom to the minimum
	            diff = zoomMin - (newEnd - newStart);
	            newStart -= diff / 2;
	            newEnd += diff / 2;
	          }
	        }
	      } // prevent (end-start) > zoomMax


	      if (this.options.zoomMax !== null) {
	        var zoomMax = _parseFloat(this.options.zoomMax);

	        if (zoomMax < 0) {
	          zoomMax = 0;
	        }

	        if (newEnd - newStart > zoomMax) {
	          if (this.end - this.start === zoomMax && newStart < this.start && newEnd > this.end) {
	            // ignore this action, we are already zoomed to the maximum
	            newStart = this.start;
	            newEnd = this.end;
	          } else {
	            // zoom to the maximum
	            diff = newEnd - newStart - zoomMax;
	            newStart += diff / 2;
	            newEnd -= diff / 2;
	          }
	        }
	      }

	      var changed = this.start != newStart || this.end != newEnd; // if the new range does NOT overlap with the old range, emit checkRangedItems to avoid not showing ranged items (ranged meaning has end time, not necessarily of type Range)

	      if (!(newStart >= this.start && newStart <= this.end || newEnd >= this.start && newEnd <= this.end) && !(this.start >= newStart && this.start <= newEnd || this.end >= newStart && this.end <= newEnd)) {
	        this.body.emitter.emit('checkRangedItems');
	      }

	      this.start = newStart;
	      this.end = newEnd;
	      return changed;
	    }
	    /**
	     * Retrieve the current range.
	     * @return {Object} An object with start and end properties
	     */

	  }, {
	    key: "getRange",
	    value: function getRange() {
	      return {
	        start: this.start,
	        end: this.end
	      };
	    }
	    /**
	     * Calculate the conversion offset and scale for current range, based on
	     * the provided width
	     * @param {number} width
	     * @param {number} [totalHidden=0]
	     * @returns {{offset: number, scale: number}} conversion
	     */

	  }, {
	    key: "conversion",
	    value: function conversion(width, totalHidden) {
	      return Range.conversion(this.start, this.end, width, totalHidden);
	    }
	    /**
	     * Static method to calculate the conversion offset and scale for a range,
	     * based on the provided start, end, and width
	     * @param {number} start
	     * @param {number} end
	     * @param {number} width
	     * @param {number} [totalHidden=0]
	     * @returns {{offset: number, scale: number}} conversion
	     */

	  }, {
	    key: "_onDragStart",
	    value:
	    /**
	     * Start dragging horizontally or vertically
	     * @param {Event} event
	     * @private
	     */
	    function _onDragStart(event) {
	      this.deltaDifference = 0;
	      this.previousDelta = 0; // only allow dragging when configured as movable

	      if (!this.options.moveable) return; // only start dragging when the mouse is inside the current range

	      if (!this._isInsideRange(event)) return; // refuse to drag when we where pinching to prevent the timeline make a jump
	      // when releasing the fingers in opposite order from the touch screen

	      if (!this.props.touch.allowDragging) return;
	      this.stopRolling();
	      this.props.touch.start = this.start;
	      this.props.touch.end = this.end;
	      this.props.touch.dragging = true;

	      if (this.body.dom.root) {
	        this.body.dom.root.style.cursor = 'move';
	      }
	    }
	    /**
	     * Perform dragging operation
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onDrag",
	    value: function _onDrag(event) {
	      if (!event) return;
	      if (!this.props.touch.dragging) return; // only allow dragging when configured as movable

	      if (!this.options.moveable) return; // TODO: this may be redundant in hammerjs2
	      // refuse to drag when we where pinching to prevent the timeline make a jump
	      // when releasing the fingers in opposite order from the touch screen

	      if (!this.props.touch.allowDragging) return;
	      var direction = this.options.direction;
	      validateDirection(direction);
	      var delta = direction == 'horizontal' ? event.deltaX : event.deltaY;
	      delta -= this.deltaDifference;
	      var interval = this.props.touch.end - this.props.touch.start; // normalize dragging speed if cutout is in between.

	      var duration = getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
	      interval -= duration;
	      var width = direction == 'horizontal' ? this.body.domProps.center.width : this.body.domProps.center.height;
	      var diffRange;

	      if (this.options.rtl) {
	        diffRange = delta / width * interval;
	      } else {
	        diffRange = -delta / width * interval;
	      }

	      var newStart = this.props.touch.start + diffRange;
	      var newEnd = this.props.touch.end + diffRange; // snapping times away from hidden zones

	      var safeStart = snapAwayFromHidden(this.body.hiddenDates, newStart, this.previousDelta - delta, true);
	      var safeEnd = snapAwayFromHidden(this.body.hiddenDates, newEnd, this.previousDelta - delta, true);

	      if (safeStart != newStart || safeEnd != newEnd) {
	        this.deltaDifference += delta;
	        this.props.touch.start = safeStart;
	        this.props.touch.end = safeEnd;

	        this._onDrag(event);

	        return;
	      }

	      this.previousDelta = delta;

	      this._applyRange(newStart, newEnd);

	      var startDate = new Date(this.start);
	      var endDate = new Date(this.end); // fire a rangechange event

	      this.body.emitter.emit('rangechange', {
	        start: startDate,
	        end: endDate,
	        byUser: true,
	        event: event
	      }); // fire a panmove event

	      this.body.emitter.emit('panmove');
	    }
	    /**
	     * Stop dragging operation
	     * @param {event} event
	     * @private
	     */

	  }, {
	    key: "_onDragEnd",
	    value: function _onDragEnd(event) {
	      if (!this.props.touch.dragging) return; // only allow dragging when configured as movable

	      if (!this.options.moveable) return; // TODO: this may be redundant in hammerjs2
	      // refuse to drag when we where pinching to prevent the timeline make a jump
	      // when releasing the fingers in opposite order from the touch screen

	      if (!this.props.touch.allowDragging) return;
	      this.props.touch.dragging = false;

	      if (this.body.dom.root) {
	        this.body.dom.root.style.cursor = 'auto';
	      } // fire a rangechanged event


	      this.body.emitter.emit('rangechanged', {
	        start: new Date(this.start),
	        end: new Date(this.end),
	        byUser: true,
	        event: event
	      });
	    }
	    /**
	     * Event handler for mouse wheel event, used to zoom
	     * Code from http://adomas.org/javascript-mouse-wheel/
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onMouseWheel",
	    value: function _onMouseWheel(event) {
	      // retrieve delta
	      var delta = 0;

	      if (event.wheelDelta) {
	        /* IE/Opera. */
	        delta = event.wheelDelta / 120;
	      } else if (event.detail) {
	        /* Mozilla case. */
	        // In Mozilla, sign of delta is different than in IE.
	        // Also, delta is multiple of 3.
	        delta = -event.detail / 3;
	      } else if (event.deltaY) {
	        delta = -event.deltaY / 3;
	      } // don't allow zoom when the according key is pressed and the zoomKey option or not zoomable but movable


	      if (this.options.zoomKey && !event[this.options.zoomKey] && this.options.zoomable || !this.options.zoomable && this.options.moveable) {
	        return;
	      } // only allow zooming when configured as zoomable and moveable


	      if (!(this.options.zoomable && this.options.moveable)) return; // only zoom when the mouse is inside the current range

	      if (!this._isInsideRange(event)) return; // If delta is nonzero, handle it.
	      // Basically, delta is now positive if wheel was scrolled up,
	      // and negative, if wheel was scrolled down.

	      if (delta) {
	        // perform the zoom action. Delta is normally 1 or -1
	        // adjust a negative delta such that zooming in with delta 0.1
	        // equals zooming out with a delta -0.1
	        var zoomFriction = this.options.zoomFriction || 5;
	        var scale;

	        if (delta < 0) {
	          scale = 1 - delta / zoomFriction;
	        } else {
	          scale = 1 / (1 + delta / zoomFriction);
	        } // calculate center, the date to zoom around


	        var pointerDate;

	        if (this.rolling) {
	          var rollingModeOffset = this.options.rollingMode && this.options.rollingMode.offset || 0.5;
	          pointerDate = this.start + (this.end - this.start) * rollingModeOffset;
	        } else {
	          var pointer = this.getPointer({
	            x: event.clientX,
	            y: event.clientY
	          }, this.body.dom.center);
	          pointerDate = this._pointerToDate(pointer);
	        }

	        this.zoom(scale, pointerDate, delta, event); // Prevent default actions caused by mouse wheel
	        // (else the page and timeline both scroll)

	        event.preventDefault();
	      }
	    }
	    /**
	     * Start of a touch gesture
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onTouch",
	    value: function _onTouch(event) {
	      // eslint-disable-line no-unused-vars
	      this.props.touch.start = this.start;
	      this.props.touch.end = this.end;
	      this.props.touch.allowDragging = true;
	      this.props.touch.center = null;
	      this.props.touch.centerDate = null;
	      this.scaleOffset = 0;
	      this.deltaDifference = 0; // Disable the browser default handling of this event.

	      availableUtils.preventDefault(event);
	    }
	    /**
	     * Handle pinch event
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onPinch",
	    value: function _onPinch(event) {
	      // only allow zooming when configured as zoomable and moveable
	      if (!(this.options.zoomable && this.options.moveable)) return; // Disable the browser default handling of this event.

	      availableUtils.preventDefault(event);
	      this.props.touch.allowDragging = false;

	      if (!this.props.touch.center) {
	        this.props.touch.center = this.getPointer(event.center, this.body.dom.center);
	        this.props.touch.centerDate = this._pointerToDate(this.props.touch.center);
	      }

	      this.stopRolling();
	      var scale = 1 / (event.scale + this.scaleOffset);
	      var centerDate = this.props.touch.centerDate;
	      var hiddenDuration = getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
	      var hiddenDurationBefore = getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this, centerDate);
	      var hiddenDurationAfter = hiddenDuration - hiddenDurationBefore; // calculate new start and end

	      var newStart = centerDate - hiddenDurationBefore + (this.props.touch.start - (centerDate - hiddenDurationBefore)) * scale;
	      var newEnd = centerDate + hiddenDurationAfter + (this.props.touch.end - (centerDate + hiddenDurationAfter)) * scale; // snapping times away from hidden zones

	      this.startToFront = 1 - scale <= 0; // used to do the right auto correction with periodic hidden times

	      this.endToFront = scale - 1 <= 0; // used to do the right auto correction with periodic hidden times

	      var safeStart = snapAwayFromHidden(this.body.hiddenDates, newStart, 1 - scale, true);
	      var safeEnd = snapAwayFromHidden(this.body.hiddenDates, newEnd, scale - 1, true);

	      if (safeStart != newStart || safeEnd != newEnd) {
	        this.props.touch.start = safeStart;
	        this.props.touch.end = safeEnd;
	        this.scaleOffset = 1 - event.scale;
	        newStart = safeStart;
	        newEnd = safeEnd;
	      }

	      var options = {
	        animation: false,
	        byUser: true,
	        event: event
	      };
	      this.setRange(newStart, newEnd, options);
	      this.startToFront = false; // revert to default

	      this.endToFront = true; // revert to default
	    }
	    /**
	     * Test whether the mouse from a mouse event is inside the visible window,
	     * between the current start and end date
	     * @param {Object} event
	     * @return {boolean} Returns true when inside the visible window
	     * @private
	     */

	  }, {
	    key: "_isInsideRange",
	    value: function _isInsideRange(event) {
	      // calculate the time where the mouse is, check whether inside
	      // and no scroll action should happen.
	      var clientX = event.center ? event.center.x : event.clientX;
	      var centerContainerRect = this.body.dom.centerContainer.getBoundingClientRect();
	      var x = this.options.rtl ? clientX - centerContainerRect.left : centerContainerRect.right - clientX;
	      var time = this.body.util.toTime(x);
	      return time >= this.start && time <= this.end;
	    }
	    /**
	     * Helper function to calculate the center date for zooming
	     * @param {{x: number, y: number}} pointer
	     * @return {number} date
	     * @private
	     */

	  }, {
	    key: "_pointerToDate",
	    value: function _pointerToDate(pointer) {
	      var conversion;
	      var direction = this.options.direction;
	      validateDirection(direction);

	      if (direction == 'horizontal') {
	        return this.body.util.toTime(pointer.x).valueOf();
	      } else {
	        var height = this.body.domProps.center.height;
	        conversion = this.conversion(height);
	        return pointer.y / conversion.scale + conversion.offset;
	      }
	    }
	    /**
	     * Get the pointer location relative to the location of the dom element
	     * @param {{x: number, y: number}} touch
	     * @param {Element} element   HTML DOM element
	     * @return {{x: number, y: number}} pointer
	     * @private
	     */

	  }, {
	    key: "getPointer",
	    value: function getPointer(touch, element) {
	      var elementRect = element.getBoundingClientRect();

	      if (this.options.rtl) {
	        return {
	          x: elementRect.right - touch.x,
	          y: touch.y - elementRect.top
	        };
	      } else {
	        return {
	          x: touch.x - elementRect.left,
	          y: touch.y - elementRect.top
	        };
	      }
	    }
	    /**
	     * Zoom the range the given scale in or out. Start and end date will
	     * be adjusted, and the timeline will be redrawn. You can optionally give a
	     * date around which to zoom.
	     * For example, try scale = 0.9 or 1.1
	     * @param {number} scale      Scaling factor. Values above 1 will zoom out,
	     *                            values below 1 will zoom in.
	     * @param {number} [center]   Value representing a date around which will
	     *                            be zoomed.
	     * @param {number} delta
	     * @param {Event} event
	     */

	  }, {
	    key: "zoom",
	    value: function zoom(scale, center, delta, event) {
	      // if centerDate is not provided, take it half between start Date and end Date
	      if (center == null) {
	        center = (this.start + this.end) / 2;
	      }

	      var hiddenDuration = getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
	      var hiddenDurationBefore = getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this, center);
	      var hiddenDurationAfter = hiddenDuration - hiddenDurationBefore; // calculate new start and end

	      var newStart = center - hiddenDurationBefore + (this.start - (center - hiddenDurationBefore)) * scale;
	      var newEnd = center + hiddenDurationAfter + (this.end - (center + hiddenDurationAfter)) * scale; // snapping times away from hidden zones

	      this.startToFront = delta > 0 ? false : true; // used to do the right autocorrection with periodic hidden times

	      this.endToFront = -delta > 0 ? false : true; // used to do the right autocorrection with periodic hidden times

	      var safeStart = snapAwayFromHidden(this.body.hiddenDates, newStart, delta, true);
	      var safeEnd = snapAwayFromHidden(this.body.hiddenDates, newEnd, -delta, true);

	      if (safeStart != newStart || safeEnd != newEnd) {
	        newStart = safeStart;
	        newEnd = safeEnd;
	      }

	      var options = {
	        animation: false,
	        byUser: true,
	        event: event
	      };
	      this.setRange(newStart, newEnd, options);
	      this.startToFront = false; // revert to default

	      this.endToFront = true; // revert to default
	    }
	    /**
	     * Move the range with a given delta to the left or right. Start and end
	     * value will be adjusted. For example, try delta = 0.1 or -0.1
	     * @param {number}  delta     Moving amount. Positive value will move right,
	     *                            negative value will move left
	     */

	  }, {
	    key: "move",
	    value: function move(delta) {
	      // zoom start Date and end Date relative to the centerDate
	      var diff = this.end - this.start; // apply new values

	      var newStart = this.start + diff * delta;
	      var newEnd = this.end + diff * delta; // TODO: reckon with min and max range

	      this.start = newStart;
	      this.end = newEnd;
	    }
	    /**
	     * Move the range to a new center point
	     * @param {number} moveTo      New center point of the range
	     */

	  }, {
	    key: "moveTo",
	    value: function moveTo(_moveTo) {
	      var center = (this.start + this.end) / 2;
	      var diff = center - _moveTo; // calculate new start and end

	      var newStart = this.start - diff;
	      var newEnd = this.end - diff;
	      var options = {
	        animation: false,
	        byUser: true,
	        event: null
	      };
	      this.setRange(newStart, newEnd, options);
	    }
	  }], [{
	    key: "conversion",
	    value: function conversion(start, end, width, totalHidden) {
	      if (totalHidden === undefined) {
	        totalHidden = 0;
	      }

	      if (width != 0 && end - start != 0) {
	        return {
	          offset: start,
	          scale: width / (end - start - totalHidden)
	        };
	      } else {
	        return {
	          offset: 0,
	          scale: 1
	        };
	      }
	    }
	  }]);

	  return Range;
	}(Component);

	function validateDirection(direction) {
	  if (direction != 'horizontal' && direction != 'vertical') {
	    throw new TypeError("Unknown direction \"".concat(direction, "\". Choose \"horizontal\" or \"vertical\"."));
	  }
	}

	var setInterval$1 = {exports: {}};

	var path = path$t;
	var setInterval = path.setInterval;

	(function (module) {
	  module.exports = setInterval;
	})(setInterval$1);

	var _setInterval = /*@__PURE__*/getDefaultExportFromCjs(setInterval$1.exports);

	var _firstTarget = null; // singleton, will contain the target element where the touch event started

	/**
	 * Extend an Hammer.js instance with event propagation.
	 *
	 * Features:
	 * - Events emitted by hammer will propagate in order from child to parent
	 *   elements.
	 * - Events are extended with a function `event.stopPropagation()` to stop
	 *   propagation to parent elements.
	 * - An option `preventDefault` to stop all default browser behavior.
	 *
	 * Usage:
	 *   var hammer = propagatingHammer(new Hammer(element));
	 *   var hammer = propagatingHammer(new Hammer(element), {preventDefault: true});
	 *
	 * @param {Hammer.Manager} hammer   An hammer instance.
	 * @param {Object} [options]        Available options:
	 *                                  - `preventDefault: true | false | 'mouse' | 'touch' | 'pen'`.
	 *                                    Enforce preventing the default browser behavior.
	 *                                    Cannot be set to `false`.
	 * @return {Hammer.Manager} Returns the same hammer instance with extended
	 *                          functionality
	 */

	function propagating(hammer, options) {
	  var _options = options || {
	    preventDefault: false
	  };

	  if (hammer.Manager) {
	    // This looks like the Hammer constructor.
	    // Overload the constructors with our own.
	    var Hammer = hammer;

	    var PropagatingHammer = function (element, options) {
	      var o = Object.create(_options);
	      if (options) Hammer.assign(o, options);
	      return propagating(new Hammer(element, o), o);
	    };

	    Hammer.assign(PropagatingHammer, Hammer);

	    PropagatingHammer.Manager = function (element, options) {
	      var o = Object.create(_options);
	      if (options) Hammer.assign(o, options);
	      return propagating(new Hammer.Manager(element, o), o);
	    };

	    return PropagatingHammer;
	  } // create a wrapper object which will override the functions
	  // `on`, `off`, `destroy`, and `emit` of the hammer instance


	  var wrapper = Object.create(hammer); // attach to DOM element

	  var element = hammer.element;
	  if (!element.hammer) element.hammer = [];
	  element.hammer.push(wrapper); // register an event to catch the start of a gesture and store the
	  // target in a singleton

	  hammer.on('hammer.input', function (event) {
	    if (_options.preventDefault === true || _options.preventDefault === event.pointerType) {
	      event.preventDefault();
	    }

	    if (event.isFirst) {
	      _firstTarget = event.target;
	    }
	  });
	  /** @type {Object.<String, Array.<function>>} */

	  wrapper._handlers = {};
	  /**
	   * Register a handler for one or multiple events
	   * @param {String} events    A space separated string with events
	   * @param {function} handler A callback function, called as handler(event)
	   * @returns {Hammer.Manager} Returns the hammer instance
	   */

	  wrapper.on = function (events, handler) {
	    // register the handler
	    split(events).forEach(function (event) {
	      var _handlers = wrapper._handlers[event];

	      if (!_handlers) {
	        wrapper._handlers[event] = _handlers = []; // register the static, propagated handler

	        hammer.on(event, propagatedHandler);
	      }

	      _handlers.push(handler);
	    });
	    return wrapper;
	  };
	  /**
	   * Unregister a handler for one or multiple events
	   * @param {String} events      A space separated string with events
	   * @param {function} [handler] Optional. The registered handler. If not
	   *                             provided, all handlers for given events
	   *                             are removed.
	   * @returns {Hammer.Manager}   Returns the hammer instance
	   */


	  wrapper.off = function (events, handler) {
	    // unregister the handler
	    split(events).forEach(function (event) {
	      var _handlers = wrapper._handlers[event];

	      if (_handlers) {
	        _handlers = handler ? _handlers.filter(function (h) {
	          return h !== handler;
	        }) : [];

	        if (_handlers.length > 0) {
	          wrapper._handlers[event] = _handlers;
	        } else {
	          // remove static, propagated handler
	          hammer.off(event, propagatedHandler);
	          delete wrapper._handlers[event];
	        }
	      }
	    });
	    return wrapper;
	  };
	  /**
	   * Emit to the event listeners
	   * @param {string} eventType
	   * @param {Event} event
	   */


	  wrapper.emit = function (eventType, event) {
	    _firstTarget = event.target;
	    hammer.emit(eventType, event);
	  };

	  wrapper.destroy = function () {
	    // Detach from DOM element
	    var hammers = hammer.element.hammer;
	    var idx = hammers.indexOf(wrapper);
	    if (idx !== -1) hammers.splice(idx, 1);
	    if (!hammers.length) delete hammer.element.hammer; // clear all handlers

	    wrapper._handlers = {}; // call original hammer destroy

	    hammer.destroy();
	  }; // split a string with space separated words


	  function split(events) {
	    return events.match(/[^ ]+/g);
	  }
	  /**
	   * A static event handler, applying event propagation.
	   * @param {Object} event
	   */


	  function propagatedHandler(event) {
	    // let only a single hammer instance handle this event
	    if (event.type !== 'hammer.input') {
	      // it is possible that the same srcEvent is used with multiple hammer events,
	      // we keep track on which events are handled in an object _handled
	      if (!event.srcEvent._handled) {
	        event.srcEvent._handled = {};
	      }

	      if (event.srcEvent._handled[event.type]) {
	        return;
	      } else {
	        event.srcEvent._handled[event.type] = true;
	      }
	    } // attach a stopPropagation function to the event


	    var stopped = false;

	    event.stopPropagation = function () {
	      stopped = true;
	    }; //wrap the srcEvent's stopPropagation to also stop hammer propagation:


	    var srcStop = event.srcEvent.stopPropagation.bind(event.srcEvent);

	    if (typeof srcStop == "function") {
	      event.srcEvent.stopPropagation = function () {
	        srcStop();
	        event.stopPropagation();
	      };
	    } // attach firstTarget property to the event


	    event.firstTarget = _firstTarget; // propagate over all elements (until stopped)

	    var elem = _firstTarget;

	    while (elem && !stopped) {
	      var elemHammer = elem.hammer;

	      if (elemHammer) {
	        var _handlers;

	        for (var k = 0; k < elemHammer.length; k++) {
	          _handlers = elemHammer[k]._handlers[event.type];
	          if (_handlers) for (var i = 0; i < _handlers.length && !stopped; i++) {
	            _handlers[i](event);
	          }
	        }
	      }

	      elem = elem.parentNode;
	    }
	  }

	  return wrapper;
	}

	/**
	 * Setup a mock hammer.js object, for unit testing.
	 *
	 * Inspiration: https://github.com/uber/deck.gl/pull/658
	 *
	 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
	 */

	function hammerMock() {
	  var noop = function noop() {};

	  return {
	    on: noop,
	    off: noop,
	    destroy: noop,
	    emit: noop,
	    get: function get(m) {
	      //eslint-disable-line no-unused-vars
	      return {
	        set: noop
	      };
	    }
	  };
	}

	var modifiedHammer;

	if (typeof window !== 'undefined') {
	  var OurHammer = window['Hammer'] || Hammer$3;
	  modifiedHammer = propagating(OurHammer, {
	    preventDefault: 'mouse'
	  });
	} else {
	  modifiedHammer = function modifiedHammer() {
	    return (// hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
	      hammerMock()
	    );
	  };
	}

	var Hammer = modifiedHammer;

	/**
	 * Register a touch event, taking place before a gesture
	 * @param {Hammer} hammer       A hammer instance
	 * @param {function} callback   Callback, called as callback(event)
	 */
	function onTouch(hammer, callback) {
	  callback.inputHandler = function (event) {
	    if (event.isFirst) {
	      callback(event);
	    }
	  };

	  hammer.on('hammer.input', callback.inputHandler);
	}
	/**
	 * Register a release event, taking place after a gesture
	 * @param {Hammer} hammer       A hammer instance
	 * @param {function} callback   Callback, called as callback(event)
	 * @returns {*}
	 */

	function onRelease(hammer, callback) {
	  callback.inputHandler = function (event) {
	    if (event.isFinal) {
	      callback(event);
	    }
	  };

	  return hammer.on('hammer.input', callback.inputHandler);
	}
	/**
	 * Hack the PinchRecognizer such that it doesn't prevent default behavior
	 * for vertical panning.
	 *
	 * Yeah ... this is quite a hack ... see https://github.com/hammerjs/hammer.js/issues/932
	 *
	 * @param {Hammer.Pinch} pinchRecognizer
	 * @return {Hammer.Pinch} returns the pinchRecognizer
	 */

	function disablePreventDefaultVertically(pinchRecognizer) {
	  var TOUCH_ACTION_PAN_Y = 'pan-y';

	  pinchRecognizer.getTouchAction = function () {
	    // default method returns [TOUCH_ACTION_NONE]
	    return [TOUCH_ACTION_PAN_Y];
	  };

	  return pinchRecognizer;
	}

	/**
	 * The class TimeStep is an iterator for dates. You provide a start date and an
	 * end date. The class itself determines the best scale (step size) based on the
	 * provided start Date, end Date, and minimumStep.
	 *
	 * If minimumStep is provided, the step size is chosen as close as possible
	 * to the minimumStep but larger than minimumStep. If minimumStep is not
	 * provided, the scale is set to 1 DAY.
	 * The minimumStep should correspond with the onscreen size of about 6 characters
	 *
	 * Alternatively, you can set a scale by hand.
	 * After creation, you can initialize the class by executing first(). Then you
	 * can iterate from the start date to the end date via next(). You can check if
	 * the end date is reached with the function hasNext(). After each step, you can
	 * retrieve the current date via getCurrent().
	 * The TimeStep has scales ranging from milliseconds, seconds, minutes, hours,
	 * days, to years.
	 *
	 * Version: 1.2
	 *
	 */

	var TimeStep = /*#__PURE__*/function () {
	  /**
	    * @param {Date} [start]         The start date, for example new Date(2010, 9, 21)
	    *                               or new Date(2010, 9, 21, 23, 45, 00)
	    * @param {Date} [end]           The end date
	    * @param {number} [minimumStep] Optional. Minimum step size in milliseconds
	    * @param {Date|Array.<Date>} [hiddenDates] Optional.
	    * @param {{showMajorLabels: boolean, showWeekScale: boolean}} [options] Optional.
	    * @constructor  TimeStep
	    */
	  function TimeStep(start, end, minimumStep, hiddenDates, options) {
	    _classCallCheck(this, TimeStep);

	    this.moment = options && options.moment || moment$2;
	    this.options = options ? options : {}; // variables

	    this.current = this.moment();
	    this._start = this.moment();
	    this._end = this.moment();
	    this.autoScale = true;
	    this.scale = 'day';
	    this.step = 1; // initialize the range

	    this.setRange(start, end, minimumStep); // hidden Dates options

	    this.switchedDay = false;
	    this.switchedMonth = false;
	    this.switchedYear = false;

	    if (_Array$isArray(hiddenDates)) {
	      this.hiddenDates = hiddenDates;
	    } else if (hiddenDates != undefined) {
	      this.hiddenDates = [hiddenDates];
	    } else {
	      this.hiddenDates = [];
	    }

	    this.format = TimeStep.FORMAT; // default formatting
	  }
	  /**
	   * Set custom constructor function for moment. Can be used to set dates
	   * to UTC or to set a utcOffset.
	   * @param {function} moment
	   */


	  _createClass(TimeStep, [{
	    key: "setMoment",
	    value: function setMoment(moment) {
	      this.moment = moment; // update the date properties, can have a new utcOffset

	      this.current = this.moment(this.current.valueOf());
	      this._start = this.moment(this._start.valueOf());
	      this._end = this.moment(this._end.valueOf());
	    }
	    /**
	     * Set custom formatting for the minor an major labels of the TimeStep.
	     * Both `minorLabels` and `majorLabels` are an Object with properties:
	     * 'millisecond', 'second', 'minute', 'hour', 'weekday', 'day', 'week', 'month', 'year'.
	     * @param {{minorLabels: Object, majorLabels: Object}} format
	     */

	  }, {
	    key: "setFormat",
	    value: function setFormat(format) {
	      var defaultFormat = availableUtils.deepExtend({}, TimeStep.FORMAT);
	      this.format = availableUtils.deepExtend(defaultFormat, format);
	    }
	    /**
	     * Set a new range
	     * If minimumStep is provided, the step size is chosen as close as possible
	     * to the minimumStep but larger than minimumStep. If minimumStep is not
	     * provided, the scale is set to 1 DAY.
	     * The minimumStep should correspond with the onscreen size of about 6 characters
	     * @param {Date} [start]      The start date and time.
	     * @param {Date} [end]        The end date and time.
	     * @param {int} [minimumStep] Optional. Minimum step size in milliseconds
	     */

	  }, {
	    key: "setRange",
	    value: function setRange(start, end, minimumStep) {
	      if (!(start instanceof Date) || !(end instanceof Date)) {
	        throw "No legal start or end date in method setRange";
	      }

	      this._start = start != undefined ? this.moment(start.valueOf()) : _Date$now();
	      this._end = end != undefined ? this.moment(end.valueOf()) : _Date$now();

	      if (this.autoScale) {
	        this.setMinimumStep(minimumStep);
	      }
	    }
	    /**
	     * Set the range iterator to the start date.
	     */

	  }, {
	    key: "start",
	    value: function start() {
	      this.current = this._start.clone();
	      this.roundToMinor();
	    }
	    /**
	     * Round the current date to the first minor date value
	     * This must be executed once when the current date is set to start Date
	     */

	  }, {
	    key: "roundToMinor",
	    value: function roundToMinor() {
	      // round to floor
	      // to prevent year & month scales rounding down to the first day of week we perform this separately
	      if (this.scale == 'week') {
	        this.current.weekday(0);
	      } // IMPORTANT: we have no breaks in this switch! (this is no bug)
	      // noinspection FallThroughInSwitchStatementJS


	      switch (this.scale) {
	        case 'year':
	          this.current.year(this.step * Math.floor(this.current.year() / this.step));
	          this.current.month(0);
	        // eslint-disable-line no-fallthrough

	        case 'month':
	          this.current.date(1);
	        // eslint-disable-line no-fallthrough

	        case 'week': // eslint-disable-line no-fallthrough

	        case 'day': // eslint-disable-line no-fallthrough

	        case 'weekday':
	          this.current.hours(0);
	        // eslint-disable-line no-fallthrough

	        case 'hour':
	          this.current.minutes(0);
	        // eslint-disable-line no-fallthrough

	        case 'minute':
	          this.current.seconds(0);
	        // eslint-disable-line no-fallthrough

	        case 'second':
	          this.current.milliseconds(0);
	        // eslint-disable-line no-fallthrough
	        //case 'millisecond': // nothing to do for milliseconds
	      }

	      if (this.step != 1) {
	        // round down to the first minor value that is a multiple of the current step size
	        var priorCurrent = this.current.clone();

	        switch (this.scale) {
	          case 'millisecond':
	            this.current.subtract(this.current.milliseconds() % this.step, 'milliseconds');
	            break;

	          case 'second':
	            this.current.subtract(this.current.seconds() % this.step, 'seconds');
	            break;

	          case 'minute':
	            this.current.subtract(this.current.minutes() % this.step, 'minutes');
	            break;

	          case 'hour':
	            this.current.subtract(this.current.hours() % this.step, 'hours');
	            break;

	          case 'weekday': // intentional fall through

	          case 'day':
	            this.current.subtract((this.current.date() - 1) % this.step, 'day');
	            break;

	          case 'week':
	            this.current.subtract(this.current.week() % this.step, 'week');
	            break;

	          case 'month':
	            this.current.subtract(this.current.month() % this.step, 'month');
	            break;

	          case 'year':
	            this.current.subtract(this.current.year() % this.step, 'year');
	            break;
	        }

	        if (!priorCurrent.isSame(this.current)) {
	          this.current = this.moment(snapAwayFromHidden(this.hiddenDates, this.current.valueOf(), -1, true));
	        }
	      }
	    }
	    /**
	     * Check if the there is a next step
	     * @return {boolean}  true if the current date has not passed the end date
	     */

	  }, {
	    key: "hasNext",
	    value: function hasNext() {
	      return this.current.valueOf() <= this._end.valueOf();
	    }
	    /**
	     * Do the next step
	     */

	  }, {
	    key: "next",
	    value: function next() {
	      var prev = this.current.valueOf(); // Two cases, needed to prevent issues with switching daylight savings
	      // (end of March and end of October)

	      switch (this.scale) {
	        case 'millisecond':
	          this.current.add(this.step, 'millisecond');
	          break;

	        case 'second':
	          this.current.add(this.step, 'second');
	          break;

	        case 'minute':
	          this.current.add(this.step, 'minute');
	          break;

	        case 'hour':
	          this.current.add(this.step, 'hour');

	          if (this.current.month() < 6) {
	            this.current.subtract(this.current.hours() % this.step, 'hour');
	          } else {
	            if (this.current.hours() % this.step !== 0) {
	              this.current.add(this.step - this.current.hours() % this.step, 'hour');
	            }
	          }

	          break;

	        case 'weekday': // intentional fall through

	        case 'day':
	          this.current.add(this.step, 'day');
	          break;

	        case 'week':
	          if (this.current.weekday() !== 0) {
	            // we had a month break not correlating with a week's start before
	            this.current.weekday(0); // switch back to week cycles

	            this.current.add(this.step, 'week');
	          } else if (this.options.showMajorLabels === false) {
	            this.current.add(this.step, 'week'); // the default case
	          } else {
	            // first day of the week
	            var nextWeek = this.current.clone();
	            nextWeek.add(1, 'week');

	            if (nextWeek.isSame(this.current, 'month')) {
	              // is the first day of the next week in the same month?
	              this.current.add(this.step, 'week'); // the default case
	            } else {
	              // inject a step at each first day of the month
	              this.current.add(this.step, 'week');
	              this.current.date(1);
	            }
	          }

	          break;

	        case 'month':
	          this.current.add(this.step, 'month');
	          break;

	        case 'year':
	          this.current.add(this.step, 'year');
	          break;
	      }

	      if (this.step != 1) {
	        // round down to the correct major value
	        switch (this.scale) {
	          case 'millisecond':
	            if (this.current.milliseconds() > 0 && this.current.milliseconds() < this.step) this.current.milliseconds(0);
	            break;

	          case 'second':
	            if (this.current.seconds() > 0 && this.current.seconds() < this.step) this.current.seconds(0);
	            break;

	          case 'minute':
	            if (this.current.minutes() > 0 && this.current.minutes() < this.step) this.current.minutes(0);
	            break;

	          case 'hour':
	            if (this.current.hours() > 0 && this.current.hours() < this.step) this.current.hours(0);
	            break;

	          case 'weekday': // intentional fall through

	          case 'day':
	            if (this.current.date() < this.step + 1) this.current.date(1);
	            break;

	          case 'week':
	            if (this.current.week() < this.step) this.current.week(1);
	            break;
	          // week numbering starts at 1, not 0

	          case 'month':
	            if (this.current.month() < this.step) this.current.month(0);
	            break;
	        }
	      } // safety mechanism: if current time is still unchanged, move to the end


	      if (this.current.valueOf() == prev) {
	        this.current = this._end.clone();
	      } // Reset switches for year, month and day. Will get set to true where appropriate in DateUtil.stepOverHiddenDates


	      this.switchedDay = false;
	      this.switchedMonth = false;
	      this.switchedYear = false;
	      stepOverHiddenDates(this.moment, this, prev);
	    }
	    /**
	     * Get the current datetime
	     * @return {Moment}  current The current date
	     */

	  }, {
	    key: "getCurrent",
	    value: function getCurrent() {
	      return this.current.clone();
	    }
	    /**
	     * Set a custom scale. Autoscaling will be disabled.
	     * For example setScale('minute', 5) will result
	     * in minor steps of 5 minutes, and major steps of an hour.
	     *
	     * @param {{scale: string, step: number}} params
	     *                               An object containing two properties:
	     *                               - A string 'scale'. Choose from 'millisecond', 'second',
	     *                                 'minute', 'hour', 'weekday', 'day', 'week', 'month', 'year'.
	     *                               - A number 'step'. A step size, by default 1.
	     *                                 Choose for example 1, 2, 5, or 10.
	     */

	  }, {
	    key: "setScale",
	    value: function setScale(params) {
	      if (params && typeof params.scale == 'string') {
	        this.scale = params.scale;
	        this.step = params.step > 0 ? params.step : 1;
	        this.autoScale = false;
	      }
	    }
	    /**
	     * Enable or disable autoscaling
	     * @param {boolean} enable  If true, autoascaling is set true
	     */

	  }, {
	    key: "setAutoScale",
	    value: function setAutoScale(enable) {
	      this.autoScale = enable;
	    }
	    /**
	     * Automatically determine the scale that bests fits the provided minimum step
	     * @param {number} [minimumStep]  The minimum step size in milliseconds
	     */

	  }, {
	    key: "setMinimumStep",
	    value: function setMinimumStep(minimumStep) {
	      if (minimumStep == undefined) {
	        return;
	      } //var b = asc + ds;


	      var stepYear = 1000 * 60 * 60 * 24 * 30 * 12;
	      var stepMonth = 1000 * 60 * 60 * 24 * 30;
	      var stepDay = 1000 * 60 * 60 * 24;
	      var stepHour = 1000 * 60 * 60;
	      var stepMinute = 1000 * 60;
	      var stepSecond = 1000;
	      var stepMillisecond = 1; // find the smallest step that is larger than the provided minimumStep

	      if (stepYear * 1000 > minimumStep) {
	        this.scale = 'year';
	        this.step = 1000;
	      }

	      if (stepYear * 500 > minimumStep) {
	        this.scale = 'year';
	        this.step = 500;
	      }

	      if (stepYear * 100 > minimumStep) {
	        this.scale = 'year';
	        this.step = 100;
	      }

	      if (stepYear * 50 > minimumStep) {
	        this.scale = 'year';
	        this.step = 50;
	      }

	      if (stepYear * 10 > minimumStep) {
	        this.scale = 'year';
	        this.step = 10;
	      }

	      if (stepYear * 5 > minimumStep) {
	        this.scale = 'year';
	        this.step = 5;
	      }

	      if (stepYear > minimumStep) {
	        this.scale = 'year';
	        this.step = 1;
	      }

	      if (stepMonth * 3 > minimumStep) {
	        this.scale = 'month';
	        this.step = 3;
	      }

	      if (stepMonth > minimumStep) {
	        this.scale = 'month';
	        this.step = 1;
	      }

	      if (stepDay * 7 > minimumStep && this.options.showWeekScale) {
	        this.scale = 'week';
	        this.step = 1;
	      }

	      if (stepDay * 2 > minimumStep) {
	        this.scale = 'day';
	        this.step = 2;
	      }

	      if (stepDay > minimumStep) {
	        this.scale = 'day';
	        this.step = 1;
	      }

	      if (stepDay / 2 > minimumStep) {
	        this.scale = 'weekday';
	        this.step = 1;
	      }

	      if (stepHour * 4 > minimumStep) {
	        this.scale = 'hour';
	        this.step = 4;
	      }

	      if (stepHour > minimumStep) {
	        this.scale = 'hour';
	        this.step = 1;
	      }

	      if (stepMinute * 15 > minimumStep) {
	        this.scale = 'minute';
	        this.step = 15;
	      }

	      if (stepMinute * 10 > minimumStep) {
	        this.scale = 'minute';
	        this.step = 10;
	      }

	      if (stepMinute * 5 > minimumStep) {
	        this.scale = 'minute';
	        this.step = 5;
	      }

	      if (stepMinute > minimumStep) {
	        this.scale = 'minute';
	        this.step = 1;
	      }

	      if (stepSecond * 15 > minimumStep) {
	        this.scale = 'second';
	        this.step = 15;
	      }

	      if (stepSecond * 10 > minimumStep) {
	        this.scale = 'second';
	        this.step = 10;
	      }

	      if (stepSecond * 5 > minimumStep) {
	        this.scale = 'second';
	        this.step = 5;
	      }

	      if (stepSecond > minimumStep) {
	        this.scale = 'second';
	        this.step = 1;
	      }

	      if (stepMillisecond * 200 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 200;
	      }

	      if (stepMillisecond * 100 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 100;
	      }

	      if (stepMillisecond * 50 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 50;
	      }

	      if (stepMillisecond * 10 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 10;
	      }

	      if (stepMillisecond * 5 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 5;
	      }

	      if (stepMillisecond > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 1;
	      }
	    }
	    /**
	     * Snap a date to a rounded value.
	     * The snap intervals are dependent on the current scale and step.
	     * Static function
	     * @param {Date} date    the date to be snapped.
	     * @param {string} scale Current scale, can be 'millisecond', 'second',
	     *                       'minute', 'hour', 'weekday, 'day', 'week', 'month', 'year'.
	     * @param {number} step  Current step (1, 2, 4, 5, ...
	     * @return {Date} snappedDate
	     */

	  }, {
	    key: "isMajor",
	    value:
	    /**
	     * Check if the current value is a major value (for example when the step
	     * is DAY, a major value is each first day of the MONTH)
	     * @return {boolean} true if current date is major, else false.
	     */
	    function isMajor() {
	      if (this.switchedYear == true) {
	        switch (this.scale) {
	          case 'year':
	          case 'month':
	          case 'week':
	          case 'weekday':
	          case 'day':
	          case 'hour':
	          case 'minute':
	          case 'second':
	          case 'millisecond':
	            return true;

	          default:
	            return false;
	        }
	      } else if (this.switchedMonth == true) {
	        switch (this.scale) {
	          case 'week':
	          case 'weekday':
	          case 'day':
	          case 'hour':
	          case 'minute':
	          case 'second':
	          case 'millisecond':
	            return true;

	          default:
	            return false;
	        }
	      } else if (this.switchedDay == true) {
	        switch (this.scale) {
	          case 'millisecond':
	          case 'second':
	          case 'minute':
	          case 'hour':
	            return true;

	          default:
	            return false;
	        }
	      }

	      var date = this.moment(this.current);

	      switch (this.scale) {
	        case 'millisecond':
	          return date.milliseconds() == 0;

	        case 'second':
	          return date.seconds() == 0;

	        case 'minute':
	          return date.hours() == 0 && date.minutes() == 0;

	        case 'hour':
	          return date.hours() == 0;

	        case 'weekday': // intentional fall through

	        case 'day':
	          return this.options.showWeekScale ? date.isoWeekday() == 1 : date.date() == 1;

	        case 'week':
	          return date.date() == 1;

	        case 'month':
	          return date.month() == 0;

	        case 'year':
	          return false;

	        default:
	          return false;
	      }
	    }
	    /**
	     * Returns formatted text for the minor axislabel, depending on the current
	     * date and the scale. For example when scale is MINUTE, the current time is
	     * formatted as "hh:mm".
	     * @param {Date} [date=this.current] custom date. if not provided, current date is taken
	     * @returns {String}
	     */

	  }, {
	    key: "getLabelMinor",
	    value: function getLabelMinor(date) {
	      if (date == undefined) {
	        date = this.current;
	      }

	      if (date instanceof Date) {
	        date = this.moment(date);
	      }

	      if (typeof this.format.minorLabels === "function") {
	        return this.format.minorLabels(date, this.scale, this.step);
	      }

	      var format = this.format.minorLabels[this.scale]; // noinspection FallThroughInSwitchStatementJS

	      switch (this.scale) {
	        case 'week':
	          // Don't draw the minor label if this date is the first day of a month AND if it's NOT the start of the week.
	          // The 'date' variable may actually be the 'next' step when called from TimeAxis' _repaintLabels.
	          if (date.date() === 1 && date.weekday() !== 0) {
	            return "";
	          }

	        default:
	          // eslint-disable-line no-fallthrough
	          return format && format.length > 0 ? this.moment(date).format(format) : '';
	      }
	    }
	    /**
	     * Returns formatted text for the major axis label, depending on the current
	     * date and the scale. For example when scale is MINUTE, the major scale is
	     * hours, and the hour will be formatted as "hh".
	     * @param {Date} [date=this.current] custom date. if not provided, current date is taken
	     * @returns {String}
	     */

	  }, {
	    key: "getLabelMajor",
	    value: function getLabelMajor(date) {
	      if (date == undefined) {
	        date = this.current;
	      }

	      if (date instanceof Date) {
	        date = this.moment(date);
	      }

	      if (typeof this.format.majorLabels === "function") {
	        return this.format.majorLabels(date, this.scale, this.step);
	      }

	      var format = this.format.majorLabels[this.scale];
	      return format && format.length > 0 ? this.moment(date).format(format) : '';
	    }
	    /**
	     * get class name
	     * @return {string} class name
	     */

	  }, {
	    key: "getClassName",
	    value: function getClassName() {
	      var _context;

	      var _moment = this.moment;
	      var m = this.moment(this.current);
	      var current = m.locale ? m.locale('en') : m.lang('en'); // old versions of moment have .lang() function

	      var step = this.step;
	      var classNames = [];
	      /**
	       *
	       * @param {number} value
	       * @returns {String}
	       */

	      function even(value) {
	        return value / step % 2 == 0 ? ' vis-even' : ' vis-odd';
	      }
	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */


	      function today(date) {
	        if (date.isSame(_Date$now(), 'day')) {
	          return ' vis-today';
	        }

	        if (date.isSame(_moment().add(1, 'day'), 'day')) {
	          return ' vis-tomorrow';
	        }

	        if (date.isSame(_moment().add(-1, 'day'), 'day')) {
	          return ' vis-yesterday';
	        }

	        return '';
	      }
	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */


	      function currentWeek(date) {
	        return date.isSame(_Date$now(), 'week') ? ' vis-current-week' : '';
	      }
	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */


	      function currentMonth(date) {
	        return date.isSame(_Date$now(), 'month') ? ' vis-current-month' : '';
	      }
	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */


	      function currentYear(date) {
	        return date.isSame(_Date$now(), 'year') ? ' vis-current-year' : '';
	      }

	      switch (this.scale) {
	        case 'millisecond':
	          classNames.push(today(current));
	          classNames.push(even(current.milliseconds()));
	          break;

	        case 'second':
	          classNames.push(today(current));
	          classNames.push(even(current.seconds()));
	          break;

	        case 'minute':
	          classNames.push(today(current));
	          classNames.push(even(current.minutes()));
	          break;

	        case 'hour':
	          classNames.push(_concatInstanceProperty(_context = "vis-h".concat(current.hours())).call(_context, this.step == 4 ? '-h' + (current.hours() + 4) : ''));
	          classNames.push(today(current));
	          classNames.push(even(current.hours()));
	          break;

	        case 'weekday':
	          classNames.push("vis-".concat(current.format('dddd').toLowerCase()));
	          classNames.push(today(current));
	          classNames.push(currentWeek(current));
	          classNames.push(even(current.date()));
	          break;

	        case 'day':
	          classNames.push("vis-day".concat(current.date()));
	          classNames.push("vis-".concat(current.format('MMMM').toLowerCase()));
	          classNames.push(today(current));
	          classNames.push(currentMonth(current));
	          classNames.push(this.step <= 2 ? today(current) : '');
	          classNames.push(this.step <= 2 ? "vis-".concat(current.format('dddd').toLowerCase()) : '');
	          classNames.push(even(current.date() - 1));
	          break;

	        case 'week':
	          classNames.push("vis-week".concat(current.format('w')));
	          classNames.push(currentWeek(current));
	          classNames.push(even(current.week()));
	          break;

	        case 'month':
	          classNames.push("vis-".concat(current.format('MMMM').toLowerCase()));
	          classNames.push(currentMonth(current));
	          classNames.push(even(current.month()));
	          break;

	        case 'year':
	          classNames.push("vis-year".concat(current.year()));
	          classNames.push(currentYear(current));
	          classNames.push(even(current.year()));
	          break;
	      }

	      return _filterInstanceProperty(classNames).call(classNames, String).join(" ");
	    }
	  }], [{
	    key: "snap",
	    value: function snap(date, scale, step) {
	      var clone = moment$2(date);

	      if (scale == 'year') {
	        var year = clone.year() + Math.round(clone.month() / 12);
	        clone.year(Math.round(year / step) * step);
	        clone.month(0);
	        clone.date(0);
	        clone.hours(0);
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'month') {
	        if (clone.date() > 15) {
	          clone.date(1);
	          clone.add(1, 'month'); // important: first set Date to 1, after that change the month.
	        } else {
	          clone.date(1);
	        }

	        clone.hours(0);
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'week') {
	        if (clone.weekday() > 2) {
	          // doing it the momentjs locale aware way
	          clone.weekday(0);
	          clone.add(1, 'week');
	        } else {
	          clone.weekday(0);
	        }

	        clone.hours(0);
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'day') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 5:
	          case 2:
	            clone.hours(Math.round(clone.hours() / 24) * 24);
	            break;

	          default:
	            clone.hours(Math.round(clone.hours() / 12) * 12);
	            break;
	        }

	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'weekday') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 5:
	          case 2:
	            clone.hours(Math.round(clone.hours() / 12) * 12);
	            break;

	          default:
	            clone.hours(Math.round(clone.hours() / 6) * 6);
	            break;
	        }

	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'hour') {
	        switch (step) {
	          case 4:
	            clone.minutes(Math.round(clone.minutes() / 60) * 60);
	            break;

	          default:
	            clone.minutes(Math.round(clone.minutes() / 30) * 30);
	            break;
	        }

	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'minute') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 15:
	          case 10:
	            clone.minutes(Math.round(clone.minutes() / 5) * 5);
	            clone.seconds(0);
	            break;

	          case 5:
	            clone.seconds(Math.round(clone.seconds() / 60) * 60);
	            break;

	          default:
	            clone.seconds(Math.round(clone.seconds() / 30) * 30);
	            break;
	        }

	        clone.milliseconds(0);
	      } else if (scale == 'second') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 15:
	          case 10:
	            clone.seconds(Math.round(clone.seconds() / 5) * 5);
	            clone.milliseconds(0);
	            break;

	          case 5:
	            clone.milliseconds(Math.round(clone.milliseconds() / 1000) * 1000);
	            break;

	          default:
	            clone.milliseconds(Math.round(clone.milliseconds() / 500) * 500);
	            break;
	        }
	      } else if (scale == 'millisecond') {
	        var _step = step > 5 ? step / 2 : 1;

	        clone.milliseconds(Math.round(clone.milliseconds() / _step) * _step);
	      }

	      return clone;
	    }
	  }]);

	  return TimeStep;
	}(); // Time formatting


	TimeStep.FORMAT = {
	  minorLabels: {
	    millisecond: 'SSS',
	    second: 's',
	    minute: 'HH:mm',
	    hour: 'HH:mm',
	    weekday: 'ddd D',
	    day: 'D',
	    week: 'w',
	    month: 'MMM',
	    year: 'YYYY'
	  },
	  majorLabels: {
	    millisecond: 'HH:mm:ss',
	    second: 'D MMMM HH:mm',
	    minute: 'ddd D MMMM',
	    hour: 'ddd D MMMM',
	    weekday: 'MMMM YYYY',
	    day: 'MMMM YYYY',
	    week: 'MMMM YYYY',
	    month: 'YYYY',
	    year: ''
	  }
	};

	function styleInject(css, ref) {
	  if (ref === void 0) ref = {};
	  var insertAt = ref.insertAt;

	  if (!css || typeof document === 'undefined') {
	    return;
	  }

	  var head = document.head || document.getElementsByTagName('head')[0];
	  var style = document.createElement('style');
	  style.type = 'text/css';

	  if (insertAt === 'top') {
	    if (head.firstChild) {
	      head.insertBefore(style, head.firstChild);
	    } else {
	      head.appendChild(style);
	    }
	  } else {
	    head.appendChild(style);
	  }

	  if (style.styleSheet) {
	    style.styleSheet.cssText = css;
	  } else {
	    style.appendChild(document.createTextNode(css));
	  }
	}

	var css_248z$e = ".vis-time-axis {\n  position: relative;\n  overflow: hidden;\n}\n\n.vis-time-axis.vis-foreground {\n  top: 0;\n  left: 0;\n  width: 100%;\n}\n\n.vis-time-axis.vis-background {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n}\n\n.vis-time-axis .vis-text {\n  position: absolute;\n  color: #4d4d4d;\n  padding: 3px;\n  overflow: hidden;\n  box-sizing: border-box;\n\n  white-space: nowrap;\n}\n\n.vis-time-axis .vis-text.vis-measure {\n  position: absolute;\n  padding-left: 0;\n  padding-right: 0;\n  margin-left: 0;\n  margin-right: 0;\n  visibility: hidden;\n}\n\n.vis-time-axis .vis-grid.vis-vertical {\n  position: absolute;\n  border-left: 1px solid;\n}\n\n.vis-time-axis .vis-grid.vis-vertical-rtl {\n  position: absolute;\n  border-right: 1px solid;\n}\n\n.vis-time-axis .vis-grid.vis-minor {\n  border-color: #e5e5e5;\n}\n\n.vis-time-axis .vis-grid.vis-major {\n  border-color: #bfbfbf;\n}\n";
	styleInject(css_248z$e);

	function _createSuper$b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$b(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$b() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/** A horizontal time axis */

	var TimeAxis = /*#__PURE__*/function (_Component) {
	  _inherits(TimeAxis, _Component);

	  var _super = _createSuper$b(TimeAxis);

	  /**
	   * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} body
	   * @param {Object} [options]        See TimeAxis.setOptions for the available
	   *                                  options.
	   * @constructor TimeAxis
	   * @extends Component
	   */
	  function TimeAxis(body, options) {
	    var _this;

	    _classCallCheck(this, TimeAxis);

	    _this = _super.call(this);
	    _this.dom = {
	      foreground: null,
	      lines: [],
	      majorTexts: [],
	      minorTexts: [],
	      redundant: {
	        lines: [],
	        majorTexts: [],
	        minorTexts: []
	      }
	    };
	    _this.props = {
	      range: {
	        start: 0,
	        end: 0,
	        minimumStep: 0
	      },
	      lineTop: 0
	    };
	    _this.defaultOptions = {
	      orientation: {
	        axis: 'bottom'
	      },
	      // axis orientation: 'top' or 'bottom'
	      showMinorLabels: true,
	      showMajorLabels: true,
	      showWeekScale: false,
	      maxMinorChars: 7,
	      format: availableUtils.extend({}, TimeStep.FORMAT),
	      moment: moment$2,
	      timeAxis: null
	    };
	    _this.options = availableUtils.extend({}, _this.defaultOptions);
	    _this.body = body; // create the HTML DOM

	    _this._create();

	    _this.setOptions(options);

	    return _this;
	  }
	  /**
	   * Set options for the TimeAxis.
	   * Parameters will be merged in current options.
	   * @param {Object} options  Available options:
	   *                          {string} [orientation.axis]
	   *                          {boolean} [showMinorLabels]
	   *                          {boolean} [showMajorLabels]
	   *                          {boolean} [showWeekScale]
	   */


	  _createClass(TimeAxis, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        // copy all options that we know
	        availableUtils.selectiveExtend(['showMinorLabels', 'showMajorLabels', 'showWeekScale', 'maxMinorChars', 'hiddenDates', 'timeAxis', 'moment', 'rtl'], this.options, options); // deep copy the format options

	        availableUtils.selectiveDeepExtend(['format'], this.options, options);

	        if ('orientation' in options) {
	          if (typeof options.orientation === 'string') {
	            this.options.orientation.axis = options.orientation;
	          } else if (_typeof$1(options.orientation) === 'object' && 'axis' in options.orientation) {
	            this.options.orientation.axis = options.orientation.axis;
	          }
	        } // apply locale to moment.js
	        // TODO: not so nice, this is applied globally to moment.js


	        if ('locale' in options) {
	          if (typeof moment$2.locale === 'function') {
	            // moment.js 2.8.1+
	            moment$2.locale(options.locale);
	          } else {
	            moment$2.lang(options.locale);
	          }
	        }
	      }
	    }
	    /**
	     * Create the HTML DOM for the TimeAxis
	     */

	  }, {
	    key: "_create",
	    value: function _create() {
	      this.dom.foreground = document.createElement('div');
	      this.dom.background = document.createElement('div');
	      this.dom.foreground.className = 'vis-time-axis vis-foreground';
	      this.dom.background.className = 'vis-time-axis vis-background';
	    }
	    /**
	     * Destroy the TimeAxis
	     */

	  }, {
	    key: "destroy",
	    value: function destroy() {
	      // remove from DOM
	      if (this.dom.foreground.parentNode) {
	        this.dom.foreground.parentNode.removeChild(this.dom.foreground);
	      }

	      if (this.dom.background.parentNode) {
	        this.dom.background.parentNode.removeChild(this.dom.background);
	      }

	      this.body = null;
	    }
	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */

	  }, {
	    key: "redraw",
	    value: function redraw() {
	      var props = this.props;
	      var foreground = this.dom.foreground;
	      var background = this.dom.background; // determine the correct parent DOM element (depending on option orientation)

	      var parent = this.options.orientation.axis == 'top' ? this.body.dom.top : this.body.dom.bottom;
	      var parentChanged = foreground.parentNode !== parent; // calculate character width and height

	      this._calculateCharSize(); // TODO: recalculate sizes only needed when parent is resized or options is changed


	      var showMinorLabels = this.options.showMinorLabels && this.options.orientation.axis !== 'none';
	      var showMajorLabels = this.options.showMajorLabels && this.options.orientation.axis !== 'none'; // determine the width and height of the elemens for the axis

	      props.minorLabelHeight = showMinorLabels ? props.minorCharHeight : 0;
	      props.majorLabelHeight = showMajorLabels ? props.majorCharHeight : 0;
	      props.height = props.minorLabelHeight + props.majorLabelHeight;
	      props.width = foreground.offsetWidth;
	      props.minorLineHeight = this.body.domProps.root.height - props.majorLabelHeight - (this.options.orientation.axis == 'top' ? this.body.domProps.bottom.height : this.body.domProps.top.height);
	      props.minorLineWidth = 1; // TODO: really calculate width

	      props.majorLineHeight = props.minorLineHeight + props.majorLabelHeight;
	      props.majorLineWidth = 1; // TODO: really calculate width
	      //  take foreground and background offline while updating (is almost twice as fast)

	      var foregroundNextSibling = foreground.nextSibling;
	      var backgroundNextSibling = background.nextSibling;
	      foreground.parentNode && foreground.parentNode.removeChild(foreground);
	      background.parentNode && background.parentNode.removeChild(background);
	      foreground.style.height = "".concat(this.props.height, "px");

	      this._repaintLabels(); // put DOM online again (at the same place)


	      if (foregroundNextSibling) {
	        parent.insertBefore(foreground, foregroundNextSibling);
	      } else {
	        parent.appendChild(foreground);
	      }

	      if (backgroundNextSibling) {
	        this.body.dom.backgroundVertical.insertBefore(background, backgroundNextSibling);
	      } else {
	        this.body.dom.backgroundVertical.appendChild(background);
	      }

	      return this._isResized() || parentChanged;
	    }
	    /**
	     * Repaint major and minor text labels and vertical grid lines
	     * @private
	     */

	  }, {
	    key: "_repaintLabels",
	    value: function _repaintLabels() {
	      var orientation = this.options.orientation.axis; // calculate range and step (step such that we have space for 7 characters per label)

	      var start = availableUtils.convert(this.body.range.start, 'Number');
	      var end = availableUtils.convert(this.body.range.end, 'Number');
	      var timeLabelsize = this.body.util.toTime((this.props.minorCharWidth || 10) * this.options.maxMinorChars).valueOf();
	      var minimumStep = timeLabelsize - getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this.body.range, timeLabelsize);
	      minimumStep -= this.body.util.toTime(0).valueOf();
	      var step = new TimeStep(new Date(start), new Date(end), minimumStep, this.body.hiddenDates, this.options);
	      step.setMoment(this.options.moment);

	      if (this.options.format) {
	        step.setFormat(this.options.format);
	      }

	      if (this.options.timeAxis) {
	        step.setScale(this.options.timeAxis);
	      }

	      this.step = step; // Move all DOM elements to a "redundant" list, where they
	      // can be picked for re-use, and clear the lists with lines and texts.
	      // At the end of the function _repaintLabels, left over elements will be cleaned up

	      var dom = this.dom;
	      dom.redundant.lines = dom.lines;
	      dom.redundant.majorTexts = dom.majorTexts;
	      dom.redundant.minorTexts = dom.minorTexts;
	      dom.lines = [];
	      dom.majorTexts = [];
	      dom.minorTexts = [];
	      var current;
	      var next;
	      var x;
	      var xNext;
	      var isMajor;
	      var showMinorGrid;
	      var width = 0;
	      var prevWidth;
	      var line;
	      var xFirstMajorLabel = undefined;
	      var count = 0;
	      var MAX = 1000;
	      var className;
	      step.start();
	      next = step.getCurrent();
	      xNext = this.body.util.toScreen(next);

	      while (step.hasNext() && count < MAX) {
	        count++;
	        isMajor = step.isMajor();
	        className = step.getClassName();
	        current = next;
	        x = xNext;
	        step.next();
	        next = step.getCurrent();
	        xNext = this.body.util.toScreen(next);
	        prevWidth = width;
	        width = xNext - x;

	        switch (step.scale) {
	          case 'week':
	            showMinorGrid = true;
	            break;

	          default:
	            showMinorGrid = width >= prevWidth * 0.4;
	            break;
	          // prevent displaying of the 31th of the month on a scale of 5 days
	        }

	        if (this.options.showMinorLabels && showMinorGrid) {
	          var label = this._repaintMinorText(x, step.getLabelMinor(current), orientation, className);

	          label.style.width = "".concat(width, "px"); // set width to prevent overflow
	        }

	        if (isMajor && this.options.showMajorLabels) {
	          if (x > 0) {
	            if (xFirstMajorLabel == undefined) {
	              xFirstMajorLabel = x;
	            }

	            label = this._repaintMajorText(x, step.getLabelMajor(current), orientation, className);
	          }

	          line = this._repaintMajorLine(x, width, orientation, className);
	        } else {
	          // minor line
	          if (showMinorGrid) {
	            line = this._repaintMinorLine(x, width, orientation, className);
	          } else {
	            if (line) {
	              // adjust the width of the previous grid
	              line.style.width = "".concat(_parseInt(line.style.width) + width, "px");
	            }
	          }
	        }
	      }

	      if (count === MAX && !warnedForOverflow) {
	        console.warn("Something is wrong with the Timeline scale. Limited drawing of grid lines to ".concat(MAX, " lines."));
	        warnedForOverflow = true;
	      } // create a major label on the left when needed


	      if (this.options.showMajorLabels) {
	        var leftTime = this.body.util.toTime(0); // upper bound estimation

	        var leftText = step.getLabelMajor(leftTime);
	        var widthText = leftText.length * (this.props.majorCharWidth || 10) + 10;

	        if (xFirstMajorLabel == undefined || widthText < xFirstMajorLabel) {
	          this._repaintMajorText(0, leftText, orientation, className);
	        }
	      } // Cleanup leftover DOM elements from the redundant list


	      _forEachInstanceProperty(availableUtils).call(availableUtils, this.dom.redundant, function (arr) {
	        while (arr.length) {
	          var elem = arr.pop();

	          if (elem && elem.parentNode) {
	            elem.parentNode.removeChild(elem);
	          }
	        }
	      });
	    }
	    /**
	     * Create a minor label for the axis at position x
	     * @param {number} x
	     * @param {string} text
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the HTML element of the created label
	     * @private
	     */

	  }, {
	    key: "_repaintMinorText",
	    value: function _repaintMinorText(x, text, orientation, className) {
	      // reuse redundant label
	      var label = this.dom.redundant.minorTexts.shift();

	      if (!label) {
	        // create new label
	        var content = document.createTextNode('');
	        label = document.createElement('div');
	        label.appendChild(content);
	        this.dom.foreground.appendChild(label);
	      }

	      this.dom.minorTexts.push(label);
	      label.innerHTML = availableUtils.xss(text);
	      var y = orientation == 'top' ? this.props.majorLabelHeight : 0;

	      this._setXY(label, x, y);

	      label.className = "vis-text vis-minor ".concat(className); //label.title = title;  // TODO: this is a heavy operation

	      return label;
	    }
	    /**
	     * Create a Major label for the axis at position x
	     * @param {number} x
	     * @param {string} text
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the HTML element of the created label
	     * @private
	     */

	  }, {
	    key: "_repaintMajorText",
	    value: function _repaintMajorText(x, text, orientation, className) {
	      // reuse redundant label
	      var label = this.dom.redundant.majorTexts.shift();

	      if (!label) {
	        // create label
	        var content = document.createElement('div');
	        label = document.createElement('div');
	        label.appendChild(content);
	        this.dom.foreground.appendChild(label);
	      }

	      label.childNodes[0].innerHTML = availableUtils.xss(text);
	      label.className = "vis-text vis-major ".concat(className); //label.title = title; // TODO: this is a heavy operation

	      var y = orientation == 'top' ? 0 : this.props.minorLabelHeight;

	      this._setXY(label, x, y);

	      this.dom.majorTexts.push(label);
	      return label;
	    }
	    /**
	     * sets xy
	     * @param {string} label
	     * @param {number} x
	     * @param {number} y
	     * @private
	     */

	  }, {
	    key: "_setXY",
	    value: function _setXY(label, x, y) {
	      var _context;

	      // If rtl is true, inverse x.
	      var directionX = this.options.rtl ? x * -1 : x;
	      label.style.transform = _concatInstanceProperty(_context = "translate(".concat(directionX, "px, ")).call(_context, y, "px)");
	    }
	    /**
	     * Create a minor line for the axis at position x
	     * @param {number} left
	     * @param {number} width
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the created line
	     * @private
	     */

	  }, {
	    key: "_repaintMinorLine",
	    value: function _repaintMinorLine(left, width, orientation, className) {
	      var _context2;

	      // reuse redundant line
	      var line = this.dom.redundant.lines.shift();

	      if (!line) {
	        // create vertical line
	        line = document.createElement('div');
	        this.dom.background.appendChild(line);
	      }

	      this.dom.lines.push(line);
	      var props = this.props;
	      line.style.width = "".concat(width, "px");
	      line.style.height = "".concat(props.minorLineHeight, "px");
	      var y = orientation == 'top' ? props.majorLabelHeight : this.body.domProps.top.height;
	      var x = left - props.minorLineWidth / 2;

	      this._setXY(line, x, y);

	      line.className = _concatInstanceProperty(_context2 = "vis-grid ".concat(this.options.rtl ? 'vis-vertical-rtl' : 'vis-vertical', " vis-minor ")).call(_context2, className);
	      return line;
	    }
	    /**
	     * Create a Major line for the axis at position x
	     * @param {number} left
	     * @param {number} width
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the created line
	     * @private
	     */

	  }, {
	    key: "_repaintMajorLine",
	    value: function _repaintMajorLine(left, width, orientation, className) {
	      var _context3;

	      // reuse redundant line
	      var line = this.dom.redundant.lines.shift();

	      if (!line) {
	        // create vertical line
	        line = document.createElement('div');
	        this.dom.background.appendChild(line);
	      }

	      this.dom.lines.push(line);
	      var props = this.props;
	      line.style.width = "".concat(width, "px");
	      line.style.height = "".concat(props.majorLineHeight, "px");
	      var y = orientation == 'top' ? 0 : this.body.domProps.top.height;
	      var x = left - props.majorLineWidth / 2;

	      this._setXY(line, x, y);

	      line.className = _concatInstanceProperty(_context3 = "vis-grid ".concat(this.options.rtl ? 'vis-vertical-rtl' : 'vis-vertical', " vis-major ")).call(_context3, className);
	      return line;
	    }
	    /**
	     * Determine the size of text on the axis (both major and minor axis).
	     * The size is calculated only once and then cached in this.props.
	     * @private
	     */

	  }, {
	    key: "_calculateCharSize",
	    value: function _calculateCharSize() {
	      // Note: We calculate char size with every redraw. Size may change, for
	      // example when any of the timelines parents had display:none for example.
	      // determine the char width and height on the minor axis
	      if (!this.dom.measureCharMinor) {
	        this.dom.measureCharMinor = document.createElement('DIV');
	        this.dom.measureCharMinor.className = 'vis-text vis-minor vis-measure';
	        this.dom.measureCharMinor.style.position = 'absolute';
	        this.dom.measureCharMinor.appendChild(document.createTextNode('0'));
	        this.dom.foreground.appendChild(this.dom.measureCharMinor);
	      }

	      this.props.minorCharHeight = this.dom.measureCharMinor.clientHeight;
	      this.props.minorCharWidth = this.dom.measureCharMinor.clientWidth; // determine the char width and height on the major axis

	      if (!this.dom.measureCharMajor) {
	        this.dom.measureCharMajor = document.createElement('DIV');
	        this.dom.measureCharMajor.className = 'vis-text vis-major vis-measure';
	        this.dom.measureCharMajor.style.position = 'absolute';
	        this.dom.measureCharMajor.appendChild(document.createTextNode('0'));
	        this.dom.foreground.appendChild(this.dom.measureCharMajor);
	      }

	      this.props.majorCharHeight = this.dom.measureCharMajor.clientHeight;
	      this.props.majorCharWidth = this.dom.measureCharMajor.clientWidth;
	    }
	  }]);

	  return TimeAxis;
	}(Component);

	var warnedForOverflow = false;

	/**
	 * Created by Alex on 11/6/2014.
	 */
	function keycharm(options) {
	  var preventDefault = options && options.preventDefault || false;
	  var container = options && options.container || window;
	  var _exportFunctions = {};
	  var _bound = {
	    keydown: {},
	    keyup: {}
	  };
	  var _keys = {};
	  var i; // a - z

	  for (i = 97; i <= 122; i++) {
	    _keys[String.fromCharCode(i)] = {
	      code: 65 + (i - 97),
	      shift: false
	    };
	  } // A - Z


	  for (i = 65; i <= 90; i++) {
	    _keys[String.fromCharCode(i)] = {
	      code: i,
	      shift: true
	    };
	  } // 0 - 9


	  for (i = 0; i <= 9; i++) {
	    _keys['' + i] = {
	      code: 48 + i,
	      shift: false
	    };
	  } // F1 - F12


	  for (i = 1; i <= 12; i++) {
	    _keys['F' + i] = {
	      code: 111 + i,
	      shift: false
	    };
	  } // num0 - num9


	  for (i = 0; i <= 9; i++) {
	    _keys['num' + i] = {
	      code: 96 + i,
	      shift: false
	    };
	  } // numpad misc


	  _keys['num*'] = {
	    code: 106,
	    shift: false
	  };
	  _keys['num+'] = {
	    code: 107,
	    shift: false
	  };
	  _keys['num-'] = {
	    code: 109,
	    shift: false
	  };
	  _keys['num/'] = {
	    code: 111,
	    shift: false
	  };
	  _keys['num.'] = {
	    code: 110,
	    shift: false
	  }; // arrows

	  _keys['left'] = {
	    code: 37,
	    shift: false
	  };
	  _keys['up'] = {
	    code: 38,
	    shift: false
	  };
	  _keys['right'] = {
	    code: 39,
	    shift: false
	  };
	  _keys['down'] = {
	    code: 40,
	    shift: false
	  }; // extra keys

	  _keys['space'] = {
	    code: 32,
	    shift: false
	  };
	  _keys['enter'] = {
	    code: 13,
	    shift: false
	  };
	  _keys['shift'] = {
	    code: 16,
	    shift: undefined
	  };
	  _keys['esc'] = {
	    code: 27,
	    shift: false
	  };
	  _keys['backspace'] = {
	    code: 8,
	    shift: false
	  };
	  _keys['tab'] = {
	    code: 9,
	    shift: false
	  };
	  _keys['ctrl'] = {
	    code: 17,
	    shift: false
	  };
	  _keys['alt'] = {
	    code: 18,
	    shift: false
	  };
	  _keys['delete'] = {
	    code: 46,
	    shift: false
	  };
	  _keys['pageup'] = {
	    code: 33,
	    shift: false
	  };
	  _keys['pagedown'] = {
	    code: 34,
	    shift: false
	  }; // symbols

	  _keys['='] = {
	    code: 187,
	    shift: false
	  };
	  _keys['-'] = {
	    code: 189,
	    shift: false
	  };
	  _keys[']'] = {
	    code: 221,
	    shift: false
	  };
	  _keys['['] = {
	    code: 219,
	    shift: false
	  };

	  var down = function (event) {
	    handleEvent(event, 'keydown');
	  };

	  var up = function (event) {
	    handleEvent(event, 'keyup');
	  }; // handle the actualy bound key with the event


	  var handleEvent = function (event, type) {
	    if (_bound[type][event.keyCode] !== undefined) {
	      var bound = _bound[type][event.keyCode];

	      for (var i = 0; i < bound.length; i++) {
	        if (bound[i].shift === undefined) {
	          bound[i].fn(event);
	        } else if (bound[i].shift == true && event.shiftKey == true) {
	          bound[i].fn(event);
	        } else if (bound[i].shift == false && event.shiftKey == false) {
	          bound[i].fn(event);
	        }
	      }

	      if (preventDefault == true) {
	        event.preventDefault();
	      }
	    }
	  }; // bind a key to a callback


	  _exportFunctions.bind = function (key, callback, type) {
	    if (type === undefined) {
	      type = 'keydown';
	    }

	    if (_keys[key] === undefined) {
	      throw new Error("unsupported key: " + key);
	    }

	    if (_bound[type][_keys[key].code] === undefined) {
	      _bound[type][_keys[key].code] = [];
	    }

	    _bound[type][_keys[key].code].push({
	      fn: callback,
	      shift: _keys[key].shift
	    });
	  }; // bind all keys to a call back (demo purposes)


	  _exportFunctions.bindAll = function (callback, type) {
	    if (type === undefined) {
	      type = 'keydown';
	    }

	    for (var key in _keys) {
	      if (_keys.hasOwnProperty(key)) {
	        _exportFunctions.bind(key, callback, type);
	      }
	    }
	  }; // get the key label from an event


	  _exportFunctions.getKey = function (event) {
	    for (var key in _keys) {
	      if (_keys.hasOwnProperty(key)) {
	        if (event.shiftKey == true && _keys[key].shift == true && event.keyCode == _keys[key].code) {
	          return key;
	        } else if (event.shiftKey == false && _keys[key].shift == false && event.keyCode == _keys[key].code) {
	          return key;
	        } else if (event.keyCode == _keys[key].code && key == 'shift') {
	          return key;
	        }
	      }
	    }

	    return "unknown key, currently not supported";
	  }; // unbind either a specific callback from a key or all of them (by leaving callback undefined)


	  _exportFunctions.unbind = function (key, callback, type) {
	    if (type === undefined) {
	      type = 'keydown';
	    }

	    if (_keys[key] === undefined) {
	      throw new Error("unsupported key: " + key);
	    }

	    if (callback !== undefined) {
	      var newBindings = [];
	      var bound = _bound[type][_keys[key].code];

	      if (bound !== undefined) {
	        for (var i = 0; i < bound.length; i++) {
	          if (!(bound[i].fn == callback && bound[i].shift == _keys[key].shift)) {
	            newBindings.push(_bound[type][_keys[key].code][i]);
	          }
	        }
	      }

	      _bound[type][_keys[key].code] = newBindings;
	    } else {
	      _bound[type][_keys[key].code] = [];
	    }
	  }; // reset all bound variables.


	  _exportFunctions.reset = function () {
	    _bound = {
	      keydown: {},
	      keyup: {}
	    };
	  }; // unbind all listeners and reset all variables.


	  _exportFunctions.destroy = function () {
	    _bound = {
	      keydown: {},
	      keyup: {}
	    };
	    container.removeEventListener('keydown', down, true);
	    container.removeEventListener('keyup', up, true);
	  }; // create listeners.


	  container.addEventListener('keydown', down, true);
	  container.addEventListener('keyup', up, true); // return the public functions.

	  return _exportFunctions;
	}

	var css_248z$d = ".vis .overlay {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n\n  /* Must be displayed above for example selected Timeline items */\n  z-index: 10;\n}\n\n.vis-active {\n  box-shadow: 0 0 10px #86d5f8;\n}\n";
	styleInject(css_248z$d);

	/**
	 * Turn an element into an clickToUse element.
	 * When not active, the element has a transparent overlay. When the overlay is
	 * clicked, the mode is changed to active.
	 * When active, the element is displayed with a blue border around it, and
	 * the interactive contents of the element can be used. When clicked outside
	 * the element, the elements mode is changed to inactive.
	 * @param {Element} container
	 * @constructor Activator
	 */

	function Activator(container) {
	  var _context, _context2;

	  this.active = false;
	  this.dom = {
	    container: container
	  };
	  this.dom.overlay = document.createElement('div');
	  this.dom.overlay.className = 'vis-overlay';
	  this.dom.container.appendChild(this.dom.overlay);
	  this.hammer = Hammer(this.dom.overlay);
	  this.hammer.on('tap', _bindInstanceProperty$1(_context = this._onTapOverlay).call(_context, this)); // block all touch events (except tap)

	  var me = this;
	  var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend'];

	  _forEachInstanceProperty(events).call(events, function (event) {
	    me.hammer.on(event, function (event) {
	      event.stopPropagation();
	    });
	  }); // attach a click event to the window, in order to deactivate when clicking outside the timeline


	  if (document && document.body) {
	    this.onClick = function (event) {
	      if (!_hasParent(event.target, container)) {
	        me.deactivate();
	      }
	    };

	    document.body.addEventListener('click', this.onClick);
	  }

	  if (this.keycharm !== undefined) {
	    this.keycharm.destroy();
	  }

	  this.keycharm = keycharm(); // keycharm listener only bounded when active)

	  this.escListener = _bindInstanceProperty$1(_context2 = this.deactivate).call(_context2, this);
	} // turn into an event emitter


	Emitter(Activator.prototype); // The currently active activator

	Activator.current = null;
	/**
	 * Destroy the activator. Cleans up all created DOM and event listeners
	 */

	Activator.prototype.destroy = function () {
	  this.deactivate(); // remove dom

	  this.dom.overlay.parentNode.removeChild(this.dom.overlay); // remove global event listener

	  if (this.onClick) {
	    document.body.removeEventListener('click', this.onClick);
	  } // remove keycharm


	  if (this.keycharm !== undefined) {
	    this.keycharm.destroy();
	  }

	  this.keycharm = null; // cleanup hammer instances

	  this.hammer.destroy();
	  this.hammer = null; // FIXME: cleaning up hammer instances doesn't work (Timeline not removed from memory)
	};
	/**
	 * Activate the element
	 * Overlay is hidden, element is decorated with a blue shadow border
	 */


	Activator.prototype.activate = function () {
	  var _context3;

	  // we allow only one active activator at a time
	  if (Activator.current) {
	    Activator.current.deactivate();
	  }

	  Activator.current = this;
	  this.active = true;
	  this.dom.overlay.style.display = 'none';
	  availableUtils.addClassName(this.dom.container, 'vis-active');
	  this.emit('change');
	  this.emit('activate'); // ugly hack: bind ESC after emitting the events, as the Network rebinds all
	  // keyboard events on a 'change' event

	  _bindInstanceProperty$1(_context3 = this.keycharm).call(_context3, 'esc', this.escListener);
	};
	/**
	 * Deactivate the element
	 * Overlay is displayed on top of the element
	 */


	Activator.prototype.deactivate = function () {
	  if (Activator.current === this) {
	    Activator.current = null;
	  }

	  this.active = false;
	  this.dom.overlay.style.display = '';
	  availableUtils.removeClassName(this.dom.container, 'vis-active');
	  this.keycharm.unbind('esc', this.escListener);
	  this.emit('change');
	  this.emit('deactivate');
	};
	/**
	 * Handle a tap event: activate the container
	 * @param {Event}  event   The event
	 * @private
	 */


	Activator.prototype._onTapOverlay = function (event) {
	  // activate the container
	  this.activate();
	  event.stopPropagation();
	};
	/**
	 * Test whether the element has the requested parent element somewhere in
	 * its chain of parent nodes.
	 * @param {HTMLElement} element
	 * @param {HTMLElement} parent
	 * @returns {boolean} Returns true when the parent is found somewhere in the
	 *                    chain of parent nodes.
	 * @private
	 */


	function _hasParent(element, parent) {
	  while (element) {
	    if (element === parent) {
	      return true;
	    }

	    element = element.parentNode;
	  }

	  return false;
	}

	/*
	 * IMPORTANT: Locales for Moment has to be imported in the legacy and standalone
	 * entry points. For the peer build it's users responsibility to do so.
	 */
	// English
	var en = {
	  current: 'current',
	  time: 'time',
	  deleteSelected: 'Delete selected'
	};
	var en_EN = en;
	var en_US = en; // Italiano

	var it = {
	  current: 'attuale',
	  time: 'tempo',
	  deleteSelected: 'Cancella la selezione'
	};
	var it_IT = it;
	var it_CH = it; // Dutch

	var nl = {
	  current: 'huidige',
	  time: 'tijd',
	  deleteSelected: 'Selectie verwijderen'
	};
	var nl_NL = nl;
	var nl_BE = nl; // German

	var de = {
	  current: 'Aktuelle',
	  time: 'Zeit',
	  deleteSelected: "L\xF6sche Auswahl"
	};
	var de_DE = de; // French

	var fr = {
	  current: 'actuel',
	  time: 'heure',
	  deleteSelected: 'Effacer la selection'
	};
	var fr_FR = fr;
	var fr_CA = fr;
	var fr_BE = fr; // Espanol

	var es = {
	  current: 'corriente',
	  time: 'hora',
	  deleteSelected: "Eliminar selecci\xF3n"
	};
	var es_ES = es; // Ukrainian

	var uk = {
	  current: 'поточний',
	  time: 'час',
	  deleteSelected: 'Видалити обране'
	};
	var uk_UA = uk; // Russian

	var ru = {
	  current: 'текущее',
	  time: 'время',
	  deleteSelected: 'Удалить выбранное'
	};
	var ru_RU = ru; // Polish

	var pl = {
	  current: 'aktualny',
	  time: 'czas',
	  deleteSelected: 'Usuń wybrane'
	};
	var pl_PL = pl; // Portuguese

	var pt = {
	  current: 'atual',
	  time: 'data',
	  deleteSelected: 'Apagar selecionado'
	};
	var pt_BR = pt;
	var pt_PT = pt; // Japanese

	var ja = {
	  current: '現在',
	  time: '時刻',
	  deleteSelected: '選択されたものを削除'
	};
	var ja_JP = ja; // Swedish

	var sv = {
	  current: 'nuvarande',
	  time: 'tid',
	  deleteSelected: 'Radera valda'
	};
	var sv_SE = sv; // Norwegian

	var nb = {
	  current: 'nåværende',
	  time: 'tid',
	  deleteSelected: 'Slett valgte'
	};
	var nb_NO = nb;
	var nn = nb;
	var nn_NO = nb; // Lithuanian

	var lt = {
	  current: 'einamas',
	  time: 'laikas',
	  deleteSelected: 'Pašalinti pasirinktą'
	};
	var lt_LT = lt;
	var locales = {
	  en: en,
	  en_EN: en_EN,
	  en_US: en_US,
	  it: it,
	  it_IT: it_IT,
	  it_CH: it_CH,
	  nl: nl,
	  nl_NL: nl_NL,
	  nl_BE: nl_BE,
	  de: de,
	  de_DE: de_DE,
	  fr: fr,
	  fr_FR: fr_FR,
	  fr_CA: fr_CA,
	  fr_BE: fr_BE,
	  es: es,
	  es_ES: es_ES,
	  uk: uk,
	  uk_UA: uk_UA,
	  ru: ru,
	  ru_RU: ru_RU,
	  pl: pl,
	  pl_PL: pl_PL,
	  pt: pt,
	  pt_BR: pt_BR,
	  pt_PT: pt_PT,
	  ja: ja,
	  ja_JP: ja_JP,
	  lt: lt,
	  lt_LT: lt_LT,
	  sv: sv,
	  sv_SE: sv_SE,
	  nb: nb,
	  nn: nn,
	  nb_NO: nb_NO,
	  nn_NO: nn_NO
	};

	var css_248z$c = ".vis-custom-time {\n  background-color: #6E94FF;\n  width: 2px;\n  cursor: move;\n  z-index: 1;\n}\n\n.vis-custom-time > .vis-custom-time-marker {\n  background-color: inherit;\n  color: white;\n  font-size: 12px;\n  white-space: nowrap;\n  padding: 3px 5px;\n  top: 0px;\n  cursor: initial;\n  z-index: inherit;\n}";
	styleInject(css_248z$c);

	function _createSuper$a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$a(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$a() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/** A custom time bar */

	var CustomTime = /*#__PURE__*/function (_Component) {
	  _inherits(CustomTime, _Component);

	  var _super = _createSuper$a(CustomTime);

	  /**
	  * @param {{range: Range, dom: Object}} body
	  * @param {Object} [options]        Available parameters:
	  *                                  {number | string} id
	  *                                  {string} locales
	  *                                  {string} locale
	  * @constructor CustomTime
	  * @extends Component
	  */
	  function CustomTime(body, options) {
	    var _context;

	    var _this;

	    _classCallCheck(this, CustomTime);

	    _this = _super.call(this);
	    _this.body = body; // default options

	    _this.defaultOptions = {
	      moment: moment$2,
	      locales: locales,
	      locale: 'en',
	      id: undefined,
	      title: undefined
	    };
	    _this.options = availableUtils.extend({}, _this.defaultOptions);

	    _this.setOptions(options);

	    _this.options.locales = availableUtils.extend({}, locales, _this.options.locales);
	    var defaultLocales = _this.defaultOptions.locales[_this.defaultOptions.locale];

	    _forEachInstanceProperty(_context = _Object$keys(_this.options.locales)).call(_context, function (locale) {
	      _this.options.locales[locale] = availableUtils.extend({}, defaultLocales, _this.options.locales[locale]);
	    });

	    if (options && options.time != null) {
	      _this.customTime = options.time;
	    } else {
	      _this.customTime = new Date();
	    }

	    _this.eventParams = {}; // stores state parameters while dragging the bar
	    // create the DOM

	    _this._create();

	    return _this;
	  }
	  /**
	   * Set options for the component. Options will be merged in current options.
	   * @param {Object} options  Available parameters:
	   *                                  {number | string} id
	   *                                  {string} locales
	   *                                  {string} locale
	   */


	  _createClass(CustomTime, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        // copy all options that we know
	        availableUtils.selectiveExtend(['moment', 'locale', 'locales', 'id', 'title', 'rtl', 'snap'], this.options, options);
	      }
	    }
	    /**
	     * Create the DOM for the custom time
	     * @private
	     */

	  }, {
	    key: "_create",
	    value: function _create() {
	      var _context2, _context3, _context4;

	      var bar = document.createElement('div');
	      bar['custom-time'] = this;
	      bar.className = "vis-custom-time ".concat(this.options.id || '');
	      bar.style.position = 'absolute';
	      bar.style.top = '0px';
	      bar.style.height = '100%';
	      this.bar = bar;
	      var drag = document.createElement('div');
	      drag.style.position = 'relative';
	      drag.style.top = '0px';

	      if (this.options.rtl) {
	        drag.style.right = '-10px';
	      } else {
	        drag.style.left = '-10px';
	      }

	      drag.style.height = '100%';
	      drag.style.width = '20px';
	      /**
	       *
	       * @param {WheelEvent} e
	       */

	      function onMouseWheel(e) {
	        this.body.range._onMouseWheel(e);
	      }

	      if (drag.addEventListener) {
	        // IE9, Chrome, Safari, Opera
	        drag.addEventListener("mousewheel", _bindInstanceProperty$1(onMouseWheel).call(onMouseWheel, this), false); // Firefox

	        drag.addEventListener("DOMMouseScroll", _bindInstanceProperty$1(onMouseWheel).call(onMouseWheel, this), false);
	      } else {
	        // IE 6/7/8
	        drag.attachEvent("onmousewheel", _bindInstanceProperty$1(onMouseWheel).call(onMouseWheel, this));
	      }

	      bar.appendChild(drag); // attach event listeners

	      this.hammer = new Hammer(drag);
	      this.hammer.on('panstart', _bindInstanceProperty$1(_context2 = this._onDragStart).call(_context2, this));
	      this.hammer.on('panmove', _bindInstanceProperty$1(_context3 = this._onDrag).call(_context3, this));
	      this.hammer.on('panend', _bindInstanceProperty$1(_context4 = this._onDragEnd).call(_context4, this));
	      this.hammer.get('pan').set({
	        threshold: 5,
	        direction: Hammer.DIRECTION_ALL
	      }); // delay addition on item click for trackpads...

	      this.hammer.get('press').set({
	        time: 10000
	      });
	    }
	    /**
	     * Destroy the CustomTime bar
	     */

	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.hide();
	      this.hammer.destroy();
	      this.hammer = null;
	      this.body = null;
	    }
	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */

	  }, {
	    key: "redraw",
	    value: function redraw() {
	      var parent = this.body.dom.backgroundVertical;

	      if (this.bar.parentNode != parent) {
	        // attach to the dom
	        if (this.bar.parentNode) {
	          this.bar.parentNode.removeChild(this.bar);
	        }

	        parent.appendChild(this.bar);
	      }

	      var x = this.body.util.toScreen(this.customTime);
	      var locale = this.options.locales[this.options.locale];

	      if (!locale) {
	        if (!this.warned) {
	          console.warn("WARNING: options.locales['".concat(this.options.locale, "'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization"));
	          this.warned = true;
	        }

	        locale = this.options.locales['en']; // fall back on english when not available
	      }

	      var title = this.options.title; // To hide the title completely use empty string ''.

	      if (title === undefined) {
	        var _context5;

	        title = _concatInstanceProperty(_context5 = "".concat(locale.time, ": ")).call(_context5, this.options.moment(this.customTime).format('dddd, MMMM Do YYYY, H:mm:ss'));
	        title = title.charAt(0).toUpperCase() + title.substring(1);
	      } else if (typeof title === "function") {
	        title = title.call(this, this.customTime);
	      }

	      this.options.rtl ? this.bar.style.right = "".concat(x, "px") : this.bar.style.left = "".concat(x, "px");
	      this.bar.title = title;
	      return false;
	    }
	    /**
	     * Remove the CustomTime from the DOM
	     */

	  }, {
	    key: "hide",
	    value: function hide() {
	      // remove the line from the DOM
	      if (this.bar.parentNode) {
	        this.bar.parentNode.removeChild(this.bar);
	      }
	    }
	    /**
	     * Set custom time.
	     * @param {Date | number | string} time
	     */

	  }, {
	    key: "setCustomTime",
	    value: function setCustomTime(time) {
	      this.customTime = availableUtils.convert(time, 'Date');
	      this.redraw();
	    }
	    /**
	     * Retrieve the current custom time.
	     * @return {Date} customTime
	     */

	  }, {
	    key: "getCustomTime",
	    value: function getCustomTime() {
	      return new Date(this.customTime.valueOf());
	    }
	    /**
	     * Set custom marker.
	     * @param {string} [title] Title of the custom marker
	     * @param {boolean} [editable] Make the custom marker editable.
	     */

	  }, {
	    key: "setCustomMarker",
	    value: function setCustomMarker(title, editable) {
	      var marker = document.createElement('div');
	      marker.className = "vis-custom-time-marker";
	      marker.innerHTML = availableUtils.xss(title);
	      marker.style.position = 'absolute';

	      if (editable) {
	        var _context6, _context7;

	        marker.setAttribute('contenteditable', 'true');
	        marker.addEventListener('pointerdown', function () {
	          marker.focus();
	        });
	        marker.addEventListener('input', _bindInstanceProperty$1(_context6 = this._onMarkerChange).call(_context6, this)); // The editable div element has no change event, so here emulates the change event.

	        marker.title = title;
	        marker.addEventListener('blur', _bindInstanceProperty$1(_context7 = function _context7(event) {
	          if (this.title != event.target.innerHTML) {
	            this._onMarkerChanged(event);

	            this.title = event.target.innerHTML;
	          }
	        }).call(_context7, this));
	      }

	      this.bar.appendChild(marker);
	    }
	    /**
	      * Set custom title.
	      * @param {Date | number | string} title
	      */

	  }, {
	    key: "setCustomTitle",
	    value: function setCustomTitle(title) {
	      this.options.title = title;
	    }
	    /**
	     * Start moving horizontally
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onDragStart",
	    value: function _onDragStart(event) {
	      this.eventParams.dragging = true;
	      this.eventParams.customTime = this.customTime;
	      event.stopPropagation();
	    }
	    /**
	     * Perform moving operating.
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onDrag",
	    value: function _onDrag(event) {
	      if (!this.eventParams.dragging) return;
	      var deltaX = this.options.rtl ? -1 * event.deltaX : event.deltaX;
	      var x = this.body.util.toScreen(this.eventParams.customTime) + deltaX;
	      var time = this.body.util.toTime(x);
	      var scale = this.body.util.getScale();
	      var step = this.body.util.getStep();
	      var snap = this.options.snap;
	      var snappedTime = snap ? snap(time, scale, step) : time;
	      this.setCustomTime(snappedTime); // fire a timechange event

	      this.body.emitter.emit('timechange', {
	        id: this.options.id,
	        time: new Date(this.customTime.valueOf()),
	        event: event
	      });
	      event.stopPropagation();
	    }
	    /**
	     * Stop moving operating.
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onDragEnd",
	    value: function _onDragEnd(event) {
	      if (!this.eventParams.dragging) return; // fire a timechanged event

	      this.body.emitter.emit('timechanged', {
	        id: this.options.id,
	        time: new Date(this.customTime.valueOf()),
	        event: event
	      });
	      event.stopPropagation();
	    }
	    /**
	     * Perform input operating.
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onMarkerChange",
	    value: function _onMarkerChange(event) {
	      this.body.emitter.emit('markerchange', {
	        id: this.options.id,
	        title: event.target.innerHTML,
	        event: event
	      });
	      event.stopPropagation();
	    }
	    /**
	     * Perform change operating.
	     * @param {Event} event
	     * @private
	     */

	  }, {
	    key: "_onMarkerChanged",
	    value: function _onMarkerChanged(event) {
	      this.body.emitter.emit('markerchanged', {
	        id: this.options.id,
	        title: event.target.innerHTML,
	        event: event
	      });
	      event.stopPropagation();
	    }
	    /**
	     * Find a custom time from an event target:
	     * searches for the attribute 'custom-time' in the event target's element tree
	     * @param {Event} event
	     * @return {CustomTime | null} customTime
	     */

	  }], [{
	    key: "customTimeFromTarget",
	    value: function customTimeFromTarget(event) {
	      var target = event.target;

	      while (target) {
	        if (target.hasOwnProperty('custom-time')) {
	          return target['custom-time'];
	        }

	        target = target.parentNode;
	      }

	      return null;
	    }
	  }]);

	  return CustomTime;
	}(Component);

	var css_248z$b = ".vis-timeline {\n  /*\n  -webkit-transition: height .4s ease-in-out;\n  transition:         height .4s ease-in-out;\n  */\n}\n\n.vis-panel {\n  /*\n  -webkit-transition: height .4s ease-in-out, top .4s ease-in-out;\n  transition:         height .4s ease-in-out, top .4s ease-in-out;\n  */\n}\n\n.vis-axis {\n  /*\n  -webkit-transition: top .4s ease-in-out;\n  transition:         top .4s ease-in-out;\n  */\n}\n\n/* TODO: get animation working nicely\n\n.vis-item {\n  -webkit-transition: top .4s ease-in-out;\n  transition:         top .4s ease-in-out;\n}\n\n.vis-item.line {\n  -webkit-transition: height .4s ease-in-out, top .4s ease-in-out;\n  transition:         height .4s ease-in-out, top .4s ease-in-out;\n}\n/**/";
	styleInject(css_248z$b);

	var css_248z$a = ".vis-current-time {\n  background-color: #FF7F6E;\n  width: 2px;\n  z-index: 1;\n  pointer-events: none;\n}\n\n.vis-rolling-mode-btn {\n  height: 40px;\n  width: 40px;\n  position: absolute;\n  top: 7px;\n  right: 20px;\n  border-radius: 50%;\n  font-size: 28px;\n  cursor: pointer;\n  opacity: 0.8;\n  color: white;\n  font-weight: bold;\n  text-align: center;\n  background: #3876c2;\n}\n.vis-rolling-mode-btn:before {\n  content: \"\\26F6\";\n}\n\n.vis-rolling-mode-btn:hover {\n  opacity: 1;\n}";
	styleInject(css_248z$a);

	var css_248z$9 = ".vis-panel {\n  position: absolute;\n\n  padding: 0;\n  margin: 0;\n\n  box-sizing: border-box;\n}\n\n.vis-panel.vis-center,\n.vis-panel.vis-left,\n.vis-panel.vis-right,\n.vis-panel.vis-top,\n.vis-panel.vis-bottom {\n  border: 1px #bfbfbf;\n}\n\n.vis-panel.vis-center,\n.vis-panel.vis-left,\n.vis-panel.vis-right {\n  border-top-style: solid;\n  border-bottom-style: solid;\n  overflow: hidden;\n}\n\n.vis-left.vis-panel.vis-vertical-scroll, .vis-right.vis-panel.vis-vertical-scroll {\n  height: 100%;\n  overflow-x: hidden;\n  overflow-y: scroll;\n} \n\n.vis-left.vis-panel.vis-vertical-scroll {\n  direction: rtl;\n}\n\n.vis-left.vis-panel.vis-vertical-scroll .vis-content {\n  direction: ltr;\n}\n\n.vis-right.vis-panel.vis-vertical-scroll {\n  direction: ltr;\n}\n\n.vis-right.vis-panel.vis-vertical-scroll .vis-content {\n  direction: rtl;\n}\n\n.vis-panel.vis-center,\n.vis-panel.vis-top,\n.vis-panel.vis-bottom {\n  border-left-style: solid;\n  border-right-style: solid;\n}\n\n.vis-background {\n  overflow: hidden;\n}\n\n.vis-panel > .vis-content {\n  position: relative;\n}\n\n.vis-panel .vis-shadow {\n  position: absolute;\n  width: 100%;\n  height: 1px;\n  box-shadow: 0 0 10px rgba(0,0,0,0.8);\n  /* TODO: find a nice way to ensure vis-shadows are drawn on top of items\n  z-index: 1;\n  */\n}\n\n.vis-panel .vis-shadow.vis-top {\n  top: -1px;\n  left: 0;\n}\n\n.vis-panel .vis-shadow.vis-bottom {\n  bottom: -1px;\n  left: 0;\n}";
	styleInject(css_248z$9);

	var css_248z$8 = ".vis-graph-group0 {\n    fill:#4f81bd;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #4f81bd;\n}\n\n.vis-graph-group1 {\n    fill:#f79646;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #f79646;\n}\n\n.vis-graph-group2 {\n    fill: #8c51cf;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #8c51cf;\n}\n\n.vis-graph-group3 {\n    fill: #75c841;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #75c841;\n}\n\n.vis-graph-group4 {\n    fill: #ff0100;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #ff0100;\n}\n\n.vis-graph-group5 {\n    fill: #37d8e6;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #37d8e6;\n}\n\n.vis-graph-group6 {\n    fill: #042662;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #042662;\n}\n\n.vis-graph-group7 {\n    fill:#00ff26;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #00ff26;\n}\n\n.vis-graph-group8 {\n    fill:#ff00ff;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #ff00ff;\n}\n\n.vis-graph-group9 {\n    fill: #8f3938;\n    fill-opacity:0;\n    stroke-width:2px;\n    stroke: #8f3938;\n}\n\n.vis-timeline .vis-fill {\n    fill-opacity:0.1;\n    stroke: none;\n}\n\n\n.vis-timeline .vis-bar {\n    fill-opacity:0.5;\n    stroke-width:1px;\n}\n\n.vis-timeline .vis-point {\n    stroke-width:2px;\n    fill-opacity:1.0;\n}\n\n\n.vis-timeline .vis-legend-background {\n    stroke-width:1px;\n    fill-opacity:0.9;\n    fill: #ffffff;\n    stroke: #c2c2c2;\n}\n\n\n.vis-timeline .vis-outline {\n    stroke-width:1px;\n    fill-opacity:1;\n    fill: #ffffff;\n    stroke: #e5e5e5;\n}\n\n.vis-timeline .vis-icon-fill {\n    fill-opacity:0.3;\n    stroke: none;\n}\n";
	styleInject(css_248z$8);

	var css_248z$7 = "\n.vis-timeline {\n  position: relative;\n  border: 1px solid #bfbfbf;\n  overflow: hidden;\n  padding: 0;\n  margin: 0;\n  box-sizing: border-box;\n}\n\n.vis-loading-screen {\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  top: 0;\n  left: 0;\n}";
	styleInject(css_248z$7);

	var css_248z$6 = "/* override some bootstrap styles screwing up the timelines css */\n\n.vis [class*=\"span\"] {\n  min-height: 0;\n  width: auto;\n}\n";
	styleInject(css_248z$6);

	/**
	 * Create a timeline visualization
	 * @constructor Core
	 */

	var Core = /*#__PURE__*/function () {
	  function Core() {
	    _classCallCheck(this, Core);
	  }

	  _createClass(Core, [{
	    key: "_create",
	    value:
	    /**
	     * Create the main DOM for the Core: a root panel containing left, right,
	     * top, bottom, content, and background panel.
	     * @param {Element} container  The container element where the Core will
	     *                             be attached.
	     * @protected
	     */
	    function _create(container) {
	      var _this = this,
	          _context,
	          _context2,
	          _context3;

	      this.dom = {};
	      this.dom.container = container;
	      this.dom.container.style.position = 'relative';
	      this.dom.root = document.createElement('div');
	      this.dom.background = document.createElement('div');
	      this.dom.backgroundVertical = document.createElement('div');
	      this.dom.backgroundHorizontal = document.createElement('div');
	      this.dom.centerContainer = document.createElement('div');
	      this.dom.leftContainer = document.createElement('div');
	      this.dom.rightContainer = document.createElement('div');
	      this.dom.center = document.createElement('div');
	      this.dom.left = document.createElement('div');
	      this.dom.right = document.createElement('div');
	      this.dom.top = document.createElement('div');
	      this.dom.bottom = document.createElement('div');
	      this.dom.shadowTop = document.createElement('div');
	      this.dom.shadowBottom = document.createElement('div');
	      this.dom.shadowTopLeft = document.createElement('div');
	      this.dom.shadowBottomLeft = document.createElement('div');
	      this.dom.shadowTopRight = document.createElement('div');
	      this.dom.shadowBottomRight = document.createElement('div');
	      this.dom.rollingModeBtn = document.createElement('div');
	      this.dom.loadingScreen = document.createElement('div');
	      this.dom.root.className = 'vis-timeline';
	      this.dom.background.className = 'vis-panel vis-background';
	      this.dom.backgroundVertical.className = 'vis-panel vis-background vis-vertical';
	      this.dom.backgroundHorizontal.className = 'vis-panel vis-background vis-horizontal';
	      this.dom.centerContainer.className = 'vis-panel vis-center';
	      this.dom.leftContainer.className = 'vis-panel vis-left';
	      this.dom.rightContainer.className = 'vis-panel vis-right';
	      this.dom.top.className = 'vis-panel vis-top';
	      this.dom.bottom.className = 'vis-panel vis-bottom';
	      this.dom.left.className = 'vis-content';
	      this.dom.center.className = 'vis-content';
	      this.dom.right.className = 'vis-content';
	      this.dom.shadowTop.className = 'vis-shadow vis-top';
	      this.dom.shadowBottom.className = 'vis-shadow vis-bottom';
	      this.dom.shadowTopLeft.className = 'vis-shadow vis-top';
	      this.dom.shadowBottomLeft.className = 'vis-shadow vis-bottom';
	      this.dom.shadowTopRight.className = 'vis-shadow vis-top';
	      this.dom.shadowBottomRight.className = 'vis-shadow vis-bottom';
	      this.dom.rollingModeBtn.className = 'vis-rolling-mode-btn';
	      this.dom.loadingScreen.className = 'vis-loading-screen';
	      this.dom.root.appendChild(this.dom.background);
	      this.dom.root.appendChild(this.dom.backgroundVertical);
	      this.dom.root.appendChild(this.dom.backgroundHorizontal);
	      this.dom.root.appendChild(this.dom.centerContainer);
	      this.dom.root.appendChild(this.dom.leftContainer);
	      this.dom.root.appendChild(this.dom.rightContainer);
	      this.dom.root.appendChild(this.dom.top);
	      this.dom.root.appendChild(this.dom.bottom);
	      this.dom.root.appendChild(this.dom.rollingModeBtn);
	      this.dom.centerContainer.appendChild(this.dom.center);
	      this.dom.leftContainer.appendChild(this.dom.left);
	      this.dom.rightContainer.appendChild(this.dom.right);
	      this.dom.centerContainer.appendChild(this.dom.shadowTop);
	      this.dom.centerContainer.appendChild(this.dom.shadowBottom);
	      this.dom.leftContainer.appendChild(this.dom.shadowTopLeft);
	      this.dom.leftContainer.appendChild(this.dom.shadowBottomLeft);
	      this.dom.rightContainer.appendChild(this.dom.shadowTopRight);
	      this.dom.rightContainer.appendChild(this.dom.shadowBottomRight); // size properties of each of the panels

	      this.props = {
	        root: {},
	        background: {},
	        centerContainer: {},
	        leftContainer: {},
	        rightContainer: {},
	        center: {},
	        left: {},
	        right: {},
	        top: {},
	        bottom: {},
	        border: {},
	        scrollTop: 0,
	        scrollTopMin: 0
	      };
	      this.on('rangechange', function () {
	        if (_this.initialDrawDone === true) {
	          _this._redraw();
	        }
	      });
	      this.on('rangechanged', function () {
	        if (!_this.initialRangeChangeDone) {
	          _this.initialRangeChangeDone = true;
	        }
	      });
	      this.on('touch', _bindInstanceProperty$1(_context = this._onTouch).call(_context, this));
	      this.on('panmove', _bindInstanceProperty$1(_context2 = this._onDrag).call(_context2, this));
	      var me = this;
	      this._origRedraw = _bindInstanceProperty$1(_context3 = this._redraw).call(_context3, this);
	      this._redraw = availableUtils.throttle(this._origRedraw);
	      this.on('_change', function (properties) {
	        if (me.itemSet && me.itemSet.initialItemSetDrawn && properties && properties.queue == true) {
	          me._redraw();
	        } else {
	          me._origRedraw();
	        }
	      }); // create event listeners for all interesting events, these events will be
	      // emitted via emitter

	      this.hammer = new Hammer(this.dom.root);
	      var pinchRecognizer = this.hammer.get('pinch').set({
	        enable: true
	      });
	      pinchRecognizer && disablePreventDefaultVertically(pinchRecognizer);
	      this.hammer.get('pan').set({
	        threshold: 5,
	        direction: Hammer.DIRECTION_ALL
	      });
	      this.timelineListeners = {};
	      var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend' // TODO: cleanup
	      //'touch', 'pinch',
	      //'tap', 'doubletap', 'hold',
	      //'dragstart', 'drag', 'dragend',
	      //'mousewheel', 'DOMMouseScroll' // DOMMouseScroll is needed for Firefox
	      ];

	      _forEachInstanceProperty(events).call(events, function (type) {
	        var listener = function listener(event) {
	          if (me.isActive()) {
	            me.emit(type, event);
	          }
	        };

	        me.hammer.on(type, listener);
	        me.timelineListeners[type] = listener;
	      }); // emulate a touch event (emitted before the start of a pan, pinch, tap, or press)


	      onTouch(this.hammer, function (event) {
	        me.emit('touch', event);
	      }); // emulate a release event (emitted after a pan, pinch, tap, or press)

	      onRelease(this.hammer, function (event) {
	        me.emit('release', event);
	      });
	      /**
	       *
	       * @param {WheelEvent} event
	       */

	      function onMouseWheel(event) {
	        // Reasonable default wheel deltas
	        var LINE_HEIGHT = 40;
	        var PAGE_HEIGHT = 800;

	        if (this.isActive()) {
	          this.emit('mousewheel', event);
	        } // deltaX and deltaY normalization from jquery.mousewheel.js


	        var deltaX = 0;
	        var deltaY = 0; // Old school scrollwheel delta

	        if ('detail' in event) {
	          deltaY = event.detail * -1;
	        }

	        if ('wheelDelta' in event) {
	          deltaY = event.wheelDelta;
	        }

	        if ('wheelDeltaY' in event) {
	          deltaY = event.wheelDeltaY;
	        }

	        if ('wheelDeltaX' in event) {
	          deltaX = event.wheelDeltaX * -1;
	        } // Firefox < 17 horizontal scrolling related to DOMMouseScroll event


	        if ('axis' in event && event.axis === event.HORIZONTAL_AXIS) {
	          deltaX = deltaY * -1;
	          deltaY = 0;
	        } // New school wheel delta (wheel event)


	        if ('deltaY' in event) {
	          deltaY = event.deltaY * -1;
	        }

	        if ('deltaX' in event) {
	          deltaX = event.deltaX;
	        } // Normalize deltas


	        if (event.deltaMode) {
	          if (event.deltaMode === 1) {
	            // delta in LINE units
	            deltaX *= LINE_HEIGHT;
	            deltaY *= LINE_HEIGHT;
	          } else {
	            // delta in PAGE units
	            deltaX *= LINE_HEIGHT;
	            deltaY *= PAGE_HEIGHT;
	          }
	        } // Prevent scrolling when zooming (no zoom key, or pressing zoom key)


	        if (this.options.preferZoom) {
	          if (!this.options.zoomKey || event[this.options.zoomKey]) return;
	        } else {
	          if (this.options.zoomKey && event[this.options.zoomKey]) return;
	        } // Don't preventDefault if you can't scroll


	        if (!this.options.verticalScroll && !this.options.horizontalScroll) return;

	        if (this.options.verticalScroll && Math.abs(deltaY) >= Math.abs(deltaX)) {
	          var current = this.props.scrollTop;
	          var adjusted = current + deltaY;

	          if (this.isActive()) {
	            var newScrollTop = this._setScrollTop(adjusted);

	            if (newScrollTop !== current) {
	              this._redraw();

	              this.emit('scroll', event); // Prevent default actions caused by mouse wheel
	              // (else the page and timeline both scroll)

	              event.preventDefault();
	            }
	          }
	        } else if (this.options.horizontalScroll) {
	          var delta = Math.abs(deltaX) >= Math.abs(deltaY) ? deltaX : deltaY; // calculate a single scroll jump relative to the range scale

	          var diff = delta / 120 * (this.range.end - this.range.start) / 20; // calculate new start and end

	          var newStart = this.range.start + diff;
	          var newEnd = this.range.end + diff;
	          var options = {
	            animation: false,
	            byUser: true,
	            event: event
	          };
	          this.range.setRange(newStart, newEnd, options);
	          event.preventDefault();
	        }
	      } // Add modern wheel event listener


	      var wheelType = "onwheel" in document.createElement("div") ? "wheel" : // Modern browsers support "wheel"
	      document.onmousewheel !== undefined ? "mousewheel" : // Webkit and IE support at least "mousewheel"
	      // DOMMouseScroll - Older Firefox versions use "DOMMouseScroll"
	      // onmousewheel - All the use "onmousewheel"
	      this.dom.centerContainer.addEventListener ? "DOMMouseScroll" : "onmousewheel";
	      this.dom.top.addEventListener ? "DOMMouseScroll" : "onmousewheel";
	      this.dom.bottom.addEventListener ? "DOMMouseScroll" : "onmousewheel";
	      this.dom.centerContainer.addEventListener(wheelType, _bindInstanceProperty$1(onMouseWheel).call(onMouseWheel, this), false);
	      this.dom.top.addEventListener(wheelType, _bindInstanceProperty$1(onMouseWheel).call(onMouseWheel, this), false);
	      this.dom.bottom.addEventListener(wheelType, _bindInstanceProperty$1(onMouseWheel).call(onMouseWheel, this), false);
	      /**
	       *
	       * @param {scroll} event
	       */

	      function onMouseScrollSide(event) {
	        if (!me.options.verticalScroll) return;
	        event.preventDefault();

	        if (me.isActive()) {
	          var adjusted = -event.target.scrollTop;

	          me._setScrollTop(adjusted);

	          me._redraw();

	          me.emit('scrollSide', event);
	        }
	      }

	      this.dom.left.parentNode.addEventListener('scroll', _bindInstanceProperty$1(onMouseScrollSide).call(onMouseScrollSide, this));
	      this.dom.right.parentNode.addEventListener('scroll', _bindInstanceProperty$1(onMouseScrollSide).call(onMouseScrollSide, this));
	      var itemAddedToTimeline = false;
	      /**
	       *
	       * @param {dragover} event
	       * @returns {boolean}
	       */

	      function handleDragOver(event) {
	        var _context4;

	        if (event.preventDefault) {
	          me.emit('dragover', me.getEventProperties(event));
	          event.preventDefault(); // Necessary. Allows us to drop.
	        } // make sure your target is a timeline element


	        if (!(_indexOfInstanceProperty(_context4 = event.target.className).call(_context4, "timeline") > -1)) return; // make sure only one item is added every time you're over the timeline

	        if (itemAddedToTimeline) return;
	        event.dataTransfer.dropEffect = 'move';
	        itemAddedToTimeline = true;
	        return false;
	      }
	      /**
	       *
	       * @param {drop} event
	       * @returns {boolean}
	       */


	      function handleDrop(event) {
	        // prevent redirect to blank page - Firefox
	        if (event.preventDefault) {
	          event.preventDefault();
	        }

	        if (event.stopPropagation) {
	          event.stopPropagation();
	        } // return when dropping non-timeline items


	        try {
	          var itemData = JSON.parse(event.dataTransfer.getData("text"));
	          if (!itemData || !itemData.content) return;
	        } catch (err) {
	          return false;
	        }

	        itemAddedToTimeline = false;
	        event.center = {
	          x: event.clientX,
	          y: event.clientY
	        };

	        if (itemData.target !== 'item') {
	          me.itemSet._onAddItem(event);
	        } else {
	          me.itemSet._onDropObjectOnItem(event);
	        }

	        me.emit('drop', me.getEventProperties(event));
	        return false;
	      }

	      this.dom.center.addEventListener('dragover', _bindInstanceProperty$1(handleDragOver).call(handleDragOver, this), false);
	      this.dom.center.addEventListener('drop', _bindInstanceProperty$1(handleDrop).call(handleDrop, this), false);
	      this.customTimes = []; // store state information needed for touch events

	      this.touch = {};
	      this.redrawCount = 0;
	      this.initialDrawDone = false;
	      this.initialRangeChangeDone = false; // attach the root panel to the provided container

	      if (!container) throw new Error('No container provided');
	      container.appendChild(this.dom.root);
	      container.appendChild(this.dom.loadingScreen);
	    }
	    /**
	     * Set options. Options will be passed to all components loaded in the Timeline.
	     * @param {Object} [options]
	     *                           {String} orientation
	     *                              Vertical orientation for the Timeline,
	     *                              can be 'bottom' (default) or 'top'.
	     *                           {string | number} width
	     *                              Width for the timeline, a number in pixels or
	     *                              a css string like '1000px' or '75%'. '100%' by default.
	     *                           {string | number} height
	     *                              Fixed height for the Timeline, a number in pixels or
	     *                              a css string like '400px' or '75%'. If undefined,
	     *                              The Timeline will automatically size such that
	     *                              its contents fit.
	     *                           {string | number} minHeight
	     *                              Minimum height for the Timeline, a number in pixels or
	     *                              a css string like '400px' or '75%'.
	     *                           {string | number} maxHeight
	     *                              Maximum height for the Timeline, a number in pixels or
	     *                              a css string like '400px' or '75%'.
	     *                           {number | Date | string} start
	     *                              Start date for the visible window
	     *                           {number | Date | string} end
	     *                              End date for the visible window
	     */

	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      var _context7;

	      if (options) {
	        // copy the known options
	        var fields = ['width', 'height', 'minHeight', 'maxHeight', 'autoResize', 'start', 'end', 'clickToUse', 'dataAttributes', 'hiddenDates', 'locale', 'locales', 'moment', 'preferZoom', 'rtl', 'zoomKey', 'horizontalScroll', 'verticalScroll', 'longSelectPressTime', 'snap'];
	        availableUtils.selectiveExtend(fields, this.options, options);
	        this.dom.rollingModeBtn.style.visibility = 'hidden';

	        if (this.options.rtl) {
	          this.dom.container.style.direction = "rtl";
	          this.dom.backgroundVertical.className = 'vis-panel vis-background vis-vertical-rtl';
	        }

	        if (this.options.verticalScroll) {
	          if (this.options.rtl) {
	            this.dom.rightContainer.className = 'vis-panel vis-right vis-vertical-scroll';
	          } else {
	            this.dom.leftContainer.className = 'vis-panel vis-left vis-vertical-scroll';
	          }
	        }

	        if (_typeof$1(this.options.orientation) !== 'object') {
	          this.options.orientation = {
	            item: undefined,
	            axis: undefined
	          };
	        }

	        if ('orientation' in options) {
	          if (typeof options.orientation === 'string') {
	            this.options.orientation = {
	              item: options.orientation,
	              axis: options.orientation
	            };
	          } else if (_typeof$1(options.orientation) === 'object') {
	            if ('item' in options.orientation) {
	              this.options.orientation.item = options.orientation.item;
	            }

	            if ('axis' in options.orientation) {
	              this.options.orientation.axis = options.orientation.axis;
	            }
	          }
	        }

	        if (this.options.orientation.axis === 'both') {
	          if (!this.timeAxis2) {
	            var timeAxis2 = this.timeAxis2 = new TimeAxis(this.body);

	            timeAxis2.setOptions = function (options) {
	              var _options = options ? availableUtils.extend({}, options) : {};

	              _options.orientation = 'top'; // override the orientation option, always top

	              TimeAxis.prototype.setOptions.call(timeAxis2, _options);
	            };

	            this.components.push(timeAxis2);
	          }
	        } else {
	          if (this.timeAxis2) {
	            var _context5;

	            var index = _indexOfInstanceProperty(_context5 = this.components).call(_context5, this.timeAxis2);

	            if (index !== -1) {
	              var _context6;

	              _spliceInstanceProperty(_context6 = this.components).call(_context6, index, 1);
	            }

	            this.timeAxis2.destroy();
	            this.timeAxis2 = null;
	          }
	        } // if the graph2d's drawPoints is a function delegate the callback to the onRender property


	        if (typeof options.drawPoints == 'function') {
	          options.drawPoints = {
	            onRender: options.drawPoints
	          };
	        }

	        if ('hiddenDates' in this.options) {
	          convertHiddenOptions(this.options.moment, this.body, this.options.hiddenDates);
	        }

	        if ('clickToUse' in options) {
	          if (options.clickToUse) {
	            if (!this.activator) {
	              this.activator = new Activator(this.dom.root);
	            }
	          } else {
	            if (this.activator) {
	              this.activator.destroy();
	              delete this.activator;
	            }
	          }
	        } // enable/disable autoResize


	        this._initAutoResize();
	      } // propagate options to all components


	      _forEachInstanceProperty(_context7 = this.components).call(_context7, function (component) {
	        return component.setOptions(options);
	      }); // enable/disable configure


	      if ('configure' in options) {
	        var _context8;

	        if (!this.configurator) {
	          this.configurator = this._createConfigurator();
	        }

	        this.configurator.setOptions(options.configure); // collect the settings of all components, and pass them to the configuration system

	        var appliedOptions = availableUtils.deepExtend({}, this.options);

	        _forEachInstanceProperty(_context8 = this.components).call(_context8, function (component) {
	          availableUtils.deepExtend(appliedOptions, component.options);
	        });

	        this.configurator.setModuleOptions({
	          global: appliedOptions
	        });
	      }

	      this._redraw();
	    }
	    /**
	     * Returns true when the Timeline is active.
	     * @returns {boolean}
	     */

	  }, {
	    key: "isActive",
	    value: function isActive() {
	      return !this.activator || this.activator.active;
	    }
	    /**
	     * Destroy the Core, clean up all DOM elements and event listeners.
	     */

	  }, {
	    key: "destroy",
	    value: function destroy() {
	      var _context9;

	      // unbind datasets
	      this.setItems(null);
	      this.setGroups(null); // remove all event listeners

	      this.off(); // stop checking for changed size

	      this._stopAutoResize(); // remove from DOM


	      if (this.dom.root.parentNode) {
	        this.dom.root.parentNode.removeChild(this.dom.root);
	      }

	      this.dom = null; // remove Activator

	      if (this.activator) {
	        this.activator.destroy();
	        delete this.activator;
	      } // cleanup hammer touch events


	      for (var event in this.timelineListeners) {
	        if (this.timelineListeners.hasOwnProperty(event)) {
	          delete this.timelineListeners[event];
	        }
	      }

	      this.timelineListeners = null;
	      this.hammer && this.hammer.destroy();
	      this.hammer = null; // give all components the opportunity to cleanup

	      _forEachInstanceProperty(_context9 = this.components).call(_context9, function (component) {
	        return component.destroy();
	      });

	      this.body = null;
	    }
	    /**
	     * Set a custom time bar
	     * @param {Date} time
	     * @param {number} [id=undefined] Optional id of the custom time bar to be adjusted.
	     */

	  }, {
	    key: "setCustomTime",
	    value: function setCustomTime(time, id) {
	      var _context10;

	      var customTimes = _filterInstanceProperty(_context10 = this.customTimes).call(_context10, function (component) {
	        return id === component.options.id;
	      });

	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }

	      if (customTimes.length > 0) {
	        customTimes[0].setCustomTime(time);
	      }
	    }
	    /**
	     * Retrieve the current custom time.
	     * @param {number} [id=undefined]    Id of the custom time bar.
	     * @return {Date | undefined} customTime
	     */

	  }, {
	    key: "getCustomTime",
	    value: function getCustomTime(id) {
	      var _context11;

	      var customTimes = _filterInstanceProperty(_context11 = this.customTimes).call(_context11, function (component) {
	        return component.options.id === id;
	      });

	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }

	      return customTimes[0].getCustomTime();
	    }
	    /**
	     * Set a custom marker for the custom time bar.
	     * @param {string} [title] Title of the custom marker.
	     * @param {number} [id=undefined] Id of the custom marker.
	     * @param {boolean} [editable=false] Make the custom marker editable.
	     */

	  }, {
	    key: "setCustomTimeMarker",
	    value: function setCustomTimeMarker(title, id, editable) {
	      var _context12;

	      var customTimes = _filterInstanceProperty(_context12 = this.customTimes).call(_context12, function (component) {
	        return component.options.id === id;
	      });

	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }

	      if (customTimes.length > 0) {
	        customTimes[0].setCustomMarker(title, editable);
	      }
	    }
	    /**
	     * Set a custom title for the custom time bar.
	     * @param {string} [title] Custom title
	     * @param {number} [id=undefined]    Id of the custom time bar.
	     * @returns {*}
	     */

	  }, {
	    key: "setCustomTimeTitle",
	    value: function setCustomTimeTitle(title, id) {
	      var _context13;

	      var customTimes = _filterInstanceProperty(_context13 = this.customTimes).call(_context13, function (component) {
	        return component.options.id === id;
	      });

	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }

	      if (customTimes.length > 0) {
	        return customTimes[0].setCustomTitle(title);
	      }
	    }
	    /**
	     * Retrieve meta information from an event.
	     * Should be overridden by classes extending Core
	     * @param {Event} event
	     * @return {Object} An object with related information.
	     */

	  }, {
	    key: "getEventProperties",
	    value: function getEventProperties(event) {
	      return {
	        event: event
	      };
	    }
	    /**
	     * Add custom vertical bar
	     * @param {Date | string | number} [time]  A Date, unix timestamp, or
	     *                                         ISO date string. Time point where
	     *                                         the new bar should be placed.
	     *                                         If not provided, `new Date()` will
	     *                                         be used.
	     * @param {number | string} [id=undefined] Id of the new bar. Optional
	     * @return {number | string}               Returns the id of the new bar
	     */

	  }, {
	    key: "addCustomTime",
	    value: function addCustomTime(time, id) {
	      var _context14;

	      var timestamp = time !== undefined ? availableUtils.convert(time, 'Date') : new Date();

	      var exists = _someInstanceProperty(_context14 = this.customTimes).call(_context14, function (customTime) {
	        return customTime.options.id === id;
	      });

	      if (exists) {
	        throw new Error("A custom time with id ".concat(_JSON$stringify(id), " already exists"));
	      }

	      var customTime = new CustomTime(this.body, availableUtils.extend({}, this.options, {
	        time: timestamp,
	        id: id,
	        snap: this.itemSet ? this.itemSet.options.snap : this.options.snap
	      }));
	      this.customTimes.push(customTime);
	      this.components.push(customTime);

	      this._redraw();

	      return id;
	    }
	    /**
	     * Remove previously added custom bar
	     * @param {int} id ID of the custom bar to be removed
	     * [at]returns {boolean} True if the bar exists and is removed, false otherwise
	     */

	  }, {
	    key: "removeCustomTime",
	    value: function removeCustomTime(id) {
	      var _context15,
	          _this2 = this;

	      var customTimes = _filterInstanceProperty(_context15 = this.customTimes).call(_context15, function (bar) {
	        return bar.options.id === id;
	      });

	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }

	      _forEachInstanceProperty(customTimes).call(customTimes, function (customTime) {
	        var _context16, _context17, _context18, _context19;

	        _spliceInstanceProperty(_context16 = _this2.customTimes).call(_context16, _indexOfInstanceProperty(_context17 = _this2.customTimes).call(_context17, customTime), 1);

	        _spliceInstanceProperty(_context18 = _this2.components).call(_context18, _indexOfInstanceProperty(_context19 = _this2.components).call(_context19, customTime), 1);

	        customTime.destroy();
	      });
	    }
	    /**
	     * Get the id's of the currently visible items.
	     * @returns {Array} The ids of the visible items
	     */

	  }, {
	    key: "getVisibleItems",
	    value: function getVisibleItems() {
	      return this.itemSet && this.itemSet.getVisibleItems() || [];
	    }
	    /**
	     * Get the id's of the items at specific time, where a click takes place on the timeline.
	     * @returns {Array} The ids of all items in existence at the time of event.
	     */

	  }, {
	    key: "getItemsAtCurrentTime",
	    value: function getItemsAtCurrentTime(timeOfEvent) {
	      this.time = timeOfEvent;
	      return this.itemSet && this.itemSet.getItemsAtCurrentTime(this.time) || [];
	    }
	    /**
	     * Get the id's of the currently visible groups.
	     * @returns {Array} The ids of the visible groups
	     */

	  }, {
	    key: "getVisibleGroups",
	    value: function getVisibleGroups() {
	      return this.itemSet && this.itemSet.getVisibleGroups() || [];
	    }
	    /**
	     * Set Core window such that it fits all items
	     * @param {Object} [options]  Available options:
	     *                                `animation: boolean | {duration: number, easingFunction: string}`
	     *                                    If true (default), the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     * @param {function} [callback] a callback funtion to be executed at the end of this function
	     */

	  }, {
	    key: "fit",
	    value: function fit(options, callback) {
	      var range = this.getDataRange(); // skip range set if there is no min and max date

	      if (range.min === null && range.max === null) {
	        return;
	      } // apply a margin of 1% left and right of the data


	      var interval = range.max - range.min;
	      var min = new Date(range.min.valueOf() - interval * 0.01);
	      var max = new Date(range.max.valueOf() + interval * 0.01);
	      var animation = options && options.animation !== undefined ? options.animation : true;
	      this.range.setRange(min, max, {
	        animation: animation
	      }, callback);
	    }
	    /**
	     * Calculate the data range of the items start and end dates
	     * [at]returns {{min: [Date], max: [Date]}}
	     * @protected
	     */

	  }, {
	    key: "getDataRange",
	    value: function getDataRange() {
	      // must be implemented by Timeline and Graph2d
	      throw new Error('Cannot invoke abstract method getDataRange');
	    }
	    /**
	     * Set the visible window. Both parameters are optional, you can change only
	     * start or only end. Syntax:
	     *
	     *     TimeLine.setWindow(start, end)
	     *     TimeLine.setWindow(start, end, options)
	     *     TimeLine.setWindow(range)
	     *
	     * Where start and end can be a Date, number, or string, and range is an
	     * object with properties start and end.
	     *
	     * @param {Date | number | string | Object} [start] Start date of visible window
	     * @param {Date | number | string} [end]            End date of visible window
	     * @param {Object} [options]  Available options:
	     *                                `animation: boolean | {duration: number, easingFunction: string}`
	     *                                    If true (default), the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     * @param {function} [callback] a callback funtion to be executed at the end of this function
	     */

	  }, {
	    key: "setWindow",
	    value: function setWindow(start, end, options, callback) {
	      if (typeof arguments[2] == "function") {
	        callback = arguments[2];
	        options = {};
	      }

	      var animation;
	      var range;

	      if (arguments.length == 1) {
	        range = arguments[0];
	        animation = range.animation !== undefined ? range.animation : true;
	        this.range.setRange(range.start, range.end, {
	          animation: animation
	        });
	      } else if (arguments.length == 2 && typeof arguments[1] == "function") {
	        range = arguments[0];
	        callback = arguments[1];
	        animation = range.animation !== undefined ? range.animation : true;
	        this.range.setRange(range.start, range.end, {
	          animation: animation
	        }, callback);
	      } else {
	        animation = options && options.animation !== undefined ? options.animation : true;
	        this.range.setRange(start, end, {
	          animation: animation
	        }, callback);
	      }
	    }
	    /**
	     * Move the window such that given time is centered on screen.
	     * @param {Date | number | string} time
	     * @param {Object} [options]  Available options:
	     *      