.. image:: https://img.shields.io/badge/licence-AGPL--3-blue.svg
   :target: https://www.gnu.org/licenses/agpl
   :alt: License: AGPL-3

==================
Client side paging
==================

This addon allows a developer to return the following action types::

{'type': 'ir.actions.act_window.page.next'}

or::

{'type': 'ir.actions.act_window.page.prev'}

which trigger the form's controller to page into the requested direction on the
client side.

A use case could be the case of a validation flow. As a developer, you set up a tree view with a domain on records to be validated. The user opens the first record in a form view and validates the record. The validation method returns the 'next' action type so that the browser window of the user is presented with the next record in the form view.

Usage
=====

See the 'Previous Partner' and 'Next Partner' buttons that this module's demo data adds to the partner form view.

.. image:: https://odoo-community.org/website/image/ir.attachment/5784_f2813bd/datas
   :alt: Try me on Runbot
   :target: https://runbot.odoo-community.org/runbot/162/10.0

Bug Tracker
===========

Bugs are tracked on `GitHub Issues
<https://github.com/OCA/web/issues>`_. In case of trouble, please
check there if your issue has already been reported. If you spotted it first,
help us smash it by providing detailed and welcomed feedback.

Credits
=======

Images
------

* Odoo Community Association: `Icon <https://github.com/OCA/maintainer-tools/blob/master/template/module/static/description/icon.svg>`_.

Contributors
------------

* Holger Brunn <hbrunn@therp.nl>
* Stefan Rijnhart <stefan@opener.amsterdam>

Do not contact contributors directly about support or help with technical issues.

Maintainer
----------

.. image:: https://odoo-community.org/logo.png
   :alt: Odoo Community Association
   :target: https://odoo-community.org

This module is maintained by the OCA.

OCA, or the Odoo Community Association, is a nonprofit organization whose
mission is to support the collaborative development of Odoo features and
promote its widespread use.

To contribute to this module, please visit https://odoo-community.org.
