# Copyright 2021 ForgeFlow S.L. (https://www.forgeflow.com)
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from odoo import fields, models


class IrFilters(models.Model):
    _inherit = "ir.filters"
    _order = "model_id, sequence, name, id desc"

    def _selection_type(self):
        return [
            ("favorite", "Favorite"),
            ("filter", "Standard Filter"),
            ("groupby", "Standard Group By"),
        ]

    sequence = fields.Integer()
    type = fields.Selection(
        selection="_selection_type", string="Type", required=True, default="favorite",
    )
    groupby_field = fields.Many2one(
        comodel_name="ir.model.fields", string="Group By Field", ondelete="cascade",
    )
    group_id = fields.Many2one(comodel_name="ir.filters.group", string="Filter Group")
