from odoo import fields, models


class AvalaraSalestax(models.Model):
    _inherit = "avalara.salestax"

    use_partner_invoice_id = fields.Boolean(
        "Use Invoice partner's customer code in SO",
        default=True,
        help="Use Sales Order's Invoice Address field to determine Taxable" "Status",
    )
    repair_calculate_tax = fields.Boolean(
        "Auto Calculate Tax on Repair Save",
        help="Automatically triggers API to calculate tax If changes made on"
        "SO's warehouse_id, tax_on_shipping_address, "
        "SO line's price_unit, discount, product_uom_qty",
    )
    override_line_taxes = fields.Boolean(
        help="When checked, the Avatax computed tax will replace any other taxes"
        " that may exist in the document line.",
    )
