# CSV writer from python doc
import codecs
import csv
from io import StringIO


class UnicodeWriter(object):

    """
    A CSV writer which will write rows to CSV file "f",
    which is encoded in the given encoding.
    """

    def __init__(self, f, dialect=csv.excel, encoding="utf-8", **kwds):
        # Redirect output to a queue
        self.queue = StringIO()
        self.writer = csv.writer(self.queue, dialect=dialect, **kwds)
        self.stream = f
        self.encoder = codecs.getincrementalencoder(encoding)()

    def writerow(self, row):
        # we ensure that we do not try to encode None or bool
        row = [x or "" for x in row]
        self.writer.writerow(row)
        # Fetch output from the queue ...
        data = self.queue.getvalue()
        # write to the target stream
        self.stream.write(data)
        # empty queue
        self.queue.truncate(0)
        # Reset the cursor back
        self.queue.seek(0)

    def writerows(self, rows):
        for row in rows:
            self.writerow(row)
