from collections import OrderedDict

grammar = OrderedDict(
    {
        "Telheader_Quelle": {
            "type": "str",
            "length": 10,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_source",
        },
        "Telheader_Ziel": {
            "type": "str",
            "length": 10,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_destination",
        },
        "Telheader_TelSeq": {
            "type": "int",
            "length": 6,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_sequence_number",
        },
        "Telheader_AnlZeit": {
            "type": "datetime",
            "length": 14,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_current_datetime",
        },
        "Satzart": {
            "type": "str",
            "length": 9,
            "dp": False,
            "ubl_path": False,
            "df_val": "KRETP0046",
            "df_func": False,
        },
        "RxKretp_KretId_Mand": {
            "type": "str",
            "length": 3,
            "dp": False,
            "ubl_path": False,
            "df_val": "000",
            "df_func": False,
        },
        "RxKretp_KretId_KretNr": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": "DespatchAdvice.cbc:ID",
            "df_val": False,
            "df_func": False,
        },
        "RxKretp_KretId_HostKretKz": {
            "type": "str",
            "length": 5,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_source",
        },
        "RxKretp_ExtRef": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:OrderReference.cbc:ID",
            "df_val": False,
            "df_func": False,
        },
        "RxKretp_HostPosNr": {
            "type": "int",
            "length": 6,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchLine.%s.cbc:ID",
            "df_val": False,
            "df_func": "get_sequence_number",
        },
        "RxKretp_MId_AId_Mand": {
            "type": "str",
            "length": 3,
            "dp": False,
            "ubl_path": False,
            "df_val": "000",
            "df_func": False,
        },
        "RxKretp_MId_AId_ArtNr": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchLine.%s.cac:Item."
            "cac:BuyersItemIdentification.cbc:ID",
            "df_val": False,
            "df_func": False,
        },
        "RxKretp_MId_AId_Var": {
            "type": "str",
            "length": 5,
            "dp": False,
            "ubl_path": False,
            "df_val": "00000",
            "df_func": False,
        },
        "Matqgs_Matqg1": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": False,
            "df_val": "DISPONIBLE",
            "df_func": False,
        },
        "Matqgs_Matqg2": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "Matqgs_Matqg3": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "SollMng": {
            "type": "float",
            "length": 12,
            "dp": 3,
            "ubl_path": "DespatchAdvice.cac:DespatchLine.%s."
            "cbc:DeliveredQuantity.#text",
            "df_val": False,
            "df_func": False,
        },
        "HostEinheit": {
            "type": "str",
            "length": 5,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchLine.%s."
            "cbc:DeliveredQuantity.@unitCode",
            "df_val": False,
            "df_func": False,
        },
        "RxKretp_MId_Charge": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "RxKretp_MId_MHD": {
            "type": "date",
            "length": 8,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "RxKretp_SatzKzKretp": {
            "type": "str",
            "length": 1,
            "dp": False,
            "ubl_path": False,
            "df_val": "N",
            "df_func": False,
        },
        "RxKretp_MId_SerienNrGrp": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "RxKretp_MId_WeNr": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
    }
)
