from collections import OrderedDict

grammar = OrderedDict(
    {
        "Telheader_Quelle": {
            "type": "str",
            "length": 10,
            "dp": False,
            "dict_key": False,
            "df_val": False,
            "df_func": "get_source_q",
        },
        "Telheader_Ziel": {
            "type": "str",
            "length": 10,
            "dp": False,
            "dict_key": False,
            "df_val": False,
            "df_func": "get_destination_q",
        },
        "Telheader_TelSeq": {
            "type": "int",
            "length": 6,
            "dp": False,
            "dict_key": False,
            "df_val": False,
            "df_func": "get_sequence_number",
        },
        "Telheader_AnlZeit": {
            "type": "datetime",
            "length": 14,
            "dp": False,
            "dict_key": False,
            "df_val": False,
            "df_func": "get_current_datetime",
        },
        "Satzart": {
            "type": "str",
            "length": 9,
            "dp": False,
            "dict_key": False,
            "df_val": "KRETPQ050",
            "df_func": False,
        },
        "IvKretp_KretId_Mand": {
            "type": "str",
            "length": 3,
            "dp": False,
            "dict_key": "RxKretp_KretId_Mand",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_KretId_KretNr": {
            "type": "str",
            "length": 20,
            "dp": False,
            "dict_key": "RxKretp_KretId_KretNr",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_KretId_HostKretKz": {
            "type": "str",
            "length": 5,
            "dp": False,
            "dict_key": "RxKretp_KretId_HostKretKz",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_ExtRef": {
            "type": "str",
            "length": 20,
            "dp": False,
            "dict_key": "RxKretp_ExtRef",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_HostPosNr": {
            "type": "int",
            "length": 6,
            "dp": False,
            "dict_key": "RxKretp_HostPosNr",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_MId_AId_Mand": {
            "type": "str",
            "length": 3,
            "dp": False,
            "dict_key": "RxKretp_MId_AId_Mand",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_MId_AId_ArtNr": {
            "type": "str",
            "length": 20,
            "dp": False,
            "dict_key": "RxKretp_MId_AId_ArtNr",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_MId_AId_Var": {
            "type": "str",
            "length": 5,
            "dp": False,
            "dict_key": "RxKretp_MId_AId_Var",
            "df_val": False,
            "df_func": False,
        },
        "IvMatqk_HMATQ_HMatQ": {
            "type": "str",
            "length": 20,
            "dp": False,
            "dict_key": "Matqgs_Matqg1",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_AnmMngs_Mng": {
            "type": "float",
            "length": 12,
            "dp": 3,
            "dict_key": False,
            "df_val": False,
            "df_func": "get_quantity_done",
        },
        "IvKretp_AnmMngs_Gew": {
            "type": "float",
            "length": 12,
            "dp": 3,
            "dict_key": False,
            "df_val": False,
            "df_func": False,
        },
        "IvArt_HOSTUNITS_HostEinh": {
            "type": "str",
            "length": 5,
            "dp": False,
            "dict_key": False,
            "df_val": False,
            "df_func": False,
        },
        "IvArt_Bestand_Einheit": {
            "type": "str",
            "length": 5,
            "dp": False,
            "dict_key": "HostEinheit",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_MId_Charge": {
            "type": "str",
            "length": 20,
            "dp": False,
            "dict_key": "RxKretp_MId_Charge",
            "df_val": False,
            "df_func": False,
        },
        "IvKretp_MId_MHD": {
            "type": "date",
            "length": 8,
            "dp": False,
            "dict_key": "RxKretp_MId_MHD",
            "df_val": "19700101",
            "df_func": False,
        },
        "IvKretp_MId_WeNr": {
            "type": "str",
            "length": 20,
            "dp": False,
            "dict_key": "RxKretp_MId_WeNr",
            "df_val": False,
            "df_func": False,
        },
    }
)
