# Copyright 2019 ACSONE SA/NV
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import fields, models


class ContractTag(models.Model):

    _name = 'contract.tag'
    _description = 'Contract Tag'

    name = fields.Char(requirment=True)
    company_id = fields.Many2one(
        'res.company',
        string='Company',
        default=lambda self: self.env.user.company_id,
    )
    color = fields.Integer("Color Index", default=0)
