Demand Driven Material Requirements Planning is a formal multi-echelon
planning and execution method developed by Ms. Carol Ptak and Mr. Chad
Smith.

DDMRP combines blended aspects of Material Requirements Planning (MRP),
Distribution Requirements Planning (DRP) with the pull and visibility
emphases found in Lean and the Theory of Constraints and the variability
reduction emphasis of Six Sigma.

This method has five sequential components:

1.  *Strategic Inventory Positioning*. Answers the question "Given our
    system and environment, where should we place inventory to have the
    best protection?" and determines where should decoupling points of
    inventory be placed.
2.  *Buffer Profiles and Levels*. Determine the amount of protection at
    those decoupling points.
3.  *Dynamic Adjustments*. Allow the company to adapt buffers to group
    and individual part trait changes over time through the use of
    several types of adjustments.
4.  *Demand Driven Planning*. Allow to launch purchase orders (POs),
    manufacturing orders (MOs) and Transfer Orders (TOs) based on the
    priority dictated by the buffers.
5.  *Visible and Collaborative Execution*. These POs, MOs and TOs have
    to be effectively managed to synchronize with the changes that often
    occur within the "execution horizon."

These five components work together to greatly dampen, if not eliminate,
the nervousness of traditional MRP systems and the bullwhip effect in
complex and challenging environments.

This approach provides real information about those parts that are truly
at risk of negatively impacting the planned availability of inventory.

DDMRP sorts the significant few items that require attention from the
many parts that are being managed. Under the DDMRP approach, fewer
planners can make better decisions more quickly. That means companies
will be better able to leverage their working and human capital.

Demand Driven Material Requirements Planning is quickly being adopted by
a wide variety of leading companies across the world.

Some of the benefits reported by the DDMRP method include:

- High fill rate performance
- Lead time reductions
- Inventory reductions, while improving customer service
- Eliminate costs related to expedite
- Planners see priorities instead of constantly fighting the conflicting
  messages of MRP

It is highly recommended to read the book 'Demand Driven Material
Requirements Planning (DDMRP)' by Carol Ptak and Chad Smith.
