# -*- coding: utf-8 -*-
# Copyright 2015 Pedro M. Baeza <pedro.baeza@tecnativa.com>
# Copyright 2015 Antonio Espinosa <antonio.espinosa@tecnativa.com>
# Copyright 2015 Javier Iniesta <javieria@antiun.com>
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from . import base
from odoo.exceptions import ValidationError


class ResPartnerCase(base.BaseCase):

    def test_count_mass_mailing_contacts(self):
        self.create_mailing_contact({'email': 'partner@test.com',
                                     'list_id': self.mailing_list.id})
        self.create_mailing_contact({'email': 'partner@test.com',
                                     'list_id': self.mailing_list2.id})
        self.assertEqual(self.partner.mass_mailing_contacts_count, 2)

    def test_write_res_partner(self):
        user = self.env['res.users'].create({
            'login': 'test',
            'name': 'test',
            'email': 'test@example.org',
            'groups_id': [
                (4, self.env.ref('base.group_user').id),
                (4, self.env.ref('base.group_partner_manager').id),
            ]
        })
        contact = self.create_mailing_contact(
            {'email': 'partner@test.com', 'list_id': self.mailing_list.id})
        self.partner.sudo(user).write({
            'name': 'Changed',
            'email': 'partner@changed.com',
        })
        self.assertEqual(contact.name, self.partner.name)
        self.assertEqual(contact.email, self.partner.email)
        with self.assertRaises(ValidationError):
            self.partner.write({'email': False})
