# -*- coding: utf-8 -*-
##############################################################################
#
#    Odoo, Open Source Management Solution
#    Copyright (C) 2020-Today Entrivis Tech PVT. LTD. (<http://www.entrivistech.com>)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>
#
##############################################################################
from odoo import models, fields, api, _


class MailComposer(models.TransientModel):
    _inherit = 'mail.compose.message'

    email_bcc = fields.Char('Bcc')

    def _onchange_template_id(self, template_id, composition_mode, model, res_id):
        res = super(MailComposer, self).onchange_template_id(template_id, composition_mode, model, res_id)
        if self.template_id:
            self.email_bcc = self.template_id.email_bcc
        return res

    def get_mail_values(self, res_ids):
        res = super(MailComposer, self).get_mail_values(res_ids)
        for res_id in res_ids:
            if res.get(res_id):
                res[res_id]['email_bcc'] = self.template_id.email_bcc
        return res

    def action_send_mail(self):
        for wizard in self:
            super(MailComposer, wizard.with_context(with_bcc=wizard.email_bcc and True or False, with_email_bcc=wizard.email_bcc)).action_send_mail()
