# -*- coding: utf-8 -*-
# Copyright 2016 Sunflower IT <http://sunflowerweb.nl>
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from openerp import models, fields, api, _
from openerp.exceptions import ValidationError


class AnalyticLine(models.Model):
    """Restrict edit and delete on analytic lines generated by holidays"""
    _inherit = 'account.analytic.line'

    _timesheet_ids = fields.One2many('hr.analytic.timesheet', 'line_id')

    @api.constrains('account_id', 'unit_amount', 'amount')
    def _protect_leave_write(self):
        if not self.env.context.get('force_write', False):
            for line in self:
                if line.account_id.is_leave_account \
                        and line._timesheet_ids.leave_id:
                    raise ValidationError(_("""This line is protected against
                            editing because it was created automatically by
                            a leave request. Please edit the leave request
                            instead."""))
