#    Authors: Leonardo Pistone, Yannick Vaucher
#    Copyright 2014-2015 Camptocamp SA
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
from openerp.tests.common import TransactionCase


class TestCheckSourcing(TransactionCase):
    """Check the _check_sourcing method of the source.

    The button to check all sources of a line is checked in TestButtonSourced.

    """
    def test_warehouse_dispatch_is_always_sourced(self):
        self.source.sourcing_method = 'wh_dispatch'
        self.assertEquals([], self.source._check_sourcing())

    def test_procurement_sourcing_without_pr_is_not_sourced(self):
        self.source.sourcing_method = 'procurement'
        errors = self.source._check_sourcing()
        self.assertEquals(1, len(errors))
        self.assertIn('Missing Purchase Requisition', errors[0])

    def test_procurement_sourcing_with_draft_pr_is_not_sourced(self):
        self.source.sourcing_method = 'procurement'
        self.source.po_requisition_id = self.PurcReq.new({'state': 'draft'})
        errors = self.source._check_sourcing()
        self.assertEquals(1, len(errors))
        self.assertIn('Purchase Requisition state should', errors[0])

    def test_reuse_bid_sourcing_without_purchase_line_is_not_sourced(self):
        self.source.sourcing_method = 'reuse_bid'
        errors = self.source._check_sourcing()
        self.assertEquals(1, len(errors))
        self.assertIn('No bid line selected', errors[0])

    def test_procurement_sourcing_with_closed_pr_is_sourced(self):
        self.source.sourcing_method = 'procurement'
        self.source.po_requisition_id = self.PurcReq.new({'state': 'closed'})
        self.assertEquals([], self.source._check_sourcing())

    def test_procurement_sourcing_with_done_pr_is_sourced(self):
        self.source.sourcing_method = 'procurement'
        self.source.po_requisition_id = self.PurcReq.new({'state': 'done'})

    def test_reuse_bid_sourcing_with_purchase_line_is_sourced(self):
        self.source.sourcing_method = 'reuse_bid'
        po_line = self.env['purchase.order.line'].new()
        self.source.selected_bid_line_id = po_line
        self.assertEquals([], self.source._check_sourcing())

    def test_other_sourcing_without_pr_is_sourced(self):
        self.source.sourcing_method = 'other'
        self.assertEquals([], self.source._check_sourcing())

    def setUp(self):
        """Setup a source.

        I use Model.new to get a model instance that is not saved to the
        database, but has working methods.

        """
        super(TestCheckSourcing, self).setUp()
        Source = self.env['logistic.requisition.source']
        self.PurcReq = self.env['purchase.requisition']
        self.source = Source.new({'proposed_qty': 1, 'unit_cost': 1})
