# Copyright 2019 Rubén Bravo <rubenred18@gmail.com>
# Copyright 2020 Tecnativa - Pedro M. Baeza
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html)

from odoo import models


class StockRule(models.Model):
    _inherit = "stock.rule"

    def _prepare_mo_vals(
        self,
        product_id,
        product_qty,
        product_uom,
        location_id,
        name,
        origin,
        company_id,
        values,
        bom,
    ):
        res = super()._prepare_mo_vals(
            product_id,
            product_qty,
            product_uom,
            location_id,
            name,
            origin,
            company_id,
            values,
            bom,
        )
        res["source_procurement_group_id"] = (
            values.get("group_id").id if values.get("group_id", False) else False
        )
        moves = values.get("move_dest_ids")
        if moves:
            line_ids = moves.sale_line_id
            while moves.move_dest_ids:
                moves = moves.move_dest_ids
                line_ids |= moves.sale_line_id
            res["sale_line_ids"] = line_ids and [(4, x.id) for x in line_ids] or False
        return res
